/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Locale;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyEvent;

public abstract class KeyCombination {
    public static final Modifier SHIFT_DOWN = new Modifier(KeyCode.SHIFT, ModifierValue.DOWN);
    public static final Modifier SHIFT_ANY = new Modifier(KeyCode.SHIFT, ModifierValue.ANY);
    public static final Modifier CONTROL_DOWN = new Modifier(KeyCode.CONTROL, ModifierValue.DOWN);
    public static final Modifier CONTROL_ANY = new Modifier(KeyCode.CONTROL, ModifierValue.ANY);
    public static final Modifier ALT_DOWN = new Modifier(KeyCode.ALT, ModifierValue.DOWN);
    public static final Modifier ALT_ANY = new Modifier(KeyCode.ALT, ModifierValue.ANY);
    public static final Modifier META_DOWN = new Modifier(KeyCode.META, ModifierValue.DOWN);
    public static final Modifier META_ANY = new Modifier(KeyCode.META, ModifierValue.ANY);
    public static final Modifier SHORTCUT_DOWN = new Modifier(KeyCode.SHORTCUT, ModifierValue.DOWN);
    public static final Modifier SHORTCUT_ANY = new Modifier(KeyCode.SHORTCUT, ModifierValue.ANY);
    private static final Modifier[] POSSIBLE_MODIFIERS = new Modifier[]{SHIFT_DOWN, SHIFT_ANY, CONTROL_DOWN, CONTROL_ANY, ALT_DOWN, ALT_ANY, META_DOWN, META_ANY, SHORTCUT_DOWN, SHORTCUT_ANY};
    public static final KeyCombination NO_MATCH = new KeyCombination(new Modifier[0]){

        @Override
        public boolean match(KeyEvent e) {
            return false;
        }
    };
    private final ModifierValue shift;
    private final ModifierValue control;
    private final ModifierValue alt;
    private final ModifierValue meta;
    private final ModifierValue shortcut;

    public final ModifierValue getShift() {
        return this.shift;
    }

    public final ModifierValue getControl() {
        return this.control;
    }

    public final ModifierValue getAlt() {
        return this.alt;
    }

    public final ModifierValue getMeta() {
        return this.meta;
    }

    public final ModifierValue getShortcut() {
        return this.shortcut;
    }

    protected KeyCombination(ModifierValue shift, ModifierValue control, ModifierValue alt, ModifierValue meta, ModifierValue shortcut) {
        if (shift == null || control == null || alt == null || meta == null || shortcut == null) {
            throw new NullPointerException("Modifier value must not be null!");
        }
        this.shift = shift;
        this.control = control;
        this.alt = alt;
        this.meta = meta;
        this.shortcut = shortcut;
    }

    protected KeyCombination(Modifier ... modifiers) {
        this(KeyCombination.getModifierValue(modifiers, KeyCode.SHIFT), KeyCombination.getModifierValue(modifiers, KeyCode.CONTROL), KeyCombination.getModifierValue(modifiers, KeyCode.ALT), KeyCombination.getModifierValue(modifiers, KeyCode.META), KeyCombination.getModifierValue(modifiers, KeyCode.SHORTCUT));
    }

    public boolean match(KeyEvent event) {
        KeyCode shortcutKey = Toolkit.getToolkit().getPlatformShortcutKey();
        return KeyCombination.test(KeyCode.SHIFT, this.shift, shortcutKey, this.shortcut, event.isShiftDown()) && KeyCombination.test(KeyCode.CONTROL, this.control, shortcutKey, this.shortcut, event.isControlDown()) && KeyCombination.test(KeyCode.ALT, this.alt, shortcutKey, this.shortcut, event.isAltDown()) && KeyCombination.test(KeyCode.META, this.meta, shortcutKey, this.shortcut, event.isMetaDown());
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        this.addModifiersIntoString(sb);
        return sb.toString();
    }

    public String getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (PlatformUtil.isMac()) {
            if (this.getControl() == ModifierValue.DOWN) {
                stringBuilder.append("\u2303");
            }
            if (this.getAlt() == ModifierValue.DOWN) {
                stringBuilder.append("\u2325");
            }
            if (this.getShift() == ModifierValue.DOWN) {
                stringBuilder.append("\u21e7");
            }
            if (this.getMeta() == ModifierValue.DOWN || this.getShortcut() == ModifierValue.DOWN) {
                stringBuilder.append("\u2318");
            }
        } else {
            if (this.getControl() == ModifierValue.DOWN || this.getShortcut() == ModifierValue.DOWN) {
                stringBuilder.append("Ctrl+");
            }
            if (this.getAlt() == ModifierValue.DOWN) {
                stringBuilder.append("Alt+");
            }
            if (this.getShift() == ModifierValue.DOWN) {
                stringBuilder.append("Shift+");
            }
            if (this.getMeta() == ModifierValue.DOWN) {
                stringBuilder.append("Meta+");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyCombination)) {
            return false;
        }
        KeyCombination other = (KeyCombination)obj;
        return this.shift == other.shift && this.control == other.control && this.alt == other.alt && this.meta == other.meta && this.shortcut == other.shortcut;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + this.shift.hashCode();
        hash = 23 * hash + this.control.hashCode();
        hash = 23 * hash + this.alt.hashCode();
        hash = 23 * hash + this.meta.hashCode();
        hash = 23 * hash + this.shortcut.hashCode();
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    public static KeyCombination valueOf(String value) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>(4);
        String[] tokens = KeyCombination.splitName(value);
        KeyCode keyCode = null;
        String keyCharacter = null;
        for (String token : tokens) {
            if (token.length() > 2 && token.charAt(0) == '\'' && token.charAt(token.length() - 1) == '\'') {
                if (keyCode != null || keyCharacter != null) {
                    throw new IllegalArgumentException("Cannot parse key binding " + value);
                }
                keyCharacter = token.substring(1, token.length() - 1).replace("\\'", "'");
                continue;
            }
            String normalizedToken = KeyCombination.normalizeToken(token);
            Modifier modifier = KeyCombination.getModifier(normalizedToken);
            if (modifier != null) {
                modifiers.add(modifier);
                continue;
            }
            if (keyCode != null || keyCharacter != null) {
                throw new IllegalArgumentException("Cannot parse key binding " + value);
            }
            keyCode = KeyCode.getKeyCode(normalizedToken);
            if (keyCode != null) continue;
            keyCharacter = token;
        }
        if (keyCode == null && keyCharacter == null) {
            throw new IllegalArgumentException("Cannot parse key binding " + value);
        }
        Modifier[] modifierArray = modifiers.toArray(new Modifier[modifiers.size()]);
        return keyCode != null ? new KeyCodeCombination(keyCode, modifierArray) : new KeyCharacterCombination(keyCharacter, modifierArray);
    }

    public static KeyCombination keyCombination(String name) {
        return KeyCombination.valueOf(name);
    }

    private void addModifiersIntoString(StringBuilder sb) {
        KeyCombination.addModifierIntoString(sb, KeyCode.SHIFT, this.shift);
        KeyCombination.addModifierIntoString(sb, KeyCode.CONTROL, this.control);
        KeyCombination.addModifierIntoString(sb, KeyCode.ALT, this.alt);
        KeyCombination.addModifierIntoString(sb, KeyCode.META, this.meta);
        KeyCombination.addModifierIntoString(sb, KeyCode.SHORTCUT, this.shortcut);
    }

    private static void addModifierIntoString(StringBuilder sb, KeyCode modifierKey, ModifierValue modifierValue) {
        if (modifierValue == ModifierValue.UP) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("+");
        }
        if (modifierValue == ModifierValue.ANY) {
            sb.append("Ignore ");
        }
        sb.append(modifierKey.getName());
    }

    private static boolean test(KeyCode testedModifierKey, ModifierValue testedModifierValue, KeyCode shortcutModifierKey, ModifierValue shortcutModifierValue, boolean isKeyDown) {
        ModifierValue finalModifierValue = testedModifierKey == shortcutModifierKey ? KeyCombination.resolveModifierValue(testedModifierValue, shortcutModifierValue) : testedModifierValue;
        return KeyCombination.test(finalModifierValue, isKeyDown);
    }

    private static boolean test(ModifierValue modifierValue, boolean isDown) {
        switch (modifierValue) {
            case DOWN: {
                return isDown;
            }
            case UP: {
                return !isDown;
            }
        }
        return true;
    }

    private static ModifierValue resolveModifierValue(ModifierValue firstValue, ModifierValue secondValue) {
        if (firstValue == ModifierValue.DOWN || secondValue == ModifierValue.DOWN) {
            return ModifierValue.DOWN;
        }
        if (firstValue == ModifierValue.ANY || secondValue == ModifierValue.ANY) {
            return ModifierValue.ANY;
        }
        return ModifierValue.UP;
    }

    static Modifier getModifier(String name) {
        for (Modifier modifier : POSSIBLE_MODIFIERS) {
            if (!modifier.toString().equals(name)) continue;
            return modifier;
        }
        return null;
    }

    private static ModifierValue getModifierValue(Modifier[] modifiers, KeyCode modifierKey) {
        ModifierValue modifierValue = ModifierValue.UP;
        for (Modifier modifier : modifiers) {
            if (modifier == null) {
                throw new NullPointerException("Modifier must not be null!");
            }
            if (modifier.getKey() != modifierKey) continue;
            if (modifierValue != ModifierValue.UP) {
                throw new IllegalArgumentException(modifier.getValue() != modifierValue ? "Conflicting modifiers specified!" : "Duplicate modifiers specified!");
            }
            modifierValue = modifier.getValue();
        }
        return modifierValue;
    }

    private static String normalizeToken(String token) {
        String[] words = token.split("\\s+");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(word.substring(0, 1).toUpperCase(Locale.ROOT));
            sb.append(word.substring(1).toLowerCase(Locale.ROOT));
        }
        return sb.toString();
    }

    private static String[] splitName(String name) {
        ArrayList<String> tokens = new ArrayList<String>();
        char[] chars = name.trim().toCharArray();
        boolean STATE_BASIC = false;
        boolean STATE_WHITESPACE = true;
        int STATE_SEPARATOR = 2;
        int STATE_QUOTED = 3;
        int state = 0;
        int tokenStart = 0;
        int tokenEnd = -1;
        block24: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            tokenEnd = i;
                            state = 1;
                            continue block24;
                        }
                        case '+': {
                            tokenEnd = i;
                            state = 2;
                            continue block24;
                        }
                        case '\'': {
                            if (i != 0 && chars[i - 1] == '\\') continue block24;
                            state = 3;
                            continue block24;
                        }
                    }
                    continue block24;
                }
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block24;
                        }
                        case '+': {
                            state = 2;
                            continue block24;
                        }
                        case '\'': {
                            state = 3;
                            tokenEnd = -1;
                            continue block24;
                        }
                    }
                    state = 0;
                    tokenEnd = -1;
                    continue block24;
                }
                case 2: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block24;
                        }
                        case '+': {
                            throw new IllegalArgumentException("Cannot parse key binding " + name);
                        }
                    }
                    if (tokenEnd <= tokenStart) {
                        throw new IllegalArgumentException("Cannot parse key binding " + name);
                    }
                    tokens.add(new String(chars, tokenStart, tokenEnd - tokenStart));
                    tokenStart = i;
                    tokenEnd = -1;
                    state = c == '\'' ? 3 : 0;
                    continue block24;
                }
                case 3: {
                    if (c != '\'' || chars[i - 1] == '\\') continue block24;
                    state = 0;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: {
                tokens.add(new String(chars, tokenStart, chars.length - tokenStart));
                break;
            }
            case 2: 
            case 3: {
                throw new IllegalArgumentException("Cannot parse key binding " + name);
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static enum ModifierValue {
        DOWN,
        UP,
        ANY;

    }

    public static final class Modifier {
        private final KeyCode key;
        private final ModifierValue value;

        private Modifier(KeyCode key, ModifierValue value) {
            this.key = key;
            this.value = value;
        }

        public KeyCode getKey() {
            return this.key;
        }

        public ModifierValue getValue() {
            return this.value;
        }

        public String toString() {
            return (this.value == ModifierValue.ANY ? "Ignore " : "") + this.key.getName();
        }
    }
}

