/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class StrokeTransition
extends Transition {
    private Color start;
    private Color end;
    private ObjectProperty<Shape> shape;
    private static final Shape DEFAULT_SHAPE = null;
    private Shape cachedShape;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis(400.0);
    private ObjectProperty<Color> fromValue;
    private static final Color DEFAULT_FROM_VALUE = null;
    private ObjectProperty<Color> toValue;
    private static final Color DEFAULT_TO_VALUE = null;

    public final void setShape(Shape value) {
        if (this.shape != null || value != null) {
            this.shapeProperty().set(value);
        }
    }

    public final Shape getShape() {
        return this.shape == null ? DEFAULT_SHAPE : (Shape)this.shape.get();
    }

    public final ObjectProperty<Shape> shapeProperty() {
        if (this.shape == null) {
            this.shape = new SimpleObjectProperty<Shape>(this, "shape", DEFAULT_SHAPE);
        }
        return this.shape;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals(value)) {
            this.durationProperty().set(value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                @Override
                public void invalidated() {
                    try {
                        StrokeTransition.this.setCycleDuration(StrokeTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(StrokeTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                @Override
                public Object getBean() {
                    return StrokeTransition.this;
                }

                @Override
                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setFromValue(Color value) {
        if (this.fromValue != null || value != null) {
            this.fromValueProperty().set(value);
        }
    }

    public final Color getFromValue() {
        return this.fromValue == null ? DEFAULT_FROM_VALUE : (Color)this.fromValue.get();
    }

    public final ObjectProperty<Color> fromValueProperty() {
        if (this.fromValue == null) {
            this.fromValue = new SimpleObjectProperty<Color>(this, "fromValue", DEFAULT_FROM_VALUE);
        }
        return this.fromValue;
    }

    public final void setToValue(Color value) {
        if (this.toValue != null || value != null) {
            this.toValueProperty().set(value);
        }
    }

    public final Color getToValue() {
        return this.toValue == null ? DEFAULT_TO_VALUE : (Color)this.toValue.get();
    }

    public final ObjectProperty<Color> toValueProperty() {
        if (this.toValue == null) {
            this.toValue = new SimpleObjectProperty<Color>(this, "toValue", DEFAULT_TO_VALUE);
        }
        return this.toValue;
    }

    public StrokeTransition(Duration duration, Shape shape, Color fromValue, Color toValue) {
        this.setDuration(duration);
        this.setShape(shape);
        this.setFromValue(fromValue);
        this.setToValue(toValue);
        this.setCycleDuration(duration);
    }

    public StrokeTransition(Duration duration, Color fromValue, Color toValue) {
        this(duration, null, fromValue, toValue);
    }

    public StrokeTransition(Duration duration, Shape shape) {
        this(duration, shape, null, null);
    }

    public StrokeTransition(Duration duration) {
        this(duration, null);
    }

    public StrokeTransition() {
        this(DEFAULT_DURATION, null);
    }

    @Override
    protected void interpolate(double frac) {
        Color newColor = this.start.interpolate(this.end, frac);
        this.cachedShape.setStroke(newColor);
    }

    private Shape getTargetShape() {
        Node node;
        Shape shape = this.getShape();
        if (shape == null && (node = this.getParentTargetNode()) instanceof Shape) {
            shape = (Shape)node;
        }
        return shape;
    }

    @Override
    boolean impl_startable(boolean forceSync) {
        if (!super.impl_startable(forceSync)) {
            return false;
        }
        if (!forceSync && this.cachedShape != null) {
            return true;
        }
        Shape shape = this.getTargetShape();
        return shape != null && (this.getFromValue() != null || shape.getStroke() instanceof Color) && this.getToValue() != null;
    }

    @Override
    void impl_sync(boolean forceSync) {
        super.impl_sync(forceSync);
        if (forceSync || this.cachedShape == null) {
            this.cachedShape = this.getTargetShape();
            Color _fromValue = this.getFromValue();
            this.start = _fromValue != null ? _fromValue : (Color)this.cachedShape.getStroke();
            this.end = this.getToValue();
        }
    }
}

