/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.webkit.network.URLs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DirectoryURLConnection
extends URLConnection {
    private static final String[] patStrings = new String[]{"([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*((?:\\d\\d:\\d\\d)|(?:\\d{4}))\\s*(\\p{Print}*)", "(\\d{2}/\\d{2}/\\d{4})\\s*(\\d{2}:\\d{2}[ap])\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)", "(\\d{2}-\\d{2}-\\d{2})\\s*(\\d{2}:\\d{2}[AP]M)\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)"};
    private static final int[][] patternGroups = new int[][]{{7, 4, 5, 6, 1}, {4, 3, 1, 2, 0}, {4, 3, 1, 2, 0}};
    private static final Pattern[] patterns;
    private static final Pattern linkp;
    private static final String styleSheet = "<style type=\"text/css\" media=\"screen\">TABLE { border: 0;}TR.header { background: #FFFFFF; color: black; font-weight: bold; text-align: center;}TR.odd { background: #E0E0E0;}TR.even { background: #C0C0C0;}TD.file { text-align: left;}TD.fsize { text-align: right; padding-right: 1em;}TD.dir { text-align: center; color: green; padding-right: 1em;}TD.link { text-align: center; color: red; padding-right: 1em;}TD.date { text-align: justify;}</style>";
    private final URLConnection inner;
    private final boolean sure;
    private String dirUrl = null;
    private boolean toHTML = true;
    private final boolean ftp;
    private InputStream ins = null;

    DirectoryURLConnection(URLConnection con, boolean notsure) {
        super(con.getURL());
        this.dirUrl = con.getURL().toExternalForm();
        this.inner = con;
        this.sure = !notsure;
        this.ftp = true;
    }

    DirectoryURLConnection(URLConnection con) {
        super(con.getURL());
        this.dirUrl = con.getURL().toExternalForm();
        this.ftp = false;
        this.sure = true;
        this.inner = con;
    }

    @Override
    public void connect() throws IOException {
        this.inner.connect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.ins == null) {
            this.ins = this.ftp ? new DirectoryInputStream(this.inner.getInputStream(), !this.sure) : new DirectoryInputStream(this.inner.getInputStream(), false);
        }
        return this.ins;
    }

    @Override
    public String getContentType() {
        try {
            if (!this.sure) {
                this.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.toHTML) {
            return "text/html";
        }
        return this.inner.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.inner.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.inner.getContentLength();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.inner.getHeaderFields();
    }

    @Override
    public String getHeaderField(String key) {
        return this.inner.getHeaderField(key);
    }

    static {
        linkp = Pattern.compile("(\\p{Print}+) \\-\\> (\\p{Print}+)$");
        patterns = new Pattern[patStrings.length];
        for (int i = 0; i < patStrings.length; ++i) {
            DirectoryURLConnection.patterns[i] = Pattern.compile(patStrings[i]);
        }
    }

    private final class DirectoryInputStream
    extends PushbackInputStream {
        private final byte[] buffer;
        private boolean endOfStream;
        private ByteArrayOutputStream bytesOut;
        private PrintStream out;
        private ByteArrayInputStream bytesIn;
        private final StringBuffer tmpString;
        private int lineCount;

        private DirectoryInputStream(InputStream ins, boolean guess) {
            super(ins, 512);
            this.endOfStream = false;
            this.bytesOut = new ByteArrayOutputStream();
            this.out = new PrintStream(this.bytesOut);
            this.bytesIn = null;
            this.tmpString = new StringBuffer();
            this.lineCount = 0;
            this.buffer = new byte[512];
            if (guess) {
                StringBuffer line = new StringBuffer();
                int l = 0;
                try {
                    l = super.read(this.buffer, 0, this.buffer.length);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (l <= 0) {
                    DirectoryURLConnection.this.toHTML = false;
                } else {
                    for (int i = 0; i < l; ++i) {
                        line.append((char)this.buffer[i]);
                    }
                    String line2 = line.toString();
                    DirectoryURLConnection.this.toHTML = false;
                    for (Pattern p : patterns) {
                        Matcher m = p.matcher(line2);
                        if (!m.find()) continue;
                        DirectoryURLConnection.this.toHTML = true;
                        break;
                    }
                    try {
                        super.unread(this.buffer, 0, l);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (DirectoryURLConnection.this.toHTML) {
                int index;
                String parent = null;
                URL prevUrl = null;
                if (!DirectoryURLConnection.this.dirUrl.endsWith("/")) {
                    DirectoryURLConnection.this.dirUrl = DirectoryURLConnection.this.dirUrl + "/";
                }
                try {
                    prevUrl = URLs.newURL(DirectoryURLConnection.this.dirUrl);
                }
                catch (Exception line2) {
                    // empty catch block
                }
                String path = prevUrl.getPath();
                if (path != null && !path.isEmpty() && (index = path.lastIndexOf("/", path.length() - 2)) >= 0) {
                    int removed = path.length() - index - 1;
                    index = DirectoryURLConnection.this.dirUrl.indexOf(path);
                    parent = DirectoryURLConnection.this.dirUrl.substring(0, index + path.length() - removed) + DirectoryURLConnection.this.dirUrl.substring(index + path.length());
                }
                this.out.print("<html><head><title>index of ");
                this.out.print(DirectoryURLConnection.this.dirUrl);
                this.out.print("</title>");
                this.out.print(DirectoryURLConnection.styleSheet);
                this.out.print("</head><body><h1>Index of ");
                this.out.print(DirectoryURLConnection.this.dirUrl);
                this.out.print("</h1><hr></hr>");
                this.out.print("<TABLE width=\"95%\" cellpadding=\"5\" cellspacing=\"5\">");
                this.out.print("<TR class=\"header\"><TD>File</TD><TD>Size</TD><TD>Last Modified</TD></TR>");
                if (parent != null) {
                    ++this.lineCount;
                    this.out.print("<TR class=\"odd\"><TD colspan=3 class=\"file\"><a href=\"");
                    this.out.print(parent);
                    this.out.print("\">Up to parent directory</a></TD></TR>");
                }
                this.out.close();
                this.bytesIn = new ByteArrayInputStream(this.bytesOut.toByteArray());
                this.out = null;
                this.bytesOut = null;
            }
        }

        private void parseFile(String s) {
            int i;
            this.tmpString.append(s);
            while ((i = this.tmpString.indexOf("\n")) >= 0) {
                String sb = this.tmpString.substring(0, i);
                this.tmpString.delete(0, i + 1);
                String filename = sb;
                String size = null;
                String date = null;
                boolean dir = false;
                boolean noaccess = false;
                URL furl = null;
                if (filename == null) continue;
                ++this.lineCount;
                try {
                    furl = URLs.newURL(DirectoryURLConnection.this.dirUrl + URLEncoder.encode(filename, "UTF-8"));
                    URLConnection fconn = furl.openConnection();
                    fconn.connect();
                    date = fconn.getHeaderField("last-modified");
                    size = fconn.getHeaderField("content-length");
                    if (size == null) {
                        dir = true;
                    }
                    fconn.getInputStream().close();
                }
                catch (IOException e) {
                    noaccess = true;
                }
                if (this.bytesOut == null) {
                    this.bytesOut = new ByteArrayOutputStream();
                    this.out = new PrintStream(this.bytesOut);
                }
                this.out.print("<TR class=\"" + (this.lineCount % 2 == 0 ? "even" : "odd") + "\"><TD class=\"file\">");
                if (noaccess) {
                    this.out.print(filename);
                } else {
                    this.out.print("<a href=\"");
                    this.out.print(furl.toExternalForm());
                    this.out.print("\">");
                    this.out.print(filename);
                    this.out.print("</a>");
                }
                if (dir) {
                    this.out.print("</TD><TD class=\"dir\">&lt;Directory&gt;</TD>");
                } else {
                    this.out.print("</TD><TD class=\"fsize\">" + (size == null ? " " : size) + "</TD>");
                }
                this.out.print("<TD class=\"date\">" + (date == null ? " " : date) + "</TD></TR>");
            }
            if (this.bytesOut != null) {
                this.out.close();
                this.bytesIn = new ByteArrayInputStream(this.bytesOut.toByteArray());
                this.out = null;
                this.bytesOut = null;
            }
        }

        private void parseFTP(String s) {
            int i;
            this.tmpString.append(s);
            while ((i = this.tmpString.indexOf("\n")) >= 0) {
                String sb = this.tmpString.substring(0, i);
                this.tmpString.delete(0, i + 1);
                String filename = null;
                String link = null;
                String size = null;
                String date = null;
                boolean dir = false;
                Matcher m = null;
                for (int j = 0; j < patterns.length; ++j) {
                    m = patterns[j].matcher(sb);
                    if (!m.find()) continue;
                    filename = m.group(patternGroups[j][0]);
                    size = m.group(patternGroups[j][1]);
                    date = m.group(patternGroups[j][2]);
                    if (patternGroups[j][3] > 0) {
                        date = date + " " + m.group(patternGroups[j][3]);
                    }
                    if (patternGroups[j][4] > 0) {
                        String perms = m.group(patternGroups[j][4]);
                        dir = perms.startsWith("d");
                    }
                    if (!"<DIR>".equals(size)) continue;
                    dir = true;
                    size = null;
                }
                if (filename == null) continue;
                m = linkp.matcher(filename);
                if (m.find()) {
                    filename = m.group(1);
                    link = m.group(2);
                }
                if (this.bytesOut == null) {
                    this.bytesOut = new ByteArrayOutputStream();
                    this.out = new PrintStream(this.bytesOut);
                }
                ++this.lineCount;
                this.out.print("<TR class=\"" + (this.lineCount % 2 == 0 ? "even" : "odd") + "\"><TD class=\"file\"><a href=\"");
                try {
                    this.out.print(DirectoryURLConnection.this.dirUrl + URLEncoder.encode(filename, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (dir) {
                    this.out.print("/");
                }
                this.out.print("\">");
                this.out.print(filename);
                this.out.print("</a>");
                if (link != null) {
                    this.out.print(" &rarr; " + link + "</TD><TD class=\"link\">&lt;Link&gt;</TD>");
                } else if (dir) {
                    this.out.print("</TD><TD class=\"dir\">&lt;Directory&gt;</TD>");
                } else {
                    this.out.print("</TD><TD class=\"fsize\">" + size + "</TD>");
                }
                this.out.print("<TD class=\"date\">" + date + "</TD></TR>");
            }
            if (this.bytesOut != null) {
                this.out.close();
                this.bytesIn = new ByteArrayInputStream(this.bytesOut.toByteArray());
                this.out = null;
                this.bytesOut = null;
            }
        }

        private void endOfList() {
            if (DirectoryURLConnection.this.ftp) {
                this.parseFTP("\n");
            } else {
                this.parseFile("\n");
            }
            if (this.bytesOut == null) {
                this.bytesOut = new ByteArrayOutputStream();
                this.out = new PrintStream(this.bytesOut);
            }
            this.out.print("</TABLE><br><hr></hr></body></html>");
            this.out.close();
            this.bytesIn = new ByteArrayInputStream(this.bytesOut.toByteArray());
            this.out = null;
            this.bytesOut = null;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            int l = 0;
            if (!DirectoryURLConnection.this.toHTML) {
                return super.read(buf, offset, length);
            }
            if (this.bytesIn != null) {
                l = this.bytesIn.read(buf, offset, length);
                if (l == -1) {
                    this.bytesIn.close();
                    this.bytesIn = null;
                    if (this.endOfStream) {
                        return -1;
                    }
                } else {
                    return l;
                }
            }
            if (!this.endOfStream) {
                l = super.read(this.buffer, 0, this.buffer.length);
                if (l == -1) {
                    this.endOfStream = true;
                    this.endOfList();
                    return this.read(buf, offset, length);
                }
                if (DirectoryURLConnection.this.ftp) {
                    this.parseFTP(new String(this.buffer, 0, l));
                } else {
                    this.parseFile(new String(this.buffer, 0, l));
                }
                if (this.bytesIn != null) {
                    return this.read(buf, offset, length);
                }
            }
            return 0;
        }
    }
}

