/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.graphics;

import com.sun.webkit.Invoker;
import com.sun.webkit.graphics.BufferData;
import com.sun.webkit.graphics.GraphicsDecoder;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCRectangle;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WCRenderQueue
extends Ref {
    private static final AtomicInteger idCountObj = new AtomicInteger(0);
    private static final Logger log = Logger.getLogger(WCRenderQueue.class.getName());
    public static final int MAX_QUEUE_SIZE = 524288;
    private final LinkedList<BufferData> buffers = new LinkedList();
    private BufferData currentBuffer = new BufferData();
    private final WCRectangle clip;
    private int size = 0;
    private final boolean opaque;
    protected final WCGraphicsContext gc;

    protected WCRenderQueue(WCGraphicsContext gc) {
        this.clip = null;
        this.opaque = false;
        this.gc = gc;
    }

    protected WCRenderQueue(WCRectangle clip, boolean opaque) {
        this.clip = clip;
        this.opaque = opaque;
        this.gc = null;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void addBuffer(ByteBuffer buffer) {
        if (log.isLoggable(Level.FINE) && this.buffers.isEmpty()) {
            log.log(Level.FINE, "'{'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.incrementAndGet()});
        }
        this.currentBuffer.setBuffer(buffer);
        this.buffers.addLast(this.currentBuffer);
        this.currentBuffer = new BufferData();
        this.size += buffer.capacity();
        if (this.size > 524288 && this.gc != null) {
            this.flush();
        }
    }

    public synchronized boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    public synchronized void decode(WCGraphicsContext gc) {
        for (BufferData bdata : this.buffers) {
            try {
                GraphicsDecoder.decode(WCGraphicsManager.getGraphicsManager(), gc, bdata);
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.err);
            }
        }
        this.dispose();
    }

    public synchronized void decode() {
        assert (this.gc != null);
        this.decode(this.gc);
        this.gc.flush();
    }

    public synchronized void decode(int fontSmoothingType) {
        assert (this.gc != null);
        this.gc.setFontSmoothingType(fontSmoothingType);
        this.decode();
    }

    protected abstract void flush();

    private void fwkFlush() {
        this.flush();
    }

    private void fwkAddBuffer(ByteBuffer buffer) {
        this.addBuffer(buffer);
    }

    public WCRectangle getClip() {
        return this.clip;
    }

    public synchronized void dispose() {
        int n = this.buffers.size();
        if (n > 0) {
            int i = 0;
            Object[] arr = new Object[n];
            for (BufferData bdata : this.buffers) {
                arr[i++] = bdata.getBuffer();
            }
            this.buffers.clear();
            Invoker.getInvoker().invokeOnEventThread(() -> this.twkRelease(arr));
            this.size = 0;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "'}'WCRenderQueue{0}[{1}]", new Object[]{this.hashCode(), idCountObj.decrementAndGet()});
            }
        }
    }

    protected abstract void disposeGraphics();

    private void fwkDisposeGraphics() {
        this.disposeGraphics();
    }

    private native void twkRelease(Object[] var1);

    private int refString(String str) {
        return this.currentBuffer.addString(str);
    }

    private int refIntArr(int[] arr) {
        return this.currentBuffer.addIntArray(arr);
    }

    private int refFloatArr(float[] arr) {
        return this.currentBuffer.addFloatArray(arr);
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public synchronized String toString() {
        return "WCRenderQueue{clip=" + this.clip + ", size=" + this.size + ", opaque=" + this.opaque + "}";
    }
}

