/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.state.RenderState;

public class Reflection
extends CoreEffect<RenderState> {
    private float topOffset = 0.0f;
    private float topOpacity = 0.5f;
    private float bottomOpacity = 0.0f;
    private float fraction = 0.75f;

    public Reflection() {
        this(DefaultInput);
    }

    public Reflection(Effect input) {
        super(input);
        this.updatePeerKey("Reflection");
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public float getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(float topOffset) {
        float old = this.topOffset;
        this.topOffset = topOffset;
    }

    public float getTopOpacity() {
        return this.topOpacity;
    }

    public void setTopOpacity(float topOpacity) {
        if (topOpacity < 0.0f || topOpacity > 1.0f) {
            throw new IllegalArgumentException("Top opacity must be in the range [0,1]");
        }
        float old = this.topOpacity;
        this.topOpacity = topOpacity;
    }

    public float getBottomOpacity() {
        return this.bottomOpacity;
    }

    public void setBottomOpacity(float bottomOpacity) {
        if (bottomOpacity < 0.0f || bottomOpacity > 1.0f) {
            throw new IllegalArgumentException("Bottom opacity must be in the range [0,1]");
        }
        float old = this.bottomOpacity;
        this.bottomOpacity = bottomOpacity;
    }

    public float getFraction() {
        return this.fraction;
    }

    public void setFraction(float fraction) {
        if (fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("Fraction must be in the range [0,1]");
        }
        float old = this.fraction;
        this.fraction = fraction;
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        Effect input = this.getDefaultedInput(0, defaultInput);
        BaseBounds r = input.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        r.roundOut();
        float x1 = r.getMinX();
        float y1 = r.getMaxY() + this.topOffset;
        float x2 = r.getMaxX();
        float y2 = y1 + this.fraction * r.getHeight();
        BaseBounds ret = new RectBounds(x1, y1, x2, y2);
        ret = ((BaseBounds)ret).deriveWithUnion(r);
        return Reflection.transformBounds(transform, ret);
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        return this.getDefaultedInput(0, defaultInput).transform(p, defaultInput);
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        return this.getDefaultedInput(0, defaultInput).untransform(p, defaultInput);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return RenderState.UnclippedUserSpaceRenderState;
    }

    @Override
    public boolean reducesOpaquePixels() {
        Effect input = this.getInput();
        return input != null && input.reducesOpaquePixels();
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        BaseBounds contentBounds = di.getBounds(BaseTransform.IDENTITY_TRANSFORM, defaultInput);
        float cbMaxY = contentBounds.getMaxY();
        float reflectedMaxYBase = 2.0f * cbMaxY + this.getTopOffset();
        float reflecteCbMaxY = cbMaxY + this.getTopOffset() + this.fraction * contentBounds.getHeight();
        DirtyRegionContainer newDRC = regionPool.checkOut();
        for (int i = 0; i < drc.size(); ++i) {
            RectBounds regionBounds = drc.getDirtyRegion(i);
            float reflectedRegionMinY = reflectedMaxYBase - ((BaseBounds)regionBounds).getMaxY();
            float reflectedRegionMaxY = Math.min(reflecteCbMaxY, reflectedRegionMinY + ((BaseBounds)regionBounds).getHeight());
            newDRC.addDirtyRegion(new RectBounds(((BaseBounds)regionBounds).getMinX(), reflectedRegionMinY, ((BaseBounds)regionBounds).getMaxX(), reflectedRegionMaxY));
        }
        drc.merge(newDRC);
        regionPool.checkIn(newDRC);
        return drc;
    }
}

