/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

public final class GradientColorMap {
    public static final int CYCLE_NONE = 0;
    public static final int CYCLE_REPEAT = 1;
    public static final int CYCLE_REFLECT = 2;
    int cycleMethod;
    private static final int LG_RAMP_SIZE = 8;
    private static final int RAMP_SIZE = 256;
    int[] fractions = null;
    int[] rgba = null;
    int[] colors = null;

    GradientColorMap(int[] fractions, int[] rgba, int cycleMethod) {
        int[] nrgba;
        int[] nfractions;
        this.cycleMethod = cycleMethod;
        int numStops = fractions.length;
        if (fractions[0] != 0) {
            nfractions = new int[numStops + 1];
            nrgba = new int[numStops + 1];
            System.arraycopy(fractions, 0, nfractions, 1, numStops);
            System.arraycopy(rgba, 0, nrgba, 1, numStops);
            nfractions[0] = 0;
            nrgba[0] = rgba[0];
            fractions = nfractions;
            rgba = nrgba;
            ++numStops;
        }
        if (fractions[numStops - 1] != 65536) {
            nfractions = new int[numStops + 1];
            nrgba = new int[numStops + 1];
            System.arraycopy(fractions, 0, nfractions, 0, numStops);
            System.arraycopy(rgba, 0, nrgba, 0, numStops);
            nfractions[numStops] = 65536;
            nrgba[numStops] = rgba[numStops - 1];
            fractions = nfractions;
            rgba = nrgba;
        }
        this.fractions = new int[fractions.length];
        System.arraycopy(fractions, 0, this.fractions, 0, fractions.length);
        this.rgba = new int[rgba.length];
        System.arraycopy(rgba, 0, this.rgba, 0, rgba.length);
        this.createRamp();
    }

    private int pad(int frac) {
        switch (this.cycleMethod) {
            case 0: {
                if (frac < 0) {
                    return 0;
                }
                if (frac > 65535) {
                    return 65535;
                }
                return frac;
            }
            case 1: {
                return frac & 0xFFFF;
            }
            case 2: {
                if (frac < 0) {
                    frac = -frac;
                }
                if ((frac &= 0x1FFFF) > 65535) {
                    frac = 131071 - frac;
                }
                return frac;
            }
        }
        throw new RuntimeException("Unknown cycle method: " + this.cycleMethod);
    }

    private int findStop(int frac) {
        int numStops = this.fractions.length;
        for (int i = 1; i < numStops; ++i) {
            if (this.fractions[i] <= frac) continue;
            return i;
        }
        return 1;
    }

    private void accumColor(int frac, int[] r, int[] g, int[] b, int[] a, int[] red, int[] green, int[] blue, int[] alpha) {
        int stop = this.findStop(frac);
        int delta = this.fractions[stop] - this.fractions[stop - 1];
        red[0] = red[0] + (r[stop - 1] + (frac -= this.fractions[stop - 1]) * (r[stop] - r[stop - 1]) / delta);
        green[0] = green[0] + (g[stop - 1] + frac * (g[stop] - g[stop - 1]) / delta);
        blue[0] = blue[0] + (b[stop - 1] + frac * (b[stop] - b[stop - 1]) / delta);
        alpha[0] = alpha[0] + (a[stop - 1] + frac * (a[stop] - a[stop - 1]) / delta);
    }

    private int getColorAA(int frac, int[] r, int[] g, int[] b, int[] a, int[] red, int[] green, int[] blue, int[] alpha) {
        int delta;
        int stop = this.findStop(frac);
        if (this.fractions[stop - 1] < this.pad(frac - (delta = 192)) && this.pad(frac + delta) < this.fractions[stop]) {
            delta = 0;
        }
        int step = 64;
        int total = 0;
        for (int i = -delta; i <= delta; i += step) {
            int f = this.pad(frac + i);
            this.accumColor(f, r, g, b, a, red, green, blue, alpha);
            ++total;
        }
        alpha[0] = alpha[0] / total;
        red[0] = red[0] / total;
        green[0] = green[0] / total;
        blue[0] = blue[0] / total;
        return alpha[0] << 24 | red[0] << 16 | green[0] << 8 | blue[0];
    }

    private void createRamp() {
        this.colors = new int[256];
        int[] alpha = new int[1];
        int[] red = new int[1];
        int[] green = new int[1];
        int[] blue = new int[1];
        int numStops = this.fractions.length;
        int[] a = new int[numStops];
        int[] r = new int[numStops];
        int[] g = new int[numStops];
        int[] b = new int[numStops];
        for (int i = 0; i < numStops; ++i) {
            a[i] = this.rgba[i] >> 24 & 0xFF;
            r[i] = this.rgba[i] >> 16 & 0xFF;
            g[i] = this.rgba[i] >> 8 & 0xFF;
            b[i] = this.rgba[i] & 0xFF;
        }
        int lastColorIndex = 255;
        int shift = 8;
        this.colors[0] = this.rgba[0];
        this.colors[lastColorIndex] = this.rgba[numStops - 1];
        for (int i = 1; i < lastColorIndex; ++i) {
            alpha[0] = 0;
            blue[0] = 0;
            green[0] = 0;
            red[0] = 0;
            this.colors[i] = this.getColorAA(i << shift, r, g, b, a, red, green, blue, alpha);
        }
    }
}

