/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;

public class LabeledImpl
extends Label {
    private final Shuttler shuttler;

    public LabeledImpl(Labeled labeled) {
        this.shuttler = new Shuttler(this, labeled);
    }

    private static void initialize(Shuttler shuttler, LabeledImpl labeledImpl, Labeled labeled) {
        labeledImpl.setText(labeled.getText());
        labeled.textProperty().addListener(shuttler);
        labeledImpl.setGraphic(labeled.getGraphic());
        labeled.graphicProperty().addListener(shuttler);
        List<CssMetaData<Styleable, ?>> styleables = StyleableProperties.STYLEABLES_TO_MIRROR;
        int nMax = styleables.size();
        for (int n = 0; n < nMax; ++n) {
            StyleableProperty<?> fromVal;
            CssMetaData<Styleable, ?> styleable = styleables.get(n);
            if ("-fx-skin".equals(styleable.getProperty()) || !((fromVal = styleable.getStyleableProperty(labeled)) instanceof Observable)) continue;
            ((Observable)((Object)fromVal)).addListener(shuttler);
            StyleOrigin origin = fromVal.getStyleOrigin();
            if (origin == null) continue;
            StyleableProperty<?> styleableProperty = styleable.getStyleableProperty(labeledImpl);
            styleableProperty.applyStyle(origin, fromVal.getValue());
        }
    }

    static final class StyleableProperties {
        static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES_TO_MIRROR;

        StyleableProperties() {
        }

        static {
            List<CssMetaData<? extends Styleable, ?>> labeledStyleables = Labeled.getClassCssMetaData();
            List<CssMetaData<? extends Styleable, ?>> parentStyleables = Region.getClassCssMetaData();
            ArrayList styleables = new ArrayList(labeledStyleables);
            styleables.removeAll(parentStyleables);
            STYLEABLES_TO_MIRROR = Collections.unmodifiableList(styleables);
        }
    }

    private static class Shuttler
    implements InvalidationListener {
        private final LabeledImpl labeledImpl;
        private final Labeled labeled;

        Shuttler(LabeledImpl labeledImpl, Labeled labeled) {
            this.labeledImpl = labeledImpl;
            this.labeled = labeled;
            LabeledImpl.initialize(this, labeledImpl, labeled);
        }

        @Override
        public void invalidated(Observable valueModel) {
            StyleableProperty styleableProperty;
            CssMetaData cssMetaData;
            if (valueModel == this.labeled.textProperty()) {
                this.labeledImpl.setText(this.labeled.getText());
            } else if (valueModel == this.labeled.graphicProperty()) {
                StyleOrigin origin = ((StyleableProperty)((Object)this.labeled.graphicProperty())).getStyleOrigin();
                if (origin == null || origin == StyleOrigin.USER) {
                    this.labeledImpl.setGraphic(this.labeled.getGraphic());
                }
            } else if (valueModel instanceof StyleableProperty && (cssMetaData = (styleableProperty = (StyleableProperty)((Object)valueModel)).getCssMetaData()) != null) {
                StyleOrigin origin = styleableProperty.getStyleOrigin();
                StyleableProperty targetProperty = cssMetaData.getStyleableProperty(this.labeledImpl);
                targetProperty.applyStyle(origin, styleableProperty.getValue());
            }
        }
    }
}

