/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;

public class TableColumnSortTypeWrapper {
    public static boolean isAscending(TableColumnBase<?, ?> column) {
        String sortTypeName = TableColumnSortTypeWrapper.getSortTypeName(column);
        return "ASCENDING".equals(sortTypeName);
    }

    public static boolean isDescending(TableColumnBase<?, ?> column) {
        String sortTypeName = TableColumnSortTypeWrapper.getSortTypeName(column);
        return "DESCENDING".equals(sortTypeName);
    }

    public static void setSortType(TableColumnBase<?, ?> column, TableColumn.SortType sortType) {
        if (column instanceof TableColumn) {
            TableColumn tc = (TableColumn)column;
            tc.setSortType(sortType);
        } else if (column instanceof TreeTableColumn) {
            TreeTableColumn tc = (TreeTableColumn)column;
            if (sortType == TableColumn.SortType.ASCENDING) {
                tc.setSortType(TreeTableColumn.SortType.ASCENDING);
            } else if (sortType == TableColumn.SortType.DESCENDING) {
                tc.setSortType(TreeTableColumn.SortType.DESCENDING);
            } else if (sortType == null) {
                tc.setSortType(null);
            }
        }
    }

    public static String getSortTypeName(TableColumnBase<?, ?> column) {
        if (column instanceof TableColumn) {
            TableColumn tc = (TableColumn)column;
            TableColumn.SortType st = tc.getSortType();
            return st == null ? null : st.name();
        }
        if (column instanceof TreeTableColumn) {
            TreeTableColumn tc = (TreeTableColumn)column;
            TreeTableColumn.SortType st = tc.getSortType();
            return st == null ? null : st.name();
        }
        return null;
    }

    public static ObservableValue getSortTypeProperty(TableColumnBase<?, ?> column) {
        if (column instanceof TableColumn) {
            return ((TableColumn)column).sortTypeProperty();
        }
        if (column instanceof TreeTableColumn) {
            return ((TreeTableColumn)column).sortTypeProperty();
        }
        return null;
    }
}

