      SUBROUTINE AXES(XMIN,XMAX,YMIN,YMAX)
C
      INCLUDE 'com_faces.f'
      INCLUDE 'com_options.f'
C
      REAL*4 XXX(4),YYY(4)
      CHARACTER*1 AX(3)
C
      DATA AX   / 'x' , 'y' , 'z' /
      DATA EPS  / 1.E-02 /
C
C Axes
C
      IF (ILANG.EQ.0) THEN
        CALL COMMENTE_PS('Debut axes',10)
      ELSE
        CALL COMMENTE_PS('Begin axis',10)
      ENDIF
C
      CALL GSCOL(ICOLAX)
      IF (IAXES.EQ.5) THEN
        IF (I2D.EQ.0) THEN
          IAXES = 0
          RETURN
        ENDIF
        CALL GSLT(2)
        EPSAX = (XMAX-XMIN)*0.01
        X = XORIG
        Y = YORIG
        Z = ZORIG
        XAXE = 1.
        CALL ROTATION(X,Y,Z,ROTA,XR,YR,ZR)
        SENS = REAL(ISENS)
        CALL PROJEC(XR,YR,ZR,SENS,XA0,YA0,IPERSP,XPUP,DIST)
        X = XAXE+XORIG
        CALL ROTATION(X,Y,Z,ROTA,XR,YR,ZR)
        CALL PROJEC(XR,YR,ZR,SENS,XAX1,YAX1,IPERSP,XPUP,DIST)
        X = XORIG
        Y = XAXE+YORIG
        CALL ROTATION(X,Y,Z,ROTA,XR,YR,ZR)
        CALL PROJEC(XR,YR,ZR,SENS,XAY1,YAY1,IPERSP,XPUP,DIST)
        Y = YORIG
        Z = XAXE+ZORIG
        CALL ROTATION(X,Y,Z,ROTA,XR,YR,ZR)
        CALL PROJEC(XR,YR,ZR,SENS,XAZ1,YAZ1,IPERSP,XPUP,DIST)
        DAX = ABS(XAX1-XA0)+ABS(YAX1-YA0)
        DAY = ABS(XAY1-XA0)+ABS(YAY1-YA0)
        DAZ = ABS(XAZ1-XA0)+ABS(YAZ1-YA0)
        IF (DAX.GT.EPSAX) THEN
          IF (ABS(XAX1-XA0).GT.EPSAX) THEN
            T0 = (XMIN-XA0)/(XAX1-XA0)
            T1 = (XMAX-XA0)/(XAX1-XA0)
            CALL GSMOVE(XMIN,YA0+T0*(YAX1-YA0))
            CALL GSLINE(XMAX,YA0+T1*(YAX1-YA0))
          ELSE
            T0 = (YMIN-YA0)/(YAX1-YA0)
            T1 = (YMAX-YA0)/(YAX1-YA0)
            CALL GSMOVE(XA0+T0*(XAX1-XA0),YMIN)
            CALL GSLINE(XA0+T1*(XAX1-XA0),YMAX)
          ENDIF
        ENDIF
        IF (DAY.GT.EPSAX) THEN
          IF (ABS(XAY1-XA0).GT.EPSAX) THEN
            T0 = (XMIN-XA0)/(XAY1-XA0)
            T1 = (XMAX-XA0)/(XAY1-XA0)
            CALL GSMOVE(XMIN,YA0+T0*(YAY1-YA0))
            CALL GSLINE(XMAX,YA0+T1*(YAY1-YA0))
          ELSE
            T0 = (YMIN-YA0)/(YAY1-YA0)
            T1 = (YMAX-YA0)/(YAY1-YA0)
            CALL GSMOVE(XA0+T0*(XAY1-XA0),YMIN)
            CALL GSLINE(XA0+T1*(XAY1-XA0),YMAX)
          ENDIF
        ENDIF
        IF (DAZ.GT.EPSAX) THEN
          IF (ABS(XAZ1-XA0).GT.EPSAX) THEN
            T0 = (XMIN-XA0)/(XAZ1-XA0)
            T1 = (XMAX-XA0)/(XAZ1-XA0)
            CALL GSMOVE(XMIN,YA0+T0*(YAZ1-YA0))
            CALL GSLINE(XMAX,YA0+T1*(YAZ1-YA0))
          ELSE
            T0 = (YMIN-YA0)/(YAZ1-YA0)
            T1 = (YMAX-YA0)/(YAZ1-YA0)
            CALL GSMOVE(XA0+T0*(XAZ1-XA0),YMIN)
            CALL GSLINE(XA0+T1*(XAZ1-XA0),YMAX)
          ENDIF
        ENDIF
        CALL GSLT(0)
        IF (ILANG.EQ.0) THEN
          CALL COMMENTE_PS('Fin axes',8)
        ELSE
          CALL COMMENTE_PS('End axis',8)
        ENDIF
      ELSE
C
        CALL GSPATF(ICTFON)
        CALL GSPAT(16)
        CALL ASFCOL(ICOLAX)
        XAXE = (XMAX-XMIN)*.12
        IF (IAXES.EQ.1) THEN
          X0 = XMIN
          X1 = X0 + XAXE
          Y1 = YMAX
          Y0 = Y1 - XAXE
        ELSEIF(IAXES.EQ.2) THEN
          X1 = XMAX
          X0 = X1 - XAXE
          Y1 = YMAX
          Y0 = Y1 - XAXE
        ELSEIF(IAXES.EQ.3) THEN
          X1 = XMAX
          X0 = X1 - XAXE
          Y0 = YMIN
          Y1 = Y0 + XAXE
        ELSE
          X0 = XMIN
          X1 = X0 + XAXE
          Y0 = YMIN
          Y1 = Y0 + XAXE
        ENDIF
C
        XXX(1) = X0
        XXX(2) = X0
        XXX(3) = X1
        XXX(4) = X1
        YYY(1) = Y0
        YYY(2) = Y1
        YYY(3) = Y1
        YYY(4) = Y0
        CALL MY_GSAREA(1,XXX,YYY,4)
        CALL GSLSS(IFONT1)
C
        XC = 0.5*(X0+X1)
        YC = 0.5*(Y0+Y1)
        XAXE = 0.25*XAXE
        SENS = REAL(ISENS)
        XLA  = 0.06
C
C Axes
C
        DO I=1,3
          X = ROTA(1,I)*XAXE
          Y = ROTA(2,I)*XAXE
          Z = ROTA(3,I)*XAXE
          DIR = SENS*(X+Y+Z)
          CALL PROJEC(X,Y,Z,SENS,XA,YA,IPERSP,XPUP,DIST)
          XB = XA + XC
          YB = YA + YC
          IF ((MAX(ABS(XA),ABS(YA))/XAXE).GT.EPS) THEN
            IF (ABS(DIR).LT.EPS) THEN
              CALL GSMOVE(XC,YC)
              CALL GSLINE(XB,YB)
            ELSE
              IF (DIR.GT.0.) THEN
                XXX(1) = XC
                XXX(2) = XB + XLA*YA
                XXX(3) = XB - XLA*YA
                YYY(1) = YC
                YYY(2) = YB - XLA*XA
                YYY(3) = YB + XLA*XA
              ELSE
                XXX(1) = XB
                XXX(2) = XC + XLA*YA
                XXX(3) = XC - XLA*YA
                YYY(1) = YB
                YYY(2) = YC - XLA*XA
                YYY(3) = YC + XLA*XA
              ENDIF
              CALL GSPATF(ICOLAX)
              CALL GSPAT(-16)
              CALL MY_GSAREA(1,XXX,YYY,3)
            ENDIF
            XB = XC + 1.4*XA - XSHIFT
            YB = YC + 1.4*YA - YSHIFT
            CALL GSPATF(ICTFON)
            CALL GSPAT(16)
            CALL GSCHAR(XB,YB,1,AX(I))
          ENDIF
        ENDDO
      ENDIF
C
      CALL GSPAT(16)
C
      IF (ILANG.EQ.0) THEN
        CALL COMMENTE_PS('Fin axes',8)
      ELSE
        CALL COMMENTE_PS('End axis',8)
      ENDIF
      END
C--------------------------------------------------------------------
      SUBROUTINE AREFRESH(IRELIM,IRELIVA,IRELIVI)
      INCLUDE 'com_options.f'
      INCLUDE 'com_faces.f'
C
      IRELIM  = 0
      IRELIVA = 0
      IRELIVI = 0
      IF (IDFICH.NE.0) THEN
        CALL datefichier(NOM_FICH(1:LONG)//CHAR(0),ID,IRC)
        IF (ID.NE.IDFICH.AND.IRC.EQ.0) THEN
          IRELIM = 1
        ELSEIF(IEXAG.GE.2.AND.IDDEPL.NE.0) THEN
          CALL datefichier(NOM_FICH(1:LONG-7)//'depl'//CHAR(0),ID,IRC)
          IF (ID.NE.IDDEPL.AND.IRC.EQ.0) IRELIM = 1
        ENDIF
      ENDIF
      IF (ISO.NE.0.OR.NSURF.GT.0) THEN
        IF (NOM_ISO(1:1).NE.'$') THEN
          CALL datefichier(NOM_ISO(1:LONISO)//CHAR(0),ID,IRC)
          IF (ID.NE.IDISO.AND.IRC.EQ.0.AND.ID*IDISO.NE.0) IRELIVA = 1
        ENDIF
        CALL datefichier(NOM_VIT(1:LONVIT)//CHAR(0),ID,IRC)
        IF (ID.NE.IDVIT.AND.IRC.EQ.0.AND.ID*IDVIT.NE.0) IRELIVI = 1
      ENDIF
      END
