      real function taille_chaine(string,nchar)
      INCLUDE 'Parametres.f'  
      integer size
      character*1 string(nchar)
      character*512 chch
      real*4 taille_cara(128)
C
C tailles pour la fonte 8 postscript (Times-Bold) en taille 0.65
C
      data taille_cara /
     &     0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,
     &     0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,
     &     0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,  0. ,
     &     0. , .25 , .333, .555, .50 , .50 ,  1. , .833, .333, .333,
     &     .333, .50 , .57 , .25 , .333, .25 , .278, .50 , .50 , .50 ,
     &     .50 , .50 , .50 , .50 , .50 , .50 , .50 , .333, .333, .57 ,
     &     .57 , .57 , .50 , .93 , .722, .667, .722, .722, .667, .611,
     &     .778, .778, .389, .50 , .778, .667, .944, .722, .778, .611,
     &     .778, .722, .556, .667, .722, .722,  1. , .722, .722, .667,
     &     .333, .278, .333, .581, .50 , .333, .50 , .556, .444, .556,
     &     .444, .333, .50 , .556, .278, .333, .556, .278, .833, .556,
     &     .50 , .556, .556, .444, .389, .333, .556, .50 , .722, .50 ,
     &     .50 , .444, .394, .22 , .394, .52 ,  0. ,  0. /
C
      if (nchar.le.0) then
        taille_chaine = 0.
        return
      endif
      if (ipostscript.eq.1) then
        if (accentsok) then
          call accent(string,nchar,chch,nn,0)
        else
          nn = nchar
          do i=1,nchar
            chch(i:i) = string(i)
          enddo
        endif
c        print*,'avant x11text',nn,'|',chch(1:nn)
c        call fflushc()
        call x11textextend(chch(1:nn)//char(0),nn,size)
c        print*,'apres x11text',size
c        call fflushc()
        if (angle_texte.eq.90.) then
          fact = -facteur_en_y
        else
          fact = facteur_en_x
        endif
        taille_chaine = real(size)/fact
      else
        if (ifonte_courante_ps.eq.4.or.ifonte_courante_ps.eq.6) then
          if (accentsok) then
            call accent(string,nchar,chch,nn,0)
          else
            nn = nchar
          endif
          ttt = .586*real(nn)*taille_texte
        else
          ttt = 0.
          if (accentsok) then
            call accent(string,nchar,chch,nn,0)
            do i=1,nn
              ii = ichar(chch(i:i))
              if (ii.le.128) then
                ttt = ttt + taille_cara(ii)*taille_texte
              else
                if (ii.ge.224.and.ii.le.228) then
                  t = taille_cara(97)
                elseif (ii.ge.232.and.ii.le.235) then
                  t = taille_cara(101)
                elseif (ii.ge.236.and.ii.le.239) then
                  t = taille_cara(105)
                elseif (ii.ge.242.and.ii.le.246) then
                  t = taille_cara(111)
                elseif ((ii.ge.249.and.ii.le.252).or.ii.eq.181) then
                  t = taille_cara(117)
                elseif (ii.eq.241) then
                  t = taille_cara(110)
                elseif (ii.eq.177) then
                  t = taille_cara(43)
                elseif (ii.eq.216) then
                  t = taille_cara(79)
                elseif (ii.eq.231) then
                  t = taille_cara(99)
                elseif (ii.eq.176) then
                  t = taille_cara(96)
                elseif (ii.eq.223) then
                  t = taille_cara(66)
                elseif (ii.eq.230) then
                  t = taille_cara(109)
                else
                  t = 0.
                endif
                ttt = ttt + t*taille_texte
              endif
            enddo
          else
            do i=1,nchar
              ttt = ttt + taille_cara(ichar(string(i)))*taille_texte
            enddo
          endif
        endif
        if (angle_texte.eq.0.) then
          taille_chaine = ttt/abs(facteur_en_x)
        elseif(abs(angle_texte).eq.90.) then
          taille_chaine = ttt/abs(facteur_en_y)
        else
          angle = angle_texte*3.14159265359/180.
          taille_chaine = ttt*sqrt( (cos(angle)/facteur_en_x)**2
     &         + (sin(angle)/facteur_en_y)**2 )
        endif
      endif
      end
