// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package admin

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	adminpb "cloud.google.com/go/iam/admin/apiv1/adminpb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newIamClientHook clientHook

// IamCallOptions contains the retry settings for each method of IamClient.
type IamCallOptions struct {
	ListServiceAccounts      []gax.CallOption
	GetServiceAccount        []gax.CallOption
	CreateServiceAccount     []gax.CallOption
	UpdateServiceAccount     []gax.CallOption
	PatchServiceAccount      []gax.CallOption
	DeleteServiceAccount     []gax.CallOption
	UndeleteServiceAccount   []gax.CallOption
	EnableServiceAccount     []gax.CallOption
	DisableServiceAccount    []gax.CallOption
	ListServiceAccountKeys   []gax.CallOption
	GetServiceAccountKey     []gax.CallOption
	CreateServiceAccountKey  []gax.CallOption
	UploadServiceAccountKey  []gax.CallOption
	DeleteServiceAccountKey  []gax.CallOption
	DisableServiceAccountKey []gax.CallOption
	EnableServiceAccountKey  []gax.CallOption
	SignBlob                 []gax.CallOption
	SignJwt                  []gax.CallOption
	GetIamPolicy             []gax.CallOption
	SetIamPolicy             []gax.CallOption
	TestIamPermissions       []gax.CallOption
	QueryGrantableRoles      []gax.CallOption
	ListRoles                []gax.CallOption
	GetRole                  []gax.CallOption
	CreateRole               []gax.CallOption
	UpdateRole               []gax.CallOption
	DeleteRole               []gax.CallOption
	UndeleteRole             []gax.CallOption
	QueryTestablePermissions []gax.CallOption
	QueryAuditableServices   []gax.CallOption
	LintPolicy               []gax.CallOption
}

func defaultIamGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("iam.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("iam.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("iam.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://iam.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultIamCallOptions() *IamCallOptions {
	return &IamCallOptions{
		ListServiceAccounts: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetServiceAccount: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateServiceAccount: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateServiceAccount: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		PatchServiceAccount: []gax.CallOption{},
		DeleteServiceAccount: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UndeleteServiceAccount: []gax.CallOption{},
		EnableServiceAccount:   []gax.CallOption{},
		DisableServiceAccount:  []gax.CallOption{},
		ListServiceAccountKeys: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetServiceAccountKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateServiceAccountKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UploadServiceAccountKey: []gax.CallOption{},
		DeleteServiceAccountKey: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DisableServiceAccountKey: []gax.CallOption{},
		EnableServiceAccountKey:  []gax.CallOption{},
		SignBlob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SignJwt: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SetIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		TestIamPermissions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		QueryGrantableRoles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListRoles:                []gax.CallOption{},
		GetRole:                  []gax.CallOption{},
		CreateRole:               []gax.CallOption{},
		UpdateRole:               []gax.CallOption{},
		DeleteRole:               []gax.CallOption{},
		UndeleteRole:             []gax.CallOption{},
		QueryTestablePermissions: []gax.CallOption{},
		QueryAuditableServices:   []gax.CallOption{},
		LintPolicy:               []gax.CallOption{},
	}
}

// internalIamClient is an interface that defines the methods available from Identity and Access Management (IAM) API.
type internalIamClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListServiceAccounts(context.Context, *adminpb.ListServiceAccountsRequest, ...gax.CallOption) *ServiceAccountIterator
	GetServiceAccount(context.Context, *adminpb.GetServiceAccountRequest, ...gax.CallOption) (*adminpb.ServiceAccount, error)
	CreateServiceAccount(context.Context, *adminpb.CreateServiceAccountRequest, ...gax.CallOption) (*adminpb.ServiceAccount, error)
	UpdateServiceAccount(context.Context, *adminpb.ServiceAccount, ...gax.CallOption) (*adminpb.ServiceAccount, error)
	PatchServiceAccount(context.Context, *adminpb.PatchServiceAccountRequest, ...gax.CallOption) (*adminpb.ServiceAccount, error)
	DeleteServiceAccount(context.Context, *adminpb.DeleteServiceAccountRequest, ...gax.CallOption) error
	UndeleteServiceAccount(context.Context, *adminpb.UndeleteServiceAccountRequest, ...gax.CallOption) (*adminpb.UndeleteServiceAccountResponse, error)
	EnableServiceAccount(context.Context, *adminpb.EnableServiceAccountRequest, ...gax.CallOption) error
	DisableServiceAccount(context.Context, *adminpb.DisableServiceAccountRequest, ...gax.CallOption) error
	ListServiceAccountKeys(context.Context, *adminpb.ListServiceAccountKeysRequest, ...gax.CallOption) (*adminpb.ListServiceAccountKeysResponse, error)
	GetServiceAccountKey(context.Context, *adminpb.GetServiceAccountKeyRequest, ...gax.CallOption) (*adminpb.ServiceAccountKey, error)
	CreateServiceAccountKey(context.Context, *adminpb.CreateServiceAccountKeyRequest, ...gax.CallOption) (*adminpb.ServiceAccountKey, error)
	UploadServiceAccountKey(context.Context, *adminpb.UploadServiceAccountKeyRequest, ...gax.CallOption) (*adminpb.ServiceAccountKey, error)
	DeleteServiceAccountKey(context.Context, *adminpb.DeleteServiceAccountKeyRequest, ...gax.CallOption) error
	DisableServiceAccountKey(context.Context, *adminpb.DisableServiceAccountKeyRequest, ...gax.CallOption) error
	EnableServiceAccountKey(context.Context, *adminpb.EnableServiceAccountKeyRequest, ...gax.CallOption) error
	SignBlob(context.Context, *adminpb.SignBlobRequest, ...gax.CallOption) (*adminpb.SignBlobResponse, error)
	SignJwt(context.Context, *adminpb.SignJwtRequest, ...gax.CallOption) (*adminpb.SignJwtResponse, error)
	getIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	setIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	QueryGrantableRoles(context.Context, *adminpb.QueryGrantableRolesRequest, ...gax.CallOption) (*adminpb.QueryGrantableRolesResponse, error)
	QueryGrantableRolesIter(context.Context, *adminpb.QueryGrantableRolesRequest, ...gax.CallOption) *RoleIterator
	ListRoles(context.Context, *adminpb.ListRolesRequest, ...gax.CallOption) (*adminpb.ListRolesResponse, error)
	ListRolesIter(context.Context, *adminpb.ListRolesRequest, ...gax.CallOption) *RoleIterator
	GetRole(context.Context, *adminpb.GetRoleRequest, ...gax.CallOption) (*adminpb.Role, error)
	CreateRole(context.Context, *adminpb.CreateRoleRequest, ...gax.CallOption) (*adminpb.Role, error)
	UpdateRole(context.Context, *adminpb.UpdateRoleRequest, ...gax.CallOption) (*adminpb.Role, error)
	DeleteRole(context.Context, *adminpb.DeleteRoleRequest, ...gax.CallOption) (*adminpb.Role, error)
	UndeleteRole(context.Context, *adminpb.UndeleteRoleRequest, ...gax.CallOption) (*adminpb.Role, error)
	QueryTestablePermissions(context.Context, *adminpb.QueryTestablePermissionsRequest, ...gax.CallOption) (*adminpb.QueryTestablePermissionsResponse, error)
	QueryTestablePermissionsIter(context.Context, *adminpb.QueryTestablePermissionsRequest, ...gax.CallOption) *PermissionIterator
	QueryAuditableServices(context.Context, *adminpb.QueryAuditableServicesRequest, ...gax.CallOption) (*adminpb.QueryAuditableServicesResponse, error)
	LintPolicy(context.Context, *adminpb.LintPolicyRequest, ...gax.CallOption) (*adminpb.LintPolicyResponse, error)
}

// IamClient is a client for interacting with Identity and Access Management (IAM) API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Creates and manages Identity and Access Management (IAM) resources.
//
// You can use this service to work with all of the following resources:
//
//	Service accounts, which identify an application or a virtual machine
//	(VM) instance rather than a person
//
//	Service account keys, which service accounts use to authenticate with
//	Google APIs
//
//	IAM policies for service accounts, which specify the roles that a
//	principal has for the service account
//
//	IAM custom roles, which help you limit the number of permissions that
//	you grant to principals
//
// In addition, you can use this service to complete the following tasks, among
// others:
//
//	Test whether a service account can use specific permissions
//
//	Check which roles you can grant for a specific resource
//
//	Lint, or validate, condition expressions in an IAM policy
//
// When you read data from the IAM API, each read is eventually consistent. In
// other words, if you write data with the IAM API, then immediately read that
// data, the read operation might return an older version of the data. To deal
// with this behavior, your application can retry the request with truncated
// exponential backoff.
//
// In contrast, writing data to the IAM API is sequentially consistent. In other
// words, write operations are always processed in the order in which they were
// received.
type IamClient struct {
	// The internal transport-dependent client.
	internalClient internalIamClient

	// The call options for this service.
	CallOptions *IamCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *IamClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *IamClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *IamClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListServiceAccounts lists every ServiceAccount that belongs to a specific project.
func (c *IamClient) ListServiceAccounts(ctx context.Context, req *adminpb.ListServiceAccountsRequest, opts ...gax.CallOption) *ServiceAccountIterator {
	return c.internalClient.ListServiceAccounts(ctx, req, opts...)
}

// GetServiceAccount gets a ServiceAccount.
func (c *IamClient) GetServiceAccount(ctx context.Context, req *adminpb.GetServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	return c.internalClient.GetServiceAccount(ctx, req, opts...)
}

// CreateServiceAccount creates a ServiceAccount.
func (c *IamClient) CreateServiceAccount(ctx context.Context, req *adminpb.CreateServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	return c.internalClient.CreateServiceAccount(ctx, req, opts...)
}

// UpdateServiceAccount Note: We are in the process of deprecating this method. Use
// PatchServiceAccount instead.
//
// Updates a ServiceAccount.
//
// You can update only the display_name field.
func (c *IamClient) UpdateServiceAccount(ctx context.Context, req *adminpb.ServiceAccount, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	return c.internalClient.UpdateServiceAccount(ctx, req, opts...)
}

// PatchServiceAccount patches a ServiceAccount.
func (c *IamClient) PatchServiceAccount(ctx context.Context, req *adminpb.PatchServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	return c.internalClient.PatchServiceAccount(ctx, req, opts...)
}

// DeleteServiceAccount deletes a ServiceAccount.
//
// Warning: After you delete a service account, you might not be able to
// undelete it. If you know that you need to re-enable the service account in
// the future, use DisableServiceAccount instead.
//
// If you delete a service account, IAM permanently removes the service
// account 30 days later. Google Cloud cannot recover the service account
// after it is permanently removed, even if you file a support request.
//
// To help avoid unplanned outages, we recommend that you disable the service
// account before you delete it. Use DisableServiceAccount to disable the
// service account, then wait at least 24 hours and watch for unintended
// consequences. If there are no unintended consequences, you can delete the
// service account.
func (c *IamClient) DeleteServiceAccount(ctx context.Context, req *adminpb.DeleteServiceAccountRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteServiceAccount(ctx, req, opts...)
}

// UndeleteServiceAccount restores a deleted ServiceAccount.
//
// Important: It is not always possible to restore a deleted service
// account. Use this method only as a last resort.
//
// After you delete a service account, IAM permanently removes the service
// account 30 days later. There is no way to restore a deleted service account
// that has been permanently removed.
func (c *IamClient) UndeleteServiceAccount(ctx context.Context, req *adminpb.UndeleteServiceAccountRequest, opts ...gax.CallOption) (*adminpb.UndeleteServiceAccountResponse, error) {
	return c.internalClient.UndeleteServiceAccount(ctx, req, opts...)
}

// EnableServiceAccount enables a ServiceAccount that was disabled by
// DisableServiceAccount.
//
// If the service account is already enabled, then this method has no effect.
//
// If the service account was disabled by other means—for example, if Google
// disabled the service account because it was compromised—you cannot use this
// method to enable the service account.
func (c *IamClient) EnableServiceAccount(ctx context.Context, req *adminpb.EnableServiceAccountRequest, opts ...gax.CallOption) error {
	return c.internalClient.EnableServiceAccount(ctx, req, opts...)
}

// DisableServiceAccount disables a ServiceAccount immediately.
//
// If an application uses the service account to authenticate, that
// application can no longer call Google APIs or access Google Cloud
// resources. Existing access tokens for the service account are rejected, and
// requests for new access tokens will fail.
//
// To re-enable the service account, use EnableServiceAccount. After you
// re-enable the service account, its existing access tokens will be accepted,
// and you can request new access tokens.
//
// To help avoid unplanned outages, we recommend that you disable the service
// account before you delete it. Use this method to disable the service
// account, then wait at least 24 hours and watch for unintended consequences.
// If there are no unintended consequences, you can delete the service account
// with DeleteServiceAccount.
func (c *IamClient) DisableServiceAccount(ctx context.Context, req *adminpb.DisableServiceAccountRequest, opts ...gax.CallOption) error {
	return c.internalClient.DisableServiceAccount(ctx, req, opts...)
}

// ListServiceAccountKeys lists every ServiceAccountKey for a service account.
func (c *IamClient) ListServiceAccountKeys(ctx context.Context, req *adminpb.ListServiceAccountKeysRequest, opts ...gax.CallOption) (*adminpb.ListServiceAccountKeysResponse, error) {
	return c.internalClient.ListServiceAccountKeys(ctx, req, opts...)
}

// GetServiceAccountKey gets a ServiceAccountKey.
func (c *IamClient) GetServiceAccountKey(ctx context.Context, req *adminpb.GetServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	return c.internalClient.GetServiceAccountKey(ctx, req, opts...)
}

// CreateServiceAccountKey creates a ServiceAccountKey.
func (c *IamClient) CreateServiceAccountKey(ctx context.Context, req *adminpb.CreateServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	return c.internalClient.CreateServiceAccountKey(ctx, req, opts...)
}

// UploadServiceAccountKey uploads the public key portion of a key pair that you manage, and
// associates the public key with a ServiceAccount.
//
// After you upload the public key, you can use the private key from the key
// pair as a service account key.
func (c *IamClient) UploadServiceAccountKey(ctx context.Context, req *adminpb.UploadServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	return c.internalClient.UploadServiceAccountKey(ctx, req, opts...)
}

// DeleteServiceAccountKey deletes a ServiceAccountKey. Deleting a service account key does not
// revoke short-lived credentials that have been issued based on the service
// account key.
func (c *IamClient) DeleteServiceAccountKey(ctx context.Context, req *adminpb.DeleteServiceAccountKeyRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteServiceAccountKey(ctx, req, opts...)
}

// DisableServiceAccountKey disable a ServiceAccountKey. A disabled service account key can be
// re-enabled with EnableServiceAccountKey.
func (c *IamClient) DisableServiceAccountKey(ctx context.Context, req *adminpb.DisableServiceAccountKeyRequest, opts ...gax.CallOption) error {
	return c.internalClient.DisableServiceAccountKey(ctx, req, opts...)
}

// EnableServiceAccountKey enable a ServiceAccountKey.
func (c *IamClient) EnableServiceAccountKey(ctx context.Context, req *adminpb.EnableServiceAccountKeyRequest, opts ...gax.CallOption) error {
	return c.internalClient.EnableServiceAccountKey(ctx, req, opts...)
}

// SignBlob Note: This method is deprecated. Use the
// signBlob (at https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signBlob)
// method in the IAM Service Account Credentials API instead. If you currently
// use this method, see the migration
// guide (at https://cloud.google.com/iam/help/credentials/migrate-api) for
// instructions.
//
// Signs a blob using the system-managed private key for a ServiceAccount.
//
// Deprecated: SignBlob may be removed in a future version.
func (c *IamClient) SignBlob(ctx context.Context, req *adminpb.SignBlobRequest, opts ...gax.CallOption) (*adminpb.SignBlobResponse, error) {
	return c.internalClient.SignBlob(ctx, req, opts...)
}

// SignJwt Note: This method is deprecated. Use the
// signJwt (at https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signJwt)
// method in the IAM Service Account Credentials API instead. If you currently
// use this method, see the migration
// guide (at https://cloud.google.com/iam/help/credentials/migrate-api) for
// instructions.
//
// Signs a JSON Web Token (JWT) using the system-managed private key for a
// ServiceAccount.
//
// Deprecated: SignJwt may be removed in a future version.
func (c *IamClient) SignJwt(ctx context.Context, req *adminpb.SignJwtRequest, opts ...gax.CallOption) (*adminpb.SignJwtResponse, error) {
	return c.internalClient.SignJwt(ctx, req, opts...)
}

// GetIamPolicy gets the IAM policy that is attached to a ServiceAccount. This IAM
// policy specifies which principals have access to the service account.
//
// This method does not tell you whether the service account has been granted
// any roles on other resources. To check whether a service account has role
// grants on a resource, use the getIamPolicy method for that resource. For
// example, to view the role grants for a project, call the Resource Manager
// API’s
// projects.getIamPolicy (at https://cloud.google.com/resource-manager/reference/rest/v1/projects/getIamPolicy)
// method.
func (c *IamClient) getIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.getIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the IAM policy that is attached to a ServiceAccount.
//
// Use this method to grant or revoke access to the service account. For
// example, you could grant a principal the ability to impersonate the service
// account.
//
// This method does not enable the service account to access other resources.
// To grant roles to a service account on a resource, follow these steps:
//
// Call the resource’s getIamPolicy method to get its current IAM policy.
//
// Edit the policy so that it binds the service account to an IAM role for
// the resource.
//
// Call the resource’s setIamPolicy method to update its IAM policy.
//
// For detailed instructions, see
// Manage access to project, folders, and
// organizations (at https://cloud.google.com/iam/help/service-accounts/granting-access-to-service-accounts)
// or Manage access to other
// resources (at https://cloud.google.com/iam/help/access/manage-other-resources).
func (c *IamClient) setIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.setIamPolicy(ctx, req, opts...)
}

// TestIamPermissions tests whether the caller has the specified permissions on a
// ServiceAccount.
func (c *IamClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// QueryGrantableRoles lists roles that can be granted on a Google Cloud resource. A role is
// grantable if the IAM policy for the resource can contain bindings to the
// role.
func (c *IamClient) QueryGrantableRolesIter(ctx context.Context, req *adminpb.QueryGrantableRolesRequest, opts ...gax.CallOption) *RoleIterator {
	return c.internalClient.QueryGrantableRolesIter(ctx, req, opts...)
}

// ListRoles lists every predefined Role that IAM supports, or every custom role
// that is defined for an organization or project.
func (c *IamClient) ListRolesIter(ctx context.Context, req *adminpb.ListRolesRequest, opts ...gax.CallOption) *RoleIterator {
	return c.internalClient.ListRolesIter(ctx, req, opts...)
}

// GetRole gets the definition of a Role.
func (c *IamClient) GetRole(ctx context.Context, req *adminpb.GetRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	return c.internalClient.GetRole(ctx, req, opts...)
}

// CreateRole creates a new custom Role.
func (c *IamClient) CreateRole(ctx context.Context, req *adminpb.CreateRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	return c.internalClient.CreateRole(ctx, req, opts...)
}

// UpdateRole updates the definition of a custom Role.
func (c *IamClient) UpdateRole(ctx context.Context, req *adminpb.UpdateRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	return c.internalClient.UpdateRole(ctx, req, opts...)
}

// DeleteRole deletes a custom Role.
//
// When you delete a custom role, the following changes occur immediately:
//
//	You cannot bind a principal to the custom role in an IAM
//	Policy.
//
//	Existing bindings to the custom role are not changed, but they have no
//	effect.
//
//	By default, the response from ListRoles does not include the custom
//	role.
//
// You have 7 days to undelete the custom role. After 7 days, the following
// changes occur:
//
//	The custom role is permanently deleted and cannot be recovered.
//
//	If an IAM policy contains a binding to the custom role, the binding is
//	permanently removed.
func (c *IamClient) DeleteRole(ctx context.Context, req *adminpb.DeleteRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	return c.internalClient.DeleteRole(ctx, req, opts...)
}

// UndeleteRole undeletes a custom Role.
func (c *IamClient) UndeleteRole(ctx context.Context, req *adminpb.UndeleteRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	return c.internalClient.UndeleteRole(ctx, req, opts...)
}

// QueryTestablePermissions lists every permission that you can test on a resource. A permission is
// testable if you can check whether a principal has that permission on the
// resource.
func (c *IamClient) QueryTestablePermissionsIter(ctx context.Context, req *adminpb.QueryTestablePermissionsRequest, opts ...gax.CallOption) *PermissionIterator {
	return c.internalClient.QueryTestablePermissionsIter(ctx, req, opts...)
}

// QueryAuditableServices returns a list of services that allow you to opt into audit logs that are
// not generated by default.
//
// To learn more about audit logs, see the Logging
// documentation (at https://cloud.google.com/logging/docs/audit).
func (c *IamClient) QueryAuditableServices(ctx context.Context, req *adminpb.QueryAuditableServicesRequest, opts ...gax.CallOption) (*adminpb.QueryAuditableServicesResponse, error) {
	return c.internalClient.QueryAuditableServices(ctx, req, opts...)
}

// LintPolicy lints, or validates, an IAM policy. Currently checks the
// google.iam.v1.Binding.condition field, which contains a condition
// expression for a role binding.
//
// Successful calls to this method always return an HTTP 200 OK status code,
// even if the linter detects an issue in the IAM policy.
func (c *IamClient) LintPolicy(ctx context.Context, req *adminpb.LintPolicyRequest, opts ...gax.CallOption) (*adminpb.LintPolicyResponse, error) {
	return c.internalClient.LintPolicy(ctx, req, opts...)
}

// iamGRPCClient is a client for interacting with Identity and Access Management (IAM) API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type iamGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing IamClient
	CallOptions **IamCallOptions

	// The gRPC API client.
	iamClient adminpb.IAMClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewIamClient creates a new iam client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Creates and manages Identity and Access Management (IAM) resources.
//
// You can use this service to work with all of the following resources:
//
//	Service accounts, which identify an application or a virtual machine
//	(VM) instance rather than a person
//
//	Service account keys, which service accounts use to authenticate with
//	Google APIs
//
//	IAM policies for service accounts, which specify the roles that a
//	principal has for the service account
//
//	IAM custom roles, which help you limit the number of permissions that
//	you grant to principals
//
// In addition, you can use this service to complete the following tasks, among
// others:
//
//	Test whether a service account can use specific permissions
//
//	Check which roles you can grant for a specific resource
//
//	Lint, or validate, condition expressions in an IAM policy
//
// When you read data from the IAM API, each read is eventually consistent. In
// other words, if you write data with the IAM API, then immediately read that
// data, the read operation might return an older version of the data. To deal
// with this behavior, your application can retry the request with truncated
// exponential backoff.
//
// In contrast, writing data to the IAM API is sequentially consistent. In other
// words, write operations are always processed in the order in which they were
// received.
func NewIamClient(ctx context.Context, opts ...option.ClientOption) (*IamClient, error) {
	clientOpts := defaultIamGRPCClientOptions()
	if newIamClientHook != nil {
		hookOpts, err := newIamClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := IamClient{CallOptions: defaultIamCallOptions()}

	c := &iamGRPCClient{
		connPool:    connPool,
		iamClient:   adminpb.NewIAMClient(connPool),
		CallOptions: &client.CallOptions,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *iamGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *iamGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *iamGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *iamGRPCClient) ListServiceAccounts(ctx context.Context, req *adminpb.ListServiceAccountsRequest, opts ...gax.CallOption) *ServiceAccountIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceAccounts[0:len((*c.CallOptions).ListServiceAccounts):len((*c.CallOptions).ListServiceAccounts)], opts...)
	it := &ServiceAccountIterator{}
	req = proto.Clone(req).(*adminpb.ListServiceAccountsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*adminpb.ServiceAccount, string, error) {
		resp := &adminpb.ListServiceAccountsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.iamClient.ListServiceAccounts, req, settings.GRPC, c.logger, "ListServiceAccounts")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccounts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *iamGRPCClient) GetServiceAccount(ctx context.Context, req *adminpb.GetServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceAccount[0:len((*c.CallOptions).GetServiceAccount):len((*c.CallOptions).GetServiceAccount)], opts...)
	var resp *adminpb.ServiceAccount
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.GetServiceAccount, req, settings.GRPC, c.logger, "GetServiceAccount")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) CreateServiceAccount(ctx context.Context, req *adminpb.CreateServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceAccount[0:len((*c.CallOptions).CreateServiceAccount):len((*c.CallOptions).CreateServiceAccount)], opts...)
	var resp *adminpb.ServiceAccount
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.CreateServiceAccount, req, settings.GRPC, c.logger, "CreateServiceAccount")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) UpdateServiceAccount(ctx context.Context, req *adminpb.ServiceAccount, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateServiceAccount[0:len((*c.CallOptions).UpdateServiceAccount):len((*c.CallOptions).UpdateServiceAccount)], opts...)
	var resp *adminpb.ServiceAccount
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.UpdateServiceAccount, req, settings.GRPC, c.logger, "UpdateServiceAccount")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) PatchServiceAccount(ctx context.Context, req *adminpb.PatchServiceAccountRequest, opts ...gax.CallOption) (*adminpb.ServiceAccount, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "service_account.name", url.QueryEscape(req.GetServiceAccount().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).PatchServiceAccount[0:len((*c.CallOptions).PatchServiceAccount):len((*c.CallOptions).PatchServiceAccount)], opts...)
	var resp *adminpb.ServiceAccount
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.PatchServiceAccount, req, settings.GRPC, c.logger, "PatchServiceAccount")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) DeleteServiceAccount(ctx context.Context, req *adminpb.DeleteServiceAccountRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceAccount[0:len((*c.CallOptions).DeleteServiceAccount):len((*c.CallOptions).DeleteServiceAccount)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.DeleteServiceAccount, req, settings.GRPC, c.logger, "DeleteServiceAccount")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) UndeleteServiceAccount(ctx context.Context, req *adminpb.UndeleteServiceAccountRequest, opts ...gax.CallOption) (*adminpb.UndeleteServiceAccountResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UndeleteServiceAccount[0:len((*c.CallOptions).UndeleteServiceAccount):len((*c.CallOptions).UndeleteServiceAccount)], opts...)
	var resp *adminpb.UndeleteServiceAccountResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.UndeleteServiceAccount, req, settings.GRPC, c.logger, "UndeleteServiceAccount")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) EnableServiceAccount(ctx context.Context, req *adminpb.EnableServiceAccountRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EnableServiceAccount[0:len((*c.CallOptions).EnableServiceAccount):len((*c.CallOptions).EnableServiceAccount)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.EnableServiceAccount, req, settings.GRPC, c.logger, "EnableServiceAccount")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) DisableServiceAccount(ctx context.Context, req *adminpb.DisableServiceAccountRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DisableServiceAccount[0:len((*c.CallOptions).DisableServiceAccount):len((*c.CallOptions).DisableServiceAccount)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.DisableServiceAccount, req, settings.GRPC, c.logger, "DisableServiceAccount")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) ListServiceAccountKeys(ctx context.Context, req *adminpb.ListServiceAccountKeysRequest, opts ...gax.CallOption) (*adminpb.ListServiceAccountKeysResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListServiceAccountKeys[0:len((*c.CallOptions).ListServiceAccountKeys):len((*c.CallOptions).ListServiceAccountKeys)], opts...)
	var resp *adminpb.ListServiceAccountKeysResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.ListServiceAccountKeys, req, settings.GRPC, c.logger, "ListServiceAccountKeys")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) GetServiceAccountKey(ctx context.Context, req *adminpb.GetServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetServiceAccountKey[0:len((*c.CallOptions).GetServiceAccountKey):len((*c.CallOptions).GetServiceAccountKey)], opts...)
	var resp *adminpb.ServiceAccountKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.GetServiceAccountKey, req, settings.GRPC, c.logger, "GetServiceAccountKey")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) CreateServiceAccountKey(ctx context.Context, req *adminpb.CreateServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateServiceAccountKey[0:len((*c.CallOptions).CreateServiceAccountKey):len((*c.CallOptions).CreateServiceAccountKey)], opts...)
	var resp *adminpb.ServiceAccountKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.CreateServiceAccountKey, req, settings.GRPC, c.logger, "CreateServiceAccountKey")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) UploadServiceAccountKey(ctx context.Context, req *adminpb.UploadServiceAccountKeyRequest, opts ...gax.CallOption) (*adminpb.ServiceAccountKey, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UploadServiceAccountKey[0:len((*c.CallOptions).UploadServiceAccountKey):len((*c.CallOptions).UploadServiceAccountKey)], opts...)
	var resp *adminpb.ServiceAccountKey
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.UploadServiceAccountKey, req, settings.GRPC, c.logger, "UploadServiceAccountKey")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) DeleteServiceAccountKey(ctx context.Context, req *adminpb.DeleteServiceAccountKeyRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteServiceAccountKey[0:len((*c.CallOptions).DeleteServiceAccountKey):len((*c.CallOptions).DeleteServiceAccountKey)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.DeleteServiceAccountKey, req, settings.GRPC, c.logger, "DeleteServiceAccountKey")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) DisableServiceAccountKey(ctx context.Context, req *adminpb.DisableServiceAccountKeyRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DisableServiceAccountKey[0:len((*c.CallOptions).DisableServiceAccountKey):len((*c.CallOptions).DisableServiceAccountKey)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.DisableServiceAccountKey, req, settings.GRPC, c.logger, "DisableServiceAccountKey")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) EnableServiceAccountKey(ctx context.Context, req *adminpb.EnableServiceAccountKeyRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EnableServiceAccountKey[0:len((*c.CallOptions).EnableServiceAccountKey):len((*c.CallOptions).EnableServiceAccountKey)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.iamClient.EnableServiceAccountKey, req, settings.GRPC, c.logger, "EnableServiceAccountKey")
		return err
	}, opts...)
	return err
}

func (c *iamGRPCClient) SignBlob(ctx context.Context, req *adminpb.SignBlobRequest, opts ...gax.CallOption) (*adminpb.SignBlobResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SignBlob[0:len((*c.CallOptions).SignBlob):len((*c.CallOptions).SignBlob)], opts...)
	var resp *adminpb.SignBlobResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.SignBlob, req, settings.GRPC, c.logger, "SignBlob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) SignJwt(ctx context.Context, req *adminpb.SignJwtRequest, opts ...gax.CallOption) (*adminpb.SignJwtResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SignJwt[0:len((*c.CallOptions).SignJwt):len((*c.CallOptions).SignJwt)], opts...)
	var resp *adminpb.SignJwtResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.SignJwt, req, settings.GRPC, c.logger, "SignJwt")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) getIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) setIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) GetRole(ctx context.Context, req *adminpb.GetRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetRole[0:len((*c.CallOptions).GetRole):len((*c.CallOptions).GetRole)], opts...)
	var resp *adminpb.Role
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.GetRole, req, settings.GRPC, c.logger, "GetRole")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) CreateRole(ctx context.Context, req *adminpb.CreateRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateRole[0:len((*c.CallOptions).CreateRole):len((*c.CallOptions).CreateRole)], opts...)
	var resp *adminpb.Role
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.CreateRole, req, settings.GRPC, c.logger, "CreateRole")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) UpdateRole(ctx context.Context, req *adminpb.UpdateRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateRole[0:len((*c.CallOptions).UpdateRole):len((*c.CallOptions).UpdateRole)], opts...)
	var resp *adminpb.Role
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.UpdateRole, req, settings.GRPC, c.logger, "UpdateRole")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) DeleteRole(ctx context.Context, req *adminpb.DeleteRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteRole[0:len((*c.CallOptions).DeleteRole):len((*c.CallOptions).DeleteRole)], opts...)
	var resp *adminpb.Role
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.DeleteRole, req, settings.GRPC, c.logger, "DeleteRole")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) UndeleteRole(ctx context.Context, req *adminpb.UndeleteRoleRequest, opts ...gax.CallOption) (*adminpb.Role, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UndeleteRole[0:len((*c.CallOptions).UndeleteRole):len((*c.CallOptions).UndeleteRole)], opts...)
	var resp *adminpb.Role
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.UndeleteRole, req, settings.GRPC, c.logger, "UndeleteRole")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) QueryAuditableServices(ctx context.Context, req *adminpb.QueryAuditableServicesRequest, opts ...gax.CallOption) (*adminpb.QueryAuditableServicesResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).QueryAuditableServices[0:len((*c.CallOptions).QueryAuditableServices):len((*c.CallOptions).QueryAuditableServices)], opts...)
	var resp *adminpb.QueryAuditableServicesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.QueryAuditableServices, req, settings.GRPC, c.logger, "QueryAuditableServices")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *iamGRPCClient) LintPolicy(ctx context.Context, req *adminpb.LintPolicyRequest, opts ...gax.CallOption) (*adminpb.LintPolicyResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).LintPolicy[0:len((*c.CallOptions).LintPolicy):len((*c.CallOptions).LintPolicy)], opts...)
	var resp *adminpb.LintPolicyResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamClient.LintPolicy, req, settings.GRPC, c.logger, "LintPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
