// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package chromemanagement provides access to the Chrome Management API.
//
// For product documentation, see: https://developers.google.com/chrome/management/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/chromemanagement/v1"
//	...
//	ctx := context.Background()
//	chromemanagementService, err := chromemanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	chromemanagementService, err := chromemanagement.NewService(ctx, option.WithScopes(chromemanagement.ChromeManagementTelemetryReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	chromemanagementService, err := chromemanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	chromemanagementService, err := chromemanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package chromemanagement // import "google.golang.org/api/chromemanagement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "chromemanagement:v1"
const apiName = "chromemanagement"
const apiVersion = "v1"
const basePath = "https://chromemanagement.googleapis.com/"
const basePathTemplate = "https://chromemanagement.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://chromemanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See detailed information about apps installed on Chrome browsers and devices
	// managed by your organization
	ChromeManagementAppdetailsReadonlyScope = "https://www.googleapis.com/auth/chrome.management.appdetails.readonly"

	// See, edit, delete, and take other necessary actions on Chrome browser
	// profiles managed by your organization
	ChromeManagementProfilesScope = "https://www.googleapis.com/auth/chrome.management.profiles"

	// See Chrome browser profiles managed by your organization
	ChromeManagementProfilesReadonlyScope = "https://www.googleapis.com/auth/chrome.management.profiles.readonly"

	// See reports about devices and Chrome browsers managed within your
	// organization
	ChromeManagementReportsReadonlyScope = "https://www.googleapis.com/auth/chrome.management.reports.readonly"

	// See basic device and telemetry information collected from ChromeOS devices
	// or users managed within your organization
	ChromeManagementTelemetryReadonlyScope = "https://www.googleapis.com/auth/chrome.management.telemetry.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/chrome.management.appdetails.readonly",
		"https://www.googleapis.com/auth/chrome.management.profiles",
		"https://www.googleapis.com/auth/chrome.management.profiles.readonly",
		"https://www.googleapis.com/auth/chrome.management.reports.readonly",
		"https://www.googleapis.com/auth/chrome.management.telemetry.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Customers = NewCustomersService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Apps = NewCustomersAppsService(s)
	rs.Profiles = NewCustomersProfilesService(s)
	rs.Reports = NewCustomersReportsService(s)
	rs.Telemetry = NewCustomersTelemetryService(s)
	rs.ThirdPartyProfileUsers = NewCustomersThirdPartyProfileUsersService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Apps *CustomersAppsService

	Profiles *CustomersProfilesService

	Reports *CustomersReportsService

	Telemetry *CustomersTelemetryService

	ThirdPartyProfileUsers *CustomersThirdPartyProfileUsersService
}

func NewCustomersAppsService(s *Service) *CustomersAppsService {
	rs := &CustomersAppsService{s: s}
	rs.Android = NewCustomersAppsAndroidService(s)
	rs.Chrome = NewCustomersAppsChromeService(s)
	rs.Web = NewCustomersAppsWebService(s)
	return rs
}

type CustomersAppsService struct {
	s *Service

	Android *CustomersAppsAndroidService

	Chrome *CustomersAppsChromeService

	Web *CustomersAppsWebService
}

func NewCustomersAppsAndroidService(s *Service) *CustomersAppsAndroidService {
	rs := &CustomersAppsAndroidService{s: s}
	return rs
}

type CustomersAppsAndroidService struct {
	s *Service
}

func NewCustomersAppsChromeService(s *Service) *CustomersAppsChromeService {
	rs := &CustomersAppsChromeService{s: s}
	return rs
}

type CustomersAppsChromeService struct {
	s *Service
}

func NewCustomersAppsWebService(s *Service) *CustomersAppsWebService {
	rs := &CustomersAppsWebService{s: s}
	return rs
}

type CustomersAppsWebService struct {
	s *Service
}

func NewCustomersProfilesService(s *Service) *CustomersProfilesService {
	rs := &CustomersProfilesService{s: s}
	rs.Commands = NewCustomersProfilesCommandsService(s)
	return rs
}

type CustomersProfilesService struct {
	s *Service

	Commands *CustomersProfilesCommandsService
}

func NewCustomersProfilesCommandsService(s *Service) *CustomersProfilesCommandsService {
	rs := &CustomersProfilesCommandsService{s: s}
	return rs
}

type CustomersProfilesCommandsService struct {
	s *Service
}

func NewCustomersReportsService(s *Service) *CustomersReportsService {
	rs := &CustomersReportsService{s: s}
	return rs
}

type CustomersReportsService struct {
	s *Service
}

func NewCustomersTelemetryService(s *Service) *CustomersTelemetryService {
	rs := &CustomersTelemetryService{s: s}
	rs.Devices = NewCustomersTelemetryDevicesService(s)
	rs.Events = NewCustomersTelemetryEventsService(s)
	rs.NotificationConfigs = NewCustomersTelemetryNotificationConfigsService(s)
	rs.Users = NewCustomersTelemetryUsersService(s)
	return rs
}

type CustomersTelemetryService struct {
	s *Service

	Devices *CustomersTelemetryDevicesService

	Events *CustomersTelemetryEventsService

	NotificationConfigs *CustomersTelemetryNotificationConfigsService

	Users *CustomersTelemetryUsersService
}

func NewCustomersTelemetryDevicesService(s *Service) *CustomersTelemetryDevicesService {
	rs := &CustomersTelemetryDevicesService{s: s}
	return rs
}

type CustomersTelemetryDevicesService struct {
	s *Service
}

func NewCustomersTelemetryEventsService(s *Service) *CustomersTelemetryEventsService {
	rs := &CustomersTelemetryEventsService{s: s}
	return rs
}

type CustomersTelemetryEventsService struct {
	s *Service
}

func NewCustomersTelemetryNotificationConfigsService(s *Service) *CustomersTelemetryNotificationConfigsService {
	rs := &CustomersTelemetryNotificationConfigsService{s: s}
	return rs
}

type CustomersTelemetryNotificationConfigsService struct {
	s *Service
}

func NewCustomersTelemetryUsersService(s *Service) *CustomersTelemetryUsersService {
	rs := &CustomersTelemetryUsersService{s: s}
	return rs
}

type CustomersTelemetryUsersService struct {
	s *Service
}

func NewCustomersThirdPartyProfileUsersService(s *Service) *CustomersThirdPartyProfileUsersService {
	rs := &CustomersThirdPartyProfileUsersService{s: s}
	return rs
}

type CustomersThirdPartyProfileUsersService struct {
	s *Service
}

// GoogleChromeManagementV1AndroidAppInfo: Android app information.
type GoogleChromeManagementV1AndroidAppInfo struct {
	// Permissions: Output only. Permissions requested by an Android app.
	Permissions []*GoogleChromeManagementV1AndroidAppPermission `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AndroidAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AndroidAppInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AndroidAppPermission: Permission requested by an
// Android app.
type GoogleChromeManagementV1AndroidAppPermission struct {
	// Type: Output only. The type of the permission.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AndroidAppPermission) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AndroidAppPermission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AppDetails: Resource representing app details.
type GoogleChromeManagementV1AppDetails struct {
	// AndroidAppInfo: Output only. Android app information.
	AndroidAppInfo *GoogleChromeManagementV1AndroidAppInfo `json:"androidAppInfo,omitempty"`
	// AppId: Output only. Unique store identifier for the item. Examples:
	// "gmbmikajjgmnabiglmofipeabaddhgne" for the Save to Google Drive Chrome
	// extension, "com.google.android.apps.docs" for the Google Drive Android app.
	AppId string `json:"appId,omitempty"`
	// ChromeAppInfo: Output only. Chrome Web Store app information.
	ChromeAppInfo *GoogleChromeManagementV1ChromeAppInfo `json:"chromeAppInfo,omitempty"`
	// Description: Output only. App's description.
	Description string `json:"description,omitempty"`
	// DetailUri: Output only. The uri for the detail page of the item.
	DetailUri string `json:"detailUri,omitempty"`
	// DisplayName: Output only. App's display name.
	DisplayName string `json:"displayName,omitempty"`
	// FirstPublishTime: Output only. First published time.
	FirstPublishTime string `json:"firstPublishTime,omitempty"`
	// HomepageUri: Output only. Home page or Website uri.
	HomepageUri string `json:"homepageUri,omitempty"`
	// IconUri: Output only. A link to an image that can be used as an icon for the
	// product.
	IconUri string `json:"iconUri,omitempty"`
	// IsPaidApp: Output only. Indicates if the app has to be paid for OR has paid
	// content.
	IsPaidApp bool `json:"isPaidApp,omitempty"`
	// LatestPublishTime: Output only. Latest published time.
	LatestPublishTime string `json:"latestPublishTime,omitempty"`
	// Name: Output only. Format:
	// name=customers/{customer_id}/apps/{chrome|android|web}/{app_id}@{version}
	Name string `json:"name,omitempty"`
	// PrivacyPolicyUri: Output only. The URI pointing to the privacy policy of the
	// app, if it was provided by the developer. Version-specific field that will
	// only be set when the requested app version is found.
	PrivacyPolicyUri string `json:"privacyPolicyUri,omitempty"`
	// Publisher: Output only. The publisher of the item.
	Publisher string `json:"publisher,omitempty"`
	// ReviewNumber: Output only. Number of reviews received. Chrome Web Store
	// review information will always be for the latest version of an app.
	ReviewNumber int64 `json:"reviewNumber,omitempty,string"`
	// ReviewRating: Output only. The rating of the app (on 5 stars). Chrome Web
	// Store review information will always be for the latest version of an app.
	ReviewRating float64 `json:"reviewRating,omitempty"`
	// RevisionId: Output only. App version. A new revision is committed whenever a
	// new version of the app is published.
	RevisionId string `json:"revisionId,omitempty"`
	// ServiceError: Output only. Information about a partial service error if
	// applicable.
	ServiceError *GoogleRpcStatus `json:"serviceError,omitempty"`
	// Type: Output only. App type.
	//
	// Possible values:
	//   "APP_ITEM_TYPE_UNSPECIFIED" - App type unspecified.
	//   "CHROME" - Chrome app.
	//   "ANDROID" - ARC++ app.
	//   "WEB" - Web app.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AndroidAppInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AndroidAppInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AppDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AppDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleChromeManagementV1AppDetails) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleChromeManagementV1AppDetails
	var s1 struct {
		ReviewRating gensupport.JSONFloat64 `json:"reviewRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ReviewRating = float64(s1.ReviewRating)
	return nil
}

// GoogleChromeManagementV1AppReport: App report.
type GoogleChromeManagementV1AppReport struct {
	// ReportTime: Timestamp when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// UsageData: App usage data.
	UsageData []*GoogleChromeManagementV1AppUsageData `json:"usageData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReportTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReportTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AppReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AppReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AppUsageData: App usage data.
type GoogleChromeManagementV1AppUsageData struct {
	// AppId: App id.
	AppId string `json:"appId,omitempty"`
	// AppInstanceId: Application instance id. This will be unique per
	// window/instance.
	AppInstanceId string `json:"appInstanceId,omitempty"`
	// AppType: Type of app.
	//
	// Possible values:
	//   "TELEMETRY_APPLICATION_TYPE_UNSPECIFIED" - Application type unknown.
	//   "APPLICATION_TYPE_ARC" - Application type arc (Android app).
	//   "APPLICATION_TYPE_BUILT_IN" - Deprecated. This value is no longer used.
	// Application type built-in.
	//   "APPLICATION_TYPE_CROSTINI" - Application type Linux (via Crostini).
	//   "APPLICATION_TYPE_CHROME_APP" - Application type Chrome app.
	//   "APPLICATION_TYPE_WEB" - Application type web.
	//   "APPLICATION_TYPE_MAC_OS" - Application type Mac OS.
	//   "APPLICATION_TYPE_PLUGIN_VM" - Application type Plugin VM.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER" - Deprecated. This value is no
	// longer used. Application type standalone browser (Lacros browser app).
	//   "APPLICATION_TYPE_REMOTE" - Application type remote.
	//   "APPLICATION_TYPE_BOREALIS" - Application type borealis.
	//   "APPLICATION_TYPE_SYSTEM_WEB" - Application type system web.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_CHROME_APP" - Deprecated. This value
	// is no longer used. Application type standalone browser chrome app.
	//   "APPLICATION_TYPE_EXTENSION" - Application type extension.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_EXTENSION" - Deprecated. This value
	// is no longer used. Application type standalone browser extension.
	//   "APPLICATION_TYPE_BRUSCHETTA" - Application type bruschetta.
	AppType string `json:"appType,omitempty"`
	// RunningDuration: App foreground running time.
	RunningDuration string `json:"runningDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AppUsageData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AppUsageData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1AudioStatusReport: Status data for storage. * This
// field is telemetry information and this will change over time as the device
// is utilized. * Data for this field is controlled via policy:
// ReportDeviceAudioStatus
// (https://chromeenterprise.google/policies/#ReportDeviceAudioStatus) * Data
// Collection Frequency: 10 minutes * Default Data Reporting Frequency: 3 hours
// - Policy Controlled: Yes * Cache: If the device is offline, the collected
// data is stored locally, and will be reported when the device is next online:
// No * Reported for affiliated users only: N/A * Granular permission needed:
// TELEMETRY_API_AUDIO_REPORT
type GoogleChromeManagementV1AudioStatusReport struct {
	// InputDevice: Output only. Active input device's name.
	InputDevice string `json:"inputDevice,omitempty"`
	// InputGain: Output only. Active input device's gain in [0, 100].
	InputGain int64 `json:"inputGain,omitempty"`
	// InputMute: Output only. Is active input device mute or not.
	InputMute bool `json:"inputMute,omitempty"`
	// OutputDevice: Output only. Active output device's name.
	OutputDevice string `json:"outputDevice,omitempty"`
	// OutputMute: Output only. Is active output device mute or not.
	OutputMute bool `json:"outputMute,omitempty"`
	// OutputVolume: Output only. Active output device's volume in [0, 100].
	OutputVolume int64 `json:"outputVolume,omitempty"`
	// ReportTime: Output only. Timestamp of when the sample was collected on
	// device.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputDevice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputDevice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1AudioStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1AudioStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1BatteryInfo: Information about the battery. * This
// field provides device information, which is static and will not change over
// time. * Data for this field is controlled via policy:
// ReportDevicePowerStatus
// (https://chromeenterprise.google/policies/#ReportDevicePowerStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_BATTERY_INFO
type GoogleChromeManagementV1BatteryInfo struct {
	// DesignCapacity: Output only. Design capacity (mAmpere-hours).
	DesignCapacity int64 `json:"designCapacity,omitempty,string"`
	// DesignMinVoltage: Output only. Designed minimum output voltage (mV)
	DesignMinVoltage int64 `json:"designMinVoltage,omitempty"`
	// ManufactureDate: Output only. The date the battery was manufactured.
	ManufactureDate *GoogleTypeDate `json:"manufactureDate,omitempty"`
	// Manufacturer: Output only. Battery manufacturer.
	Manufacturer string `json:"manufacturer,omitempty"`
	// SerialNumber: Output only. Battery serial number.
	SerialNumber string `json:"serialNumber,omitempty"`
	// Technology: Output only. Technology of the battery. Example: Li-ion
	Technology string `json:"technology,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DesignCapacity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DesignCapacity") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1BatteryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BatteryInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1BatterySampleReport: Sampling data for battery. *
// This field is telemetry information and this will change over time as the
// device is utilized. * Data for this field is controlled via policy:
// ReportDevicePowerStatus
// (https://chromeenterprise.google/policies/#ReportDevicePowerStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A
type GoogleChromeManagementV1BatterySampleReport struct {
	// ChargeRate: Output only. Battery charge percentage.
	ChargeRate int64 `json:"chargeRate,omitempty"`
	// Current: Output only. Battery current (mA).
	Current int64 `json:"current,omitempty,string"`
	// DischargeRate: Output only. The battery discharge rate measured in mW.
	// Positive if the battery is being discharged, negative if it's being charged.
	DischargeRate int64 `json:"dischargeRate,omitempty"`
	// RemainingCapacity: Output only. Battery remaining capacity (mAmpere-hours).
	RemainingCapacity int64 `json:"remainingCapacity,omitempty,string"`
	// ReportTime: Output only. Timestamp of when the sample was collected on
	// device
	ReportTime string `json:"reportTime,omitempty"`
	// Status: Output only. Battery status read from sysfs. Example: Discharging
	Status string `json:"status,omitempty"`
	// Temperature: Output only. Temperature in Celsius degrees.
	Temperature int64 `json:"temperature,omitempty"`
	// Voltage: Output only. Battery voltage (millivolt).
	Voltage int64 `json:"voltage,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ChargeRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChargeRate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1BatterySampleReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BatterySampleReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1BatteryStatusReport: Status data for battery. * This
// field is telemetry information and this will change over time as the device
// is utilized. * Data for this field is controlled via policy:
// ReportDevicePowerStatus
// (https://chromeenterprise.google/policies/#ReportDevicePowerStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_BATTERY_REPORT
type GoogleChromeManagementV1BatteryStatusReport struct {
	// BatteryHealth: Output only. Battery health.
	//
	// Possible values:
	//   "BATTERY_HEALTH_UNSPECIFIED" - Health unknown.
	//   "BATTERY_HEALTH_NORMAL" - Battery is healthy, full charge capacity /
	// design capacity > 80%
	//   "BATTERY_REPLACE_SOON" - Battery is moderately unhealthy and suggested to
	// be replaced soon, full charge capacity / design capacity 75% - 80%
	//   "BATTERY_REPLACE_NOW" - Battery is unhealthy and suggested to be replaced,
	// full charge capacity / design capacity < 75%
	BatteryHealth string `json:"batteryHealth,omitempty"`
	// CycleCount: Output only. Cycle count.
	CycleCount int64 `json:"cycleCount,omitempty"`
	// FullChargeCapacity: Output only. Full charge capacity (mAmpere-hours).
	FullChargeCapacity int64 `json:"fullChargeCapacity,omitempty,string"`
	// ReportTime: Output only. Timestamp of when the sample was collected on
	// device
	ReportTime string `json:"reportTime,omitempty"`
	// Sample: Output only. Sampling data for the battery sorted in a decreasing
	// order of report_time.
	Sample []*GoogleChromeManagementV1BatterySampleReport `json:"sample,omitempty"`
	// SerialNumber: Output only. Battery serial number.
	SerialNumber string `json:"serialNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatteryHealth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatteryHealth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1BatteryStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BatteryStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1BootPerformanceReport: Boot performance report of a
// device. * This field is telemetry information and this will change over time
// as the device is utilized. * Data for this field is controlled via policy:
// ReportDeviceBootMode
// (https://chromeenterprise.google/policies/#ReportDeviceBootMode) * Data
// Collection Frequency: On every boot up event * Default Data Reporting
// Frequency: 3 hours - Policy Controlled: Yes * Cache: If the device is
// offline, the collected data is stored locally, and will be reported when the
// device is next online: Yes * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_OS_REPORT
type GoogleChromeManagementV1BootPerformanceReport struct {
	// BootUpDuration: Total time to boot up.
	BootUpDuration string `json:"bootUpDuration,omitempty"`
	// BootUpTime: The timestamp when power came on.
	BootUpTime string `json:"bootUpTime,omitempty"`
	// ReportTime: Timestamp when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// ShutdownDuration: Total time since shutdown start to power off.
	ShutdownDuration string `json:"shutdownDuration,omitempty"`
	// ShutdownReason: The shutdown reason.
	//
	// Possible values:
	//   "SHUTDOWN_REASON_UNSPECIFIED" - Shutdown reason is not specified.
	//   "USER_REQUEST" - User initiated.
	//   "SYSTEM_UPDATE" - System update initiated.
	//   "LOW_BATTERY" - Shutdown due to low battery.
	//   "OTHER" - Shutdown due to other reasons.
	ShutdownReason string `json:"shutdownReason,omitempty"`
	// ShutdownTime: The timestamp when shutdown.
	ShutdownTime string `json:"shutdownTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootUpDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootUpDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1BootPerformanceReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BootPerformanceReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1BrowserVersion: Describes a browser version and its
// install count.
type GoogleChromeManagementV1BrowserVersion struct {
	// Channel: Output only. The release channel of the installed browser.
	//
	// Possible values:
	//   "RELEASE_CHANNEL_UNSPECIFIED" - No release channel specified.
	//   "CANARY" - Canary release channel.
	//   "DEV" - Dev release channel.
	//   "BETA" - Beta release channel.
	//   "STABLE" - Stable release channel.
	Channel string `json:"channel,omitempty"`
	// Count: Output only. Count grouped by device_system and major version
	Count int64 `json:"count,omitempty,string"`
	// DeviceOsVersion: Output only. Version of the system-specified operating
	// system.
	DeviceOsVersion string `json:"deviceOsVersion,omitempty"`
	// System: Output only. The device operating system.
	//
	// Possible values:
	//   "DEVICE_SYSTEM_UNSPECIFIED" - No operating system specified.
	//   "SYSTEM_OTHER" - Other operating system.
	//   "SYSTEM_ANDROID" - Android operating system.
	//   "SYSTEM_IOS" - Apple iOS operating system.
	//   "SYSTEM_CROS" - ChromeOS operating system.
	//   "SYSTEM_WINDOWS" - Microsoft Windows operating system.
	//   "SYSTEM_MAC" - Apple macOS operating system.
	//   "SYSTEM_LINUX" - Linux operating system.
	System string `json:"system,omitempty"`
	// Version: Output only. The full version of the installed browser.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1BrowserVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BrowserVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppInfo: Chrome Web Store app information.
type GoogleChromeManagementV1ChromeAppInfo struct {
	// GoogleOwned: Output only. Whether the app or extension is built and
	// maintained by Google. Version-specific field that will only be set when the
	// requested app version is found.
	GoogleOwned bool `json:"googleOwned,omitempty"`
	// IsCwsHosted: Output only. Whether the app or extension is in a published
	// state in the Chrome Web Store.
	IsCwsHosted bool `json:"isCwsHosted,omitempty"`
	// IsExtensionPolicySupported: Output only. Whether an app supports policy for
	// extensions.
	IsExtensionPolicySupported bool `json:"isExtensionPolicySupported,omitempty"`
	// IsKioskOnly: Output only. Whether the app is only for Kiosk mode on ChromeOS
	// devices
	IsKioskOnly bool `json:"isKioskOnly,omitempty"`
	// IsTheme: Output only. Whether the app or extension is a theme.
	IsTheme bool `json:"isTheme,omitempty"`
	// KioskEnabled: Output only. Whether this app is enabled for Kiosk mode on
	// ChromeOS devices
	KioskEnabled bool `json:"kioskEnabled,omitempty"`
	// ManifestVersion: Output only. The version of this extension's manifest.
	ManifestVersion int64 `json:"manifestVersion,omitempty,string"`
	// MinUserCount: Output only. The minimum number of users using this app.
	MinUserCount int64 `json:"minUserCount,omitempty"`
	// Permissions: Output only. Every custom permission requested by the app.
	// Version-specific field that will only be set when the requested app version
	// is found.
	Permissions []*GoogleChromeManagementV1ChromeAppPermission `json:"permissions,omitempty"`
	// SiteAccess: Output only. Every permission giving access to domains or broad
	// host patterns. ( e.g. www.google.com). This includes the matches from
	// content scripts as well as hosts in the permissions node of the manifest.
	// Version-specific field that will only be set when the requested app version
	// is found.
	SiteAccess []*GoogleChromeManagementV1ChromeAppSiteAccess `json:"siteAccess,omitempty"`
	// SupportEnabled: Output only. The app developer has enabled support for their
	// app. Version-specific field that will only be set when the requested app
	// version is found.
	SupportEnabled bool `json:"supportEnabled,omitempty"`
	// Type: Output only. Types of an item in the Chrome Web Store
	//
	// Possible values:
	//   "ITEM_TYPE_UNSPECIFIED" - Unspecified ItemType.
	//   "EXTENSION" - Chrome Extensions.
	//   "OTHERS" - Any other type than extension.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoogleOwned") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleOwned") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ChromeAppInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppPermission: Permission requested by a
// Chrome app or extension.
type GoogleChromeManagementV1ChromeAppPermission struct {
	// AccessUserData: Output only. If available, whether this permissions grants
	// the app/extension access to user data.
	AccessUserData bool `json:"accessUserData,omitempty"`
	// DocumentationUri: Output only. If available, a URI to a page that has
	// documentation for the current permission.
	DocumentationUri string `json:"documentationUri,omitempty"`
	// Type: Output only. The type of the permission.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessUserData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessUserData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ChromeAppPermission) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppPermission
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppRequest: Details of an app installation
// request.
type GoogleChromeManagementV1ChromeAppRequest struct {
	// AppDetails: Output only. Format:
	// app_details=customers/{customer_id}/apps/chrome/{app_id}
	AppDetails string `json:"appDetails,omitempty"`
	// AppId: Output only. Unique store identifier for the app. Example:
	// "gmbmikajjgmnabiglmofipeabaddhgne" for the Save to Google Drive Chrome
	// extension.
	AppId string `json:"appId,omitempty"`
	// DetailUri: Output only. The uri for the detail page of the item.
	DetailUri string `json:"detailUri,omitempty"`
	// DisplayName: Output only. App's display name.
	DisplayName string `json:"displayName,omitempty"`
	// IconUri: Output only. A link to an image that can be used as an icon for the
	// product.
	IconUri string `json:"iconUri,omitempty"`
	// LatestRequestTime: Output only. The timestamp of the most recently made
	// request for this app.
	LatestRequestTime string `json:"latestRequestTime,omitempty"`
	// RequestCount: Output only. Total count of requests for this app.
	RequestCount int64 `json:"requestCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AppDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppDetails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ChromeAppRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ChromeAppSiteAccess: Represent one host permission.
type GoogleChromeManagementV1ChromeAppSiteAccess struct {
	// HostMatch: Output only. This can contain very specific hosts, or patterns
	// like "*.com" for instance.
	HostMatch string `json:"hostMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HostMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HostMatch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ChromeAppSiteAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ChromeAppSiteAccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeAppRequestsResponse: Response containing
// summary of requested app installations.
type GoogleChromeManagementV1CountChromeAppRequestsResponse struct {
	// NextPageToken: Token to specify the next page in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RequestedApps: Count of requested apps matching request.
	RequestedApps []*GoogleChromeManagementV1ChromeAppRequest `json:"requestedApps,omitempty"`
	// TotalSize: Total number of matching app requests.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeAppRequestsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeAppRequestsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse:
// Response containing counts for browsers that need attention.
type GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse struct {
	// NoRecentActivityCount: Number of browsers that haven’t had any recent
	// activity
	NoRecentActivityCount int64 `json:"noRecentActivityCount,omitempty,string"`
	// PendingBrowserUpdateCount: Number of browsers that are pending an OS update
	PendingBrowserUpdateCount int64 `json:"pendingBrowserUpdateCount,omitempty,string"`
	// RecentlyEnrolledCount: Number of browsers that have been recently enrolled
	RecentlyEnrolledCount int64 `json:"recentlyEnrolledCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NoRecentActivityCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoRecentActivityCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeCrashEventsResponse: Response contains a
// list of CrashEventCountByVersionPerDay which count the chrome crash at the
// certain date.
type GoogleChromeManagementV1CountChromeCrashEventsResponse struct {
	// CrashEventCounts: Crash event counts grouped by date and browser version.
	CrashEventCounts []*GoogleChromeManagementV1CountChromeCrashEventsResponseCrashEventCount `json:"crashEventCounts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CrashEventCounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrashEventCounts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeCrashEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeCrashEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeCrashEventsResponseCrashEventCount: The
// `count` of the Chrome crash events at the `date`.
type GoogleChromeManagementV1CountChromeCrashEventsResponseCrashEventCount struct {
	// BrowserVersion: Browser version this is counting.
	BrowserVersion string `json:"browserVersion,omitempty"`
	// Count: Total count of crash events.
	Count int64 `json:"count,omitempty,string"`
	// Date: Date of the crash event.
	Date *GoogleTypeDate `json:"date,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BrowserVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrowserVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeCrashEventsResponseCrashEventCount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeCrashEventsResponseCrashEventCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse:
//
//	Response containing a list of devices expiring in each month of a selected
//
// time frame. Counts are grouped by model and Auto Update Expiration date.
type GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse struct {
	// DeviceAueCountReports: The list of reports sorted by auto update expiration
	// date in ascending order.
	DeviceAueCountReports []*GoogleChromeManagementV1DeviceAueCountReport `json:"deviceAueCountReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeviceAueCountReports") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceAueCountReports") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse:
// Response containing counts for devices that need attention.
type GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse struct {
	// NoRecentPolicySyncCount: Number of ChromeOS devices have not synced policies
	// in the past 28 days.
	NoRecentPolicySyncCount int64 `json:"noRecentPolicySyncCount,omitempty,string"`
	// NoRecentUserActivityCount: Number of ChromeOS devices that have not seen any
	// user activity in the past 28 days.
	NoRecentUserActivityCount int64 `json:"noRecentUserActivityCount,omitempty,string"`
	// OsVersionNotCompliantCount: Number of devices whose OS version is not
	// compliant.
	OsVersionNotCompliantCount int64 `json:"osVersionNotCompliantCount,omitempty,string"`
	// PendingUpdate: Number of devices that are pending an OS update.
	PendingUpdate int64 `json:"pendingUpdate,omitempty,string"`
	// UnsupportedPolicyCount: Number of devices that are unable to apply a policy
	// due to an OS version mismatch.
	UnsupportedPolicyCount int64 `json:"unsupportedPolicyCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NoRecentPolicySyncCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoRecentPolicySyncCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse: Response
// containing a list of devices with a specific type of hardware specification
// from the requested hardware type.
type GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse struct {
	// CpuReports: The DeviceHardwareCountReport for device cpu type (for example
	// Intel(R) Core(TM) i7-10610U CPU @ 1.80GHz).
	CpuReports []*GoogleChromeManagementV1DeviceHardwareCountReport `json:"cpuReports,omitempty"`
	// MemoryReports: The DeviceHardwareCountReport for device memory amount in
	// gigabytes (for example 16).
	MemoryReports []*GoogleChromeManagementV1DeviceHardwareCountReport `json:"memoryReports,omitempty"`
	// ModelReports: The DeviceHardwareCountReport for device model type (for
	// example Acer C7 Chromebook).
	ModelReports []*GoogleChromeManagementV1DeviceHardwareCountReport `json:"modelReports,omitempty"`
	// StorageReports: The DeviceHardwareCountReport for device storage amount in
	// gigabytes (for example 128).
	StorageReports []*GoogleChromeManagementV1DeviceHardwareCountReport `json:"storageReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CpuReports") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuReports") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeVersionsResponse: Response containing
// requested browser versions details and counts.
type GoogleChromeManagementV1CountChromeVersionsResponse struct {
	// BrowserVersions: List of all browser versions and their install counts.
	BrowserVersions []*GoogleChromeManagementV1BrowserVersion `json:"browserVersions,omitempty"`
	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total number browser versions matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BrowserVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrowserVersions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountChromeVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountInstalledAppsResponse: Response containing
// details of queried installed apps.
type GoogleChromeManagementV1CountInstalledAppsResponse struct {
	// InstalledApps: List of installed apps matching request.
	InstalledApps []*GoogleChromeManagementV1InstalledApp `json:"installedApps,omitempty"`
	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total number of installed apps matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InstalledApps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstalledApps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountInstalledAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountInstalledAppsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountPrintJobsByPrinterResponse: Response containing
// a summary printing report for each printer from the specified organizational
// unit for the requested time interval.
type GoogleChromeManagementV1CountPrintJobsByPrinterResponse struct {
	// NextPageToken: Pagination token for requesting the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PrinterReports: List of PrinterReports matching request.
	PrinterReports []*GoogleChromeManagementV1PrinterReport `json:"printerReports,omitempty"`
	// TotalSize: Total number of printers matching request.
	TotalSize int64 `json:"totalSize,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountPrintJobsByPrinterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountPrintJobsByPrinterResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountPrintJobsByUserResponse: Response containing a
// summary printing report for each user that has initiated a print job with a
// printer from the specified organizational unit during the requested time
// interval.
type GoogleChromeManagementV1CountPrintJobsByUserResponse struct {
	// NextPageToken: Pagination token for requesting the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total number of users matching request.
	TotalSize int64 `json:"totalSize,omitempty,string"`
	// UserPrintReports: List of UserPrintReports matching request.
	UserPrintReports []*GoogleChromeManagementV1UserPrintReport `json:"userPrintReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CountPrintJobsByUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountPrintJobsByUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CpuInfo: CPU specifications for the device * This
// field provides device information, which is static and will not change over
// time. * Data for this field is controlled via policy: ReportDeviceCpuInfo
// (https://chromeenterprise.google/policies/#ReportDeviceCpuInfo) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_CPU_INFO
type GoogleChromeManagementV1CpuInfo struct {
	// Architecture: Output only. Architecture type for the CPU. * This field
	// provides device information, which is static and will not change over time.
	// * Data for this field is controlled via policy: ReportDeviceCpuInfo
	// (https://chromeenterprise.google/policies/#ReportDeviceCpuInfo) * Data
	// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
	// hours - Policy Controlled: Yes * Cache: If the device is offline, the
	// collected data is stored locally, and will be reported when the device is
	// next online: No * Reported for affiliated users only: N/A
	//
	// Possible values:
	//   "ARCHITECTURE_UNSPECIFIED" - Architecture unknown.
	//   "X64" - x64 architecture
	Architecture string `json:"architecture,omitempty"`
	// KeylockerConfigured: Output only. Whether keylocker is configured.`TRUE` =
	// Enabled; `FALSE` = disabled. Only reported if keylockerSupported = `TRUE`.
	KeylockerConfigured bool `json:"keylockerConfigured,omitempty"`
	// KeylockerSupported: Output only. Whether keylocker is supported.
	KeylockerSupported bool `json:"keylockerSupported,omitempty"`
	// MaxClockSpeed: Output only. The max CPU clock speed in kHz.
	MaxClockSpeed int64 `json:"maxClockSpeed,omitempty"`
	// Model: Output only. The CPU model name. Example: Intel(R) Core(TM) i5-8250U
	// CPU @ 1.60GHz
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Architecture") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CpuInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CpuInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CpuStatusReport: Provides information about the
// status of the CPU. * This field is telemetry information and this will
// change over time as the device is utilized. * Data for this field is
// controlled via policy: ReportDeviceCpuInfo
// (https://chromeenterprise.google/policies/#ReportDeviceCpuInfo) * Data
// Collection Frequency: Every 10 minutes * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_CPU_REPORT
type GoogleChromeManagementV1CpuStatusReport struct {
	// CpuTemperatureInfo: Output only. CPU temperature sample info per CPU core in
	// Celsius
	CpuTemperatureInfo []*GoogleChromeManagementV1CpuTemperatureInfo `json:"cpuTemperatureInfo,omitempty"`
	// CpuUtilizationPct: Output only. Sample of CPU utilization (0-100 percent).
	CpuUtilizationPct int64 `json:"cpuUtilizationPct,omitempty"`
	// ReportTime: Output only. The timestamp in milliseconds representing time at
	// which this report was sampled.
	ReportTime string `json:"reportTime,omitempty"`
	// SampleFrequency: Output only. Frequency the report is sampled.
	SampleFrequency string `json:"sampleFrequency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuTemperatureInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuTemperatureInfo") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CpuStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CpuStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CpuTemperatureInfo: CPU temperature of a device.
// Sampled per CPU core in Celsius. * This field is telemetry information and
// this will change over time as the device is utilized. * Data for this field
// is controlled via policy: ReportDeviceCpuInfo
// (https://chromeenterprise.google/policies/#ReportDeviceCpuInfo) * Data
// Collection Frequency: Every 10 minutes * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A
type GoogleChromeManagementV1CpuTemperatureInfo struct {
	// Label: Output only. CPU label. Example: Core 0
	Label string `json:"label,omitempty"`
	// TemperatureCelsius: Output only. CPU temperature in Celsius.
	TemperatureCelsius int64 `json:"temperatureCelsius,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Label") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Label") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1CpuTemperatureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CpuTemperatureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1Device: Describes a device reporting Chrome browser
// information.
type GoogleChromeManagementV1Device struct {
	// DeviceId: Output only. The ID of the device that reported this Chrome
	// browser information.
	DeviceId string `json:"deviceId,omitempty"`
	// Machine: Output only. The name of the machine within its local network.
	Machine string `json:"machine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1Device) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1Device
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DeviceActivityReport: Device activity report. *
// Granular permission needed: TELEMETRY_API_DEVICE_ACTIVITY_REPORT
type GoogleChromeManagementV1DeviceActivityReport struct {
	// DeviceActivityState: Output only. Device activity state.
	//
	// Possible values:
	//   "DEVICE_ACTIVITY_STATE_UNSPECIFIED" - Device activity state is
	// unspecified.
	//   "ACTIVE" - Device is currently being used.
	//   "IDLE" - Device is currently idle.
	//   "LOCKED" - Device is currently locked.
	DeviceActivityState string `json:"deviceActivityState,omitempty"`
	// ReportTime: Output only. Timestamp of when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceActivityState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceActivityState") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DeviceActivityReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DeviceActivityReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DeviceAueCountReport: Report for
// CountChromeDevicesPerAueDateResponse, contains the count of devices of a
// specific model and auto update expiration range.
type GoogleChromeManagementV1DeviceAueCountReport struct {
	// AueMonth: Enum value of month corresponding to the auto update expiration
	// date in UTC time zone. If the device is already expired, this field is
	// empty.
	//
	// Possible values:
	//   "MONTH_UNSPECIFIED" - The unspecified month.
	//   "JANUARY" - The month of January.
	//   "FEBRUARY" - The month of February.
	//   "MARCH" - The month of March.
	//   "APRIL" - The month of April.
	//   "MAY" - The month of May.
	//   "JUNE" - The month of June.
	//   "JULY" - The month of July.
	//   "AUGUST" - The month of August.
	//   "SEPTEMBER" - The month of September.
	//   "OCTOBER" - The month of October.
	//   "NOVEMBER" - The month of November.
	//   "DECEMBER" - The month of December.
	AueMonth string `json:"aueMonth,omitempty"`
	// AueYear: Int value of year corresponding to the Auto Update Expiration date
	// in UTC time zone. If the device is already expired, this field is empty.
	AueYear int64 `json:"aueYear,omitempty,string"`
	// Count: Count of devices of this model.
	Count int64 `json:"count,omitempty,string"`
	// Expired: Boolean value for whether or not the device has already expired.
	Expired bool `json:"expired,omitempty"`
	// Model: Public model name of the devices.
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AueMonth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AueMonth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DeviceAueCountReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DeviceAueCountReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DeviceHardwareCountReport: Report for
// CountChromeDevicesPerHardwareSpecResponse, contains the count of devices
// with a unique hardware specification.
type GoogleChromeManagementV1DeviceHardwareCountReport struct {
	// Bucket: Public name of the hardware specification.
	Bucket string `json:"bucket,omitempty"`
	// Count: Count of devices with a unique hardware specification.
	Count int64 `json:"count,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DeviceHardwareCountReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DeviceHardwareCountReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DeviceRequestingExtensionDetails: Details of a
// device requesting an extension, including the name of the device and the
// justification of the request.
type GoogleChromeManagementV1DeviceRequestingExtensionDetails struct {
	// DeviceName: The name of a device that has requested the extension.
	DeviceName string `json:"deviceName,omitempty"`
	// Justification: Request justification as entered by the user.
	Justification string `json:"justification,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DeviceRequestingExtensionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DeviceRequestingExtensionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DiskInfo: Status of the single storage device.
type GoogleChromeManagementV1DiskInfo struct {
	// BytesReadThisSession: Output only. Number of bytes read since last boot.
	BytesReadThisSession int64 `json:"bytesReadThisSession,omitempty,string"`
	// BytesWrittenThisSession: Output only. Number of bytes written since last
	// boot.
	BytesWrittenThisSession int64 `json:"bytesWrittenThisSession,omitempty,string"`
	// DiscardTimeThisSession: Output only. Time spent discarding since last boot.
	// Discarding is writing to clear blocks which are no longer in use. Supported
	// on kernels 4.18+.
	DiscardTimeThisSession string `json:"discardTimeThisSession,omitempty"`
	// Health: Output only. Disk health.
	Health string `json:"health,omitempty"`
	// IoTimeThisSession: Output only. Counts the time the disk and queue were
	// busy, so unlike the fields above, parallel requests are not counted multiple
	// times.
	IoTimeThisSession string `json:"ioTimeThisSession,omitempty"`
	// Manufacturer: Output only. Disk manufacturer.
	Manufacturer string `json:"manufacturer,omitempty"`
	// Model: Output only. Disk model.
	Model string `json:"model,omitempty"`
	// ReadTimeThisSession: Output only. Time spent reading from disk since last
	// boot.
	ReadTimeThisSession string `json:"readTimeThisSession,omitempty"`
	// SerialNumber: Output only. Disk serial number.
	SerialNumber string `json:"serialNumber,omitempty"`
	// SizeBytes: Output only. Disk size.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`
	// Type: Output only. Disk type: eMMC / NVMe / ATA / SCSI.
	Type string `json:"type,omitempty"`
	// VolumeIds: Output only. Disk volumes.
	VolumeIds []string `json:"volumeIds,omitempty"`
	// WriteTimeThisSession: Output only. Time spent writing to disk since last
	// boot.
	WriteTimeThisSession string `json:"writeTimeThisSession,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesReadThisSession") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesReadThisSession") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DiskInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DiskInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DisplayDevice: Information of a display device.
type GoogleChromeManagementV1DisplayDevice struct {
	// DisplayHeightMm: Output only. Display height in millimeters.
	DisplayHeightMm int64 `json:"displayHeightMm,omitempty"`
	// DisplayName: Output only. Display device name.
	DisplayName string `json:"displayName,omitempty"`
	// DisplayWidthMm: Output only. Display width in millimeters.
	DisplayWidthMm int64 `json:"displayWidthMm,omitempty"`
	// EdidVersion: Output only. EDID version.
	EdidVersion string `json:"edidVersion,omitempty"`
	// Internal: Output only. Is display internal or not.
	Internal bool `json:"internal,omitempty"`
	// ManufactureYear: Output only. Year of manufacture.
	ManufactureYear int64 `json:"manufactureYear,omitempty"`
	// ManufacturerId: Output only. Three letter manufacturer ID.
	ManufacturerId string `json:"manufacturerId,omitempty"`
	// ModelId: Output only. Manufacturer product code.
	ModelId int64 `json:"modelId,omitempty"`
	// SerialNumber: Output only. Serial number.
	SerialNumber int64 `json:"serialNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayHeightMm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayHeightMm") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DisplayDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DisplayDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1DisplayInfo: Information for a display.
type GoogleChromeManagementV1DisplayInfo struct {
	// DeviceId: Output only. Represents the graphics card device id.
	DeviceId int64 `json:"deviceId,omitempty,string"`
	// DisplayName: Output only. Display device name.
	DisplayName string `json:"displayName,omitempty"`
	// EdidVersion: Output only. EDID version.
	EdidVersion string `json:"edidVersion,omitempty"`
	// IsInternal: Output only. Indicates if display is internal or not.
	IsInternal bool `json:"isInternal,omitempty"`
	// RefreshRate: Output only. Refresh rate in Hz.
	RefreshRate int64 `json:"refreshRate,omitempty"`
	// ResolutionHeight: Output only. Resolution height in pixels.
	ResolutionHeight int64 `json:"resolutionHeight,omitempty"`
	// ResolutionWidth: Output only. Resolution width in pixels.
	ResolutionWidth int64 `json:"resolutionWidth,omitempty"`
	// SerialNumber: Output only. Serial number.
	SerialNumber int64 `json:"serialNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1DisplayInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1DisplayInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1EnumeratePrintJobsResponse: Response containing a
// list of print jobs.
type GoogleChromeManagementV1EnumeratePrintJobsResponse struct {
	// NextPageToken: A token, which can be used in a subsequent request to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PrintJobs: List of requested print jobs.
	PrintJobs []*GoogleChromeManagementV1PrintJob `json:"printJobs,omitempty"`
	// TotalSize: Total number of print jobs matching request.
	TotalSize int64 `json:"totalSize,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1EnumeratePrintJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1EnumeratePrintJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse: Response
// containing a list of devices that have requested the queried extension.
type GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse struct {
	// DeviceDetails: Details of devices that have requested the queried extension.
	DeviceDetails []*GoogleChromeManagementV1DeviceRequestingExtensionDetails `json:"deviceDetails,omitempty"`
	// NextPageToken: Optional. Token to specify the next page in the list. Token
	// expires after 1 day.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Optional. Total number of devices in response.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeviceDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceDetails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1FetchUsersRequestingExtensionResponse: Response
// containing a list of users that have requested the queried extension.
type GoogleChromeManagementV1FetchUsersRequestingExtensionResponse struct {
	// NextPageToken: Token to specify the next page in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total number of users in response.
	TotalSize int64 `json:"totalSize,omitempty"`
	// UserDetails: Details of users that have requested the queried extension.
	UserDetails []*GoogleChromeManagementV1UserRequestingExtensionDetails `json:"userDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1FetchUsersRequestingExtensionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1FetchUsersRequestingExtensionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1FindInstalledAppDevicesResponse: Response containing
// a list of devices with queried app installed.
type GoogleChromeManagementV1FindInstalledAppDevicesResponse struct {
	// Devices: A list of devices which have the app installed. Sorted in ascending
	// alphabetical order on the Device.machine field.
	Devices []*GoogleChromeManagementV1Device `json:"devices,omitempty"`
	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total number of devices matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Devices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Devices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1FindInstalledAppDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1FindInstalledAppDevicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1GraphicsAdapterInfo: Information of a graphics
// adapter (GPU).
type GoogleChromeManagementV1GraphicsAdapterInfo struct {
	// Adapter: Output only. Adapter name. Example: Mesa DRI Intel(R) UHD Graphics
	// 620 (Kabylake GT2).
	Adapter string `json:"adapter,omitempty"`
	// DeviceId: Output only. Represents the graphics card device id.
	DeviceId int64 `json:"deviceId,omitempty,string"`
	// DriverVersion: Output only. Version of the GPU driver.
	DriverVersion string `json:"driverVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Adapter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Adapter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1GraphicsAdapterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1GraphicsAdapterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1GraphicsInfo: Information of the graphics subsystem.
// * This field provides device information, which is static and will not
// change over time. * Data for this field is controlled via policy:
// ReportDeviceGraphicsStatus
// (https://chromeenterprise.google/policies/#ReportDeviceGraphicsStatus) *
// Data Collection Frequency: Only at Upload * Default Data Reporting
// Frequency: 3 hours - Policy Controlled: Yes * Cache: If the device is
// offline, the collected data is stored locally, and will be reported when the
// device is next online: No * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_GRAPHICS_INFO
type GoogleChromeManagementV1GraphicsInfo struct {
	// AdapterInfo: Output only. Information about the graphics adapter (GPU).
	AdapterInfo *GoogleChromeManagementV1GraphicsAdapterInfo `json:"adapterInfo,omitempty"`
	// DisplayDevices: Output only. Information about the display(s) of the device.
	DisplayDevices []*GoogleChromeManagementV1DisplayDevice `json:"displayDevices,omitempty"`
	// EprivacySupported: Output only. Is ePrivacy screen supported or not.
	EprivacySupported bool `json:"eprivacySupported,omitempty"`
	// TouchScreenInfo: Output only. Information about the internal touch screen(s)
	// of the device.
	TouchScreenInfo *GoogleChromeManagementV1TouchScreenInfo `json:"touchScreenInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdapterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdapterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1GraphicsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1GraphicsInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1GraphicsStatusReport: Information of the graphics
// subsystem. * This field is telemetry information and this will change over
// time as the device is utilized. * Data for this field is controlled via
// policy: ReportDeviceGraphicsInfo
// (https://chromeenterprise.google/policies/#ReportDeviceGraphicsInfo) * Data
// Collection Frequency: 3 hours. * Default Data Reporting Frequency: 3 hours -
// Policy Controlled: Yes * Cache: If the device is offline, the collected data
// is stored locally, and will be reported when the device is next online: No *
// Reported for affiliated users only: N/A * Granular permission needed:
// TELEMETRY_API_GRAPHICS_REPORT
type GoogleChromeManagementV1GraphicsStatusReport struct {
	// Displays: Output only. Information about the displays for the device.
	Displays []*GoogleChromeManagementV1DisplayInfo `json:"displays,omitempty"`
	// ReportTime: Output only. Time at which the graphics data was reported.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Displays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Displays") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1GraphicsStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1GraphicsStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1HeartbeatStatusReport: Heartbeat status report of a
// device. * Available for Kiosks * This field provides online/offline/unknown
// status of a device and will only be included if the status has changed (e.g.
// Online -> Offline) * Data for this field is controlled via policy:
// HeartbeatEnabled
// (https://chromeenterprise.google/policies/#HeartbeatEnabled) [More
// Info](https://support.google.com/chrome/a/answer/6179663#:~:text=On%20the%20C
// hrome,device%20status%20alerts) * Heartbeat Frequency: 2 mins * Note: If a
// device goes offline, it can take up to 12 minutes for the online status of
// the device to be updated * Cache: If the device is offline, the collected
// data is stored locally, and will be reported when the device is next online:
// N/A * Reported for affiliated users only: N/A * Granular permission needed:
// TELEMETRY_API_DEVICE_ACTIVITY_REPORT
type GoogleChromeManagementV1HeartbeatStatusReport struct {
	// ReportTime: Timestamp of when status changed was detected
	ReportTime string `json:"reportTime,omitempty"`
	// State: State the device changed to
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State not specified
	//   "UNKNOWN" - Device is not eligible for heartbeat monitoring
	//   "ONLINE" - Device is online
	//   "OFFLINE" - Device is offline
	//   "DEVICE_OUTDATED" - Device is outdated
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReportTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReportTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1HeartbeatStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1HeartbeatStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1HttpsLatencyRoutineData: Data that describes the
// result of the HTTPS latency diagnostics routine, with the HTTPS requests
// issued to Google websites.
type GoogleChromeManagementV1HttpsLatencyRoutineData struct {
	// Latency: Output only. HTTPS latency if routine succeeded or failed because
	// of HIGH_LATENCY or VERY_HIGH_LATENCY.
	Latency string `json:"latency,omitempty"`
	// Problem: Output only. HTTPS latency routine problem if a problem occurred.
	//
	// Possible values:
	//   "HTTPS_LATENCY_PROBLEM_UNSPECIFIED" - HTTPS latency problem not specified.
	//   "FAILED_DNS_RESOLUTIONS" - One or more DNS resolutions resulted in a
	// failure.
	//   "FAILED_HTTPS_REQUESTS" - One or more HTTPS requests resulted in a
	// failure.
	//   "HIGH_LATENCY" - Average HTTPS request latency time between 500ms and
	// 1000ms is high.
	//   "VERY_HIGH_LATENCY" - Average HTTPS request latency time greater than
	// 1000ms is very high.
	Problem string `json:"problem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latency") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1HttpsLatencyRoutineData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1HttpsLatencyRoutineData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1InstalledApp: Describes an installed app.
type GoogleChromeManagementV1InstalledApp struct {
	// AppId: Output only. Unique identifier of the app. For Chrome apps and
	// extensions, the 32-character id (e.g. ehoadneljpdggcbbknedodolkkjodefl). For
	// Android apps, the package name (e.g. com.evernote).
	AppId string `json:"appId,omitempty"`
	// AppInstallType: Output only. How the app was installed.
	//
	// Possible values:
	//   "APP_INSTALL_TYPE_UNSPECIFIED" - Application install type not specified.
	//   "MULTIPLE" - Multiple app install types.
	//   "NORMAL" - Normal app install type.
	//   "ADMIN" - Administrator app install type.
	//   "DEVELOPMENT" - Development app install type.
	//   "SIDELOAD" - Sideloaded app install type.
	//   "OTHER" - Other app install type.
	AppInstallType string `json:"appInstallType,omitempty"`
	// AppSource: Output only. Source of the installed app.
	//
	// Possible values:
	//   "APP_SOURCE_UNSPECIFIED" - Application source not specified.
	//   "CHROME_WEBSTORE" - Generally for extensions and Chrome apps.
	//   "PLAY_STORE" - Play Store app.
	AppSource string `json:"appSource,omitempty"`
	// AppType: Output only. Type of the app.
	//
	// Possible values:
	//   "APP_TYPE_UNSPECIFIED" - App type not specified.
	//   "EXTENSION" - Chrome extension.
	//   "APP" - Chrome app.
	//   "THEME" - Chrome theme.
	//   "HOSTED_APP" - Chrome hosted app.
	//   "ANDROID_APP" - ARC++ app.
	AppType string `json:"appType,omitempty"`
	// BrowserDeviceCount: Output only. Count of browser devices with this app
	// installed.
	BrowserDeviceCount int64 `json:"browserDeviceCount,omitempty,string"`
	// Description: Output only. Description of the installed app.
	Description string `json:"description,omitempty"`
	// Disabled: Output only. Whether the app is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Output only. Name of the installed app.
	DisplayName string `json:"displayName,omitempty"`
	// HomepageUri: Output only. Homepage uri of the installed app.
	HomepageUri string `json:"homepageUri,omitempty"`
	// OsUserCount: Output only. Count of ChromeOS users with this app installed.
	OsUserCount int64 `json:"osUserCount,omitempty,string"`
	// Permissions: Output only. Permissions of the installed app.
	Permissions []string `json:"permissions,omitempty"`
	// RiskAssessment: Output only. If available, the risk assessment data about
	// this extension.
	RiskAssessment *GoogleChromeManagementV1RiskAssessmentData `json:"riskAssessment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1InstalledApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1InstalledApp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1KioskAppStatusReport: Kiosk app status report of a
// device. * Available for Kiosks * This field provides the app id and version
// number running on a kiosk device and the timestamp of when the report was
// last updated * Data for this field is controlled via policy:
// ReportDeviceSessionStatus
// (https://chromeenterprise.google/policies/#ReportDeviceSessionStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_APPS_REPORT
type GoogleChromeManagementV1KioskAppStatusReport struct {
	// AppId: App id of kiosk app for example "mdmkkicfmmkgmpkmkdikhlbggogpicma"
	AppId string `json:"appId,omitempty"`
	// AppVersion: App version number of kiosk app for example "1.10.118"
	AppVersion string `json:"appVersion,omitempty"`
	// ReportTime: Timestamp of when report was collected
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1KioskAppStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1KioskAppStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleChromeManagementV1ListTelemetryDevicesResponse struct {
	// Devices: Telemetry devices returned in the response.
	Devices []*GoogleChromeManagementV1TelemetryDevice `json:"devices,omitempty"`
	// NextPageToken: Token to specify next page in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Devices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Devices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ListTelemetryDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ListTelemetryDevicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ListTelemetryEventsResponse: Response message for
// listing telemetry events for a customer.
type GoogleChromeManagementV1ListTelemetryEventsResponse struct {
	// NextPageToken: Token to specify next page in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TelemetryEvents: Telemetry events returned in the response.
	TelemetryEvents []*GoogleChromeManagementV1TelemetryEvent `json:"telemetryEvents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ListTelemetryEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ListTelemetryEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse: Response
// message for listing notification configs for a customer.
type GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TelemetryNotificationConfigs: The telemetry notification configs from the
	// specified customer.
	TelemetryNotificationConfigs []*GoogleChromeManagementV1TelemetryNotificationConfig `json:"telemetryNotificationConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ListTelemetryUsersResponse: Response message for
// listing telemetry users for a customer.
type GoogleChromeManagementV1ListTelemetryUsersResponse struct {
	// NextPageToken: Token to specify next page in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TelemetryUsers: Telemetry users returned in the response.
	TelemetryUsers []*GoogleChromeManagementV1TelemetryUser `json:"telemetryUsers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ListTelemetryUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ListTelemetryUsersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1MemoryInfo: Memory information of a device. * This
// field has both telemetry and device information: - `totalRamBytes` - Device
// information - `availableRamBytes` - Telemetry information -
// `totalMemoryEncryption` - Device information * Data for this field is
// controlled via policy: ReportDeviceMemoryInfo
// (https://chromeenterprise.google/policies/#ReportDeviceMemoryInfo) * Data
// Collection Frequency: - `totalRamBytes` - Only at upload -
// `availableRamBytes` - Every 10 minutes - `totalMemoryEncryption` - at device
// startup * Default Data Reporting Frequency: - `totalRamBytes` - 3 hours -
// `availableRamBytes` - 3 hours - `totalMemoryEncryption` - at device startup
// - Policy Controlled: Yes * Cache: If the device is offline, the collected
// data is stored locally, and will be reported when the device is next online:
// only for `totalMemoryEncryption` * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_MEMORY_INFO
type GoogleChromeManagementV1MemoryInfo struct {
	// AvailableRamBytes: Output only. Amount of available RAM in bytes.
	AvailableRamBytes int64 `json:"availableRamBytes,omitempty,string"`
	// TotalMemoryEncryption: Output only. Total memory encryption info for the
	// device.
	TotalMemoryEncryption *GoogleChromeManagementV1TotalMemoryEncryptionInfo `json:"totalMemoryEncryption,omitempty"`
	// TotalRamBytes: Output only. Total RAM in bytes.
	TotalRamBytes int64 `json:"totalRamBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AvailableRamBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableRamBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1MemoryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1MemoryInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1MemoryStatusReport: Contains samples of memory
// status reports. * This field is telemetry information and this will change
// over time as the device is utilized. * Data for this field is controlled via
// policy: ReportDeviceMemoryInfo
// (https://chromeenterprise.google/policies/#ReportDeviceMemoryInfo) * Data
// Collection Frequency: Only at upload, SystemRamFreeByes is collected every
// 10 minutes * Default Data Reporting Frequency: Every 3 hours - Policy
// Controlled: Yes * Cache: If the device is offline, the collected data is
// stored locally, and will be reported when the device is next online: No *
// Reported for affiliated users only: N/A * Granular permission needed:
// TELEMETRY_API_MEMORY_REPORT
type GoogleChromeManagementV1MemoryStatusReport struct {
	// PageFaults: Output only. Number of page faults during this collection
	PageFaults int64 `json:"pageFaults,omitempty"`
	// ReportTime: Output only. The timestamp in milliseconds representing time at
	// which this report was sampled.
	ReportTime string `json:"reportTime,omitempty"`
	// SampleFrequency: Output only. Frequency the report is sampled.
	SampleFrequency string `json:"sampleFrequency,omitempty"`
	// SystemRamFreeBytes: Output only. Amount of free RAM in bytes (unreliable due
	// to Garbage Collection).
	SystemRamFreeBytes int64 `json:"systemRamFreeBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PageFaults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageFaults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1MemoryStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1MemoryStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1NetworkBandwidthReport: Network bandwidth report. *
// Granular permission needed: TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1NetworkBandwidthReport struct {
	// DownloadSpeedKbps: Output only. Download speed in kilobits per second.
	DownloadSpeedKbps int64 `json:"downloadSpeedKbps,omitempty,string"`
	// ReportTime: Output only. Timestamp of when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DownloadSpeedKbps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DownloadSpeedKbps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1NetworkBandwidthReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1NetworkBandwidthReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1NetworkDevice: Details about the network device. *
// This field provides device information, which is static and will not change
// over time. * Data for this field is controlled via policy:
// ReportNetworkDeviceConfiguration
// (https://chromeenterprise.google/policies/#ReportNetworkDeviceConfiguration)
// * Data Collection Frequency: At device startup * Default Data Reporting
// Frequency: At device startup - Policy Controlled: Yes * Cache: If the device
// is offline, the collected data is stored locally, and will be reported when
// the device is next online: Yes * Reported for affiliated users only: N/A
type GoogleChromeManagementV1NetworkDevice struct {
	// Iccid: Output only. The integrated circuit card ID associated with the
	// device's sim card.
	Iccid string `json:"iccid,omitempty"`
	// Imei: Output only. IMEI (if applicable) of the corresponding network device.
	Imei string `json:"imei,omitempty"`
	// MacAddress: Output only. MAC address (if applicable) of the corresponding
	// network device.
	MacAddress string `json:"macAddress,omitempty"`
	// Mdn: Output only. The mobile directory number associated with the device's
	// sim card.
	Mdn string `json:"mdn,omitempty"`
	// Meid: Output only. MEID (if applicable) of the corresponding network device.
	Meid string `json:"meid,omitempty"`
	// Type: Output only. Network device type.
	//
	// Possible values:
	//   "NETWORK_DEVICE_TYPE_UNSPECIFIED" - Network device type not specified.
	//   "CELLULAR_DEVICE" - Cellular device.
	//   "ETHERNET_DEVICE" - Ethernet device.
	//   "WIFI_DEVICE" - Wifi device.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Iccid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Iccid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1NetworkDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1NetworkDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1NetworkDiagnosticsReport: Network testing results to
// determine the health of the device's network connection, for example whether
// the HTTPS latency is high or normal. * Granular permission needed:
// TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1NetworkDiagnosticsReport struct {
	// HttpsLatencyData: Output only. HTTPS latency test data.
	HttpsLatencyData *GoogleChromeManagementV1HttpsLatencyRoutineData `json:"httpsLatencyData,omitempty"`
	// ReportTime: Output only. Timestamp of when the diagnostics were collected.
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpsLatencyData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpsLatencyData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1NetworkDiagnosticsReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1NetworkDiagnosticsReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1NetworkInfo: Network device information. * This
// field provides device information, which is static and will not change over
// time. * Data for this field is controlled via policy:
// ReportNetworkDeviceConfiguration
// (https://chromeenterprise.google/policies/#ReportNetworkDeviceConfiguration)
// * Data Collection Frequency: At device startup * Default Data Reporting
// Frequency: At device startup - Policy Controlled: Yes * Cache: If the device
// is offline, the collected data is stored locally, and will be reported when
// the device is next online: Yes * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_NETWORK_INFO
type GoogleChromeManagementV1NetworkInfo struct {
	// NetworkDevices: Output only. List of network devices.
	NetworkDevices []*GoogleChromeManagementV1NetworkDevice `json:"networkDevices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NetworkDevices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NetworkDevices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1NetworkInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1NetworkInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1NetworkStatusReport: State of visible/configured
// networks. * This field is telemetry information and this will change over
// time as the device is utilized. * Data for this field is controlled via
// policy: ReportNetworkStatus
// (https://chromeenterprise.google/policies/#ReportNetworkStatus) * Data
// Collection Frequency: 60 minutes * Default Data Reporting Frequency: 3 hours
// - Policy Controlled: Yes * Cache: If the device is offline, the collected
// data is stored locally, and will be reported when the device is next online:
// Yes * Reported for affiliated users only: Yes * Granular permission needed:
// TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1NetworkStatusReport struct {
	// ConnectionState: Output only. Current connection state of the network.
	//
	// Possible values:
	//   "NETWORK_CONNECTION_STATE_UNSPECIFIED" - Network connection state
	// unspecified.
	//   "ONLINE" - The network is connected and internet connectivity is
	// available.
	//   "CONNECTED" - The network is connected and not in a detected portal state,
	// but internet connectivity may not be available.
	//   "PORTAL" - The network is connected but a portal state was detected.
	// Internet connectivity may be limited.
	//   "CONNECTING" - The network is in the process of connecting.
	//   "NOT_CONNECTED" - The network is not connected.
	ConnectionState string `json:"connectionState,omitempty"`
	// ConnectionType: Output only. Network connection type.
	//
	// Possible values:
	//   "NETWORK_TYPE_UNSPECIFIED" - Network connection type unspecified
	//   "CELLULAR" - Cellular network connection.
	//   "ETHERNET" - Ethernet network connection.
	//   "TETHER" - Tether network connection.
	//   "VPN" - VPN network connection.
	//   "WIFI" - Wifi network connection.
	ConnectionType string `json:"connectionType,omitempty"`
	// EncryptionOn: Output only. Whether the wifi encryption key is turned off.
	EncryptionOn bool `json:"encryptionOn,omitempty"`
	// GatewayIpAddress: Output only. Gateway IP address.
	GatewayIpAddress string `json:"gatewayIpAddress,omitempty"`
	// Guid: Output only. Network connection guid.
	Guid string `json:"guid,omitempty"`
	// LanIpAddress: Output only. LAN IP address.
	LanIpAddress string `json:"lanIpAddress,omitempty"`
	// ReceivingBitRateMbps: Output only. Receiving bit rate measured in Megabits
	// per second.
	ReceivingBitRateMbps int64 `json:"receivingBitRateMbps,omitempty,string"`
	// ReportTime: Output only. Time at which the network state was reported.
	ReportTime string `json:"reportTime,omitempty"`
	// SampleFrequency: Output only. Frequency the report is sampled.
	SampleFrequency string `json:"sampleFrequency,omitempty"`
	// SignalStrengthDbm: Output only. Signal strength for wireless networks
	// measured in decibels.
	SignalStrengthDbm int64 `json:"signalStrengthDbm,omitempty"`
	// TransmissionBitRateMbps: Output only. Transmission bit rate measured in
	// Megabits per second.
	TransmissionBitRateMbps int64 `json:"transmissionBitRateMbps,omitempty,string"`
	// TransmissionPowerDbm: Output only. Transmission power measured in decibels.
	TransmissionPowerDbm int64 `json:"transmissionPowerDbm,omitempty"`
	// WifiLinkQuality: Output only. Wifi link quality. Value ranges from [0, 70].
	// 0 indicates no signal and 70 indicates a strong signal.
	WifiLinkQuality int64 `json:"wifiLinkQuality,omitempty,string"`
	// WifiPowerManagementEnabled: Output only. Wifi power management enabled
	WifiPowerManagementEnabled bool `json:"wifiPowerManagementEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1NetworkStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1NetworkStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1OsUpdateStatus: Contains information regarding the
// current OS update status. * This field is telemetry information and this
// will change over time as the device is utilized. * Data for this field is
// controlled via policy: ReportDeviceOsUpdateStatus
// (https://chromeenterprise.google/policies/#ReportDeviceOsUpdateStatus) *
// Data Collection Frequency: Only at Upload * Default Data Reporting
// Frequency: 3 hours - Policy Controlled: Yes * Cache: If the device is
// offline, the collected data is stored locally, and will be reported when the
// device is next online: No * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_OS_REPORT
type GoogleChromeManagementV1OsUpdateStatus struct {
	// LastRebootTime: Output only. Timestamp of the last reboot.
	LastRebootTime string `json:"lastRebootTime,omitempty"`
	// LastUpdateCheckTime: Output only. Timestamp of the last update check.
	LastUpdateCheckTime string `json:"lastUpdateCheckTime,omitempty"`
	// LastUpdateTime: Output only. Timestamp of the last successful update.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// NewPlatformVersion: Output only. New platform version of the os image being
	// downloaded and applied. It is only set when update status is
	// OS_IMAGE_DOWNLOAD_IN_PROGRESS or OS_UPDATE_NEED_REBOOT. Note this could be a
	// dummy "0.0.0.0" for OS_UPDATE_NEED_REBOOT status for some edge cases, e.g.
	// update engine is restarted without a reboot.
	NewPlatformVersion string `json:"newPlatformVersion,omitempty"`
	// NewRequestedPlatformVersion: Output only. New requested platform version
	// from the pending updated kiosk app.
	NewRequestedPlatformVersion string `json:"newRequestedPlatformVersion,omitempty"`
	// UpdateState: Output only. Current state of the os update.
	//
	// Possible values:
	//   "UPDATE_STATE_UNSPECIFIED" - State unspecified.
	//   "OS_IMAGE_DOWNLOAD_NOT_STARTED" - OS has not started downloading.
	//   "OS_IMAGE_DOWNLOAD_IN_PROGRESS" - OS has started download on device.
	//   "OS_UPDATE_NEED_REBOOT" - Device needs reboot to finish upload.
	UpdateState string `json:"updateState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastRebootTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastRebootTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1OsUpdateStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1OsUpdateStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1PeripheralsReport: Peripherals report. * Granular
// permission needed: TELEMETRY_API_PERIPHERALS_REPORT
type GoogleChromeManagementV1PeripheralsReport struct {
	// ReportTime: Output only. Timestamp of when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// UsbPeripheralReport: Reports of all usb connected devices.
	UsbPeripheralReport []*GoogleChromeManagementV1UsbPeripheralReport `json:"usbPeripheralReport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReportTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReportTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1PeripheralsReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1PeripheralsReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1PrintJob: Represents a request to print a document
// that has been submitted to a printer.
type GoogleChromeManagementV1PrintJob struct {
	// ColorMode: Color mode.
	//
	// Possible values:
	//   "COLOR_MODE_UNSPECIFIED" - Unspecified.
	//   "BLACK_AND_WHITE" - Black and white.
	//   "COLOR" - Color.
	ColorMode string `json:"colorMode,omitempty"`
	// CompleteTime: Print job completion timestamp.
	CompleteTime string `json:"completeTime,omitempty"`
	// CopyCount: Number of copies.
	CopyCount int64 `json:"copyCount,omitempty"`
	// CreateTime: Print job creation timestamp.
	CreateTime string `json:"createTime,omitempty"`
	// DocumentPageCount: Number of pages in the document.
	DocumentPageCount int64 `json:"documentPageCount,omitempty"`
	// DuplexMode: Duplex mode.
	//
	// Possible values:
	//   "DUPLEX_MODE_UNSPECIFIED" - Unspecified.
	//   "ONE_SIDED" - One-sided.
	//   "TWO_SIDED_LONG_EDGE" - Two-sided flipping over long edge.
	//   "TWO_SIDED_SHORT_EDGE" - Two-sided flipping over short edge.
	DuplexMode string `json:"duplexMode,omitempty"`
	// Id: Unique ID of the print job.
	Id string `json:"id,omitempty"`
	// Printer: Name of the printer used for printing.
	Printer string `json:"printer,omitempty"`
	// PrinterId: API ID of the printer used for printing.
	PrinterId string `json:"printerId,omitempty"`
	// State: The final state of the job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Print job is in an unspecified state.
	//   "PRINTED" - The document was successfully printed.
	//   "CANCELLED" - Print job was cancelled.
	//   "FAILED" - Print job failed.
	State string `json:"state,omitempty"`
	// Title: The title of the document.
	Title string `json:"title,omitempty"`
	// UserEmail: The primary e-mail address of the user who submitted the print
	// job.
	UserEmail string `json:"userEmail,omitempty"`
	// UserId: The unique Directory API ID of the user who submitted the print job.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColorMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColorMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1PrintJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1PrintJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1PrinterReport: Report for CountPrintJobsByPrinter,
// contains statistics on printer usage. Contains the total number of print
// jobs initiated with this printer, the number of users and the number of
// devices that have initiated at least one print job with this printer.
type GoogleChromeManagementV1PrinterReport struct {
	// DeviceCount: Number of chrome devices that have been used to send print jobs
	// to the specified printer.
	DeviceCount int64 `json:"deviceCount,omitempty,string"`
	// JobCount: Number of print jobs sent to the printer.
	JobCount int64 `json:"jobCount,omitempty,string"`
	// Printer: Printer name.
	Printer string `json:"printer,omitempty"`
	// PrinterId: Printer API ID.
	PrinterId string `json:"printerId,omitempty"`
	// PrinterModel: Printer model.
	PrinterModel string `json:"printerModel,omitempty"`
	// UserCount: Number of users that have sent print jobs to the printer.
	UserCount int64 `json:"userCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DeviceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1PrinterReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1PrinterReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1RiskAssessment: Risk assessment for a Chrome
// extension.
type GoogleChromeManagementV1RiskAssessment struct {
	// Assessment: Risk assessment for the extension. Currently, this is a
	// numerical value, and its interpretation is specific to each risk assessment
	// provider.
	Assessment string `json:"assessment,omitempty"`
	// DetailsUrl: A URL that a user can navigate to for more information about the
	// risk assessment.
	DetailsUrl string `json:"detailsUrl,omitempty"`
	// Version: The version of the extension that this assessment applies to.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Assessment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assessment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1RiskAssessment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1RiskAssessment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1RiskAssessmentData: Risk assessment data about an
// extension/app.
type GoogleChromeManagementV1RiskAssessmentData struct {
	// Entries: Individual risk assessments.
	Entries []*GoogleChromeManagementV1RiskAssessmentEntry `json:"entries,omitempty"`
	// OverallRiskLevel: Overall assessed risk level across all entries. This will
	// be the highest risk level from all entries.
	//
	// Possible values:
	//   "RISK_LEVEL_UNSPECIFIED" - Risk level not specified.
	//   "RISK_LEVEL_LOW" - Extension that represents a low risk.
	//   "RISK_LEVEL_MEDIUM" - Extension that represents a medium risk.
	//   "RISK_LEVEL_HIGH" - Extension that represents a high risk.
	OverallRiskLevel string `json:"overallRiskLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1RiskAssessmentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1RiskAssessmentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1RiskAssessmentEntry: One risk assessment entry.
type GoogleChromeManagementV1RiskAssessmentEntry struct {
	// Provider: The risk assessment provider from which this entry comes from.
	//
	// Possible values:
	//   "RISK_ASSESSMENT_PROVIDER_UNSPECIFIED" - Default value when no provider is
	// specified.
	//   "RISK_ASSESSMENT_PROVIDER_CRXCAVATOR" - CRXcavator.
	//   "RISK_ASSESSMENT_PROVIDER_SPIN_AI" - Spin.Ai.
	//   "RISK_ASSESSMENT_PROVIDER_LAYERX" - LayerX Security.
	Provider string `json:"provider,omitempty"`
	// RiskAssessment: The details of the provider's risk assessment.
	RiskAssessment *GoogleChromeManagementV1RiskAssessment `json:"riskAssessment,omitempty"`
	// RiskLevel: The bucketed risk level for the risk assessment.
	//
	// Possible values:
	//   "RISK_LEVEL_UNSPECIFIED" - Risk level not specified.
	//   "RISK_LEVEL_LOW" - Extension that represents a low risk.
	//   "RISK_LEVEL_MEDIUM" - Extension that represents a medium risk.
	//   "RISK_LEVEL_HIGH" - Extension that represents a high risk.
	RiskLevel string `json:"riskLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Provider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Provider") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1RiskAssessmentEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1RiskAssessmentEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1RuntimeCountersReport: Runtime counters retrieved
// from CPU. Currently the runtime counters telemetry is only supported by
// Intel vPro PSR on Gen 14+.
type GoogleChromeManagementV1RuntimeCountersReport struct {
	// EnterHibernationCount: Number of times that the device has entered into the
	// hibernation state. Currently obtained via the PSR, count from S0->S4.
	EnterHibernationCount int64 `json:"enterHibernationCount,omitempty,string"`
	// EnterPoweroffCount: Number of times that the device has entered into the
	// power-off state. Currently obtained via the PSR, count from S0->S5.
	EnterPoweroffCount int64 `json:"enterPoweroffCount,omitempty,string"`
	// EnterSleepCount: Number of times that the device has entered into the sleep
	// state. Currently obtained via the PSR, count from S0->S3.
	EnterSleepCount int64 `json:"enterSleepCount,omitempty,string"`
	// ReportTime: Timestamp when the report was collected.
	ReportTime string `json:"reportTime,omitempty"`
	// UptimeRuntimeDuration: Total lifetime runtime. Currently always S0 runtime
	// from Intel vPro PSR.
	UptimeRuntimeDuration string `json:"uptimeRuntimeDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnterHibernationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnterHibernationCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1RuntimeCountersReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1RuntimeCountersReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1StorageInfo: Status data for storage. * This field
// is telemetry information and this will change over time as the device is
// utilized. * Data for this field is controlled via policy:
// ReportDeviceStorageStatus
// (https://chromeenterprise.google/policies/#ReportDeviceStorageStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_STORAGE_INFO
type GoogleChromeManagementV1StorageInfo struct {
	// AvailableDiskBytes: The available space for user data storage in the device
	// in bytes.
	AvailableDiskBytes int64 `json:"availableDiskBytes,omitempty,string"`
	// TotalDiskBytes: The total space for user data storage in the device in
	// bytes.
	TotalDiskBytes int64 `json:"totalDiskBytes,omitempty,string"`
	// Volume: Information for disk volumes
	Volume []*GoogleChromeManagementV1StorageInfoDiskVolume `json:"volume,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableDiskBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableDiskBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1StorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1StorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1StorageInfoDiskVolume: Information for disk volumes
type GoogleChromeManagementV1StorageInfoDiskVolume struct {
	// StorageFreeBytes: Free storage space in bytes.
	StorageFreeBytes int64 `json:"storageFreeBytes,omitempty,string"`
	// StorageTotalBytes: Total storage space in bytes.
	StorageTotalBytes int64 `json:"storageTotalBytes,omitempty,string"`
	// VolumeId: Disk volume id.
	VolumeId string `json:"volumeId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StorageFreeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StorageFreeBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1StorageInfoDiskVolume) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1StorageInfoDiskVolume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1StorageStatusReport: Status data for storage. * This
// field is telemetry information and this will change over time as the device
// is utilized. * Data for this field is controlled via policy:
// ReportDeviceStorageStatus
// (https://chromeenterprise.google/policies/#ReportDeviceStorageStatus) * Data
// Collection Frequency: Only at Upload * Default Data Reporting Frequency: 3
// hours - Policy Controlled: Yes * Cache: If the device is offline, the
// collected data is stored locally, and will be reported when the device is
// next online: No * Reported for affiliated users only: N/A * Granular
// permission needed: TELEMETRY_API_STORAGE_REPORT
type GoogleChromeManagementV1StorageStatusReport struct {
	// Disk: Output only. Reports on disk.
	Disk []*GoogleChromeManagementV1DiskInfo `json:"disk,omitempty"`
	// ReportTime: Output only. Timestamp of when the sample was collected on
	// device
	ReportTime string `json:"reportTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disk") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1StorageStatusReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1StorageStatusReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryAppInstallEvent: App installation data.
type GoogleChromeManagementV1TelemetryAppInstallEvent struct {
	// AppId: App id. For PWAs this is the start URL, and for extensions this is
	// the extension id.
	AppId string `json:"appId,omitempty"`
	// AppInstallReason: App installation reason.
	//
	// Possible values:
	//   "APPLICATION_INSTALL_REASON_UNSPECIFIED" - Application install reason is
	// unknown.
	//   "APPLICATION_INSTALL_REASON_SYSTEM" - Application installed with the
	// system and is considered part of the OS.
	//   "APPLICATION_INSTALL_REASON_POLICY" - Application installed by policy.
	//   "APPLICATION_INSTALL_REASON_OEM" - Application installed by an original
	// equipment manufacturer (OEM).
	//   "APPLICATION_INSTALL_REASON_DEFAULT" - Application installed by default,
	// but is not considered a system app.
	//   "APPLICATION_INSTALL_REASON_SYNC" - Application installed by sync.
	//   "APPLICATION_INSTALL_REASON_USER" - Application installed by user action.
	//   "APPLICATION_INSTALL_REASON_SUB_APP" - Application installed bt SubApp API
	// call.
	//   "APPLICATION_INSTALL_REASON_KIOSK" - Application installed by Kiosk on
	// Chrome OS.
	//   "APPLICATION_INSTALL_REASON_COMMAND_LINE" - Application installed by
	// command line argument.
	AppInstallReason string `json:"appInstallReason,omitempty"`
	// AppInstallSource: App installation source.
	//
	// Possible values:
	//   "APPLICATION_INSTALL_SOURCE_UNSPECIFIED" - Application install source is
	// unknown.
	//   "APPLICATION_INSTALL_SOURCE_SYSTEM" - Application installed as part of
	// Chrome OS.
	//   "APPLICATION_INSTALL_SOURCE_SYNC" - Application install source is a sync.
	//   "APPLICATION_INSTALL_SOURCE_PLAY_STORE" - Application install source is
	// the Play store.
	//   "APPLICATION_INSTALL_SOURCE_CHROME_WEB_STORE" - Application install source
	// is the Chrome web store.
	//   "APPLICATION_INSTALL_SOURCE_BROWSER" - Application install source is a
	// browser.
	AppInstallSource string `json:"appInstallSource,omitempty"`
	// AppInstallTime: App installation time depending on the app lifecycle.
	//
	// Possible values:
	//   "APPLICATION_INSTALL_TIME_UNSPECIFIED" - Application install time unknown.
	//   "APPLICATION_INSTALL_TIME_INIT" - Application install is initialized.
	//   "APPLICATION_INSTALL_TIME_RUNNING" - Application install is currently
	// running.
	AppInstallTime string `json:"appInstallTime,omitempty"`
	// AppType: Type of app.
	//
	// Possible values:
	//   "TELEMETRY_APPLICATION_TYPE_UNSPECIFIED" - Application type unknown.
	//   "APPLICATION_TYPE_ARC" - Application type arc (Android app).
	//   "APPLICATION_TYPE_BUILT_IN" - Deprecated. This value is no longer used.
	// Application type built-in.
	//   "APPLICATION_TYPE_CROSTINI" - Application type Linux (via Crostini).
	//   "APPLICATION_TYPE_CHROME_APP" - Application type Chrome app.
	//   "APPLICATION_TYPE_WEB" - Application type web.
	//   "APPLICATION_TYPE_MAC_OS" - Application type Mac OS.
	//   "APPLICATION_TYPE_PLUGIN_VM" - Application type Plugin VM.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER" - Deprecated. This value is no
	// longer used. Application type standalone browser (Lacros browser app).
	//   "APPLICATION_TYPE_REMOTE" - Application type remote.
	//   "APPLICATION_TYPE_BOREALIS" - Application type borealis.
	//   "APPLICATION_TYPE_SYSTEM_WEB" - Application type system web.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_CHROME_APP" - Deprecated. This value
	// is no longer used. Application type standalone browser chrome app.
	//   "APPLICATION_TYPE_EXTENSION" - Application type extension.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_EXTENSION" - Deprecated. This value
	// is no longer used. Application type standalone browser extension.
	//   "APPLICATION_TYPE_BRUSCHETTA" - Application type bruschetta.
	AppType string `json:"appType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryAppInstallEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryAppInstallEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryAppLaunchEvent: App launch data.
type GoogleChromeManagementV1TelemetryAppLaunchEvent struct {
	// AppId: App id. For PWAs this is the start URL, and for extensions this is
	// the extension id.
	AppId string `json:"appId,omitempty"`
	// AppLaunchSource: App launch source.
	//
	// Possible values:
	//   "APPLICATION_LAUNCH_SOURCE_UNSPECIFIED" - Application launch source
	// unknown.
	//   "APPLICATION_LAUNCH_SOURCE_APP_LIST_GRID" - Application launched from the
	// grid of apps, not the search box.
	//   "APPLICATION_LAUNCH_SOURCE_APP_LIST_GRID_CONTEXT_MENU" - Application
	// launched from the grid of apps, off of the context menu.
	//   "APPLICATION_LAUNCH_SOURCE_APP_LIST_QUERY" - Application launched from
	// query-dependent results (larger icons).
	//   "APPLICATION_LAUNCH_SOURCE_APP_LIST_QUERY_CONTEXT_MENU" - Application
	// launched from query-dependent results, off of the context menu.
	//   "APPLICATION_LAUNCH_SOURCE_APP_LIST_RECOMMENDATION" - Application launched
	// from query-less recommendations (smaller icons).
	//   "APPLICATION_LAUNCH_SOURCE_PARENTAL_CONTROLS" - Application launched from
	// the Parental Controls Settings section and Per App time notification.
	//   "APPLICATION_LAUNCH_SOURCE_SHELF" - Application launched from shelf.
	//   "APPLICATION_LAUNCH_SOURCE_FILE_MANAGER" - Application launched from the
	// file manager
	//   "APPLICATION_LAUNCH_SOURCE_LINK" - Application launched from left click on
	// a link in the browser.
	//   "APPLICATION_LAUNCH_SOURCE_OMNIBOX" - Application launched from entering a
	// URL in the Omnibox on the browser.
	//   "APPLICATION_LAUNCH_SOURCE_CHROME_INTERNAL" - Application launched from a
	// Chrome internal call.
	//   "APPLICATION_LAUNCH_SOURCE_KEYBOARD" - Application launched from keyboard
	// shortcut for opening app.
	//   "APPLICATION_LAUNCH_SOURCE_OTHER_APP" - Application launched from clicking
	// a link in another app or WebUI.
	//   "APPLICATION_LAUNCH_SOURCE_MENU" - Application launched from menu.
	//   "APPLICATION_LAUNCH_SOURCE_INSTALLED_NOTIFICATION" - Application launched
	// from the installed notification.
	//   "APPLICATION_LAUNCH_SOURCE_TEST" - Application launched from a test.
	//   "APPLICATION_LAUNCH_SOURCE_ARC" - Application launched from Arc.
	//   "APPLICATION_LAUNCH_SOURCE_SHARESHEET" - Application launched from
	// Sharesheet.
	//   "APPLICATION_LAUNCH_SOURCE_RELEASE_NOTES_NOTIFICATION" - Application
	// launched from the release notes notification.
	//   "APPLICATION_LAUNCH_SOURCE_FULL_RESTORE" - Application launched from a
	// full restore.
	//   "APPLICATION_LAUNCH_SOURCE_SMART_TEXT_CONTEXT_MENU" - Application launched
	// from a smart text selection context menu.
	//   "APPLICATION_LAUNCH_SOURCE_DISCOVER_TAB_NOTIFICATION" - Application
	// launched from a discover tab notification.
	//   "APPLICATION_LAUNCH_SOURCE_MANAGEMENT_API" - Application launched from the
	// Management API.
	//   "APPLICATION_LAUNCH_SOURCE_KIOSK" - Application launched from kiosk.
	//   "APPLICATION_LAUNCH_SOURCE_COMMAND_LINE" - Application launched from the
	// command line.
	//   "APPLICATION_LAUNCH_SOURCE_BACKGROUND_MODE" - Application launched from
	// background mode.
	//   "APPLICATION_LAUNCH_SOURCE_NEW_TAB_PAGE" - Application launched from the
	// new tab page.
	//   "APPLICATION_LAUNCH_SOURCE_INTENT_URL" - Application launched from an
	// intent URL.
	//   "APPLICATION_LAUNCH_SOURCE_OS_LOGIN" - Application launched from OS login.
	//   "APPLICATION_LAUNCH_SOURCE_PROTOCOL_HANDLER" - Application launched from
	// protocol handler.
	//   "APPLICATION_LAUNCH_SOURCE_URL_HANDLER" - Application launched from URL
	// handler.
	//   "APPLICATION_LAUNCH_SOURCE_LOCK_SCREEN" - Application launched from lock
	// screen app launcher.
	//   "APPLICATION_LAUNCH_SOURCE_APP_HOME_PAGE" - Application launched from app
	// home (chrome://apps) page.
	//   "APPLICATION_LAUNCH_SOURCE_REPARENTING" - Application launched from moving
	// content into an app.
	//   "APPLICATION_LAUNCH_SOURCE_PROFILE_MENU" - Application launched from
	// profile menu of installable chrome://password-manager WebUI.
	//   "APPLICATION_LAUNCH_SOURCE_SYSTEM_TRAY_CALENDAR" - Application launched
	// from system tray calendar.
	//   "APPLICATION_LAUNCH_SOURCE_INSTALLER" - Application launched from source
	// installer.
	//   "APPLICATION_LAUNCH_SOURCE_FIRST_RUN" - Count first-run Help app launches
	// separately so that we can understand the number of user-triggered launches.
	//   "APPLICATION_LAUNCH_SOURCE_WELCOME_TOUR" - Application launched from
	// welcome tour.
	//   "APPLICATION_LAUNCH_SOURCE_FOCUS_MODE" - Applicationed launched from focus
	// panel.
	//   "APPLICATION_LAUNCH_SOURCE_SPARKY" - Application launched from
	// experimental feature Sparky.
	//   "APPLICATION_LAUNCH_SOURCE_NAVIGATION_CAPTURING" - Application launched
	// from navigation capturing.
	//   "APPLICATION_LAUNCH_SOURCE_WEB_INSTALL_API" - Application launched from
	// web install API.
	AppLaunchSource string `json:"appLaunchSource,omitempty"`
	// AppType: Type of app.
	//
	// Possible values:
	//   "TELEMETRY_APPLICATION_TYPE_UNSPECIFIED" - Application type unknown.
	//   "APPLICATION_TYPE_ARC" - Application type arc (Android app).
	//   "APPLICATION_TYPE_BUILT_IN" - Deprecated. This value is no longer used.
	// Application type built-in.
	//   "APPLICATION_TYPE_CROSTINI" - Application type Linux (via Crostini).
	//   "APPLICATION_TYPE_CHROME_APP" - Application type Chrome app.
	//   "APPLICATION_TYPE_WEB" - Application type web.
	//   "APPLICATION_TYPE_MAC_OS" - Application type Mac OS.
	//   "APPLICATION_TYPE_PLUGIN_VM" - Application type Plugin VM.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER" - Deprecated. This value is no
	// longer used. Application type standalone browser (Lacros browser app).
	//   "APPLICATION_TYPE_REMOTE" - Application type remote.
	//   "APPLICATION_TYPE_BOREALIS" - Application type borealis.
	//   "APPLICATION_TYPE_SYSTEM_WEB" - Application type system web.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_CHROME_APP" - Deprecated. This value
	// is no longer used. Application type standalone browser chrome app.
	//   "APPLICATION_TYPE_EXTENSION" - Application type extension.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_EXTENSION" - Deprecated. This value
	// is no longer used. Application type standalone browser extension.
	//   "APPLICATION_TYPE_BRUSCHETTA" - Application type bruschetta.
	AppType string `json:"appType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryAppLaunchEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryAppLaunchEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryAppUninstallEvent: App uninstall data.
type GoogleChromeManagementV1TelemetryAppUninstallEvent struct {
	// AppId: App id. For PWAs this is the start URL, and for extensions this is
	// the extension id.
	AppId string `json:"appId,omitempty"`
	// AppType: Type of app.
	//
	// Possible values:
	//   "TELEMETRY_APPLICATION_TYPE_UNSPECIFIED" - Application type unknown.
	//   "APPLICATION_TYPE_ARC" - Application type arc (Android app).
	//   "APPLICATION_TYPE_BUILT_IN" - Deprecated. This value is no longer used.
	// Application type built-in.
	//   "APPLICATION_TYPE_CROSTINI" - Application type Linux (via Crostini).
	//   "APPLICATION_TYPE_CHROME_APP" - Application type Chrome app.
	//   "APPLICATION_TYPE_WEB" - Application type web.
	//   "APPLICATION_TYPE_MAC_OS" - Application type Mac OS.
	//   "APPLICATION_TYPE_PLUGIN_VM" - Application type Plugin VM.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER" - Deprecated. This value is no
	// longer used. Application type standalone browser (Lacros browser app).
	//   "APPLICATION_TYPE_REMOTE" - Application type remote.
	//   "APPLICATION_TYPE_BOREALIS" - Application type borealis.
	//   "APPLICATION_TYPE_SYSTEM_WEB" - Application type system web.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_CHROME_APP" - Deprecated. This value
	// is no longer used. Application type standalone browser chrome app.
	//   "APPLICATION_TYPE_EXTENSION" - Application type extension.
	//   "APPLICATION_TYPE_STANDALONE_BROWSER_EXTENSION" - Deprecated. This value
	// is no longer used. Application type standalone browser extension.
	//   "APPLICATION_TYPE_BRUSCHETTA" - Application type bruschetta.
	AppType string `json:"appType,omitempty"`
	// AppUninstallSource: App uninstall source.
	//
	// Possible values:
	//   "APPLICATION_UNINSTALL_SOURCE_UNSPECIFIED" - Application uninstall source
	// unknown.
	//   "APPLICATION_UNINSTALL_SOURCE_APP_LIST" - Application uninstalled from the
	// App List (Launcher).
	//   "APPLICATION_UNINSTALL_SOURCE_APP_MANAGEMENT" - Application uninstalled
	// from the App Managedment page.
	//   "APPLICATION_UNINSTALL_SOURCE_SHELF" - Application uninstalled from the
	// Shelf.
	//   "APPLICATION_UNINSTALL_SOURCE_MIGRATION" - Application uninstalled by app
	// migration.
	AppUninstallSource string `json:"appUninstallSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryAppUninstallEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryAppUninstallEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryAudioSevereUnderrunEvent:
// `TelemetryAudioSevereUnderrunEvent` is triggered when a audio devices run
// out of buffer data for more than 5 seconds. * Granular permission needed:
// TELEMETRY_API_AUDIO_REPORT
type GoogleChromeManagementV1TelemetryAudioSevereUnderrunEvent struct {
}

// GoogleChromeManagementV1TelemetryDevice: Telemetry data collected from a
// managed device. * Granular permission needed: TELEMETRY_API_DEVICE
type GoogleChromeManagementV1TelemetryDevice struct {
	// AppReport: Output only. App reports collected periodically sorted in a
	// decreasing order of report_time.
	AppReport []*GoogleChromeManagementV1AppReport `json:"appReport,omitempty"`
	// AudioStatusReport: Output only. Audio reports collected periodically sorted
	// in a decreasing order of report_time.
	AudioStatusReport []*GoogleChromeManagementV1AudioStatusReport `json:"audioStatusReport,omitempty"`
	// BatteryInfo: Output only. Information on battery specs for the device.
	BatteryInfo []*GoogleChromeManagementV1BatteryInfo `json:"batteryInfo,omitempty"`
	// BatteryStatusReport: Output only. Battery reports collected periodically.
	BatteryStatusReport []*GoogleChromeManagementV1BatteryStatusReport `json:"batteryStatusReport,omitempty"`
	// BootPerformanceReport: Output only. Boot performance reports of the device.
	BootPerformanceReport []*GoogleChromeManagementV1BootPerformanceReport `json:"bootPerformanceReport,omitempty"`
	// CpuInfo: Output only. Information regarding CPU specs for the device.
	CpuInfo []*GoogleChromeManagementV1CpuInfo `json:"cpuInfo,omitempty"`
	// CpuStatusReport: Output only. CPU status reports collected periodically
	// sorted in a decreasing order of report_time.
	CpuStatusReport []*GoogleChromeManagementV1CpuStatusReport `json:"cpuStatusReport,omitempty"`
	// Customer: Output only. Google Workspace Customer whose enterprise enrolled
	// the device.
	Customer string `json:"customer,omitempty"`
	// DeviceId: Output only. The unique Directory API ID of the device. This value
	// is the same as the Admin Console's Directory API ID in the ChromeOS Devices
	// tab
	DeviceId string `json:"deviceId,omitempty"`
	// GraphicsInfo: Output only. Contains information regarding Graphic
	// peripherals for the device.
	GraphicsInfo *GoogleChromeManagementV1GraphicsInfo `json:"graphicsInfo,omitempty"`
	// GraphicsStatusReport: Output only. Graphics reports collected periodically.
	GraphicsStatusReport []*GoogleChromeManagementV1GraphicsStatusReport `json:"graphicsStatusReport,omitempty"`
	// HeartbeatStatusReport: Output only. Heartbeat status report containing
	// timestamps periodically sorted in decreasing order of report_time
	HeartbeatStatusReport []*GoogleChromeManagementV1HeartbeatStatusReport `json:"heartbeatStatusReport,omitempty"`
	// KioskAppStatusReport: Output only. Kiosk app status report for the kiosk
	// device
	KioskAppStatusReport []*GoogleChromeManagementV1KioskAppStatusReport `json:"kioskAppStatusReport,omitempty"`
	// MemoryInfo: Output only. Information regarding memory specs for the device.
	MemoryInfo *GoogleChromeManagementV1MemoryInfo `json:"memoryInfo,omitempty"`
	// MemoryStatusReport: Output only. Memory status reports collected
	// periodically sorted decreasing by report_time.
	MemoryStatusReport []*GoogleChromeManagementV1MemoryStatusReport `json:"memoryStatusReport,omitempty"`
	// Name: Output only. Resource name of the device.
	Name string `json:"name,omitempty"`
	// NetworkBandwidthReport: Output only. Network bandwidth reports collected
	// periodically sorted in a decreasing order of report_time.
	NetworkBandwidthReport []*GoogleChromeManagementV1NetworkBandwidthReport `json:"networkBandwidthReport,omitempty"`
	// NetworkDiagnosticsReport: Output only. Network diagnostics collected
	// periodically.
	NetworkDiagnosticsReport []*GoogleChromeManagementV1NetworkDiagnosticsReport `json:"networkDiagnosticsReport,omitempty"`
	// NetworkInfo: Output only. Network devices information.
	NetworkInfo *GoogleChromeManagementV1NetworkInfo `json:"networkInfo,omitempty"`
	// NetworkStatusReport: Output only. Network specs collected periodically.
	NetworkStatusReport []*GoogleChromeManagementV1NetworkStatusReport `json:"networkStatusReport,omitempty"`
	// OrgUnitId: Output only. Organization unit ID of the device.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// OsUpdateStatus: Output only. Contains relevant information regarding
	// ChromeOS update status.
	OsUpdateStatus []*GoogleChromeManagementV1OsUpdateStatus `json:"osUpdateStatus,omitempty"`
	// PeripheralsReport: Output only. Peripherals reports collected periodically
	// sorted in a decreasing order of report_time.
	PeripheralsReport []*GoogleChromeManagementV1PeripheralsReport `json:"peripheralsReport,omitempty"`
	// RuntimeCountersReport: Output only. Runtime counters reports collected
	// device lifetime runtime, as well as the counts of S0->S3, S0->S4, and S0->S5
	// transitions, meaning entering into sleep, hibernation, and power-off states
	RuntimeCountersReport []*GoogleChromeManagementV1RuntimeCountersReport `json:"runtimeCountersReport,omitempty"`
	// SerialNumber: Output only. Device serial number. This value is the same as
	// the Admin Console's Serial Number in the ChromeOS Devices tab.
	SerialNumber string `json:"serialNumber,omitempty"`
	// StorageInfo: Output only. Information of storage specs for the device.
	StorageInfo *GoogleChromeManagementV1StorageInfo `json:"storageInfo,omitempty"`
	// StorageStatusReport: Output only. Storage reports collected periodically.
	StorageStatusReport []*GoogleChromeManagementV1StorageStatusReport `json:"storageStatusReport,omitempty"`
	// ThunderboltInfo: Output only. Information on Thunderbolt bus.
	ThunderboltInfo []*GoogleChromeManagementV1ThunderboltInfo `json:"thunderboltInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AppReport") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppReport") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryDeviceInfo: Information about a device
// associated with telemetry data. * Granular Permission needed:
// TELEMETRY_API_DEVICE
type GoogleChromeManagementV1TelemetryDeviceInfo struct {
	// DeviceId: Output only. The unique Directory API ID of the device. This value
	// is the same as the Admin Console's Directory API ID in the ChromeOS Devices
	// tab.
	DeviceId string `json:"deviceId,omitempty"`
	// OrgUnitId: Output only. Organization unit ID of the device.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryDeviceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryDeviceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryEvent: Telemetry data reported by a managed
// device.
type GoogleChromeManagementV1TelemetryEvent struct {
	// AppInstallEvent: Output only. Payload for app install event. Present only
	// when `event_type` is `APP_INSTALLED`.
	AppInstallEvent *GoogleChromeManagementV1TelemetryAppInstallEvent `json:"appInstallEvent,omitempty"`
	// AppLaunchEvent: Output only. Payload for app launch event.Present only when
	// `event_type` is `APP_LAUNCHED`.
	AppLaunchEvent *GoogleChromeManagementV1TelemetryAppLaunchEvent `json:"appLaunchEvent,omitempty"`
	// AppUninstallEvent: Output only. Payload for app uninstall event. Present
	// only when `event_type` is `APP_UNINSTALLED`.
	AppUninstallEvent *GoogleChromeManagementV1TelemetryAppUninstallEvent `json:"appUninstallEvent,omitempty"`
	// AudioSevereUnderrunEvent: Output only. Payload for audio severe underrun
	// event. Present only when the `event_type` field is `AUDIO_SEVERE_UNDERRUN`.
	AudioSevereUnderrunEvent *GoogleChromeManagementV1TelemetryAudioSevereUnderrunEvent `json:"audioSevereUnderrunEvent,omitempty"`
	// Device: Output only. Information about the device associated with the event.
	Device *GoogleChromeManagementV1TelemetryDeviceInfo `json:"device,omitempty"`
	// EventType: The event type of the current event.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Event type unknown.
	//   "AUDIO_SEVERE_UNDERRUN" - Triggered when a audio devices run out of buffer
	// data for more than 5 seconds.
	//   "NETWORK_STATE_CHANGE" - Triggered immediately on any changes to a network
	// connection.
	//   "USB_ADDED" - Triggered when USB devices are added.
	//   "USB_REMOVED" - Triggered when USB devices are removed.
	//   "NETWORK_HTTPS_LATENCY_CHANGE" - Triggered when a new HTTPS latency
	// problem was detected or the device has recovered form an existing HTTPS
	// latency problem.
	//   "WIFI_SIGNAL_STRENGTH_LOW" - Triggered when connected WiFi network signal
	// strength drops below -70dBm.
	//   "WIFI_SIGNAL_STRENGTH_RECOVERED" - Triggered when connected WiFi network
	// signal strength is recovered from a signal drop.
	//   "VPN_CONNECTION_STATE_CHANGE" - Triggered on changes to VPN connections.
	//   "APP_INSTALLED" - Triggered when an app is installed.
	//   "APP_UNINSTALLED" - Triggered when an app is uninstalled.
	//   "APP_LAUNCHED" - Triggered when an app is launched.
	//   "OS_CRASH" - Triggered when a crash occurs.
	//   "EXTERNAL_DISPLAY_CONNECTED" - Triggered when an external display is
	// connected.
	//   "EXTERNAL_DISPLAY_DISCONNECTED" - Triggered when an external display is
	// disconnected.
	EventType string `json:"eventType,omitempty"`
	// HttpsLatencyChangeEvent: Output only. Payload for HTTPS latency change
	// event. Present only when `event_type` is `NETWORK_HTTPS_LATENCY_CHANGE`.
	HttpsLatencyChangeEvent *GoogleChromeManagementV1TelemetryHttpsLatencyChangeEvent `json:"httpsLatencyChangeEvent,omitempty"`
	// Name: Output only. Resource name of the event.
	Name string `json:"name,omitempty"`
	// NetworkStateChangeEvent: Output only. Payload for network connection state
	// change event. Present only when `event_type` is `NETWORK_STATE_CHANGE`.
	NetworkStateChangeEvent *GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent `json:"networkStateChangeEvent,omitempty"`
	// OsCrashEvent: Output only. Payload for OS crash event. Present only when
	// `event_type` is `OS_CRASH`.
	OsCrashEvent *GoogleChromeManagementV1TelemetryOsCrashEvent `json:"osCrashEvent,omitempty"`
	// ReportTime: Timestamp that represents when the event was reported.
	ReportTime string `json:"reportTime,omitempty"`
	// UsbPeripheralsEvent: Output only. Payload for usb peripherals event. Present
	// only when the `event_type` field is either `USB_ADDED` or `USB_REMOVED`.
	UsbPeripheralsEvent *GoogleChromeManagementV1TelemetryUsbPeripheralsEvent `json:"usbPeripheralsEvent,omitempty"`
	// User: Output only. Information about the user associated with the event.
	User *GoogleChromeManagementV1TelemetryUserInfo `json:"user,omitempty"`
	// VpnConnectionStateChangeEvent: Output only. Payload for VPN connection state
	// change event. Present only when `event_type` is
	// `VPN_CONNECTION_STATE_CHANGE`.
	VpnConnectionStateChangeEvent *GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent `json:"vpnConnectionStateChangeEvent,omitempty"`
	// WifiSignalStrengthEvent: Output only. Payload for WiFi signal strength
	// events. Present only when `event_type` is `WIFI_SIGNAL_STRENGTH_LOW` or
	// `WIFI_SIGNAL_STRENGTH_RECOVERED`.
	WifiSignalStrengthEvent *GoogleChromeManagementV1TelemetryNetworkSignalStrengthEvent `json:"wifiSignalStrengthEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppInstallEvent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppInstallEvent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryEventNotificationFilter: Configures how the
// telemetry events should be filtered.
type GoogleChromeManagementV1TelemetryEventNotificationFilter struct {
	// EventTypes: Only sends the notifications for events of these types. Must not
	// be empty.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Event type unknown.
	//   "AUDIO_SEVERE_UNDERRUN" - Triggered when a audio devices run out of buffer
	// data for more than 5 seconds.
	//   "NETWORK_STATE_CHANGE" - Triggered immediately on any changes to a network
	// connection.
	//   "USB_ADDED" - Triggered when USB devices are added.
	//   "USB_REMOVED" - Triggered when USB devices are removed.
	//   "NETWORK_HTTPS_LATENCY_CHANGE" - Triggered when a new HTTPS latency
	// problem was detected or the device has recovered form an existing HTTPS
	// latency problem.
	//   "WIFI_SIGNAL_STRENGTH_LOW" - Triggered when connected WiFi network signal
	// strength drops below -70dBm.
	//   "WIFI_SIGNAL_STRENGTH_RECOVERED" - Triggered when connected WiFi network
	// signal strength is recovered from a signal drop.
	//   "VPN_CONNECTION_STATE_CHANGE" - Triggered on changes to VPN connections.
	//   "APP_INSTALLED" - Triggered when an app is installed.
	//   "APP_UNINSTALLED" - Triggered when an app is uninstalled.
	//   "APP_LAUNCHED" - Triggered when an app is launched.
	//   "OS_CRASH" - Triggered when a crash occurs.
	//   "EXTERNAL_DISPLAY_CONNECTED" - Triggered when an external display is
	// connected.
	//   "EXTERNAL_DISPLAY_DISCONNECTED" - Triggered when an external display is
	// disconnected.
	EventTypes []string `json:"eventTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryEventNotificationFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryEventNotificationFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryHttpsLatencyChangeEvent: Https latency
// routine is run periodically and `TelemetryHttpsLatencyChangeEvent` is
// triggered if a latency problem was detected or if the device has recovered
// from a latency problem. * Granular permission needed:
// TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1TelemetryHttpsLatencyChangeEvent struct {
	// HttpsLatencyRoutineData: HTTPS latency routine data that triggered the
	// event.
	HttpsLatencyRoutineData *GoogleChromeManagementV1HttpsLatencyRoutineData `json:"httpsLatencyRoutineData,omitempty"`
	// HttpsLatencyState: Current HTTPS latency state.
	//
	// Possible values:
	//   "HTTPS_LATENCY_STATE_UNSPECIFIED" - HTTPS latency state is unspecified.
	//   "RECOVERY" - HTTPS latency recovered from a problem.
	//   "PROBLEM" - HTTPS latency problem.
	HttpsLatencyState string `json:"httpsLatencyState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpsLatencyRoutineData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpsLatencyRoutineData") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryHttpsLatencyChangeEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryHttpsLatencyChangeEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent:
// `TelemetryNetworkConnectionStateChangeEvent` is triggered on network
// connection state changes. * Granular permission needed:
// TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent struct {
	// ConnectionState: Current connection state of the network.
	//
	// Possible values:
	//   "NETWORK_CONNECTION_STATE_UNSPECIFIED" - Network connection state
	// unspecified.
	//   "ONLINE" - The network is connected and internet connectivity is
	// available.
	//   "CONNECTED" - The network is connected and not in a detected portal state,
	// but internet connectivity may not be available.
	//   "PORTAL" - The network is connected but a portal state was detected.
	// Internet connectivity may be limited.
	//   "CONNECTING" - The network is in the process of connecting.
	//   "NOT_CONNECTED" - The network is not connected.
	ConnectionState string `json:"connectionState,omitempty"`
	// Guid: Unique identifier of the network.
	Guid string `json:"guid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryNetworkConnectionStateChangeEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryNetworkSignalStrengthEvent:
// `TelemetryNetworkSignalStrengthEvent` is triggered on WiFi signal strength
// events. * Granular permission needed: TELEMETRY_API_NETWORK_REPORT
type GoogleChromeManagementV1TelemetryNetworkSignalStrengthEvent struct {
	// Guid: Unique identifier of the network.
	Guid string `json:"guid,omitempty"`
	// SignalStrengthDbm: Signal strength RSSI value.
	SignalStrengthDbm int64 `json:"signalStrengthDbm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Guid") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Guid") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryNetworkSignalStrengthEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryNetworkSignalStrengthEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryNotificationConfig: Configuration to
// receive notifications of telemetry data.
type GoogleChromeManagementV1TelemetryNotificationConfig struct {
	// Customer: Output only. Google Workspace customer that owns the resource.
	Customer string `json:"customer,omitempty"`
	// Filter: Only send notifications for telemetry data matching this filter.
	Filter *GoogleChromeManagementV1TelemetryNotificationFilter `json:"filter,omitempty"`
	// GoogleCloudPubsubTopic: The pubsub topic to which notifications are
	// published to.
	GoogleCloudPubsubTopic string `json:"googleCloudPubsubTopic,omitempty"`
	// Name: Output only. Resource name of the notification configuration.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryNotificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryNotificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryNotificationFilter: Configures how the
// telemetry data should be filtered.
type GoogleChromeManagementV1TelemetryNotificationFilter struct {
	// DeviceId: If set, only sends notifications for telemetry data coming from
	// this device.
	DeviceId string `json:"deviceId,omitempty"`
	// DeviceOrgUnitId: If set, only sends notifications for telemetry data coming
	// from devices in this org unit.
	DeviceOrgUnitId string `json:"deviceOrgUnitId,omitempty"`
	// TelemetryEventNotificationFilter: Only sends notifications for the telemetry
	// events matching this filter.
	TelemetryEventNotificationFilter *GoogleChromeManagementV1TelemetryEventNotificationFilter `json:"telemetryEventNotificationFilter,omitempty"`
	// UserEmail: If set, only sends notifications for telemetry data coming from
	// devices owned by this user.
	UserEmail string `json:"userEmail,omitempty"`
	// UserOrgUnitId: If set, only sends notifications for telemetry data coming
	// from devices owned by users in this org unit.
	UserOrgUnitId string `json:"userOrgUnitId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryNotificationFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryNotificationFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryOsCrashEvent: OS crash data.
type GoogleChromeManagementV1TelemetryOsCrashEvent struct {
	// CrashId: Crash id.
	CrashId string `json:"crashId,omitempty"`
	// CrashType: Crash type.
	//
	// Possible values:
	//   "CRASH_TYPE_UNSPECIFIED" - Crash type unknown.
	//   "CRASH_TYPE_KERNEL" - Kernel crash.
	//   "CRASH_TYPE_EMBEDDED_CONTROLLER" - Embedded controller crash.
	CrashType string `json:"crashType,omitempty"`
	// SessionType: Session type.
	//
	// Possible values:
	//   "SESSION_TYPE_UNSPECIFIED" - Session type unknown.
	//   "SESSION_TYPE_SIGNED_IN_USER" - Signed in user.
	//   "SESSION_TYPE_KIOSK" - Kiosk.
	//   "SESSION_TYPE_MANAGED_GUEST" - Managed guest session.
	//   "SESSION_TYPE_ACTIVE_DIRECTORY" - Active directory session.
	SessionType string `json:"sessionType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrashId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrashId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryOsCrashEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryOsCrashEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryUsbPeripheralsEvent:
// `TelemetryUsbPeripheralsEvent` is triggered USB devices are either added or
// removed. * Granular permission needed: TELEMETRY_API_PERIPHERALS_REPORT
type GoogleChromeManagementV1TelemetryUsbPeripheralsEvent struct {
	// UsbPeripheralReport: List of usb devices that were either added or removed.
	UsbPeripheralReport []*GoogleChromeManagementV1UsbPeripheralReport `json:"usbPeripheralReport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UsbPeripheralReport") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UsbPeripheralReport") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryUsbPeripheralsEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryUsbPeripheralsEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryUser: Telemetry data collected from a
// managed user. * Granular permission needed: TELEMETRY_API_USER
type GoogleChromeManagementV1TelemetryUser struct {
	// Customer: G Suite Customer whose enterprise enrolled the device.
	Customer string `json:"customer,omitempty"`
	// Name: Resource name of the user.
	Name string `json:"name,omitempty"`
	// OrgUnitId: Organization unit of the user.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// UserDevice: Telemetry data collected from a managed user and device.
	UserDevice []*GoogleChromeManagementV1TelemetryUserDevice `json:"userDevice,omitempty"`
	// UserEmail: Email address of the user.
	UserEmail string `json:"userEmail,omitempty"`
	// UserId: Directory ID of the user.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Customer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryUser) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryUserDevice: Telemetry data collected for a
// managed user and device. * Granular permission needed: TELEMETRY_API_DEVICE
type GoogleChromeManagementV1TelemetryUserDevice struct {
	// AppReport: Output only. App reports collected periodically sorted in a
	// decreasing order of report_time.
	AppReport []*GoogleChromeManagementV1AppReport `json:"appReport,omitempty"`
	// AudioStatusReport: Output only. Audio reports collected periodically sorted
	// in a decreasing order of report_time.
	AudioStatusReport []*GoogleChromeManagementV1AudioStatusReport `json:"audioStatusReport,omitempty"`
	// DeviceActivityReport: Output only. Device activity reports collected
	// periodically sorted in a decreasing order of report_time.
	DeviceActivityReport []*GoogleChromeManagementV1DeviceActivityReport `json:"deviceActivityReport,omitempty"`
	// DeviceId: The unique Directory API ID of the device. This value is the same
	// as the Admin Console's Directory API ID in the ChromeOS Devices tab.
	DeviceId string `json:"deviceId,omitempty"`
	// NetworkBandwidthReport: Output only. Network bandwidth reports collected
	// periodically sorted in a decreasing order of report_time.
	NetworkBandwidthReport []*GoogleChromeManagementV1NetworkBandwidthReport `json:"networkBandwidthReport,omitempty"`
	// PeripheralsReport: Output only. Peripherals reports collected periodically
	// sorted in a decreasing order of report_time.
	PeripheralsReport []*GoogleChromeManagementV1PeripheralsReport `json:"peripheralsReport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppReport") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppReport") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryUserDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryUserDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TelemetryUserInfo: Information about a user
// associated with telemetry data. * Granular permission needed:
// TELEMETRY_API_USER
type GoogleChromeManagementV1TelemetryUserInfo struct {
	// Email: Output only. User's email.
	Email string `json:"email,omitempty"`
	// OrgUnitId: Output only. Organization unit ID of the user.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TelemetryUserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TelemetryUserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1ThunderboltInfo: Thunderbolt bus info. * This field
// provides device information, which is static and will not change over time.
// * Data for this field is controlled via policy: ReportDeviceSecurityStatus
// (https://chromeenterprise.google/policies/#ReportDeviceSecurityStatus) *
// Data Collection Frequency: At device startup * Default Data Reporting
// Frequency: At device startup - Policy Controlled: No * Cache: If the device
// is offline, the collected data is stored locally, and will be reported when
// the device is next online: Yes * Reported for affiliated users only: N/A *
// Granular permission needed: TELEMETRY_API_BUS_DEVICE_INFO
type GoogleChromeManagementV1ThunderboltInfo struct {
	// SecurityLevel: Security level of the Thunderbolt bus.
	//
	// Possible values:
	//   "THUNDERBOLT_SECURITY_LEVEL_UNSPECIFIED" - Thunderbolt security level is
	// not set.
	//   "THUNDERBOLT_SECURITY_NONE_LEVEL" - All devices are automatically
	// connected by the firmware. No user approval is needed.
	//   "THUNDERBOLT_SECURITY_USER_LEVEL" - User is asked whether the device is
	// allowed to be connected.
	//   "THUNDERBOLT_SECURITY_SECURE_LEVEL" - User is asked whether the device is
	// allowed to be connected. In addition the device is sent a challenge that
	// should match the expected one based on a random key written to the key sysfs
	// attribute
	//   "THUNDERBOLT_SECURITY_DP_ONLY_LEVEL" - The firmware automatically creates
	// tunnels for Thunderbolt.
	//   "THUNDERBOLT_SECURITY_USB_ONLY_LEVEL" - The firmware automatically creates
	// tunnels for the USB controller and Display Port in a dock. All PCIe links
	// downstream of the dock are removed.
	//   "THUNDERBOLT_SECURITY_NO_PCIE_LEVEL" - PCIE tunneling is disabled.
	SecurityLevel string `json:"securityLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecurityLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecurityLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1ThunderboltInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1ThunderboltInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TotalMemoryEncryptionInfo: Memory encryption
// information of a device. * This field provides device information, which is
// static and will not change over time. * Data for this field is controlled
// via policy: ReportDeviceMemoryInfo
// (https://chromeenterprise.google/policies/#ReportDeviceMemoryInfo) * Data
// Collection Frequency: At device startup * Default Data Reporting Frequency:
// At device startup - Policy Controlled: Yes * Cache: If the device is
// offline, the collected data is stored locally, and will be reported when the
// device is next online: Yes * Reported for affiliated users only: N/A
type GoogleChromeManagementV1TotalMemoryEncryptionInfo struct {
	// EncryptionAlgorithm: Memory encryption algorithm.
	//
	// Possible values:
	//   "MEMORY_ENCRYPTION_ALGORITHM_UNSPECIFIED" - Memory encryption algorithm is
	// not set.
	//   "MEMORY_ENCRYPTION_ALGORITHM_UNKNOWN" - The memory encryption algorithm
	// being used is unknown.
	//   "MEMORY_ENCRYPTION_ALGORITHM_AES_XTS_128" - The memory encryption
	// algorithm is using the AES_XTS encryption algorithm with a 128 bit block
	// cypher.
	//   "MEMORY_ENCRYPTION_ALGORITHM_AES_XTS_256" - The memory encryption
	// algorithm is using the AES_XTS encryption algorithm with a 256 bit block
	// cypher.
	EncryptionAlgorithm string `json:"encryptionAlgorithm,omitempty"`
	// EncryptionState: The state of memory encryption on the device.
	//
	// Possible values:
	//   "MEMORY_ENCRYPTION_STATE_UNSPECIFIED" - Memory encryption state is not
	// set.
	//   "MEMORY_ENCRYPTION_STATE_UNKNOWN" - The memory encryption state is
	// unknown.
	//   "MEMORY_ENCRYPTION_STATE_DISABLED" - Memory encrpytion on the device is
	// disabled.
	//   "MEMORY_ENCRYPTION_STATE_TME" - Memory encryption on the device uses total
	// memory encryption.
	//   "MEMORY_ENCRYPTION_STATE_MKTME" - Memory encryption on the device uses
	// multi-key total memory encryption.
	EncryptionState string `json:"encryptionState,omitempty"`
	// KeyLength: The length of the encryption keys.
	KeyLength int64 `json:"keyLength,omitempty,string"`
	// MaxKeys: The maximum number of keys that can be used for encryption.
	MaxKeys int64 `json:"maxKeys,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EncryptionAlgorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionAlgorithm") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TotalMemoryEncryptionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TotalMemoryEncryptionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TouchScreenDevice: Information of an internal touch
// screen device.
type GoogleChromeManagementV1TouchScreenDevice struct {
	// DisplayName: Output only. Touch screen device display name.
	DisplayName string `json:"displayName,omitempty"`
	// StylusCapable: Output only. Touch screen device is stylus capable or not.
	StylusCapable bool `json:"stylusCapable,omitempty"`
	// TouchPointCount: Output only. Number of touch points supported on the
	// device.
	TouchPointCount int64 `json:"touchPointCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TouchScreenDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TouchScreenDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1TouchScreenInfo: Information on the device touch
// screen.
type GoogleChromeManagementV1TouchScreenInfo struct {
	// Devices: Output only. List of the internal touch screen devices.
	Devices []*GoogleChromeManagementV1TouchScreenDevice `json:"devices,omitempty"`
	// TouchpadLibrary: Output only. Touchpad library name used by the input stack.
	TouchpadLibrary string `json:"touchpadLibrary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Devices") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Devices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1TouchScreenInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1TouchScreenInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1UsbPeripheralReport: USB connected peripheral
// report.
type GoogleChromeManagementV1UsbPeripheralReport struct {
	// Categories: Output only. Categories the device belongs to
	// https://www.usb.org/defined-class-codes
	Categories []string `json:"categories,omitempty"`
	// ClassId: Output only. Class ID https://www.usb.org/defined-class-codes
	ClassId int64 `json:"classId,omitempty"`
	// FirmwareVersion: Output only. Firmware version
	FirmwareVersion string `json:"firmwareVersion,omitempty"`
	// Name: Output only. Device name, model name, or product name
	Name string `json:"name,omitempty"`
	// Pid: Output only. Product ID
	Pid int64 `json:"pid,omitempty"`
	// SubclassId: Output only. Subclass ID https://www.usb.org/defined-class-codes
	SubclassId int64 `json:"subclassId,omitempty"`
	// Vendor: Output only. Vendor name
	Vendor string `json:"vendor,omitempty"`
	// Vid: Output only. Vendor ID
	Vid int64 `json:"vid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1UsbPeripheralReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1UsbPeripheralReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1UserPrintReport: Report for CountPrintJobsByUser,
// contains printing statistics for a user. Contains the number of printers,
// the number of devices used to initiate print jobs, and the number of print
// jobs initiated.
type GoogleChromeManagementV1UserPrintReport struct {
	// DeviceCount: Number of chrome devices that have been used to initiate print
	// jobs by the user.
	DeviceCount int64 `json:"deviceCount,omitempty,string"`
	// JobCount: Number of print jobs initiated by the user.
	JobCount int64 `json:"jobCount,omitempty,string"`
	// PrinterCount: Number of printers used by the user.
	PrinterCount int64 `json:"printerCount,omitempty,string"`
	// UserEmail: The primary e-mail address of the user.
	UserEmail string `json:"userEmail,omitempty"`
	// UserId: The unique Directory API ID of the user.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1UserPrintReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1UserPrintReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1UserRequestingExtensionDetails: Details of a user
// requesting an extension, including the email and the justification.
type GoogleChromeManagementV1UserRequestingExtensionDetails struct {
	// Email: The e-mail address of a user that has requested the extension.
	Email string `json:"email,omitempty"`
	// Justification: Request justification as entered by the user.
	Justification string `json:"justification,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementV1UserRequestingExtensionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1UserRequestingExtensionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1AttestationCredential: Information of public
// key associated with a Chrome browser profile.
type GoogleChromeManagementVersionsV1AttestationCredential struct {
	// KeyRotationTime: Output only. Latest rotation timestamp of the public key
	// rotation.
	KeyRotationTime string `json:"keyRotationTime,omitempty"`
	// KeyTrustLevel: Output only. Trust level of the public key.
	//
	// Possible values:
	//   "KEY_TRUST_LEVEL_UNSPECIFIED" - Represents an unspecified public key trust
	// level.
	//   "CHROME_BROWSER_HW_KEY" - Represents a HW key.
	//   "CHROME_BROWSER_OS_KEY" - Represents an OS key.
	KeyTrustLevel string `json:"keyTrustLevel,omitempty"`
	// KeyType: Output only. Type of the public key.
	//
	// Possible values:
	//   "KEY_TYPE_UNSPECIFIED" - Represents an unspecified public key type.
	//   "RSA_KEY" - Represents a RSA key.
	//   "EC_KEY" - Represents an EC key.
	KeyType string `json:"keyType,omitempty"`
	// PublicKey: Output only. Value of the public key.
	PublicKey string `json:"publicKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KeyRotationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeyRotationTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1AttestationCredential) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1AttestationCredential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1CertificateProvisioningProcess: A
// certificate provisioning process.
type GoogleChromeManagementVersionsV1CertificateProvisioningProcess struct {
	// ChromeOsDevice: Output only. The client certificate is being provisioned for
	// a ChromeOS device. This contains information about the device.
	ChromeOsDevice *GoogleChromeManagementVersionsV1ChromeOsDevice `json:"chromeOsDevice,omitempty"`
	// ChromeOsUserSession: Output only. The client certificate is being
	// provisioned for a ChromeOS user. This contains information about the current
	// user session.
	ChromeOsUserSession *GoogleChromeManagementVersionsV1ChromeOsUserSession `json:"chromeOsUserSession,omitempty"`
	// FailureMessage: Output only. A message describing why this
	// `CertificateProvisioningProcess` has failed. Presence of this field
	// indicates that the `CertificateProvisioningProcess` has failed.
	FailureMessage string `json:"failureMessage,omitempty"`
	// GenericCaConnection: Output only. The CA connection is a generic CA
	// connection.
	GenericCaConnection *GoogleChromeManagementVersionsV1GenericCaConnection `json:"genericCaConnection,omitempty"`
	// GenericProfile: Output only. The profile is a generic certificate
	// provisioning profile.
	GenericProfile *GoogleChromeManagementVersionsV1GenericProfile `json:"genericProfile,omitempty"`
	// IssuedCertificate: Output only. The issued certificate for this
	// `CertificateProvisioningProcess` in PEM format.
	IssuedCertificate string `json:"issuedCertificate,omitempty"`
	// Name: Identifier. Resource name of the `CertificateProvisioningProcess`. The
	// name pattern is given as
	// `customers/{customer}/certificateProvisioningProcesses/{certificate_provision
	// ing_process}` with `{customer}` being the obfuscated customer id and
	// `{certificate_provisioning_process}` being the certificate provisioning
	// process id.
	Name string `json:"name,omitempty"`
	// ProvisioningProfileId: Output only. The ID of the certificate provisioning
	// profile.
	ProvisioningProfileId string `json:"provisioningProfileId,omitempty"`
	// SignData: Output only. The data that the client was asked to sign. This
	// field is only present after the `SignData` operation has been initiated.
	SignData string `json:"signData,omitempty"`
	// Signature: Output only. The signature of `signature_algorithm`, generated
	// using the client's private key using `signature_algorithm`. This field is
	// only present after the `SignData` operation has finished.
	Signature string `json:"signature,omitempty"`
	// SignatureAlgorithm: Output only. The signature algorithm that the adapter
	// expects the client and backend components to use when processing
	// `sign_data`. This field is only present after the `SignData` operation has
	// been initiated.
	//
	// Possible values:
	//   "SIGNATURE_ALGORITHM_UNSPECIFIED" - Default value. This value is unused.
	//   "SIGNATURE_ALGORITHM_RSA_PKCS1_V1_5_SHA256" - The server-side builds the
	// PKCS#1 DigestInfo, i.e., the SHA256 hash is constructed on the server-side.
	// The client should sign using RSA with PKCS#1 v1.5 padding.
	SignatureAlgorithm string `json:"signatureAlgorithm,omitempty"`
	// StartTime: Output only. Server-generated timestamp of when the certificate
	// provisioning process has been created.
	StartTime string `json:"startTime,omitempty"`
	// SubjectPublicKeyInfo: Output only. The public key for which a certificate
	// should be provisioned. Represented as a DER-encoded X.509
	// SubjectPublicKeyInfo.
	SubjectPublicKeyInfo string `json:"subjectPublicKeyInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChromeOsDevice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeOsDevice") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1CertificateProvisioningProcess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1CertificateProvisioningProcess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ChromeBrowserProfile: A representation of a
// Chrome browser profile.
type GoogleChromeManagementVersionsV1ChromeBrowserProfile struct {
	// AffiliationState: Output only. The specific affiliation state of the
	// profile.
	//
	// Possible values:
	//   "AFFILIATION_STATE_UNSPECIFIED" - Unspecified affiliation state.
	//   "UNAFFILIATED_GENERIC" - Unaffiliated - but we do not have the details for
	// the type of unaffiliated profile.
	//   "PROFILE_ONLY" - Unaffiliated - A managed profile that appears on a
	// totally unamanaged browser.
	//   "UNAFFILIATED_LOCAL_MACHINE" - Unaffiliated - A managed profile that
	// appears on a machine that is locally managed by a different organization
	// (through platform management mechanisms like GPO).
	//   "UNAFFILIATED_CLOUD_MACHINE" - Unaffiliated - A managed profile that
	// appears on a managed browser that is cloud managed by a different
	// organization (using Chrome Browser Cloud Management).
	//   "AFFILIATED_CLOUD_MANAGED" - Affiliated - Both the profile and the managed
	// browser are managed by the same organization.
	AffiliationState string `json:"affiliationState,omitempty"`
	// AnnotatedLocation: Optional. Location of the profile annotated by the admin.
	AnnotatedLocation string `json:"annotatedLocation,omitempty"`
	// AnnotatedUser: Optional. User of the profile annotated by the admin.
	AnnotatedUser string `json:"annotatedUser,omitempty"`
	// AttestationCredential: Output only. Attestation credential information of
	// the profile.
	AttestationCredential *GoogleChromeManagementVersionsV1AttestationCredential `json:"attestationCredential,omitempty"`
	// BrowserChannel: Output only. Channel of the browser on which the profile
	// exists.
	BrowserChannel string `json:"browserChannel,omitempty"`
	// BrowserVersion: Output only. Version of the browser on which the profile
	// exists.
	BrowserVersion string `json:"browserVersion,omitempty"`
	// DeviceInfo: Output only. Basic information of the device on which the
	// profile exists. This information is only available for the affiliated
	// profiles.
	DeviceInfo *GoogleChromeManagementVersionsV1DeviceInfo `json:"deviceInfo,omitempty"`
	// DisplayName: Output only. Profile display name set by client.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Output only. Etag of this ChromeBrowserProfile resource. This etag can
	// be used with UPDATE operation to ensure consistency.
	Etag string `json:"etag,omitempty"`
	// ExtensionCount: Output only. Number of extensions installed on the profile.
	ExtensionCount int64 `json:"extensionCount,omitempty,string"`
	// FirstEnrollmentTime: Output only. Timestamp of the first enrollment of the
	// profile.
	FirstEnrollmentTime string `json:"firstEnrollmentTime,omitempty"`
	// IdentityProvider: Output only. Identify provider of the profile.
	//
	// Possible values:
	//   "IDENTITY_PROVIDER_UNSPECIFIED" - Represents an unspecified identity
	// provider.
	//   "GOOGLE_IDENTITY_PROVIDER" - Represents a Google identity provider.
	//   "EXTERNAL_IDENTITY_PROVIDER" - Represents an external identity provider.
	IdentityProvider string `json:"identityProvider,omitempty"`
	// LastActivityTime: Output only. Timestamp of the latest activity by the
	// profile.
	LastActivityTime string `json:"lastActivityTime,omitempty"`
	// LastPolicyFetchTime: Output only. Timestamp of the latest policy fetch by
	// the profile.
	LastPolicyFetchTime string `json:"lastPolicyFetchTime,omitempty"`
	// LastPolicySyncTime: Output only. Timestamp of the latest policy sync by the
	// profile.
	LastPolicySyncTime string `json:"lastPolicySyncTime,omitempty"`
	// LastStatusReportTime: Output only. Timestamp of the latest status report by
	// the profile.
	LastStatusReportTime string `json:"lastStatusReportTime,omitempty"`
	// Name: Identifier. Format:
	// customers/{customer_id}/profiles/{profile_permanent_id}
	Name string `json:"name,omitempty"`
	// OsPlatformType: Output only. OS platform of the device on which the profile
	// exists.
	OsPlatformType string `json:"osPlatformType,omitempty"`
	// OsPlatformVersion: Output only. Major OS platform version of the device on
	// which the profile exists, from profile reporting.
	OsPlatformVersion string `json:"osPlatformVersion,omitempty"`
	// OsVersion: Output only. OS version of the device on which the profile
	// exists.
	OsVersion string `json:"osVersion,omitempty"`
	// PolicyCount: Output only. Number of policies applied on the profile.
	PolicyCount int64 `json:"policyCount,omitempty,string"`
	// ProfileId: Output only. Chrome client side profile ID.
	ProfileId string `json:"profileId,omitempty"`
	// ProfilePermanentId: Output only. Profile permanent ID is the unique
	// identifier of a profile within one customer.
	ProfilePermanentId string `json:"profilePermanentId,omitempty"`
	// ReportingData: Output only. Detailed reporting data of the profile. This
	// information is only available when the profile reporting policy is enabled.
	ReportingData *GoogleChromeManagementVersionsV1ReportingData `json:"reportingData,omitempty"`
	// UserEmail: Output only. Email address of the user to which the profile
	// belongs.
	UserEmail string `json:"userEmail,omitempty"`
	// UserId: Output only. Unique Directory API ID of the user that can be used in
	// Admin SDK Users API.
	UserId string `json:"userId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AffiliationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffiliationState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ChromeBrowserProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ChromeBrowserProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand: A
// representation of a remote command for a Chrome browser profile.
type GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand struct {
	// CommandResult: Output only. Result of the remote command.
	CommandResult *GoogleChromeManagementVersionsV1ChromeBrowserProfileCommandCommandResult `json:"commandResult,omitempty"`
	// CommandState: Output only. State of the remote command.
	//
	// Possible values:
	//   "COMMAND_STATE_UNSPECIFIED" - Represents an unspecified command state.
	//   "PENDING" - Represents a command in a pending state.
	//   "EXPIRED" - Represents a command that has expired.
	//   "EXECUTED_BY_CLIENT" - Represents a command that has been executed by the
	// client.
	CommandState string `json:"commandState,omitempty"`
	// CommandType: Required. Type of the remote command. The only supported
	// command_type is "clearBrowsingData".
	CommandType string `json:"commandType,omitempty"`
	// IssueTime: Output only. Timestamp of the issurance of the remote command.
	IssueTime string `json:"issueTime,omitempty"`
	// Name: Identifier. Format:
	// customers/{customer_id}/profiles/{profile_permanent_id}/commands/{command_id}
	Name string `json:"name,omitempty"`
	// Payload: Required. Payload of the remote command. The payload for
	// "clearBrowsingData" command supports: - fields "clearCache" and
	// "clearCookies" - values of boolean type.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// ValidDuration: Output only. Valid duration of the remote command.
	ValidDuration string `json:"validDuration,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CommandResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommandResult") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ChromeBrowserProfileCommandCommandResult:
// Result of the execution of a command.
type GoogleChromeManagementVersionsV1ChromeBrowserProfileCommandCommandResult struct {
	// ClientExecutionTime: Output only. Timestamp of the client execution of the
	// remote command.
	ClientExecutionTime string `json:"clientExecutionTime,omitempty"`
	// ResultCode: Output only. Result code that indicates the type of error or
	// success of the command.
	ResultCode string `json:"resultCode,omitempty"`
	// ResultType: Output only. Result type of the remote command.
	//
	// Possible values:
	//   "COMMAND_RESULT_TYPE_UNSPECIFIED" - Represents an unspecified command
	// result.
	//   "IGNORED" - Represents a command with an ignored result.
	//   "FAILURE" - Represents a failed command.
	//   "SUCCESS" - Represents a succeeded command.
	ResultType string `json:"resultType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientExecutionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientExecutionTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ChromeBrowserProfileCommandCommandResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ChromeBrowserProfileCommandCommandResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ChromeOsDevice: Describes the ChromeOS
// device that a `CertificateProvisioningProcess` belongs to.
type GoogleChromeManagementVersionsV1ChromeOsDevice struct {
	// DeviceDirectoryApiId: Output only. The unique Directory API ID of the
	// device. This value is the same as the Admin Console's Directory API ID in
	// the ChromeOS Devices tab.
	DeviceDirectoryApiId string `json:"deviceDirectoryApiId,omitempty"`
	// SerialNumber: Output only. Device serial number. This value is the same as
	// the Admin Console's Serial Number in the ChromeOS Devices tab.
	SerialNumber string `json:"serialNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeviceDirectoryApiId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeviceDirectoryApiId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ChromeOsDevice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ChromeOsDevice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ChromeOsUserSession: Describes the ChromeOS
// user session that a `CertificateProvisioningProcess` belongs to.
type GoogleChromeManagementVersionsV1ChromeOsUserSession struct {
	// ChromeOsDevice: Output only. This field contains information about the
	// ChromeOS device that the user session is running on. It is only set if the
	// user is affiliated, i.e., if the user is managed by the same organization
	// that manages the ChromeOS device.
	ChromeOsDevice *GoogleChromeManagementVersionsV1ChromeOsDevice `json:"chromeOsDevice,omitempty"`
	// UserDirectoryApiId: Output only. The unique Directory API ID of the user.
	UserDirectoryApiId string `json:"userDirectoryApiId,omitempty"`
	// UserPrimaryEmail: Output only. The primary e-mail address of the user.
	UserPrimaryEmail string `json:"userPrimaryEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChromeOsDevice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeOsDevice") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ChromeOsUserSession) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ChromeOsUserSession
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1DeviceInfo: Information of a device that
// runs a Chrome browser profile.
type GoogleChromeManagementVersionsV1DeviceInfo struct {
	// AffiliatedDeviceId: Output only. Device ID that identifies the affiliated
	// device on which the profile exists. If the device type is CHROME_BROWSER,
	// then this represents a unique Directory API ID of the device that can be
	// used in Admin SDK Browsers API.
	AffiliatedDeviceId string `json:"affiliatedDeviceId,omitempty"`
	// DeviceType: Output only. Type of the device on which the profile exists.
	//
	// Possible values:
	//   "DEVICE_TYPE_UNSPECIFIED" - Represents an unspecified device type.
	//   "CHROME_BROWSER" - Represents a Chrome browser device.
	DeviceType string `json:"deviceType,omitempty"`
	// Hostname: Output only. Hostname of the device on which the profile exists.
	Hostname string `json:"hostname,omitempty"`
	// Machine: Output only. Machine name of the device on which the profile
	// exists. On platforms which do not report the machine name (currently iOS and
	// Android) this is instead set to the browser's device_id - but note that this
	// is a different device_id than the |affiliated_device_id|.
	Machine string `json:"machine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AffiliatedDeviceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AffiliatedDeviceId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1DeviceInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1DeviceInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1GenericCaConnection: Describes a generic
// Certificate Authority Connection.
type GoogleChromeManagementVersionsV1GenericCaConnection struct {
	// CaConnectionAdapterConfigReference: Output only. A string that references
	// the administrator-provided configuration for the certification authority
	// service. This field can be missing if no configuration was given.
	CaConnectionAdapterConfigReference string `json:"caConnectionAdapterConfigReference,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CaConnectionAdapterConfigReference") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CaConnectionAdapterConfigReference") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1GenericCaConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1GenericCaConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1GenericProfile: Describes a generic
// certificate provisioning profile.
type GoogleChromeManagementVersionsV1GenericProfile struct {
	// ProfileAdapterConfigReference: Output only. A string that references the
	// administrator-provided configuration for the certificate provisioning
	// profile. This field can be missing if no configuration was given.
	ProfileAdapterConfigReference string `json:"profileAdapterConfigReference,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ProfileAdapterConfigReference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProfileAdapterConfigReference")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1GenericProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1GenericProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse:
// Response to ListChromeBrowserProfileCommands method.
type GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse struct {
	// ChromeBrowserProfileCommands: The list of commands returned.
	ChromeBrowserProfileCommands []*GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand `json:"chromeBrowserProfileCommands,omitempty"`
	// NextPageToken: The pagination token that can be used to list the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total size represents an estimated number of resources returned.
	TotalSize int64 `json:"totalSize,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ChromeBrowserProfileCommands") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeBrowserProfileCommands") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse: Response
// to ListChromeBrowserProfiles method.
type GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse struct {
	// ChromeBrowserProfiles: The list of profiles returned.
	ChromeBrowserProfiles []*GoogleChromeManagementVersionsV1ChromeBrowserProfile `json:"chromeBrowserProfiles,omitempty"`
	// NextPageToken: The pagination token that can be used to list the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TotalSize: Total size represents an estimated number of resources returned.
	// Not guaranteed to be accurate above 10k profiles.
	TotalSize int64 `json:"totalSize,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ChromeBrowserProfiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChromeBrowserProfiles") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest: Request to
// MoveThirdPartyProfileUser method.
type GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest struct {
	// DestinationOrgUnit: Required. Destination organizational unit where the
	// third party chrome profile user will be moved to.
	DestinationOrgUnit string `json:"destinationOrgUnit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationOrgUnit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationOrgUnit") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse: Response
// for MoveThirdPartyProfileUser method.
type GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse struct {
	// ThirdPartyProfileUser: Output only. The moved third party profile user.
	ThirdPartyProfileUser *GoogleChromeManagementVersionsV1ThirdPartyProfileUser `json:"thirdPartyProfileUser,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ThirdPartyProfileUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ThirdPartyProfileUser") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ReportingData: Reporting data of a Chrome
// browser profile.
type GoogleChromeManagementVersionsV1ReportingData struct {
	// BrowserExecutablePath: Output only. Executable path of the installed Chrome
	// browser. A valid path is included only in affiliated profiles.
	BrowserExecutablePath string `json:"browserExecutablePath,omitempty"`
	// ExtensionData: Output only. Information of the extensions installed on the
	// profile.
	ExtensionData []*GoogleChromeManagementVersionsV1ReportingDataExtensionData `json:"extensionData,omitempty"`
	// ExtensionPolicyData: Output only. Information of the policies applied on the
	// extensions.
	ExtensionPolicyData []*GoogleChromeManagementVersionsV1ReportingDataExtensionPolicyData `json:"extensionPolicyData,omitempty"`
	// InstalledBrowserVersion: Output only. Updated version of a browser, if it is
	// different from the active browser version.
	InstalledBrowserVersion string `json:"installedBrowserVersion,omitempty"`
	// PolicyData: Output only. Information of the policies applied on the profile.
	PolicyData []*GoogleChromeManagementVersionsV1ReportingDataPolicyData `json:"policyData,omitempty"`
	// ProfilePath: Output only. Path of the profile. A valid path is included only
	// in affiliated profiles.
	ProfilePath string `json:"profilePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BrowserExecutablePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BrowserExecutablePath") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ReportingData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ReportingData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ReportingDataConflictingPolicyData:
// Information of conflicting policy applied on a Chrome browser profile.
type GoogleChromeManagementVersionsV1ReportingDataConflictingPolicyData struct {
	// Source: Output only. Source of the policy.
	//
	// Possible values:
	//   "POLICY_SOURCE_UNSPECIFIED" - Represents an unspecified policy source.
	//   "MACHINE_PLATFORM" - Represents a machine level platform policy.
	//   "USER_PLATFORM" - Represents a user level platform policy.
	//   "MACHINE_LEVEL_USER_CLOUD" - Represents a machine level user cloud policy.
	//   "USER_CLOUD" - Represents a user level cloud policy.
	//   "MACHINE_MERGED" - Represents a machine level merged policy.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Source") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Source") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ReportingDataConflictingPolicyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ReportingDataConflictingPolicyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ReportingDataExtensionData: Information of
// an extension installed on a Chrome browser profile.
type GoogleChromeManagementVersionsV1ReportingDataExtensionData struct {
	// Description: Output only. Description of the extension.
	Description string `json:"description,omitempty"`
	// ExtensionId: Output only. ID of the extension.
	ExtensionId string `json:"extensionId,omitempty"`
	// ExtensionType: Output only. Type of the extension.
	//
	// Possible values:
	//   "EXTENSION_TYPE_UNSPECIFIED" - Represents an unspecified extension type.
	//   "EXTENSION" - Represents an extension.
	//   "APP" - Represents an app.
	//   "THEME" - Represents a theme.
	//   "HOSTED_APP" - Represents a hosted app.
	ExtensionType string `json:"extensionType,omitempty"`
	// HomepageUri: Output only. The URL of the homepage of the extension.
	HomepageUri string `json:"homepageUri,omitempty"`
	// InstallationType: Output only. Installation type of the extension.
	//
	// Possible values:
	//   "INSTALLATION_TYPE_UNSPECIFIED" - Represents an unspecified installation
	// type.
	//   "MULTIPLE" - Represents instances of the extension having mixed
	// installation types.
	//   "NORMAL" - Represents a normal installation type.
	//   "ADMIN" - Represents an installation by admin.
	//   "DEVELOPMENT" - Represents a development installation type.
	//   "SIDELOAD" - Represents a sideload installation type.
	//   "OTHER" - Represents an installation type that is not covered in the other
	// options.
	InstallationType string `json:"installationType,omitempty"`
	// IsDisabled: Output only. Represents whether the user disabled the extension.
	IsDisabled bool `json:"isDisabled,omitempty"`
	// IsWebstoreExtension: Output only. Represents whether the extension is from
	// the webstore.
	IsWebstoreExtension bool `json:"isWebstoreExtension,omitempty"`
	// ManifestVersion: Output only. Manifest version of the extension.
	ManifestVersion int64 `json:"manifestVersion,omitempty"`
	// Name: Output only. Name of the extension.
	Name string `json:"name,omitempty"`
	// Permissions: Output only. Permissions requested by the extension.
	Permissions []string `json:"permissions,omitempty"`
	// Version: Output only. Version of the extension.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ReportingDataExtensionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ReportingDataExtensionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ReportingDataExtensionPolicyData:
// Information of the policies applied on an extension.
type GoogleChromeManagementVersionsV1ReportingDataExtensionPolicyData struct {
	// ExtensionId: Output only. ID of the extension.
	ExtensionId string `json:"extensionId,omitempty"`
	// ExtensionName: Output only. Name of the extension.
	ExtensionName string `json:"extensionName,omitempty"`
	// PolicyData: Output only. Information of the policies applied on the
	// extension.
	PolicyData []*GoogleChromeManagementVersionsV1ReportingDataPolicyData `json:"policyData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExtensionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExtensionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ReportingDataExtensionPolicyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ReportingDataExtensionPolicyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ReportingDataPolicyData: Information of a
// policy applied on a Chrome browser profile.
type GoogleChromeManagementVersionsV1ReportingDataPolicyData struct {
	// Conflicts: Output only. Conflicting policy information.
	Conflicts []*GoogleChromeManagementVersionsV1ReportingDataConflictingPolicyData `json:"conflicts,omitempty"`
	// Error: Output only. Error message of the policy, if any.
	Error string `json:"error,omitempty"`
	// Name: Output only. Name of the policy.
	Name string `json:"name,omitempty"`
	// Source: Output only. Source of the policy.
	//
	// Possible values:
	//   "POLICY_SOURCE_UNSPECIFIED" - Represents an unspecified policy source.
	//   "MACHINE_PLATFORM" - Represents a machine level platform policy.
	//   "USER_PLATFORM" - Represents a user level platform policy.
	//   "MACHINE_LEVEL_USER_CLOUD" - Represents a machine level user cloud policy.
	//   "USER_CLOUD" - Represents a user level cloud policy.
	//   "MACHINE_MERGED" - Represents a machine level merged policy.
	Source string `json:"source,omitempty"`
	// Value: Output only. Value of the policy.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conflicts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conflicts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ReportingDataPolicyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ReportingDataPolicyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1SignDataMetadata: Metadata for the
// long-running operation returned by signData.
type GoogleChromeManagementVersionsV1SignDataMetadata struct {
	// StartTime: Output only. Start time of the SignData operation.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1SignDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1SignDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1SignDataResponse: Response message for
// requesting a signature from the client that initated a certificate
// provisioning process.
type GoogleChromeManagementVersionsV1SignDataResponse struct {
	// CertificateProvisioningProcess: Output only. The certificate provisioning
	// process. The signature generated by the client will be available in the
	// `signature` field of `CertificateProvisioningProcess`.
	CertificateProvisioningProcess *GoogleChromeManagementVersionsV1CertificateProvisioningProcess `json:"certificateProvisioningProcess,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CertificateProvisioningProcess") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateProvisioningProcess")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1SignDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1SignDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementVersionsV1ThirdPartyProfileUser: A representation of
// non-Google (third party) user that is associated with a managed Chrome
// profile.
type GoogleChromeManagementVersionsV1ThirdPartyProfileUser struct {
	// Name: Identifier. Format:
	// customers/{customer_id}/thirdPartyProfileUsers/{third_party_profile_user_id}
	Name string `json:"name,omitempty"`
	// OrgUnitId: Output only. The ID of the organizational unit assigned to the
	// user.
	OrgUnitId string `json:"orgUnitId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleChromeManagementVersionsV1ThirdPartyProfileUser) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementVersionsV1ThirdPartyProfileUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CustomersAppsCountChromeAppRequestsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeAppRequests: Generate summary of app installation requests.
//
//   - customer: Customer id or "my_customer" to use the customer associated to
//     the account making the request.
func (r *CustomersAppsService) CountChromeAppRequests(customer string) *CustomersAppsCountChromeAppRequestsCall {
	c := &CustomersAppsCountChromeAppRequestsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// Supported fields: * request_count * latest_request_time
func (c *CustomersAppsCountChromeAppRequestsCall) OrderBy(orderBy string) *CustomersAppsCountChromeAppRequestsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersAppsCountChromeAppRequestsCall) OrgUnitId(orgUnitId string) *CustomersAppsCountChromeAppRequestsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 50, anything above will be coerced to 50.
func (c *CustomersAppsCountChromeAppRequestsCall) PageSize(pageSize int64) *CustomersAppsCountChromeAppRequestsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned.
func (c *CustomersAppsCountChromeAppRequestsCall) PageToken(pageToken string) *CustomersAppsCountChromeAppRequestsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsCountChromeAppRequestsCall) Fields(s ...googleapi.Field) *CustomersAppsCountChromeAppRequestsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsCountChromeAppRequestsCall) IfNoneMatch(entityTag string) *CustomersAppsCountChromeAppRequestsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsCountChromeAppRequestsCall) Context(ctx context.Context) *CustomersAppsCountChromeAppRequestsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsCountChromeAppRequestsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsCountChromeAppRequestsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/apps:countChromeAppRequests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.countChromeAppRequests", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.countChromeAppRequests" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeAppRequestsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersAppsCountChromeAppRequestsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeAppRequestsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeAppRequestsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.countChromeAppRequests", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersAppsCountChromeAppRequestsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountChromeAppRequestsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersAppsFetchDevicesRequestingExtensionCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchDevicesRequestingExtension: Get a list of devices that have requested
// to install an extension.
//
// - customer: The customer ID or "my_customer" prefixed with "customers/".
func (r *CustomersAppsService) FetchDevicesRequestingExtension(customer string) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c := &CustomersAppsFetchDevicesRequestingExtensionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// ExtensionId sets the optional parameter "extensionId": Required. The
// extension for which we want to find requesting devices.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) ExtensionId(extensionId string) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.urlParams_.Set("extensionId", extensionId)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit. Only consider devices that directly belong to this org
// unit, i.e. sub-orgunits are not counted. If omitted, all data will be
// returned.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) OrgUnitId(orgUnitId string) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 50. Any page size larger than 50 will be
// coerced to 50.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) PageSize(pageSize int64) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned. Token expires after 1 day.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) PageToken(pageToken string) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) Fields(s ...googleapi.Field) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) IfNoneMatch(entityTag string) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) Context(ctx context.Context) *CustomersAppsFetchDevicesRequestingExtensionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsFetchDevicesRequestingExtensionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/apps:fetchDevicesRequestingExtension")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.fetchDevicesRequestingExtension", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.fetchDevicesRequestingExtension" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.fetchDevicesRequestingExtension", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersAppsFetchDevicesRequestingExtensionCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1FetchDevicesRequestingExtensionResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersAppsFetchUsersRequestingExtensionCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchUsersRequestingExtension: Get a list of users that have requested to
// install an extension.
//
// - customer: The customer ID or "my_customer" prefixed with "customers/".
func (r *CustomersAppsService) FetchUsersRequestingExtension(customer string) *CustomersAppsFetchUsersRequestingExtensionCall {
	c := &CustomersAppsFetchUsersRequestingExtensionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// ExtensionId sets the optional parameter "extensionId": Required. The
// extension for which we want to find the requesting users.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) ExtensionId(extensionId string) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.urlParams_.Set("extensionId", extensionId)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit. Only consider devices that directly belong to this org
// unit, i.e. sub-orgunits are not counted. If omitted, all data will be
// returned.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) OrgUnitId(orgUnitId string) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 50. Any page size larger than 50 will be
// coerced to 50.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) PageSize(pageSize int64) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned. Token expires after 1 day.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) PageToken(pageToken string) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) Fields(s ...googleapi.Field) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) IfNoneMatch(entityTag string) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) Context(ctx context.Context) *CustomersAppsFetchUsersRequestingExtensionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsFetchUsersRequestingExtensionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/apps:fetchUsersRequestingExtension")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.fetchUsersRequestingExtension", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.fetchUsersRequestingExtension" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1FetchUsersRequestingExtensionResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1FetchUsersRequestingExtensionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1FetchUsersRequestingExtensionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.fetchUsersRequestingExtension", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersAppsFetchUsersRequestingExtensionCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1FetchUsersRequestingExtensionResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersAppsAndroidGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
//   - name: The app for which details are being queried. Examples:
//     "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2"
//     for the Save to Google Drive Chrome extension version 2.1.2,
//     "customers/my_customer/apps/android/com.google.android.apps.docs" for the
//     Google Drive Android app's latest version.
func (r *CustomersAppsAndroidService) Get(name string) *CustomersAppsAndroidGetCall {
	c := &CustomersAppsAndroidGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsAndroidGetCall) Fields(s ...googleapi.Field) *CustomersAppsAndroidGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsAndroidGetCall) IfNoneMatch(entityTag string) *CustomersAppsAndroidGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsAndroidGetCall) Context(ctx context.Context) *CustomersAppsAndroidGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsAndroidGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsAndroidGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.android.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.android.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1AppDetails.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersAppsAndroidGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.android.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersAppsChromeGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
//   - name: The app for which details are being queried. Examples:
//     "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2"
//     for the Save to Google Drive Chrome extension version 2.1.2,
//     "customers/my_customer/apps/android/com.google.android.apps.docs" for the
//     Google Drive Android app's latest version.
func (r *CustomersAppsChromeService) Get(name string) *CustomersAppsChromeGetCall {
	c := &CustomersAppsChromeGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsChromeGetCall) Fields(s ...googleapi.Field) *CustomersAppsChromeGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsChromeGetCall) IfNoneMatch(entityTag string) *CustomersAppsChromeGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsChromeGetCall) Context(ctx context.Context) *CustomersAppsChromeGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsChromeGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsChromeGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.chrome.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.chrome.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1AppDetails.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersAppsChromeGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.chrome.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersAppsWebGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a specific app for a customer by its resource name.
//
//   - name: The app for which details are being queried. Examples:
//     "customers/my_customer/apps/chrome/gmbmikajjgmnabiglmofipeabaddhgne@2.1.2"
//     for the Save to Google Drive Chrome extension version 2.1.2,
//     "customers/my_customer/apps/android/com.google.android.apps.docs" for the
//     Google Drive Android app's latest version.
func (r *CustomersAppsWebService) Get(name string) *CustomersAppsWebGetCall {
	c := &CustomersAppsWebGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersAppsWebGetCall) Fields(s ...googleapi.Field) *CustomersAppsWebGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersAppsWebGetCall) IfNoneMatch(entityTag string) *CustomersAppsWebGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersAppsWebGetCall) Context(ctx context.Context) *CustomersAppsWebGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersAppsWebGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersAppsWebGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.web.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.apps.web.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1AppDetails.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersAppsWebGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1AppDetails, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1AppDetails{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.apps.web.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersProfilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the data collected from a Chrome browser profile.
//
// - name: Format: customers/{customer_id}/profiles/{profile_permanent_id}.
func (r *CustomersProfilesService) Delete(name string) *CustomersProfilesDeleteCall {
	c := &CustomersProfilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesDeleteCall) Fields(s ...googleapi.Field) *CustomersProfilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesDeleteCall) Context(ctx context.Context) *CustomersProfilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersProfilesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Chrome browser profile with customer ID and profile permanent
// ID.
//
// - name: Format: customers/{customer_id}/profiles/{profile_permanent_id}.
func (r *CustomersProfilesService) Get(name string) *CustomersProfilesGetCall {
	c := &CustomersProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesGetCall) Fields(s ...googleapi.Field) *CustomersProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersProfilesGetCall) IfNoneMatch(entityTag string) *CustomersProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesGetCall) Context(ctx context.Context) *CustomersProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1ChromeBrowserProfile.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersProfilesGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1ChromeBrowserProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1ChromeBrowserProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Chrome browser profiles of a customer based on the given search
// and sorting criteria.
//
// - parent: Format: customers/{customer_id}.
func (r *CustomersProfilesService) List(parent string) *CustomersProfilesListCall {
	c := &CustomersProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter used to filter
// profiles. The following fields can be used in the filter: - profile_id -
// display_name - user_email - last_activity_time - last_policy_sync_time -
// last_status_report_time - first_enrollment_time - os_platform_type -
// os_version - browser_version - browser_channel - policy_count -
// extension_count - identity_provider - affiliation_state -
// os_platform_version - ouId Any of the above fields can be used to specify a
// filter, and filtering by multiple fields is supported with AND operator.
// String type fields and enum type fields support '=' and '!=' operators. The
// integer type and the timestamp type fields support '=', '!=', '<', '>', '<='
// and '>=' operators. Timestamps expect an RFC-3339 formatted string (e.g.
// 2012-04-21T11:30:00-04:00). Wildcard '*' can be used with a string type
// field filter. In addition, string literal filtering is also supported, for
// example, 'ABC' as a filter maps to a filter that checks if any of the
// filterable string type fields contains 'ABC'. Organization unit number can
// be used as a filtering criteria here by specifying 'ouId =
// ${your_org_unit_id}', please note that only single OU ID matching is
// supported.
func (c *CustomersProfilesListCall) Filter(filter string) *CustomersProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The fields used to specify
// the ordering of the results. The supported fields are: - profile_id -
// display_name - user_email - last_activity_time - last_policy_sync_time -
// last_status_report_time - first_enrollment_time - os_platform_type -
// os_version - browser_version - browser_channel - policy_count -
// extension_count - identity_provider - affiliation_state -
// os_platform_version By default, sorting is in ascending order, to specify
// descending order for a field, a suffix " desc" should be added to the field
// name. The default ordering is the descending order of
// last_status_report_time.
func (c *CustomersProfilesListCall) OrderBy(orderBy string) *CustomersProfilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// profiles to return. The default page size is 100 if page_size is
// unspecified, and the maximum page size allowed is 200.
func (c *CustomersProfilesListCall) PageSize(pageSize int64) *CustomersProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token used to
// retrieve a specific page of the listing request.
func (c *CustomersProfilesListCall) PageToken(pageToken string) *CustomersProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesListCall) Fields(s ...googleapi.Field) *CustomersProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersProfilesListCall) IfNoneMatch(entityTag string) *CustomersProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesListCall) Context(ctx context.Context) *CustomersProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/profiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersProfilesListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersProfilesListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementVersionsV1ListChromeBrowserProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersProfilesCommandsCreateCall struct {
	s                                                           *Service
	parent                                                      string
	googlechromemanagementversionsv1chromebrowserprofilecommand *GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Create: Creates a Chrome browser profile remote command.
//
// - parent: Format: customers/{customer_id}/profiles/{profile_permanent_id}.
func (r *CustomersProfilesCommandsService) Create(parent string, googlechromemanagementversionsv1chromebrowserprofilecommand *GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand) *CustomersProfilesCommandsCreateCall {
	c := &CustomersProfilesCommandsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlechromemanagementversionsv1chromebrowserprofilecommand = googlechromemanagementversionsv1chromebrowserprofilecommand
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesCommandsCreateCall) Fields(s ...googleapi.Field) *CustomersProfilesCommandsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesCommandsCreateCall) Context(ctx context.Context) *CustomersProfilesCommandsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesCommandsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesCommandsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromemanagementversionsv1chromebrowserprofilecommand)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/commands")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.commands.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersProfilesCommandsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersProfilesCommandsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Chrome browser profile remote command.
//
//   - name: Format:
//     customers/{customer_id}/profiles/{profile_permanent_id}/commands/{command_i
//     d}.
func (r *CustomersProfilesCommandsService) Get(name string) *CustomersProfilesCommandsGetCall {
	c := &CustomersProfilesCommandsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesCommandsGetCall) Fields(s ...googleapi.Field) *CustomersProfilesCommandsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersProfilesCommandsGetCall) IfNoneMatch(entityTag string) *CustomersProfilesCommandsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesCommandsGetCall) Context(ctx context.Context) *CustomersProfilesCommandsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesCommandsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesCommandsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.commands.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersProfilesCommandsGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1ChromeBrowserProfileCommand{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersProfilesCommandsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists remote commands of a Chrome browser profile.
//
// - parent: Format: customers/{customer_id}/profiles/{profile_permanent_id}.
func (r *CustomersProfilesCommandsService) List(parent string) *CustomersProfilesCommandsListCall {
	c := &CustomersProfilesCommandsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// commands to return. The default page size is 100 if page_size is
// unspecified, and the maximum page size allowed is 100.
func (c *CustomersProfilesCommandsListCall) PageSize(pageSize int64) *CustomersProfilesCommandsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token used to
// retrieve a specific page of the listing request.
func (c *CustomersProfilesCommandsListCall) PageToken(pageToken string) *CustomersProfilesCommandsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersProfilesCommandsListCall) Fields(s ...googleapi.Field) *CustomersProfilesCommandsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersProfilesCommandsListCall) IfNoneMatch(entityTag string) *CustomersProfilesCommandsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersProfilesCommandsListCall) Context(ctx context.Context) *CustomersProfilesCommandsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersProfilesCommandsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersProfilesCommandsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/commands")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.profiles.commands.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse.Ser
// verResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersProfilesCommandsListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.profiles.commands.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersProfilesCommandsListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementVersionsV1ListChromeBrowserProfileCommandsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsCountChromeBrowsersNeedingAttentionCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeBrowsersNeedingAttention: Count of Chrome Browsers that have been
// recently enrolled, have new policy to be synced, or have no recent activity.
//
// - customer: The customer ID or "my_customer" prefixed with "customers/".
func (r *CustomersReportsService) CountChromeBrowsersNeedingAttention(customer string) *CustomersReportsCountChromeBrowsersNeedingAttentionCall {
	c := &CustomersReportsCountChromeBrowsersNeedingAttentionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit. If omitted, all data will be returned.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeBrowsersNeedingAttentionCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeBrowsersNeedingAttentionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeBrowsersNeedingAttentionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) Context(ctx context.Context) *CustomersReportsCountChromeBrowsersNeedingAttentionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeBrowsersNeedingAttention")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeBrowsersNeedingAttention", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeBrowsersNeedingAttention" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeBrowsersNeedingAttentionCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeBrowsersNeedingAttentionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeBrowsersNeedingAttention", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersReportsCountChromeCrashEventsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeCrashEvents: Get a count of Chrome crash events.
//
// - customer: Customer ID.
func (r *CustomersReportsService) CountChromeCrashEvents(customer string) *CustomersReportsCountChromeCrashEventsCall {
	c := &CustomersReportsCountChromeCrashEventsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Supported filter fields: *
// major_browser_version * minor_browser_version * browser_channel *
// device_platform * past_number_days Example: `major_browser_version = 'M115'
// AND past_number_days = '28'`.
func (c *CustomersReportsCountChromeCrashEventsCall) Filter(filter string) *CustomersReportsCountChromeCrashEventsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// Supported order by fields: * browser_version * count * date
func (c *CustomersReportsCountChromeCrashEventsCall) OrderBy(orderBy string) *CustomersReportsCountChromeCrashEventsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": If specified, only count
// the number of crash events of the devices in this organizational unit.
func (c *CustomersReportsCountChromeCrashEventsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeCrashEventsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeCrashEventsCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeCrashEventsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeCrashEventsCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeCrashEventsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeCrashEventsCall) Context(ctx context.Context) *CustomersReportsCountChromeCrashEventsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeCrashEventsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeCrashEventsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeCrashEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeCrashEvents", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeCrashEvents" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeCrashEventsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeCrashEventsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeCrashEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeCrashEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeCrashEvents", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeDevicesReachingAutoExpirationDate: Generate report of the number
// of devices expiring in each month of the selected time frame. Devices are
// grouped by auto update expiration date and model. Further information can be
// found here (https://support.google.com/chrome/a/answer/10564947).
//
// - customer: The customer ID or "my_customer" prefixed with "customers/".
func (r *CustomersReportsService) CountChromeDevicesReachingAutoExpirationDate(customer string) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c := &CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// MaxAueDate sets the optional parameter "maxAueDate": Maximum expiration date
// in format yyyy-mm-dd in UTC timezone. If included returns all devices that
// have already expired and devices with auto expiration date equal to or
// earlier than the maximum date.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) MaxAueDate(maxAueDate string) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.urlParams_.Set("maxAueDate", maxAueDate)
	return c
}

// MinAueDate sets the optional parameter "minAueDate": Maximum expiration date
// in format yyyy-mm-dd in UTC timezone. If included returns all devices that
// have already expired and devices with auto expiration date equal to or later
// than the minimum date.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) MinAueDate(minAueDate string) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.urlParams_.Set("minAueDate", minAueDate)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The organizational unit
// ID, if omitted, will return data for all organizational units.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) Context(ctx context.Context) *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeDevicesReachingAutoExpirationDate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeDevicesReachingAutoExpirationDate", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeDevicesReachingAutoExpirationDate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse
// .ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeDevicesReachingAutoExpirationDateCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeDevicesReachingAutoExpirationDateResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeDevicesReachingAutoExpirationDate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersReportsCountChromeDevicesThatNeedAttentionCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeDevicesThatNeedAttention: Counts of ChromeOS devices that have
// not synced policies or have lacked user activity in the past 28 days, are
// out of date, or are not complaint. Further information can be found here
// https://support.google.com/chrome/a/answer/10564947
//
// - customer: The customer ID or "my_customer" prefixed with "customers/".
func (r *CustomersReportsService) CountChromeDevicesThatNeedAttention(customer string) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c := &CustomersReportsCountChromeDevicesThatNeedAttentionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit. If omitted, all data will be returned.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// ReadMask sets the optional parameter "readMask": Required. Mask of the
// fields that should be populated in the returned report.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) ReadMask(readMask string) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) Context(ctx context.Context) *CustomersReportsCountChromeDevicesThatNeedAttentionCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeDevicesThatNeedAttention")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeDevicesThatNeedAttention", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeDevicesThatNeedAttention" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeDevicesThatNeedAttentionCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeDevicesThatNeedAttentionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeDevicesThatNeedAttention", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersReportsCountChromeHardwareFleetDevicesCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeHardwareFleetDevices: Counts of devices with a specific hardware
// specification from the requested hardware type (for example model name,
// processor type). Further information can be found here
// https://support.google.com/chrome/a/answer/10564947
//
// - customer: The customer ID or "my_customer".
func (r *CustomersReportsService) CountChromeHardwareFleetDevices(customer string) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c := &CustomersReportsCountChromeHardwareFleetDevicesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit. If omitted, all data will be returned.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// ReadMask sets the optional parameter "readMask": Required. Mask of the
// fields that should be populated in the returned report.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) ReadMask(readMask string) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) Context(ctx context.Context) *CustomersReportsCountChromeHardwareFleetDevicesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeHardwareFleetDevices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeHardwareFleetDevices", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeHardwareFleetDevices" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeHardwareFleetDevicesCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeHardwareFleetDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeHardwareFleetDevices", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersReportsCountChromeVersionsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeVersions: Generate report of installed Chrome versions.
//
//   - customer: Customer id or "my_customer" to use the customer associated to
//     the account making the request.
func (r *CustomersReportsService) CountChromeVersions(customer string) *CustomersReportsCountChromeVersionsCall {
	c := &CustomersReportsCountChromeVersionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Supported filter fields: * last_active_date
func (c *CustomersReportsCountChromeVersionsCall) Filter(filter string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountChromeVersionsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 100.
func (c *CustomersReportsCountChromeVersionsCall) PageSize(pageSize int64) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned.
func (c *CustomersReportsCountChromeVersionsCall) PageToken(pageToken string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountChromeVersionsCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountChromeVersionsCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeVersionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountChromeVersionsCall) Context(ctx context.Context) *CustomersReportsCountChromeVersionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountChromeVersionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeVersionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeVersions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeVersions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountChromeVersionsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsCountChromeVersionsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountChromeVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countChromeVersions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountChromeVersionsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountChromeVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsCountInstalledAppsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountInstalledApps: Generate report of app installations.
//
//   - customer: Customer id or "my_customer" to use the customer associated to
//     the account making the request.
func (r *CustomersReportsService) CountInstalledApps(customer string) *CustomersReportsCountInstalledAppsCall {
	c := &CustomersReportsCountInstalledAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Supported filter fields: * app_name * app_type *
// install_type * number_of_permissions * total_install_count *
// latest_profile_active_date * permission_name * app_id * manifest_versions *
// risk_score
func (c *CustomersReportsCountInstalledAppsCall) Filter(filter string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// Supported order by fields: * app_name * app_type * install_type *
// number_of_permissions * total_install_count * app_id * manifest_versions *
// risk_score
func (c *CustomersReportsCountInstalledAppsCall) OrderBy(orderBy string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountInstalledAppsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 100.
func (c *CustomersReportsCountInstalledAppsCall) PageSize(pageSize int64) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned.
func (c *CustomersReportsCountInstalledAppsCall) PageToken(pageToken string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountInstalledAppsCall) Fields(s ...googleapi.Field) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountInstalledAppsCall) IfNoneMatch(entityTag string) *CustomersReportsCountInstalledAppsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountInstalledAppsCall) Context(ctx context.Context) *CustomersReportsCountInstalledAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountInstalledAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountInstalledAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countInstalledApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countInstalledApps", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countInstalledApps" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountInstalledAppsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsCountInstalledAppsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountInstalledAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountInstalledAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countInstalledApps", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountInstalledAppsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountInstalledAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsCountPrintJobsByPrinterCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountPrintJobsByPrinter: Get a summary of printing done by each printer.
//
//   - customer: Customer ID prefixed with "customers/" or
//     "customers/my_customer" to use the customer associated to the account
//     making the request.
func (r *CustomersReportsService) CountPrintJobsByPrinter(customer string) *CustomersReportsCountPrintJobsByPrinterCall {
	c := &CustomersReportsCountPrintJobsByPrinterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Note: Only >= and <= comparators are supported in this
// filter. Supported filter fields: * complete_time
func (c *CustomersReportsCountPrintJobsByPrinterCall) Filter(filter string) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// If omitted, results will be ordered in ascending order of the 'printer'
// field. Supported order_by fields: * printer * job_count * device_count *
// user_count
func (c *CustomersReportsCountPrintJobsByPrinterCall) OrderBy(orderBy string) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 100.
func (c *CustomersReportsCountPrintJobsByPrinterCall) PageSize(pageSize int64) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the response to be returned.
func (c *CustomersReportsCountPrintJobsByPrinterCall) PageToken(pageToken string) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PrinterOrgUnitId sets the optional parameter "printerOrgUnitId": The ID of
// the organizational unit for printers. If specified, only data for printers
// from the specified organizational unit will be returned. If omitted, data
// for printers from all organizational units will be returned.
func (c *CustomersReportsCountPrintJobsByPrinterCall) PrinterOrgUnitId(printerOrgUnitId string) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("printerOrgUnitId", printerOrgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountPrintJobsByPrinterCall) Fields(s ...googleapi.Field) *CustomersReportsCountPrintJobsByPrinterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountPrintJobsByPrinterCall) IfNoneMatch(entityTag string) *CustomersReportsCountPrintJobsByPrinterCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountPrintJobsByPrinterCall) Context(ctx context.Context) *CustomersReportsCountPrintJobsByPrinterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountPrintJobsByPrinterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountPrintJobsByPrinterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countPrintJobsByPrinter")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countPrintJobsByPrinter", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countPrintJobsByPrinter" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountPrintJobsByPrinterResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsCountPrintJobsByPrinterCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountPrintJobsByPrinterResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountPrintJobsByPrinterResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countPrintJobsByPrinter", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountPrintJobsByPrinterCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountPrintJobsByPrinterResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsCountPrintJobsByUserCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountPrintJobsByUser: Get a summary of printing done by each user.
//
//   - customer: Customer ID prefixed with "customers/" or
//     "customers/my_customer" to use the customer associated to the account
//     making the request.
func (r *CustomersReportsService) CountPrintJobsByUser(customer string) *CustomersReportsCountPrintJobsByUserCall {
	c := &CustomersReportsCountPrintJobsByUserCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Note: Only >= and <= comparators are supported in this
// filter. Supported filter fields: * complete_time
func (c *CustomersReportsCountPrintJobsByUserCall) Filter(filter string) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// If omitted, results will be ordered in ascending order of the 'user_email'
// field. Supported order_by fields: * user_email * job_count * printer_count *
// device_count
func (c *CustomersReportsCountPrintJobsByUserCall) OrderBy(orderBy string) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 100.
func (c *CustomersReportsCountPrintJobsByUserCall) PageSize(pageSize int64) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the response to be returned.
func (c *CustomersReportsCountPrintJobsByUserCall) PageToken(pageToken string) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PrinterOrgUnitId sets the optional parameter "printerOrgUnitId": The ID of
// the organizational unit for printers. If specified, only print jobs
// initiated with printers from the specified organizational unit will be
// counted. If omitted, all print jobs will be counted.
func (c *CustomersReportsCountPrintJobsByUserCall) PrinterOrgUnitId(printerOrgUnitId string) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("printerOrgUnitId", printerOrgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsCountPrintJobsByUserCall) Fields(s ...googleapi.Field) *CustomersReportsCountPrintJobsByUserCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsCountPrintJobsByUserCall) IfNoneMatch(entityTag string) *CustomersReportsCountPrintJobsByUserCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsCountPrintJobsByUserCall) Context(ctx context.Context) *CustomersReportsCountPrintJobsByUserCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsCountPrintJobsByUserCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountPrintJobsByUserCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countPrintJobsByUser")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countPrintJobsByUser", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countPrintJobsByUser" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1CountPrintJobsByUserResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsCountPrintJobsByUserCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountPrintJobsByUserResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1CountPrintJobsByUserResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.countPrintJobsByUser", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountPrintJobsByUserCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountPrintJobsByUserResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsEnumeratePrintJobsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// EnumeratePrintJobs: Get a list of print jobs.
//
//   - customer: Customer ID prefixed with "customers/" or
//     "customers/my_customer" to use the customer associated to the account
//     making the request.
func (r *CustomersReportsService) EnumeratePrintJobs(customer string) *CustomersReportsEnumeratePrintJobsCall {
	c := &CustomersReportsEnumeratePrintJobsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Note: Only >= and <= comparators are supported for
// `complete_time`. Note: Only = comparator supported for `user_id` and
// `printer_id`. Supported filter fields: * complete_time * printer_id *
// user_id
func (c *CustomersReportsEnumeratePrintJobsCall) Filter(filter string) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// If not specified, results will be ordered in descending order of the
// `complete_time` field. Supported order by fields: * title * state *
// create_time * complete_time * document_page_count * color_mode * duplex_mode
// * printer * user_email
func (c *CustomersReportsEnumeratePrintJobsCall) OrderBy(orderBy string) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The number of print jobs in
// the page from 0 to 100 inclusive, if page_size is not specified or zero, the
// size will be 50.
func (c *CustomersReportsEnumeratePrintJobsCall) PageSize(pageSize int64) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous `EnumeratePrintJobs` call. Provide this to retrieve the
// subsequent page. If omitted, the first page of results will be returned.
// When paginating, all other parameters provided to `EnumeratePrintJobs` must
// match the call that provided the page token.
func (c *CustomersReportsEnumeratePrintJobsCall) PageToken(pageToken string) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// PrinterOrgUnitId sets the optional parameter "printerOrgUnitId": The ID of
// the organizational unit for printers. If specified, only print jobs
// submitted to printers from the specified organizational unit will be
// returned.
func (c *CustomersReportsEnumeratePrintJobsCall) PrinterOrgUnitId(printerOrgUnitId string) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("printerOrgUnitId", printerOrgUnitId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsEnumeratePrintJobsCall) Fields(s ...googleapi.Field) *CustomersReportsEnumeratePrintJobsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsEnumeratePrintJobsCall) IfNoneMatch(entityTag string) *CustomersReportsEnumeratePrintJobsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsEnumeratePrintJobsCall) Context(ctx context.Context) *CustomersReportsEnumeratePrintJobsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsEnumeratePrintJobsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsEnumeratePrintJobsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:enumeratePrintJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.enumeratePrintJobs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.enumeratePrintJobs" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1EnumeratePrintJobsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsEnumeratePrintJobsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1EnumeratePrintJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1EnumeratePrintJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.enumeratePrintJobs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsEnumeratePrintJobsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1EnumeratePrintJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersReportsFindInstalledAppDevicesCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FindInstalledAppDevices: Generate report of managed Chrome browser devices
// that have a specified app installed.
//
//   - customer: Customer id or "my_customer" to use the customer associated to
//     the account making the request.
func (r *CustomersReportsService) FindInstalledAppDevices(customer string) *CustomersReportsFindInstalledAppDevicesCall {
	c := &CustomersReportsFindInstalledAppDevicesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// AppId sets the optional parameter "appId": Unique identifier of the app. For
// Chrome apps and extensions, the 32-character id (e.g.
// ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name (e.g.
// com.evernote).
func (c *CustomersReportsFindInstalledAppDevicesCall) AppId(appId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appId", appId)
	return c
}

// AppType sets the optional parameter "appType": Type of the app.  If not
// provided, an app type will be inferred from the format of the app ID.
//
// Possible values:
//
//	"APP_TYPE_UNSPECIFIED" - App type not specified.
//	"EXTENSION" - Chrome extension.
//	"APP" - Chrome app.
//	"THEME" - Chrome theme.
//	"HOSTED_APP" - Chrome hosted app.
//	"ANDROID_APP" - ARC++ app.
func (c *CustomersReportsFindInstalledAppDevicesCall) AppType(appType string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appType", appType)
	return c
}

// Filter sets the optional parameter "filter": Query string to filter results,
// AND-separated fields in EBNF syntax. Note: OR operations are not supported
// in this filter. Supported filter fields: * last_active_date
func (c *CustomersReportsFindInstalledAppDevicesCall) Filter(filter string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order results.
// Supported order by fields: * machine * device_id
func (c *CustomersReportsFindInstalledAppDevicesCall) OrderBy(orderBy string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsFindInstalledAppDevicesCall) OrgUnitId(orgUnitId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Maximum and default are 100.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageSize(pageSize int64) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify the page
// of the request to be returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageToken(pageToken string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersReportsFindInstalledAppDevicesCall) Fields(s ...googleapi.Field) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersReportsFindInstalledAppDevicesCall) IfNoneMatch(entityTag string) *CustomersReportsFindInstalledAppDevicesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersReportsFindInstalledAppDevicesCall) Context(ctx context.Context) *CustomersReportsFindInstalledAppDevicesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersReportsFindInstalledAppDevicesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsFindInstalledAppDevicesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:findInstalledAppDevices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.findInstalledAppDevices", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.findInstalledAppDevices" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1FindInstalledAppDevicesResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1FindInstalledAppDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1FindInstalledAppDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.reports.findInstalledAppDevices", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsFindInstalledAppDevicesCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1FindInstalledAppDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersTelemetryDevicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get telemetry device.
//
// - name: Name of the `TelemetryDevice` to return.
func (r *CustomersTelemetryDevicesService) Get(name string) *CustomersTelemetryDevicesGetCall {
	c := &CustomersTelemetryDevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ReadMask sets the optional parameter "readMask": Required. Read mask to
// specify which fields to return. Supported read_mask paths are: - name -
// org_unit_id - device_id - serial_number - cpu_info - cpu_status_report -
// memory_info - memory_status_report - network_info -
// network_diagnostics_report - network_status_report - os_update_status -
// graphics_info - graphics_status_report - battery_info -
// battery_status_report - storage_info - storage_status_report -
// thunderbolt_info - audio_status_report - boot_performance_report -
// heartbeat_status_report - network_bandwidth_report - peripherals_report -
// kiosk_app_status_report - app_report - runtime_counters_report
func (c *CustomersTelemetryDevicesGetCall) ReadMask(readMask string) *CustomersTelemetryDevicesGetCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryDevicesGetCall) Fields(s ...googleapi.Field) *CustomersTelemetryDevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryDevicesGetCall) IfNoneMatch(entityTag string) *CustomersTelemetryDevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryDevicesGetCall) Context(ctx context.Context) *CustomersTelemetryDevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryDevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryDevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.devices.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.devices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1TelemetryDevice.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryDevicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1TelemetryDevice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1TelemetryDevice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.devices.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersTelemetryDevicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all telemetry devices.
//
//   - parent: Customer id or "my_customer" to use the customer associated to the
//     account making the request.
func (r *CustomersTelemetryDevicesService) List(parent string) *CustomersTelemetryDevicesListCall {
	c := &CustomersTelemetryDevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Only include resources that
// match the filter. Requests that don't specify a "reports_timestamp" value
// will default to returning only recent reports. Specify
// "reports_timestamp>=0" to get all report data. Supported filter fields: -
// org_unit_id - serial_number - device_id - reports_timestamp The
// "reports_timestamp" filter accepts either the Unix Epoch milliseconds format
// or the RFC3339 UTC "Zulu" format with nanosecond resolution and up to nine
// fractional digits. Both formats should be surrounded by simple double
// quotes. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z",
// "1679283943823".
func (c *CustomersTelemetryDevicesListCall) Filter(filter string) *CustomersTelemetryDevicesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Default value is 100. Maximum value is 1000.
func (c *CustomersTelemetryDevicesListCall) PageSize(pageSize int64) *CustomersTelemetryDevicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list.
func (c *CustomersTelemetryDevicesListCall) PageToken(pageToken string) *CustomersTelemetryDevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": Required. Read mask to
// specify which fields to return. Supported read_mask paths are: - name -
// org_unit_id - device_id - serial_number - cpu_info - cpu_status_report -
// memory_info - memory_status_report - network_info -
// network_diagnostics_report - network_status_report - os_update_status -
// graphics_info - graphics_status_report - battery_info -
// battery_status_report - storage_info - storage_status_report -
// thunderbolt_info - audio_status_report - boot_performance_report -
// heartbeat_status_report - network_bandwidth_report - peripherals_report -
// kiosk_app_status_report - app_report - runtime_counters_report
func (c *CustomersTelemetryDevicesListCall) ReadMask(readMask string) *CustomersTelemetryDevicesListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryDevicesListCall) Fields(s ...googleapi.Field) *CustomersTelemetryDevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryDevicesListCall) IfNoneMatch(entityTag string) *CustomersTelemetryDevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryDevicesListCall) Context(ctx context.Context) *CustomersTelemetryDevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryDevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryDevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/telemetry/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.devices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.devices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1ListTelemetryDevicesResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryDevicesListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1ListTelemetryDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1ListTelemetryDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.devices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersTelemetryDevicesListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1ListTelemetryDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersTelemetryEventsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List telemetry events.
//
//   - parent: Customer id or "my_customer" to use the customer associated to the
//     account making the request.
func (r *CustomersTelemetryEventsService) List(parent string) *CustomersTelemetryEventsListCall {
	c := &CustomersTelemetryEventsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Only include resources that
// match the filter. Although this parameter is currently optional, this
// parameter will be required- please specify at least 1 event type. Supported
// filter fields: - device_id - user_id - device_org_unit_id - user_org_unit_id
// - timestamp - event_type The "timestamp" filter accepts either the Unix
// Epoch milliseconds format or the RFC3339 UTC "Zulu" format with nanosecond
// resolution and up to nine fractional digits. Both formats should be
// surrounded by simple double quotes. Examples: "2014-10-02T15:01:23Z",
// "2014-10-02T15:01:23.045123456Z", "1679283943823".
func (c *CustomersTelemetryEventsListCall) Filter(filter string) *CustomersTelemetryEventsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Default value is 100. Maximum value is 1000.
func (c *CustomersTelemetryEventsListCall) PageSize(pageSize int64) *CustomersTelemetryEventsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list.
func (c *CustomersTelemetryEventsListCall) PageToken(pageToken string) *CustomersTelemetryEventsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": Required. Read mask to
// specify which fields to return. Although currently required, this field will
// become optional, while the filter parameter with an event type will be come
// required. Supported read_mask paths are: - device - user -
// audio_severe_underrun_event - usb_peripherals_event -
// https_latency_change_event - network_state_change_event -
// wifi_signal_strength_event - vpn_connection_state_change_event -
// app_install_event - app_uninstall_event - app_launch_event - os_crash_event
// - external_displays_event
func (c *CustomersTelemetryEventsListCall) ReadMask(readMask string) *CustomersTelemetryEventsListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryEventsListCall) Fields(s ...googleapi.Field) *CustomersTelemetryEventsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryEventsListCall) IfNoneMatch(entityTag string) *CustomersTelemetryEventsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryEventsListCall) Context(ctx context.Context) *CustomersTelemetryEventsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryEventsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryEventsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/telemetry/events")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.events.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.events.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1ListTelemetryEventsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryEventsListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1ListTelemetryEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1ListTelemetryEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.events.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersTelemetryEventsListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1ListTelemetryEventsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersTelemetryNotificationConfigsCreateCall struct {
	s                                                   *Service
	parent                                              string
	googlechromemanagementv1telemetrynotificationconfig *GoogleChromeManagementV1TelemetryNotificationConfig
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Create: Create a telemetry notification config.
//
//   - parent: The parent resource where this notification config will be
//     created. Format: `customers/{customer}`.
func (r *CustomersTelemetryNotificationConfigsService) Create(parent string, googlechromemanagementv1telemetrynotificationconfig *GoogleChromeManagementV1TelemetryNotificationConfig) *CustomersTelemetryNotificationConfigsCreateCall {
	c := &CustomersTelemetryNotificationConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlechromemanagementv1telemetrynotificationconfig = googlechromemanagementv1telemetrynotificationconfig
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryNotificationConfigsCreateCall) Fields(s ...googleapi.Field) *CustomersTelemetryNotificationConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryNotificationConfigsCreateCall) Context(ctx context.Context) *CustomersTelemetryNotificationConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryNotificationConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryNotificationConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromemanagementv1telemetrynotificationconfig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/telemetry/notificationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.notificationConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1TelemetryNotificationConfig.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryNotificationConfigsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1TelemetryNotificationConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1TelemetryNotificationConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersTelemetryNotificationConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a telemetry notification config.
//
//   - name: The name of the notification config to delete. Format:
//     `customers/{customer}/telemetry/notificationConfigs/{notification_config}`.
func (r *CustomersTelemetryNotificationConfigsService) Delete(name string) *CustomersTelemetryNotificationConfigsDeleteCall {
	c := &CustomersTelemetryNotificationConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryNotificationConfigsDeleteCall) Fields(s ...googleapi.Field) *CustomersTelemetryNotificationConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryNotificationConfigsDeleteCall) Context(ctx context.Context) *CustomersTelemetryNotificationConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryNotificationConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryNotificationConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.notificationConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersTelemetryNotificationConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersTelemetryNotificationConfigsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all telemetry notification configs.
//
// - parent: The parent which owns the notification configs.
func (r *CustomersTelemetryNotificationConfigsService) List(parent string) *CustomersTelemetryNotificationConfigsListCall {
	c := &CustomersTelemetryNotificationConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// notification configs to return. The service may return fewer than this
// value. If unspecified, at most 100 notification configs will be returned.
// The maximum value is 100; values above 100 will be coerced to 100.
func (c *CustomersTelemetryNotificationConfigsListCall) PageSize(pageSize int64) *CustomersTelemetryNotificationConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListTelemetryNotificationConfigs` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListTelemetryNotificationConfigs` must match the call that provided the
// page token.
func (c *CustomersTelemetryNotificationConfigsListCall) PageToken(pageToken string) *CustomersTelemetryNotificationConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryNotificationConfigsListCall) Fields(s ...googleapi.Field) *CustomersTelemetryNotificationConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryNotificationConfigsListCall) IfNoneMatch(entityTag string) *CustomersTelemetryNotificationConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryNotificationConfigsListCall) Context(ctx context.Context) *CustomersTelemetryNotificationConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryNotificationConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryNotificationConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/telemetry/notificationConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.notificationConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersTelemetryNotificationConfigsListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.notificationConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersTelemetryNotificationConfigsListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1ListTelemetryNotificationConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersTelemetryUsersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get telemetry user.
//
// - name: Name of the `TelemetryUser` to return.
func (r *CustomersTelemetryUsersService) Get(name string) *CustomersTelemetryUsersGetCall {
	c := &CustomersTelemetryUsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ReadMask sets the optional parameter "readMask": Read mask to specify which
// fields to return. Supported read_mask paths are: - name - org_unit_id -
// user_id - user_email - user_device.device_id -
// user_device.audio_status_report - user_device.device_activity_report -
// user_device.network_bandwidth_report - user_device.peripherals_report -
// user_device.app_report
func (c *CustomersTelemetryUsersGetCall) ReadMask(readMask string) *CustomersTelemetryUsersGetCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryUsersGetCall) Fields(s ...googleapi.Field) *CustomersTelemetryUsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryUsersGetCall) IfNoneMatch(entityTag string) *CustomersTelemetryUsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryUsersGetCall) Context(ctx context.Context) *CustomersTelemetryUsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryUsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryUsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.users.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.users.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1TelemetryUser.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryUsersGetCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1TelemetryUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1TelemetryUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.users.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CustomersTelemetryUsersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all telemetry users.
//
//   - parent: Customer id or "my_customer" to use the customer associated to the
//     account making the request.
func (r *CustomersTelemetryUsersService) List(parent string) *CustomersTelemetryUsersListCall {
	c := &CustomersTelemetryUsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Only include resources that
// match the filter. Supported filter fields: - user_id - user_org_unit_id
func (c *CustomersTelemetryUsersListCall) Filter(filter string) *CustomersTelemetryUsersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of results
// to return. Default value is 100. Maximum value is 1000.
func (c *CustomersTelemetryUsersListCall) PageSize(pageSize int64) *CustomersTelemetryUsersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify next
// page in the list.
func (c *CustomersTelemetryUsersListCall) PageToken(pageToken string) *CustomersTelemetryUsersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": Read mask to specify which
// fields to return. Supported read_mask paths are: - name - org_unit_id -
// user_id - user_email - user_device.device_id -
// user_device.audio_status_report - user_device.device_activity_report -
// user_device.network_bandwidth_report - user_device.peripherals_report -
// user_device.app_report
func (c *CustomersTelemetryUsersListCall) ReadMask(readMask string) *CustomersTelemetryUsersListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersTelemetryUsersListCall) Fields(s ...googleapi.Field) *CustomersTelemetryUsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CustomersTelemetryUsersListCall) IfNoneMatch(entityTag string) *CustomersTelemetryUsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersTelemetryUsersListCall) Context(ctx context.Context) *CustomersTelemetryUsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersTelemetryUsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersTelemetryUsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/telemetry/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.users.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.telemetry.users.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementV1ListTelemetryUsersResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersTelemetryUsersListCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1ListTelemetryUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementV1ListTelemetryUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.telemetry.users.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersTelemetryUsersListCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1ListTelemetryUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CustomersThirdPartyProfileUsersMoveCall struct {
	s                                                                *Service
	name                                                             string
	googlechromemanagementversionsv1movethirdpartyprofileuserrequest *GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// Move: Moves a third party chrome profile user to a destination OU. All
// profiles associated to that user will be moved to the destination OU.
//
//   - name: Format:
//     customers/{customer_id}/thirdPartyProfileUsers/{third_party_profile_user_id
//     }.
func (r *CustomersThirdPartyProfileUsersService) Move(name string, googlechromemanagementversionsv1movethirdpartyprofileuserrequest *GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserRequest) *CustomersThirdPartyProfileUsersMoveCall {
	c := &CustomersThirdPartyProfileUsersMoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlechromemanagementversionsv1movethirdpartyprofileuserrequest = googlechromemanagementversionsv1movethirdpartyprofileuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CustomersThirdPartyProfileUsersMoveCall) Fields(s ...googleapi.Field) *CustomersThirdPartyProfileUsersMoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CustomersThirdPartyProfileUsersMoveCall) Context(ctx context.Context) *CustomersThirdPartyProfileUsersMoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CustomersThirdPartyProfileUsersMoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersThirdPartyProfileUsersMoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlechromemanagementversionsv1movethirdpartyprofileuserrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:move")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "chromemanagement.customers.thirdPartyProfileUsers.move", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.thirdPartyProfileUsers.move" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse.ServerResp
// onse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CustomersThirdPartyProfileUsersMoveCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleChromeManagementVersionsV1MoveThirdPartyProfileUserResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "chromemanagement.customers.thirdPartyProfileUsers.move", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
