/*
 * util.c
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 */

#include "util.h"

#include <stdio.h>
#include <netdb.h>
#include <string.h>
#include <arpa/inet.h>

extern int do_resolve;
extern char dname[];

void
resolveipbyaddr(char *dst, int dlen, char *addr, int alen, int type)
{
    inet_ntop(type, addr, dst, dlen);
}

int
resolvebyaddr(char *dst, int dlen, char *addr, int alen, int type)
{
    struct hostent *h=NULL;

    if (do_resolve)
        h = gethostbyaddr(addr, alen, type);

    if (h && do_resolve) {
        strncpy(dst, h->h_name, dlen);

        if (strlen(dst) > strlen(dname)) {
            if (!strcasecmp(&dst[strlen(dst)-strlen(dname)], dname)) {
                dst[strlen(dst)-strlen(dname)] = '\0';
            }
        }

        if (dlen >= 24)
            dst[23] = '\0';

        return 1;
        
    } else
        inet_ntop(type, addr, dst, dlen);

    return 0;
}

char *
as_string(int i)
{
    static char buf[1024];

    memset(buf, 0, sizeof(buf));
    sprintf(buf, "%d", i);

    return buf;
}

float
sumup(unsigned long long l, char **unit)
{
    if (l >= 1099511627776) {
        *unit = "TB";
        return ((float) l) / 1099511627776;
    } else if (l >= 1073741824) {
        *unit = "GB";
        return ((float) l) / 1073741824;
    } else if (l >= 1048576) {
        *unit = "MB";
        return ((float) l) / 1048576;
    } else if (l >= 1024) {
        *unit = "KB";
        return ((float) l) / 1024;
    } else {
        *unit = "B ";
        return (float) l;
    }
}

time_t
time_sumup(time_t t, char **unit)
{
    if (t >= 86400) {
        *unit = "d";
        return t / 86400;
    } else if (t >= 3600) {
        *unit = "h";
        return t / 3600;
    } else if (t >= 60) {
        *unit = "m";
        return t / 60;
    } else {
        *unit = "s";
        return t;
    }
}
