#
# This is the case-insensitive hash [by pasky]
# it is pretty simple... if you want to reset original key's cases,
# delete the key first
#
# use it just by use IHash; tie %hash, 'IHash';
#
# (l) Petr Baudis <pasky@pasky.ji.cz> 2001, GPL'ed
#
package IHash;

sub TIEHASH {
  my $self = shift;
  my $hash = { DATA => {}, TRANSL => {}, };
  
  return bless $hash, $self;
}

sub FETCH {
  my $self = shift;
  my $key = shift;

  return $self->{DATA}->{$self->{TRANSL}->{lc($key)}};
}

sub STORE {
  my $self = shift;
  my $key = shift;
  my $val = shift;

  if (! exists $self->{TRANSL}->{lc($key)}) {
      $self->{TRANSL}->{lc($key)}=$key;
  }
  $self->{DATA}->{$self->{TRANSL}->{lc($key)}}=$val;
}

sub DELETE {
  my $self = shift;
  my $key = shift;
  my $val = $self->{DATA}->{$self->{TRANSL}->{lc($key)}};

  delete $self->{DATA}->{$self->{TRANSL}->{lc($key)}};
  delete $self->{TRANSL}->{lc($key)};
  
  return $val;
}

sub CLEAR {
  my $self = shift;

  delete $self->{DATA};
  delete $self->{TRANSL};
}

sub EXISTS {
  my $self = shift;
  my $key = shift;

  return exists $self->{DATA}->{$self->{TRANSL}->{lc($key)}};
}

sub FIRSTKEY {
  my $self = shift;
  my $a = keys %{$self->{DATA}};
  
  each %{$self->{DATA}};
}

sub NEXTKEY {
  my $self = shift;
  
  return each %{$self->{DATA}};
}

sub DESTROY {
}

return 1;
