// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package traces

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTracesOKCode is the HTTP code returned for type GetTracesOK
const GetTracesOKCode int = 200

/*
GetTracesOK Successful operation

swagger:response getTracesOK
*/
type GetTracesOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Traces `json:"body,omitempty"`
}

// NewGetTracesOK creates GetTracesOK with default headers values
func NewGetTracesOK() *GetTracesOK {

	return &GetTracesOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get traces o k response
func (o *GetTracesOK) WithConfigurationVersion(configurationVersion string) *GetTracesOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get traces o k response
func (o *GetTracesOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get traces o k response
func (o *GetTracesOK) WithPayload(payload *models.Traces) *GetTracesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get traces o k response
func (o *GetTracesOK) SetPayload(payload *models.Traces) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTracesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTracesNotFoundCode is the HTTP code returned for type GetTracesNotFound
const GetTracesNotFoundCode int = 404

/*
GetTracesNotFound The specified resource was not found

swagger:response getTracesNotFound
*/
type GetTracesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTracesNotFound creates GetTracesNotFound with default headers values
func NewGetTracesNotFound() *GetTracesNotFound {

	return &GetTracesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get traces not found response
func (o *GetTracesNotFound) WithConfigurationVersion(configurationVersion string) *GetTracesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get traces not found response
func (o *GetTracesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get traces not found response
func (o *GetTracesNotFound) WithPayload(payload *models.Error) *GetTracesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get traces not found response
func (o *GetTracesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTracesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTracesDefault General Error

swagger:response getTracesDefault
*/
type GetTracesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTracesDefault creates GetTracesDefault with default headers values
func NewGetTracesDefault(code int) *GetTracesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTracesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get traces default response
func (o *GetTracesDefault) WithStatusCode(code int) *GetTracesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get traces default response
func (o *GetTracesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get traces default response
func (o *GetTracesDefault) WithConfigurationVersion(configurationVersion string) *GetTracesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get traces default response
func (o *GetTracesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get traces default response
func (o *GetTracesDefault) WithPayload(payload *models.Error) *GetTracesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get traces default response
func (o *GetTracesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTracesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
