// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package process_manager

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteProgramAcceptedCode is the HTTP code returned for type DeleteProgramAccepted
const DeleteProgramAcceptedCode int = 202

/*
DeleteProgramAccepted Configuration change accepted and reload requested

swagger:response deleteProgramAccepted
*/
type DeleteProgramAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteProgramAccepted creates DeleteProgramAccepted with default headers values
func NewDeleteProgramAccepted() *DeleteProgramAccepted {

	return &DeleteProgramAccepted{}
}

// WithReloadID adds the reloadId to the delete program accepted response
func (o *DeleteProgramAccepted) WithReloadID(reloadID string) *DeleteProgramAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete program accepted response
func (o *DeleteProgramAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteProgramAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteProgramNoContentCode is the HTTP code returned for type DeleteProgramNoContent
const DeleteProgramNoContentCode int = 204

/*
DeleteProgramNoContent Program deleted

swagger:response deleteProgramNoContent
*/
type DeleteProgramNoContent struct {
}

// NewDeleteProgramNoContent creates DeleteProgramNoContent with default headers values
func NewDeleteProgramNoContent() *DeleteProgramNoContent {

	return &DeleteProgramNoContent{}
}

// WriteResponse to the client
func (o *DeleteProgramNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteProgramNotFoundCode is the HTTP code returned for type DeleteProgramNotFound
const DeleteProgramNotFoundCode int = 404

/*
DeleteProgramNotFound The specified resource was not found

swagger:response deleteProgramNotFound
*/
type DeleteProgramNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteProgramNotFound creates DeleteProgramNotFound with default headers values
func NewDeleteProgramNotFound() *DeleteProgramNotFound {

	return &DeleteProgramNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete program not found response
func (o *DeleteProgramNotFound) WithConfigurationVersion(configurationVersion string) *DeleteProgramNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete program not found response
func (o *DeleteProgramNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete program not found response
func (o *DeleteProgramNotFound) WithPayload(payload *models.Error) *DeleteProgramNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete program not found response
func (o *DeleteProgramNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteProgramNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteProgramDefault General Error

swagger:response deleteProgramDefault
*/
type DeleteProgramDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteProgramDefault creates DeleteProgramDefault with default headers values
func NewDeleteProgramDefault(code int) *DeleteProgramDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteProgramDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete program default response
func (o *DeleteProgramDefault) WithStatusCode(code int) *DeleteProgramDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete program default response
func (o *DeleteProgramDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete program default response
func (o *DeleteProgramDefault) WithConfigurationVersion(configurationVersion string) *DeleteProgramDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete program default response
func (o *DeleteProgramDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete program default response
func (o *DeleteProgramDefault) WithPayload(payload *models.Error) *DeleteProgramDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete program default response
func (o *DeleteProgramDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteProgramDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
