// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package dgram_bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceDgramBindOKCode is the HTTP code returned for type ReplaceDgramBindOK
const ReplaceDgramBindOKCode int = 200

/*
ReplaceDgramBindOK Bind replaced

swagger:response replaceDgramBindOK
*/
type ReplaceDgramBindOK struct {

	/*
	  In: Body
	*/
	Payload *models.DgramBind `json:"body,omitempty"`
}

// NewReplaceDgramBindOK creates ReplaceDgramBindOK with default headers values
func NewReplaceDgramBindOK() *ReplaceDgramBindOK {

	return &ReplaceDgramBindOK{}
}

// WithPayload adds the payload to the replace dgram bind o k response
func (o *ReplaceDgramBindOK) WithPayload(payload *models.DgramBind) *ReplaceDgramBindOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace dgram bind o k response
func (o *ReplaceDgramBindOK) SetPayload(payload *models.DgramBind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDgramBindOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceDgramBindAcceptedCode is the HTTP code returned for type ReplaceDgramBindAccepted
const ReplaceDgramBindAcceptedCode int = 202

/*
ReplaceDgramBindAccepted Configuration change accepted and reload requested

swagger:response replaceDgramBindAccepted
*/
type ReplaceDgramBindAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.DgramBind `json:"body,omitempty"`
}

// NewReplaceDgramBindAccepted creates ReplaceDgramBindAccepted with default headers values
func NewReplaceDgramBindAccepted() *ReplaceDgramBindAccepted {

	return &ReplaceDgramBindAccepted{}
}

// WithReloadID adds the reloadId to the replace dgram bind accepted response
func (o *ReplaceDgramBindAccepted) WithReloadID(reloadID string) *ReplaceDgramBindAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace dgram bind accepted response
func (o *ReplaceDgramBindAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace dgram bind accepted response
func (o *ReplaceDgramBindAccepted) WithPayload(payload *models.DgramBind) *ReplaceDgramBindAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace dgram bind accepted response
func (o *ReplaceDgramBindAccepted) SetPayload(payload *models.DgramBind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDgramBindAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceDgramBindBadRequestCode is the HTTP code returned for type ReplaceDgramBindBadRequest
const ReplaceDgramBindBadRequestCode int = 400

/*
ReplaceDgramBindBadRequest Bad request

swagger:response replaceDgramBindBadRequest
*/
type ReplaceDgramBindBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceDgramBindBadRequest creates ReplaceDgramBindBadRequest with default headers values
func NewReplaceDgramBindBadRequest() *ReplaceDgramBindBadRequest {

	return &ReplaceDgramBindBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace dgram bind bad request response
func (o *ReplaceDgramBindBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceDgramBindBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace dgram bind bad request response
func (o *ReplaceDgramBindBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace dgram bind bad request response
func (o *ReplaceDgramBindBadRequest) WithPayload(payload *models.Error) *ReplaceDgramBindBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace dgram bind bad request response
func (o *ReplaceDgramBindBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDgramBindBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceDgramBindNotFoundCode is the HTTP code returned for type ReplaceDgramBindNotFound
const ReplaceDgramBindNotFoundCode int = 404

/*
ReplaceDgramBindNotFound The specified resource was not found

swagger:response replaceDgramBindNotFound
*/
type ReplaceDgramBindNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceDgramBindNotFound creates ReplaceDgramBindNotFound with default headers values
func NewReplaceDgramBindNotFound() *ReplaceDgramBindNotFound {

	return &ReplaceDgramBindNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace dgram bind not found response
func (o *ReplaceDgramBindNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceDgramBindNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace dgram bind not found response
func (o *ReplaceDgramBindNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace dgram bind not found response
func (o *ReplaceDgramBindNotFound) WithPayload(payload *models.Error) *ReplaceDgramBindNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace dgram bind not found response
func (o *ReplaceDgramBindNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDgramBindNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceDgramBindDefault General Error

swagger:response replaceDgramBindDefault
*/
type ReplaceDgramBindDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceDgramBindDefault creates ReplaceDgramBindDefault with default headers values
func NewReplaceDgramBindDefault(code int) *ReplaceDgramBindDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceDgramBindDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) WithStatusCode(code int) *ReplaceDgramBindDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) WithConfigurationVersion(configurationVersion string) *ReplaceDgramBindDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) WithPayload(payload *models.Error) *ReplaceDgramBindDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace dgram bind default response
func (o *ReplaceDgramBindDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceDgramBindDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
