// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteCrtStoreAcceptedCode is the HTTP code returned for type DeleteCrtStoreAccepted
const DeleteCrtStoreAcceptedCode int = 202

/*
DeleteCrtStoreAccepted Configuration change accepted and reload requested

swagger:response deleteCrtStoreAccepted
*/
type DeleteCrtStoreAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteCrtStoreAccepted creates DeleteCrtStoreAccepted with default headers values
func NewDeleteCrtStoreAccepted() *DeleteCrtStoreAccepted {

	return &DeleteCrtStoreAccepted{}
}

// WithReloadID adds the reloadId to the delete crt store accepted response
func (o *DeleteCrtStoreAccepted) WithReloadID(reloadID string) *DeleteCrtStoreAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete crt store accepted response
func (o *DeleteCrtStoreAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteCrtStoreAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteCrtStoreNoContentCode is the HTTP code returned for type DeleteCrtStoreNoContent
const DeleteCrtStoreNoContentCode int = 204

/*
DeleteCrtStoreNoContent crt_store deleted

swagger:response deleteCrtStoreNoContent
*/
type DeleteCrtStoreNoContent struct {
}

// NewDeleteCrtStoreNoContent creates DeleteCrtStoreNoContent with default headers values
func NewDeleteCrtStoreNoContent() *DeleteCrtStoreNoContent {

	return &DeleteCrtStoreNoContent{}
}

// WriteResponse to the client
func (o *DeleteCrtStoreNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteCrtStoreNotFoundCode is the HTTP code returned for type DeleteCrtStoreNotFound
const DeleteCrtStoreNotFoundCode int = 404

/*
DeleteCrtStoreNotFound The specified resource was not found

swagger:response deleteCrtStoreNotFound
*/
type DeleteCrtStoreNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteCrtStoreNotFound creates DeleteCrtStoreNotFound with default headers values
func NewDeleteCrtStoreNotFound() *DeleteCrtStoreNotFound {

	return &DeleteCrtStoreNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete crt store not found response
func (o *DeleteCrtStoreNotFound) WithConfigurationVersion(configurationVersion string) *DeleteCrtStoreNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete crt store not found response
func (o *DeleteCrtStoreNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete crt store not found response
func (o *DeleteCrtStoreNotFound) WithPayload(payload *models.Error) *DeleteCrtStoreNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete crt store not found response
func (o *DeleteCrtStoreNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteCrtStoreNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteCrtStoreDefault General Error

swagger:response deleteCrtStoreDefault
*/
type DeleteCrtStoreDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteCrtStoreDefault creates DeleteCrtStoreDefault with default headers values
func NewDeleteCrtStoreDefault(code int) *DeleteCrtStoreDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteCrtStoreDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete crt store default response
func (o *DeleteCrtStoreDefault) WithStatusCode(code int) *DeleteCrtStoreDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete crt store default response
func (o *DeleteCrtStoreDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete crt store default response
func (o *DeleteCrtStoreDefault) WithConfigurationVersion(configurationVersion string) *DeleteCrtStoreDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete crt store default response
func (o *DeleteCrtStoreDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete crt store default response
func (o *DeleteCrtStoreDefault) WithPayload(payload *models.Error) *DeleteCrtStoreDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete crt store default response
func (o *DeleteCrtStoreDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteCrtStoreDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
