// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceACLBackendOKCode is the HTTP code returned for type ReplaceACLBackendOK
const ReplaceACLBackendOKCode int = 200

/*
ReplaceACLBackendOK ACL line replaced

swagger:response replaceAclBackendOK
*/
type ReplaceACLBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLBackendOK creates ReplaceACLBackendOK with default headers values
func NewReplaceACLBackendOK() *ReplaceACLBackendOK {

	return &ReplaceACLBackendOK{}
}

// WithPayload adds the payload to the replace Acl backend o k response
func (o *ReplaceACLBackendOK) WithPayload(payload *models.ACL) *ReplaceACLBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl backend o k response
func (o *ReplaceACLBackendOK) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLBackendAcceptedCode is the HTTP code returned for type ReplaceACLBackendAccepted
const ReplaceACLBackendAcceptedCode int = 202

/*
ReplaceACLBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAclBackendAccepted
*/
type ReplaceACLBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLBackendAccepted creates ReplaceACLBackendAccepted with default headers values
func NewReplaceACLBackendAccepted() *ReplaceACLBackendAccepted {

	return &ReplaceACLBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Acl backend accepted response
func (o *ReplaceACLBackendAccepted) WithReloadID(reloadID string) *ReplaceACLBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Acl backend accepted response
func (o *ReplaceACLBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Acl backend accepted response
func (o *ReplaceACLBackendAccepted) WithPayload(payload *models.ACL) *ReplaceACLBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl backend accepted response
func (o *ReplaceACLBackendAccepted) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLBackendBadRequestCode is the HTTP code returned for type ReplaceACLBackendBadRequest
const ReplaceACLBackendBadRequestCode int = 400

/*
ReplaceACLBackendBadRequest Bad request

swagger:response replaceAclBackendBadRequest
*/
type ReplaceACLBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLBackendBadRequest creates ReplaceACLBackendBadRequest with default headers values
func NewReplaceACLBackendBadRequest() *ReplaceACLBackendBadRequest {

	return &ReplaceACLBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl backend bad request response
func (o *ReplaceACLBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceACLBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl backend bad request response
func (o *ReplaceACLBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl backend bad request response
func (o *ReplaceACLBackendBadRequest) WithPayload(payload *models.Error) *ReplaceACLBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl backend bad request response
func (o *ReplaceACLBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLBackendNotFoundCode is the HTTP code returned for type ReplaceACLBackendNotFound
const ReplaceACLBackendNotFoundCode int = 404

/*
ReplaceACLBackendNotFound The specified resource was not found

swagger:response replaceAclBackendNotFound
*/
type ReplaceACLBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLBackendNotFound creates ReplaceACLBackendNotFound with default headers values
func NewReplaceACLBackendNotFound() *ReplaceACLBackendNotFound {

	return &ReplaceACLBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl backend not found response
func (o *ReplaceACLBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceACLBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl backend not found response
func (o *ReplaceACLBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl backend not found response
func (o *ReplaceACLBackendNotFound) WithPayload(payload *models.Error) *ReplaceACLBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl backend not found response
func (o *ReplaceACLBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceACLBackendDefault General Error

swagger:response replaceAclBackendDefault
*/
type ReplaceACLBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLBackendDefault creates ReplaceACLBackendDefault with default headers values
func NewReplaceACLBackendDefault(code int) *ReplaceACLBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceACLBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) WithStatusCode(code int) *ReplaceACLBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceACLBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) WithPayload(payload *models.Error) *ReplaceACLBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl backend default response
func (o *ReplaceACLBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
