/* pattern.c generated by valac 0.46.3, the Vala compiler
 * generated from pattern.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2015  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#define PASANG_TYPE_PATTERN (pasang_pattern_get_type ())
#define PASANG_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN, PasangPattern))
#define PASANG_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN, PasangPatternClass))
#define PASANG_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN))
#define PASANG_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN))
#define PASANG_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN, PasangPatternClass))

typedef struct _PasangPattern PasangPattern;
typedef struct _PasangPatternClass PasangPatternClass;
typedef struct _PasangPatternPrivate PasangPatternPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
typedef struct _PasangParamSpecPattern PasangParamSpecPattern;

struct _PasangPattern {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangPatternPrivate * priv;
	gchar* name;
	gchar* dots;
	guint8* pixbuf_data;
	gint pixbuf_data_length1;
	gint _pixbuf_data_size_;
	GdkPixbuf* pixbuf;
	gint dot_width;
	GtkRadioButton* button;
};

struct _PasangPatternClass {
	GTypeClass parent_class;
	void (*finalize) (PasangPattern *self);
	void (*background) (PasangPattern* self, gint n, gint x, gint y);
	void (*create_pixbuf) (PasangPattern* self);
};

struct _PasangParamSpecPattern {
	GParamSpec parent_instance;
};

static gpointer pasang_pattern_parent_class = NULL;

gpointer pasang_pattern_ref (gpointer instance);
void pasang_pattern_unref (gpointer instance);
GParamSpec* pasang_param_spec_pattern (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void pasang_value_set_pattern (GValue* value,
                               gpointer v_object);
void pasang_value_take_pattern (GValue* value,
                                gpointer v_object);
gpointer pasang_value_get_pattern (const GValue* value);
GType pasang_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPattern, pasang_pattern_unref)
PasangPattern* pasang_pattern_new (const gchar* name,
                                   const gchar* dots);
PasangPattern* pasang_pattern_construct (GType object_type,
                                         const gchar* name,
                                         const gchar* dots);
void pasang_pattern_create_pixbuf (PasangPattern* self);
PasangPattern* pasang_pattern_new_empty (const gchar* name);
PasangPattern* pasang_pattern_construct_empty (GType object_type,
                                               const gchar* name);
void pasang_pattern_set_dot_width (PasangPattern* self,
                                   gint width);
void pasang_pattern_background (PasangPattern* self,
                                gint n,
                                gint x,
                                gint y);
static void pasang_pattern_real_background (PasangPattern* self,
                                     gint n,
                                     gint x,
                                     gint y);
static void pasang_pattern_real_create_pixbuf (PasangPattern* self);
GType pasang_piece_get_type (void) G_GNUC_CONST;
#define PASANG_BOARD_SIZE (13 * 13)
void pasang_game_compile (const gchar* pattern,
                          PasangPiece** b,
                          gint* b_length1);
void pasang_pattern_create_pixbuf_from_board (PasangPattern* self,
                                              PasangPiece** board,
                                              gint* board_length1);
#define PASANG_BOARD_WIDTH 13
static void pasang_pattern_finalize (PasangPattern * obj);

PasangPattern*
pasang_pattern_construct (GType object_type,
                          const gchar* name,
                          const gchar* dots)
{
	PasangPattern* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 50 "pattern.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 50 "pattern.vala"
	g_return_val_if_fail (dots != NULL, NULL);
#line 50 "pattern.vala"
	self = (PasangPattern*) g_type_create_instance (object_type);
#line 51 "pattern.vala"
	_tmp0_ = g_strdup (name);
#line 51 "pattern.vala"
	_g_free0 (self->name);
#line 51 "pattern.vala"
	self->name = _tmp0_;
#line 52 "pattern.vala"
	_tmp1_ = g_strdup (dots);
#line 52 "pattern.vala"
	_g_free0 (self->dots);
#line 52 "pattern.vala"
	self->dots = _tmp1_;
#line 53 "pattern.vala"
	pasang_pattern_create_pixbuf (self);
#line 50 "pattern.vala"
	return self;
#line 162 "pattern.c"
}

PasangPattern*
pasang_pattern_new (const gchar* name,
                    const gchar* dots)
{
#line 50 "pattern.vala"
	return pasang_pattern_construct (PASANG_TYPE_PATTERN, name, dots);
#line 171 "pattern.c"
}

PasangPattern*
pasang_pattern_construct_empty (GType object_type,
                                const gchar* name)
{
	PasangPattern* self = NULL;
	gchar* _tmp0_;
#line 56 "pattern.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 56 "pattern.vala"
	self = (PasangPattern*) g_type_create_instance (object_type);
#line 57 "pattern.vala"
	_tmp0_ = g_strdup (name);
#line 57 "pattern.vala"
	_g_free0 (self->name);
#line 57 "pattern.vala"
	self->name = _tmp0_;
#line 56 "pattern.vala"
	return self;
#line 192 "pattern.c"
}

PasangPattern*
pasang_pattern_new_empty (const gchar* name)
{
#line 56 "pattern.vala"
	return pasang_pattern_construct_empty (PASANG_TYPE_PATTERN, name);
#line 200 "pattern.c"
}

/**
     * Change dot_width
     */
void
pasang_pattern_set_dot_width (PasangPattern* self,
                              gint width)
{
#line 63 "pattern.vala"
	g_return_if_fail (self != NULL);
#line 64 "pattern.vala"
	if (self->dot_width == width) {
#line 64 "pattern.vala"
		return;
#line 216 "pattern.c"
	}
#line 65 "pattern.vala"
	self->dot_width = width;
#line 66 "pattern.vala"
	pasang_pattern_create_pixbuf (self);
#line 222 "pattern.c"
}

/**
     * Background of the pattern (each call paint one pixel only).
     * n : position of the pixel relative to pixbuf_data.
     * x, y : position of the pixel relative to top-left corner of the dot.
     */
static void
pasang_pattern_real_background (PasangPattern* self,
                                gint n,
                                gint x,
                                gint y)
{
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
#line 75 "pattern.vala"
	_tmp0_ = self->pixbuf_data;
#line 75 "pattern.vala"
	_tmp0__length1 = self->pixbuf_data_length1;
#line 75 "pattern.vala"
	_tmp1_ = self->pixbuf_data;
#line 75 "pattern.vala"
	_tmp1__length1 = self->pixbuf_data_length1;
#line 75 "pattern.vala"
	_tmp2_ = self->pixbuf_data;
#line 75 "pattern.vala"
	_tmp2__length1 = self->pixbuf_data_length1;
#line 75 "pattern.vala"
	_tmp2_[n + 2] = (guint8) (100 - (100 / (3 - ((x + y) % 3))));
#line 75 "pattern.vala"
	_tmp1_[n + 1] = (guint8) (100 - (100 / (3 - ((x + y) % 3))));
#line 75 "pattern.vala"
	_tmp0_[n + 0] = (guint8) (100 - (100 / (3 - ((x + y) % 3))));
#line 78 "pattern.vala"
	_tmp3_ = self->pixbuf_data;
#line 78 "pattern.vala"
	_tmp3__length1 = self->pixbuf_data_length1;
#line 78 "pattern.vala"
	_tmp3_[n + 3] = (guint8) 255;
#line 268 "pattern.c"
}

void
pasang_pattern_background (PasangPattern* self,
                           gint n,
                           gint x,
                           gint y)
{
#line 74 "pattern.vala"
	g_return_if_fail (self != NULL);
#line 74 "pattern.vala"
	PASANG_PATTERN_GET_CLASS (self)->background (self, n, x, y);
#line 281 "pattern.c"
}

/**
     * Render a pattern as a pixbuf. dots must be legal, i.e. compilable into
     * a board with 60 whites and 60 blacks.
     */
static void
pasang_pattern_real_create_pixbuf (PasangPattern* self)
{
	PasangPiece* board = NULL;
	PasangPiece* _tmp0_;
	gint board_length1;
	gint _board_size_;
	const gchar* _tmp1_;
#line 86 "pattern.vala"
	_tmp0_ = g_new0 (PasangPiece, PASANG_BOARD_SIZE);
#line 86 "pattern.vala"
	board = _tmp0_;
#line 86 "pattern.vala"
	board_length1 = PASANG_BOARD_SIZE;
#line 86 "pattern.vala"
	_board_size_ = board_length1;
#line 87 "pattern.vala"
	_tmp1_ = self->dots;
#line 87 "pattern.vala"
	pasang_game_compile (_tmp1_, &board, (gint*) (&board_length1));
#line 88 "pattern.vala"
	pasang_pattern_create_pixbuf_from_board (self, &board, (gint*) (&board_length1));
#line 85 "pattern.vala"
	board = (g_free (board), NULL);
#line 312 "pattern.c"
}

void
pasang_pattern_create_pixbuf (PasangPattern* self)
{
#line 85 "pattern.vala"
	g_return_if_fail (self != NULL);
#line 85 "pattern.vala"
	PASANG_PATTERN_GET_CLASS (self)->create_pixbuf (self);
#line 322 "pattern.c"
}

/**
     * Render a pattern as a pixbuf. board doesn't have to be legal.
     * e.g. there may be less than 60 whites.
     * This is to cater for unfinished custom patterns.
     */
void
pasang_pattern_create_pixbuf_from_board (PasangPattern* self,
                                         PasangPiece** board,
                                         gint* board_length1)
{
	gint dot_cut = 0;
	gint image_width = 0;
	gint sizeof_pixel = 0;
	gint sizeof_dot = 0;
	gint sizeof_image = 0;
	guint8* _tmp0_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	GdkPixbuf* _tmp14_;
	GtkRadioButton* _tmp15_;
	GdkPixbuf* _tmp16_;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
#line 96 "pattern.vala"
	g_return_if_fail (self != NULL);
#line 98 "pattern.vala"
	dot_cut = self->dot_width;
#line 99 "pattern.vala"
	image_width = PASANG_BOARD_WIDTH * self->dot_width;
#line 101 "pattern.vala"
	sizeof_pixel = 4;
#line 102 "pattern.vala"
	sizeof_dot = (self->dot_width * self->dot_width) * sizeof_pixel;
#line 103 "pattern.vala"
	sizeof_image = (image_width * image_width) * sizeof_dot;
#line 104 "pattern.vala"
	_tmp0_ = g_new0 (guint8, sizeof_image);
#line 104 "pattern.vala"
	self->pixbuf_data = (g_free (self->pixbuf_data), NULL);
#line 104 "pattern.vala"
	self->pixbuf_data = _tmp0_;
#line 104 "pattern.vala"
	self->pixbuf_data_length1 = sizeof_image;
#line 104 "pattern.vala"
	self->_pixbuf_data_size_ = self->pixbuf_data_length1;
#line 370 "pattern.c"
	{
		gint i = 0;
#line 106 "pattern.vala"
		i = 0;
#line 375 "pattern.c"
		{
			gboolean _tmp1_ = FALSE;
#line 106 "pattern.vala"
			_tmp1_ = TRUE;
#line 106 "pattern.vala"
			while (TRUE) {
#line 382 "pattern.c"
				gint dot_ndx = 0;
#line 106 "pattern.vala"
				if (!_tmp1_) {
#line 386 "pattern.c"
					gint _tmp2_;
#line 106 "pattern.vala"
					_tmp2_ = i;
#line 106 "pattern.vala"
					i = _tmp2_ + 1;
#line 392 "pattern.c"
				}
#line 106 "pattern.vala"
				_tmp1_ = FALSE;
#line 106 "pattern.vala"
				if (!(i < PASANG_BOARD_SIZE)) {
#line 106 "pattern.vala"
					break;
#line 400 "pattern.c"
				}
#line 107 "pattern.vala"
				dot_ndx = (((i / PASANG_BOARD_WIDTH) * PASANG_BOARD_WIDTH) * sizeof_dot) + (((i % PASANG_BOARD_WIDTH) * self->dot_width) * sizeof_pixel);
#line 404 "pattern.c"
				{
					gint px = 0;
#line 110 "pattern.vala"
					px = 0;
#line 409 "pattern.c"
					{
						gboolean _tmp3_ = FALSE;
#line 110 "pattern.vala"
						_tmp3_ = TRUE;
#line 110 "pattern.vala"
						while (TRUE) {
#line 110 "pattern.vala"
							if (!_tmp3_) {
#line 418 "pattern.c"
								gint _tmp4_;
#line 110 "pattern.vala"
								_tmp4_ = px;
#line 110 "pattern.vala"
								px = _tmp4_ + 1;
#line 424 "pattern.c"
							}
#line 110 "pattern.vala"
							_tmp3_ = FALSE;
#line 110 "pattern.vala"
							if (!(px < self->dot_width)) {
#line 110 "pattern.vala"
								break;
#line 432 "pattern.c"
							}
							{
								gint py = 0;
#line 111 "pattern.vala"
								py = 0;
#line 438 "pattern.c"
								{
									gboolean _tmp5_ = FALSE;
#line 111 "pattern.vala"
									_tmp5_ = TRUE;
#line 111 "pattern.vala"
									while (TRUE) {
#line 445 "pattern.c"
										gint n = 0;
										gboolean _tmp7_ = FALSE;
										PasangPiece _tmp8_;
#line 111 "pattern.vala"
										if (!_tmp5_) {
#line 451 "pattern.c"
											gint _tmp6_;
#line 111 "pattern.vala"
											_tmp6_ = py;
#line 111 "pattern.vala"
											py = _tmp6_ + 1;
#line 457 "pattern.c"
										}
#line 111 "pattern.vala"
										_tmp5_ = FALSE;
#line 111 "pattern.vala"
										if (!(py < self->dot_width)) {
#line 111 "pattern.vala"
											break;
#line 465 "pattern.c"
										}
#line 112 "pattern.vala"
										n = (dot_ndx + ((py * image_width) * sizeof_pixel)) + (px * sizeof_pixel);
#line 113 "pattern.vala"
										_tmp8_ = (*board)[i];
#line 113 "pattern.vala"
										if (_tmp8_ == PASANG_PIECE_WHITE) {
#line 113 "pattern.vala"
											_tmp7_ = (px % dot_cut) != (dot_cut - 1);
#line 475 "pattern.c"
										} else {
#line 113 "pattern.vala"
											_tmp7_ = FALSE;
#line 479 "pattern.c"
										}
#line 113 "pattern.vala"
										if (_tmp7_) {
#line 483 "pattern.c"
											guint8* _tmp9_;
											gint _tmp9__length1;
											guint8* _tmp10_;
											gint _tmp10__length1;
											guint8* _tmp11_;
											gint _tmp11__length1;
											guint8* _tmp12_;
											gint _tmp12__length1;
#line 115 "pattern.vala"
											_tmp9_ = self->pixbuf_data;
#line 115 "pattern.vala"
											_tmp9__length1 = self->pixbuf_data_length1;
#line 115 "pattern.vala"
											_tmp10_ = self->pixbuf_data;
#line 115 "pattern.vala"
											_tmp10__length1 = self->pixbuf_data_length1;
#line 115 "pattern.vala"
											_tmp10_[n + 1] = (guint8) (155 + (100 / ((py % dot_cut) + 1)));
#line 115 "pattern.vala"
											_tmp9_[n + 0] = (guint8) (155 + (100 / ((py % dot_cut) + 1)));
#line 117 "pattern.vala"
											_tmp11_ = self->pixbuf_data;
#line 117 "pattern.vala"
											_tmp11__length1 = self->pixbuf_data_length1;
#line 117 "pattern.vala"
											_tmp11_[n + 2] = (guint8) (55 + (100 / ((py % dot_cut) + 1)));
#line 118 "pattern.vala"
											_tmp12_ = self->pixbuf_data;
#line 118 "pattern.vala"
											_tmp12__length1 = self->pixbuf_data_length1;
#line 118 "pattern.vala"
											_tmp12_[n + 3] = (guint8) 255;
#line 516 "pattern.c"
										} else {
#line 121 "pattern.vala"
											pasang_pattern_background (self, n, px, py);
#line 520 "pattern.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 127 "pattern.vala"
	_tmp13_ = self->pixbuf_data;
#line 127 "pattern.vala"
	_tmp13__length1 = self->pixbuf_data_length1;
#line 127 "pattern.vala"
	_tmp14_ = gdk_pixbuf_new_from_data (_tmp13_, GDK_COLORSPACE_RGB, TRUE, 8, image_width, image_width, image_width * sizeof_pixel, (GdkPixbufDestroyNotify) NULL, NULL);
#line 127 "pattern.vala"
	_g_object_unref0 (self->pixbuf);
#line 127 "pattern.vala"
	self->pixbuf = _tmp14_;
#line 136 "pattern.vala"
	_tmp15_ = self->button;
#line 136 "pattern.vala"
	_tmp16_ = self->pixbuf;
#line 136 "pattern.vala"
	_tmp17_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp16_);
#line 136 "pattern.vala"
	g_object_ref_sink (_tmp17_);
#line 136 "pattern.vala"
	_tmp18_ = _tmp17_;
#line 136 "pattern.vala"
	gtk_button_set_image ((GtkButton*) _tmp15_, (GtkWidget*) _tmp18_);
#line 136 "pattern.vala"
	_g_object_unref0 (_tmp18_);
#line 555 "pattern.c"
}

static void
pasang_value_pattern_init (GValue* value)
{
#line 21 "pattern.vala"
	value->data[0].v_pointer = NULL;
#line 563 "pattern.c"
}

static void
pasang_value_pattern_free_value (GValue* value)
{
#line 21 "pattern.vala"
	if (value->data[0].v_pointer) {
#line 21 "pattern.vala"
		pasang_pattern_unref (value->data[0].v_pointer);
#line 573 "pattern.c"
	}
}

static void
pasang_value_pattern_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 21 "pattern.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "pattern.vala"
		dest_value->data[0].v_pointer = pasang_pattern_ref (src_value->data[0].v_pointer);
#line 585 "pattern.c"
	} else {
#line 21 "pattern.vala"
		dest_value->data[0].v_pointer = NULL;
#line 589 "pattern.c"
	}
}

static gpointer
pasang_value_pattern_peek_pointer (const GValue* value)
{
#line 21 "pattern.vala"
	return value->data[0].v_pointer;
#line 598 "pattern.c"
}

static gchar*
pasang_value_pattern_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 21 "pattern.vala"
	if (collect_values[0].v_pointer) {
#line 609 "pattern.c"
		PasangPattern * object;
		object = collect_values[0].v_pointer;
#line 21 "pattern.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "pattern.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 616 "pattern.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "pattern.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 620 "pattern.c"
		}
#line 21 "pattern.vala"
		value->data[0].v_pointer = pasang_pattern_ref (object);
#line 624 "pattern.c"
	} else {
#line 21 "pattern.vala"
		value->data[0].v_pointer = NULL;
#line 628 "pattern.c"
	}
#line 21 "pattern.vala"
	return NULL;
#line 632 "pattern.c"
}

static gchar*
pasang_value_pattern_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	PasangPattern ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "pattern.vala"
	if (!object_p) {
#line 21 "pattern.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 647 "pattern.c"
	}
#line 21 "pattern.vala"
	if (!value->data[0].v_pointer) {
#line 21 "pattern.vala"
		*object_p = NULL;
#line 653 "pattern.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "pattern.vala"
		*object_p = value->data[0].v_pointer;
#line 657 "pattern.c"
	} else {
#line 21 "pattern.vala"
		*object_p = pasang_pattern_ref (value->data[0].v_pointer);
#line 661 "pattern.c"
	}
#line 21 "pattern.vala"
	return NULL;
#line 665 "pattern.c"
}

GParamSpec*
pasang_param_spec_pattern (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	PasangParamSpecPattern* spec;
#line 21 "pattern.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PASANG_TYPE_PATTERN), NULL);
#line 21 "pattern.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "pattern.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "pattern.vala"
	return G_PARAM_SPEC (spec);
#line 684 "pattern.c"
}

gpointer
pasang_value_get_pattern (const GValue* value)
{
#line 21 "pattern.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_PATTERN), NULL);
#line 21 "pattern.vala"
	return value->data[0].v_pointer;
#line 694 "pattern.c"
}

void
pasang_value_set_pattern (GValue* value,
                          gpointer v_object)
{
	PasangPattern * old;
#line 21 "pattern.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_PATTERN));
#line 21 "pattern.vala"
	old = value->data[0].v_pointer;
#line 21 "pattern.vala"
	if (v_object) {
#line 21 "pattern.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_PATTERN));
#line 21 "pattern.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "pattern.vala"
		value->data[0].v_pointer = v_object;
#line 21 "pattern.vala"
		pasang_pattern_ref (value->data[0].v_pointer);
#line 716 "pattern.c"
	} else {
#line 21 "pattern.vala"
		value->data[0].v_pointer = NULL;
#line 720 "pattern.c"
	}
#line 21 "pattern.vala"
	if (old) {
#line 21 "pattern.vala"
		pasang_pattern_unref (old);
#line 726 "pattern.c"
	}
}

void
pasang_value_take_pattern (GValue* value,
                           gpointer v_object)
{
	PasangPattern * old;
#line 21 "pattern.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_TYPE_PATTERN));
#line 21 "pattern.vala"
	old = value->data[0].v_pointer;
#line 21 "pattern.vala"
	if (v_object) {
#line 21 "pattern.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_TYPE_PATTERN));
#line 21 "pattern.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "pattern.vala"
		value->data[0].v_pointer = v_object;
#line 747 "pattern.c"
	} else {
#line 21 "pattern.vala"
		value->data[0].v_pointer = NULL;
#line 751 "pattern.c"
	}
#line 21 "pattern.vala"
	if (old) {
#line 21 "pattern.vala"
		pasang_pattern_unref (old);
#line 757 "pattern.c"
	}
}

static void
pasang_pattern_class_init (PasangPatternClass * klass,
                           gpointer klass_data)
{
#line 21 "pattern.vala"
	pasang_pattern_parent_class = g_type_class_peek_parent (klass);
#line 21 "pattern.vala"
	((PasangPatternClass *) klass)->finalize = pasang_pattern_finalize;
#line 21 "pattern.vala"
	((PasangPatternClass *) klass)->background = (void (*) (PasangPattern*, gint, gint, gint)) pasang_pattern_real_background;
#line 21 "pattern.vala"
	((PasangPatternClass *) klass)->create_pixbuf = (void (*) (PasangPattern*)) pasang_pattern_real_create_pixbuf;
#line 773 "pattern.c"
}

static void
pasang_pattern_instance_init (PasangPattern * self,
                              gpointer klass)
{
	GtkRadioButton* _tmp0_;
#line 36 "pattern.vala"
	self->pixbuf_data = NULL;
#line 36 "pattern.vala"
	self->pixbuf_data_length1 = 0;
#line 36 "pattern.vala"
	self->_pixbuf_data_size_ = self->pixbuf_data_length1;
#line 37 "pattern.vala"
	self->pixbuf = NULL;
#line 42 "pattern.vala"
	self->dot_width = 4;
#line 48 "pattern.vala"
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
#line 48 "pattern.vala"
	g_object_ref_sink (_tmp0_);
#line 48 "pattern.vala"
	self->button = _tmp0_;
#line 21 "pattern.vala"
	self->ref_count = 1;
#line 799 "pattern.c"
}

static void
pasang_pattern_finalize (PasangPattern * obj)
{
	PasangPattern * self;
#line 21 "pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_PATTERN, PasangPattern);
#line 21 "pattern.vala"
	g_signal_handlers_destroy (self);
#line 25 "pattern.vala"
	_g_free0 (self->name);
#line 31 "pattern.vala"
	_g_free0 (self->dots);
#line 36 "pattern.vala"
	self->pixbuf_data = (g_free (self->pixbuf_data), NULL);
#line 37 "pattern.vala"
	_g_object_unref0 (self->pixbuf);
#line 48 "pattern.vala"
	_g_object_unref0 (self->button);
#line 820 "pattern.c"
}

GType
pasang_pattern_get_type (void)
{
	static volatile gsize pasang_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_pattern_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { pasang_value_pattern_init, pasang_value_pattern_free_value, pasang_value_pattern_copy_value, pasang_value_pattern_peek_pointer, "p", pasang_value_pattern_collect_value, "p", pasang_value_pattern_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasangPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangPattern), 0, (GInstanceInitFunc) pasang_pattern_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pasang_pattern_type_id;
		pasang_pattern_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PasangPattern", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pasang_pattern_type_id__volatile, pasang_pattern_type_id);
	}
	return pasang_pattern_type_id__volatile;
}

gpointer
pasang_pattern_ref (gpointer instance)
{
	PasangPattern * self;
	self = instance;
#line 21 "pattern.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "pattern.vala"
	return instance;
#line 847 "pattern.c"
}

void
pasang_pattern_unref (gpointer instance)
{
	PasangPattern * self;
	self = instance;
#line 21 "pattern.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "pattern.vala"
		PASANG_PATTERN_GET_CLASS (self)->finalize (self);
#line 21 "pattern.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 861 "pattern.c"
	}
}

