/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2018  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Pasang {
    static bool theme_dir_req = false;
    static bool server_req = false;
    static uint16 port = 3812;
    static bool version_req = false;

    const OptionEntry[] options = {
        {"server", 0, 0, OptionArg.NONE, ref server_req, "Run game server", null},
        {"port", 'p', 0, OptionArg.INT, ref port, "Port number for game server (default: 3812)", "N"},
        {"themes-path", 0, 0, OptionArg.NONE, ref theme_dir_req, "Show theme location", null},
        {"version", 0, 0, OptionArg.NONE, ref version_req, "Show version number", null},
        {null}
    };

    public static void main (string[] args) {
        Reloc.init (args[0]);
        try {
            var opt = new OptionContext ("");
            opt.set_help_enabled (true);
            opt.add_main_entries (options, null);
            opt.parse (ref args);
        }
        catch (Error e) {
            stderr.printf ("Error: %s\n", e.message);
            stderr.printf ("Run '%s --help' to see available options\n", args[0]);
            return;
        }
        if (theme_dir_req) {
            stdout.printf ("%s", Reloc.theme_root_dir);
        }
        else if (version_req) {
            stdout.printf ("%s\n", Config.PACKAGE_STRING);
            stdout.printf ("Copyright (C) 2018  Nor Jaidi Tuah\n" +
                           "This is free software; see the source for copying conditions.\n" +
                           "There is NO warranty; not even for MERCHANTABILITY or\n" +
                           "FITNESS FOR A PARTICULAR PURPOSE.\n");
        }
        else if (server_req) {
            Server.main (port);
        }
        else {
            // Localisation stuff
            Intl.bindtextdomain (Config.GETTEXT_PACKAGE, Reloc.locale_dir);
            Intl.bind_textdomain_codeset (Config.GETTEXT_PACKAGE, "UTF-8");
            Intl.textdomain (Config.GETTEXT_PACKAGE);

            var instance = new PasangApplication ();
            instance.run (args);
        }
    }
}//namespace

// vim: tabstop=4: expandtab: textwidth=100: autoindent:
