/*
 *   mwmv80p.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*****************************************************************************/
/* These routines do validation and initate actions for V.80 commands.  They */
/* are common routines that will be called from modem init, V.80 command     */
/* parsing routines, and other parse routines (such as #CLS).  These         */
/* routines do not parse the commands.  They accept a buffer with the        */
/* command parms already parsed.  The actual parsing is done by routines in  */
/* mwmclss2.c.                                                               */
/*****************************************************************************/

#include <mwmparse.h>
#include <mwmparsi.h>
#include <psv8itcb.h>

#include <stddef.h>

static char szThisFile[] = "MWMV80P.C";



USHORT mwmv80PA8ECommand(STATEINFO *psi,USHORT * usPlusA8E)
{
   REGISTERS Registers;
   USHORT usParserStatus = 0;
   USHORT usParmsChanged = 0;
   MWM_FCLASS_SUBCLASS ClassStruct;
   USHORT usModulat2 = 0;
   ULONG ulRC;
   USHORT usHandsetStatus = 0;
   USHORT usHookStatus = 0;

   DPF("mwmv80PA8ECommand\n");
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmv80p::mwmv80PA8ECommand entry\n");
   if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      DPF("mwmParseQueryModemRegisters ERROR\n");
      return 1;
   } /* endif */

   DPF("*usPlusA8E=%d +1=%d +2=%x Registers.PlusA8E[0]=%d [1]=%d [2]=%x",
    *usPlusA8E,*(usPlusA8E+1),*(usPlusA8E+2),Registers.PlusA8E[0],Registers.PlusA8E[1],Registers.PlusA8E[2]);

   if (* usPlusA8E != Registers.PlusA8E[0])
   {
     if ( (psi->usNextPPIndex + PP_A8E_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (* usPlusA8E)
       {
         case DEFAULT_PLUSA8E_0_VALUE:  //$1 enable v.8 origination negotiation
         case 6:
            usParmsChanged = 1;
            Registers.PlusA8E[0] = *(usPlusA8E);
            break;
         case ' ':       // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       } /* end switch */
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (*(usPlusA8E+2) != Registers.PlusA8E[2])
   {
     if ( (psi->usNextPPIndex + PP_A8E_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (*(usPlusA8E+2))
       {
         case DEFAULT_PLUSA8E_2_VALUE:  //$1 data mode
         case 0x021:  //$5
         case 0x061:

           usParmsChanged = 1;
           Registers.PlusA8E[2] = *(usPlusA8E+2);

           if ( *(usPlusA8E+2) == 0xC1) {
             usModulat2 = 0x222;
           } else {
             usModulat2 = 0x220;
           } /* endif */

           ulRC = dspMemTransfer( psi->dsp.hDSP, (psi->dsp.dspaddrPSV8ITCB)+offsetof(PSV8ITCB, MODULAT1)+2,
                                  &usModulat2, 1,
                                  DSP_MEMXFER_DATA_WRITE);
           if (ulRC!=DSP_NOERROR)
           {
             mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                               MWM_DSP_ERROR, ulRC );
             return MWM_ATCMD_ERROR;
           }

           break;

         case ' ':        // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (*(usPlusA8E+1) != Registers.PlusA8E[1])
   {
     if ( (psi->usNextPPIndex + PP_A8E_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (*(usPlusA8E+1))
       {
         case DEFAULT_PLUSA8E_1_VALUE:  //$1 enable v.8 answer negotiation
            usParmsChanged = 1;
            Registers.PlusA8E[1] = *(usPlusA8E +1);
            break;
         case 5:
            if (usParserStatus != MWM_ATCMD_ERROR) // if no other parsing errors
            {
              usParmsChanged = 1;
              Registers.PlusA8E[1] = *(usPlusA8E +1);
            } /* endif */
            break;
         case ' ':           // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   DPF("mwmParse: usParserStatus = %d\n",usParserStatus);

   if (usParserStatus != MWM_ATCMD_ERROR)
   {
     if (usParmsChanged)
     {
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x24;
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2000;

       mwmParseSetModemRegisters(&Registers);
     } /* endif */
   } /* endif */

   /****************************************************
   ** Check to see if this instance of the command
   ** should be considered an action command (issued
   ** while online in V.80 mode).
   *****************************************************/
   if (!usParserStatus) {
     if (psi->usAllowA8EActionCommand) {
       ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrFCLASS,
                             &ClassStruct, 7,
                             DSP_MEMXFER_DATA_READ);

       if (ulRC!=DSP_NOERROR) {
         mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                           MWM_DSP_ERROR, ulRC );
         return MWM_ATCMD_ERROR;
       } /* endif */

       if (ClassStruct.usFCLASS == 0 && ClassStruct.usSubclass == 1) {
         if (mwmParseQueryHookStatus(&usHandsetStatus,&usHookStatus)) {
           return MWM_ATCMD_ERROR;
         } else {
           if (usHookStatus) { /* We are off-hook */
             DPF("+A8E used as an ACTION command...Initiating a dial...");
             usParserStatus = mwmCmdDCommand(psi);
           } /* endif */
         } /* endif */
       } /* endif */

     } /* endif */
   } /* endif */
  MW_SYSLOG_2(TRACE_MWMPW32,"mwmv80p::mwmv80PA8ECommand exit usParserStatus %x\n",usParserStatus);
   return usParserStatus;
}

USHORT mwmv80PESCommand(STATEINFO *psi, USHORT * usPlusES, BOOL bSwitchClass)
{
   REGISTERS Registers;
   USHORT usParserStatus = 0;
   USHORT usParmsChanged = 0;
   MWM_FCLASS_SUBCLASS ClassStruct;
   USHORT usInterrupt = 0;
   ULONG  ulRC = 0;
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmv80p::mwmv80PESCommand entry\n");
   DPF("mwmv80PESCommand\n");

   if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      DPF("mwmParseQueryModemRegisters ERROR\n");
      usParserStatus = MWM_ATCMD_ERROR;
      return usParserStatus;
   } /* endif */

   DPF("*usPlusES=%d +1=%d +2=%d Registers.PlusES[0]=%d [1]=%d [2]=%d",
    *usPlusES,*(usPlusES+1),*(usPlusES+2),Registers.PlusES[0],Registers.PlusES[1],Registers.PlusES[2]);

   if (* usPlusES != Registers.PlusES[0])
   {
     if ( (psi->usNextPPIndex + PP_ES_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (* usPlusES)
       {
         case DEFAULT_PLUSES_0_VALUE:                           //$1
            usParmsChanged = 1;
            Registers.PlusES[0] = *(usPlusES);
            if (Registers.PlusES[2] != 8 &&  //$3 if parm 3 will not put/keep us in v.80 mode
                *(usPlusES+2) != 8)
            {
              Registers.PlusIBC[0] = 0;                         //$4 keep IBC value in sync
              usInterrupt = 42;
              psi->usV80StateSaved = FALSE;
            }
            break;
         case 6:
            if ((psi->ulFeaturesToLoad & FEATURE_V34) ||        //$2
                (psi->ulFeaturesToLoad & FEATURE_V34EM))
            {
              usParmsChanged = 1;
              Registers.PlusES[0] = *(usPlusES);
              Registers.PlusIBC[0] = 2;                         //$4 keep IBC value in sync
              usInterrupt = 41;                                 //$1
            }
            else
            {
              DPF("  ERROR: V.80 requires V.34 (speed >= 28800)\n");
              usParserStatus = MWM_ATCMD_ERROR;
            }
            break;
         case ' ':  // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       DPF("  get more buffers\n");
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (*(usPlusES+1) != Registers.PlusES[1])
   {
     if ( (psi->usNextPPIndex + PP_ES_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (*(usPlusES+1))
       {
         case DEFAULT_PLUSES_1_VALUE:  //$1
            break;
         case ' ':  // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (*(usPlusES+2) != Registers.PlusES[2])
   {
     if ( (psi->usNextPPIndex + PP_ES_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (*(usPlusES+2))
       {
         case DEFAULT_PLUSES_2_VALUE:  //$1
            usParmsChanged = 1;
            Registers.PlusES[2] = *(usPlusES + 2);
            if (Registers.PlusES[0] != 6)  //$3 if parm 1 will not put/keep us in V.80 mode
            {
              Registers.PlusIBC[0] = 0;                         //$4 keep IBC value in sync
              usInterrupt = 42;
              psi->usV80StateSaved = FALSE;
            }
            break;
         case 8:
            if ((psi->ulFeaturesToLoad & FEATURE_V34) ||        //$2
                (psi->ulFeaturesToLoad & FEATURE_V34EM))
            {
              usParmsChanged = 1;
              Registers.PlusES[2] = *(usPlusES + 2);
              Registers.PlusIBC[0] = 2;                         //$4 keep IBC value in sync
              usInterrupt = 41;          //$1
            }
            else
            {
              DPF("  ERROR: V.80 requires V.34 (speed >= 28800)\n");
              usParserStatus = MWM_ATCMD_ERROR;
            }
            break;
         case ' ':  // no value specified
            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (usParserStatus != MWM_ATCMD_ERROR)
   {
     if (usParmsChanged)
     {
       ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrFCLASS,
                             &ClassStruct.usFCLASS, 1,
                             DSP_MEMXFER_DATA_READ);
       if (ulRC!=DSP_NOERROR)
       {
         mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                           MWM_DSP_ERROR, ulRC );
         return MWM_ATCMD_ERROR;
       }

       if (ClassStruct.usFCLASS != 0) // if not in class 0 warn mctl we're switching to class 0
       {
         if (bSwitchClass) {
           psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x09;
           psi->ausPPcmdBuffer[psi->usNextPPIndex++] = ClassStruct.usFCLASS;
           psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0;
         } /* endif */
       }
       // tell mctl to send us back an interrupt to switch into or out of v.80 mode
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x24;
       psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usInterrupt;           //$1

       // Force the *TH value for V.80 mode.
       if (psi->usV80THValue) {
         psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
         psi->ausPPcmdBuffer[psi->usNextPPIndex++] = psi->usV80THValue;
       } /* endif */

       mwmParseSetModemRegisters(&Registers);

     } /* endif */


   } /* endif */
  MW_SYSLOG_2(TRACE_MWMPW32,"mwmv80p::mwmv80PESCommand exit usParserStatus %x\n",usParserStatus);
   return usParserStatus;
}

USHORT mwmv80PESACommand(STATEINFO *psi,USHORT *usPlusESA)
{
   REGISTERS Registers;
   USHORT usParserStatus = 0;
   USHORT usParmsChanged = 0;
   DPF("mwmv80PESACommand\n");
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmv80p::mwmv80PESACommand entry\n");
   if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      DPF("mwmParseQueryModemRegisters ERROR\n");
      return 1;
   } /* endif */

   DPF("*usPlusESA=%d +1=%d +2=%d Registers.PlusESA[0]=%d [1]=%d [2]=%d",
    *usPlusESA,*(usPlusESA+1),*(usPlusESA+2),Registers.PlusESA[0],Registers.PlusESA[1],Registers.PlusESA[2]);

   if (* usPlusESA != Registers.PlusESA[0])
   {
       switch (* usPlusESA)
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
         case 2:
            usParmsChanged = 1;
            Registers.PlusESA[0] = *(usPlusESA);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusESA+1) != Registers.PlusESA[1])
   {
       switch (*(usPlusESA+1))
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
            usParmsChanged = 1;
            Registers.PlusESA[1] = *(usPlusESA + 1);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusESA+2) != Registers.PlusESA[2])
   {
       switch (*(usPlusESA+2))
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
            usParmsChanged = 1;
            Registers.PlusESA[2] = *(usPlusESA + 2);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusESA+3) != Registers.PlusESA[3])
   {
       switch (*(usPlusESA+3))
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
            usParmsChanged = 1;
            Registers.PlusESA[3] = *(usPlusESA + 3);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusESA+4) != Registers.PlusESA[4])
   {
       switch (*(usPlusESA+4))
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
         case 2:
            usParmsChanged = 1;
            Registers.PlusESA[4] = *(usPlusESA + 4);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusESA+5) != Registers.PlusESA[5])
   {
       switch (*(usPlusESA+5))
       {
         case ' ':  // no value specified
            break;
         case 0:
         case 1:
            usParmsChanged = 1;
            Registers.PlusESA[5] = *(usPlusESA + 5);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (usParserStatus != MWM_ATCMD_ERROR)
   {
     if (usParmsChanged)
     {
       mwmParseSetModemRegisters(&Registers);
     } /* endif */
   } /* endif */
  MW_SYSLOG_2(TRACE_MWMPW32,"mwmv80p::mwmv80PESACommand exit usParserStatus %x\n",usParserStatus);
   return usParserStatus;
}

USHORT mwmv80PIBCCommand(STATEINFO *psi,USHORT *usPlusIBC)
{
   REGISTERS Registers;
   USHORT usParserStatus = 0;
   USHORT usParmsChanged = 0;
   DPF("mwmv80PIBCCommand\n");
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmv80p::mwmv80PIBCCommand entry\n");
   if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      DPF("mwmParseQueryModemRegisters ERROR\n");
      return 1;
   } /* endif */

   DPF("*usPlusIBC=%d Registers.PlusIBC[0]=%d",
    *usPlusIBC,Registers.PlusIBC[0]);

   if (* usPlusIBC != Registers.PlusIBC[0])
   {
     if ( (psi->usNextPPIndex + PP_IBC_CMD_SPACE) < PP_BUFFER_THRESHOLD)
     {
       switch (* usPlusIBC)
       {
         case 0: // switch out of v.80 mode vs. no value specified???
            usParmsChanged = 1;
            Registers.PlusIBC[0] = *(usPlusIBC);
            //$4 tell mctl to send interrupt to switch out of v.80 mode
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x24;
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 42;
            break;
         case 2: // switch into of v.80 mode
            usParmsChanged = 1;
            Registers.PlusIBC[0] = *(usPlusIBC);
            //$4 tell mctl to send interrupt to switch into v.80 mode
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x24;
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 41;

            if (psi->usV80THValue) {
              psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x2f | psi->usParserMode;
              psi->ausPPcmdBuffer[psi->usNextPPIndex++] = psi->usV80THValue;
            } /* endif */

            break;
         default:
           usParserStatus = MWM_ATCMD_ERROR;
           break;
       }
     }
     else
     {
       /*********************************************************************/
       /* There is not enough room left in this PP Command buffer to process*/
       /* this command....                                                  */
       /*********************************************************************/
       usParserStatus = MWM_GET_MORE_BUFFERS;
       psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
     } /* endif */
   } /* endif */

   if (usParserStatus != MWM_ATCMD_ERROR)
   {
     if (usParmsChanged)
     {
       mwmParseSetModemRegisters(&Registers);
     } /* endif */
   } /* endif */
  MW_SYSLOG_2(TRACE_MWMPW32,"mwmv80p::mwmv80PIBCCommand exit usParserStatus %x\n",usParserStatus);
   return usParserStatus;
}

USHORT mwmv80PITFCommand(STATEINFO *psi,USHORT *usPlusITF)
{
   REGISTERS Registers;
   USHORT usParserStatus = 0;
   USHORT usParmsChanged = 0;
   DPF("mwmv80PITFCommand\n");
  MW_SYSLOG_1(TRACE_MWMPW32,"mwmv80p::mwmv80PITFCommand entry\n");
   if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      DPF("mwmParseQueryModemRegisters ERROR\n");
      return 1;
   } /* endif */

   DPF("*usPlusITF=%d +1=%d +2=%d Registers.PlusITF[0]=%d [1]=%d [2]=%d",
    *usPlusITF,*(usPlusITF+1),*(usPlusITF+2),Registers.PlusITF[0],Registers.PlusITF[1],Registers.PlusITF[2]);

   if (* usPlusITF != Registers.PlusITF[0])
   {
       switch (* usPlusITF)
       {
         case ' ':  // no value specified
            break;
         case 154:
            usParmsChanged = 1;
            Registers.PlusITF[0] = *(usPlusITF);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusITF+1) != Registers.PlusITF[1])
   {
       switch (*(usPlusITF+1))
       {
         case ' ':  // no value specified
            break;
         case 38:
            usParmsChanged = 1;
            Registers.PlusITF[1] = *(usPlusITF + 1);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (*(usPlusITF+2) != Registers.PlusITF[2])
   {
       switch (*(usPlusITF+2))
       {
         case ' ':  // no value specified
            break;
         case 38:
            usParmsChanged = 1;
            Registers.PlusITF[2] = *(usPlusITF + 2);
            break;
         default:
            usParserStatus = MWM_ATCMD_ERROR;
            break;
       }
   } /* endif */

   if (usParserStatus != MWM_ATCMD_ERROR)
   {
     if (usParmsChanged)
     {
       mwmParseSetModemRegisters(&Registers);
     } /* endif */
   } /* endif */
  MW_SYSLOG_2(TRACE_MWMPW32,"mwmv80p::mwmv80PITFCommand exit usParserStatus %x\n",usParserStatus);
   return usParserStatus;
}

