// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsecuretunneling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCloseTunnel = "CloseTunnel"

// CloseTunnelRequest generates a "aws/request.Request" representing the
// client's request for the CloseTunnel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloseTunnel for more information on using the CloseTunnel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloseTunnelRequest method.
//    req, resp := client.CloseTunnelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel
func (c *IoTSecureTunneling) CloseTunnelRequest(input *CloseTunnelInput) (req *request.Request, output *CloseTunnelOutput) {
	op := &request.Operation{
		Name:       opCloseTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloseTunnelInput{}
	}

	output = &CloseTunnelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CloseTunnel API operation for AWS IoT Secure Tunneling.
//
// Closes a tunnel identified by the unique tunnel id. When a CloseTunnel request
// is received, we close the WebSocket connections between the client and proxy
// server so no data can be transmitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation CloseTunnel for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Thrown when an operation is attempted on a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel
func (c *IoTSecureTunneling) CloseTunnel(input *CloseTunnelInput) (*CloseTunnelOutput, error) {
	req, out := c.CloseTunnelRequest(input)
	return out, req.Send()
}

// CloseTunnelWithContext is the same as CloseTunnel with the addition of
// the ability to pass a context and additional request options.
//
// See CloseTunnel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) CloseTunnelWithContext(ctx aws.Context, input *CloseTunnelInput, opts ...request.Option) (*CloseTunnelOutput, error) {
	req, out := c.CloseTunnelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTunnel = "DescribeTunnel"

// DescribeTunnelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTunnel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTunnel for more information on using the DescribeTunnel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTunnelRequest method.
//    req, resp := client.DescribeTunnelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel
func (c *IoTSecureTunneling) DescribeTunnelRequest(input *DescribeTunnelInput) (req *request.Request, output *DescribeTunnelOutput) {
	op := &request.Operation{
		Name:       opDescribeTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTunnelInput{}
	}

	output = &DescribeTunnelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTunnel API operation for AWS IoT Secure Tunneling.
//
// Gets information about a tunnel identified by the unique tunnel id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation DescribeTunnel for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Thrown when an operation is attempted on a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel
func (c *IoTSecureTunneling) DescribeTunnel(input *DescribeTunnelInput) (*DescribeTunnelOutput, error) {
	req, out := c.DescribeTunnelRequest(input)
	return out, req.Send()
}

// DescribeTunnelWithContext is the same as DescribeTunnel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTunnel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) DescribeTunnelWithContext(ctx aws.Context, input *DescribeTunnelInput, opts ...request.Option) (*DescribeTunnelOutput, error) {
	req, out := c.DescribeTunnelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource
func (c *IoTSecureTunneling) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Secure Tunneling.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Thrown when an operation is attempted on a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource
func (c *IoTSecureTunneling) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTunnels = "ListTunnels"

// ListTunnelsRequest generates a "aws/request.Request" representing the
// client's request for the ListTunnels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTunnels for more information on using the ListTunnels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTunnelsRequest method.
//    req, resp := client.ListTunnelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels
func (c *IoTSecureTunneling) ListTunnelsRequest(input *ListTunnelsInput) (req *request.Request, output *ListTunnelsOutput) {
	op := &request.Operation{
		Name:       opListTunnels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTunnelsInput{}
	}

	output = &ListTunnelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTunnels API operation for AWS IoT Secure Tunneling.
//
// List all tunnels for an AWS account. Tunnels are listed by creation time
// in descending order, newer tunnels will be listed before older tunnels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation ListTunnels for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels
func (c *IoTSecureTunneling) ListTunnels(input *ListTunnelsInput) (*ListTunnelsOutput, error) {
	req, out := c.ListTunnelsRequest(input)
	return out, req.Send()
}

// ListTunnelsWithContext is the same as ListTunnels with the addition of
// the ability to pass a context and additional request options.
//
// See ListTunnels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) ListTunnelsWithContext(ctx aws.Context, input *ListTunnelsInput, opts ...request.Option) (*ListTunnelsOutput, error) {
	req, out := c.ListTunnelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTunnelsPages iterates over the pages of a ListTunnels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTunnels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTunnels operation.
//    pageNum := 0
//    err := client.ListTunnelsPages(params,
//        func(page *iotsecuretunneling.ListTunnelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTSecureTunneling) ListTunnelsPages(input *ListTunnelsInput, fn func(*ListTunnelsOutput, bool) bool) error {
	return c.ListTunnelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTunnelsPagesWithContext same as ListTunnelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) ListTunnelsPagesWithContext(ctx aws.Context, input *ListTunnelsInput, fn func(*ListTunnelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTunnelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTunnelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTunnelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opOpenTunnel = "OpenTunnel"

// OpenTunnelRequest generates a "aws/request.Request" representing the
// client's request for the OpenTunnel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See OpenTunnel for more information on using the OpenTunnel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the OpenTunnelRequest method.
//    req, resp := client.OpenTunnelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel
func (c *IoTSecureTunneling) OpenTunnelRequest(input *OpenTunnelInput) (req *request.Request, output *OpenTunnelOutput) {
	op := &request.Operation{
		Name:       opOpenTunnel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OpenTunnelInput{}
	}

	output = &OpenTunnelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OpenTunnel API operation for AWS IoT Secure Tunneling.
//
// Creates a new tunnel, and returns two client access tokens for clients to
// use to connect to the AWS IoT Secure Tunneling proxy server. .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation OpenTunnel for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   Thrown when a tunnel limit is exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel
func (c *IoTSecureTunneling) OpenTunnel(input *OpenTunnelInput) (*OpenTunnelOutput, error) {
	req, out := c.OpenTunnelRequest(input)
	return out, req.Send()
}

// OpenTunnelWithContext is the same as OpenTunnel with the addition of
// the ability to pass a context and additional request options.
//
// See OpenTunnel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) OpenTunnelWithContext(ctx aws.Context, input *OpenTunnelInput, opts ...request.Option) (*OpenTunnelOutput, error) {
	req, out := c.OpenTunnelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource
func (c *IoTSecureTunneling) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Secure Tunneling.
//
// A resource tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Thrown when an operation is attempted on a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource
func (c *IoTSecureTunneling) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource
func (c *IoTSecureTunneling) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Secure Tunneling.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Secure Tunneling's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Thrown when an operation is attempted on a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource
func (c *IoTSecureTunneling) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTSecureTunneling) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CloseTunnelInput struct {
	_ struct{} `type:"structure"`

	// When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
	Delete *bool `locationName:"delete" type:"boolean"`

	// The ID of the tunnel to close.
	//
	// TunnelId is a required field
	TunnelId *string `locationName:"tunnelId" type:"string" required:"true"`
}

// String returns the string representation
func (s CloseTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseTunnelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseTunnelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloseTunnelInput"}
	if s.TunnelId == nil {
		invalidParams.Add(request.NewErrParamRequired("TunnelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDelete sets the Delete field's value.
func (s *CloseTunnelInput) SetDelete(v bool) *CloseTunnelInput {
	s.Delete = &v
	return s
}

// SetTunnelId sets the TunnelId field's value.
func (s *CloseTunnelInput) SetTunnelId(v string) *CloseTunnelInput {
	s.TunnelId = &v
	return s
}

type CloseTunnelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CloseTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseTunnelOutput) GoString() string {
	return s.String()
}

// The state of a connection.
type ConnectionState struct {
	_ struct{} `type:"structure"`

	// The last time the connection status was updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The connection status of the tunnel. Valid values are CONNECTED and DISCONNECTED.
	Status *string `locationName:"status" type:"string" enum:"ConnectionStatus"`
}

// String returns the string representation
func (s ConnectionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionState) GoString() string {
	return s.String()
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ConnectionState) SetLastUpdatedAt(v time.Time) *ConnectionState {
	s.LastUpdatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ConnectionState) SetStatus(v string) *ConnectionState {
	s.Status = &v
	return s
}

type DescribeTunnelInput struct {
	_ struct{} `type:"structure"`

	// The tunnel to describe.
	//
	// TunnelId is a required field
	TunnelId *string `locationName:"tunnelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTunnelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTunnelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTunnelInput"}
	if s.TunnelId == nil {
		invalidParams.Add(request.NewErrParamRequired("TunnelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTunnelId sets the TunnelId field's value.
func (s *DescribeTunnelInput) SetTunnelId(v string) *DescribeTunnelInput {
	s.TunnelId = &v
	return s
}

type DescribeTunnelOutput struct {
	_ struct{} `type:"structure"`

	// The tunnel being described.
	Tunnel *Tunnel `locationName:"tunnel" type:"structure"`
}

// String returns the string representation
func (s DescribeTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTunnelOutput) GoString() string {
	return s.String()
}

// SetTunnel sets the Tunnel field's value.
func (s *DescribeTunnelOutput) SetTunnel(v *Tunnel) *DescribeTunnelOutput {
	s.Tunnel = v
	return s
}

// The destination configuration.
type DestinationConfig struct {
	_ struct{} `type:"structure"`

	// A list of service names that identity the target application. Currently,
	// you can only specify a single name. The AWS IoT client running on the destination
	// device reads this value and uses it to look up a port or an IP address and
	// a port. The AWS IoT client instantiates the local proxy which uses this information
	// to connect to the destination application.
	//
	// Services is a required field
	Services []*string `locationName:"services" min:"1" type:"list" required:"true"`

	// The name of the IoT thing to which you want to connect.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationConfig"}
	if s.Services == nil {
		invalidParams.Add(request.NewErrParamRequired("Services"))
	}
	if s.Services != nil && len(s.Services) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Services", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServices sets the Services field's value.
func (s *DestinationConfig) SetServices(v []*string) *DestinationConfig {
	s.Services = v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DestinationConfig) SetThingName(v string) *DestinationConfig {
	s.ThingName = &v
	return s
}

// Thrown when a tunnel limit is exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the specified resource.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTunnelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at once.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the IoT thing associated with the destination device.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListTunnelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTunnelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTunnelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTunnelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTunnelsInput) SetMaxResults(v int64) *ListTunnelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTunnelsInput) SetNextToken(v string) *ListTunnelsInput {
	s.NextToken = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ListTunnelsInput) SetThingName(v string) *ListTunnelsInput {
	s.ThingName = &v
	return s
}

type ListTunnelsOutput struct {
	_ struct{} `type:"structure"`

	// A token to used to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A short description of the tunnels in an AWS account.
	TunnelSummaries []*TunnelSummary `locationName:"tunnelSummaries" type:"list"`
}

// String returns the string representation
func (s ListTunnelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTunnelsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTunnelsOutput) SetNextToken(v string) *ListTunnelsOutput {
	s.NextToken = &v
	return s
}

// SetTunnelSummaries sets the TunnelSummaries field's value.
func (s *ListTunnelsOutput) SetTunnelSummaries(v []*TunnelSummary) *ListTunnelsOutput {
	s.TunnelSummaries = v
	return s
}

type OpenTunnelInput struct {
	_ struct{} `type:"structure"`

	// A short text description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The destination configuration for the OpenTunnel request.
	DestinationConfig *DestinationConfig `locationName:"destinationConfig" type:"structure"`

	// A collection of tag metadata.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// Timeout configuration for a tunnel.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`
}

// String returns the string representation
func (s OpenTunnelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenTunnelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenTunnelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenTunnelInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.DestinationConfig != nil {
		if err := s.DestinationConfig.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimeoutConfig != nil {
		if err := s.TimeoutConfig.Validate(); err != nil {
			invalidParams.AddNested("TimeoutConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *OpenTunnelInput) SetDescription(v string) *OpenTunnelInput {
	s.Description = &v
	return s
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *OpenTunnelInput) SetDestinationConfig(v *DestinationConfig) *OpenTunnelInput {
	s.DestinationConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *OpenTunnelInput) SetTags(v []*Tag) *OpenTunnelInput {
	s.Tags = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *OpenTunnelInput) SetTimeoutConfig(v *TimeoutConfig) *OpenTunnelInput {
	s.TimeoutConfig = v
	return s
}

type OpenTunnelOutput struct {
	_ struct{} `type:"structure"`

	// The access token the destination local proxy uses to connect to AWS IoT Secure
	// Tunneling.
	DestinationAccessToken *string `locationName:"destinationAccessToken" type:"string" sensitive:"true"`

	// The access token the source local proxy uses to connect to AWS IoT Secure
	// Tunneling.
	SourceAccessToken *string `locationName:"sourceAccessToken" type:"string" sensitive:"true"`

	// The Amazon Resource Name for the tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// A unique alpha-numeric tunnel ID.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s OpenTunnelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenTunnelOutput) GoString() string {
	return s.String()
}

// SetDestinationAccessToken sets the DestinationAccessToken field's value.
func (s *OpenTunnelOutput) SetDestinationAccessToken(v string) *OpenTunnelOutput {
	s.DestinationAccessToken = &v
	return s
}

// SetSourceAccessToken sets the SourceAccessToken field's value.
func (s *OpenTunnelOutput) SetSourceAccessToken(v string) *OpenTunnelOutput {
	s.SourceAccessToken = &v
	return s
}

// SetTunnelArn sets the TunnelArn field's value.
func (s *OpenTunnelOutput) SetTunnelArn(v string) *OpenTunnelOutput {
	s.TunnelArn = &v
	return s
}

// SetTunnelId sets the TunnelId field's value.
func (s *OpenTunnelOutput) SetTunnelId(v string) *OpenTunnelOutput {
	s.TunnelId = &v
	return s
}

// Thrown when an operation is attempted on a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An arbitary key/value pair used to add searchable metadata to secure tunnel
// resources.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags for the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Tunnel timeout configuration.
type TimeoutConfig struct {
	_ struct{} `type:"structure"`

	// The maximum amount of time (in minutes) a tunnel can remain open. If not
	// specified, maxLifetimeTimeoutMinutes defaults to 720 minutes. Valid values
	// are from 1 minute to 12 hours (720 minutes)
	MaxLifetimeTimeoutMinutes *int64 `locationName:"maxLifetimeTimeoutMinutes" min:"1" type:"integer"`
}

// String returns the string representation
func (s TimeoutConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeoutConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeoutConfig"}
	if s.MaxLifetimeTimeoutMinutes != nil && *s.MaxLifetimeTimeoutMinutes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxLifetimeTimeoutMinutes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxLifetimeTimeoutMinutes sets the MaxLifetimeTimeoutMinutes field's value.
func (s *TimeoutConfig) SetMaxLifetimeTimeoutMinutes(v int64) *TimeoutConfig {
	s.MaxLifetimeTimeoutMinutes = &v
	return s
}

// A connection between a source computer and a destination device.
type Tunnel struct {
	_ struct{} `type:"structure"`

	// The time when the tunnel was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The destination configuration that specifies the thing name of the destination
	// device and a service name that the local proxy uses to connect to the destination
	// application.
	DestinationConfig *DestinationConfig `locationName:"destinationConfig" type:"structure"`

	// The connection state of the destination application.
	DestinationConnectionState *ConnectionState `locationName:"destinationConnectionState" type:"structure"`

	// The last time the tunnel was updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The connection state of the source application.
	SourceConnectionState *ConnectionState `locationName:"sourceConnectionState" type:"structure"`

	// The status of a tunnel. Valid values are: Open and Closed.
	Status *string `locationName:"status" type:"string" enum:"TunnelStatus"`

	// A list of tag metadata associated with the secure tunnel.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// Timeout configuration for the tunnel.
	TimeoutConfig *TimeoutConfig `locationName:"timeoutConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// A unique alpha-numeric ID that identifies a tunnel.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s Tunnel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tunnel) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Tunnel) SetCreatedAt(v time.Time) *Tunnel {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Tunnel) SetDescription(v string) *Tunnel {
	s.Description = &v
	return s
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *Tunnel) SetDestinationConfig(v *DestinationConfig) *Tunnel {
	s.DestinationConfig = v
	return s
}

// SetDestinationConnectionState sets the DestinationConnectionState field's value.
func (s *Tunnel) SetDestinationConnectionState(v *ConnectionState) *Tunnel {
	s.DestinationConnectionState = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *Tunnel) SetLastUpdatedAt(v time.Time) *Tunnel {
	s.LastUpdatedAt = &v
	return s
}

// SetSourceConnectionState sets the SourceConnectionState field's value.
func (s *Tunnel) SetSourceConnectionState(v *ConnectionState) *Tunnel {
	s.SourceConnectionState = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Tunnel) SetStatus(v string) *Tunnel {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Tunnel) SetTags(v []*Tag) *Tunnel {
	s.Tags = v
	return s
}

// SetTimeoutConfig sets the TimeoutConfig field's value.
func (s *Tunnel) SetTimeoutConfig(v *TimeoutConfig) *Tunnel {
	s.TimeoutConfig = v
	return s
}

// SetTunnelArn sets the TunnelArn field's value.
func (s *Tunnel) SetTunnelArn(v string) *Tunnel {
	s.TunnelArn = &v
	return s
}

// SetTunnelId sets the TunnelId field's value.
func (s *Tunnel) SetTunnelId(v string) *Tunnel {
	s.TunnelId = &v
	return s
}

// Information about the tunnel.
type TunnelSummary struct {
	_ struct{} `type:"structure"`

	// The time the tunnel was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description of the tunnel.
	Description *string `locationName:"description" type:"string"`

	// The time the tunnel was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The status of a tunnel. Valid values are: Open and Closed.
	Status *string `locationName:"status" type:"string" enum:"TunnelStatus"`

	// The Amazon Resource Name of the tunnel. The tunnel ARN format is arn:aws:tunnel:<region>:<account-id>:tunnel/<tunnel-id>
	TunnelArn *string `locationName:"tunnelArn" min:"1" type:"string"`

	// The unique alpha-numeric identifier for the tunnel.
	TunnelId *string `locationName:"tunnelId" type:"string"`
}

// String returns the string representation
func (s TunnelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TunnelSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TunnelSummary) SetCreatedAt(v time.Time) *TunnelSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TunnelSummary) SetDescription(v string) *TunnelSummary {
	s.Description = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TunnelSummary) SetLastUpdatedAt(v time.Time) *TunnelSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TunnelSummary) SetStatus(v string) *TunnelSummary {
	s.Status = &v
	return s
}

// SetTunnelArn sets the TunnelArn field's value.
func (s *TunnelSummary) SetTunnelArn(v string) *TunnelSummary {
	s.TunnelArn = &v
	return s
}

// SetTunnelId sets the TunnelId field's value.
func (s *TunnelSummary) SetTunnelId(v string) *TunnelSummary {
	s.TunnelId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

const (
	// ConnectionStatusConnected is a ConnectionStatus enum value
	ConnectionStatusConnected = "CONNECTED"

	// ConnectionStatusDisconnected is a ConnectionStatus enum value
	ConnectionStatusDisconnected = "DISCONNECTED"
)

// ConnectionStatus_Values returns all elements of the ConnectionStatus enum
func ConnectionStatus_Values() []string {
	return []string{
		ConnectionStatusConnected,
		ConnectionStatusDisconnected,
	}
}

const (
	// TunnelStatusOpen is a TunnelStatus enum value
	TunnelStatusOpen = "OPEN"

	// TunnelStatusClosed is a TunnelStatus enum value
	TunnelStatusClosed = "CLOSED"
)

// TunnelStatus_Values returns all elements of the TunnelStatus enum
func TunnelStatus_Values() []string {
	return []string{
		TunnelStatusOpen,
		TunnelStatusClosed,
	}
}
