/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class OneHotEncoderCommon$ {
    public static OneHotEncoderCommon$ MODULE$;

    static {
        new OneHotEncoderCommon$();
    }

    private Option<String[]> genOutputAttrNames(StructField inputCol) {
        None$ none$;
        Attribute inputAttr = Attribute$.MODULE$.fromStructField(inputCol);
        Attribute attribute = inputAttr;
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1 & Serializable & scala.Serializable)n -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$1(BoxesRunTime.unboxToInt((Object)n))) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1 & Serializable & scala.Serializable)x$12 -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$3(BoxesRunTime.unboxToInt((Object)x$12)), ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringBuilder(45).append("The input column ").append(inputCol.name()).append(" cannot be continuous-value.").toString());
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private AttributeGroup genOutputAttrGroup(Option<String[]> outputAttrNames, String outputColName) {
        return (AttributeGroup)outputAttrNames.map((Function1 & Serializable & scala.Serializable)attrNames -> {
            Attribute[] attrs = (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attrNames)).map((Function1 & Serializable & scala.Serializable)name -> BinaryAttribute$.MODULE$.defaultAttr().withName((String)name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            return new AttributeGroup(outputColName, attrs);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AttributeGroup(outputColName));
    }

    public StructField transformOutputColumnSchema(StructField inputCol, String outputColName, boolean dropLast, boolean keepInvalid) {
        Option<String[]> outputAttrNames = this.genOutputAttrNames(inputCol);
        Option filteredOutputAttrNames = outputAttrNames.map((Function1 & Serializable & scala.Serializable)names -> {
            String[] stringArray;
            if (dropLast && !keepInvalid) {
                Predef$.MODULE$.require(((String[])names).length > 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("The input column ").append(inputCol.name()).append(" should have at least two distinct values.").toString());
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).dropRight(1);
            } else {
                stringArray = !dropLast && keepInvalid ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalidValues"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : names;
            }
            return stringArray;
        });
        return this.genOutputAttrGroup((Option<String[]>)filteredOutputAttrNames, outputColName).toStructField();
    }

    public boolean transformOutputColumnSchema$default$4() {
        return false;
    }

    public Seq<AttributeGroup> getOutputAttrGroupFromData(Dataset<?> dataset, Seq<String> inputColNames, Seq<String> outputColNames, boolean dropLast) {
        Seq columns = (Seq)inputColNames.map((Function1 & Serializable & scala.Serializable)inputColName -> functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$), Seq$.MODULE$.canBuildFrom());
        int numOfColumns = columns.length();
        RDD qual$1 = dataset.select(columns).rdd().map((Function1 & Serializable & scala.Serializable)row -> (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfColumns).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)idx -> row.getDouble(idx), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        double[] x$1 = new double[numOfColumns];
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(maxValues, curValues) -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfColumns).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                double x = curValues[idx];
                Predef$.MODULE$.assert(x <= (double)Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("OneHotEncoder only supports up to ").append(Integer.MAX_VALUE).append(" indices, but got ").append(x).append(".").toString());
                Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Values from column ").append(inputColNames.apply(idx)).append(" must be indices, but got ").append(x).append(".").toString());
                maxValues$1[idx] = package$.MODULE$.max(maxValues[idx], x);
            });
            return maxValues;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(m0, m1) -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfColumns).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                m0$1[idx] = package$.MODULE$.max(m0[idx], m1[idx]);
            });
            return m0;
        };
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        int[] numAttrsArray = (int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$13 -> (int)x$13 + 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return (Seq)((TraversableLike)outputColNames.zip((GenIterable)Predef$.MODULE$.wrapIntArray(numAttrsArray), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String outputColName = (String)tuple2._1();
            int numAttrs = tuple2._2$mcI$sp();
            AttributeGroup attributeGroup = MODULE$.createAttrGroupForAttrNames(outputColName, numAttrs, dropLast, false);
            return attributeGroup;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public AttributeGroup createAttrGroupForAttrNames(String outputColName, int numAttrs, boolean dropLast, boolean keepInvalid) {
        String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1 & Serializable & scala.Serializable)x$14 -> OneHotEncoderCommon$.$anonfun$createAttrGroupForAttrNames$1(BoxesRunTime.unboxToInt((Object)x$14)), ClassTag$.MODULE$.apply(String.class));
        String[] filtered = dropLast && !keepInvalid ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputAttrNames)).dropRight(1) : (!dropLast && keepInvalid ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputAttrNames)).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalidValues"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : outputAttrNames);
        return this.genOutputAttrGroup((Option<String[]>)new Some((Object)filtered), outputColName);
    }

    public static final /* synthetic */ String $anonfun$genOutputAttrNames$2(int x$11) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$11)).toString();
    }

    public static final /* synthetic */ String[] $anonfun$genOutputAttrNames$1(int n) {
        return (String[])Array$.MODULE$.tabulate(n, (Function1 & Serializable & scala.Serializable)x$11 -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$2(BoxesRunTime.unboxToInt((Object)x$11)), ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ String $anonfun$genOutputAttrNames$3(int x$12) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$12)).toString();
    }

    public static final /* synthetic */ String $anonfun$createAttrGroupForAttrNames$1(int x$14) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$14)).toString();
    }

    private OneHotEncoderCommon$() {
        MODULE$ = this;
    }
}

