/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.regression.IsotonicRegression;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IsotonicRegressionExample$ {
    public static IsotonicRegressionExample$ MODULE$;

    static {
        new IsotonicRegressionExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("IsotonicRegressionExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_isotonic_regression_libsvm_data.txt").cache();
        RDD parsedData = data.map((Function1 & java.io.Serializable & Serializable)labeledPoint -> new Tuple3((Object)BoxesRunTime.boxToDouble((double)labeledPoint.label()), (Object)BoxesRunTime.boxToDouble((double)labeledPoint.features().apply(0)), (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple3.class));
        RDD[] splits = parsedData.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0];
        RDD test = splits[1];
        IsotonicRegressionModel model = new IsotonicRegression().setIsotonic(true).run(training);
        RDD predictionAndLabel = test.map((Function1 & java.io.Serializable & Serializable)point -> {
            double predictedLabel = model.predict(BoxesRunTime.unboxToDouble((Object)point._2()));
            return new Tuple2.mcDD.sp(predictedLabel, BoxesRunTime.unboxToDouble((Object)point._1()));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double meanSquaredError = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictionAndLabel.map((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)IsotonicRegressionExample$.$anonfun$main$3(x0$1)), ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Mean Squared Error = ").append(meanSquaredError).toString());
        model.save(sc, "target/tmp/myIsotonicRegressionModel");
        IsotonicRegressionModel sameModel = IsotonicRegressionModel$.MODULE$.load(sc, "target/tmp/myIsotonicRegressionModel");
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$main$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double p = tuple2._1$mcD$sp();
        double l = tuple2._2$mcD$sp();
        double d = package$.MODULE$.pow(p - l, 2.0);
        return d;
    }

    private IsotonicRegressionExample$() {
        MODULE$ = this;
    }
}

