/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.BisectingKMeans;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.evaluation.ClusteringEvaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaBisectingKMeansExample {
    public static void main(String[] args) {
        Vector[] centers;
        SparkSession spark = SparkSession.builder().appName("JavaBisectingKMeansExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_kmeans_data.txt");
        BisectingKMeans bkm = new BisectingKMeans().setK(2).setSeed(1L);
        BisectingKMeansModel model = bkm.fit(dataset);
        Dataset predictions = model.transform(dataset);
        ClusteringEvaluator evaluator = new ClusteringEvaluator();
        double silhouette = evaluator.evaluate(predictions);
        System.out.println("Silhouette with squared euclidean distance = " + silhouette);
        System.out.println("Cluster Centers: ");
        for (Vector center : centers = model.clusterCenters()) {
            System.out.println(center);
        }
        spark.stop();
    }
}

