/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0012%\u0001EB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AA\f\u0001B\u0002B\u0003-Q\fC\u0003d\u0001\u0011\u0005A\rC\u0004k\u0001\t\u0007I1B6\t\u000f\u0005%\u0001\u0001)A\u0005Y\"I\u00111\u0002\u0001C\u0002\u0013-\u0011Q\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011q\u0003\u0001C\u0002\u0013\u0005\u0011\u0011\u0004\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u001c!I\u0011Q\u0006\u0001C\u0002\u0013E\u0011q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00022!I\u0011\u0011\b\u0001C\u0002\u0013E\u00111\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002>!9\u0011\u0011\f\u0001\u0005\u0012\u0005m\u0003bBA4\u0001\u0011E\u0011\u0011\u000e\u0005\b\u0003[\u0002A\u0011CA8\u0011\u001d\tI\b\u0001C\t\u0003wBq!a&\u0001\t#\tI\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003[\u0003A\u0011IAt\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003AqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\n\u0001!\tAa\u0003\t\u000f\tU\u0001\u0001\"\u0011\u0003\u0018!9!Q\u0004\u0001\u0005\u0002\t}\u0001\u0002\u0003B\u0012\u0001\u0011\u0005\u0001F!\n\b\u000f\tUB\u0005#\u0001\u00038\u001911\u0005\nE\u0001\u0005sAaa\u0019\u0011\u0005\u0002\tm\u0002b\u0002B\u001fA\u0011\u0005!q\b\u0002\u0010\u0011\u001235+T3uC\u0012\fG/\u0019'pO*\u0011QEJ\u0001\ngR\u0014X-Y7j]\u001eT!a\n\u0015\u0002\u0013\u0015DXmY;uS>t'BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u0001QC\u0001\u001a@'\u0011\u00011'O#\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\rQ4(P\u0007\u0002I%\u0011A\b\n\u0002\f\u001b\u0016$\u0018\rZ1uC2{w\r\u0005\u0002?\u007f1\u0001A!\u0002!\u0001\u0005\u0004\t%!\u0001+\u0012\u0005\t\u001b\u0004C\u0001\u001bD\u0013\t!UGA\u0004O_RD\u0017N\\4\u0011\u0005\u0019KU\"A$\u000b\u0005!S\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005);%a\u0002'pO\u001eLgnZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u001b:k\u0011\u0001K\u0005\u0003\u001f\"\u0012Ab\u00159be.\u001cVm]:j_:\fA\u0001]1uQB\u0011!+\u0017\b\u0003'^\u0003\"\u0001V\u001b\u000e\u0003US!A\u0016\u0019\u0002\rq\u0012xn\u001c;?\u0013\tAV'\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-6\u0003))g/\u001b3f]\u000e,G%\r\t\u0004=\u0006lT\"A0\u000b\u0005\u0001,\u0014a\u0002:fM2,7\r^\u0005\u0003E~\u0013\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015D\u0017\u000e\u0006\u0002gOB\u0019!\bA\u001f\t\u000bq#\u00019A/\t\u000b-#\u0001\u0019\u0001'\t\u000bA#\u0001\u0019A)\u0002\u000f\u0019|'/\\1ugV\tANE\u0002ngQ4AA\u001c\u0001\u0001Y\naAH]3gS:,W.\u001a8u}%\u0011!\u000e]\u0005\u0003cJ\u0014QbU3sS\u0006d\u0017N_1uS>t'BA:/\u0003\u0019Q7o\u001c85gB\u0011QO^\u0007\u0002e&\u0011qO\u001d\u0002\b\r>\u0014X.\u0019;t\u0011\u001dIXN1A\u0005\u0002i\f!\u0002Z1uK\u001a{'/\\1u+\u0005Y\bCA;}\u0013\ti(O\u0001\u0006ECR,gi\u001c:nCRD\u0001b`7C\u0002\u0013\u0005\u0013\u0011A\u0001\nif\u0004X\rS5oiN,\"!a\u0001\u0011\u0007U\f)!C\u0002\u0002\bI\u0014\u0011\u0002V=qK\"Kg\u000e^:\u0002\u0011\u0019|'/\\1ug\u0002\n\u0001\"\\1oS\u001a,7\u000f^\u000b\u0003\u0003\u001f\u0001BAXA\t{%\u0019\u00111C0\u0003\u00115\u000bg.\u001b4fgR\f\u0011\"\\1oS\u001a,7\u000f\u001e\u0011\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0003MNT1!!\n-\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011FA\u0010\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001b5,G/\u00193bi\u0006\u0004\u0016\r\u001e5!\u0003-1\u0017\u000e\\3NC:\fw-\u001a:\u0016\u0005\u0005E\u0002c\u0001\u001e\u00024%\u0019\u0011Q\u0007\u0013\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\u0006aa-\u001b7f\u001b\u0006t\u0017mZ3sA\u0005\u0001\"-\u0019;dQ\u001aKG.Z:GS2$XM]\u000b\u0003\u0003{\u0011b!a\u0010\u0002D\u0005Mc!\u00028\u000f\u0001\u0005u\u0012!\u00052bi\u000eDg)\u001b7fg\u001aKG\u000e^3sAA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0005\u0003#\n9E\u0001\u0004PE*,7\r\u001e\t\u0005\u0003;\t)&\u0003\u0003\u0002X\u0005}!A\u0003)bi\"4\u0015\u000e\u001c;fe\u0006i!-\u0019;dQ&#Gk\u001c)bi\"$B!a\u0007\u0002^!9\u0011qL\bA\u0002\u0005\u0005\u0014a\u00022bi\u000eD\u0017\n\u001a\t\u0004i\u0005\r\u0014bAA3k\t!Aj\u001c8h\u00035\u0001\u0018\r\u001e5U_\n\u000bGo\u00195JIR!\u0011\u0011MA6\u0011\u0019\u0001\u0006\u00031\u0001\u0002\u001c\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t\t(a\u001e\u0011\u0007Q\n\u0019(C\u0002\u0002vU\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004Q#\u0001\u0007\u00111D\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$b!! \u0002\u0004\u0006\u001d\u0005c\u0001\u001b\u0002\u0000%\u0019\u0011\u0011Q\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u000b\u0013\u0002\u0019A\u001f\u0002\u00115,G/\u00193bi\u0006Dq!!#\u0013\u0001\u0004\tY)A\u0002pkR\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0005\u0003#\u000bY%\u0001\u0002j_&!\u0011QSAH\u00051yU\u000f\u001e9viN#(/Z1n\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007u\nY\nC\u0004\u0002\u001eN\u0001\r!a(\u0002\u0005%t\u0007\u0003BAG\u0003CKA!a)\u0002\u0010\nY\u0011J\u001c9viN#(/Z1n\u0003\r\tG\r\u001a\u000b\u0007\u0003c\nI+a+\t\u000f\u0005}C\u00031\u0001\u0002b!1\u0011Q\u0011\u000bA\u0002u\n1aZ3u)\u0011\t\t,a.\u0011\tQ\n\u0019,P\u0005\u0004\u0003k+$AB(qi&|g\u000eC\u0004\u0002`U\u0001\r!!\u0019\u0002-\u0005\u0004\b\u000f\\=G]R{')\u0019;dQ\nK8\u000b\u001e:fC6,B!!0\u0002DR!\u0011qXAm)\u0011\t\t-a4\u0011\u0007y\n\u0019\rB\u0004\u0002FZ\u0011\r!a2\u0003\u0007I+E+E\u0002C\u0003\u0013\u00042\u0001NAf\u0013\r\ti-\u000e\u0002\u0004\u0003:L\bbBAi-\u0001\u0007\u00111[\u0001\u0003M:\u0004r\u0001NAk\u0003?\u000b\t-C\u0002\u0002XV\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\u0005}c\u00031\u0001\u0002b\u0005\u0019\u0012\r\u001a3OK^\u0014\u0015\r^2i\u0005f\u001cFO]3b[R!\u0011q\\As)\u0011\t\t(!9\t\u000f\u0005Ew\u00031\u0001\u0002dB9A'!6\u0002\f\u0006u\u0004bBA0/\u0001\u0007\u0011\u0011\r\u000b\u0007\u0003S\f)0a?\u0011\u000bQ\nY/a<\n\u0007\u00055XGA\u0003BeJ\f\u0017\u0010\u0005\u00045\u0003c\f\t'P\u0005\u0004\u0003g,$A\u0002+va2,'\u0007C\u0004\u0002xb\u0001\r!!?\u0002\u000fM$\u0018M\u001d;JIB)A'a-\u0002b!9\u0011Q \rA\u0002\u0005e\u0018!B3oI&#\u0017\u0001E4fi2\u000bG/Z:u\u0005\u0006$8\r[%e)\t\tI0A\u0005hKRd\u0015\r^3tiR\u0011!q\u0001\t\u0006i\u0005M\u0016q^\u0001\u0015O\u0016$xJ\u001d3fe\u0016$')\u0019;dQ\u001aKG.Z:\u0015\u0005\t5\u0001#\u0002\u001b\u0002l\n=\u0001\u0003BA\u000f\u0005#IAAa\u0005\u0002 \tQa)\u001b7f'R\fG/^:\u0002\u000bA,(oZ3\u0015\t\u0005u$\u0011\u0004\u0005\b\u00057a\u0002\u0019AA1\u0003A!\bN]3tQ>dGMQ1uG\"LE-\u0001\u0006qkJ<W-\u00114uKJ$B!! \u0003\"!9!1D\u000fA\u0002\u0005\u0005\u0014a\u0004<bY&$\u0017\r^3WKJ\u001c\u0018n\u001c8\u0015\r\t\u001d\"Q\u0006B\u0019!\r!$\u0011F\u0005\u0004\u0005W)$aA%oi\"1!q\u0006\u0010A\u0002E\u000bA\u0001^3yi\"9!1\u0007\u0010A\u0002\t\u001d\u0012aE7bqN+\b\u000f]8si\u0016$g+\u001a:tS>t\u0017a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0005i\u00023C\u0001\u00114)\t\u00119$\u0001\bwKJLg-\u001f\"bi\u000eD\u0017\nZ:\u0015\u0011\u0005u$\u0011\tB,\u00053BqAa\u0011#\u0001\u0004\u0011)%\u0001\u0005cCR\u001c\u0007.\u00133t!\u0019\u00119E!\u0015\u0002b9!!\u0011\nB'\u001d\r!&1J\u0005\u0002m%\u0019!qJ\u001b\u0002\u000fA\f7m[1hK&!!1\u000bB+\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u001f*\u0004bBA|E\u0001\u0007\u0011\u0011 \u0005\b\u0003{\u0014\u0003\u0019AA}\u0001")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "'null' metadata cannot written to a metadata log");
        return this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<T> get(long batchId) {
        Option option;
        try {
            option = (Option)this.applyFnToBatchByStream(batchId, (Function1 & Serializable & scala.Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> fne.getMessage());
            option = None$.MODULE$;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, Function1<InputStream, RET> fn) {
        Object object;
        block6: {
            Path batchMetadataFile = this.batchIdToPath(batchId);
            if (this.fileManager().exists(batchMetadataFile)) {
                FSDataInputStream input = this.fileManager().open(batchMetadataFile);
                try {
                    try {
                        object = fn.apply((Object)input);
                        break block6;
                    }
                    catch (IllegalStateException ise) {
                        throw new IllegalStateException(new StringBuilder(26).append("Failed to read log file ").append(batchMetadataFile).append(". ").append(ise.getMessage()).toString(), ise);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            throw new FileNotFoundException(new StringBuilder(21).append("Unable to find batch ").append(batchMetadataFile).toString());
        }
        return (RET)object;
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$addNewBatchByStream$1(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(this.batchIdToPath(batchId), false);
            try {
                fn.apply((Object)output);
                output.close();
            }
            catch (FileAlreadyExistsException e) {
                throw new ConcurrentModificationException(new StringBuilder(50).append("Multiple streaming queries are concurrently using ").append($this.path).toString(), e);
            }
            finally {
                output.cancel();
            }
            return true;
        }));
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get()))))).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$get$5(this, BoxesRunTime.unboxToLong((Object)batchId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$get$6(x$2))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long batchId = tuple2._1$mcJ$sp();
            Option metadataOption = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public Option<Object> getLatestBatchId() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted(Ordering.Long$.MODULE$.reverse()))).headOption();
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return this.getLatestBatchId().map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).sortBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$))).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public static final /* synthetic */ boolean $anonfun$addNewBatchByStream$1(Object x$1) {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$5(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.get(batchId));
    }

    public static final /* synthetic */ boolean $anonfun$get$6(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        Object content = $this.get(batchId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(34).append("failed to read log file for batch ").append(batchId).toString());
        });
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), content);
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable & scala.Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

