/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import org.apache.orc.TypeDescription;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class OrcFileFormat$
implements Serializable {
    public static OrcFileFormat$ MODULE$;

    static {
        new OrcFileFormat$();
    }

    private void checkFieldName(String name) {
        try {
            TypeDescription.fromString((String)new StringBuilder(14).append("struct<`").append(name).append("`:int>").toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnalysisException(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Column name \"").append(name).append("\" contains invalid character(s).\n             |Please use alias to rename it.\n           ").toString())).stripMargin().split("\n"))).mkString(" ").trim(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void checkFieldNames(Seq<String> names) {
        names.foreach((Function1 & java.io.Serializable & Serializable)name -> {
            OrcFileFormat$.MODULE$.checkFieldName(name);
            return BoxedUnit.UNIT;
        });
    }

    public String getQuotedSchemaString(DataType dataType) {
        String string;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            string = dataType.catalogString();
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & java.io.Serializable & Serializable)f -> new StringBuilder(3).append("`").append(f.name()).append("`:").append(MODULE$.getQuotedSchemaString(f.dataType())).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("struct<", ",", ">");
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            string = new StringBuilder(7).append("array<").append(this.getQuotedSchemaString(elementType)).append(">").toString();
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            string = new StringBuilder(6).append("map<").append(this.getQuotedSchemaString(keyType)).append(",").append(this.getQuotedSchemaString(valueType)).append(">").toString();
        } else {
            string = dataType.catalogString();
        }
        return string;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OrcFileFormat$() {
        MODULE$ = this;
    }
}

