/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.AbstractAppHandle;
import org.apache.spark.launcher.LauncherConnection;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.NamedThreadFactory;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

class LauncherServer
implements Closeable {
    private static final Logger LOG = Logger.getLogger(LauncherServer.class.getName());
    private static final String THREAD_NAME_FMT = "LauncherServer-%d";
    private static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
    private static final SecureRandom RND = new SecureRandom();
    private static volatile LauncherServer serverInstance;
    private final AtomicLong refCount = new AtomicLong(0L);
    private final AtomicLong threadIds;
    private final ConcurrentMap<String, AbstractAppHandle> secretToPendingApps;
    private final List<ServerConnection> clients;
    private final ServerSocket server;
    private final Thread serverThread;
    private final ThreadFactory factory;
    private final Timer timeoutTimer;
    private volatile boolean running;

    static synchronized LauncherServer getOrCreateServer() throws IOException {
        LauncherServer server;
        do {
            LauncherServer launcherServer = server = serverInstance != null ? serverInstance : new LauncherServer();
        } while (!server.running);
        server.ref();
        serverInstance = server;
        return server;
    }

    static synchronized LauncherServer getServer() {
        return serverInstance;
    }

    private LauncherServer() throws IOException {
        ServerSocket server = new ServerSocket();
        try {
            server.setReuseAddress(true);
            server.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
            this.clients = new ArrayList<ServerConnection>();
            this.threadIds = new AtomicLong();
            this.factory = new NamedThreadFactory(THREAD_NAME_FMT);
            this.secretToPendingApps = new ConcurrentHashMap<String, AbstractAppHandle>();
            this.timeoutTimer = new Timer("LauncherServer-TimeoutTimer", true);
            this.server = server;
            this.running = true;
            this.serverThread = this.factory.newThread(this::acceptConnections);
            this.serverThread.start();
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    synchronized String registerHandle(AbstractAppHandle handle) {
        String secret = this.createSecret();
        this.secretToPendingApps.put(secret, handle);
        return secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<ServerConnection> list = this;
        synchronized (list) {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        list = LauncherServer.class;
        synchronized (LauncherServer.class) {
            serverInstance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.timeoutTimer.cancel();
            this.server.close();
            list = this.clients;
            synchronized (list) {
                ArrayList<ServerConnection> copy = new ArrayList<ServerConnection>(this.clients);
                this.clients.clear();
                for (ServerConnection client : copy) {
                    client.close();
                }
            }
            if (this.serverThread != null) {
                try {
                    this.serverThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    void ref() {
        this.refCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unref() {
        Class<LauncherServer> clazz = LauncherServer.class;
        synchronized (LauncherServer.class) {
            if (this.refCount.decrementAndGet() == 0L) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    int getPort() {
        return this.server.getLocalPort();
    }

    void unregister(AbstractAppHandle handle) {
        for (Map.Entry e : this.secretToPendingApps.entrySet()) {
            if (!((AbstractAppHandle)e.getValue()).equals(handle)) continue;
            String secret = (String)e.getKey();
            this.secretToPendingApps.remove(secret);
            break;
        }
        this.unref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptConnections() {
        block8: {
            try {
                while (this.running) {
                    final Socket client = this.server.accept();
                    TimerTask timeout = new TimerTask(){

                        @Override
                        public void run() {
                            LOG.warning("Timed out waiting for hello message from client.");
                            try {
                                client.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    ServerConnection clientConnection = new ServerConnection(client, timeout);
                    Thread clientThread = this.factory.newThread(clientConnection);
                    clientConnection.setConnectionThread(clientThread);
                    List<ServerConnection> list = this.clients;
                    synchronized (list) {
                        this.clients.add(clientConnection);
                    }
                    long timeoutMs = this.getConnectionTimeout();
                    if (timeoutMs > 0L) {
                        this.timeoutTimer.schedule(timeout, timeoutMs);
                    } else {
                        timeout.run();
                    }
                    clientThread.start();
                }
            }
            catch (IOException ioe) {
                if (!this.running) break block8;
                LOG.log(Level.SEVERE, "Error in accept loop.", ioe);
            }
        }
    }

    private long getConnectionTimeout() {
        String value = SparkLauncher.launcherConfig.get("spark.launcher.childConectionTimeout");
        return value != null ? Long.parseLong(value) : 10000L;
    }

    private String createSecret() {
        StringBuilder sb;
        String secretStr;
        do {
            byte[] secret = new byte[128];
            RND.nextBytes(secret);
            sb = new StringBuilder();
            for (int n : secret) {
                int ival;
                int n2 = ival = n >= 0 ? n : 127 - n;
                if (ival < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(ival));
            }
        } while (this.secretToPendingApps.containsKey(secretStr = sb.toString()));
        return secretStr;
    }

    class ServerConnection
    extends LauncherConnection {
        private TimerTask timeout;
        private volatile Thread connectionThread;
        private volatile AbstractAppHandle handle;

        ServerConnection(Socket socket, TimerTask timeout) throws IOException {
            super(socket);
            this.timeout = timeout;
        }

        void setConnectionThread(Thread t) {
            this.connectionThread = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(LauncherProtocol.Message msg) throws IOException {
            block12: {
                try {
                    String msgClassName;
                    if (msg instanceof LauncherProtocol.Hello) {
                        this.timeout.cancel();
                        this.timeout = null;
                        LauncherProtocol.Hello hello = (LauncherProtocol.Hello)msg;
                        AbstractAppHandle handle = (AbstractAppHandle)LauncherServer.this.secretToPendingApps.remove(hello.secret);
                        if (handle != null) {
                            handle.setConnection(this);
                            handle.setState(SparkAppHandle.State.CONNECTED);
                            this.handle = handle;
                            break block12;
                        }
                        throw new IllegalArgumentException("Received Hello for unknown client.");
                    }
                    String string = msgClassName = msg != null ? msg.getClass().getName() : "no message";
                    if (this.handle == null) {
                        throw new IllegalArgumentException("Expected hello, got: " + msgClassName);
                    }
                    if (msg instanceof LauncherProtocol.SetAppId) {
                        LauncherProtocol.SetAppId set = (LauncherProtocol.SetAppId)msg;
                        this.handle.setAppId(set.appId);
                        break block12;
                    }
                    if (msg instanceof LauncherProtocol.SetState) {
                        this.handle.setState(((LauncherProtocol.SetState)msg).state);
                        break block12;
                    }
                    throw new IllegalArgumentException("Invalid message: " + msgClassName);
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Error handling message from client.", e);
                    if (this.timeout != null) {
                        this.timeout.cancel();
                    }
                    this.close();
                    if (this.handle != null) {
                        this.handle.dispose();
                    }
                }
                finally {
                    LauncherServer.this.timeoutTimer.purge();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.isOpen()) {
                return;
            }
            List list = LauncherServer.this.clients;
            synchronized (list) {
                LauncherServer.this.clients.remove(this);
            }
            super.close();
        }

        public void waitForClose() throws IOException {
            Thread connThread = this.connectionThread;
            if (Thread.currentThread() != connThread) {
                try {
                    connThread.join(LauncherServer.this.getConnectionTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (connThread.isAlive()) {
                    LOG.log(Level.WARNING, "Timed out waiting for child connection to close.");
                    this.close();
                }
            }
        }
    }
}

