/*
 * pcpj.c --- position searching package.
 *
 * Copyright (c) 1997-2002 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-12-10 15:18:43 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#define		EXTERN_PCPJ	/* Uniquement defini ici */
#include	"pcpj.h"

#include	"dis_type.h"
#include	"pcpjcapt.h"
#include	"screen.h"
#include	"distimmo.h"
#include	"distance.h"
#include	"pcpj_deb.h"

#include	<string.h>	/* For memcpy(...), memset(...) */

static	distance_t		Primary_Distance_Table[6 * SIZE_PIECE];

/*--------------------------------------------------------------------------*/

void
majEchiquier(void)
{
    piece_index_t	i;

    memset(Echiquier, 0, sizeof(Echiquier));
    for (i=INDEX_ROI_BLANC; i<=INDEX_PION_NOIR_H; i++)
    {
	if (Position_Pieces[i] != CASE_D_UNE_PIECE_CAPTUREE)
	{
	    Echiquier[Position_Pieces[i]] = i;
	}
    }
}

void
initAssociation(int nbCoups)
{
    int		compteur;
    int		i;

    NbDemiCoups   = nbCoups;
    NbCoupsNoirs  = nbCoups >> 1;
    NbCoupsBlancs = nbCoups - NbCoupsNoirs;

    Position_Pieces_Blanches_Final = &Position_Pieces_Final[INDEX_ROI_BLANC];
    Position_Pieces_Noires_Final   = &Position_Pieces_Final[INDEX_ROI_NOIR];
    Type_Pieces_Blanches_Final     = &Type_Pieces_Final[INDEX_ROI_BLANC];
    Type_Pieces_Noires_Final       = &Type_Pieces_Final[INDEX_ROI_NOIR];

    /* Copie Echiquier dans EchiquierFinal et met dans Echiquier
     * la position initiale.
     */
    memcpy(EchiquierFinal,        Echiquier,       sizeof(Echiquier));
    memcpy(Position_Pieces_Final, Position_Pieces, sizeof(Position_Pieces));
    memcpy(Type_Pieces_Final,     Type_Pieces,     sizeof(Type_Pieces));

    for (i=0; i<32; i++)
    {
	Position_Pieces[INDEX_ROI_BLANC + i] = ListeNonTraitees[i].caseInitiale;
	Type_Pieces[INDEX_ROI_BLANC + i]     = ListeNonTraitees[i].typePiece;
    }
    majEchiquier();

    /* Initialisation de CasesInterdites */
    memset(CasesInterdites, TRUE, sizeof(CasesInterdites));
    for (i=0; i<8; i++)
    {
	memset(CasesInterdites + i * 16, FALSE, 8);
    }

    /* Compte le nombre de pieces blanches et noires manquantes
     * au diagramme.
     */
    compteur = 0;
    for (i=0; i<16; i++)
    {
	if (Position_Pieces_Blanches_Final[i] != CASE_D_UNE_PIECE_CAPTUREE)
	{
	    compteur++;
	}
    }
    NbTotalCaptureesBlanches = 16 - compteur;

    compteur = 0;
    for (i=0; i<16; i++)
    {
	if (Position_Pieces_Noires_Final[i] != CASE_D_UNE_PIECE_CAPTUREE)
	{
	    compteur++;
	}
    }
    NbTotalCaptureesNoires = 16 - compteur;

    NbResteACapturerBlanches = NbTotalCaptureesBlanches;
    NbResteACapturerNoires   = NbTotalCaptureesNoires;

    NbImmobiles = NbSures = NbRestantes = 0;

    /* Initialisation de TabIndexPiece. */
    for (i=0; i<32; i++)
    {
	TabIndexPiece[INDEX_ROI_BLANC + i] = &ListeNonTraitees[i];
    }
}

static void
creeAssociationRecursive(int indice)
{
    int			i;
    distance_t		dist, distPion, distPiecePromue;
    row_t		rangeePromotion;
    piece_t*		p = ListeNonTraitees;
    column_t		depX, arrX;
    square_delta_t	deltaX;
    square_t		caseArrivee;
    piece_index_t	pieces_ayant_du_bouger[16];
    int			nombre_pieces_ayant_du_bouger;

    if (indice == NbRestantes)
    {
	captureParPion(0);
	return;
    }

    while (indice < NbRestantes &&
	   ListeRestantes[indice].nbDestination > 0 )
    {
	indice++;
    }

    if (indice == NbRestantes)
    {
	captureParPion(0);
	return;
    }

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag && keyboardHit() )
    {
	(void)screenKeyboard( FALSE, NULL, 0, 0 );
    }
#endif /* HAVE_LIBNCURSES */

    for (i=0; i<NbNonTraites; i++, p++)
    {
	if ( p->caseInitiale != PIECE_DEJA_TRAITEE &&
	     p->camp == ListeRestantes[ indice ].camp )
	{
	    if (p->typePiece == ListeRestantes[indice].typePiece &&
		p->caseInitiale != ListeRestantes[indice].caseArrivee)
	    {
		dist = distance_avec_obstacle(
		    p->typePiece,
		    p->camp,
		    p->caseInitiale,
		    ListeRestantes[indice].caseArrivee,
		    TRUE,
		    pieces_ayant_du_bouger,
		    &nombre_pieces_ayant_du_bouger );
		if (dist == INFINI)
		{
		    continue;
		}

		/* Si c'est un pion qui change de colonne, verifie qu'il
		 * reste assez de pieces a prendre.
		 */
		if (p->typePiece == PION)
		{
		    depX = column(p->caseInitiale);
		    arrX = column(ListeRestantes[indice].caseArrivee);
		    deltaX = (arrX > depX) ? (arrX - depX) : (depX - arrX);

		    if ((p->camp == BLANC &&
			 deltaX > NbResteACapturerNoires) ||
			(p->camp == NOIR &&
			 deltaX > NbResteACapturerBlanches) )
		    {
			distance_reimmobilise_pieces(
			    pieces_ayant_du_bouger,
			    nombre_pieces_ayant_du_bouger);
			continue;
		    }
		}
		else
		{
		    deltaX = 0;
		}

		if (p->camp == BLANC)
		{
		    NbCoupsBlancsRestants  -= dist;
		    NbResteACapturerNoires -= deltaX;
		}
		else
		{
		    NbCoupsNoirsRestants     -= dist;
		    NbResteACapturerBlanches -= deltaX;
		}

		caseArrivee = ListeRestantes[indice].caseArrivee;
		ListeRestantes[indice] = *p;
		ListeRestantes[indice].caseArrivee      = caseArrivee;
		ListeRestantes[indice].nbDestination    = 1;
		ListeRestantes[indice].destination[0]   = caseArrivee;
		ListeRestantes[indice].pieceCapturee[0] = PAS_DE_CAPTURE;
		ListeRestantes[indice].distance[0]      = dist;

		if ( p->typePiece == PION )
		    ListeRestantes[ indice ].nb_captures = deltaX;
		TabIndexPiece[p->index] = &ListeRestantes[indice];
		p->caseInitiale = PIECE_DEJA_TRAITEE;

		creeAssociationRecursive(indice + 1);

		p->caseInitiale = ListeRestantes[indice].caseInitiale;
		ListeRestantes[indice].nbDestination = 0;
		TabIndexPiece[p->index] = p;

		if (p->camp == BLANC)
		{
		    NbCoupsBlancsRestants  += dist;
		    NbResteACapturerNoires += deltaX;
		}
		else
		{
		    NbCoupsNoirsRestants     += dist;
		    NbResteACapturerBlanches += deltaX;
		}

		distance_reimmobilise_pieces(
		    pieces_ayant_du_bouger,
		    nombre_pieces_ayant_du_bouger);
	    }
	    else if (p->typePiece == PION)
	    {
		int	j;

		if (p->camp == BLANC)	rangeePromotion = 0x70;
		else			rangeePromotion = 0x00;

		for (j=0; j<8; j++)
		{
		    if (CasesInterdites[rangeePromotion + j])	continue;

		    distPion = distancePion(p->camp,
					    p->caseInitiale,
					    rangeePromotion + j);

		    if ( ( p->camp == BLANC
			   && distPion > NbCoupsBlancsRestants )
			 || ( p->camp == NOIR
			      && distPion > NbCoupsNoirsRestants ) )
		    {
			continue;
		    }

		    /* Si le pion change de colonne, verifie qu'il
		     * reste assez de piece a prendre.
		     */
		    depX   = column(p->caseInitiale);
		    arrX   = j;
		    deltaX = (arrX > depX) ? (arrX - depX) : (depX - arrX);

		    if ((p->camp == BLANC && deltaX > NbResteACapturerNoires) ||
			(p->camp == NOIR  && deltaX > NbResteACapturerBlanches))
		    {
			continue;
		    }

		    distPiecePromue =
			distance_avec_obstacle(
			    ListeRestantes[indice].typePiece,
			    ListeRestantes[indice].camp,
			    rangeePromotion + j,
			    ListeRestantes[indice].caseArrivee,
			    TRUE,
			    pieces_ayant_du_bouger,
			    &nombre_pieces_ayant_du_bouger);

		    if (distPiecePromue == INFINI)
		    {
			continue;
		    }
		    dist = distPion + distPiecePromue;

		    if ((p->camp == BLANC && dist > NbCoupsBlancsRestants) ||
			(p->camp == NOIR  && dist > NbCoupsNoirsRestants) )
		    {
			distance_reimmobilise_pieces(
			    pieces_ayant_du_bouger,
			    nombre_pieces_ayant_du_bouger);
			continue;
		    }

		    if (p->camp == BLANC)
		    {
			NbCoupsBlancsRestants  -= dist;
			NbResteACapturerNoires -= deltaX;
		    }
		    else
		    {
			NbCoupsNoirsRestants     -= dist;
			NbResteACapturerBlanches -= deltaX;
		    }
		    ListeRestantes[indice].index            = p->index;
		    ListeRestantes[indice].castling         = NO_CASTLING ;
		    ListeRestantes[indice].caseInitiale     = p->caseInitiale;
		    ListeRestantes[indice].casePromotion  = rangeePromotion + j;
		    ListeRestantes[indice].typePromotion    =
			ListeRestantes[indice].typePiece;
		    ListeRestantes[indice].typePiece        = PION;
		    ListeRestantes[indice].nb_captures      = deltaX;

		    ListeRestantes[indice].nbDestination    = 1;
		    ListeRestantes[indice].destination[0] = rangeePromotion + j;
		    ListeRestantes[indice].pieceCapturee[0] = PAS_DE_CAPTURE;
		    ListeRestantes[indice].distance[0]      = distPion;
		    if (distPiecePromue != 0)
		    {
			ListeRestantes[indice].nbDestination++;
			ListeRestantes[indice].destination[ 1 ] =
			    ListeRestantes[indice].caseArrivee;
			ListeRestantes[indice].pieceCapturee[ 1 ] =
			    PAS_DE_CAPTURE;
			ListeRestantes[indice].distance[ 1 ] = distPiecePromue;
		    }

		    TabIndexPiece[p->index] = &ListeRestantes[indice];
		    p->caseInitiale = PIECE_DEJA_TRAITEE;

		    if (distPiecePromue == 0)
		    {
			distance_libere_case(rangeePromotion + j,
					     creeAssociationRecursive,
					     indice + 1);
		    }
		    else
		    {
			/* Case de promotion deja evacuee si necessaire */
			creeAssociationRecursive(indice + 1);
		    }

		    p->caseInitiale = ListeRestantes[indice].caseInitiale;
		    TabIndexPiece[p->index] = p;
		    ListeRestantes[indice].typePiece =
			ListeRestantes[indice].typePromotion;
		    ListeRestantes[indice].casePromotion
			= CASE_PAS_DE_PROMOTION;
		    ListeRestantes[indice].nbDestination = 0;

		    if (p->camp == BLANC)
		    {
			NbCoupsBlancsRestants  += dist;
			NbResteACapturerNoires += deltaX;
		    }
		    else
		    {
			NbCoupsNoirsRestants     += dist;
			NbResteACapturerBlanches += deltaX;
		    }
		    distance_reimmobilise_pieces(
			pieces_ayant_du_bouger,
			nombre_pieces_ayant_du_bouger);
		} /* Boucle sur les cases de promotion */
	    } /* SI bon type SINON SI pion qui se promeut */
	} /* SI la piece est du bon camp et n'est pas encore `occupee'. */
    } /* Boucle sur les pieces non traitees. */
}

static void
trajetRoque(int indice)
{
    static square_t	case_de_base;

    if (indice == INFINI)
    {
	if ( TabIndexPiece[ INDEX_ROI_BLANC ]->castling == KING_SIDE )
	{
	    case_de_base = e1;
	    indice = 3;
	}
	else if ( TabIndexPiece[ INDEX_ROI_BLANC ]->castling == QUEEN_SIDE )
	{
	    case_de_base = a1;
	    indice = 4;
	}
	else if ( TabIndexPiece[ INDEX_ROI_NOIR ]->castling == KING_SIDE )
	{
	    case_de_base = e8;
	    indice = 3;
	}
	else if ( TabIndexPiece[ INDEX_ROI_NOIR ]->castling == QUEEN_SIDE )
	{
	    case_de_base = a8;
	    indice = 4;
	}
	else
	{
	    case_de_base = h8;	/* Tout sauf a1 et e1 */
	    indice = 1;
	}
    }

    indice--;
    if (indice == 0)
    {
	if ( TabIndexPiece[ INDEX_ROI_NOIR ]->castling != NO_CASTLING &&
	    case_de_base < h1)
	{
	    if ( TabIndexPiece[ INDEX_ROI_NOIR ]->castling == QUEEN_SIDE )
	    {
		case_de_base = a8;
		indice = 4;
	    }
	    else
	    {
		case_de_base = e8;
		indice = 3;
	    }
	    trajetRoque(indice);
	}
	else
	{
	    indice = 0;
	    while (indice < NbRestantes &&
		   ListeRestantes[indice].typePiece == PION )
	    {
		indice++;
	    }
	    creeAssociationRecursive(indice);
	}
    }
    else
    {
	distance_libere_case(case_de_base + indice,
			     trajetRoque,
			     indice);
    }
}

static void
cree_association_piece_potentiellement_immobile(int indice)
{
    while (indice < NbRestantes)
    {
	int		i;
	piece_t*	p = ListeNonTraitees;
	for (i=0; i<NbNonTraites; i++, p++)
	{
	    if (p->caseInitiale != PIECE_DEJA_TRAITEE		      &&
		p->camp == ListeRestantes[indice].camp		      &&
		p->typePiece == ListeRestantes[indice].typePiece      &&
		p->caseInitiale == ListeRestantes[indice].caseArrivee )
	    {
		square_t caseArrivee = ListeRestantes[ indice ].caseArrivee;
		ListeRestantes[indice] = *p;
		ListeRestantes[indice].caseArrivee      = caseArrivee;
		ListeRestantes[indice].nbDestination    = 1;
		ListeRestantes[indice].destination[0]   = caseArrivee;
		ListeRestantes[indice].pieceCapturee[0] = PAS_DE_CAPTURE;
		ListeRestantes[indice].distance[0]      = 0;

		TabIndexPiece[p->index] = &ListeRestantes[indice];
		p->caseInitiale = PIECE_DEJA_TRAITEE;

		if (! (p->typePiece == TOUR && p->castling != NO_CASTLING ) )
		{
		    distance_ajouter_tableau_pour_case(caseArrivee);
		}

		cree_association_piece_potentiellement_immobile(indice + 1);

		if (! (p->typePiece == TOUR && p->castling != NO_CASTLING ) )
		{
	distance_supprimer_dernier_tableau_pour_case_potentiellement_bloquee();
		}

		p->caseInitiale = ListeRestantes[indice].caseInitiale;
		TabIndexPiece[p->index] = p;
		ListeRestantes[indice].nbDestination = 0;

		break;
	    }
	}
	indice++;
    }

    trajetRoque(INFINI);
}

static void
initialisation_piece_potentiellement_immobile(int indice)
{
    int		index = indice;
    piece_t*	roi ;

    distance_raz_tableaux_si_immobile();

    while (index < NbRestantes)
    {
	int		i;
	piece_t*	p = ListeNonTraitees;
	for (i=0; i<NbNonTraites; i++, p++)
	{
	    if (p->caseInitiale != PIECE_DEJA_TRAITEE			 &&
		p->camp == ListeRestantes[index].camp			 &&
		p->typePiece == ListeRestantes[index].typePiece		 &&
		p->caseInitiale == ListeRestantes[index].caseArrivee	 &&
		(! (p->typePiece == TOUR && p->castling != NO_CASTLING ) ) )
	    {
		distance_cree_tableau_si_immobile(p->caseInitiale, p->index);
		break;
	    }
	}
	index++;
    }

    roi = TabIndexPiece[ INDEX_ROI_BLANC ];
    if ( roi->castling == NO_CASTLING && roi->distance[ 0 ] == 0 )
    {
	distance_cree_tableau_si_immobile( roi->caseInitiale, roi->index );
	distance_ajouter_tableau_pour_case( roi->caseInitiale );
    }

    roi = TabIndexPiece[ INDEX_ROI_NOIR ];
    if ( roi->castling == NO_CASTLING && roi->distance[ 0 ] == 0 )
    {
	distance_cree_tableau_si_immobile( roi->caseInitiale, roi->index );
	distance_ajouter_tableau_pour_case( roi->caseInitiale );
    }

    cree_association_piece_potentiellement_immobile(indice);
}

static void
roque(int indice)
{
#ifdef __DJGPP__
    int		white_castling ;
    int		black_castling ;
#else
    castling_t	white_castling ;
    castling_t	black_castling ;
#endif
    piece_t*	pBlanc;
    piece_t*	pNoir;
    distance_t	distBlanc, distNoir;

    /* Traite tous les cas de roque possible. */
    pBlanc = TabIndexPiece[INDEX_ROI_BLANC];
    pNoir  = TabIndexPiece[INDEX_ROI_NOIR];
    for ( white_castling = NO_CASTLING;
	  white_castling <= QUEEN_SIDE;
	  white_castling++ )
    {
	square_t	white_init_square = e1 ;

	if ( NbCoupsBlancsRestants == 0 && white_castling != NO_CASTLING )
	    continue;

	if ( white_castling == KING_SIDE )
	{
	    /* Si le Ff1 n'a jamais pu jouer. */
	    if (CasesInterdites[f1])	continue;

	    NbCoupsBlancsRestants--;
	    white_init_square = g1 ;

	    TabIndexPiece[ INDEX_TOUR_ROI_BLANC ]->castling     = KING_SIDE ;
	    TabIndexPiece[ INDEX_TOUR_ROI_BLANC ]->caseInitiale = f1 ;
	}
	else if ( white_castling == QUEEN_SIDE )
	{
	    /* Si le Fc1 n'a jamais pu jouer. */
	    if (CasesInterdites[c1])	continue;

	    NbCoupsBlancsRestants--;
	    white_init_square = c1 ;

	    TabIndexPiece[ INDEX_TOUR_DAME_BLANC ]->castling     = QUEEN_SIDE ;
	    TabIndexPiece[ INDEX_TOUR_DAME_BLANC ]->caseInitiale = d1 ;
	}
	/* This must be done after the possible `continue' statements above.
	 * The problem is that false twin_squares may otherwise be created.
	 */
	pBlanc->castling = white_castling ;

	distBlanc = distance( ROI,
			      BLANC,
			      white_init_square ,
			      pBlanc->caseArrivee );

	if (distBlanc <= NbCoupsBlancsRestants)
	{
	    if ( white_castling != NO_CASTLING )
	    {
		pBlanc->pieceCapturee[ 0 ] = PAS_DE_CAPTURE ;
		pBlanc->destination  [ 0 ] = white_init_square ;
		pBlanc->distance     [ 0 ] = 1 ;

		if ( distBlanc != 0 )
		{
		    pBlanc->pieceCapturee[ 1 ] = PAS_DE_CAPTURE ;
		    pBlanc->destination  [ 1 ] = pBlanc->caseArrivee ;
		    pBlanc->nbDestination++;
		}
	    }

	    NbCoupsBlancsRestants -= distBlanc;
	    if ( white_castling == NO_CASTLING || distBlanc != 0 )
	    {
		pBlanc->distance[ pBlanc->nbDestination - 1 ] = distBlanc ;
	    }

	    for ( black_castling = NO_CASTLING;
		  black_castling <= QUEEN_SIDE;
		  black_castling++ )
	    {
		square_t	black_init_square = e8 ;

		if ( NbCoupsNoirsRestants == 0 && black_castling != NO_CASTLING)
		    continue;

		if ( black_castling == KING_SIDE )
		{
		    /* Si le Ff8 n'a jamais pu jouer. */
		    if (CasesInterdites[f8])	continue;

		    NbCoupsNoirsRestants--;
		    black_init_square = g8 ;

		    TabIndexPiece[ INDEX_TOUR_ROI_NOIR ]->castling     =
			KING_SIDE ;
		    TabIndexPiece[ INDEX_TOUR_ROI_NOIR ]->caseInitiale = f8 ;
		}
		else if ( black_castling == QUEEN_SIDE )
		{
		    /* Si le Fc8 n'a jamais pu jouer. */
		    if (CasesInterdites[c8])	continue;

		    NbCoupsNoirsRestants--;
		    black_init_square = c8 ;

		    TabIndexPiece[ INDEX_TOUR_DAME_NOIR ]->castling     =
			QUEEN_SIDE ;
		    TabIndexPiece[ INDEX_TOUR_DAME_NOIR ]->caseInitiale = d8 ;
		}
		/* This must be done after the possible `continue' statements
		 * above.  The problem is that false twin_squares may otherwise
		 * be created.
		 */
		pNoir->castling = black_castling ;

		distNoir = distance( ROI,
				     NOIR,
				     black_init_square ,
				     pNoir->caseArrivee );

		if (distNoir <= NbCoupsNoirsRestants)
		{
		    if ( black_castling != NO_CASTLING )
		    {
			pNoir->pieceCapturee[ 0 ] = PAS_DE_CAPTURE ;
			pNoir->destination  [ 0 ] = black_init_square ;
			pNoir->distance     [ 0 ] = 1 ;

			if ( distNoir != 0 )
			{
			    pNoir->pieceCapturee[ 1 ] = PAS_DE_CAPTURE ;
			    pNoir->destination  [ 1 ] = pNoir->caseArrivee ;
			    pNoir->nbDestination++;
			}
		    }

		    NbCoupsNoirsRestants -= distNoir;
		    if ( black_castling == NO_CASTLING || distNoir != 0 )
		    {
			pNoir->distance[ pNoir->nbDestination - 1 ] = distNoir ;
		    }

		    initialisation_piece_potentiellement_immobile(indice);

		    if ( black_castling != NO_CASTLING )
		    {
			pNoir->pieceCapturee[ 0 ] = PAS_DE_CAPTURE ;
			pNoir->destination  [ 0 ] = pNoir ->caseArrivee ;
			pNoir->distance     [ 0 ] = 0 ;

			if ( distNoir != 0 )
			{
			    pNoir->nbDestination--;
			}
		    }

		    NbCoupsNoirsRestants += distNoir;
		}

		if ( black_castling == KING_SIDE )
		{
		    NbCoupsNoirsRestants++;
		    pNoir->castling     = NO_CASTLING ;
		    pNoir->caseInitiale = e8 ;

		    TabIndexPiece[ INDEX_TOUR_ROI_NOIR ]->castling     =
			NO_CASTLING ;
		    TabIndexPiece[ INDEX_TOUR_ROI_NOIR ]->caseInitiale = h8 ;
		}
		else if ( black_castling == QUEEN_SIDE )
		{
		    NbCoupsNoirsRestants++;
		    pNoir->castling     = NO_CASTLING ;
		    pNoir->caseInitiale = e8 ;

		    TabIndexPiece[ INDEX_TOUR_DAME_NOIR ]->castling     =
			NO_CASTLING ;
		    TabIndexPiece[ INDEX_TOUR_DAME_NOIR ]->caseInitiale = a8 ;
		}
	    }

	    if ( white_castling != NO_CASTLING )
	    {
		pBlanc->pieceCapturee[ 0 ] = PAS_DE_CAPTURE ;
		pBlanc->destination  [ 0 ] = pBlanc ->caseArrivee ;
		pBlanc->distance     [ 0 ] = 0 ;

		if ( distBlanc != 0 )
		{
		    pBlanc->nbDestination--;
		}
	    }

	    NbCoupsBlancsRestants += distBlanc;
	}

	if ( white_castling == KING_SIDE )
	{
	    NbCoupsBlancsRestants++;
	    pBlanc->castling     = NO_CASTLING ;
	    pBlanc->caseInitiale = e1 ;

	    TabIndexPiece[ INDEX_TOUR_ROI_BLANC ]->castling     = NO_CASTLING ;
	    TabIndexPiece[ INDEX_TOUR_ROI_BLANC ]->caseInitiale = h1 ;
	}
	else if ( white_castling == QUEEN_SIDE )
	{
	    NbCoupsBlancsRestants++;
	    pBlanc->castling     = NO_CASTLING ;
	    pBlanc->caseInitiale = e1 ;

	    TabIndexPiece[ INDEX_TOUR_DAME_BLANC ]->castling     = NO_CASTLING ;
	    TabIndexPiece[ INDEX_TOUR_DAME_BLANC ]->caseInitiale = a1 ;
	}
    }
}

static void
creeAssociationRecursivePion(int indice)
{
    int			i;
    distance_t		dist;
    piece_t*		p = ListeNonTraitees;
    column_t		depX, arrX;
    square_delta_t	deltaX;
    square_t		caseArrivee;

    if (ListeRestantes[indice].typePiece != PION)
    {
	distCreeTabPiece(Primary_Distance_Table);
	roque(indice);
	return;
    }

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag && keyboardHit() )
    {
	(void)screenKeyboard( FALSE, NULL, 0, 0 );
    }
#endif /* HAVE_LIBNCURSES */

    for (i=0; i<NbNonTraites; i++, p++)
    {
	if (p->caseInitiale != PIECE_DEJA_TRAITEE && p->typePiece == PION &&
	    p->camp == ListeRestantes[indice].camp)
	{
	    dist = distance(PION, p->camp, p->caseInitiale,
			    ListeRestantes[indice].caseArrivee);

	    if ((p->camp == BLANC && dist > NbCoupsBlancsRestants) ||
		(p->camp == NOIR && dist > NbCoupsNoirsRestants) )
	    {
		continue;
	    }

	    /* Si le pion change de colonne, verifie qu'il
	     * reste assez de pieces a prendre.
	     */
	    depX = column(p->caseInitiale);
	    arrX = column(ListeRestantes[indice].caseArrivee);
	    deltaX = (arrX > depX) ? (arrX - depX) : (depX - arrX);

	    if ((p->camp == BLANC && deltaX > NbResteACapturerNoires) ||
		(p->camp == NOIR && deltaX > NbResteACapturerBlanches) )
	    {
		continue;
	    }

	    if (p->camp == BLANC)
	    {
		NbCoupsBlancsRestants -= dist;
		NbResteACapturerNoires -= deltaX;
	    }
	    else
	    {
		NbCoupsNoirsRestants -= dist;
		NbResteACapturerBlanches -= deltaX;
	    }

	    caseArrivee = ListeRestantes[indice].caseArrivee;
	    ListeRestantes[indice] = *p;
	    ListeRestantes[indice].caseArrivee      = caseArrivee;
	    ListeRestantes[indice].nbDestination    = 1;
	    ListeRestantes[indice].destination[0]   = caseArrivee;
	    ListeRestantes[indice].pieceCapturee[0] = PAS_DE_CAPTURE;
	    ListeRestantes[indice].distance[0]      = dist;

	    ListeRestantes[indice].nb_captures = deltaX;
	    TabIndexPiece[p->index] = &ListeRestantes[indice];
	    p->caseInitiale = PIECE_DEJA_TRAITEE;

	    creeAssociationRecursivePion(indice + 1);

	    p->caseInitiale = ListeRestantes[indice].caseInitiale;
	    TabIndexPiece[p->index] = p;

	    if (p->camp == BLANC)
	    {
		NbCoupsBlancsRestants  += dist;
		NbResteACapturerNoires += deltaX;
	    }
	    else
	    {
		NbCoupsNoirsRestants     += dist;
		NbResteACapturerBlanches += deltaX;
	    }
	} /* SI la piece est du bon camp et n'est pas encore `occupee'. */
    } /* Boucle sur les pieces non traitees. */
}

static bool_t
initialisation_association_restante()
{
    int			i, j;
    square_t		square;
    bool_t		dejaVu;
    distance_t		totalBlanc, totalNoir;
    piece_t*		p;
    piece_t		piece;
    distance_t		dist;

    /* Mise a jour de la table TabIndexPiece. */
    p = ListeImmobiles;
    for (i=0; i<NbImmobiles; i++, p++)
    {
	TabIndexPiece[p->index] = p;
    }
    p = ListeSures;
    for (i=0; i<NbSures; i++, p++)
    {
	TabIndexPiece[p->index] = p;
    }

    /* Calcule le nombre minimum de coups pour les pieces "sures"
     * a l'exception des 2 rois (a cause des roques).
     */
    /* Uniquement pour les PIONs car ca n'a pas ete fait dans
     * creeAssociationPions.
     */
    p = &ListeSures[2];
    totalBlanc = totalNoir = 0;
    for (i=2; i<NbSures; i++, p++)
    {
	if ( p->typePiece == PION )
	{
	    dist = distance( p->typePiece,
			     p->camp,
			     p->caseInitiale,
			     p->caseArrivee );
	    p->distance[ 0 ] = dist;
	    if (p->camp == BLANC)	totalBlanc += dist;
	    else			totalNoir  += dist;
	}
    }
    if (NbCoupsBlancs < totalBlanc || NbCoupsNoirs < totalNoir)
    {
	return FALSE ;
    }
    NbCoupsBlancsRestants = NbCoupsBlancs - totalBlanc;
    NbCoupsNoirsRestants  = NbCoupsNoirs - totalNoir;

    /* Pour toutes les pieces du diagramme non encore traitees,
     * cree une entree dans la table ListeRestantes.
     */
    ListeRestantes = &ListeSures[NbSures];
    for (square=a1; square<=h8; square++)
    {
	if (! CASE_OK(square))	continue;

	if (EchiquierFinal[square] != 0)
	{
	    dejaVu = FALSE;
	    for (j=0; j<NbImmobiles; j++)
	    {
		if (ListeImmobiles[j].caseArrivee == square)
		{
		    dejaVu = TRUE;
		    break;
		}
	    }

	    if (! dejaVu)
	    {
		for (j=0; j<NbSures; j++)
		{
		    /* Cas d'une piece sur la case initiale d'un Fou
		     * n'ayant jamais joue.
		     */
		    if ( ListeSures[j].caseArrivee == square
			 && ListeSures[j].pieceCapturante
			 != PIECE_CAPTURANTE_INCONNUE)
		    {
			dejaVu = TRUE;
			break;
		    }
		}
	    }

	    if (! dejaVu)
	    {
		for (j=0; j<NbRestantes; j++)
		{
		    if (ListeRestantes[j].caseArrivee == square)
		    {
			dejaVu = TRUE;
			break;
		    }
		}
	    }
	    if (!dejaVu)
	    {
		ListeRestantes[NbRestantes].typePiece =
		    Type_Pieces_Final[EchiquierFinal[square]];
		ListeRestantes[NbRestantes].camp
		    = colour(EchiquierFinal[square]);
		ListeRestantes[NbRestantes].caseInitiale    = square;
		ListeRestantes[NbRestantes].caseArrivee     = square;
		ListeRestantes[NbRestantes].destination[0]  = square;
		ListeRestantes[NbRestantes].pieceCapturante
		    = PIECE_PAS_CAPTUREE;
		ListeRestantes[NbRestantes].casePromotion
		    = CASE_PAS_DE_PROMOTION;
		ListeRestantes[NbRestantes].typePromotion   =
		    ListeRestantes[NbRestantes].typePiece;
		ListeRestantes[NbRestantes].index           = 0 ;
		ListeRestantes[NbRestantes].castling        = NO_CASTLING ;
		ListeRestantes[NbRestantes].nb_captures     = 0 ;
		ListeRestantes[NbRestantes].nbDestination   = 0 ;
		NbRestantes++;
	    }
	}
    }

    /* Met les pions en tetes dans la `ListeRestantes'. */
    i = 0;
    while (i < NbRestantes && ListeRestantes[i].typePiece == PION)	i++;
    for (j=i+1; j<NbRestantes; j++)
    {
	if (ListeRestantes[j].typePiece == PION)
	{
	    piece = ListeRestantes[i];
	    ListeRestantes[i] = ListeRestantes[j];
	    ListeRestantes[j] = piece;
	    i++;
	}
    }

    /* Bouche les trous de la ListeNonTraitees */
    i = 0;
    while (ListeNonTraitees[i].caseInitiale != PIECE_DEJA_TRAITEE)	i++;
    for (j=i+1; j<32; j++)
    {
	if (ListeNonTraitees[j].caseInitiale != PIECE_DEJA_TRAITEE)
	{
	    ListeNonTraitees[i] = ListeNonTraitees[j];
	    ListeNonTraitees[j].caseInitiale = PIECE_DEJA_TRAITEE;
	    TabIndexPiece[ListeNonTraitees[i].index] = &ListeNonTraitees[i];
	    i++;
	}
    }
    NbNonTraites = i;

    return TRUE ;
}

void
creeAssociation(int number_of_half_moves)
{
    creeAssociationPieceImmobile();

    /* Avant distCreeTab... parce que un pion qui joue juste a2-a3
     * empeche par exemple une tour de jouer Ta1-a3.
     */
    creeAssociationPions();

    distance_push(Primary_Distance_Table);
    distCreeTabPionRoiCavalier(Primary_Distance_Table);

#ifdef HAVE_LIBNCURSES
    if ( MainVisualFlag )
    {
	screenInit( EchiquierFinal,
		    Type_Pieces_Final,
		    number_of_half_moves,
		    ListeImmobiles,
		    NbImmobiles );
    }
#endif /* HAVE_LIBNCURSES */

    if (! initialisation_association_restante() )
    {
	return ;
    }
    creeAssociationRecursivePion(0);

}
