//====================================================
// Grande
// Copyright (C) 2002-2003, kacchan
// E-M@il address   ml@kxl.hn.org
// Homepage address http://kxl.hn.org
//====================================================
#include "grande.h"
#include "extern.h"

//========================================
// ƥ
//========================================
void CreateItem(Uint16 x, Uint16 y)
{
  Cchr.Attr     = AttrItem | AttrShadow;
  Cchr.Target   = AttrMy;
  Cchr.Spr      = PixItem;
  Cchr.FrameNo  = RM(2) ? 5 : RM(5);
  Cchr.Score    = 100;
  Cchr.X        = x;
  Cchr.Y        = y;
  GetDirectionAdd(0, &(Cchr.AddX), &(Cchr.AddY), 2);
  CopyYourNew(MoveStandardNoFrame, HitDelete, DrawImageFrame);
}
//========================================
// ȯ˥᡼
// (˥᡼λ
//========================================
RcHitEnum MoveBomb(CharacterData *my)
{
  my->Y ++;
  return (++ my->FrameNo != my->FrameMax) ? RcHitNone : RcHitDel;
}
//========================================
// Һ
//========================================
void CreateCrash(Uint16 x, Uint16 y, Uint16 d)
{
  Cchr.Attr     = AttrNone;
  Cchr.Target   = AttrNone;
  Cchr.Spr      = RM(2) ? PixCrash1 : PixCrash2;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.X        = x;
  Cchr.Y        = y;
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = d;
  Cchr.Cnt3     = 6;
  CopyYourNew(MoveCrash, HitDelete, DrawImageFrame);
}
//========================================
// Ұư
//========================================
RcHitEnum MoveCrash(CharacterData *my)
{
  if (++ my->FrameNo == my->FrameMax)
    my->FrameNo = 0;
  my->Cnt1 ++;
  if (my->Cnt1 > 10) {
    my->Cnt3 = 4;
    if (my->Cnt1 > 14)
      my->Cnt3 = 2;
    if (my->Cnt1 > 20)
      return RcHitDel;
    if (my->Cnt1 & 1)
      my->FrameNo = 3;
  }
  GetDirectionAdd(my->Cnt2, &(my->AddX), &(my->AddY), my->Cnt3);
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}
//========================================
// Ũȯ
// (HP̵ʤäȯ&ѥи)
//========================================
RcHitEnum HitEnemyToBomb(CharacterData *my, CharacterData *your)
{
  Uint16 i;

  // ѵϸ
  my->Hp -= your->Power;
  if (my->Hp <= 0) { // ѵϤ̵ʤä
    // ȯ
    KXL_PlaySound(SE_BOMB, KXL_SOUND_PLAY);
    Cchr.Attr     = AttrNone;
    Cchr.Target   = AttrNone;
    Cchr.Spr      = PixBomb1;
    Cchr.FrameNo  = 0;
    Cchr.FrameMax = Cchr.Spr->max;
    Cchr.X        = ((my->X + my->Spr->data[0].img->Width / 2)
                     - (Cchr.Spr->data[0].img->Width / 2));
    Cchr.Y        = ((my->Y + my->Spr->data[0].img->Height / 2)
                     - (Cchr.Spr->data[0].img->Height / 2));
    CopyYourNew(MoveBomb, HitNone, DrawImageFrame);
    // 
    for (i = 0; i < 5; i ++)
      CreateCrash(my->X + my->Spr->data[0].img->Width / 2,
		  my->Y + my->Spr->data[0].img->Height / 2,
		  RM(360));
    // ƥ
    if (RM(5) == 0)
      CreateItem(Cchr.X, Cchr.Y);
    if (my->Spr == PixBossSub)
      Root->Your[BOSS_NO].Chr.Attr |= AttrEnemy;
    if (your->Spr == PixMyCShot) {
      CreateChargeBomb(my->X,
		       my->Y + my->Spr->data[0].img->Height / 2);
      CreateChargeBomb(my->X + my->Spr->data[0].img->Width - 1,
		       my->Y + my->Spr->data[0].img->Height / 2);
    }
    return RcHitBomb;
  }
  return RcHitNone;
}
//========================================
// Ũȯ
// (HP̵ʤäȯ&ѥи)
//========================================
RcHitEnum HitEnemyToTank(CharacterData *my, CharacterData *your)
{
  // ѵϸ
  my->Hp -= your->Power;
  if (my->Hp <= 0) { // ѵϤ̵ʤä
    // ȯ
    KXL_PlaySound(SE_BOMB, KXL_SOUND_PLAY);
    Cchr.Attr     = AttrNone;
    Cchr.Target   = AttrNone;
    Cchr.Spr      = PixBomb1;
    Cchr.FrameNo  = 0;
    Cchr.FrameMax = Cchr.Spr->max;
    Cchr.X        = ((my->X + my->Spr->data[0].img->Width / 2)
                     - (Cchr.Spr->data[0].img->Width / 2));
    Cchr.Y        = ((my->Y + my->Spr->data[0].img->Height / 2)
                     - (Cchr.Spr->data[0].img->Height / 2));
    CopyYourNew(MoveBomb, HitNone, DrawImageFrame);
    // ƥ
    if (RM(6) == 0)
      CreateItem(Cchr.X, Cchr.Y);
    my->Target = AttrNone;
    my->FrameNo = my->FrameMax - 1;
    if (your->Spr == PixMyCShot) {
      CreateChargeBomb(my->X,
		       my->Y + my->Spr->data[0].img->Height / 2);
      CreateChargeBomb(my->X + my->Spr->data[0].img->Width - 1,
		       my->Y + my->Spr->data[0].img->Height / 2);
    }
    return RcHitTank;
  }
  return RcHitNone;
}
//========================================
// 1
//========================================
void CreateEnemyShot1(Uint16 x, Uint16 y, Uint16 dir, Uint8 speed)
{
  Cchr.Attr     = AttrEShot;
  Cchr.Target   = AttrMy | AttrMBomb;
  Cchr.Spr      = PixEShot1;
  Cchr.FrameNo  = 0;
  Cchr.X        = x;
  Cchr.Y        = y;
  GetDirectionAdd(dir, &(Cchr.AddX), &(Cchr.AddY), speed);
  CopyYourNew(MoveStandardNoFrame, HitDelete, DrawImageFrame);
}
//========================================
// 2
//========================================
void CreateEnemyShot2(Uint16 x, Uint16 y, Uint16 dir, Uint8 speed)
{
  Cchr.Attr     = AttrEBomb;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixEShot2;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.X        = x;
  Cchr.Y        = y;
  GetDirectionAdd(dir, &(Cchr.AddX), &(Cchr.AddY), speed);
  CopyYourNew(MoveStandardFrame, HitDelete, DrawImageFrame);
}
//========================================
// 3
//========================================
void CreateEnemyShot3(Uint16 x, Uint16 y, Uint16 dir, Uint8 speed)
{
  Cchr.Attr     = AttrEShot;
  Cchr.Target   = AttrMy | AttrMBomb;
  Cchr.Spr      = PixEShot3;
  Cchr.FrameNo  = (dir % 360) / 10;
  Cchr.X        = x;
  Cchr.Y        = y;
  GetDirectionAdd(dir, &(Cchr.AddX), &(Cchr.AddY), speed);
  CopyYourNew(MoveStandardNoFrame, HitDelete, DrawImageFrame);
}
//========================================
// Ũ13
//========================================
void CreateEnemy1_3(Uint8 *x, Uint8 *y, Uint8 f)
{
  RcHitEnum (*mov[3])(CharacterData *) = {
    MoveEnemy1,
    MoveEnemy2,
    MoveEnemy3
  };
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Hp       = 1;
  Cchr.Spr      = PixRoll;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Score    = 10;
  Cchr.Bomb     = 0;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  if (f == 0) Cchr.Cnt1 = 2;
  else {
    GetDirectionAdd(0, &(Cchr.AddX), &(Cchr.AddY), 6);
    Cchr.Cnt1   = 0;
  }
  Cchr.Cnt2     = 0;
  Cchr.Cnt3     = Cchr.X < UP_LEFT + WIDTH / 2 ? 0 : 1;
  Cchr.Cnt5     = 0;
  CopyYourNew(mov[f], HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ1ư
// ˸äsinư
//========================================
RcHitEnum MoveEnemy1(CharacterData *my)
{
  // sinư
  if (my->Cnt3 == 0) {
    if (++ my->Cnt2 >= 2 * my->Cnt1) my->Cnt3 = 1;
  } else {
    if (-- my->Cnt2 <= -2 * my->Cnt1) my->Cnt3 = 0;
  }
  my->X += my->Cnt2;
  my->Y += 3;
  if (my->Y > UP_BOTTOM) return RcHitDel;
  // 
  if (my->Cnt5 == 0) {
    if (RM(10 - Root->Stage) == 0 && my->Y < UP_BOTTOM - 32) {
      CreateEnemyShot1(my->X + my->Spr->data[0].img->Width / 2, my->Y,
                       RM(5) ? 0 : GetDirection(my, &(Root->My[MY_NO].Chr)),
                       6);
    }
    my->Cnt5 = 10;
  }
  if (my->Cnt5) my->Cnt5 --;
  // ˥᡼
  if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ2ư
// ˰ưȽļäž
// ˸äưư
//========================================
RcHitEnum MoveEnemy2(CharacterData *my)
{
  if (my->Cnt1 == 0 && my->Y > Root->My[MY_NO].Chr.Y - 32) my->Cnt1 = 1;
  if (my->Cnt1 == 1) { // Ũ˶Ť
    if (my->Cnt3 == 0) { // 
      if (++ my->Cnt2 == 45) my->Cnt1 = 2;
    } else { // 
      if (-- my->Cnt2 == -45) my->Cnt1 = 2;
     }
    GetDirectionAdd(my->Cnt2 * 10, &(my->AddX), &(my->AddY), 6);
  }
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  // 
  if (my->Cnt5 == 0) {
    if (RM(10 - Root->Stage) == 0 && my->Y < UP_BOTTOM - 32) {
      CreateEnemyShot1(my->X + my->Spr->data[0].img->Width / 2, my->Y,
                       RM(5) ? 0 : GetDirection(my, &(Root->My[MY_NO].Chr)),
                       6);
    }
    my->Cnt5 = 10;
  }
  if (my->Cnt5) my->Cnt5 --;
  // ˥᡼
  if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ3ư
// ˰ư褿U
//========================================
RcHitEnum MoveEnemy3(CharacterData *my)
{
  if (my->Cnt1 == 0 && my->Y > UP_TOP + HEIGHT / 2) {
    my->Cnt1 = 1;
    // 
    if (RM(10 - Root->Stage) == 0 && my->Y < UP_BOTTOM - 32) {
      CreateEnemyShot1(my->X + my->Spr->data[0].img->Width / 2, my->Y,
                       GetDirection(my, &(Root->My[MY_NO].Chr)),
                       6);
    }
  }
  if (my->Cnt1 == 1) { // ˶Ť
    if (my->Cnt3 == 0) { // 
      if (++ my->Cnt2 == 18) my->Cnt1 = 2;
    } else { // 
      if (-- my->Cnt2 == -18) my->Cnt1 = 2;
    }
    GetDirectionAdd(my->Cnt2 * 10, &(my->AddX), &(my->AddY), 6);
  }
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height) return RcHitDel;
  // ˥᡼
  if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ45
//========================================
void CreateEnemy4_5(Uint8 *x, Uint8 *y, Uint8 f)
{
  RcHitEnum (*mov[2])(CharacterData *) = {
    MoveEnemy4,
    MoveEnemy5
  };

  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixKuru;
  Cchr.FrameNo  = 0;
  Cchr.Hp       = 3;
  Cchr.Score    = 30;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 0;
  Cchr.Cnt3     = Cchr.X < UP_LEFT + WIDTH / 2 ? 0 : 1;
  Cchr.Cnt5     = 0;
  if (f == 0) {
    Cchr.Cnt4   = Cchr.Y < UP_TOP + HEIGHT / 2 ? 1 : 0;
    GetDirectionAdd(180 - Cchr.Cnt4 * 180, &(Cchr.AddX), &(Cchr.AddY), 6);
  } else {
    Cchr.AddX   = 0;
    Cchr.AddY   = 6;
  }
  CopyYourNew(mov[f], HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ4ư
// ˰ư褿礭U
//========================================
RcHitEnum MoveEnemy4(CharacterData *my)
{
  KXL_Rect m = {1536, 1536, 2, 2};
  KXL_Rect t = m;
  
  if (my->Cnt1 == 0) {
    if (my->Cnt4 == 0) {
      if (my->Y < UP_TOP + 128) my->Cnt1 = 1;
    } else {
      if (my->Y > UP_BOTTOM - 128 - my->Spr->data[0].img->Height) my->Cnt1 = 1;
    }
  }
  if (my->Cnt1 == 1) { // ˶Ť
    if (my->Cnt4 == 0) {
      if (my->Cnt3 == 0) { // 
        if (-- my->Cnt2 == -60) my->Cnt1 = 2;
      } else { // 
        if (++ my->Cnt2 == 60) my->Cnt1 = 2;
      }
      GetDirectionAdd(180 + my->Cnt2 * 3, &(my->AddX), &(my->AddY), 6);
    } else {
      if (my->Cnt3 == 0) { // 
        if (++ my->Cnt2 == 60) my->Cnt1 = 2;
      } else { // 
        if (-- my->Cnt2 == -60) my->Cnt1 = 2;
      }
      GetDirectionAdd(my->Cnt2 * 3, &(my->AddX), &(my->AddY), 6);
    }
  }
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y > UP_BOTTOM ||
      my->Y < UP_TOP - my->Spr->data[0].img->Height)
    return RcHitDel;
  // 
  if (my->Cnt5 == 0) {
    if (RM(10 - Root->Stage) == 0 && my->Y < UP_BOTTOM - 32) {
      CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2, my->Y,
                       GetDirection(my, &(Root->My[MY_NO].Chr)),
                       4);
    }
    my->Cnt5 = 30;
  }
  if (my->Cnt5) my->Cnt5 --;
  // ˥᡼
  t.Left += my->AddX;
  t.Top  += my->AddY;
  my->FrameNo = KXL_GetDirection(m, t) / 30;
  return RcHitNone;
}
//========================================
// Ũ5ư
// ˰ưʤ顢˶Ť
// ˶Ť᤮꤫Τ
//========================================
RcHitEnum MoveEnemy5(CharacterData *my)
{
  KXL_Rect m = {6, 8, 2, 2};
  KXL_Rect t = m;
  Sint16 d = my->X - Root->My[MY_NO].Chr.X;
  Sint16 i, j;

  if (my->Cnt1 == 0) {
    if (abs(d) > 50) { // Ť
      if (d < 0) {
        if (my->AddX < 6) my->AddX ++;
      } else {
        if (my->AddX > -6) my->AddX --;
      }
    } else
      my->Cnt1 = 1;
  } else {
    if (abs(d) <= 50) {
      if (d < 0) { // Ť᤮Τ
        if (my->AddX > -6) my->AddX --;
      } else {
        if (my->AddX < 6) my->AddX ++;
      }
    }
  }
  my->X += my->AddX;
  my->Y += my->AddY;
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  // 
  if (my->Cnt5 == 0) {
    if (RM(20) == 0 && my->Y < UP_BOTTOM - 32) {
      j = GetDirection(my, &(Root->My[MY_NO].Chr));
      for (i = -10; i <= 10; i += 10)
        CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2, my->Y,
                         j + i, 4);
    }
    my->Cnt5 = 10;
  }
  if (my->Cnt5) my->Cnt5 --;
  // ˥᡼
  t.Left += my->AddX;
  t.Top  += my->AddY;
  my->FrameNo = KXL_GetDirection(m, t) / 30;
  return RcHitNone;
}
//========================================
// Ũ6
//========================================
void CreateEnemy6(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrTank;
  Cchr.Target   = AttrMShot | AttrMBomb;
  Cchr.Spr      = PixHoudai;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.Hp       = 6 + Root->Stage * 3;
  Cchr.Score    = 50;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt5     = 0;
  Cchr.AddY     = 1;
  CopyYourNew(MoveEnemy6, HitEnemyToTank, DrawImageFrame);
}
//========================================
// Ũ6ư
// ˰ưˤ˸
//========================================
RcHitEnum MoveEnemy6(CharacterData *my)
{
  static Uint8 dd[25] = {
    0, 1, 2, 2, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 4, 0
  };
  Uint16 d = GetDirection(my, &(Root->My[MY_NO].Chr));
  Uint8 f = dd[d / 15];

  // ư
  if (Root->BackLine < Root->BackMax - 12) {
    my->Y += my->AddY;
    if (my->Y > UP_BOTTOM) return RcHitDel;
  }
  if (my->Target == AttrNone) return RcHitNone;
  // 
  if (my->Cnt5 <= 5) {
    if (f != 5 && (my->Cnt5 % 4) == 1 && RM(2) && my->Y < UP_BOTTOM - 32)
      CreateEnemyShot3(my->X + my->Spr->data[0].img->Width / 2, my->Y, d, 6);
    if (my->Cnt5 == 0) my->Cnt5 = 64;
  }
  if (my->Cnt5) my->Cnt5 --;
  // ˥᡼
  if (f != 5) my->FrameNo = f;
  return RcHitNone;
}
//========================================
// Ũ7
//========================================
void CreateEnemy7(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrTank;
  Cchr.Target   = AttrMShot | AttrMBomb;
  Cchr.Spr      = PixOpenH;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max;
  Cchr.Hp       = 8;
  Cchr.Score    = 100;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 0;
  Cchr.Cnt5     = 0;
  Cchr.AddY     = 1;
  CopyYourNew(MoveEnemy7, HitEnemyToTank, DrawImageFrame);
}
//========================================
// Ũ7ư
// ˰ưˤ򳫤
//========================================
RcHitEnum MoveEnemy7(CharacterData *my)
{
  Uint16 i;

  // ư
  if (Root->BackLine < Root->BackMax - 12) {
    my->Y += my->AddY;
    if (my->Y > UP_BOTTOM) return RcHitDel;
  }
  if (my->Target == AttrNone) return RcHitNone;
  // 
  my->Attr &= ~AttrEnemy;
  if (my->Cnt1) my->Cnt1 --;
  if (my->Cnt2 == 0) { // ư
    if (my->Cnt1 == 0) my->Cnt2 = 1;
  } else if (my->Cnt2 == 1) { // 
    if (++ my->FrameNo == my->FrameMax - 2) {
      my->Cnt2 = 2;
      my->Cnt3 = 11;
      my->Cnt4 = RM(2);
    }
  } else if (my->Cnt2 == 2) { // 
    my->Attr |= AttrEnemy;
    if (-- my->Cnt3 == 0)
      my->Cnt2 = 3;
    else {
      if (my->Cnt4 && (my->Cnt3 % 5) == 0 && my->Y < UP_BOTTOM - 32)
        for (i = 330; i <= 390; i += 30)
          CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2,
                           my->Y + my->Spr->data[0].img->Height / 2,
                           i, 4);
    }
  } else if (my->Cnt2 ==3 ) { // Ĥ
    if (-- my->FrameNo == 0) {
      my->Cnt1 = 64 + 5 * RM(5);
      my->Cnt2 = 0;
    }
  }
  return RcHitNone;
}
//========================================
// Ũ8
//========================================
void CreateEnemy8(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixFly1;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 10;
  Cchr.Score    = 80;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt5     = 0;
  Cchr.AddX     = 0;
  Cchr.AddY     = 15;
  CopyYourNew(MoveEnemy8, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ8ư
// ®٤Ȥʤư
// Τžʤ˸
//========================================
RcHitEnum MoveEnemy8(CharacterData *my)
{
  Uint16 i;

  // ư
  if (my->Cnt1 == 0) { // ޤǰư
    if (-- my->AddY == 0) {
      my->Cnt1 = 1;
      my->Cnt2 = 5;
    }
  } else if (my->Cnt1 == 1) { // ʳܤѷ
    if (-- my->Cnt2 == 0) {
      my->FrameNo = 1;
      my->Cnt1 = 2;
      my->Cnt2 = 3;
    }
  } else if (my->Cnt1 == 2) { // 2ʳܤѷ
    if (-- my->Cnt2 == 0) {
      my->Spr = PixFly2;
      my->FrameNo = 0;
      my->FrameMax = my->Spr->max / 2;
      my->Cnt1 = 3;
      my->Cnt2 = 2;
      if (RM(3) == 0) {
        for (i = 270; i <= 450; i += 90)
          CreateEnemyShot1(my->X + my->Spr->data[0].img->Width / 2,
                           my->Y + my->Spr->data[0].img->Height / 2,
                           i, 4);
      }
    }
  } else if (my->Cnt1 == 3) { // 3ʳܤѷ塢ͷ
    if (my->AddY < 8) my->AddY ++;
    if (my->X < Root->My[MY_NO].Chr.X) {
      if (my->AddX < 10) my->AddX ++;
    } else {
      if (my->AddX > -10) my->AddX --;
    }
    if (++ my->FrameNo == my->FrameMax)
      my->FrameNo = 0;
  }
  my->X += my->AddX;
  my->Y += my->AddY;
  if (my->Y > UP_BOTTOM ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  return RcHitNone;
}
//========================================
// Ũ9
//========================================
void CreateEnemy9(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixHory;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 20;
  Cchr.Score    = 120;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 0;
  Cchr.AddX     = (Cchr.X < UP_LEFT + WIDTH / 2) ? 2 : -2;
  Cchr.AddY     = 0;
  CopyYourNew(MoveEnemy9, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ9ư
// ˰ư
//========================================
RcHitEnum MoveEnemy9(CharacterData *my)
{
  // ư
  my->X += my->AddX;
  if (my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  // 
  if (my->Cnt1 == 0) {
    if (RM(20 - Root->Stage) == 0) my->Cnt1 = 1;
  } else if (my->Cnt1 == 1) { // 
    if (++ my->FrameNo == my->FrameMax - 1) {
      my->Cnt1 = 2;
      my->Cnt2 = 0;
    }
  } else if (my->Cnt1 == 2) { // 
    if ((my->Cnt2 & 1) == 0) {
      CreateEnemyShot2(my->X + 10, my->Y + 37, 0, 8);
      CreateEnemyShot2(my->X + 32, my->Y + 37, 0, 8);
    }
    if (++ my->Cnt2 == 12) {
      my->FrameNo = 0;
      my->Cnt1 = 0;
    }
  }
  return RcHitNone;
}
//========================================
// Ũ10
//========================================
void CreateEnemy10(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixUturn;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 5;
  Cchr.Score    = 100;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt2     = 10;
  Cchr.Cnt3     = RM(30) * ((Cchr.X < UP_LEFT + WIDTH / 2) ? 1 : -1);
  GetDirectionAdd(Cchr.Cnt3, &(Cchr.AddX), &(Cchr.AddY), Cchr.Cnt2);
  Cchr.Cnt1     = 0;
  Cchr.Cnt5     = 0;
  CopyYourNew(MoveEnemy10, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ10ư
// ˰ưU
//========================================
RcHitEnum MoveEnemy10(CharacterData *my)
{
  Sint16 i;

  // ư
  if (my->Cnt1 == 0) {
    if (my->Y > UP_TOP + 64) my->Cnt1 = 1;
  } else if (my->Cnt1 == 1) {
    if (-- my->Cnt2 == 0) {
      my->Cnt3 = 180 - my->Cnt3;
      my->Cnt1 = 2;
    }
  } else if (my->Cnt1 == 2) {
    my->Cnt2 ++;
    if (++ my->FrameNo == my->FrameMax - 1) my->Cnt1 = 3;
  }
  GetDirectionAdd(my->Cnt3, &(my->AddX), &(my->AddY), my->Cnt2);
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  if (my->Y < UP_TOP - my->Spr->data[my->FrameNo].img->Height ||
      my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
      my->X > UP_RIGHT)
    return RcHitDel;
  // 
  if (RM(15 - Root->Stage) == 0 && my->Cnt1 == 1) {
    for (i = 300; i <= 420; i += 30)
      CreateEnemyShot1(my->X + my->Spr->data[0].img->Width / 2,
                       my->Y + my->Spr->data[0].img->Height,
                       i, 2);
  }
  return RcHitNone;
}
//========================================
// Ũ11
//========================================
void CreateEnemy11(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixBound;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 10;
  Cchr.Score    = 200;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt2     = (Cchr.X < UP_LEFT + WIDTH / 2) ? -10 : 10;
  Cchr.Cnt3     = (Cchr.Cnt2 == -10) ? 90 : 270;
  Cchr.Cnt4     = Cchr.Cnt3;
  GetDirectionAdd(Cchr.Cnt3, &(Cchr.AddX), &(Cchr.AddY), 8);
  Cchr.Cnt1     = 0;
  Cchr.Cnt5     = 0;
  CopyYourNew(MoveEnemy11, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ11ư
// ʾ˰ư
//========================================
RcHitEnum MoveEnemy11(CharacterData *my)
{
  Sint16 i;

  // ư
  if (my->Cnt1 == 0) {
    my->Cnt3 += my->Cnt2;
    if ((my->Cnt3 % 360) == 0) my->Cnt1 = 1;
    GetDirectionAdd(my->Cnt3, &(my->AddX), &(my->AddY), 8);
    KXL_DirectionAdd(my->X, my->CntX, my->AddX);
    KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
    if (my->X < UP_LEFT - my->Spr->data[my->FrameNo].img->Width ||
        my->X > UP_RIGHT ||
        my->Y > UP_BOTTOM)
      return RcHitDel;
  } else if (my->Cnt1 == 1) {
    if (RM(10) == 0) {
      my->Cnt1 = 0;
      my->Cnt3 = my->Cnt4;
    }
  }
  // 
  if (RM(15 - Root->Stage) == 0 && my->Cnt1 == 1) {
    for (i = 330; i <= 390; i += 10)
      CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2,
                       my->Y + my->Spr->data[0].img->Height,
                       i, 4);
  }
  // ˥᡼
  if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ12
// ľʤ
//========================================
void CreateEnemy12(void)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixFBoard;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 30;
  Cchr.Score    = 500;
  Cchr.X        = UP_LEFT + (RM(WIDTH / Cchr.Spr->data[Cchr.FrameNo].img->Width)) * Cchr.Spr->data[Cchr.FrameNo].img->Width;
  Cchr.Y        = UP_TOP - Cchr.Spr->data[Cchr.FrameNo].img->Height;
  Cchr.AddY     = 2 + RM(3);
  Cchr.Cnt1     = 0;
  CopyYourNew(MoveEnemy12, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ12ư
//========================================
RcHitEnum MoveEnemy12(CharacterData *my)
{
  // ư
  my->Y += my->AddY;
  if (my->Y > UP_BOTTOM)
    return RcHitDel;
  // ˥᡼
  if (++ my->Cnt1 & 1)
    if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ13
//========================================
void CreateEnemy13(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixBohu;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 20;
  Cchr.Score    = 300;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 0;
  Cchr.AddX     = 0;
  Cchr.AddY     = 0;
  CopyYourNew(MoveEnemy13, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ13ư
//========================================
RcHitEnum MoveEnemy13(CharacterData *my)
{
  // ư
  if (my->Cnt1 == 0) {
    if (++ my->AddY == 4) my->Cnt1 = 1;
  } else {
    if (-- my->AddY == 0) my->Cnt1 = 0;
  }
  my->Y += my->AddY;
  if (my->Y > UP_BOTTOM)
    return RcHitDel;
  // 
  if (my->AddY == 0) {
    if (RM(5) == 0) {
      CreateEnemyShot3(my->X,
                       my->Y + 20,
                       340, 6);
      CreateEnemyShot3(my->X + my->Spr->data[0].img->Width - PixEShot3->data[0].img->Width,
                       my->Y + 20,
                       20, 6);
    }
    if (RM(3) == 0)
      CreateEnemyShot2(my->X + (my->Spr->data[0].img->Width / 2) - PixEShot1->data[0].img->Width / 2,
                       my->Y + 20,
                       0, 6);
    
  }
  // ˥᡼
  if (++ my->Cnt2 & 1)
    if (++ my->FrameNo == my->FrameMax) my->FrameNo = 0;
  return RcHitNone;
}
//========================================
// Ũ14
//========================================
void CreateEnemy14(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixMBoss;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 80;
  Cchr.Score    = 600;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 0;
  Cchr.AddX     = 3;
  Cchr.AddY     = 3;
  CopyYourNew(MoveEnemy14, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ14ư
// üķ֤
//========================================
RcHitEnum MoveEnemy14(CharacterData *my)
{
  Uint16 i;

  // ư
  if (my->Cnt1 == 0) {
    my->Y += 4;
    if (my->Y > UP_TOP) my->Cnt1 = 1;
    return RcHitNone;
  }
  if (my->X + my->AddX <= UP_LEFT ||
      my->X + my->AddX >= UP_RIGHT - my->Spr->data[0].img->Width)
    my->AddX = -my->AddX;
  if (my->Y + my->AddY <= UP_TOP ||
      my->Y + my->AddY >= UP_BOTTOM - my->Spr->data[0].img->Height)
    my->AddY = -my->AddY;
  my->X += my->AddX;
  my->Y += my->AddY;
  // 
  if (RM(30) == 0)
    CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2,
		     my->Y + my->Spr->data[0].img->Height / 2,
		     GetDirection(my, &(Root->My[MY_NO].Chr)), 4);
  if (my->Cnt2 == 0) {
    if (RM(2) == 0) {
      for (i = 0; i < 360; i += 45)
	CreateEnemyShot3(my->X + my->Spr->data[0].img->Width / 2,
			 my->Y + my->Spr->data[0].img->Height / 2,
			 i, 8);
    }
    my->Cnt2 = 20 + RM(10);
  }
  if (my->Cnt2) my->Cnt2 --;
  return RcHitNone;
}
//========================================
// Ũ15
//========================================
void CreateEnemy15(Uint8 *x, Uint8 *y)
{
  Cchr.Attr     = AttrEnemy | AttrShadow;
  Cchr.Target   = AttrMy | AttrMShot | AttrMBomb;
  Cchr.Spr      = PixEgg;
  Cchr.FrameNo  = 0;
  Cchr.FrameMax = Cchr.Spr->max / 2;
  Cchr.Hp       = 40;
  Cchr.Score    = 300;
  Cchr.X        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, x);
  Cchr.Y        = Calc(Cchr.Spr->data[Cchr.FrameNo].img, y);
  Cchr.Cnt1     = 0;
  Cchr.Cnt2     = 1 + RM(3);
  CopyYourNew(MoveEnemy15, HitEnemyToBomb, DrawImageFrame);
}
//========================================
// Ũ15ư
// äɤ
//========================================
RcHitEnum MoveEnemy15(CharacterData *my)
{
  static fr[8] = {0, 0, 1, 1 ,2, 2, 1, 1};

  // ư
  GetDirectionAdd(GetDirection(my, &(Root->My[MY_NO].Chr)), &(my->AddX), &(my->AddY), my->Cnt2);
  KXL_DirectionAdd(my->X, my->CntX, my->AddX);
  KXL_DirectionAdd(my->Y, my->CntY, my->AddY);
  // 
  if (RM(30) == 0)
    CreateEnemyShot2(my->X + my->Spr->data[0].img->Width / 2,
		     my->Y + my->Spr->data[0].img->Height / 2,
		     GetDirection(my, &(Root->My[MY_NO].Chr)), 4);
  // ˥᡼
  if (++ my->Cnt1 == 8) my->Cnt1 = 0;
  my->FrameNo = fr[my->Cnt1];
  return RcHitNone;
}
