/* Return the parent pid for the given pid. Alternatives include parsing
 * "ps j" */
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <string.h>
#define __USE_XOPEN_EXTENDED /* getpgid */
#include <unistd.h>

#define DIE(X) do { fprintf(stderr, "%s: %s\n", argv[0], X); exit(EXIT_FAILURE); } while (0)
#define EDIE(X) do { fprintf(stderr, "%s: %s: %s\n", argv[0], X, strerror(errno)); exit(EXIT_FAILURE); } while (0)

int main(int argc, char *argv[])
{
	unsigned long pid_arg;
	pid_t group;
	if (argc != 2)
		DIE("usage: pid");
	pid_arg = strtoul(argv[1], NULL, 10);
	if ((pid_arg==ULONG_MAX && errno==ERANGE) || pid_arg==0)
		DIE("pid out of range");
	group = getpgid(pid_arg);
	if (group==-1)
		EDIE("getpgid failed");
	printf("%lu\n", (unsigned long)group);
	return EXIT_SUCCESS;
}
