// DO NOT EDIT: This file is autogenerated via the builtin command.

package monitor

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 19,
					Line:   142,
				},
				File:   "monitor.flux",
				Source: "package monitor\n\nimport \"experimental\"\nimport \"influxdata/influxdb/v1\"\nimport \"influxdata/influxdb\"\n\nbucket = \"_monitoring\"\n\n// Write persists the check statuses\noption write = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// Log records notification events\noption log = (tables=<-) => tables |> experimental.to(bucket: bucket)\n\n// From retrieves the check statuses that have been stored.\nfrom = (start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()\n\n// levels describing the result of a check\nlevelOK = \"ok\"\nlevelInfo = \"info\"\nlevelWarn = \"warn\"\nlevelCrit = \"crit\"\nlevelUnknown = \"unknown\"\n\n_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// stateChangesOnly takes a stream of tables that contains a _level column and\n// returns a stream of tables where each record in a table represents a state change\n// of the _level column.\nstateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}\n\n// StateChanges takes a stream of tables, fromLevel, and toLevel and returns\n// a stream of tables where status has gone from fromLevel to toLevel.\n//\n// StateChanges only operates on data with data where r._level exists.\nstateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}\n\n// Notify will call the endpoint and log the results.\nnotify = (tables=<-, endpoint, data={}) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()\n\n// Logs retrieves notification events that have been logged.\nlogs = (start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()\n\n// Deadman takes in a stream of tables and reports which tables\n// were observed strictly before t and which were observed after.\n//\ndeadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))\n\n// Check performs a check against its input using the given ok, info, warn and crit functions\n// and writes the result to a system bucket.\ncheck = (\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   7,
					},
					File:   "monitor.flux",
					Source: "bucket = \"_monitoring\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "monitor.flux",
						Source: "bucket",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "bucket",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   7,
						},
						File:   "monitor.flux",
						Source: "\"_monitoring\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "_monitoring",
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   10,
						},
						File:   "monitor.flux",
						Source: "write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   10,
							},
							File:   "monitor.flux",
							Source: "write",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "write",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   10,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 16,
								Line:   10,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 31,
									Line:   10,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   10,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 57,
											Line:   10,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 57,
												Line:   10,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   10,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 57,
													Line:   10,
												},
											},
										},
										Name: "bucket",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   10,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 65,
													Line:   10,
												},
											},
										},
										Name: "bucket",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 41,
										Line:   10,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   10,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 41,
											Line:   10,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 41,
												Line:   10,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   10,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 54,
												Line:   10,
											},
										},
									},
									Name: "to",
								},
							},
						},
					},
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 17,
									Line:   10,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   10,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 17,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   10,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 24,
									Line:   10,
								},
							},
						}},
					}},
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 72,
						Line:   10,
					},
					File:   "monitor.flux",
					Source: "option write = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   13,
						},
						File:   "monitor.flux",
						Source: "log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   13,
							},
							File:   "monitor.flux",
							Source: "log",
							Start: ast.Position{
								Column: 8,
								Line:   13,
							},
						},
					},
					Name: "log",
				},
				Init: &ast.FunctionExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   13,
							},
							File:   "monitor.flux",
							Source: "(tables=<-) => tables |> experimental.to(bucket: bucket)",
							Start: ast.Position{
								Column: 14,
								Line:   13,
							},
						},
					},
					Body: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "tables |> experimental.to(bucket: bucket)",
								Start: ast.Position{
									Column: 29,
									Line:   13,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   13,
										},
										File:   "monitor.flux",
										Source: "bucket: bucket",
										Start: ast.Position{
											Column: 55,
											Line:   13,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "bucket: bucket",
											Start: ast.Position{
												Column: 55,
												Line:   13,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   13,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 55,
													Line:   13,
												},
											},
										},
										Name: "bucket",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   13,
												},
												File:   "monitor.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 63,
													Line:   13,
												},
											},
										},
										Name: "bucket",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "experimental.to(bucket: bucket)",
									Start: ast.Position{
										Column: 39,
										Line:   13,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   13,
										},
										File:   "monitor.flux",
										Source: "experimental.to",
										Start: ast.Position{
											Column: 39,
											Line:   13,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 39,
												Line:   13,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   13,
											},
											File:   "monitor.flux",
											Source: "to",
											Start: ast.Position{
												Column: 52,
												Line:   13,
											},
										},
									},
									Name: "to",
								},
							},
						},
					},
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "tables=<-",
								Start: ast.Position{
									Column: 15,
									Line:   13,
								},
							},
						},
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   13,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 15,
										Line:   13,
									},
								},
							},
							Name: "tables",
						},
						Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   13,
								},
								File:   "monitor.flux",
								Source: "<-",
								Start: ast.Position{
									Column: 22,
									Line:   13,
								},
							},
						}},
					}},
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   13,
					},
					File:   "monitor.flux",
					Source: "option log = (tables=<-) => tables |> experimental.to(bucket: bucket)",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   21,
					},
					File:   "monitor.flux",
					Source: "from = (start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   16,
						},
						File:   "monitor.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   21,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn=(r) => true) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   16,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   17,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 19,
													Line:   17,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 19,
														Line:   17,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   17,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 19,
															Line:   17,
														},
													},
												},
												Name: "bucket",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   17,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   17,
														},
													},
												},
												Name: "bucket",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   17,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 5,
												Line:   17,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   17,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 5,
													Line:   17,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 5,
														Line:   17,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   17,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 14,
														Line:   17,
													},
												},
											},
											Name: "from",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   18,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 5,
											Line:   17,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   18,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 18,
													Line:   18,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   18,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   18,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   18,
														},
													},
												},
												Name: "start",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 25,
															Line:   18,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   18,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 32,
														Line:   18,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 32,
															Line:   18,
														},
													},
												},
												Name: "stop",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   18,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 38,
															Line:   18,
														},
													},
												},
												Name: "stop",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   18,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 12,
												Line:   18,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   18,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   18,
												},
											},
										},
										Name: "range",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   19,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   19,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"statuses\"",
											Start: ast.Position{
												Column: 19,
												Line:   19,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   19,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"statuses\"",
												Start: ast.Position{
													Column: 19,
													Line:   19,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   19,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   19,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   19,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"statuses\"",
													Start: ast.Position{
														Column: 23,
														Line:   19,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   19,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"statuses\"",
														Start: ast.Position{
															Column: 30,
															Line:   19,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 30,
																Line:   19,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   19,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   19,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   19,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 32,
																	Line:   19,
																},
															},
														},
														Name: "_measurement",
													},
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "\"statuses\"",
															Start: ast.Position{
																Column: 48,
																Line:   19,
															},
														},
													},
													Value: "statuses",
												},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   19,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 24,
															Line:   19,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   19,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   19,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   19,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"statuses\")",
										Start: ast.Position{
											Column: 12,
											Line:   19,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   19,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   19,
											},
										},
									},
									Name: "filter",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   20,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   20,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 19,
											Line:   20,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   20,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 19,
												Line:   20,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   20,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   20,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   20,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 23,
													Line:   20,
												},
											},
										},
										Name: "fn",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   20,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 12,
										Line:   20,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   20,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 12,
											Line:   20,
										},
									},
								},
								Name: "filter",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   21,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"statuses\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 5,
								Line:   17,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   21,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 12,
									Line:   21,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   21,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 12,
										Line:   21,
									},
								},
							},
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   21,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 12,
											Line:   21,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   21,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 15,
											Line:   21,
										},
									},
								},
								Name: "fieldsAsCols",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "start",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   16,
								},
							},
						},
						Name: "stop",
					},
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   16,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   16,
									},
								},
							},
							Name: "now",
						},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   16,
							},
							File:   "monitor.flux",
							Source: "fn=(r) => true",
							Start: ast.Position{
								Column: 28,
								Line:   16,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   16,
								},
							},
						},
						Name: "fn",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   16,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 31,
									Line:   16,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 38,
										Line:   16,
									},
								},
							},
							Name: "true",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   16,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 32,
										Line:   16,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   16,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 32,
											Line:   16,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   24,
					},
					File:   "monitor.flux",
					Source: "levelOK = \"ok\"",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   24,
						},
						File:   "monitor.flux",
						Source: "levelOK",
						Start: ast.Position{
							Column: 1,
							Line:   24,
						},
					},
				},
				Name: "levelOK",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   24,
						},
						File:   "monitor.flux",
						Source: "\"ok\"",
						Start: ast.Position{
							Column: 11,
							Line:   24,
						},
					},
				},
				Value: "ok",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   25,
					},
					File:   "monitor.flux",
					Source: "levelInfo = \"info\"",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   25,
						},
						File:   "monitor.flux",
						Source: "levelInfo",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "levelInfo",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   25,
						},
						File:   "monitor.flux",
						Source: "\"info\"",
						Start: ast.Position{
							Column: 13,
							Line:   25,
						},
					},
				},
				Value: "info",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   26,
					},
					File:   "monitor.flux",
					Source: "levelWarn = \"warn\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   26,
						},
						File:   "monitor.flux",
						Source: "levelWarn",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "levelWarn",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   26,
						},
						File:   "monitor.flux",
						Source: "\"warn\"",
						Start: ast.Position{
							Column: 13,
							Line:   26,
						},
					},
				},
				Value: "warn",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   27,
					},
					File:   "monitor.flux",
					Source: "levelCrit = \"crit\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   27,
						},
						File:   "monitor.flux",
						Source: "levelCrit",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "levelCrit",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   27,
						},
						File:   "monitor.flux",
						Source: "\"crit\"",
						Start: ast.Position{
							Column: 13,
							Line:   27,
						},
					},
				},
				Value: "crit",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   28,
					},
					File:   "monitor.flux",
					Source: "levelUnknown = \"unknown\"",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   28,
						},
						File:   "monitor.flux",
						Source: "levelUnknown",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "levelUnknown",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   28,
						},
						File:   "monitor.flux",
						Source: "\"unknown\"",
						Start: ast.Position{
							Column: 16,
							Line:   28,
						},
					},
				},
				Value: "unknown",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   49,
					},
					File:   "monitor.flux",
					Source: "_stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   30,
						},
						File:   "monitor.flux",
						Source: "_stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "_stateChanges",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   49,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 17,
							Line:   30,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   49,
							},
							File:   "monitor.flux",
							Source: "{\n    toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel\n\n    fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel\n\n    return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 64,
								Line:   30,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   32,
								},
								File:   "monitor.flux",
								Source: "toLevelFilter = if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   31,
									},
									File:   "monitor.flux",
									Source: "toLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   31,
									},
								},
							},
							Name: "toLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   32,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == toLevel",
										Start: ast.Position{
											Column: 25,
											Line:   32,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   32,
											},
											File:   "monitor.flux",
											Source: "r._level == toLevel",
											Start: ast.Position{
												Column: 32,
												Line:   32,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 32,
													Line:   32,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   32,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 32,
														Line:   32,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   32,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 34,
														Line:   32,
													},
												},
											},
											Name: "_level",
										},
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 44,
													Line:   32,
												},
											},
										},
										Name: "toLevel",
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   32,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 26,
												Line:   32,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   32,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 26,
													Line:   32,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   32,
									},
									File:   "monitor.flux",
									Source: "if toLevel == \"any\" then (r) => r._level != fromLevel and exists r._level\n                   else (r) => r._level == toLevel",
									Start: ast.Position{
										Column: 21,
										Line:   31,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   31,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != fromLevel and exists r._level",
										Start: ast.Position{
											Column: 46,
											Line:   31,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "r._level != fromLevel and exists r._level",
											Start: ast.Position{
												Column: 53,
												Line:   31,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "r._level != fromLevel",
												Start: ast.Position{
													Column: 53,
													Line:   31,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 53,
														Line:   31,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 53,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 55,
															Line:   31,
														},
													},
												},
												Name: "_level",
											},
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "fromLevel",
													Start: ast.Position{
														Column: 65,
														Line:   31,
													},
												},
											},
											Name: "fromLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   31,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 86,
														Line:   31,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 86,
															Line:   31,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   31,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 88,
															Line:   31,
														},
													},
												},
												Name: "_level",
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 79,
													Line:   31,
												},
											},
										},
										Operator: 14,
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 47,
												Line:   31,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   31,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   31,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   31,
										},
										File:   "monitor.flux",
										Source: "toLevel == \"any\"",
										Start: ast.Position{
											Column: 24,
											Line:   31,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "toLevel",
											Start: ast.Position{
												Column: 24,
												Line:   31,
											},
										},
									},
									Name: "toLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   31,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 35,
												Line:   31,
											},
										},
									},
									Value: "any",
								},
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   35,
								},
								File:   "monitor.flux",
								Source: "fromLevelFilter = if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   34,
									},
									File:   "monitor.flux",
									Source: "fromLevelFilter",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Name: "fromLevelFilter",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   35,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level == fromLevel",
										Start: ast.Position{
											Column: 25,
											Line:   35,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   35,
											},
											File:   "monitor.flux",
											Source: "r._level == fromLevel",
											Start: ast.Position{
												Column: 32,
												Line:   35,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "r._level",
												Start: ast.Position{
													Column: 32,
													Line:   35,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   35,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 32,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   35,
													},
													File:   "monitor.flux",
													Source: "_level",
													Start: ast.Position{
														Column: 34,
														Line:   35,
													},
												},
											},
											Name: "_level",
										},
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 44,
													Line:   35,
												},
											},
										},
										Name: "fromLevel",
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   35,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 26,
												Line:   35,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   35,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 26,
													Line:   35,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   35,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" then (r) => r._level != toLevel and exists r._level\n                   else (r) => r._level == fromLevel",
									Start: ast.Position{
										Column: 23,
										Line:   34,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   34,
										},
										File:   "monitor.flux",
										Source: "(r) => r._level != toLevel and exists r._level",
										Start: ast.Position{
											Column: 50,
											Line:   34,
										},
									},
								},
								Body: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "r._level != toLevel and exists r._level",
											Start: ast.Position{
												Column: 57,
												Line:   34,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "r._level != toLevel",
												Start: ast.Position{
													Column: 57,
													Line:   34,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 57,
														Line:   34,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 57,
															Line:   34,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 59,
															Line:   34,
														},
													},
												},
												Name: "_level",
											},
										},
										Operator: 18,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "toLevel",
													Start: ast.Position{
														Column: 69,
														Line:   34,
													},
												},
											},
											Name: "toLevel",
										},
									},
									Operator: 1,
									Right: &ast.UnaryExpression{
										Argument: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   34,
													},
													File:   "monitor.flux",
													Source: "r._level",
													Start: ast.Position{
														Column: 88,
														Line:   34,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 89,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 88,
															Line:   34,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   34,
														},
														File:   "monitor.flux",
														Source: "_level",
														Start: ast.Position{
															Column: 90,
															Line:   34,
														},
													},
												},
												Name: "_level",
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "exists r._level",
												Start: ast.Position{
													Column: 81,
													Line:   34,
												},
											},
										},
										Operator: 14,
									},
								},
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "r",
											Start: ast.Position{
												Column: 51,
												Line:   34,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   34,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 51,
													Line:   34,
												},
											},
										},
										Name: "r",
									},
									Value: nil,
								}},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   34,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\"",
										Start: ast.Position{
											Column: 26,
											Line:   34,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "fromLevel",
											Start: ast.Position{
												Column: 26,
												Line:   34,
											},
										},
									},
									Name: "fromLevel",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   34,
											},
											File:   "monitor.flux",
											Source: "\"any\"",
											Start: ast.Position{
												Column: 39,
												Line:   34,
											},
										},
									},
									Value: "any",
								},
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   37,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   37,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   40,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))",
																	Start: ast.Position{
																		Column: 12,
																		Line:   37,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   40,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																			Start: ast.Position{
																				Column: 16,
																				Line:   38,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   40,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																				Start: ast.Position{
																					Column: 16,
																					Line:   38,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   38,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 16,
																						Line:   38,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Value: &ast.FunctionExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 59,
																						Line:   40,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																					Start: ast.Position{
																						Column: 20,
																						Line:   38,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 59,
																							Line:   40,
																						},
																						File:   "monitor.flux",
																						Source: "({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10})",
																						Start: ast.Position{
																							Column: 27,
																							Line:   38,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 58,
																								Line:   40,
																							},
																							File:   "monitor.flux",
																							Source: "{r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}",
																							Start: ast.Position{
																								Column: 28,
																								Line:   38,
																							},
																						},
																					},
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 57,
																									Line:   40,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10",
																								Start: ast.Position{
																									Column: 36,
																									Line:   38,
																								},
																							},
																						},
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   38,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 36,
																										Line:   38,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.UnaryExpression{
																									Argument: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 57,
																													Line:   40,
																												},
																												File:   "monitor.flux",
																												Source: "10",
																												Start: ast.Position{
																													Column: 55,
																													Line:   40,
																												},
																											},
																										},
																										Value: int64(10),
																									},
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 57,
																												Line:   40,
																											},
																											File:   "monitor.flux",
																											Source: "-10",
																											Start: ast.Position{
																												Column: 54,
																												Line:   40,
																											},
																										},
																									},
																									Operator: 6,
																								},
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 57,
																											Line:   40,
																										},
																										File:   "monitor.flux",
																										Source: "if fromLevelFilter(r: r) then 0\n                                                else -10",
																										Start: ast.Position{
																											Column: 54,
																											Line:   39,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 85,
																												Line:   39,
																											},
																											File:   "monitor.flux",
																											Source: "0",
																											Start: ast.Position{
																												Column: 84,
																												Line:   39,
																											},
																										},
																									},
																									Value: int64(0),
																								},
																								Test: &ast.CallExpression{
																									Arguments: []ast.Expression{&ast.ObjectExpression{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 77,
																													Line:   39,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 73,
																													Line:   39,
																												},
																											},
																										},
																										Properties: []*ast.Property{&ast.Property{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 77,
																														Line:   39,
																													},
																													File:   "monitor.flux",
																													Source: "r: r",
																													Start: ast.Position{
																														Column: 73,
																														Line:   39,
																													},
																												},
																											},
																											Key: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 74,
																															Line:   39,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 73,
																															Line:   39,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Value: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 77,
																															Line:   39,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 76,
																															Line:   39,
																														},
																													},
																												},
																												Name: "r",
																											},
																										}},
																										With: nil,
																									}},
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 78,
																												Line:   39,
																											},
																											File:   "monitor.flux",
																											Source: "fromLevelFilter(r: r)",
																											Start: ast.Position{
																												Column: 57,
																												Line:   39,
																											},
																										},
																									},
																									Callee: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 72,
																													Line:   39,
																												},
																												File:   "monitor.flux",
																												Source: "fromLevelFilter",
																												Start: ast.Position{
																													Column: 57,
																													Line:   39,
																												},
																											},
																										},
																										Name: "fromLevelFilter",
																									},
																								},
																							},
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 57,
																										Line:   40,
																									},
																									File:   "monitor.flux",
																									Source: "if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10",
																									Start: ast.Position{
																										Column: 49,
																										Line:   38,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 78,
																											Line:   38,
																										},
																										File:   "monitor.flux",
																										Source: "1",
																										Start: ast.Position{
																											Column: 77,
																											Line:   38,
																										},
																									},
																								},
																								Value: int64(1),
																							},
																							Test: &ast.CallExpression{
																								Arguments: []ast.Expression{&ast.ObjectExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 70,
																												Line:   38,
																											},
																											File:   "monitor.flux",
																											Source: "r: r",
																											Start: ast.Position{
																												Column: 66,
																												Line:   38,
																											},
																										},
																									},
																									Properties: []*ast.Property{&ast.Property{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 70,
																													Line:   38,
																												},
																												File:   "monitor.flux",
																												Source: "r: r",
																												Start: ast.Position{
																													Column: 66,
																													Line:   38,
																												},
																											},
																										},
																										Key: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 67,
																														Line:   38,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 66,
																														Line:   38,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Value: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 70,
																														Line:   38,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 69,
																														Line:   38,
																													},
																												},
																											},
																											Name: "r",
																										},
																									}},
																									With: nil,
																								}},
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 71,
																											Line:   38,
																										},
																										File:   "monitor.flux",
																										Source: "toLevelFilter(r: r)",
																										Start: ast.Position{
																											Column: 52,
																											Line:   38,
																										},
																									},
																								},
																								Callee: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 65,
																												Line:   38,
																											},
																											File:   "monitor.flux",
																											Source: "toLevelFilter",
																											Start: ast.Position{
																												Column: 52,
																												Line:   38,
																											},
																										},
																									},
																									Name: "toLevelFilter",
																								},
																							},
																						},
																					}},
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 30,
																									Line:   38,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 29,
																									Line:   38,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																			},
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 22,
																							Line:   38,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 21,
																							Line:   38,
																						},
																					},
																				},
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   38,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 21,
																								Line:   38,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Value: nil,
																			}},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   40,
																		},
																		File:   "monitor.flux",
																		Source: "map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))",
																		Start: ast.Position{
																			Column: 12,
																			Line:   38,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   38,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   38,
																			},
																		},
																	},
																	Name: "map",
																},
															},
														},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   41,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   37,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   41,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   41,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   41,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   41,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   41,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   41,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   41,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   41,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   41,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   41,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   41,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   41,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   41,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   41,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   41,
																		},
																	},
																},
																Name: "duplicate",
															},
														},
													},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   42,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   37,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   42,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   42,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   42,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   42,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   42,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   42,
																			},
																		},
																	},
																	Name: "columns",
																},
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   42,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   42,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   42,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   42,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   42,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   42,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   42,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   42,
																	},
																},
															},
															Name: "drop",
														},
													},
												},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   43,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   37,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   43,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   43,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   43,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   43,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   43,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   43,
																		},
																	},
																},
																Name: "columns",
															},
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   43,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   43,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   43,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   43,
																			},
																		},
																	},
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   43,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   43,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   43,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   43,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																With: nil,
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   43,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   43,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   43,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   43,
																},
															},
														},
														Name: "rename",
													},
												},
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   44,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_time\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   44,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_time\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   44,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   44,
																	},
																},
															},
															Name: "columns",
														},
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_time\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   44,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   44,
																		},
																		File:   "monitor.flux",
																		Source: "\"_time\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   44,
																		},
																	},
																},
																Value: "_time",
															}},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   44,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 37,
																	Line:   44,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 37,
																		Line:   44,
																	},
																},
															},
															Name: "desc",
														},
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   44,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 43,
																		Line:   44,
																	},
																},
															},
															Name: "false",
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   44,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_time\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   44,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   44,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   44,
															},
														},
													},
													Name: "sort",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   45,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   37,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   45,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   45,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   45,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   45,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   45,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   45,
																},
															},
														},
														Name: "columns",
													},
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   45,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   45,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   45,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   45,
																	},
																},
															},
															Value: "level_value",
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   45,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   45,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   45,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   45,
														},
													},
												},
												Name: "difference",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   46,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   46,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value == 1",
													Start: ast.Position{
														Column: 19,
														Line:   46,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   46,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value == 1",
														Start: ast.Position{
															Column: 19,
															Line:   46,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   46,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   46,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   46,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value == 1",
															Start: ast.Position{
																Column: 23,
																Line:   46,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   46,
																},
																File:   "monitor.flux",
																Source: "r.level_value == 1",
																Start: ast.Position{
																	Column: 30,
																	Line:   46,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   46,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   46,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   46,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   46,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   46,
																		},
																	},
																},
																Name: "level_value",
															},
														},
														Operator: 17,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "1",
																	Start: ast.Position{
																		Column: 47,
																		Line:   46,
																	},
																},
															},
															Value: int64(1),
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   46,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   46,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   46,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   46,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   46,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value == 1)",
												Start: ast.Position{
													Column: 12,
													Line:   46,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   46,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   46,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   47,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   37,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   47,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   47,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   47,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   47,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   47,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   47,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   47,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   47,
															},
														},
													},
													Value: "level_value",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   47,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   47,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Name: "drop",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   48,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   48,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   48,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   48,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   48,
													},
												},
											},
											Name: "mode",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   48,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   48,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   48,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   48,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   48,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   48,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   48,
														},
													},
												},
												Value: "_level",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   48,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   48,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   48,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   48,
											},
										},
									},
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   48,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   48,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   48,
												},
											},
										},
										Name: "group",
									},
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   48,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(fn: (r) => ({r with level_value: if toLevelFilter(r: r) then 1\n                                                else if fromLevelFilter(r: r) then 0\n                                                else -10}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value == 1)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   37,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 18,
								Line:   30,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 18,
									Line:   30,
								},
							},
						},
						Name: "fromLevel",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 28,
									Line:   30,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 35,
								Line:   30,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 35,
									Line:   30,
								},
							},
						},
						Name: "toLevel",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 43,
									Line:   30,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 50,
								Line:   30,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   30,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 50,
									Line:   30,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   30,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 57,
								Line:   30,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   69,
					},
					File:   "monitor.flux",
					Source: "stateChangesOnly = (tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   54,
						},
						File:   "monitor.flux",
						Source: "stateChangesOnly",
						Start: ast.Position{
							Column: 1,
							Line:   54,
						},
					},
				},
				Name: "stateChangesOnly",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   69,
						},
						File:   "monitor.flux",
						Source: "(tables=<-) => {\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
						Start: ast.Position{
							Column: 20,
							Line:   54,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   69,
							},
							File:   "monitor.flux",
							Source: "{\n    return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])\n}",
							Start: ast.Position{
								Column: 35,
								Line:   54,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.PipeExpression{
													Argument: &ast.PipeExpression{
														Argument: &ast.PipeExpression{
															Argument: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   55,
																		},
																		File:   "monitor.flux",
																		Source: "tables",
																		Start: ast.Position{
																			Column: 12,
																			Line:   55,
																		},
																	},
																},
																Name: "tables",
															},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   60,
																	},
																	File:   "monitor.flux",
																	Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))",
																	Start: ast.Position{
																		Column: 12,
																		Line:   55,
																	},
																},
															},
															Call: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   60,
																			},
																			File:   "monitor.flux",
																			Source: "fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																			Start: ast.Position{
																				Column: 16,
																				Line:   56,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 57,
																					Line:   60,
																				},
																				File:   "monitor.flux",
																				Source: "fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																				Start: ast.Position{
																					Column: 16,
																					Line:   56,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   56,
																					},
																					File:   "monitor.flux",
																					Source: "fn",
																					Start: ast.Position{
																						Column: 16,
																						Line:   56,
																					},
																				},
																			},
																			Name: "fn",
																		},
																		Value: &ast.FunctionExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   60,
																					},
																					File:   "monitor.flux",
																					Source: "(r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																					Start: ast.Position{
																						Column: 20,
																						Line:   56,
																					},
																				},
																			},
																			Body: &ast.ParenExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 57,
																							Line:   60,
																						},
																						File:   "monitor.flux",
																						Source: "({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0})",
																						Start: ast.Position{
																							Column: 27,
																							Line:   56,
																						},
																					},
																				},
																				Expression: &ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 56,
																								Line:   60,
																							},
																							File:   "monitor.flux",
																							Source: "{r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}",
																							Start: ast.Position{
																								Column: 28,
																								Line:   56,
																							},
																						},
																					},
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 55,
																									Line:   60,
																								},
																								File:   "monitor.flux",
																								Source: "level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																								Start: ast.Position{
																									Column: 36,
																									Line:   56,
																								},
																							},
																						},
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   56,
																									},
																									File:   "monitor.flux",
																									Source: "level_value",
																									Start: ast.Position{
																										Column: 36,
																										Line:   56,
																									},
																								},
																							},
																							Name: "level_value",
																						},
																						Value: &ast.ConditionalExpression{
																							Alternate: &ast.ConditionalExpression{
																								Alternate: &ast.ConditionalExpression{
																									Alternate: &ast.ConditionalExpression{
																										Alternate: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 55,
																														Line:   60,
																													},
																													File:   "monitor.flux",
																													Source: "0",
																													Start: ast.Position{
																														Column: 54,
																														Line:   60,
																													},
																												},
																											},
																											Value: int64(0),
																										},
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 55,
																													Line:   60,
																												},
																												File:   "monitor.flux",
																												Source: "if r._level == levelOK then 1\n                                                else 0",
																												Start: ast.Position{
																													Column: 54,
																													Line:   59,
																												},
																											},
																										},
																										Consequent: &ast.IntegerLiteral{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 83,
																														Line:   59,
																													},
																													File:   "monitor.flux",
																													Source: "1",
																													Start: ast.Position{
																														Column: 82,
																														Line:   59,
																													},
																												},
																											},
																											Value: int64(1),
																										},
																										Test: &ast.BinaryExpression{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 76,
																														Line:   59,
																													},
																													File:   "monitor.flux",
																													Source: "r._level == levelOK",
																													Start: ast.Position{
																														Column: 57,
																														Line:   59,
																													},
																												},
																											},
																											Left: &ast.MemberExpression{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 65,
																															Line:   59,
																														},
																														File:   "monitor.flux",
																														Source: "r._level",
																														Start: ast.Position{
																															Column: 57,
																															Line:   59,
																														},
																													},
																												},
																												Object: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Errors: nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 58,
																																Line:   59,
																															},
																															File:   "monitor.flux",
																															Source: "r",
																															Start: ast.Position{
																																Column: 57,
																																Line:   59,
																															},
																														},
																													},
																													Name: "r",
																												},
																												Property: &ast.Identifier{
																													BaseNode: ast.BaseNode{
																														Errors: nil,
																														Loc: &ast.SourceLocation{
																															End: ast.Position{
																																Column: 65,
																																Line:   59,
																															},
																															File:   "monitor.flux",
																															Source: "_level",
																															Start: ast.Position{
																																Column: 59,
																																Line:   59,
																															},
																														},
																													},
																													Name: "_level",
																												},
																											},
																											Operator: 17,
																											Right: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 76,
																															Line:   59,
																														},
																														File:   "monitor.flux",
																														Source: "levelOK",
																														Start: ast.Position{
																															Column: 69,
																															Line:   59,
																														},
																													},
																												},
																												Name: "levelOK",
																											},
																										},
																									},
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 55,
																												Line:   60,
																											},
																											File:   "monitor.flux",
																											Source: "if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																											Start: ast.Position{
																												Column: 54,
																												Line:   58,
																											},
																										},
																									},
																									Consequent: &ast.IntegerLiteral{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 85,
																													Line:   58,
																												},
																												File:   "monitor.flux",
																												Source: "2",
																												Start: ast.Position{
																													Column: 84,
																													Line:   58,
																												},
																											},
																										},
																										Value: int64(2),
																									},
																									Test: &ast.BinaryExpression{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 78,
																													Line:   58,
																												},
																												File:   "monitor.flux",
																												Source: "r._level == levelInfo",
																												Start: ast.Position{
																													Column: 57,
																													Line:   58,
																												},
																											},
																										},
																										Left: &ast.MemberExpression{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 65,
																														Line:   58,
																													},
																													File:   "monitor.flux",
																													Source: "r._level",
																													Start: ast.Position{
																														Column: 57,
																														Line:   58,
																													},
																												},
																											},
																											Object: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 58,
																															Line:   58,
																														},
																														File:   "monitor.flux",
																														Source: "r",
																														Start: ast.Position{
																															Column: 57,
																															Line:   58,
																														},
																													},
																												},
																												Name: "r",
																											},
																											Property: &ast.Identifier{
																												BaseNode: ast.BaseNode{
																													Errors: nil,
																													Loc: &ast.SourceLocation{
																														End: ast.Position{
																															Column: 65,
																															Line:   58,
																														},
																														File:   "monitor.flux",
																														Source: "_level",
																														Start: ast.Position{
																															Column: 59,
																															Line:   58,
																														},
																													},
																												},
																												Name: "_level",
																											},
																										},
																										Operator: 17,
																										Right: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 78,
																														Line:   58,
																													},
																													File:   "monitor.flux",
																													Source: "levelInfo",
																													Start: ast.Position{
																														Column: 69,
																														Line:   58,
																													},
																												},
																											},
																											Name: "levelInfo",
																										},
																									},
																								},
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 55,
																											Line:   60,
																										},
																										File:   "monitor.flux",
																										Source: "if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																										Start: ast.Position{
																											Column: 54,
																											Line:   57,
																										},
																									},
																								},
																								Consequent: &ast.IntegerLiteral{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 85,
																												Line:   57,
																											},
																											File:   "monitor.flux",
																											Source: "3",
																											Start: ast.Position{
																												Column: 84,
																												Line:   57,
																											},
																										},
																									},
																									Value: int64(3),
																								},
																								Test: &ast.BinaryExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 78,
																												Line:   57,
																											},
																											File:   "monitor.flux",
																											Source: "r._level == levelWarn",
																											Start: ast.Position{
																												Column: 57,
																												Line:   57,
																											},
																										},
																									},
																									Left: &ast.MemberExpression{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 65,
																													Line:   57,
																												},
																												File:   "monitor.flux",
																												Source: "r._level",
																												Start: ast.Position{
																													Column: 57,
																													Line:   57,
																												},
																											},
																										},
																										Object: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 58,
																														Line:   57,
																													},
																													File:   "monitor.flux",
																													Source: "r",
																													Start: ast.Position{
																														Column: 57,
																														Line:   57,
																													},
																												},
																											},
																											Name: "r",
																										},
																										Property: &ast.Identifier{
																											BaseNode: ast.BaseNode{
																												Errors: nil,
																												Loc: &ast.SourceLocation{
																													End: ast.Position{
																														Column: 65,
																														Line:   57,
																													},
																													File:   "monitor.flux",
																													Source: "_level",
																													Start: ast.Position{
																														Column: 59,
																														Line:   57,
																													},
																												},
																											},
																											Name: "_level",
																										},
																									},
																									Operator: 17,
																									Right: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 78,
																													Line:   57,
																												},
																												File:   "monitor.flux",
																												Source: "levelWarn",
																												Start: ast.Position{
																													Column: 69,
																													Line:   57,
																												},
																											},
																										},
																										Name: "levelWarn",
																									},
																								},
																							},
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 55,
																										Line:   60,
																									},
																									File:   "monitor.flux",
																									Source: "if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0",
																									Start: ast.Position{
																										Column: 49,
																										Line:   56,
																									},
																								},
																							},
																							Consequent: &ast.IntegerLiteral{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 80,
																											Line:   56,
																										},
																										File:   "monitor.flux",
																										Source: "4",
																										Start: ast.Position{
																											Column: 79,
																											Line:   56,
																										},
																									},
																								},
																								Value: int64(4),
																							},
																							Test: &ast.BinaryExpression{
																								BaseNode: ast.BaseNode{
																									Errors: nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 73,
																											Line:   56,
																										},
																										File:   "monitor.flux",
																										Source: "r._level == levelCrit",
																										Start: ast.Position{
																											Column: 52,
																											Line:   56,
																										},
																									},
																								},
																								Left: &ast.MemberExpression{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 60,
																												Line:   56,
																											},
																											File:   "monitor.flux",
																											Source: "r._level",
																											Start: ast.Position{
																												Column: 52,
																												Line:   56,
																											},
																										},
																									},
																									Object: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 53,
																													Line:   56,
																												},
																												File:   "monitor.flux",
																												Source: "r",
																												Start: ast.Position{
																													Column: 52,
																													Line:   56,
																												},
																											},
																										},
																										Name: "r",
																									},
																									Property: &ast.Identifier{
																										BaseNode: ast.BaseNode{
																											Errors: nil,
																											Loc: &ast.SourceLocation{
																												End: ast.Position{
																													Column: 60,
																													Line:   56,
																												},
																												File:   "monitor.flux",
																												Source: "_level",
																												Start: ast.Position{
																													Column: 54,
																													Line:   56,
																												},
																											},
																										},
																										Name: "_level",
																									},
																								},
																								Operator: 17,
																								Right: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Errors: nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 73,
																												Line:   56,
																											},
																											File:   "monitor.flux",
																											Source: "levelCrit",
																											Start: ast.Position{
																												Column: 64,
																												Line:   56,
																											},
																										},
																									},
																									Name: "levelCrit",
																								},
																							},
																						},
																					}},
																					With: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 30,
																									Line:   56,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 29,
																									Line:   56,
																								},
																							},
																						},
																						Name: "r",
																					},
																				},
																			},
																			Params: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 22,
																							Line:   56,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 21,
																							Line:   56,
																						},
																					},
																				},
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   56,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 21,
																								Line:   56,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Value: nil,
																			}},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   60,
																		},
																		File:   "monitor.flux",
																		Source: "map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))",
																		Start: ast.Position{
																			Column: 12,
																			Line:   56,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 15,
																				Line:   56,
																			},
																			File:   "monitor.flux",
																			Source: "map",
																			Start: ast.Position{
																				Column: 12,
																				Line:   56,
																			},
																		},
																	},
																	Name: "map",
																},
															},
														},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   61,
																},
																File:   "monitor.flux",
																Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")",
																Start: ast.Position{
																	Column: 12,
																	Line:   55,
																},
															},
														},
														Call: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   61,
																		},
																		File:   "monitor.flux",
																		Source: "column: \"_level\", as: \"____temp_level____\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   61,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   61,
																			},
																			File:   "monitor.flux",
																			Source: "column: \"_level\"",
																			Start: ast.Position{
																				Column: 22,
																				Line:   61,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   61,
																				},
																				File:   "monitor.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 22,
																					Line:   61,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   61,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 30,
																					Line:   61,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}, &ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   61,
																			},
																			File:   "monitor.flux",
																			Source: "as: \"____temp_level____\"",
																			Start: ast.Position{
																				Column: 40,
																				Line:   61,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   61,
																				},
																				File:   "monitor.flux",
																				Source: "as",
																				Start: ast.Position{
																					Column: 40,
																					Line:   61,
																				},
																			},
																		},
																		Name: "as",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   61,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 44,
																					Line:   61,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   61,
																	},
																	File:   "monitor.flux",
																	Source: "duplicate(column: \"_level\", as: \"____temp_level____\")",
																	Start: ast.Position{
																		Column: 12,
																		Line:   61,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   61,
																		},
																		File:   "monitor.flux",
																		Source: "duplicate",
																		Start: ast.Position{
																			Column: 12,
																			Line:   61,
																		},
																	},
																},
																Name: "duplicate",
															},
														},
													},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   62,
															},
															File:   "monitor.flux",
															Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])",
															Start: ast.Position{
																Column: 12,
																Line:   55,
															},
														},
													},
													Call: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   62,
																	},
																	File:   "monitor.flux",
																	Source: "columns: [\"_level\"]",
																	Start: ast.Position{
																		Column: 17,
																		Line:   62,
																	},
																},
															},
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   62,
																		},
																		File:   "monitor.flux",
																		Source: "columns: [\"_level\"]",
																		Start: ast.Position{
																			Column: 17,
																			Line:   62,
																		},
																	},
																},
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   62,
																			},
																			File:   "monitor.flux",
																			Source: "columns",
																			Start: ast.Position{
																				Column: 17,
																				Line:   62,
																			},
																		},
																	},
																	Name: "columns",
																},
																Value: &ast.ArrayExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   62,
																			},
																			File:   "monitor.flux",
																			Source: "[\"_level\"]",
																			Start: ast.Position{
																				Column: 26,
																				Line:   62,
																			},
																		},
																	},
																	Elements: []ast.Expression{&ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   62,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 27,
																					Line:   62,
																				},
																			},
																		},
																		Value: "_level",
																	}},
																},
															}},
															With: nil,
														}},
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   62,
																},
																File:   "monitor.flux",
																Source: "drop(columns: [\"_level\"])",
																Start: ast.Position{
																	Column: 12,
																	Line:   62,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   62,
																	},
																	File:   "monitor.flux",
																	Source: "drop",
																	Start: ast.Position{
																		Column: 12,
																		Line:   62,
																	},
																},
															},
															Name: "drop",
														},
													},
												},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   63,
														},
														File:   "monitor.flux",
														Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})",
														Start: ast.Position{
															Column: 12,
															Line:   55,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   63,
																},
																File:   "monitor.flux",
																Source: "columns: {\"____temp_level____\": \"_level\"}",
																Start: ast.Position{
																	Column: 19,
																	Line:   63,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   63,
																	},
																	File:   "monitor.flux",
																	Source: "columns: {\"____temp_level____\": \"_level\"}",
																	Start: ast.Position{
																		Column: 19,
																		Line:   63,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   63,
																		},
																		File:   "monitor.flux",
																		Source: "columns",
																		Start: ast.Position{
																			Column: 19,
																			Line:   63,
																		},
																	},
																},
																Name: "columns",
															},
															Value: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   63,
																		},
																		File:   "monitor.flux",
																		Source: "{\"____temp_level____\": \"_level\"}",
																		Start: ast.Position{
																			Column: 28,
																			Line:   63,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   63,
																			},
																			File:   "monitor.flux",
																			Source: "\"____temp_level____\": \"_level\"",
																			Start: ast.Position{
																				Column: 29,
																				Line:   63,
																			},
																		},
																	},
																	Key: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   63,
																				},
																				File:   "monitor.flux",
																				Source: "\"____temp_level____\"",
																				Start: ast.Position{
																					Column: 29,
																					Line:   63,
																				},
																			},
																		},
																		Value: "____temp_level____",
																	},
																	Value: &ast.StringLiteral{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   63,
																				},
																				File:   "monitor.flux",
																				Source: "\"_level\"",
																				Start: ast.Position{
																					Column: 51,
																					Line:   63,
																				},
																			},
																		},
																		Value: "_level",
																	},
																}},
																With: nil,
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   63,
															},
															File:   "monitor.flux",
															Source: "rename(columns: {\"____temp_level____\": \"_level\"})",
															Start: ast.Position{
																Column: 12,
																Line:   63,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   63,
																},
																File:   "monitor.flux",
																Source: "rename",
																Start: ast.Position{
																	Column: 12,
																	Line:   63,
																},
															},
														},
														Name: "rename",
													},
												},
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   64,
													},
													File:   "monitor.flux",
													Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)",
													Start: ast.Position{
														Column: 12,
														Line:   55,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   64,
															},
															File:   "monitor.flux",
															Source: "columns: [\"_time\"], desc: false",
															Start: ast.Position{
																Column: 17,
																Line:   64,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   64,
																},
																File:   "monitor.flux",
																Source: "columns: [\"_time\"]",
																Start: ast.Position{
																	Column: 17,
																	Line:   64,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   64,
																	},
																	File:   "monitor.flux",
																	Source: "columns",
																	Start: ast.Position{
																		Column: 17,
																		Line:   64,
																	},
																},
															},
															Name: "columns",
														},
														Value: &ast.ArrayExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   64,
																	},
																	File:   "monitor.flux",
																	Source: "[\"_time\"]",
																	Start: ast.Position{
																		Column: 26,
																		Line:   64,
																	},
																},
															},
															Elements: []ast.Expression{&ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   64,
																		},
																		File:   "monitor.flux",
																		Source: "\"_time\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   64,
																		},
																	},
																},
																Value: "_time",
															}},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   64,
																},
																File:   "monitor.flux",
																Source: "desc: false",
																Start: ast.Position{
																	Column: 37,
																	Line:   64,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   64,
																	},
																	File:   "monitor.flux",
																	Source: "desc",
																	Start: ast.Position{
																		Column: 37,
																		Line:   64,
																	},
																},
															},
															Name: "desc",
														},
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   64,
																	},
																	File:   "monitor.flux",
																	Source: "false",
																	Start: ast.Position{
																		Column: 43,
																		Line:   64,
																	},
																},
															},
															Name: "false",
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   64,
														},
														File:   "monitor.flux",
														Source: "sort(columns: [\"_time\"], desc: false)",
														Start: ast.Position{
															Column: 12,
															Line:   64,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   64,
															},
															File:   "monitor.flux",
															Source: "sort",
															Start: ast.Position{
																Column: 12,
																Line:   64,
															},
														},
													},
													Name: "sort",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   65,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])",
												Start: ast.Position{
													Column: 12,
													Line:   55,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   65,
														},
														File:   "monitor.flux",
														Source: "columns: [\"level_value\"]",
														Start: ast.Position{
															Column: 23,
															Line:   65,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   65,
															},
															File:   "monitor.flux",
															Source: "columns: [\"level_value\"]",
															Start: ast.Position{
																Column: 23,
																Line:   65,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   65,
																},
																File:   "monitor.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 23,
																	Line:   65,
																},
															},
														},
														Name: "columns",
													},
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   65,
																},
																File:   "monitor.flux",
																Source: "[\"level_value\"]",
																Start: ast.Position{
																	Column: 32,
																	Line:   65,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   65,
																	},
																	File:   "monitor.flux",
																	Source: "\"level_value\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   65,
																	},
																},
															},
															Value: "level_value",
														}},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   65,
													},
													File:   "monitor.flux",
													Source: "difference(columns: [\"level_value\"])",
													Start: ast.Position{
														Column: 12,
														Line:   65,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   65,
														},
														File:   "monitor.flux",
														Source: "difference",
														Start: ast.Position{
															Column: 12,
															Line:   65,
														},
													},
												},
												Name: "difference",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   66,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)",
											Start: ast.Position{
												Column: 12,
												Line:   55,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   66,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => r.level_value != 0",
													Start: ast.Position{
														Column: 19,
														Line:   66,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   66,
														},
														File:   "monitor.flux",
														Source: "fn: (r) => r.level_value != 0",
														Start: ast.Position{
															Column: 19,
															Line:   66,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   66,
															},
															File:   "monitor.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   66,
															},
														},
													},
													Name: "fn",
												},
												Value: &ast.FunctionExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   66,
															},
															File:   "monitor.flux",
															Source: "(r) => r.level_value != 0",
															Start: ast.Position{
																Column: 23,
																Line:   66,
															},
														},
													},
													Body: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   66,
																},
																File:   "monitor.flux",
																Source: "r.level_value != 0",
																Start: ast.Position{
																	Column: 30,
																	Line:   66,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   66,
																	},
																	File:   "monitor.flux",
																	Source: "r.level_value",
																	Start: ast.Position{
																		Column: 30,
																		Line:   66,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   66,
																		},
																		File:   "monitor.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 30,
																			Line:   66,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   66,
																		},
																		File:   "monitor.flux",
																		Source: "level_value",
																		Start: ast.Position{
																			Column: 32,
																			Line:   66,
																		},
																	},
																},
																Name: "level_value",
															},
														},
														Operator: 18,
														Right: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   66,
																	},
																	File:   "monitor.flux",
																	Source: "0",
																	Start: ast.Position{
																		Column: 47,
																		Line:   66,
																	},
																},
															},
															Value: int64(0),
														},
													},
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   66,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   66,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   66,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   66,
																	},
																},
															},
															Name: "r",
														},
														Value: nil,
													}},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   66,
												},
												File:   "monitor.flux",
												Source: "filter(fn: (r) => r.level_value != 0)",
												Start: ast.Position{
													Column: 12,
													Line:   66,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   66,
													},
													File:   "monitor.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   66,
													},
												},
											},
											Name: "filter",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   67,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])",
										Start: ast.Position{
											Column: 12,
											Line:   55,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   67,
												},
												File:   "monitor.flux",
												Source: "columns: [\"level_value\"]",
												Start: ast.Position{
													Column: 17,
													Line:   67,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   67,
													},
													File:   "monitor.flux",
													Source: "columns: [\"level_value\"]",
													Start: ast.Position{
														Column: 17,
														Line:   67,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   67,
														},
														File:   "monitor.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 17,
															Line:   67,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   67,
														},
														File:   "monitor.flux",
														Source: "[\"level_value\"]",
														Start: ast.Position{
															Column: 26,
															Line:   67,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   67,
															},
															File:   "monitor.flux",
															Source: "\"level_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   67,
															},
														},
													},
													Value: "level_value",
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   67,
											},
											File:   "monitor.flux",
											Source: "drop(columns: [\"level_value\"])",
											Start: ast.Position{
												Column: 12,
												Line:   67,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   67,
												},
												File:   "monitor.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 12,
													Line:   67,
												},
											},
										},
										Name: "drop",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   68,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   55,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   68,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\", columns: [\"_level\"]",
											Start: ast.Position{
												Column: 31,
												Line:   68,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   68,
												},
												File:   "monitor.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 31,
													Line:   68,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   68,
													},
													File:   "monitor.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 31,
														Line:   68,
													},
												},
											},
											Name: "mode",
										},
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   68,
													},
													File:   "monitor.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 37,
														Line:   68,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   68,
												},
												File:   "monitor.flux",
												Source: "columns: [\"_level\"]",
												Start: ast.Position{
													Column: 47,
													Line:   68,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   68,
													},
													File:   "monitor.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 47,
														Line:   68,
													},
												},
											},
											Name: "columns",
										},
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   68,
													},
													File:   "monitor.flux",
													Source: "[\"_level\"]",
													Start: ast.Position{
														Column: 56,
														Line:   68,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   68,
														},
														File:   "monitor.flux",
														Source: "\"_level\"",
														Start: ast.Position{
															Column: 57,
															Line:   68,
														},
													},
												},
												Value: "_level",
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   68,
										},
										File:   "monitor.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_level\"])",
										Start: ast.Position{
											Column: 12,
											Line:   68,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   68,
											},
											File:   "monitor.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 12,
												Line:   68,
											},
										},
									},
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   68,
												},
												File:   "monitor.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 12,
													Line:   68,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   68,
												},
												File:   "monitor.flux",
												Source: "group",
												Start: ast.Position{
													Column: 25,
													Line:   68,
												},
											},
										},
										Name: "group",
									},
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   68,
								},
								File:   "monitor.flux",
								Source: "return tables\n        |> map(fn: (r) => ({r with level_value: if r._level == levelCrit then 4\n                                                else if r._level == levelWarn then 3\n                                                else if r._level == levelInfo then 2\n                                                else if r._level == levelOK then 1\n                                                else 0}))\n        |> duplicate(column: \"_level\", as: \"____temp_level____\")\n        |> drop(columns: [\"_level\"])\n        |> rename(columns: {\"____temp_level____\": \"_level\"})\n        |> sort(columns: [\"_time\"], desc: false)\n        |> difference(columns: [\"level_value\"])\n        |> filter(fn: (r) => r.level_value != 0)\n        |> drop(columns: [\"level_value\"])\n        |> experimental.group(mode: \"extend\", columns: [\"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   54,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   54,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   54,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   54,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   54,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   54,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   78,
					},
					File:   "monitor.flux",
					Source: "stateChanges = (fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   75,
						},
						File:   "monitor.flux",
						Source: "stateChanges",
						Start: ast.Position{
							Column: 1,
							Line:   75,
						},
					},
				},
				Name: "stateChanges",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   78,
						},
						File:   "monitor.flux",
						Source: "(fromLevel=\"any\", toLevel=\"any\", tables=<-) => {\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
						Start: ast.Position{
							Column: 16,
							Line:   75,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   78,
							},
							File:   "monitor.flux",
							Source: "{\n    return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)\n}",
							Start: ast.Position{
								Column: 63,
								Line:   75,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.ConditionalExpression{
							Alternate: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   77,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 17,
												Line:   77,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   77,
										},
										File:   "monitor.flux",
										Source: "tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
										Start: ast.Position{
											Column: 17,
											Line:   77,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   77,
												},
												File:   "monitor.flux",
												Source: "fromLevel: fromLevel, toLevel: toLevel",
												Start: ast.Position{
													Column: 41,
													Line:   77,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   77,
													},
													File:   "monitor.flux",
													Source: "fromLevel: fromLevel",
													Start: ast.Position{
														Column: 41,
														Line:   77,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 41,
															Line:   77,
														},
													},
												},
												Name: "fromLevel",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "fromLevel",
														Start: ast.Position{
															Column: 52,
															Line:   77,
														},
													},
												},
												Name: "fromLevel",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   77,
													},
													File:   "monitor.flux",
													Source: "toLevel: toLevel",
													Start: ast.Position{
														Column: 63,
														Line:   77,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 63,
															Line:   77,
														},
													},
												},
												Name: "toLevel",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   77,
														},
														File:   "monitor.flux",
														Source: "toLevel",
														Start: ast.Position{
															Column: 72,
															Line:   77,
														},
													},
												},
												Name: "toLevel",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   77,
											},
											File:   "monitor.flux",
											Source: "_stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
											Start: ast.Position{
												Column: 27,
												Line:   77,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   77,
												},
												File:   "monitor.flux",
												Source: "_stateChanges",
												Start: ast.Position{
													Column: 27,
													Line:   77,
												},
											},
										},
										Name: "_stateChanges",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   77,
									},
									File:   "monitor.flux",
									Source: "if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
									Start: ast.Position{
										Column: 12,
										Line:   76,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   76,
											},
											File:   "monitor.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 60,
												Line:   76,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   76,
										},
										File:   "monitor.flux",
										Source: "tables |> stateChangesOnly()",
										Start: ast.Position{
											Column: 60,
											Line:   76,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   76,
											},
											File:   "monitor.flux",
											Source: "stateChangesOnly()",
											Start: ast.Position{
												Column: 70,
												Line:   76,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "stateChangesOnly",
												Start: ast.Position{
													Column: 70,
													Line:   76,
												},
											},
										},
										Name: "stateChangesOnly",
									},
								},
							},
							Test: &ast.LogicalExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   76,
										},
										File:   "monitor.flux",
										Source: "fromLevel == \"any\" and toLevel == \"any\"",
										Start: ast.Position{
											Column: 15,
											Line:   76,
										},
									},
								},
								Left: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   76,
											},
											File:   "monitor.flux",
											Source: "fromLevel == \"any\"",
											Start: ast.Position{
												Column: 15,
												Line:   76,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "fromLevel",
												Start: ast.Position{
													Column: 15,
													Line:   76,
												},
											},
										},
										Name: "fromLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 28,
													Line:   76,
												},
											},
										},
										Value: "any",
									},
								},
								Operator: 1,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   76,
											},
											File:   "monitor.flux",
											Source: "toLevel == \"any\"",
											Start: ast.Position{
												Column: 38,
												Line:   76,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "toLevel",
												Start: ast.Position{
													Column: 38,
													Line:   76,
												},
											},
										},
										Name: "toLevel",
									},
									Operator: 17,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   76,
												},
												File:   "monitor.flux",
												Source: "\"any\"",
												Start: ast.Position{
													Column: 49,
													Line:   76,
												},
											},
										},
										Value: "any",
									},
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   77,
								},
								File:   "monitor.flux",
								Source: "return if fromLevel == \"any\" and toLevel == \"any\" then tables |> stateChangesOnly()\n           else tables |> _stateChanges(fromLevel: fromLevel, toLevel: toLevel)",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
					}},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   75,
							},
							File:   "monitor.flux",
							Source: "fromLevel=\"any\"",
							Start: ast.Position{
								Column: 17,
								Line:   75,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   75,
								},
								File:   "monitor.flux",
								Source: "fromLevel",
								Start: ast.Position{
									Column: 17,
									Line:   75,
								},
							},
						},
						Name: "fromLevel",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   75,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 27,
									Line:   75,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   75,
							},
							File:   "monitor.flux",
							Source: "toLevel=\"any\"",
							Start: ast.Position{
								Column: 34,
								Line:   75,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   75,
								},
								File:   "monitor.flux",
								Source: "toLevel",
								Start: ast.Position{
									Column: 34,
									Line:   75,
								},
							},
						},
						Name: "toLevel",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   75,
								},
								File:   "monitor.flux",
								Source: "\"any\"",
								Start: ast.Position{
									Column: 42,
									Line:   75,
								},
							},
						},
						Value: "any",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   75,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 49,
								Line:   75,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   75,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 49,
									Line:   75,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   75,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 56,
								Line:   75,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   92,
					},
					File:   "monitor.flux",
					Source: "notify = (tables=<-, endpoint, data={}) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
					Start: ast.Position{
						Column: 1,
						Line:   81,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   81,
						},
						File:   "monitor.flux",
						Source: "notify",
						Start: ast.Position{
							Column: 1,
							Line:   81,
						},
					},
				},
				Name: "notify",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   92,
						},
						File:   "monitor.flux",
						Source: "(tables=<-, endpoint, data={}) =>\n    tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
						Start: ast.Position{
							Column: 10,
							Line:   81,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   82,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 5,
														Line:   82,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   83,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> experimental.set(o: data)",
												Start: ast.Position{
													Column: 5,
													Line:   82,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   83,
														},
														File:   "monitor.flux",
														Source: "o: data",
														Start: ast.Position{
															Column: 29,
															Line:   83,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   83,
															},
															File:   "monitor.flux",
															Source: "o: data",
															Start: ast.Position{
																Column: 29,
																Line:   83,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   83,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 29,
																	Line:   83,
																},
															},
														},
														Name: "o",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   83,
																},
																File:   "monitor.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 32,
																	Line:   83,
																},
															},
														},
														Name: "data",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   83,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data)",
													Start: ast.Position{
														Column: 12,
														Line:   83,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   83,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 12,
															Line:   83,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   83,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 12,
																Line:   83,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   83,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 25,
																Line:   83,
															},
														},
													},
													Name: "set",
												},
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   84,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
											Start: ast.Position{
												Column: 5,
												Line:   82,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   84,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data)",
													Start: ast.Position{
														Column: 31,
														Line:   84,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   84,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 31,
															Line:   84,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   84,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 31,
																Line:   84,
															},
														},
													},
													Name: "mode",
												},
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   84,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 37,
																Line:   84,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   84,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data)",
														Start: ast.Position{
															Column: 47,
															Line:   84,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   84,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 47,
																Line:   84,
															},
														},
													},
													Name: "columns",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   84,
																},
																File:   "monitor.flux",
																Source: "o: data",
																Start: ast.Position{
																	Column: 80,
																	Line:   84,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   84,
																	},
																	File:   "monitor.flux",
																	Source: "o: data",
																	Start: ast.Position{
																		Column: 80,
																		Line:   84,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   84,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 80,
																			Line:   84,
																		},
																	},
																},
																Name: "o",
															},
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   84,
																		},
																		File:   "monitor.flux",
																		Source: "data",
																		Start: ast.Position{
																			Column: 83,
																			Line:   84,
																		},
																	},
																},
																Name: "data",
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   84,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data)",
															Start: ast.Position{
																Column: 56,
																Line:   84,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   84,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 56,
																	Line:   84,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   84,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 56,
																		Line:   84,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   84,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 69,
																		Line:   84,
																	},
																},
															},
															Name: "objectKeys",
														},
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   84,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))",
												Start: ast.Position{
													Column: 12,
													Line:   84,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   84,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 12,
														Line:   84,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   84,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 12,
															Line:   84,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   84,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 25,
															Line:   84,
														},
													},
												},
												Name: "group",
											},
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   89,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))",
										Start: ast.Position{
											Column: 5,
											Line:   82,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   89,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   85,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   89,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 16,
														Line:   85,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   85,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   85,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   89,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 20,
															Line:   85,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   89,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 27,
																Line:   85,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   89,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 28,
																	Line:   85,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   86,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"notifications\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   86,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   86,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   86,
																		},
																	},
																},
																Name: "_measurement",
															},
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   86,
																		},
																		File:   "monitor.flux",
																		Source: "\"notifications\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   86,
																		},
																	},
																},
																Value: "notifications",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   87,
																	},
																	File:   "monitor.flux",
																	Source: "_status_timestamp: int(v: r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   87,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   87,
																		},
																		File:   "monitor.flux",
																		Source: "_status_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   87,
																		},
																	},
																},
																Name: "_status_timestamp",
															},
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   87,
																			},
																			File:   "monitor.flux",
																			Source: "v: r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   87,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   87,
																				},
																				File:   "monitor.flux",
																				Source: "v: r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   87,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   87,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   87,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 46,
																						Line:   87,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 39,
																						Line:   87,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   87,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 39,
																							Line:   87,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   87,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 41,
																							Line:   87,
																						},
																					},
																				},
																				Name: "_time",
																			},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   87,
																		},
																		File:   "monitor.flux",
																		Source: "int(v: r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   87,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   87,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   87,
																			},
																		},
																	},
																	Name: "int",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   88,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   88,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   88,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   88,
																		},
																	},
																},
																Name: "_time",
															},
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   88,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   88,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   88,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   88,
																			},
																		},
																	},
																	Name: "now",
																},
															},
														}},
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   85,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   85,
																	},
																},
															},
															Name: "r",
														},
													},
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   85,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   85,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   85,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   85,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   89,
											},
											File:   "monitor.flux",
											Source: "map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))",
											Start: ast.Position{
												Column: 12,
												Line:   85,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   85,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   85,
												},
											},
										},
										Name: "map",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   90,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()",
									Start: ast.Position{
										Column: 5,
										Line:   82,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   90,
										},
										File:   "monitor.flux",
										Source: "endpoint()",
										Start: ast.Position{
											Column: 12,
											Line:   90,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   90,
											},
											File:   "monitor.flux",
											Source: "endpoint",
											Start: ast.Position{
												Column: 12,
												Line:   90,
											},
										},
									},
									Name: "endpoint",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   91,
								},
								File:   "monitor.flux",
								Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
								Start: ast.Position{
									Column: 5,
									Line:   82,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   91,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\", columns: [\"_sent\"]",
										Start: ast.Position{
											Column: 31,
											Line:   91,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   91,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 31,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   91,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 31,
													Line:   91,
												},
											},
										},
										Name: "mode",
									},
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   91,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 37,
													Line:   91,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   91,
											},
											File:   "monitor.flux",
											Source: "columns: [\"_sent\"]",
											Start: ast.Position{
												Column: 47,
												Line:   91,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   91,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   91,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   91,
												},
												File:   "monitor.flux",
												Source: "[\"_sent\"]",
												Start: ast.Position{
													Column: 56,
													Line:   91,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   91,
													},
													File:   "monitor.flux",
													Source: "\"_sent\"",
													Start: ast.Position{
														Column: 57,
														Line:   91,
													},
												},
											},
											Value: "_sent",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   91,
									},
									File:   "monitor.flux",
									Source: "experimental.group(mode: \"extend\", columns: [\"_sent\"])",
									Start: ast.Position{
										Column: 12,
										Line:   91,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   91,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 12,
											Line:   91,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   91,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 12,
												Line:   91,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   91,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 25,
												Line:   91,
											},
										},
									},
									Name: "group",
								},
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   92,
							},
							File:   "monitor.flux",
							Source: "tables\n        |> experimental.set(o: data)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data))\n        |> map(fn: (r) => ({r with\n            _measurement: \"notifications\",\n            _status_timestamp: int(v: r._time),\n            _time: now(),\n        }))\n        |> endpoint()\n        |> experimental.group(mode: \"extend\", columns: [\"_sent\"])\n        |> log()",
							Start: ast.Position{
								Column: 5,
								Line:   82,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   92,
								},
								File:   "monitor.flux",
								Source: "log()",
								Start: ast.Position{
									Column: 12,
									Line:   92,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   92,
									},
									File:   "monitor.flux",
									Source: "log",
									Start: ast.Position{
										Column: 12,
										Line:   92,
									},
								},
							},
							Name: "log",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   81,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 11,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   81,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 11,
									Line:   81,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   81,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   81,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   81,
							},
							File:   "monitor.flux",
							Source: "endpoint",
							Start: ast.Position{
								Column: 22,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   81,
								},
								File:   "monitor.flux",
								Source: "endpoint",
								Start: ast.Position{
									Column: 22,
									Line:   81,
								},
							},
						},
						Name: "endpoint",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   81,
							},
							File:   "monitor.flux",
							Source: "data={}",
							Start: ast.Position{
								Column: 32,
								Line:   81,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   81,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 32,
									Line:   81,
								},
							},
						},
						Name: "data",
					},
					Value: &ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   81,
								},
								File:   "monitor.flux",
								Source: "{}",
								Start: ast.Position{
									Column: 37,
									Line:   81,
								},
							},
						},
						Properties: nil,
						With:       nil,
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   100,
					},
					File:   "monitor.flux",
					Source: "logs = (start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   95,
						},
						File:   "monitor.flux",
						Source: "logs",
						Start: ast.Position{
							Column: 1,
							Line:   95,
						},
					},
				},
				Name: "logs",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   100,
						},
						File:   "monitor.flux",
						Source: "(start, stop=now(), fn) =>\n    influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
						Start: ast.Position{
							Column: 8,
							Line:   95,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   96,
												},
												File:   "monitor.flux",
												Source: "bucket: bucket",
												Start: ast.Position{
													Column: 19,
													Line:   96,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   96,
													},
													File:   "monitor.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 19,
														Line:   96,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   96,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 19,
															Line:   96,
														},
													},
												},
												Name: "bucket",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   96,
														},
														File:   "monitor.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   96,
														},
													},
												},
												Name: "bucket",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   96,
											},
											File:   "monitor.flux",
											Source: "influxdb.from(bucket: bucket)",
											Start: ast.Position{
												Column: 5,
												Line:   96,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   96,
												},
												File:   "monitor.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 5,
													Line:   96,
												},
											},
										},
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   96,
													},
													File:   "monitor.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 5,
														Line:   96,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   96,
													},
													File:   "monitor.flux",
													Source: "from",
													Start: ast.Position{
														Column: 14,
														Line:   96,
													},
												},
											},
											Name: "from",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   97,
										},
										File:   "monitor.flux",
										Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)",
										Start: ast.Position{
											Column: 5,
											Line:   96,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   97,
												},
												File:   "monitor.flux",
												Source: "start: start, stop: stop",
												Start: ast.Position{
													Column: 18,
													Line:   97,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   97,
													},
													File:   "monitor.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   97,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   97,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   97,
														},
													},
												},
												Name: "start",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   97,
														},
														File:   "monitor.flux",
														Source: "start",
														Start: ast.Position{
															Column: 25,
															Line:   97,
														},
													},
												},
												Name: "start",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   97,
													},
													File:   "monitor.flux",
													Source: "stop: stop",
													Start: ast.Position{
														Column: 32,
														Line:   97,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   97,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 32,
															Line:   97,
														},
													},
												},
												Name: "stop",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   97,
														},
														File:   "monitor.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 38,
															Line:   97,
														},
													},
												},
												Name: "stop",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   97,
											},
											File:   "monitor.flux",
											Source: "range(start: start, stop: stop)",
											Start: ast.Position{
												Column: 12,
												Line:   97,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   97,
												},
												File:   "monitor.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   97,
												},
											},
										},
										Name: "range",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   98,
									},
									File:   "monitor.flux",
									Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")",
									Start: ast.Position{
										Column: 5,
										Line:   96,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   98,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => r._measurement == \"notifications\"",
											Start: ast.Position{
												Column: 19,
												Line:   98,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   98,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => r._measurement == \"notifications\"",
												Start: ast.Position{
													Column: 19,
													Line:   98,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   98,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   98,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   98,
													},
													File:   "monitor.flux",
													Source: "(r) => r._measurement == \"notifications\"",
													Start: ast.Position{
														Column: 23,
														Line:   98,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   98,
														},
														File:   "monitor.flux",
														Source: "r._measurement == \"notifications\"",
														Start: ast.Position{
															Column: 30,
															Line:   98,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   98,
															},
															File:   "monitor.flux",
															Source: "r._measurement",
															Start: ast.Position{
																Column: 30,
																Line:   98,
															},
														},
													},
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   98,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   98,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   98,
																},
																File:   "monitor.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 32,
																	Line:   98,
																},
															},
														},
														Name: "_measurement",
													},
												},
												Operator: 17,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   98,
															},
															File:   "monitor.flux",
															Source: "\"notifications\"",
															Start: ast.Position{
																Column: 48,
																Line:   98,
															},
														},
													},
													Value: "notifications",
												},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   98,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 24,
															Line:   98,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   98,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   98,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   98,
										},
										File:   "monitor.flux",
										Source: "filter(fn: (r) => r._measurement == \"notifications\")",
										Start: ast.Position{
											Column: 12,
											Line:   98,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   98,
											},
											File:   "monitor.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   98,
											},
										},
									},
									Name: "filter",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   99,
								},
								File:   "monitor.flux",
								Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)",
								Start: ast.Position{
									Column: 5,
									Line:   96,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   99,
										},
										File:   "monitor.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 19,
											Line:   99,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   99,
											},
											File:   "monitor.flux",
											Source: "fn: fn",
											Start: ast.Position{
												Column: 19,
												Line:   99,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   99,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 19,
													Line:   99,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   99,
												},
												File:   "monitor.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 23,
													Line:   99,
												},
											},
										},
										Name: "fn",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   99,
									},
									File:   "monitor.flux",
									Source: "filter(fn: fn)",
									Start: ast.Position{
										Column: 12,
										Line:   99,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   99,
										},
										File:   "monitor.flux",
										Source: "filter",
										Start: ast.Position{
											Column: 12,
											Line:   99,
										},
									},
								},
								Name: "filter",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   100,
							},
							File:   "monitor.flux",
							Source: "influxdb.from(bucket: bucket)\n        |> range(start: start, stop: stop)\n        |> filter(fn: (r) => r._measurement == \"notifications\")\n        |> filter(fn: fn)\n        |> v1.fieldsAsCols()",
							Start: ast.Position{
								Column: 5,
								Line:   96,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   100,
								},
								File:   "monitor.flux",
								Source: "v1.fieldsAsCols()",
								Start: ast.Position{
									Column: 12,
									Line:   100,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   100,
									},
									File:   "monitor.flux",
									Source: "v1.fieldsAsCols",
									Start: ast.Position{
										Column: 12,
										Line:   100,
									},
								},
							},
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   100,
										},
										File:   "monitor.flux",
										Source: "v1",
										Start: ast.Position{
											Column: 12,
											Line:   100,
										},
									},
								},
								Name: "v1",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   100,
										},
										File:   "monitor.flux",
										Source: "fieldsAsCols",
										Start: ast.Position{
											Column: 15,
											Line:   100,
										},
									},
								},
								Name: "fieldsAsCols",
							},
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   95,
							},
							File:   "monitor.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   95,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   95,
								},
								File:   "monitor.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   95,
								},
							},
						},
						Name: "start",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   95,
							},
							File:   "monitor.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 16,
								Line:   95,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   95,
								},
								File:   "monitor.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 16,
									Line:   95,
								},
							},
						},
						Name: "stop",
					},
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   95,
								},
								File:   "monitor.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 21,
									Line:   95,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   95,
									},
									File:   "monitor.flux",
									Source: "now",
									Start: ast.Position{
										Column: 21,
										Line:   95,
									},
								},
							},
							Name: "now",
						},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   95,
							},
							File:   "monitor.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 28,
								Line:   95,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   95,
								},
								File:   "monitor.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   95,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   107,
					},
					File:   "monitor.flux",
					Source: "deadman = (t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
					Start: ast.Position{
						Column: 1,
						Line:   105,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   105,
						},
						File:   "monitor.flux",
						Source: "deadman",
						Start: ast.Position{
							Column: 1,
							Line:   105,
						},
					},
				},
				Name: "deadman",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   107,
						},
						File:   "monitor.flux",
						Source: "(t, tables=<-) => tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
						Start: ast.Position{
							Column: 11,
							Line:   105,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   105,
									},
									File:   "monitor.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 29,
										Line:   105,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   106,
								},
								File:   "monitor.flux",
								Source: "tables\n    |> max(column: \"_time\")",
								Start: ast.Position{
									Column: 29,
									Line:   105,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   106,
										},
										File:   "monitor.flux",
										Source: "column: \"_time\"",
										Start: ast.Position{
											Column: 12,
											Line:   106,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   106,
											},
											File:   "monitor.flux",
											Source: "column: \"_time\"",
											Start: ast.Position{
												Column: 12,
												Line:   106,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   106,
												},
												File:   "monitor.flux",
												Source: "column",
												Start: ast.Position{
													Column: 12,
													Line:   106,
												},
											},
										},
										Name: "column",
									},
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   106,
												},
												File:   "monitor.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 20,
													Line:   106,
												},
											},
										},
										Value: "_time",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   106,
									},
									File:   "monitor.flux",
									Source: "max(column: \"_time\")",
									Start: ast.Position{
										Column: 8,
										Line:   106,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   106,
										},
										File:   "monitor.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   106,
										},
									},
								},
								Name: "max",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   107,
							},
							File:   "monitor.flux",
							Source: "tables\n    |> max(column: \"_time\")\n    |> map(fn: (r) => ( {r with dead: r._time < t} ))",
							Start: ast.Position{
								Column: 29,
								Line:   105,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   107,
									},
									File:   "monitor.flux",
									Source: "fn: (r) => ( {r with dead: r._time < t} )",
									Start: ast.Position{
										Column: 12,
										Line:   107,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   107,
										},
										File:   "monitor.flux",
										Source: "fn: (r) => ( {r with dead: r._time < t} )",
										Start: ast.Position{
											Column: 12,
											Line:   107,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   107,
											},
											File:   "monitor.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   107,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   107,
											},
											File:   "monitor.flux",
											Source: "(r) => ( {r with dead: r._time < t} )",
											Start: ast.Position{
												Column: 16,
												Line:   107,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   107,
												},
												File:   "monitor.flux",
												Source: "( {r with dead: r._time < t} )",
												Start: ast.Position{
													Column: 23,
													Line:   107,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   107,
													},
													File:   "monitor.flux",
													Source: "{r with dead: r._time < t}",
													Start: ast.Position{
														Column: 25,
														Line:   107,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   107,
														},
														File:   "monitor.flux",
														Source: "dead: r._time < t",
														Start: ast.Position{
															Column: 33,
															Line:   107,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   107,
															},
															File:   "monitor.flux",
															Source: "dead",
															Start: ast.Position{
																Column: 33,
																Line:   107,
															},
														},
													},
													Name: "dead",
												},
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 50,
																Line:   107,
															},
															File:   "monitor.flux",
															Source: "r._time < t",
															Start: ast.Position{
																Column: 39,
																Line:   107,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   107,
																},
																File:   "monitor.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 39,
																	Line:   107,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   107,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 39,
																		Line:   107,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   107,
																	},
																	File:   "monitor.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 41,
																		Line:   107,
																	},
																},
															},
															Name: "_time",
														},
													},
													Operator: 8,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   107,
																},
																File:   "monitor.flux",
																Source: "t",
																Start: ast.Position{
																	Column: 49,
																	Line:   107,
																},
															},
														},
														Name: "t",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   107,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 26,
															Line:   107,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   107,
												},
												File:   "monitor.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   107,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   107,
													},
													File:   "monitor.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   107,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   107,
								},
								File:   "monitor.flux",
								Source: "map(fn: (r) => ( {r with dead: r._time < t} ))",
								Start: ast.Position{
									Column: 8,
									Line:   107,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   107,
									},
									File:   "monitor.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   107,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   105,
							},
							File:   "monitor.flux",
							Source: "t",
							Start: ast.Position{
								Column: 12,
								Line:   105,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   105,
								},
								File:   "monitor.flux",
								Source: "t",
								Start: ast.Position{
									Column: 12,
									Line:   105,
								},
							},
						},
						Name: "t",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   105,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   105,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   105,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   105,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   105,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   105,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   142,
					},
					File:   "monitor.flux",
					Source: "check = (\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
					Start: ast.Position{
						Column: 1,
						Line:   111,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   111,
						},
						File:   "monitor.flux",
						Source: "check",
						Start: ast.Position{
							Column: 1,
							Line:   111,
						},
					},
				},
				Name: "check",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   142,
						},
						File:   "monitor.flux",
						Source: "(\n    tables=<-,\n    data,\n    messageFn,\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true\n) =>\n    tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
						Start: ast.Position{
							Column: 9,
							Line:   111,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   120,
													},
													File:   "monitor.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 5,
														Line:   120,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   121,
												},
												File:   "monitor.flux",
												Source: "tables\n        |> experimental.set(o: data.tags)",
												Start: ast.Position{
													Column: 5,
													Line:   120,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   121,
														},
														File:   "monitor.flux",
														Source: "o: data.tags",
														Start: ast.Position{
															Column: 29,
															Line:   121,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "o: data.tags",
															Start: ast.Position{
																Column: 29,
																Line:   121,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   121,
																},
																File:   "monitor.flux",
																Source: "o",
																Start: ast.Position{
																	Column: 29,
																	Line:   121,
																},
															},
														},
														Name: "o",
													},
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   121,
																},
																File:   "monitor.flux",
																Source: "data.tags",
																Start: ast.Position{
																	Column: 32,
																	Line:   121,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   121,
																	},
																	File:   "monitor.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 32,
																		Line:   121,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   121,
																	},
																	File:   "monitor.flux",
																	Source: "tags",
																	Start: ast.Position{
																		Column: 37,
																		Line:   121,
																	},
																},
															},
															Name: "tags",
														},
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   121,
													},
													File:   "monitor.flux",
													Source: "experimental.set(o: data.tags)",
													Start: ast.Position{
														Column: 12,
														Line:   121,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   121,
														},
														File:   "monitor.flux",
														Source: "experimental.set",
														Start: ast.Position{
															Column: 12,
															Line:   121,
														},
													},
												},
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "experimental",
															Start: ast.Position{
																Column: 12,
																Line:   121,
															},
														},
													},
													Name: "experimental",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   121,
															},
															File:   "monitor.flux",
															Source: "set",
															Start: ast.Position{
																Column: 25,
																Line:   121,
															},
														},
													},
													Name: "set",
												},
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   122,
											},
											File:   "monitor.flux",
											Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
											Start: ast.Position{
												Column: 5,
												Line:   120,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   122,
													},
													File:   "monitor.flux",
													Source: "mode: \"extend\", columns: experimental.objectKeys(o: data.tags)",
													Start: ast.Position{
														Column: 31,
														Line:   122,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 31,
															Line:   122,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 31,
																Line:   122,
															},
														},
													},
													Name: "mode",
												},
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 37,
																Line:   122,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 93,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "columns: experimental.objectKeys(o: data.tags)",
														Start: ast.Position{
															Column: 47,
															Line:   122,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 47,
																Line:   122,
															},
														},
													},
													Name: "columns",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 92,
																	Line:   122,
																},
																File:   "monitor.flux",
																Source: "o: data.tags",
																Start: ast.Position{
																	Column: 80,
																	Line:   122,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 92,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "o: data.tags",
																	Start: ast.Position{
																		Column: 80,
																		Line:   122,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   122,
																		},
																		File:   "monitor.flux",
																		Source: "o",
																		Start: ast.Position{
																			Column: 80,
																			Line:   122,
																		},
																	},
																},
																Name: "o",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   122,
																		},
																		File:   "monitor.flux",
																		Source: "data.tags",
																		Start: ast.Position{
																			Column: 83,
																			Line:   122,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 87,
																				Line:   122,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 83,
																				Line:   122,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 92,
																				Line:   122,
																			},
																			File:   "monitor.flux",
																			Source: "tags",
																			Start: ast.Position{
																				Column: 88,
																				Line:   122,
																			},
																		},
																	},
																	Name: "tags",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 93,
																Line:   122,
															},
															File:   "monitor.flux",
															Source: "experimental.objectKeys(o: data.tags)",
															Start: ast.Position{
																Column: 56,
																Line:   122,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 79,
																	Line:   122,
																},
																File:   "monitor.flux",
																Source: "experimental.objectKeys",
																Start: ast.Position{
																	Column: 56,
																	Line:   122,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "experimental",
																	Start: ast.Position{
																		Column: 56,
																		Line:   122,
																	},
																},
															},
															Name: "experimental",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   122,
																	},
																	File:   "monitor.flux",
																	Source: "objectKeys",
																	Start: ast.Position{
																		Column: 69,
																		Line:   122,
																	},
																},
															},
															Name: "objectKeys",
														},
													},
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   122,
												},
												File:   "monitor.flux",
												Source: "experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))",
												Start: ast.Position{
													Column: 12,
													Line:   122,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   122,
													},
													File:   "monitor.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 12,
														Line:   122,
													},
												},
											},
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 12,
															Line:   122,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   122,
														},
														File:   "monitor.flux",
														Source: "group",
														Start: ast.Position{
															Column: 25,
															Line:   122,
														},
													},
												},
												Name: "group",
											},
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   137,
										},
										File:   "monitor.flux",
										Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))",
										Start: ast.Position{
											Column: 5,
											Line:   120,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   137,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   123,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   137,
													},
													File:   "monitor.flux",
													Source: "fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
													Start: ast.Position{
														Column: 16,
														Line:   123,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   123,
														},
														File:   "monitor.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   123,
														},
													},
												},
												Name: "fn",
											},
											Value: &ast.FunctionExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   137,
														},
														File:   "monitor.flux",
														Source: "(r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
														Start: ast.Position{
															Column: 20,
															Line:   123,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   137,
															},
															File:   "monitor.flux",
															Source: "({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        })",
															Start: ast.Position{
																Column: 27,
																Line:   123,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 10,
																	Line:   137,
																},
																File:   "monitor.flux",
																Source: "{r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }",
																Start: ast.Position{
																	Column: 28,
																	Line:   123,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   124,
																	},
																	File:   "monitor.flux",
																	Source: "_measurement: \"statuses\"",
																	Start: ast.Position{
																		Column: 13,
																		Line:   124,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   124,
																		},
																		File:   "monitor.flux",
																		Source: "_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   124,
																		},
																	},
																},
																Name: "_measurement",
															},
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   124,
																		},
																		File:   "monitor.flux",
																		Source: "\"statuses\"",
																		Start: ast.Position{
																			Column: 27,
																			Line:   124,
																		},
																	},
																},
																Value: "statuses",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   125,
																	},
																	File:   "monitor.flux",
																	Source: "_source_measurement: r._measurement",
																	Start: ast.Position{
																		Column: 13,
																		Line:   125,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "_source_measurement",
																		Start: ast.Position{
																			Column: 13,
																			Line:   125,
																		},
																	},
																},
																Name: "_source_measurement",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   125,
																		},
																		File:   "monitor.flux",
																		Source: "r._measurement",
																		Start: ast.Position{
																			Column: 34,
																			Line:   125,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   125,
																			},
																			File:   "monitor.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 34,
																				Line:   125,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   125,
																			},
																			File:   "monitor.flux",
																			Source: "_measurement",
																			Start: ast.Position{
																				Column: 36,
																				Line:   125,
																			},
																		},
																	},
																	Name: "_measurement",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   126,
																	},
																	File:   "monitor.flux",
																	Source: "_type: data._type",
																	Start: ast.Position{
																		Column: 13,
																		Line:   126,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   126,
																		},
																		File:   "monitor.flux",
																		Source: "_type",
																		Start: ast.Position{
																			Column: 13,
																			Line:   126,
																		},
																	},
																},
																Name: "_type",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   126,
																		},
																		File:   "monitor.flux",
																		Source: "data._type",
																		Start: ast.Position{
																			Column: 20,
																			Line:   126,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   126,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 20,
																				Line:   126,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   126,
																			},
																			File:   "monitor.flux",
																			Source: "_type",
																			Start: ast.Position{
																				Column: 25,
																				Line:   126,
																			},
																		},
																	},
																	Name: "_type",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   127,
																	},
																	File:   "monitor.flux",
																	Source: "_check_id:  data._check_id",
																	Start: ast.Position{
																		Column: 13,
																		Line:   127,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "_check_id",
																		Start: ast.Position{
																			Column: 13,
																			Line:   127,
																		},
																	},
																},
																Name: "_check_id",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   127,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_id",
																		Start: ast.Position{
																			Column: 25,
																			Line:   127,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   127,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 25,
																				Line:   127,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   127,
																			},
																			File:   "monitor.flux",
																			Source: "_check_id",
																			Start: ast.Position{
																				Column: 30,
																				Line:   127,
																			},
																		},
																	},
																	Name: "_check_id",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   128,
																	},
																	File:   "monitor.flux",
																	Source: "_check_name: data._check_name",
																	Start: ast.Position{
																		Column: 13,
																		Line:   128,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   128,
																		},
																		File:   "monitor.flux",
																		Source: "_check_name",
																		Start: ast.Position{
																			Column: 13,
																			Line:   128,
																		},
																	},
																},
																Name: "_check_name",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   128,
																		},
																		File:   "monitor.flux",
																		Source: "data._check_name",
																		Start: ast.Position{
																			Column: 26,
																			Line:   128,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   128,
																			},
																			File:   "monitor.flux",
																			Source: "data",
																			Start: ast.Position{
																				Column: 26,
																				Line:   128,
																			},
																		},
																	},
																	Name: "data",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 42,
																				Line:   128,
																			},
																			File:   "monitor.flux",
																			Source: "_check_name",
																			Start: ast.Position{
																				Column: 31,
																				Line:   128,
																			},
																		},
																	},
																	Name: "_check_name",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   134,
																	},
																	File:   "monitor.flux",
																	Source: "_level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																	Start: ast.Position{
																		Column: 13,
																		Line:   129,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 19,
																			Line:   129,
																		},
																		File:   "monitor.flux",
																		Source: "_level",
																		Start: ast.Position{
																			Column: 13,
																			Line:   129,
																		},
																	},
																},
																Name: "_level",
															},
															Value: &ast.ConditionalExpression{
																Alternate: &ast.ConditionalExpression{
																	Alternate: &ast.ConditionalExpression{
																		Alternate: &ast.ConditionalExpression{
																			Alternate: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   134,
																						},
																						File:   "monitor.flux",
																						Source: "levelUnknown",
																						Start: ast.Position{
																							Column: 22,
																							Line:   134,
																						},
																					},
																				},
																				Name: "levelUnknown",
																			},
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   134,
																					},
																					File:   "monitor.flux",
																					Source: "if ok(r: r) then levelOK\n                else levelUnknown",
																					Start: ast.Position{
																						Column: 22,
																						Line:   133,
																					},
																				},
																			},
																			Consequent: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   133,
																						},
																						File:   "monitor.flux",
																						Source: "levelOK",
																						Start: ast.Position{
																							Column: 39,
																							Line:   133,
																						},
																					},
																				},
																				Name: "levelOK",
																			},
																			Test: &ast.CallExpression{
																				Arguments: []ast.Expression{&ast.ObjectExpression{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 32,
																								Line:   133,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 28,
																								Line:   133,
																							},
																						},
																					},
																					Properties: []*ast.Property{&ast.Property{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 32,
																									Line:   133,
																								},
																								File:   "monitor.flux",
																								Source: "r: r",
																								Start: ast.Position{
																									Column: 28,
																									Line:   133,
																								},
																							},
																						},
																						Key: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   133,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 28,
																										Line:   133,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Value: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Errors: nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 32,
																										Line:   133,
																									},
																									File:   "monitor.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 31,
																										Line:   133,
																									},
																								},
																							},
																							Name: "r",
																						},
																					}},
																					With: nil,
																				}},
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 33,
																							Line:   133,
																						},
																						File:   "monitor.flux",
																						Source: "ok(r: r)",
																						Start: ast.Position{
																							Column: 25,
																							Line:   133,
																						},
																					},
																				},
																				Callee: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 27,
																								Line:   133,
																							},
																							File:   "monitor.flux",
																							Source: "ok",
																							Start: ast.Position{
																								Column: 25,
																								Line:   133,
																							},
																						},
																					},
																					Name: "ok",
																				},
																			},
																		},
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   134,
																				},
																				File:   "monitor.flux",
																				Source: "if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																				Start: ast.Position{
																					Column: 22,
																					Line:   132,
																				},
																			},
																		},
																		Consequent: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 50,
																						Line:   132,
																					},
																					File:   "monitor.flux",
																					Source: "levelInfo",
																					Start: ast.Position{
																						Column: 41,
																						Line:   132,
																					},
																				},
																			},
																			Name: "levelInfo",
																		},
																		Test: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   132,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 30,
																							Line:   132,
																						},
																					},
																				},
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 34,
																								Line:   132,
																							},
																							File:   "monitor.flux",
																							Source: "r: r",
																							Start: ast.Position{
																								Column: 30,
																								Line:   132,
																							},
																						},
																					},
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 31,
																									Line:   132,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 30,
																									Line:   132,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Errors: nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 34,
																									Line:   132,
																								},
																								File:   "monitor.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 33,
																									Line:   132,
																								},
																							},
																						},
																						Name: "r",
																					},
																				}},
																				With: nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 35,
																						Line:   132,
																					},
																					File:   "monitor.flux",
																					Source: "info(r: r)",
																					Start: ast.Position{
																						Column: 25,
																						Line:   132,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   132,
																						},
																						File:   "monitor.flux",
																						Source: "info",
																						Start: ast.Position{
																							Column: 25,
																							Line:   132,
																						},
																					},
																				},
																				Name: "info",
																			},
																		},
																	},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   134,
																			},
																			File:   "monitor.flux",
																			Source: "if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																			Start: ast.Position{
																				Column: 22,
																				Line:   131,
																			},
																		},
																	},
																	Consequent: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   131,
																				},
																				File:   "monitor.flux",
																				Source: "levelWarn",
																				Start: ast.Position{
																					Column: 41,
																					Line:   131,
																				},
																			},
																		},
																		Name: "levelWarn",
																	},
																	Test: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 34,
																						Line:   131,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 30,
																						Line:   131,
																					},
																				},
																			},
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   131,
																						},
																						File:   "monitor.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 30,
																							Line:   131,
																						},
																					},
																				},
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 31,
																								Line:   131,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 30,
																								Line:   131,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Errors: nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 34,
																								Line:   131,
																							},
																							File:   "monitor.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 33,
																								Line:   131,
																							},
																						},
																					},
																					Name: "r",
																				},
																			}},
																			With: nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   131,
																				},
																				File:   "monitor.flux",
																				Source: "warn(r: r)",
																				Start: ast.Position{
																					Column: 25,
																					Line:   131,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   131,
																					},
																					File:   "monitor.flux",
																					Source: "warn",
																					Start: ast.Position{
																						Column: 25,
																						Line:   131,
																					},
																				},
																			},
																			Name: "warn",
																		},
																	},
																},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   134,
																		},
																		File:   "monitor.flux",
																		Source: "if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown",
																		Start: ast.Position{
																			Column: 17,
																			Line:   130,
																		},
																	},
																},
																Consequent: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   130,
																			},
																			File:   "monitor.flux",
																			Source: "levelCrit",
																			Start: ast.Position{
																				Column: 36,
																				Line:   130,
																			},
																		},
																	},
																	Name: "levelCrit",
																},
																Test: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 29,
																					Line:   130,
																				},
																				File:   "monitor.flux",
																				Source: "r: r",
																				Start: ast.Position{
																					Column: 25,
																					Line:   130,
																				},
																			},
																		},
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 29,
																						Line:   130,
																					},
																					File:   "monitor.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 25,
																						Line:   130,
																					},
																				},
																			},
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 26,
																							Line:   130,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 25,
																							Line:   130,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 29,
																							Line:   130,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 28,
																							Line:   130,
																						},
																					},
																				},
																				Name: "r",
																			},
																		}},
																		With: nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   130,
																			},
																			File:   "monitor.flux",
																			Source: "crit(r: r)",
																			Start: ast.Position{
																				Column: 20,
																				Line:   130,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   130,
																				},
																				File:   "monitor.flux",
																				Source: "crit",
																				Start: ast.Position{
																					Column: 20,
																					Line:   130,
																				},
																			},
																		},
																		Name: "crit",
																	},
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   135,
																	},
																	File:   "monitor.flux",
																	Source: "_source_timestamp: int(v:r._time)",
																	Start: ast.Position{
																		Column: 13,
																		Line:   135,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   135,
																		},
																		File:   "monitor.flux",
																		Source: "_source_timestamp",
																		Start: ast.Position{
																			Column: 13,
																			Line:   135,
																		},
																	},
																},
																Name: "_source_timestamp",
															},
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   135,
																			},
																			File:   "monitor.flux",
																			Source: "v:r._time",
																			Start: ast.Position{
																				Column: 36,
																				Line:   135,
																			},
																		},
																	},
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   135,
																				},
																				File:   "monitor.flux",
																				Source: "v:r._time",
																				Start: ast.Position{
																					Column: 36,
																					Line:   135,
																				},
																			},
																		},
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   135,
																					},
																					File:   "monitor.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 36,
																						Line:   135,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 45,
																						Line:   135,
																					},
																					File:   "monitor.flux",
																					Source: "r._time",
																					Start: ast.Position{
																						Column: 38,
																						Line:   135,
																					},
																				},
																			},
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 39,
																							Line:   135,
																						},
																						File:   "monitor.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 38,
																							Line:   135,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Errors: nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 45,
																							Line:   135,
																						},
																						File:   "monitor.flux",
																						Source: "_time",
																						Start: ast.Position{
																							Column: 40,
																							Line:   135,
																						},
																					},
																				},
																				Name: "_time",
																			},
																		},
																	}},
																	With: nil,
																}},
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   135,
																		},
																		File:   "monitor.flux",
																		Source: "int(v:r._time)",
																		Start: ast.Position{
																			Column: 32,
																			Line:   135,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 35,
																				Line:   135,
																			},
																			File:   "monitor.flux",
																			Source: "int",
																			Start: ast.Position{
																				Column: 32,
																				Line:   135,
																			},
																		},
																	},
																	Name: "int",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   136,
																	},
																	File:   "monitor.flux",
																	Source: "_time: now()",
																	Start: ast.Position{
																		Column: 13,
																		Line:   136,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   136,
																		},
																		File:   "monitor.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 13,
																			Line:   136,
																		},
																	},
																},
																Name: "_time",
															},
															Value: &ast.CallExpression{
																Arguments: nil,
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   136,
																		},
																		File:   "monitor.flux",
																		Source: "now()",
																		Start: ast.Position{
																			Column: 20,
																			Line:   136,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 23,
																				Line:   136,
																			},
																			File:   "monitor.flux",
																			Source: "now",
																			Start: ast.Position{
																				Column: 20,
																				Line:   136,
																			},
																		},
																	},
																	Name: "now",
																},
															},
														}},
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   123,
																	},
																	File:   "monitor.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   123,
																	},
																},
															},
															Name: "r",
														},
													},
												},
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   123,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   123,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   123,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   123,
																},
															},
														},
														Name: "r",
													},
													Value: nil,
												}},
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   137,
											},
											File:   "monitor.flux",
											Source: "map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))",
											Start: ast.Position{
												Column: 12,
												Line:   123,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   123,
												},
												File:   "monitor.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   123,
												},
											},
										},
										Name: "map",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   140,
									},
									File:   "monitor.flux",
									Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))",
									Start: ast.Position{
										Column: 5,
										Line:   120,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   140,
											},
											File:   "monitor.flux",
											Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
											Start: ast.Position{
												Column: 16,
												Line:   138,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   140,
												},
												File:   "monitor.flux",
												Source: "fn: (r) => ({r with\n            _message: messageFn(r: r),\n        })",
												Start: ast.Position{
													Column: 16,
													Line:   138,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   138,
													},
													File:   "monitor.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 16,
														Line:   138,
													},
												},
											},
											Name: "fn",
										},
										Value: &ast.FunctionExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   140,
													},
													File:   "monitor.flux",
													Source: "(r) => ({r with\n            _message: messageFn(r: r),\n        })",
													Start: ast.Position{
														Column: 20,
														Line:   138,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   140,
														},
														File:   "monitor.flux",
														Source: "({r with\n            _message: messageFn(r: r),\n        })",
														Start: ast.Position{
															Column: 27,
															Line:   138,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   140,
															},
															File:   "monitor.flux",
															Source: "{r with\n            _message: messageFn(r: r),\n        }",
															Start: ast.Position{
																Column: 28,
																Line:   138,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   139,
																},
																File:   "monitor.flux",
																Source: "_message: messageFn(r: r)",
																Start: ast.Position{
																	Column: 13,
																	Line:   139,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   139,
																	},
																	File:   "monitor.flux",
																	Source: "_message",
																	Start: ast.Position{
																		Column: 13,
																		Line:   139,
																	},
																},
															},
															Name: "_message",
														},
														Value: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   139,
																		},
																		File:   "monitor.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 33,
																			Line:   139,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   139,
																			},
																			File:   "monitor.flux",
																			Source: "r: r",
																			Start: ast.Position{
																				Column: 33,
																				Line:   139,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   139,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 33,
																					Line:   139,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Value: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   139,
																				},
																				File:   "monitor.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 36,
																					Line:   139,
																				},
																			},
																		},
																		Name: "r",
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   139,
																	},
																	File:   "monitor.flux",
																	Source: "messageFn(r: r)",
																	Start: ast.Position{
																		Column: 23,
																		Line:   139,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 32,
																			Line:   139,
																		},
																		File:   "monitor.flux",
																		Source: "messageFn",
																		Start: ast.Position{
																			Column: 23,
																			Line:   139,
																		},
																	},
																},
																Name: "messageFn",
															},
														},
													}},
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   138,
																},
																File:   "monitor.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 29,
																	Line:   138,
																},
															},
														},
														Name: "r",
													},
												},
											},
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   138,
														},
														File:   "monitor.flux",
														Source: "r",
														Start: ast.Position{
															Column: 21,
															Line:   138,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   138,
															},
															File:   "monitor.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   138,
															},
														},
													},
													Name: "r",
												},
												Value: nil,
											}},
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   140,
										},
										File:   "monitor.flux",
										Source: "map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))",
										Start: ast.Position{
											Column: 12,
											Line:   138,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   138,
											},
											File:   "monitor.flux",
											Source: "map",
											Start: ast.Position{
												Column: 12,
												Line:   138,
											},
										},
									},
									Name: "map",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   141,
								},
								File:   "monitor.flux",
								Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])",
								Start: ast.Position{
									Column: 5,
									Line:   120,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   141,
										},
										File:   "monitor.flux",
										Source: "mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
										Start: ast.Position{
											Column: 31,
											Line:   141,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   141,
											},
											File:   "monitor.flux",
											Source: "mode: \"extend\"",
											Start: ast.Position{
												Column: 31,
												Line:   141,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   141,
												},
												File:   "monitor.flux",
												Source: "mode",
												Start: ast.Position{
													Column: 31,
													Line:   141,
												},
											},
										},
										Name: "mode",
									},
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   141,
												},
												File:   "monitor.flux",
												Source: "\"extend\"",
												Start: ast.Position{
													Column: 37,
													Line:   141,
												},
											},
										},
										Value: "extend",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 126,
												Line:   141,
											},
											File:   "monitor.flux",
											Source: "columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
											Start: ast.Position{
												Column: 47,
												Line:   141,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   141,
												},
												File:   "monitor.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   141,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 126,
													Line:   141,
												},
												File:   "monitor.flux",
												Source: "[\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"]",
												Start: ast.Position{
													Column: 56,
													Line:   141,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "\"_source_measurement\"",
													Start: ast.Position{
														Column: 57,
														Line:   141,
													},
												},
											},
											Value: "_source_measurement",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "\"_type\"",
													Start: ast.Position{
														Column: 80,
														Line:   141,
													},
												},
											},
											Value: "_type",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "\"_check_id\"",
													Start: ast.Position{
														Column: 89,
														Line:   141,
													},
												},
											},
											Value: "_check_id",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 115,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "\"_check_name\"",
													Start: ast.Position{
														Column: 102,
														Line:   141,
													},
												},
											},
											Value: "_check_name",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 125,
														Line:   141,
													},
													File:   "monitor.flux",
													Source: "\"_level\"",
													Start: ast.Position{
														Column: 117,
														Line:   141,
													},
												},
											},
											Value: "_level",
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 127,
										Line:   141,
									},
									File:   "monitor.flux",
									Source: "experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])",
									Start: ast.Position{
										Column: 12,
										Line:   141,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   141,
										},
										File:   "monitor.flux",
										Source: "experimental.group",
										Start: ast.Position{
											Column: 12,
											Line:   141,
										},
									},
								},
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   141,
											},
											File:   "monitor.flux",
											Source: "experimental",
											Start: ast.Position{
												Column: 12,
												Line:   141,
											},
										},
									},
									Name: "experimental",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   141,
											},
											File:   "monitor.flux",
											Source: "group",
											Start: ast.Position{
												Column: 25,
												Line:   141,
											},
										},
									},
									Name: "group",
								},
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   142,
							},
							File:   "monitor.flux",
							Source: "tables\n        |> experimental.set(o: data.tags)\n        |> experimental.group(mode: \"extend\", columns: experimental.objectKeys(o: data.tags))\n        |> map(fn: (r) => ({r with\n            _measurement: \"statuses\",\n            _source_measurement: r._measurement,\n            _type: data._type,\n            _check_id:  data._check_id,\n            _check_name: data._check_name,\n            _level:\n                if crit(r: r) then levelCrit\n                else if warn(r: r) then levelWarn\n                else if info(r: r) then levelInfo\n                else if ok(r: r) then levelOK\n                else levelUnknown,\n            _source_timestamp: int(v:r._time),\n            _time: now(),\n        }))\n        |> map(fn: (r) => ({r with\n            _message: messageFn(r: r),\n        }))\n        |> experimental.group(mode: \"extend\", columns: [\"_source_measurement\", \"_type\", \"_check_id\", \"_check_name\", \"_level\"])\n        |> write()",
							Start: ast.Position{
								Column: 5,
								Line:   120,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   142,
								},
								File:   "monitor.flux",
								Source: "write()",
								Start: ast.Position{
									Column: 12,
									Line:   142,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   142,
									},
									File:   "monitor.flux",
									Source: "write",
									Start: ast.Position{
										Column: 12,
										Line:   142,
									},
								},
							},
							Name: "write",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   112,
							},
							File:   "monitor.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 5,
								Line:   112,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   112,
								},
								File:   "monitor.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   112,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   112,
							},
							File:   "monitor.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 12,
								Line:   112,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   113,
							},
							File:   "monitor.flux",
							Source: "data",
							Start: ast.Position{
								Column: 5,
								Line:   113,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   113,
								},
								File:   "monitor.flux",
								Source: "data",
								Start: ast.Position{
									Column: 5,
									Line:   113,
								},
							},
						},
						Name: "data",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   114,
							},
							File:   "monitor.flux",
							Source: "messageFn",
							Start: ast.Position{
								Column: 5,
								Line:   114,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   114,
								},
								File:   "monitor.flux",
								Source: "messageFn",
								Start: ast.Position{
									Column: 5,
									Line:   114,
								},
							},
						},
						Name: "messageFn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   115,
							},
							File:   "monitor.flux",
							Source: "crit=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   115,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   115,
								},
								File:   "monitor.flux",
								Source: "crit",
								Start: ast.Position{
									Column: 5,
									Line:   115,
								},
							},
						},
						Name: "crit",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   115,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   115,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   115,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   115,
									},
								},
							},
							Name: "false",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   115,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   115,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   115,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   115,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   116,
							},
							File:   "monitor.flux",
							Source: "warn=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   116,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   116,
								},
								File:   "monitor.flux",
								Source: "warn",
								Start: ast.Position{
									Column: 5,
									Line:   116,
								},
							},
						},
						Name: "warn",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   116,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   116,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   116,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   116,
									},
								},
							},
							Name: "false",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   116,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   116,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   116,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   116,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   117,
							},
							File:   "monitor.flux",
							Source: "info=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   117,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   117,
								},
								File:   "monitor.flux",
								Source: "info",
								Start: ast.Position{
									Column: 5,
									Line:   117,
								},
							},
						},
						Name: "info",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   117,
								},
								File:   "monitor.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   117,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   117,
									},
									File:   "monitor.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   117,
									},
								},
							},
							Name: "false",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   117,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   117,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   117,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   117,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   118,
							},
							File:   "monitor.flux",
							Source: "ok=(r) => true",
							Start: ast.Position{
								Column: 5,
								Line:   118,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   118,
								},
								File:   "monitor.flux",
								Source: "ok",
								Start: ast.Position{
									Column: 5,
									Line:   118,
								},
							},
						},
						Name: "ok",
					},
					Value: &ast.FunctionExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   118,
								},
								File:   "monitor.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 8,
									Line:   118,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   118,
									},
									File:   "monitor.flux",
									Source: "true",
									Start: ast.Position{
										Column: 15,
										Line:   118,
									},
								},
							},
							Name: "true",
						},
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   118,
									},
									File:   "monitor.flux",
									Source: "r",
									Start: ast.Position{
										Column: 9,
										Line:   118,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   118,
										},
										File:   "monitor.flux",
										Source: "r",
										Start: ast.Position{
											Column: 9,
											Line:   118,
										},
									},
								},
								Name: "r",
							},
							Value: nil,
						}},
					},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   3,
					},
					File:   "monitor.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   3,
						},
						File:   "monitor.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   4,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   4,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   5,
					},
					File:   "monitor.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   5,
						},
						File:   "monitor.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "monitor.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   1,
					},
					File:   "monitor.flux",
					Source: "package monitor",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   1,
						},
						File:   "monitor.flux",
						Source: "monitor",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "monitor",
			},
		},
	}},
	Package: "monitor",
	Path:    "influxdata/influxdb/monitor",
}
