// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1/cloud_sql_resources.proto

package sql

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SqlFileType int32

const (
	// Unknown file type.
	SqlFileType_SQL_FILE_TYPE_UNSPECIFIED SqlFileType = 0
	// File containing SQL statements.
	SqlFileType_SQL SqlFileType = 1
	// File in CSV format.
	SqlFileType_CSV SqlFileType = 2
	SqlFileType_BAK SqlFileType = 4
)

// Enum value maps for SqlFileType.
var (
	SqlFileType_name = map[int32]string{
		0: "SQL_FILE_TYPE_UNSPECIFIED",
		1: "SQL",
		2: "CSV",
		4: "BAK",
	}
	SqlFileType_value = map[string]int32{
		"SQL_FILE_TYPE_UNSPECIFIED": 0,
		"SQL":                       1,
		"CSV":                       2,
		"BAK":                       4,
	}
)

func (x SqlFileType) Enum() *SqlFileType {
	p := new(SqlFileType)
	*p = x
	return p
}

func (x SqlFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[0].Descriptor()
}

func (SqlFileType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[0]
}

func (x SqlFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlFileType.Descriptor instead.
func (SqlFileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{0}
}

type SqlBackendType int32

const (
	// This is an unknown backend type for instance.
	SqlBackendType_SQL_BACKEND_TYPE_UNSPECIFIED SqlBackendType = 0
	// V1 speckle instance.
	//
	// Deprecated: Do not use.
	SqlBackendType_FIRST_GEN SqlBackendType = 1
	// V2 speckle instance.
	SqlBackendType_SECOND_GEN SqlBackendType = 2
	// On premises instance.
	SqlBackendType_EXTERNAL SqlBackendType = 3
)

// Enum value maps for SqlBackendType.
var (
	SqlBackendType_name = map[int32]string{
		0: "SQL_BACKEND_TYPE_UNSPECIFIED",
		1: "FIRST_GEN",
		2: "SECOND_GEN",
		3: "EXTERNAL",
	}
	SqlBackendType_value = map[string]int32{
		"SQL_BACKEND_TYPE_UNSPECIFIED": 0,
		"FIRST_GEN":                    1,
		"SECOND_GEN":                   2,
		"EXTERNAL":                     3,
	}
)

func (x SqlBackendType) Enum() *SqlBackendType {
	p := new(SqlBackendType)
	*p = x
	return p
}

func (x SqlBackendType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackendType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[1].Descriptor()
}

func (SqlBackendType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[1]
}

func (x SqlBackendType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackendType.Descriptor instead.
func (SqlBackendType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{1}
}

type SqlIpAddressType int32

const (
	// This is an unknown IP address type.
	SqlIpAddressType_SQL_IP_ADDRESS_TYPE_UNSPECIFIED SqlIpAddressType = 0
	// IP address the customer is supposed to connect to. Usually this is the
	// load balancer's IP address
	SqlIpAddressType_PRIMARY SqlIpAddressType = 1
	// Source IP address of the connection a read replica establishes to its
	// external primary instance. This IP address can be allowlisted by the
	// customer in case it has a firewall that filters incoming connection to its
	// on premises primary instance.
	SqlIpAddressType_OUTGOING SqlIpAddressType = 2
	// Private IP used when using private IPs and network peering.
	SqlIpAddressType_PRIVATE SqlIpAddressType = 3
	// V1 IP of a migrated instance. We want the user to
	// decommission this IP as soon as the migration is complete.
	// Note: V1 instances with V1 ip addresses will be counted as PRIMARY.
	SqlIpAddressType_MIGRATED_1ST_GEN SqlIpAddressType = 4
)

// Enum value maps for SqlIpAddressType.
var (
	SqlIpAddressType_name = map[int32]string{
		0: "SQL_IP_ADDRESS_TYPE_UNSPECIFIED",
		1: "PRIMARY",
		2: "OUTGOING",
		3: "PRIVATE",
		4: "MIGRATED_1ST_GEN",
	}
	SqlIpAddressType_value = map[string]int32{
		"SQL_IP_ADDRESS_TYPE_UNSPECIFIED": 0,
		"PRIMARY":                         1,
		"OUTGOING":                        2,
		"PRIVATE":                         3,
		"MIGRATED_1ST_GEN":                4,
	}
)

func (x SqlIpAddressType) Enum() *SqlIpAddressType {
	p := new(SqlIpAddressType)
	*p = x
	return p
}

func (x SqlIpAddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlIpAddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[2].Descriptor()
}

func (SqlIpAddressType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[2]
}

func (x SqlIpAddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlIpAddressType.Descriptor instead.
func (SqlIpAddressType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{2}
}

// The database engine type and version.
type SqlDatabaseVersion int32

const (
	// This is an unknown database version.
	SqlDatabaseVersion_SQL_DATABASE_VERSION_UNSPECIFIED SqlDatabaseVersion = 0
	// The database version is MySQL 5.1.
	//
	// Deprecated: Do not use.
	SqlDatabaseVersion_MYSQL_5_1 SqlDatabaseVersion = 2
	// The database version is MySQL 5.5.
	//
	// Deprecated: Do not use.
	SqlDatabaseVersion_MYSQL_5_5 SqlDatabaseVersion = 3
	// The database version is MySQL 5.6.
	SqlDatabaseVersion_MYSQL_5_6 SqlDatabaseVersion = 5
	// The database version is MySQL 5.7.
	SqlDatabaseVersion_MYSQL_5_7 SqlDatabaseVersion = 6
	// The database version is PostgreSQL 9.6.
	SqlDatabaseVersion_POSTGRES_9_6 SqlDatabaseVersion = 9
	// The database version is PostgreSQL 11.
	SqlDatabaseVersion_POSTGRES_11 SqlDatabaseVersion = 10
	// The database version is SQL Server 2017 Standard.
	SqlDatabaseVersion_SQLSERVER_2017_STANDARD SqlDatabaseVersion = 11
	// The database version is SQL Server 2017 Enterprise.
	SqlDatabaseVersion_SQLSERVER_2017_ENTERPRISE SqlDatabaseVersion = 14
	// The database version is SQL Server 2017 Express.
	SqlDatabaseVersion_SQLSERVER_2017_EXPRESS SqlDatabaseVersion = 15
	// The database version is SQL Server 2017 Web.
	SqlDatabaseVersion_SQLSERVER_2017_WEB SqlDatabaseVersion = 16
	// The database version is PostgreSQL 10.
	SqlDatabaseVersion_POSTGRES_10 SqlDatabaseVersion = 18
	// The database version is PostgreSQL 12.
	SqlDatabaseVersion_POSTGRES_12 SqlDatabaseVersion = 19
	// The database version is PostgreSQL 13.
	SqlDatabaseVersion_POSTGRES_13 SqlDatabaseVersion = 23
	// The database version is SQL Server 2019 Standard.
	SqlDatabaseVersion_SQLSERVER_2019_STANDARD SqlDatabaseVersion = 26
	// The database version is SQL Server 2019 Enterprise.
	SqlDatabaseVersion_SQLSERVER_2019_ENTERPRISE SqlDatabaseVersion = 27
	// The database version is SQL Server 2019 Express.
	SqlDatabaseVersion_SQLSERVER_2019_EXPRESS SqlDatabaseVersion = 28
	// The database version is SQL Server 2019 Web.
	SqlDatabaseVersion_SQLSERVER_2019_WEB SqlDatabaseVersion = 29
)

// Enum value maps for SqlDatabaseVersion.
var (
	SqlDatabaseVersion_name = map[int32]string{
		0:  "SQL_DATABASE_VERSION_UNSPECIFIED",
		2:  "MYSQL_5_1",
		3:  "MYSQL_5_5",
		5:  "MYSQL_5_6",
		6:  "MYSQL_5_7",
		9:  "POSTGRES_9_6",
		10: "POSTGRES_11",
		11: "SQLSERVER_2017_STANDARD",
		14: "SQLSERVER_2017_ENTERPRISE",
		15: "SQLSERVER_2017_EXPRESS",
		16: "SQLSERVER_2017_WEB",
		18: "POSTGRES_10",
		19: "POSTGRES_12",
		23: "POSTGRES_13",
		26: "SQLSERVER_2019_STANDARD",
		27: "SQLSERVER_2019_ENTERPRISE",
		28: "SQLSERVER_2019_EXPRESS",
		29: "SQLSERVER_2019_WEB",
	}
	SqlDatabaseVersion_value = map[string]int32{
		"SQL_DATABASE_VERSION_UNSPECIFIED": 0,
		"MYSQL_5_1":                        2,
		"MYSQL_5_5":                        3,
		"MYSQL_5_6":                        5,
		"MYSQL_5_7":                        6,
		"POSTGRES_9_6":                     9,
		"POSTGRES_11":                      10,
		"SQLSERVER_2017_STANDARD":          11,
		"SQLSERVER_2017_ENTERPRISE":        14,
		"SQLSERVER_2017_EXPRESS":           15,
		"SQLSERVER_2017_WEB":               16,
		"POSTGRES_10":                      18,
		"POSTGRES_12":                      19,
		"POSTGRES_13":                      23,
		"SQLSERVER_2019_STANDARD":          26,
		"SQLSERVER_2019_ENTERPRISE":        27,
		"SQLSERVER_2019_EXPRESS":           28,
		"SQLSERVER_2019_WEB":               29,
	}
)

func (x SqlDatabaseVersion) Enum() *SqlDatabaseVersion {
	p := new(SqlDatabaseVersion)
	*p = x
	return p
}

func (x SqlDatabaseVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlDatabaseVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[3].Descriptor()
}

func (SqlDatabaseVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[3]
}

func (x SqlDatabaseVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlDatabaseVersion.Descriptor instead.
func (SqlDatabaseVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{3}
}

// The pricing plan for this instance.
type SqlPricingPlan int32

const (
	// This is an unknown pricing plan for this instance.
	SqlPricingPlan_SQL_PRICING_PLAN_UNSPECIFIED SqlPricingPlan = 0
	// The instance is billed at a monthly flat rate.
	SqlPricingPlan_PACKAGE SqlPricingPlan = 1
	// The instance is billed per usage.
	SqlPricingPlan_PER_USE SqlPricingPlan = 2
)

// Enum value maps for SqlPricingPlan.
var (
	SqlPricingPlan_name = map[int32]string{
		0: "SQL_PRICING_PLAN_UNSPECIFIED",
		1: "PACKAGE",
		2: "PER_USE",
	}
	SqlPricingPlan_value = map[string]int32{
		"SQL_PRICING_PLAN_UNSPECIFIED": 0,
		"PACKAGE":                      1,
		"PER_USE":                      2,
	}
)

func (x SqlPricingPlan) Enum() *SqlPricingPlan {
	p := new(SqlPricingPlan)
	*p = x
	return p
}

func (x SqlPricingPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlPricingPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[4].Descriptor()
}

func (SqlPricingPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[4]
}

func (x SqlPricingPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlPricingPlan.Descriptor instead.
func (SqlPricingPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{4}
}

type SqlReplicationType int32

const (
	// This is an unknown replication type for a Cloud SQL instance.
	SqlReplicationType_SQL_REPLICATION_TYPE_UNSPECIFIED SqlReplicationType = 0
	// The synchronous replication mode for First Generation instances. It is the
	// default value.
	SqlReplicationType_SYNCHRONOUS SqlReplicationType = 1
	// The asynchronous replication mode for First Generation instances. It
	// provides a slight performance gain, but if an outage occurs while this
	// option is set to asynchronous, you can lose up to a few seconds of updates
	// to your data.
	SqlReplicationType_ASYNCHRONOUS SqlReplicationType = 2
)

// Enum value maps for SqlReplicationType.
var (
	SqlReplicationType_name = map[int32]string{
		0: "SQL_REPLICATION_TYPE_UNSPECIFIED",
		1: "SYNCHRONOUS",
		2: "ASYNCHRONOUS",
	}
	SqlReplicationType_value = map[string]int32{
		"SQL_REPLICATION_TYPE_UNSPECIFIED": 0,
		"SYNCHRONOUS":                      1,
		"ASYNCHRONOUS":                     2,
	}
)

func (x SqlReplicationType) Enum() *SqlReplicationType {
	p := new(SqlReplicationType)
	*p = x
	return p
}

func (x SqlReplicationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlReplicationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[5].Descriptor()
}

func (SqlReplicationType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[5]
}

func (x SqlReplicationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlReplicationType.Descriptor instead.
func (SqlReplicationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{5}
}

// The type of disk that is used for a v2 instance to use.
type SqlDataDiskType int32

const (
	// This is an unknown data disk type.
	SqlDataDiskType_SQL_DATA_DISK_TYPE_UNSPECIFIED SqlDataDiskType = 0
	// An SSD data disk.
	SqlDataDiskType_PD_SSD SqlDataDiskType = 1
	// An HDD data disk.
	SqlDataDiskType_PD_HDD SqlDataDiskType = 2
	// This field is deprecated and will be removed from a future version of the
	// API.
	//
	// Deprecated: Do not use.
	SqlDataDiskType_OBSOLETE_LOCAL_SSD SqlDataDiskType = 3
)

// Enum value maps for SqlDataDiskType.
var (
	SqlDataDiskType_name = map[int32]string{
		0: "SQL_DATA_DISK_TYPE_UNSPECIFIED",
		1: "PD_SSD",
		2: "PD_HDD",
		3: "OBSOLETE_LOCAL_SSD",
	}
	SqlDataDiskType_value = map[string]int32{
		"SQL_DATA_DISK_TYPE_UNSPECIFIED": 0,
		"PD_SSD":                         1,
		"PD_HDD":                         2,
		"OBSOLETE_LOCAL_SSD":             3,
	}
)

func (x SqlDataDiskType) Enum() *SqlDataDiskType {
	p := new(SqlDataDiskType)
	*p = x
	return p
}

func (x SqlDataDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlDataDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[6].Descriptor()
}

func (SqlDataDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[6]
}

func (x SqlDataDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlDataDiskType.Descriptor instead.
func (SqlDataDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{6}
}

// The availability type of the given Cloud SQL instance.
type SqlAvailabilityType int32

const (
	// This is an unknown Availability type.
	SqlAvailabilityType_SQL_AVAILABILITY_TYPE_UNSPECIFIED SqlAvailabilityType = 0
	// Zonal available instance.
	SqlAvailabilityType_ZONAL SqlAvailabilityType = 1
	// Regional available instance.
	SqlAvailabilityType_REGIONAL SqlAvailabilityType = 2
)

// Enum value maps for SqlAvailabilityType.
var (
	SqlAvailabilityType_name = map[int32]string{
		0: "SQL_AVAILABILITY_TYPE_UNSPECIFIED",
		1: "ZONAL",
		2: "REGIONAL",
	}
	SqlAvailabilityType_value = map[string]int32{
		"SQL_AVAILABILITY_TYPE_UNSPECIFIED": 0,
		"ZONAL":                             1,
		"REGIONAL":                          2,
	}
)

func (x SqlAvailabilityType) Enum() *SqlAvailabilityType {
	p := new(SqlAvailabilityType)
	*p = x
	return p
}

func (x SqlAvailabilityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlAvailabilityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[7].Descriptor()
}

func (SqlAvailabilityType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[7]
}

func (x SqlAvailabilityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlAvailabilityType.Descriptor instead.
func (SqlAvailabilityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{7}
}

type SqlUpdateTrack int32

const (
	// This is an unknown maintenance timing preference.
	SqlUpdateTrack_SQL_UPDATE_TRACK_UNSPECIFIED SqlUpdateTrack = 0
	// For instance update that requires a restart, this update track indicates
	// your instance prefer to restart for new version early in maintenance
	// window.
	SqlUpdateTrack_canary SqlUpdateTrack = 1
	// For instance update that requires a restart, this update track indicates
	// your instance prefer to let Cloud SQL choose the timing of restart (within
	// its Maintenance window, if applicable).
	SqlUpdateTrack_stable SqlUpdateTrack = 2
)

// Enum value maps for SqlUpdateTrack.
var (
	SqlUpdateTrack_name = map[int32]string{
		0: "SQL_UPDATE_TRACK_UNSPECIFIED",
		1: "canary",
		2: "stable",
	}
	SqlUpdateTrack_value = map[string]int32{
		"SQL_UPDATE_TRACK_UNSPECIFIED": 0,
		"canary":                       1,
		"stable":                       2,
	}
)

func (x SqlUpdateTrack) Enum() *SqlUpdateTrack {
	p := new(SqlUpdateTrack)
	*p = x
	return p
}

func (x SqlUpdateTrack) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlUpdateTrack) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[8].Descriptor()
}

func (SqlUpdateTrack) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[8]
}

func (x SqlUpdateTrack) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlUpdateTrack.Descriptor instead.
func (SqlUpdateTrack) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{8}
}

type ApiWarning_SqlApiWarningCode int32

const (
	// An unknown or unset warning type from Cloud SQL API.
	ApiWarning_SQL_API_WARNING_CODE_UNSPECIFIED ApiWarning_SqlApiWarningCode = 0
	// Warning when one or more regions are not reachable.  The returned result
	// set may be incomplete.
	ApiWarning_REGION_UNREACHABLE ApiWarning_SqlApiWarningCode = 1
)

// Enum value maps for ApiWarning_SqlApiWarningCode.
var (
	ApiWarning_SqlApiWarningCode_name = map[int32]string{
		0: "SQL_API_WARNING_CODE_UNSPECIFIED",
		1: "REGION_UNREACHABLE",
	}
	ApiWarning_SqlApiWarningCode_value = map[string]int32{
		"SQL_API_WARNING_CODE_UNSPECIFIED": 0,
		"REGION_UNREACHABLE":               1,
	}
)

func (x ApiWarning_SqlApiWarningCode) Enum() *ApiWarning_SqlApiWarningCode {
	p := new(ApiWarning_SqlApiWarningCode)
	*p = x
	return p
}

func (x ApiWarning_SqlApiWarningCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApiWarning_SqlApiWarningCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[9].Descriptor()
}

func (ApiWarning_SqlApiWarningCode) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[9]
}

func (x ApiWarning_SqlApiWarningCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApiWarning_SqlApiWarningCode.Descriptor instead.
func (ApiWarning_SqlApiWarningCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The units that retained_backups specifies, we only support COUNT.
type BackupRetentionSettings_RetentionUnit int32

const (
	// Backup retention unit is unspecified, will be treated as COUNT.
	BackupRetentionSettings_RETENTION_UNIT_UNSPECIFIED BackupRetentionSettings_RetentionUnit = 0
	// Retention will be by count, eg. "retain the most recent 7 backups".
	BackupRetentionSettings_COUNT BackupRetentionSettings_RetentionUnit = 1
)

// Enum value maps for BackupRetentionSettings_RetentionUnit.
var (
	BackupRetentionSettings_RetentionUnit_name = map[int32]string{
		0: "RETENTION_UNIT_UNSPECIFIED",
		1: "COUNT",
	}
	BackupRetentionSettings_RetentionUnit_value = map[string]int32{
		"RETENTION_UNIT_UNSPECIFIED": 0,
		"COUNT":                      1,
	}
)

func (x BackupRetentionSettings_RetentionUnit) Enum() *BackupRetentionSettings_RetentionUnit {
	p := new(BackupRetentionSettings_RetentionUnit)
	*p = x
	return p
}

func (x BackupRetentionSettings_RetentionUnit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupRetentionSettings_RetentionUnit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[10].Descriptor()
}

func (BackupRetentionSettings_RetentionUnit) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[10]
}

func (x BackupRetentionSettings_RetentionUnit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupRetentionSettings_RetentionUnit.Descriptor instead.
func (BackupRetentionSettings_RetentionUnit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{2, 0}
}

// The type of Cloud SQL operation.
type Operation_SqlOperationType int32

const (
	// Unknown operation type.
	Operation_SQL_OPERATION_TYPE_UNSPECIFIED Operation_SqlOperationType = 0
	// Imports data into a Cloud SQL instance.
	Operation_IMPORT Operation_SqlOperationType = 1
	// Exports data from a Cloud SQL instance to a Cloud Storage
	// bucket.
	Operation_EXPORT Operation_SqlOperationType = 2
	// Creates a new Cloud SQL instance.
	Operation_CREATE Operation_SqlOperationType = 3
	// Updates the settings of a Cloud SQL instance.
	Operation_UPDATE Operation_SqlOperationType = 4
	// Deletes a Cloud SQL instance.
	Operation_DELETE Operation_SqlOperationType = 5
	// Restarts the Cloud SQL instance.
	Operation_RESTART Operation_SqlOperationType = 6
	// Deprecated: Do not use.
	Operation_BACKUP Operation_SqlOperationType = 7
	// Deprecated: Do not use.
	Operation_SNAPSHOT Operation_SqlOperationType = 8
	// Performs instance backup.
	Operation_BACKUP_VOLUME Operation_SqlOperationType = 9
	// Deletes an instance backup.
	Operation_DELETE_VOLUME Operation_SqlOperationType = 10
	// Restores an instance backup.
	Operation_RESTORE_VOLUME Operation_SqlOperationType = 11
	// Injects a privileged user in mysql for MOB instances.
	Operation_INJECT_USER Operation_SqlOperationType = 12
	// Clones a Cloud SQL instance.
	Operation_CLONE Operation_SqlOperationType = 14
	// Stops replication on a Cloud SQL read replica instance.
	Operation_STOP_REPLICA Operation_SqlOperationType = 15
	// Starts replication on a Cloud SQL read replica instance.
	Operation_START_REPLICA Operation_SqlOperationType = 16
	// Promotes a Cloud SQL replica instance.
	Operation_PROMOTE_REPLICA Operation_SqlOperationType = 17
	// Creates a Cloud SQL replica instance.
	Operation_CREATE_REPLICA Operation_SqlOperationType = 18
	// Creates a new user in a Cloud SQL instance.
	Operation_CREATE_USER Operation_SqlOperationType = 19
	// Deletes a user from a Cloud SQL instance.
	Operation_DELETE_USER Operation_SqlOperationType = 20
	// Updates an existing user in a Cloud SQL instance.
	Operation_UPDATE_USER Operation_SqlOperationType = 21
	// Creates a database in the Cloud SQL instance.
	Operation_CREATE_DATABASE Operation_SqlOperationType = 22
	// Deletes a database in the Cloud SQL instance.
	Operation_DELETE_DATABASE Operation_SqlOperationType = 23
	// Updates a database in the Cloud SQL instance.
	Operation_UPDATE_DATABASE Operation_SqlOperationType = 24
	// Performs failover of an HA-enabled Cloud SQL
	// failover replica.
	Operation_FAILOVER Operation_SqlOperationType = 25
	// Deletes the backup taken by a backup run.
	Operation_DELETE_BACKUP    Operation_SqlOperationType = 26
	Operation_RECREATE_REPLICA Operation_SqlOperationType = 27
	// Truncates a general or slow log table in MySQL.
	Operation_TRUNCATE_LOG Operation_SqlOperationType = 28
	// Demotes the stand-alone instance to be a Cloud SQL
	// read replica for an external database server.
	Operation_DEMOTE_MASTER Operation_SqlOperationType = 29
	// Indicates that the instance is currently in maintenance. Maintenance
	// typically causes the instance to be unavailable for 1-3 minutes.
	Operation_MAINTENANCE Operation_SqlOperationType = 30
	// This field is deprecated, and will be removed in future version of API.
	//
	// Deprecated: Do not use.
	Operation_ENABLE_PRIVATE_IP Operation_SqlOperationType = 31
	// Deprecated: Do not use.
	Operation_DEFER_MAINTENANCE Operation_SqlOperationType = 32
	// Creates clone instance.
	//
	// Deprecated: Do not use.
	Operation_CREATE_CLONE Operation_SqlOperationType = 33
	// Reschedule maintenance to another time.
	Operation_RESCHEDULE_MAINTENANCE Operation_SqlOperationType = 34
	// Starts external sync of a Cloud SQL EM replica to an external primary
	// instance.
	Operation_START_EXTERNAL_SYNC Operation_SqlOperationType = 35
)

// Enum value maps for Operation_SqlOperationType.
var (
	Operation_SqlOperationType_name = map[int32]string{
		0:  "SQL_OPERATION_TYPE_UNSPECIFIED",
		1:  "IMPORT",
		2:  "EXPORT",
		3:  "CREATE",
		4:  "UPDATE",
		5:  "DELETE",
		6:  "RESTART",
		7:  "BACKUP",
		8:  "SNAPSHOT",
		9:  "BACKUP_VOLUME",
		10: "DELETE_VOLUME",
		11: "RESTORE_VOLUME",
		12: "INJECT_USER",
		14: "CLONE",
		15: "STOP_REPLICA",
		16: "START_REPLICA",
		17: "PROMOTE_REPLICA",
		18: "CREATE_REPLICA",
		19: "CREATE_USER",
		20: "DELETE_USER",
		21: "UPDATE_USER",
		22: "CREATE_DATABASE",
		23: "DELETE_DATABASE",
		24: "UPDATE_DATABASE",
		25: "FAILOVER",
		26: "DELETE_BACKUP",
		27: "RECREATE_REPLICA",
		28: "TRUNCATE_LOG",
		29: "DEMOTE_MASTER",
		30: "MAINTENANCE",
		31: "ENABLE_PRIVATE_IP",
		32: "DEFER_MAINTENANCE",
		33: "CREATE_CLONE",
		34: "RESCHEDULE_MAINTENANCE",
		35: "START_EXTERNAL_SYNC",
	}
	Operation_SqlOperationType_value = map[string]int32{
		"SQL_OPERATION_TYPE_UNSPECIFIED": 0,
		"IMPORT":                         1,
		"EXPORT":                         2,
		"CREATE":                         3,
		"UPDATE":                         4,
		"DELETE":                         5,
		"RESTART":                        6,
		"BACKUP":                         7,
		"SNAPSHOT":                       8,
		"BACKUP_VOLUME":                  9,
		"DELETE_VOLUME":                  10,
		"RESTORE_VOLUME":                 11,
		"INJECT_USER":                    12,
		"CLONE":                          14,
		"STOP_REPLICA":                   15,
		"START_REPLICA":                  16,
		"PROMOTE_REPLICA":                17,
		"CREATE_REPLICA":                 18,
		"CREATE_USER":                    19,
		"DELETE_USER":                    20,
		"UPDATE_USER":                    21,
		"CREATE_DATABASE":                22,
		"DELETE_DATABASE":                23,
		"UPDATE_DATABASE":                24,
		"FAILOVER":                       25,
		"DELETE_BACKUP":                  26,
		"RECREATE_REPLICA":               27,
		"TRUNCATE_LOG":                   28,
		"DEMOTE_MASTER":                  29,
		"MAINTENANCE":                    30,
		"ENABLE_PRIVATE_IP":              31,
		"DEFER_MAINTENANCE":              32,
		"CREATE_CLONE":                   33,
		"RESCHEDULE_MAINTENANCE":         34,
		"START_EXTERNAL_SYNC":            35,
	}
)

func (x Operation_SqlOperationType) Enum() *Operation_SqlOperationType {
	p := new(Operation_SqlOperationType)
	*p = x
	return p
}

func (x Operation_SqlOperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_SqlOperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[11].Descriptor()
}

func (Operation_SqlOperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[11]
}

func (x Operation_SqlOperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_SqlOperationType.Descriptor instead.
func (Operation_SqlOperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{24, 0}
}

// The status of an operation.
type Operation_SqlOperationStatus int32

const (
	// The state of the operation is unknown.
	Operation_SQL_OPERATION_STATUS_UNSPECIFIED Operation_SqlOperationStatus = 0
	// The operation has been queued, but has not started yet.
	Operation_PENDING Operation_SqlOperationStatus = 1
	// The operation is running.
	Operation_RUNNING Operation_SqlOperationStatus = 2
	// The operation completed.
	Operation_DONE Operation_SqlOperationStatus = 3
)

// Enum value maps for Operation_SqlOperationStatus.
var (
	Operation_SqlOperationStatus_name = map[int32]string{
		0: "SQL_OPERATION_STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
	}
	Operation_SqlOperationStatus_value = map[string]int32{
		"SQL_OPERATION_STATUS_UNSPECIFIED": 0,
		"PENDING":                          1,
		"RUNNING":                          2,
		"DONE":                             3,
	}
)

func (x Operation_SqlOperationStatus) Enum() *Operation_SqlOperationStatus {
	p := new(Operation_SqlOperationStatus)
	*p = x
	return p
}

func (x Operation_SqlOperationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_SqlOperationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[12].Descriptor()
}

func (Operation_SqlOperationStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[12]
}

func (x Operation_SqlOperationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_SqlOperationStatus.Descriptor instead.
func (Operation_SqlOperationStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{24, 1}
}

// Specifies when the instance is activated.
type Settings_SqlActivationPolicy int32

const (
	// Unknown activation plan.
	Settings_SQL_ACTIVATION_POLICY_UNSPECIFIED Settings_SqlActivationPolicy = 0
	// The instance is always up and running.
	Settings_ALWAYS Settings_SqlActivationPolicy = 1
	// The instance never starts.
	Settings_NEVER Settings_SqlActivationPolicy = 2
	// The instance starts upon receiving requests.
	//
	// Deprecated: Do not use.
	Settings_ON_DEMAND Settings_SqlActivationPolicy = 3
)

// Enum value maps for Settings_SqlActivationPolicy.
var (
	Settings_SqlActivationPolicy_name = map[int32]string{
		0: "SQL_ACTIVATION_POLICY_UNSPECIFIED",
		1: "ALWAYS",
		2: "NEVER",
		3: "ON_DEMAND",
	}
	Settings_SqlActivationPolicy_value = map[string]int32{
		"SQL_ACTIVATION_POLICY_UNSPECIFIED": 0,
		"ALWAYS":                            1,
		"NEVER":                             2,
		"ON_DEMAND":                         3,
	}
)

func (x Settings_SqlActivationPolicy) Enum() *Settings_SqlActivationPolicy {
	p := new(Settings_SqlActivationPolicy)
	*p = x
	return p
}

func (x Settings_SqlActivationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Settings_SqlActivationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[13].Descriptor()
}

func (Settings_SqlActivationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes[13]
}

func (x Settings_SqlActivationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Settings_SqlActivationPolicy.Descriptor instead.
func (Settings_SqlActivationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{27, 0}
}

// An entry for an Access Control list.
type AclEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlisted value for the access control list.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The time when this access control entry expires in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Optional. A label to identify this entry.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// This is always **sql#aclEntry**.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *AclEntry) Reset() {
	*x = AclEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AclEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AclEntry) ProtoMessage() {}

func (x *AclEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AclEntry.ProtoReflect.Descriptor instead.
func (*AclEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{0}
}

func (x *AclEntry) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *AclEntry) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *AclEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AclEntry) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// An Admin API warning message.
type ApiWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Code to uniquely identify the warning type.
	Code ApiWarning_SqlApiWarningCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.sql.v1.ApiWarning_SqlApiWarningCode" json:"code,omitempty"`
	// The warning message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The region name for REGION_UNREACHABLE warning.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *ApiWarning) Reset() {
	*x = ApiWarning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiWarning) ProtoMessage() {}

func (x *ApiWarning) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiWarning.ProtoReflect.Descriptor instead.
func (*ApiWarning) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ApiWarning) GetCode() ApiWarning_SqlApiWarningCode {
	if x != nil {
		return x.Code
	}
	return ApiWarning_SQL_API_WARNING_CODE_UNSPECIFIED
}

func (x *ApiWarning) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ApiWarning) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// We currently only support backup retention by specifying the number
// of backups we will retain.
type BackupRetentionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unit that 'retained_backups' represents.
	RetentionUnit BackupRetentionSettings_RetentionUnit `protobuf:"varint,1,opt,name=retention_unit,json=retentionUnit,proto3,enum=google.cloud.sql.v1.BackupRetentionSettings_RetentionUnit" json:"retention_unit,omitempty"`
	// Depending on the value of retention_unit, this is used to determine
	// if a backup needs to be deleted.  If retention_unit is 'COUNT', we will
	// retain this many backups.
	RetainedBackups *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=retained_backups,json=retainedBackups,proto3" json:"retained_backups,omitempty"`
}

func (x *BackupRetentionSettings) Reset() {
	*x = BackupRetentionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRetentionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRetentionSettings) ProtoMessage() {}

func (x *BackupRetentionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRetentionSettings.ProtoReflect.Descriptor instead.
func (*BackupRetentionSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{2}
}

func (x *BackupRetentionSettings) GetRetentionUnit() BackupRetentionSettings_RetentionUnit {
	if x != nil {
		return x.RetentionUnit
	}
	return BackupRetentionSettings_RETENTION_UNIT_UNSPECIFIED
}

func (x *BackupRetentionSettings) GetRetainedBackups() *wrapperspb.Int32Value {
	if x != nil {
		return x.RetainedBackups
	}
	return nil
}

// Database instance backup configuration.
type BackupConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time for the daily backup configuration in UTC timezone in the 24
	// hour format - **HH:MM**.
	StartTime string `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Whether this configuration is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// This is always **sql#backupConfiguration**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// (MySQL only) Whether binary log is enabled. If backup configuration is
	// disabled, binarylog must be disabled as well.
	BinaryLogEnabled *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=binary_log_enabled,json=binaryLogEnabled,proto3" json:"binary_log_enabled,omitempty"`
	// Reserved for future use.
	ReplicationLogArchivingEnabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=replication_log_archiving_enabled,json=replicationLogArchivingEnabled,proto3" json:"replication_log_archiving_enabled,omitempty"`
	// Location of the backup
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// (Postgres only) Whether point in time recovery is enabled.
	PointInTimeRecoveryEnabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=point_in_time_recovery_enabled,json=pointInTimeRecoveryEnabled,proto3" json:"point_in_time_recovery_enabled,omitempty"`
	// Backup retention settings.
	BackupRetentionSettings *BackupRetentionSettings `protobuf:"bytes,8,opt,name=backup_retention_settings,json=backupRetentionSettings,proto3" json:"backup_retention_settings,omitempty"`
	// The number of days of transaction logs we retain for point in time
	// restore, from 1-7.
	TransactionLogRetentionDays *wrapperspb.Int32Value `protobuf:"bytes,9,opt,name=transaction_log_retention_days,json=transactionLogRetentionDays,proto3" json:"transaction_log_retention_days,omitempty"`
}

func (x *BackupConfiguration) Reset() {
	*x = BackupConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupConfiguration) ProtoMessage() {}

func (x *BackupConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupConfiguration.ProtoReflect.Descriptor instead.
func (*BackupConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{3}
}

func (x *BackupConfiguration) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *BackupConfiguration) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *BackupConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupConfiguration) GetBinaryLogEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.BinaryLogEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetReplicationLogArchivingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.ReplicationLogArchivingEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *BackupConfiguration) GetPointInTimeRecoveryEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.PointInTimeRecoveryEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetBackupRetentionSettings() *BackupRetentionSettings {
	if x != nil {
		return x.BackupRetentionSettings
	}
	return nil
}

func (x *BackupConfiguration) GetTransactionLogRetentionDays() *wrapperspb.Int32Value {
	if x != nil {
		return x.TransactionLogRetentionDays
	}
	return nil
}

// Backup context.
type BackupContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the backup.
	BackupId int64 `protobuf:"varint,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// This is always **sql#backupContext**.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *BackupContext) Reset() {
	*x = BackupContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupContext) ProtoMessage() {}

func (x *BackupContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupContext.ProtoReflect.Descriptor instead.
func (*BackupContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{4}
}

func (x *BackupContext) GetBackupId() int64 {
	if x != nil {
		return x.BackupId
	}
	return 0
}

func (x *BackupContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Represents a SQL database on the Cloud SQL instance.
type Database struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#database**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The Cloud SQL charset value.
	Charset string `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// The Cloud SQL collation value.
	Collation string `protobuf:"bytes,3,opt,name=collation,proto3" json:"collation,omitempty"`
	// This field is deprecated and will be removed from a future version of the
	// API.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// The name of the database in the Cloud SQL instance. This does not include
	// the project ID or instance name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the Cloud SQL instance. This does not include the project ID.
	Instance string `protobuf:"bytes,6,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,7,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The project ID of the project containing the Cloud SQL database. The Google
	// apps domain is prefixed if applicable.
	Project string `protobuf:"bytes,8,opt,name=project,proto3" json:"project,omitempty"`
	// Types that are assignable to DatabaseDetails:
	//	*Database_SqlserverDatabaseDetails
	DatabaseDetails isDatabase_DatabaseDetails `protobuf_oneof:"database_details"`
}

func (x *Database) Reset() {
	*x = Database{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Database) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Database) ProtoMessage() {}

func (x *Database) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Database.ProtoReflect.Descriptor instead.
func (*Database) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{5}
}

func (x *Database) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Database) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *Database) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *Database) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Database) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Database) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *Database) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Database) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (m *Database) GetDatabaseDetails() isDatabase_DatabaseDetails {
	if m != nil {
		return m.DatabaseDetails
	}
	return nil
}

func (x *Database) GetSqlserverDatabaseDetails() *SqlServerDatabaseDetails {
	if x, ok := x.GetDatabaseDetails().(*Database_SqlserverDatabaseDetails); ok {
		return x.SqlserverDatabaseDetails
	}
	return nil
}

type isDatabase_DatabaseDetails interface {
	isDatabase_DatabaseDetails()
}

type Database_SqlserverDatabaseDetails struct {
	SqlserverDatabaseDetails *SqlServerDatabaseDetails `protobuf:"bytes,9,opt,name=sqlserver_database_details,json=sqlserverDatabaseDetails,proto3,oneof"`
}

func (*Database_SqlserverDatabaseDetails) isDatabase_DatabaseDetails() {}

// Represents a Sql Server database on the Cloud SQL instance.
type SqlServerDatabaseDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of SQL Server with which the database is to be made compatible
	CompatibilityLevel int32 `protobuf:"varint,1,opt,name=compatibility_level,json=compatibilityLevel,proto3" json:"compatibility_level,omitempty"`
	// The recovery model of a SQL Server database
	RecoveryModel string `protobuf:"bytes,2,opt,name=recovery_model,json=recoveryModel,proto3" json:"recovery_model,omitempty"`
}

func (x *SqlServerDatabaseDetails) Reset() {
	*x = SqlServerDatabaseDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlServerDatabaseDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlServerDatabaseDetails) ProtoMessage() {}

func (x *SqlServerDatabaseDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlServerDatabaseDetails.ProtoReflect.Descriptor instead.
func (*SqlServerDatabaseDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{6}
}

func (x *SqlServerDatabaseDetails) GetCompatibilityLevel() int32 {
	if x != nil {
		return x.CompatibilityLevel
	}
	return 0
}

func (x *SqlServerDatabaseDetails) GetRecoveryModel() string {
	if x != nil {
		return x.RecoveryModel
	}
	return ""
}

// Database flags for Cloud SQL instances.
type DatabaseFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flag. These flags are passed at instance startup, so
	// include both server options and system variables. Flags are
	// specified with underscores, not hyphens. For more information, see
	// [Configuring Database Flags](https://cloud.google.com/sql/docs/mysql/flags)
	// in the Cloud SQL documentation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the flag. Booleans are set to **on** for true
	// and **off** for false. This field must be omitted if the flag
	// doesn't take a value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DatabaseFlags) Reset() {
	*x = DatabaseFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseFlags) ProtoMessage() {}

func (x *DatabaseFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseFlags.ProtoReflect.Descriptor instead.
func (*DatabaseFlags) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{7}
}

func (x *DatabaseFlags) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseFlags) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// MySQL-specific external server sync settings.
type MySqlSyncConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Flags to use for the initial dump.
	InitialSyncFlags []*SyncFlags `protobuf:"bytes,1,rep,name=initial_sync_flags,json=initialSyncFlags,proto3" json:"initial_sync_flags,omitempty"`
}

func (x *MySqlSyncConfig) Reset() {
	*x = MySqlSyncConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlSyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlSyncConfig) ProtoMessage() {}

func (x *MySqlSyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlSyncConfig.ProtoReflect.Descriptor instead.
func (*MySqlSyncConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{8}
}

func (x *MySqlSyncConfig) GetInitialSyncFlags() []*SyncFlags {
	if x != nil {
		return x.InitialSyncFlags
	}
	return nil
}

// Initial sync flags for certain Cloud SQL APIs.
// Currently used for the MySQL external server initial dump.
type SyncFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flag.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the flag. This field must be omitted if the flag
	// doesn't take a value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *SyncFlags) Reset() {
	*x = SyncFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFlags) ProtoMessage() {}

func (x *SyncFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFlags.ProtoReflect.Descriptor instead.
func (*SyncFlags) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{9}
}

func (x *SyncFlags) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SyncFlags) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Reference to another Cloud SQL instance.
type InstanceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Cloud SQL instance being referenced.
	// This does not include the project ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The region of the Cloud SQL instance being referenced.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// The project ID of the Cloud SQL instance being referenced.
	// The default is the same project ID as the instance references it.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *InstanceReference) Reset() {
	*x = InstanceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceReference) ProtoMessage() {}

func (x *InstanceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceReference.ProtoReflect.Descriptor instead.
func (*InstanceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{10}
}

func (x *InstanceReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstanceReference) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *InstanceReference) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Read-replica configuration for connecting to the on-premises primary
// instance.
type DemoteMasterConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#demoteMasterConfiguration**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// MySQL specific configuration when replicating from a MySQL on-premises
	// primary instance. Replication configuration information such as the
	// username, password, certificates, and keys are not stored in the instance
	// metadata. The configuration information is used only to set up the
	// replication connection and is stored by MySQL in a file named
	// **master.info** in the data directory.
	MysqlReplicaConfiguration *DemoteMasterMySqlReplicaConfiguration `protobuf:"bytes,2,opt,name=mysql_replica_configuration,json=mysqlReplicaConfiguration,proto3" json:"mysql_replica_configuration,omitempty"`
}

func (x *DemoteMasterConfiguration) Reset() {
	*x = DemoteMasterConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterConfiguration) ProtoMessage() {}

func (x *DemoteMasterConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterConfiguration.ProtoReflect.Descriptor instead.
func (*DemoteMasterConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{11}
}

func (x *DemoteMasterConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterConfiguration) GetMysqlReplicaConfiguration() *DemoteMasterMySqlReplicaConfiguration {
	if x != nil {
		return x.MysqlReplicaConfiguration
	}
	return nil
}

// Read-replica configuration specific to MySQL databases.
type DemoteMasterMySqlReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#demoteMasterMysqlReplicaConfiguration**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The username for the replication connection.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the replication connection.
	Password string `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate. The format of the replica's
	// private key can be either PKCS #1 or PKCS #8.
	ClientKey string `protobuf:"bytes,4,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,5,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,6,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
}

func (x *DemoteMasterMySqlReplicaConfiguration) Reset() {
	*x = DemoteMasterMySqlReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterMySqlReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterMySqlReplicaConfiguration) ProtoMessage() {}

func (x *DemoteMasterMySqlReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterMySqlReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*DemoteMasterMySqlReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{12}
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

// Database instance export context.
type ExportContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the file in Google Cloud Storage where the export will be
	// stored. The URI is in the form **gs://bucketName/fileName**. If the file
	// already exists, the request succeeds, but the operation fails. If
	// **fileType** is **SQL** and the filename ends with .gz,
	// the contents are compressed.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Databases to be exported.
	// *  **MySQL instances:** If **fileType** is **SQL** and no database is
	// specified, all databases are exported, except for the **mysql** system
	// database. If **fileType** is **CSV**, you can specify one database,
	// either by using this property or by using the
	// **csvExportOptions.selectQuery** property, which takes precedence
	// over this property.
	// *  **PostgreSQL instances:** You must specify one database to be exported.
	// If **fileType** is **CSV**, this database must match the one specified in
	// the **csvExportOptions.selectQuery** property.
	// *  **SQL Server instances:** You must specify one database to be exported,
	// and the **fileType** must be **BAK**.
	Databases []string `protobuf:"bytes,2,rep,name=databases,proto3" json:"databases,omitempty"`
	// This is always **sql#exportContext**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// Options for exporting data as SQL statements.
	SqlExportOptions *ExportContext_SqlExportOptions `protobuf:"bytes,4,opt,name=sql_export_options,json=sqlExportOptions,proto3" json:"sql_export_options,omitempty"`
	// Options for exporting data as CSV. **MySQL** and **PostgreSQL**
	// instances only.
	CsvExportOptions *ExportContext_SqlCsvExportOptions `protobuf:"bytes,5,opt,name=csv_export_options,json=csvExportOptions,proto3" json:"csv_export_options,omitempty"`
	// The file type for the specified uri.
	// *  **SQL**: The file contains SQL statements.
	// *  **CSV**: The file contains CSV data.
	// *  **BAK**: The file contains backup data for a SQL Server instance.
	FileType SqlFileType `protobuf:"varint,6,opt,name=file_type,json=fileType,proto3,enum=google.cloud.sql.v1.SqlFileType" json:"file_type,omitempty"`
	// Option for export offload.
	Offload *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=offload,proto3" json:"offload,omitempty"`
}

func (x *ExportContext) Reset() {
	*x = ExportContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext) ProtoMessage() {}

func (x *ExportContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext.ProtoReflect.Descriptor instead.
func (*ExportContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{13}
}

func (x *ExportContext) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ExportContext) GetDatabases() []string {
	if x != nil {
		return x.Databases
	}
	return nil
}

func (x *ExportContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ExportContext) GetSqlExportOptions() *ExportContext_SqlExportOptions {
	if x != nil {
		return x.SqlExportOptions
	}
	return nil
}

func (x *ExportContext) GetCsvExportOptions() *ExportContext_SqlCsvExportOptions {
	if x != nil {
		return x.CsvExportOptions
	}
	return nil
}

func (x *ExportContext) GetFileType() SqlFileType {
	if x != nil {
		return x.FileType
	}
	return SqlFileType_SQL_FILE_TYPE_UNSPECIFIED
}

func (x *ExportContext) GetOffload() *wrapperspb.BoolValue {
	if x != nil {
		return x.Offload
	}
	return nil
}

// Database instance import context.
type ImportContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the import file in Cloud Storage, in the form
	// **gs://bucketName/fileName**. Compressed gzip files (.gz) are supported
	// when **fileType** is **SQL**. The instance must have
	// write permissions to the bucket and read access to the file.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The target database for the import. If **fileType** is **SQL**, this field
	// is required only if the import file does not specify a database, and is
	// overridden by any database specification in the import file. If
	// **fileType** is **CSV**, one database must be specified.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// This is always **sql#importContext**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// The file type for the specified uri. <br>**SQL**: The file
	// contains SQL statements. <br>**CSV**: The file contains CSV data.
	FileType SqlFileType `protobuf:"varint,4,opt,name=file_type,json=fileType,proto3,enum=google.cloud.sql.v1.SqlFileType" json:"file_type,omitempty"`
	// Options for importing data as CSV.
	CsvImportOptions *ImportContext_SqlCsvImportOptions `protobuf:"bytes,5,opt,name=csv_import_options,json=csvImportOptions,proto3" json:"csv_import_options,omitempty"`
	// The PostgreSQL user for this import operation. PostgreSQL instances only.
	ImportUser string `protobuf:"bytes,6,opt,name=import_user,json=importUser,proto3" json:"import_user,omitempty"`
	// Import parameters specific to SQL Server .BAK files
	BakImportOptions *ImportContext_SqlBakImportOptions `protobuf:"bytes,7,opt,name=bak_import_options,json=bakImportOptions,proto3" json:"bak_import_options,omitempty"`
}

func (x *ImportContext) Reset() {
	*x = ImportContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext) ProtoMessage() {}

func (x *ImportContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext.ProtoReflect.Descriptor instead.
func (*ImportContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{14}
}

func (x *ImportContext) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ImportContext) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *ImportContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ImportContext) GetFileType() SqlFileType {
	if x != nil {
		return x.FileType
	}
	return SqlFileType_SQL_FILE_TYPE_UNSPECIFIED
}

func (x *ImportContext) GetCsvImportOptions() *ImportContext_SqlCsvImportOptions {
	if x != nil {
		return x.CsvImportOptions
	}
	return nil
}

func (x *ImportContext) GetImportUser() string {
	if x != nil {
		return x.ImportUser
	}
	return ""
}

func (x *ImportContext) GetBakImportOptions() *ImportContext_SqlBakImportOptions {
	if x != nil {
		return x.BakImportOptions
	}
	return nil
}

// IP Management configuration.
type IpConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the instance is assigned a public IP address or not.
	Ipv4Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=ipv4_enabled,json=ipv4Enabled,proto3" json:"ipv4_enabled,omitempty"`
	// The resource link for the VPC network from which the Cloud SQL instance is
	// accessible for private IP. For example,
	// **/projects/myProject/global/networks/default**. This setting can
	// be updated, but it cannot be removed after it is set.
	PrivateNetwork string `protobuf:"bytes,2,opt,name=private_network,json=privateNetwork,proto3" json:"private_network,omitempty"`
	// Whether SSL connections over IP are enforced or not.
	RequireSsl *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=require_ssl,json=requireSsl,proto3" json:"require_ssl,omitempty"`
	// The list of external networks that are allowed to connect to the instance
	// using the IP. In 'CIDR' notation, also known as 'slash' notation (for
	// example: **192.168.100.0/24**).
	AuthorizedNetworks []*AclEntry `protobuf:"bytes,4,rep,name=authorized_networks,json=authorizedNetworks,proto3" json:"authorized_networks,omitempty"`
	// The name of the allocated ip range for the private ip CloudSQL instance.
	// For example: "google-managed-services-default". If set, the instance ip
	// will be created in the allocated range. The range name must comply with
	// [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name
	// must be 1-63 characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?.`
	// Reserved for future use.
	AllocatedIpRange string `protobuf:"bytes,6,opt,name=allocated_ip_range,json=allocatedIpRange,proto3" json:"allocated_ip_range,omitempty"`
}

func (x *IpConfiguration) Reset() {
	*x = IpConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IpConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpConfiguration) ProtoMessage() {}

func (x *IpConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpConfiguration.ProtoReflect.Descriptor instead.
func (*IpConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{15}
}

func (x *IpConfiguration) GetIpv4Enabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Ipv4Enabled
	}
	return nil
}

func (x *IpConfiguration) GetPrivateNetwork() string {
	if x != nil {
		return x.PrivateNetwork
	}
	return ""
}

func (x *IpConfiguration) GetRequireSsl() *wrapperspb.BoolValue {
	if x != nil {
		return x.RequireSsl
	}
	return nil
}

func (x *IpConfiguration) GetAuthorizedNetworks() []*AclEntry {
	if x != nil {
		return x.AuthorizedNetworks
	}
	return nil
}

func (x *IpConfiguration) GetAllocatedIpRange() string {
	if x != nil {
		return x.AllocatedIpRange
	}
	return ""
}

// Preferred location. This specifies where a Cloud SQL instance is located.
// Note that if the preferred location is not available, the instance will be
// located as close as possible within the region. Only one location may be
// specified.
type LocationPreference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The App Engine application to follow, it must be in the same region as the
	// Cloud SQL instance.
	//
	// Deprecated: Do not use.
	FollowGaeApplication string `protobuf:"bytes,1,opt,name=follow_gae_application,json=followGaeApplication,proto3" json:"follow_gae_application,omitempty"`
	// The preferred Compute Engine zone (for example: us-central1-a,
	// us-central1-b, etc.).
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The preferred Compute Engine zone for the secondary/failover
	// (for example: us-central1-a, us-central1-b, etc.).
	// Reserved for future use.
	SecondaryZone string `protobuf:"bytes,4,opt,name=secondary_zone,json=secondaryZone,proto3" json:"secondary_zone,omitempty"`
	// This is always **sql#locationPreference**.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *LocationPreference) Reset() {
	*x = LocationPreference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationPreference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationPreference) ProtoMessage() {}

func (x *LocationPreference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationPreference.ProtoReflect.Descriptor instead.
func (*LocationPreference) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{16}
}

// Deprecated: Do not use.
func (x *LocationPreference) GetFollowGaeApplication() string {
	if x != nil {
		return x.FollowGaeApplication
	}
	return ""
}

func (x *LocationPreference) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *LocationPreference) GetSecondaryZone() string {
	if x != nil {
		return x.SecondaryZone
	}
	return ""
}

func (x *LocationPreference) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Maintenance window. This specifies when a Cloud SQL instance is
// restarted for system maintenance purposes.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// hour of day - 0 to 23.
	Hour *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=hour,proto3" json:"hour,omitempty"`
	// day of week (1-7), starting on Monday.
	Day *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=day,proto3" json:"day,omitempty"`
	// Maintenance timing setting: **canary** (Earlier) or **stable** (Later).
	// [Learn
	// more](https://cloud.google.com/sql/docs/mysql/instance-settings#maintenance-timing-2ndgen).
	UpdateTrack SqlUpdateTrack `protobuf:"varint,3,opt,name=update_track,json=updateTrack,proto3,enum=google.cloud.sql.v1.SqlUpdateTrack" json:"update_track,omitempty"`
	// This is always **sql#maintenanceWindow**.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{17}
}

func (x *MaintenanceWindow) GetHour() *wrapperspb.Int32Value {
	if x != nil {
		return x.Hour
	}
	return nil
}

func (x *MaintenanceWindow) GetDay() *wrapperspb.Int32Value {
	if x != nil {
		return x.Day
	}
	return nil
}

func (x *MaintenanceWindow) GetUpdateTrack() SqlUpdateTrack {
	if x != nil {
		return x.UpdateTrack
	}
	return SqlUpdateTrack_SQL_UPDATE_TRACK_UNSPECIFIED
}

func (x *MaintenanceWindow) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Deny maintenance Periods. This specifies a date range during when all CSA
// rollout will be denied.
type DenyMaintenancePeriod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// "deny maintenance period" start date. If the year of the start date is
	// empty, the year of the end date also must be empty. In this case, it means
	// the deny maintenance period recurs every year. The date is in format
	// yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
	StartDate string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// "deny maintenance period" end date. If the year of the end date is empty,
	// the year of the start date also must be empty. In this case, it means the
	// no maintenance interval recurs every year. The date is in format yyyy-mm-dd
	// i.e., 2020-11-01, or mm-dd, i.e., 11-01
	EndDate string `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Time in UTC when the "deny maintenance period" starts on start_date and
	// ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
	Time string `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DenyMaintenancePeriod) Reset() {
	*x = DenyMaintenancePeriod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyMaintenancePeriod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyMaintenancePeriod) ProtoMessage() {}

func (x *DenyMaintenancePeriod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyMaintenancePeriod.ProtoReflect.Descriptor instead.
func (*DenyMaintenancePeriod) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{18}
}

func (x *DenyMaintenancePeriod) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *DenyMaintenancePeriod) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

func (x *DenyMaintenancePeriod) GetTime() string {
	if x != nil {
		return x.Time
	}
	return ""
}

// Insights configuration. This specifies when Cloud SQL Insights feature is
// enabled and optional configuration.
type InsightsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Query Insights feature is enabled.
	QueryInsightsEnabled bool `protobuf:"varint,1,opt,name=query_insights_enabled,json=queryInsightsEnabled,proto3" json:"query_insights_enabled,omitempty"`
	// Whether Query Insights will record client address when enabled.
	RecordClientAddress bool `protobuf:"varint,2,opt,name=record_client_address,json=recordClientAddress,proto3" json:"record_client_address,omitempty"`
	// Whether Query Insights will record application tags from query when
	// enabled.
	RecordApplicationTags bool `protobuf:"varint,3,opt,name=record_application_tags,json=recordApplicationTags,proto3" json:"record_application_tags,omitempty"`
	// Maximum query length stored in bytes. Default value: 1024 bytes.
	// Range: 256-4500 bytes. Query length more than this field value will be
	// truncated to this value. When unset, query length will be the default
	// value. Changing query length will restart the database.
	QueryStringLength *wrapperspb.Int32Value `protobuf:"bytes,4,opt,name=query_string_length,json=queryStringLength,proto3" json:"query_string_length,omitempty"`
	// Number of query execution plans captured by Insights per minute
	// for all queries combined. Default is 5.
	QueryPlansPerMinute *wrapperspb.Int32Value `protobuf:"bytes,5,opt,name=query_plans_per_minute,json=queryPlansPerMinute,proto3" json:"query_plans_per_minute,omitempty"`
}

func (x *InsightsConfig) Reset() {
	*x = InsightsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsightsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsightsConfig) ProtoMessage() {}

func (x *InsightsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsightsConfig.ProtoReflect.Descriptor instead.
func (*InsightsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{19}
}

func (x *InsightsConfig) GetQueryInsightsEnabled() bool {
	if x != nil {
		return x.QueryInsightsEnabled
	}
	return false
}

func (x *InsightsConfig) GetRecordClientAddress() bool {
	if x != nil {
		return x.RecordClientAddress
	}
	return false
}

func (x *InsightsConfig) GetRecordApplicationTags() bool {
	if x != nil {
		return x.RecordApplicationTags
	}
	return false
}

func (x *InsightsConfig) GetQueryStringLength() *wrapperspb.Int32Value {
	if x != nil {
		return x.QueryStringLength
	}
	return nil
}

func (x *InsightsConfig) GetQueryPlansPerMinute() *wrapperspb.Int32Value {
	if x != nil {
		return x.QueryPlansPerMinute
	}
	return nil
}

// Read-replica configuration specific to MySQL databases.
type MySqlReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to a SQL dump file in Google Cloud Storage from which the replica
	// instance is to be created. The URI is in the form gs://bucketName/fileName.
	// Compressed gzip files (.gz) are also supported.
	// Dumps have the binlog co-ordinates from which replication
	// begins. This can be accomplished by setting --master-data to 1 when using
	// mysqldump.
	DumpFilePath string `protobuf:"bytes,1,opt,name=dump_file_path,json=dumpFilePath,proto3" json:"dump_file_path,omitempty"`
	// The username for the replication connection.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the replication connection.
	Password string `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// Seconds to wait between connect retries. MySQL's default is 60 seconds.
	ConnectRetryInterval *wrapperspb.Int32Value `protobuf:"bytes,4,opt,name=connect_retry_interval,json=connectRetryInterval,proto3" json:"connect_retry_interval,omitempty"`
	// Interval in milliseconds between replication heartbeats.
	MasterHeartbeatPeriod *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=master_heartbeat_period,json=masterHeartbeatPeriod,proto3" json:"master_heartbeat_period,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,6,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,7,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate.
	ClientKey string `protobuf:"bytes,8,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// A list of permissible ciphers to use for SSL encryption.
	SslCipher string `protobuf:"bytes,9,opt,name=ssl_cipher,json=sslCipher,proto3" json:"ssl_cipher,omitempty"`
	// Whether or not to check the primary instance's Common Name value in the
	// certificate that it sends during the SSL handshake.
	VerifyServerCertificate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=verify_server_certificate,json=verifyServerCertificate,proto3" json:"verify_server_certificate,omitempty"`
	// This is always **sql#mysqlReplicaConfiguration**.
	Kind string `protobuf:"bytes,11,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *MySqlReplicaConfiguration) Reset() {
	*x = MySqlReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlReplicaConfiguration) ProtoMessage() {}

func (x *MySqlReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*MySqlReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{20}
}

func (x *MySqlReplicaConfiguration) GetDumpFilePath() string {
	if x != nil {
		return x.DumpFilePath
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetConnectRetryInterval() *wrapperspb.Int32Value {
	if x != nil {
		return x.ConnectRetryInterval
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetMasterHeartbeatPeriod() *wrapperspb.Int64Value {
	if x != nil {
		return x.MasterHeartbeatPeriod
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetSslCipher() string {
	if x != nil {
		return x.SslCipher
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetVerifyServerCertificate() *wrapperspb.BoolValue {
	if x != nil {
		return x.VerifyServerCertificate
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Disk encryption configuration for an instance.
type DiskEncryptionConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of KMS key for disk encryption
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// This is always **sql#diskEncryptionConfiguration**.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *DiskEncryptionConfiguration) Reset() {
	*x = DiskEncryptionConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEncryptionConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEncryptionConfiguration) ProtoMessage() {}

func (x *DiskEncryptionConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEncryptionConfiguration.ProtoReflect.Descriptor instead.
func (*DiskEncryptionConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{21}
}

func (x *DiskEncryptionConfiguration) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *DiskEncryptionConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Disk encryption status for an instance.
type DiskEncryptionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// KMS key version used to encrypt the Cloud SQL instance resource
	KmsKeyVersionName string `protobuf:"bytes,1,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// This is always **sql#diskEncryptionStatus**.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *DiskEncryptionStatus) Reset() {
	*x = DiskEncryptionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEncryptionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEncryptionStatus) ProtoMessage() {}

func (x *DiskEncryptionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEncryptionStatus.ProtoReflect.Descriptor instead.
func (*DiskEncryptionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{22}
}

func (x *DiskEncryptionStatus) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (x *DiskEncryptionStatus) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Database instance IP Mapping.
type IpMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of this IP address. A **PRIMARY** address is a public address that
	// can accept incoming connections. A **PRIVATE** address is a private address
	// that can accept incoming connections. An **OUTGOING** address is the source
	// address of connections originating from the instance, if supported.
	Type SqlIpAddressType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.sql.v1.SqlIpAddressType" json:"type,omitempty"`
	// The IP address assigned.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// The due time for this IP to be retired in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**. This field is only available when
	// the IP is scheduled to be retired.
	TimeToRetire *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=time_to_retire,json=timeToRetire,proto3" json:"time_to_retire,omitempty"`
}

func (x *IpMapping) Reset() {
	*x = IpMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IpMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpMapping) ProtoMessage() {}

func (x *IpMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpMapping.ProtoReflect.Descriptor instead.
func (*IpMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{23}
}

func (x *IpMapping) GetType() SqlIpAddressType {
	if x != nil {
		return x.Type
	}
	return SqlIpAddressType_SQL_IP_ADDRESS_TYPE_UNSPECIFIED
}

func (x *IpMapping) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *IpMapping) GetTimeToRetire() *timestamppb.Timestamp {
	if x != nil {
		return x.TimeToRetire
	}
	return nil
}

// An Operation resource.&nbsp;For successful operations that return an
// Operation resource, only the fields relevant to the operation are populated
// in the resource.
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#operation**.
	Kind       string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	TargetLink string `protobuf:"bytes,2,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// The status of an operation. Valid values are:
	// *  **PENDING**
	// *  **RUNNING**
	// *  **DONE**
	// *  **SQL_OPERATION_STATUS_UNSPECIFIED**
	Status Operation_SqlOperationStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.cloud.sql.v1.Operation_SqlOperationStatus" json:"status,omitempty"`
	// The email address of the user who initiated this operation.
	User string `protobuf:"bytes,4,opt,name=user,proto3" json:"user,omitempty"`
	// The time this operation was enqueued in UTC timezone in [RFC
	// 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	InsertTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=insert_time,json=insertTime,proto3" json:"insert_time,omitempty"`
	// The time this operation actually started in UTC timezone in [RFC
	// 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation finished in UTC timezone in [RFC
	// 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// If errors occurred during processing of this operation, this field will be
	// populated.
	Error *OperationErrors `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// The type of the operation. Valid values are:
	// *  **CREATE**
	// *  **DELETE**
	// *  **UPDATE**
	// *  **RESTART**
	// *  **IMPORT**
	// *  **EXPORT**
	// *  **BACKUP_VOLUME**
	// *  **RESTORE_VOLUME**
	// *  **CREATE_USER**
	// *  **DELETE_USER**
	// *  **CREATE_DATABASE**
	// *  **DELETE_DATABASE**
	OperationType Operation_SqlOperationType `protobuf:"varint,9,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.sql.v1.Operation_SqlOperationType" json:"operation_type,omitempty"`
	// The context for import operation, if applicable.
	ImportContext *ImportContext `protobuf:"bytes,10,opt,name=import_context,json=importContext,proto3" json:"import_context,omitempty"`
	// The context for export operation, if applicable.
	ExportContext *ExportContext `protobuf:"bytes,11,opt,name=export_context,json=exportContext,proto3" json:"export_context,omitempty"`
	// The context for backup operation, if applicable.
	BackupContext *BackupContext `protobuf:"bytes,17,opt,name=backup_context,json=backupContext,proto3" json:"backup_context,omitempty"`
	// An identifier that uniquely identifies the operation. You can use this
	// identifier to retrieve the Operations resource that has information about
	// the operation.
	Name string `protobuf:"bytes,12,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the database instance related to this operation.
	TargetId string `protobuf:"bytes,13,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,14,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The project ID of the target instance related to this operation.
	TargetProject string `protobuf:"bytes,15,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{24}
}

func (x *Operation) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Operation) GetTargetLink() string {
	if x != nil {
		return x.TargetLink
	}
	return ""
}

func (x *Operation) GetStatus() Operation_SqlOperationStatus {
	if x != nil {
		return x.Status
	}
	return Operation_SQL_OPERATION_STATUS_UNSPECIFIED
}

func (x *Operation) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *Operation) GetInsertTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InsertTime
	}
	return nil
}

func (x *Operation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Operation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Operation) GetError() *OperationErrors {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Operation) GetOperationType() Operation_SqlOperationType {
	if x != nil {
		return x.OperationType
	}
	return Operation_SQL_OPERATION_TYPE_UNSPECIFIED
}

func (x *Operation) GetImportContext() *ImportContext {
	if x != nil {
		return x.ImportContext
	}
	return nil
}

func (x *Operation) GetExportContext() *ExportContext {
	if x != nil {
		return x.ExportContext
	}
	return nil
}

func (x *Operation) GetBackupContext() *BackupContext {
	if x != nil {
		return x.BackupContext
	}
	return nil
}

func (x *Operation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Operation) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Operation) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Operation) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

// Database instance operation error.
type OperationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#operationError**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Identifies the specific error that occurred.
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
	// Additional information about the error encountered.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *OperationError) Reset() {
	*x = OperationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationError) ProtoMessage() {}

func (x *OperationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationError.ProtoReflect.Descriptor instead.
func (*OperationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{25}
}

func (x *OperationError) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OperationError) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *OperationError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Database instance operation errors list wrapper.
type OperationErrors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#operationErrors**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The list of errors encountered while processing this operation.
	Errors []*OperationError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *OperationErrors) Reset() {
	*x = OperationErrors{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationErrors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationErrors) ProtoMessage() {}

func (x *OperationErrors) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationErrors.ProtoReflect.Descriptor instead.
func (*OperationErrors) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{26}
}

func (x *OperationErrors) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OperationErrors) GetErrors() []*OperationError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Database instance settings.
type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of instance settings. This is a required field for update
	// method to make sure concurrent updates are handled properly. During update,
	// use the most recent settingsVersion value for this instance and do not try
	// to update this value.
	SettingsVersion *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=settings_version,json=settingsVersion,proto3" json:"settings_version,omitempty"`
	// The App Engine app IDs that can access this instance.
	// (Deprecated) Applied to First Generation instances only.
	//
	// Deprecated: Do not use.
	AuthorizedGaeApplications []string `protobuf:"bytes,2,rep,name=authorized_gae_applications,json=authorizedGaeApplications,proto3" json:"authorized_gae_applications,omitempty"`
	// The tier (or machine type) for this instance, for example
	// **db-custom-1-3840**.
	Tier string `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	// This is always **sql#settings**.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
	// User-provided labels, represented as a dictionary where each label is a
	// single key value pair.
	UserLabels map[string]string `protobuf:"bytes,5,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Availability type. Potential values:
	// *  **ZONAL**: The instance serves data from only one zone. Outages in that
	// zone affect data accessibility.
	// *  **REGIONAL**: The instance can serve data from more than one zone in a
	// region (it is highly available)./
	//
	// For more information, see [Overview of the High Availability
	// Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
	AvailabilityType SqlAvailabilityType `protobuf:"varint,6,opt,name=availability_type,json=availabilityType,proto3,enum=google.cloud.sql.v1.SqlAvailabilityType" json:"availability_type,omitempty"`
	// The pricing plan for this instance. This can be either **PER_USE** or
	// **PACKAGE**. Only **PER_USE** is supported for Second Generation instances.
	PricingPlan SqlPricingPlan `protobuf:"varint,7,opt,name=pricing_plan,json=pricingPlan,proto3,enum=google.cloud.sql.v1.SqlPricingPlan" json:"pricing_plan,omitempty"`
	// The type of replication this instance uses. This can be either
	// **ASYNCHRONOUS** or **SYNCHRONOUS**. (Deprecated) This property was only
	// applicable to First Generation instances.
	//
	// Deprecated: Do not use.
	ReplicationType SqlReplicationType `protobuf:"varint,8,opt,name=replication_type,json=replicationType,proto3,enum=google.cloud.sql.v1.SqlReplicationType" json:"replication_type,omitempty"`
	// The maximum size to which storage capacity can be automatically increased.
	// The default value is 0, which specifies that there is no limit.
	StorageAutoResizeLimit *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=storage_auto_resize_limit,json=storageAutoResizeLimit,proto3" json:"storage_auto_resize_limit,omitempty"`
	// The activation policy specifies when the instance is activated; it is
	// applicable only when the instance state is RUNNABLE. Valid values:
	// *  **ALWAYS**: The instance is on, and remains so even in the absence of
	// connection requests.
	// *  **NEVER**: The instance is off; it is not activated, even if a
	// connection request arrives.
	ActivationPolicy Settings_SqlActivationPolicy `protobuf:"varint,10,opt,name=activation_policy,json=activationPolicy,proto3,enum=google.cloud.sql.v1.Settings_SqlActivationPolicy" json:"activation_policy,omitempty"`
	// The settings for IP Management. This allows to enable or disable the
	// instance IP and manage which external networks can connect to the instance.
	// The IPv4 address cannot be disabled for Second Generation instances.
	IpConfiguration *IpConfiguration `protobuf:"bytes,11,opt,name=ip_configuration,json=ipConfiguration,proto3" json:"ip_configuration,omitempty"`
	// Configuration to increase storage size automatically. The default value is
	// true.
	StorageAutoResize *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=storage_auto_resize,json=storageAutoResize,proto3" json:"storage_auto_resize,omitempty"`
	// The location preference settings. This allows the instance to be located as
	// near as possible to either an App Engine app or Compute Engine zone for
	// better performance. App Engine co-location was only applicable to First
	// Generation instances.
	LocationPreference *LocationPreference `protobuf:"bytes,13,opt,name=location_preference,json=locationPreference,proto3" json:"location_preference,omitempty"`
	// The database flags passed to the instance at startup.
	DatabaseFlags []*DatabaseFlags `protobuf:"bytes,14,rep,name=database_flags,json=databaseFlags,proto3" json:"database_flags,omitempty"`
	// The type of data disk: **PD_SSD** (default) or **PD_HDD**. Not used for
	// First Generation instances.
	DataDiskType SqlDataDiskType `protobuf:"varint,15,opt,name=data_disk_type,json=dataDiskType,proto3,enum=google.cloud.sql.v1.SqlDataDiskType" json:"data_disk_type,omitempty"`
	// The maintenance window for this instance. This specifies when the instance
	// can be restarted for maintenance purposes.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// The daily backup configuration for the instance.
	BackupConfiguration *BackupConfiguration `protobuf:"bytes,17,opt,name=backup_configuration,json=backupConfiguration,proto3" json:"backup_configuration,omitempty"`
	// Configuration specific to read replica instances. Indicates whether
	// replication is enabled or not.
	DatabaseReplicationEnabled *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=database_replication_enabled,json=databaseReplicationEnabled,proto3" json:"database_replication_enabled,omitempty"`
	// Configuration specific to read replica instances. Indicates whether
	// database flags for crash-safe replication are enabled. This property was
	// only applicable to First Generation instances.
	//
	// Deprecated: Do not use.
	CrashSafeReplicationEnabled *wrapperspb.BoolValue `protobuf:"bytes,19,opt,name=crash_safe_replication_enabled,json=crashSafeReplicationEnabled,proto3" json:"crash_safe_replication_enabled,omitempty"`
	// The size of data disk, in GB. The data disk size minimum is 10GB.
	DataDiskSizeGb *wrapperspb.Int64Value `protobuf:"bytes,20,opt,name=data_disk_size_gb,json=dataDiskSizeGb,proto3" json:"data_disk_size_gb,omitempty"`
	// Active Directory configuration, relevant only for Cloud SQL for SQL Server.
	ActiveDirectoryConfig *SqlActiveDirectoryConfig `protobuf:"bytes,22,opt,name=active_directory_config,json=activeDirectoryConfig,proto3" json:"active_directory_config,omitempty"`
	// The name of server Instance collation.
	Collation string `protobuf:"bytes,23,opt,name=collation,proto3" json:"collation,omitempty"`
	// Deny maintenance periods
	DenyMaintenancePeriods []*DenyMaintenancePeriod `protobuf:"bytes,24,rep,name=deny_maintenance_periods,json=denyMaintenancePeriods,proto3" json:"deny_maintenance_periods,omitempty"`
	// Insights configuration, for now relevant only for Postgres.
	InsightsConfig *InsightsConfig `protobuf:"bytes,25,opt,name=insights_config,json=insightsConfig,proto3" json:"insights_config,omitempty"`
	// SQL Server specific audit configuration.
	SqlServerAuditConfig *SqlServerAuditConfig `protobuf:"bytes,29,opt,name=sql_server_audit_config,json=sqlServerAuditConfig,proto3" json:"sql_server_audit_config,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{27}
}

func (x *Settings) GetSettingsVersion() *wrapperspb.Int64Value {
	if x != nil {
		return x.SettingsVersion
	}
	return nil
}

// Deprecated: Do not use.
func (x *Settings) GetAuthorizedGaeApplications() []string {
	if x != nil {
		return x.AuthorizedGaeApplications
	}
	return nil
}

func (x *Settings) GetTier() string {
	if x != nil {
		return x.Tier
	}
	return ""
}

func (x *Settings) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Settings) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *Settings) GetAvailabilityType() SqlAvailabilityType {
	if x != nil {
		return x.AvailabilityType
	}
	return SqlAvailabilityType_SQL_AVAILABILITY_TYPE_UNSPECIFIED
}

func (x *Settings) GetPricingPlan() SqlPricingPlan {
	if x != nil {
		return x.PricingPlan
	}
	return SqlPricingPlan_SQL_PRICING_PLAN_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *Settings) GetReplicationType() SqlReplicationType {
	if x != nil {
		return x.ReplicationType
	}
	return SqlReplicationType_SQL_REPLICATION_TYPE_UNSPECIFIED
}

func (x *Settings) GetStorageAutoResizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.StorageAutoResizeLimit
	}
	return nil
}

func (x *Settings) GetActivationPolicy() Settings_SqlActivationPolicy {
	if x != nil {
		return x.ActivationPolicy
	}
	return Settings_SQL_ACTIVATION_POLICY_UNSPECIFIED
}

func (x *Settings) GetIpConfiguration() *IpConfiguration {
	if x != nil {
		return x.IpConfiguration
	}
	return nil
}

func (x *Settings) GetStorageAutoResize() *wrapperspb.BoolValue {
	if x != nil {
		return x.StorageAutoResize
	}
	return nil
}

func (x *Settings) GetLocationPreference() *LocationPreference {
	if x != nil {
		return x.LocationPreference
	}
	return nil
}

func (x *Settings) GetDatabaseFlags() []*DatabaseFlags {
	if x != nil {
		return x.DatabaseFlags
	}
	return nil
}

func (x *Settings) GetDataDiskType() SqlDataDiskType {
	if x != nil {
		return x.DataDiskType
	}
	return SqlDataDiskType_SQL_DATA_DISK_TYPE_UNSPECIFIED
}

func (x *Settings) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Settings) GetBackupConfiguration() *BackupConfiguration {
	if x != nil {
		return x.BackupConfiguration
	}
	return nil
}

func (x *Settings) GetDatabaseReplicationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.DatabaseReplicationEnabled
	}
	return nil
}

// Deprecated: Do not use.
func (x *Settings) GetCrashSafeReplicationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CrashSafeReplicationEnabled
	}
	return nil
}

func (x *Settings) GetDataDiskSizeGb() *wrapperspb.Int64Value {
	if x != nil {
		return x.DataDiskSizeGb
	}
	return nil
}

func (x *Settings) GetActiveDirectoryConfig() *SqlActiveDirectoryConfig {
	if x != nil {
		return x.ActiveDirectoryConfig
	}
	return nil
}

func (x *Settings) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *Settings) GetDenyMaintenancePeriods() []*DenyMaintenancePeriod {
	if x != nil {
		return x.DenyMaintenancePeriods
	}
	return nil
}

func (x *Settings) GetInsightsConfig() *InsightsConfig {
	if x != nil {
		return x.InsightsConfig
	}
	return nil
}

func (x *Settings) GetSqlServerAuditConfig() *SqlServerAuditConfig {
	if x != nil {
		return x.SqlServerAuditConfig
	}
	return nil
}

// SslCerts Resource
type SslCert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always **sql#sslCert**.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Serial number, as extracted from the certificate.
	CertSerialNumber string `protobuf:"bytes,2,opt,name=cert_serial_number,json=certSerialNumber,proto3" json:"cert_serial_number,omitempty"`
	// PEM representation.
	Cert string `protobuf:"bytes,3,opt,name=cert,proto3" json:"cert,omitempty"`
	// The time when the certificate was created in [RFC
	// 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// User supplied name.  Constrained to [a-zA-Z.-_ ]+.
	CommonName string `protobuf:"bytes,5,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	// The time when the certificate expires in [RFC
	// 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// **2012-11-15T16:19:00.094Z**.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Sha1 Fingerprint.
	Sha1Fingerprint string `protobuf:"bytes,7,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
	// Name of the database instance.
	Instance string `protobuf:"bytes,8,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,9,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
}

func (x *SslCert) Reset() {
	*x = SslCert{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCert) ProtoMessage() {}

func (x *SslCert) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCert.ProtoReflect.Descriptor instead.
func (*SslCert) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{28}
}

func (x *SslCert) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCert) GetCertSerialNumber() string {
	if x != nil {
		return x.CertSerialNumber
	}
	return ""
}

func (x *SslCert) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

func (x *SslCert) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SslCert) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *SslCert) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *SslCert) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

func (x *SslCert) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SslCert) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

// SslCertDetail.
type SslCertDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public information about the cert.
	CertInfo *SslCert `protobuf:"bytes,1,opt,name=cert_info,json=certInfo,proto3" json:"cert_info,omitempty"`
	// The private key for the client cert, in pem format.  Keep private in order
	// to protect your security.
	CertPrivateKey string `protobuf:"bytes,2,opt,name=cert_private_key,json=certPrivateKey,proto3" json:"cert_private_key,omitempty"`
}

func (x *SslCertDetail) Reset() {
	*x = SslCertDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertDetail) ProtoMessage() {}

func (x *SslCertDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertDetail.ProtoReflect.Descriptor instead.
func (*SslCertDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{29}
}

func (x *SslCertDetail) GetCertInfo() *SslCert {
	if x != nil {
		return x.CertInfo
	}
	return nil
}

func (x *SslCertDetail) GetCertPrivateKey() string {
	if x != nil {
		return x.CertPrivateKey
	}
	return ""
}

// Active Directory configuration, relevant only for Cloud SQL for SQL Server.
type SqlActiveDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always sql#activeDirectoryConfig.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The name of the domain (e.g., mydomain.com).
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *SqlActiveDirectoryConfig) Reset() {
	*x = SqlActiveDirectoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlActiveDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlActiveDirectoryConfig) ProtoMessage() {}

func (x *SqlActiveDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlActiveDirectoryConfig.ProtoReflect.Descriptor instead.
func (*SqlActiveDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{30}
}

func (x *SqlActiveDirectoryConfig) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlActiveDirectoryConfig) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// SQL Server specific audit configuration.
type SqlServerAuditConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always sql#sqlServerAuditConfig
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The name of the destination bucket (e.g., gs://mybucket).
	Bucket string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *SqlServerAuditConfig) Reset() {
	*x = SqlServerAuditConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlServerAuditConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlServerAuditConfig) ProtoMessage() {}

func (x *SqlServerAuditConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlServerAuditConfig.ProtoReflect.Descriptor instead.
func (*SqlServerAuditConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{31}
}

func (x *SqlServerAuditConfig) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlServerAuditConfig) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

type ExportContext_SqlCsvExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The select query used to extract the data.
	SelectQuery string `protobuf:"bytes,1,opt,name=select_query,json=selectQuery,proto3" json:"select_query,omitempty"`
	// Specifies the character that should appear before a data character that
	// needs to be escaped.
	EscapeCharacter string `protobuf:"bytes,2,opt,name=escape_character,json=escapeCharacter,proto3" json:"escape_character,omitempty"`
	// Specifies the quoting character to be used when a data value is quoted.
	QuoteCharacter string `protobuf:"bytes,3,opt,name=quote_character,json=quoteCharacter,proto3" json:"quote_character,omitempty"`
	// Specifies the character that separates columns within each row (line) of
	// the file.
	FieldsTerminatedBy string `protobuf:"bytes,4,opt,name=fields_terminated_by,json=fieldsTerminatedBy,proto3" json:"fields_terminated_by,omitempty"`
	// This is used to separate lines. If a line does not contain all fields,
	// the rest of the columns are set to their default values.
	LinesTerminatedBy string `protobuf:"bytes,6,opt,name=lines_terminated_by,json=linesTerminatedBy,proto3" json:"lines_terminated_by,omitempty"`
}

func (x *ExportContext_SqlCsvExportOptions) Reset() {
	*x = ExportContext_SqlCsvExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlCsvExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlCsvExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlCsvExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlCsvExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlCsvExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ExportContext_SqlCsvExportOptions) GetSelectQuery() string {
	if x != nil {
		return x.SelectQuery
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetEscapeCharacter() string {
	if x != nil {
		return x.EscapeCharacter
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetQuoteCharacter() string {
	if x != nil {
		return x.QuoteCharacter
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetFieldsTerminatedBy() string {
	if x != nil {
		return x.FieldsTerminatedBy
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetLinesTerminatedBy() string {
	if x != nil {
		return x.LinesTerminatedBy
	}
	return ""
}

type ExportContext_SqlExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tables to export, or that were exported, from the specified database. If
	// you specify tables, specify one and only one database. For PostgreSQL
	// instances, you can specify only one table.
	Tables []string `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
	// Export only schemas.
	SchemaOnly         *wrapperspb.BoolValue                              `protobuf:"bytes,2,opt,name=schema_only,json=schemaOnly,proto3" json:"schema_only,omitempty"`
	MysqlExportOptions *ExportContext_SqlExportOptions_MysqlExportOptions `protobuf:"bytes,3,opt,name=mysql_export_options,json=mysqlExportOptions,proto3" json:"mysql_export_options,omitempty"`
}

func (x *ExportContext_SqlExportOptions) Reset() {
	*x = ExportContext_SqlExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{13, 1}
}

func (x *ExportContext_SqlExportOptions) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *ExportContext_SqlExportOptions) GetSchemaOnly() *wrapperspb.BoolValue {
	if x != nil {
		return x.SchemaOnly
	}
	return nil
}

func (x *ExportContext_SqlExportOptions) GetMysqlExportOptions() *ExportContext_SqlExportOptions_MysqlExportOptions {
	if x != nil {
		return x.MysqlExportOptions
	}
	return nil
}

// Options for exporting from MySQL.
type ExportContext_SqlExportOptions_MysqlExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Option to include SQL statement required to set up replication.
	// *  If set to **1**, the dump file includes
	//  a CHANGE MASTER TO statement with the binary log coordinates,
	//  and --set-gtid-purged is set to ON.
	// *  If set to **2**, the CHANGE MASTER TO statement is written as
	//  a SQL comment and has no effect.
	// *  If set to any value other than **1**, --set-gtid-purged is set
	// to OFF.
	MasterData *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=master_data,json=masterData,proto3" json:"master_data,omitempty"`
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) Reset() {
	*x = ExportContext_SqlExportOptions_MysqlExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlExportOptions_MysqlExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlExportOptions_MysqlExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlExportOptions_MysqlExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{13, 1, 0}
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) GetMasterData() *wrapperspb.Int32Value {
	if x != nil {
		return x.MasterData
	}
	return nil
}

type ImportContext_SqlCsvImportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The table to which CSV data is imported.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// The columns to which CSV data is imported. If not specified, all columns
	// of the database table are loaded with CSV data.
	Columns []string `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	// Specifies the character that should appear before a data character that
	// needs to be escaped.
	EscapeCharacter string `protobuf:"bytes,4,opt,name=escape_character,json=escapeCharacter,proto3" json:"escape_character,omitempty"`
	// Specifies the quoting character to be used when a data value is quoted.
	QuoteCharacter string `protobuf:"bytes,5,opt,name=quote_character,json=quoteCharacter,proto3" json:"quote_character,omitempty"`
	// Specifies the character that separates columns within each row (line) of
	// the file.
	FieldsTerminatedBy string `protobuf:"bytes,6,opt,name=fields_terminated_by,json=fieldsTerminatedBy,proto3" json:"fields_terminated_by,omitempty"`
	// This is used to separate lines. If a line does not contain all fields,
	// the rest of the columns are set to their default values.
	LinesTerminatedBy string `protobuf:"bytes,8,opt,name=lines_terminated_by,json=linesTerminatedBy,proto3" json:"lines_terminated_by,omitempty"`
}

func (x *ImportContext_SqlCsvImportOptions) Reset() {
	*x = ImportContext_SqlCsvImportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlCsvImportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlCsvImportOptions) ProtoMessage() {}

func (x *ImportContext_SqlCsvImportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlCsvImportOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlCsvImportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ImportContext_SqlCsvImportOptions) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *ImportContext_SqlCsvImportOptions) GetEscapeCharacter() string {
	if x != nil {
		return x.EscapeCharacter
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetQuoteCharacter() string {
	if x != nil {
		return x.QuoteCharacter
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetFieldsTerminatedBy() string {
	if x != nil {
		return x.FieldsTerminatedBy
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetLinesTerminatedBy() string {
	if x != nil {
		return x.LinesTerminatedBy
	}
	return ""
}

type ImportContext_SqlBakImportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EncryptionOptions *ImportContext_SqlBakImportOptions_EncryptionOptions `protobuf:"bytes,1,opt,name=encryption_options,json=encryptionOptions,proto3" json:"encryption_options,omitempty"`
}

func (x *ImportContext_SqlBakImportOptions) Reset() {
	*x = ImportContext_SqlBakImportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlBakImportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlBakImportOptions) ProtoMessage() {}

func (x *ImportContext_SqlBakImportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlBakImportOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlBakImportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 1}
}

func (x *ImportContext_SqlBakImportOptions) GetEncryptionOptions() *ImportContext_SqlBakImportOptions_EncryptionOptions {
	if x != nil {
		return x.EncryptionOptions
	}
	return nil
}

type ImportContext_SqlBakImportOptions_EncryptionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the Certificate (.cer) in Cloud Storage, in the form
	// **gs://bucketName/fileName**. The instance must have
	// write permissions to the bucket and read access to the file.
	CertPath string `protobuf:"bytes,1,opt,name=cert_path,json=certPath,proto3" json:"cert_path,omitempty"`
	// Path to the Certificate Private Key (.pvk)  in Cloud Storage, in the
	// form **gs://bucketName/fileName**. The instance must have
	// write permissions to the bucket and read access to the file.
	PvkPath string `protobuf:"bytes,2,opt,name=pvk_path,json=pvkPath,proto3" json:"pvk_path,omitempty"`
	// Password that encrypts the private key
	PvkPassword string `protobuf:"bytes,3,opt,name=pvk_password,json=pvkPassword,proto3" json:"pvk_password,omitempty"`
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) Reset() {
	*x = ImportContext_SqlBakImportOptions_EncryptionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlBakImportOptions_EncryptionOptions) ProtoMessage() {}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlBakImportOptions_EncryptionOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlBakImportOptions_EncryptionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 1, 0}
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetCertPath() string {
	if x != nil {
		return x.CertPath
	}
	return ""
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetPvkPath() string {
	if x != nil {
		return x.PvkPath
	}
	return ""
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetPvkPassword() string {
	if x != nil {
		return x.PvkPassword
	}
	return ""
}

var File_google_cloud_sql_v1_cloud_sql_resources_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92, 0x01, 0x0a, 0x08, 0x41, 0x63, 0x6c, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xd8, 0x01, 0x0a, 0x0a,
	0x41, 0x70, 0x69, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x69, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x70, 0x69,
	0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x22, 0x51, 0x0a, 0x11, 0x53, 0x71, 0x6c, 0x41, 0x70, 0x69, 0x57, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f,
	0x41, 0x50, 0x49, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16,
	0x0a, 0x12, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x22, 0x80, 0x02, 0x0a, 0x17, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x61, 0x0a, 0x0e, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x75, 0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x0d, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x46, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x22, 0x3a, 0x0a,
	0x0d, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x1e,
	0x0a, 0x1a, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x49, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01, 0x22, 0xf7, 0x04, 0x0a, 0x13, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x48, 0x0a, 0x12, 0x62, 0x69,
	0x6e, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x10, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x65, 0x0a, 0x21, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x69, 0x6e,
	0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x1e, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x68, 0x0a, 0x19, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x60, 0x0a, 0x1e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x79, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x79, 0x73, 0x22, 0x40, 0x0a, 0x0d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xd4, 0x02, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74,
	0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x6d, 0x0a, 0x1a, 0x73, 0x71, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x18,
	0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x72, 0x0a, 0x18,
	0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x22, 0x39, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x5f, 0x0a, 0x0f, 0x4d,
	0x79, 0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c,
	0x0a, 0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x66,
	0x6c, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x10, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x22, 0x35, 0x0a, 0x09,
	0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x59, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xab,
	0x01, 0x0a, 0x19, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x7a, 0x0a, 0x1b, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x19, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe8, 0x01, 0x0a,
	0x25, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x79, 0x53,
	0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65,
	0x79, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0xba, 0x07, 0x0a, 0x0d, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x61, 0x0a,
	0x12, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71,
	0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10,
	0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x64, 0x0a, 0x12, 0x63, 0x73, 0x76, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x63, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0xee, 0x01, 0x0a, 0x13,
	0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
	0x72, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x71, 0x75, 0x6f, 0x74,
	0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x2e, 0x0a, 0x13,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6c, 0x69, 0x6e, 0x65, 0x73,
	0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x1a, 0xb5, 0x02, 0x0a,
	0x10, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x78, 0x0a, 0x14, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x6d, 0x79,
	0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x52, 0x0a, 0x12, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x22, 0xfc, 0x06, 0x0a, 0x0d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x3d, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x64, 0x0a, 0x12, 0x63, 0x73, 0x76, 0x5f, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x63, 0x73, 0x76,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x64,
	0x0a, 0x12, 0x62, 0x61, 0x6b, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53,
	0x71, 0x6c, 0x42, 0x61, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x10, 0x62, 0x61, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xfb, 0x01, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x6f, 0x74, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x12, 0x30, 0x0a, 0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x1a, 0xfe, 0x01, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x6b, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x77, 0x0a, 0x12, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61,
	0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x6e, 0x0a, 0x11, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x65, 0x72, 0x74,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x65, 0x72,
	0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x76, 0x6b, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x76, 0x6b, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x76, 0x6b, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x76, 0x6b, 0x50, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x22, 0xb4, 0x02, 0x0a, 0x0f, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x69, 0x70, 0x76, 0x34, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x69, 0x70, 0x76, 0x34, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x73, 0x73, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x53, 0x73, 0x6c, 0x12, 0x4e, 0x0a, 0x13,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x2c, 0x0a, 0x12,
	0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x38, 0x0a, 0x16, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x67, 0x61, 0x65, 0x5f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x47, 0x61, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xcf, 0x01, 0x0a, 0x11, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x12, 0x2f, 0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x68, 0x6f, 0x75,
	0x72, 0x12, 0x2d, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x64, 0x61, 0x79,
	0x12, 0x46, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x65, 0x0a, 0x15,
	0x44, 0x65, 0x6e, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x44, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0xd1, 0x02, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x15,
	0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x36, 0x0a, 0x17, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x50, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x50, 0x65,
	0x72, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x22, 0xa1, 0x04, 0x0a, 0x19, 0x4d, 0x79, 0x53, 0x71,
	0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64,
	0x75, 0x6d, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x12, 0x51, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x14, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x53, 0x0a, 0x17, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x48, 0x65, 0x61, 0x72,
	0x74, 0x62, 0x65, 0x61, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79,
	0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x73, 0x6c, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x12,
	0x56, 0x0a, 0x19, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x53, 0x0a, 0x1b, 0x44,
	0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d,
	0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x22, 0x5b, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xa7, 0x01,
	0x0a, 0x09, 0x49, 0x70, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x40, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x6f,
	0x5f, 0x72, 0x65, 0x74, 0x69, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x54,
	0x6f, 0x52, 0x65, 0x74, 0x69, 0x72, 0x65, 0x22, 0xc0, 0x0c, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x49, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x56, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x71, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x0e,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x49, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x49, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x25, 0x0a, 0x0e, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x22, 0xa5, 0x05, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49,
	0x4d, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x58, 0x50, 0x4f, 0x52,
	0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x06, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x07,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x10, 0x0a, 0x08, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54,
	0x10, 0x08, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50,
	0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x10, 0x09, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e,
	0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x10, 0x0b,
	0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10,
	0x0c, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x10, 0x0e, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x54, 0x4f, 0x50, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x0f, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10,
	0x10, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50,
	0x4c, 0x49, 0x43, 0x41, 0x10, 0x11, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x12, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x14, 0x12, 0x0f, 0x0a, 0x0b,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x15, 0x12, 0x13, 0x0a,
	0x0f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45,
	0x10, 0x16, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x17, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x18, 0x12, 0x0c, 0x0a, 0x08,
	0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x19, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x1a, 0x12, 0x14, 0x0a,
	0x10, 0x52, 0x45, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x10, 0x1b, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x5f,
	0x4c, 0x4f, 0x47, 0x10, 0x1c, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f,
	0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x1d, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e,
	0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x1e, 0x12, 0x19, 0x0a, 0x11, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x10, 0x1f,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x19, 0x0a, 0x11, 0x44, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x20, 0x1a, 0x02, 0x08, 0x01, 0x12,
	0x14, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x10,
	0x21, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10,
	0x22, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52,
	0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x10, 0x23, 0x22, 0x5e, 0x0a, 0x12, 0x53, 0x71,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x22, 0x52, 0x0a, 0x0e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x62,
	0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x3b, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x22, 0xcc, 0x10, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x46, 0x0a, 0x10, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1b, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x67, 0x61, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x19, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x47, 0x61, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x4e, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0c, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x56, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x19, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x5e, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x71, 0x6c,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x4f, 0x0a, 0x10, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x13, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x12,
	0x58, 0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x0e, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46,
	0x6c, 0x61, 0x67, 0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x55, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x5b, 0x0a, 0x14, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x63, 0x0a, 0x1e, 0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x73, 0x61, 0x66, 0x65,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1b, 0x63, 0x72, 0x61, 0x73,
	0x68, 0x53, 0x61, 0x66, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x46, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0e, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x65, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x18, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x6d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73,
	0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6e,
	0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x52, 0x16, 0x64, 0x65, 0x6e, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x12, 0x4c, 0x0a, 0x0f, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x17, 0x73, 0x71, 0x6c, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x75, 0x64, 0x69, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x73, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x13, 0x53, 0x71, 0x6c,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59,
	0x53, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x03, 0x1a, 0x02, 0x08,
	0x01, 0x22, 0xe6, 0x02, 0x0a, 0x07, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63,
	0x65, 0x72, 0x74, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63,
	0x65, 0x72, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x74, 0x0a, 0x0d, 0x53, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x39, 0x0a, 0x09, 0x63,
	0x65, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x08, 0x63, 0x65,
	0x72, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x22, 0x46, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22, 0x42, 0x0a, 0x14, 0x53, 0x71, 0x6c, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x75, 0x64, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2a, 0x47, 0x0a, 0x0b,
	0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53,
	0x51, 0x4c, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x51,
	0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03,
	0x42, 0x41, 0x4b, 0x10, 0x04, 0x2a, 0x63, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x51, 0x4c, 0x5f, 0x42,
	0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x09, 0x46, 0x49, 0x52,
	0x53, 0x54, 0x5f, 0x47, 0x45, 0x4e, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0e, 0x0a, 0x0a,
	0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x47, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x2a, 0x75, 0x0a, 0x10, 0x53, 0x71,
	0x6c, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23,
	0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x50, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x55, 0x54, 0x47, 0x4f, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x4d,
	0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x31, 0x53, 0x54, 0x5f, 0x47, 0x45, 0x4e, 0x10,
	0x04, 0x2a, 0xb4, 0x03, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11,
	0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x31, 0x10, 0x02, 0x1a, 0x02, 0x08,
	0x01, 0x12, 0x11, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x35, 0x10, 0x03,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f,
	0x36, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x37,
	0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x39,
	0x5f, 0x36, 0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53,
	0x5f, 0x31, 0x31, 0x10, 0x0a, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x37, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x10, 0x0b, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f,
	0x32, 0x30, 0x31, 0x37, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10,
	0x0e, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32,
	0x30, 0x31, 0x37, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0f, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x37, 0x5f,
	0x57, 0x45, 0x42, 0x10, 0x10, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45,
	0x53, 0x5f, 0x31, 0x30, 0x10, 0x12, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52,
	0x45, 0x53, 0x5f, 0x31, 0x32, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47,
	0x52, 0x45, 0x53, 0x5f, 0x31, 0x33, 0x10, 0x17, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x51, 0x4c, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44,
	0x41, 0x52, 0x44, 0x10, 0x1a, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56,
	0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49,
	0x53, 0x45, 0x10, 0x1b, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x10, 0x1c,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30,
	0x31, 0x39, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x1d, 0x2a, 0x4c, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x50,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x51,
	0x4c, 0x5f, 0x50, 0x52, 0x49, 0x43, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x52,
	0x5f, 0x55, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x5d, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20,
	0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x59, 0x4e, 0x43, 0x48, 0x52, 0x4f, 0x4e, 0x4f, 0x55,
	0x53, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x53, 0x59, 0x4e, 0x43, 0x48, 0x52, 0x4f, 0x4e,
	0x4f, 0x55, 0x53, 0x10, 0x02, 0x2a, 0x69, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x44, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x48,
	0x44, 0x44, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x12, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45,
	0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01,
	0x2a, 0x55, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x41,
	0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x5a, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0x4a, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x51, 0x4c,
	0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x63,
	0x61, 0x6e, 0x61, 0x72, 0x79, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x10, 0x02, 0x42, 0x6b, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x16,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x71, 0x6c,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescData = file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDesc
)

func file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescData)
	})
	return file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDescData
}

var file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 14)
var file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_sql_v1_cloud_sql_resources_proto_goTypes = []interface{}{
	(SqlFileType)(0),                                            // 0: google.cloud.sql.v1.SqlFileType
	(SqlBackendType)(0),                                         // 1: google.cloud.sql.v1.SqlBackendType
	(SqlIpAddressType)(0),                                       // 2: google.cloud.sql.v1.SqlIpAddressType
	(SqlDatabaseVersion)(0),                                     // 3: google.cloud.sql.v1.SqlDatabaseVersion
	(SqlPricingPlan)(0),                                         // 4: google.cloud.sql.v1.SqlPricingPlan
	(SqlReplicationType)(0),                                     // 5: google.cloud.sql.v1.SqlReplicationType
	(SqlDataDiskType)(0),                                        // 6: google.cloud.sql.v1.SqlDataDiskType
	(SqlAvailabilityType)(0),                                    // 7: google.cloud.sql.v1.SqlAvailabilityType
	(SqlUpdateTrack)(0),                                         // 8: google.cloud.sql.v1.SqlUpdateTrack
	(ApiWarning_SqlApiWarningCode)(0),                           // 9: google.cloud.sql.v1.ApiWarning.SqlApiWarningCode
	(BackupRetentionSettings_RetentionUnit)(0),                  // 10: google.cloud.sql.v1.BackupRetentionSettings.RetentionUnit
	(Operation_SqlOperationType)(0),                             // 11: google.cloud.sql.v1.Operation.SqlOperationType
	(Operation_SqlOperationStatus)(0),                           // 12: google.cloud.sql.v1.Operation.SqlOperationStatus
	(Settings_SqlActivationPolicy)(0),                           // 13: google.cloud.sql.v1.Settings.SqlActivationPolicy
	(*AclEntry)(nil),                                            // 14: google.cloud.sql.v1.AclEntry
	(*ApiWarning)(nil),                                          // 15: google.cloud.sql.v1.ApiWarning
	(*BackupRetentionSettings)(nil),                             // 16: google.cloud.sql.v1.BackupRetentionSettings
	(*BackupConfiguration)(nil),                                 // 17: google.cloud.sql.v1.BackupConfiguration
	(*BackupContext)(nil),                                       // 18: google.cloud.sql.v1.BackupContext
	(*Database)(nil),                                            // 19: google.cloud.sql.v1.Database
	(*SqlServerDatabaseDetails)(nil),                            // 20: google.cloud.sql.v1.SqlServerDatabaseDetails
	(*DatabaseFlags)(nil),                                       // 21: google.cloud.sql.v1.DatabaseFlags
	(*MySqlSyncConfig)(nil),                                     // 22: google.cloud.sql.v1.MySqlSyncConfig
	(*SyncFlags)(nil),                                           // 23: google.cloud.sql.v1.SyncFlags
	(*InstanceReference)(nil),                                   // 24: google.cloud.sql.v1.InstanceReference
	(*DemoteMasterConfiguration)(nil),                           // 25: google.cloud.sql.v1.DemoteMasterConfiguration
	(*DemoteMasterMySqlReplicaConfiguration)(nil),               // 26: google.cloud.sql.v1.DemoteMasterMySqlReplicaConfiguration
	(*ExportContext)(nil),                                       // 27: google.cloud.sql.v1.ExportContext
	(*ImportContext)(nil),                                       // 28: google.cloud.sql.v1.ImportContext
	(*IpConfiguration)(nil),                                     // 29: google.cloud.sql.v1.IpConfiguration
	(*LocationPreference)(nil),                                  // 30: google.cloud.sql.v1.LocationPreference
	(*MaintenanceWindow)(nil),                                   // 31: google.cloud.sql.v1.MaintenanceWindow
	(*DenyMaintenancePeriod)(nil),                               // 32: google.cloud.sql.v1.DenyMaintenancePeriod
	(*InsightsConfig)(nil),                                      // 33: google.cloud.sql.v1.InsightsConfig
	(*MySqlReplicaConfiguration)(nil),                           // 34: google.cloud.sql.v1.MySqlReplicaConfiguration
	(*DiskEncryptionConfiguration)(nil),                         // 35: google.cloud.sql.v1.DiskEncryptionConfiguration
	(*DiskEncryptionStatus)(nil),                                // 36: google.cloud.sql.v1.DiskEncryptionStatus
	(*IpMapping)(nil),                                           // 37: google.cloud.sql.v1.IpMapping
	(*Operation)(nil),                                           // 38: google.cloud.sql.v1.Operation
	(*OperationError)(nil),                                      // 39: google.cloud.sql.v1.OperationError
	(*OperationErrors)(nil),                                     // 40: google.cloud.sql.v1.OperationErrors
	(*Settings)(nil),                                            // 41: google.cloud.sql.v1.Settings
	(*SslCert)(nil),                                             // 42: google.cloud.sql.v1.SslCert
	(*SslCertDetail)(nil),                                       // 43: google.cloud.sql.v1.SslCertDetail
	(*SqlActiveDirectoryConfig)(nil),                            // 44: google.cloud.sql.v1.SqlActiveDirectoryConfig
	(*SqlServerAuditConfig)(nil),                                // 45: google.cloud.sql.v1.SqlServerAuditConfig
	(*ExportContext_SqlCsvExportOptions)(nil),                   // 46: google.cloud.sql.v1.ExportContext.SqlCsvExportOptions
	(*ExportContext_SqlExportOptions)(nil),                      // 47: google.cloud.sql.v1.ExportContext.SqlExportOptions
	(*ExportContext_SqlExportOptions_MysqlExportOptions)(nil),   // 48: google.cloud.sql.v1.ExportContext.SqlExportOptions.MysqlExportOptions
	(*ImportContext_SqlCsvImportOptions)(nil),                   // 49: google.cloud.sql.v1.ImportContext.SqlCsvImportOptions
	(*ImportContext_SqlBakImportOptions)(nil),                   // 50: google.cloud.sql.v1.ImportContext.SqlBakImportOptions
	(*ImportContext_SqlBakImportOptions_EncryptionOptions)(nil), // 51: google.cloud.sql.v1.ImportContext.SqlBakImportOptions.EncryptionOptions
	nil,                           // 52: google.cloud.sql.v1.Settings.UserLabelsEntry
	(*timestamppb.Timestamp)(nil), // 53: google.protobuf.Timestamp
	(*wrapperspb.Int32Value)(nil), // 54: google.protobuf.Int32Value
	(*wrapperspb.BoolValue)(nil),  // 55: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil), // 56: google.protobuf.Int64Value
}
var file_google_cloud_sql_v1_cloud_sql_resources_proto_depIdxs = []int32{
	53, // 0: google.cloud.sql.v1.AclEntry.expiration_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.cloud.sql.v1.ApiWarning.code:type_name -> google.cloud.sql.v1.ApiWarning.SqlApiWarningCode
	10, // 2: google.cloud.sql.v1.BackupRetentionSettings.retention_unit:type_name -> google.cloud.sql.v1.BackupRetentionSettings.RetentionUnit
	54, // 3: google.cloud.sql.v1.BackupRetentionSettings.retained_backups:type_name -> google.protobuf.Int32Value
	55, // 4: google.cloud.sql.v1.BackupConfiguration.enabled:type_name -> google.protobuf.BoolValue
	55, // 5: google.cloud.sql.v1.BackupConfiguration.binary_log_enabled:type_name -> google.protobuf.BoolValue
	55, // 6: google.cloud.sql.v1.BackupConfiguration.replication_log_archiving_enabled:type_name -> google.protobuf.BoolValue
	55, // 7: google.cloud.sql.v1.BackupConfiguration.point_in_time_recovery_enabled:type_name -> google.protobuf.BoolValue
	16, // 8: google.cloud.sql.v1.BackupConfiguration.backup_retention_settings:type_name -> google.cloud.sql.v1.BackupRetentionSettings
	54, // 9: google.cloud.sql.v1.BackupConfiguration.transaction_log_retention_days:type_name -> google.protobuf.Int32Value
	20, // 10: google.cloud.sql.v1.Database.sqlserver_database_details:type_name -> google.cloud.sql.v1.SqlServerDatabaseDetails
	23, // 11: google.cloud.sql.v1.MySqlSyncConfig.initial_sync_flags:type_name -> google.cloud.sql.v1.SyncFlags
	26, // 12: google.cloud.sql.v1.DemoteMasterConfiguration.mysql_replica_configuration:type_name -> google.cloud.sql.v1.DemoteMasterMySqlReplicaConfiguration
	47, // 13: google.cloud.sql.v1.ExportContext.sql_export_options:type_name -> google.cloud.sql.v1.ExportContext.SqlExportOptions
	46, // 14: google.cloud.sql.v1.ExportContext.csv_export_options:type_name -> google.cloud.sql.v1.ExportContext.SqlCsvExportOptions
	0,  // 15: google.cloud.sql.v1.ExportContext.file_type:type_name -> google.cloud.sql.v1.SqlFileType
	55, // 16: google.cloud.sql.v1.ExportContext.offload:type_name -> google.protobuf.BoolValue
	0,  // 17: google.cloud.sql.v1.ImportContext.file_type:type_name -> google.cloud.sql.v1.SqlFileType
	49, // 18: google.cloud.sql.v1.ImportContext.csv_import_options:type_name -> google.cloud.sql.v1.ImportContext.SqlCsvImportOptions
	50, // 19: google.cloud.sql.v1.ImportContext.bak_import_options:type_name -> google.cloud.sql.v1.ImportContext.SqlBakImportOptions
	55, // 20: google.cloud.sql.v1.IpConfiguration.ipv4_enabled:type_name -> google.protobuf.BoolValue
	55, // 21: google.cloud.sql.v1.IpConfiguration.require_ssl:type_name -> google.protobuf.BoolValue
	14, // 22: google.cloud.sql.v1.IpConfiguration.authorized_networks:type_name -> google.cloud.sql.v1.AclEntry
	54, // 23: google.cloud.sql.v1.MaintenanceWindow.hour:type_name -> google.protobuf.Int32Value
	54, // 24: google.cloud.sql.v1.MaintenanceWindow.day:type_name -> google.protobuf.Int32Value
	8,  // 25: google.cloud.sql.v1.MaintenanceWindow.update_track:type_name -> google.cloud.sql.v1.SqlUpdateTrack
	54, // 26: google.cloud.sql.v1.InsightsConfig.query_string_length:type_name -> google.protobuf.Int32Value
	54, // 27: google.cloud.sql.v1.InsightsConfig.query_plans_per_minute:type_name -> google.protobuf.Int32Value
	54, // 28: google.cloud.sql.v1.MySqlReplicaConfiguration.connect_retry_interval:type_name -> google.protobuf.Int32Value
	56, // 29: google.cloud.sql.v1.MySqlReplicaConfiguration.master_heartbeat_period:type_name -> google.protobuf.Int64Value
	55, // 30: google.cloud.sql.v1.MySqlReplicaConfiguration.verify_server_certificate:type_name -> google.protobuf.BoolValue
	2,  // 31: google.cloud.sql.v1.IpMapping.type:type_name -> google.cloud.sql.v1.SqlIpAddressType
	53, // 32: google.cloud.sql.v1.IpMapping.time_to_retire:type_name -> google.protobuf.Timestamp
	12, // 33: google.cloud.sql.v1.Operation.status:type_name -> google.cloud.sql.v1.Operation.SqlOperationStatus
	53, // 34: google.cloud.sql.v1.Operation.insert_time:type_name -> google.protobuf.Timestamp
	53, // 35: google.cloud.sql.v1.Operation.start_time:type_name -> google.protobuf.Timestamp
	53, // 36: google.cloud.sql.v1.Operation.end_time:type_name -> google.protobuf.Timestamp
	40, // 37: google.cloud.sql.v1.Operation.error:type_name -> google.cloud.sql.v1.OperationErrors
	11, // 38: google.cloud.sql.v1.Operation.operation_type:type_name -> google.cloud.sql.v1.Operation.SqlOperationType
	28, // 39: google.cloud.sql.v1.Operation.import_context:type_name -> google.cloud.sql.v1.ImportContext
	27, // 40: google.cloud.sql.v1.Operation.export_context:type_name -> google.cloud.sql.v1.ExportContext
	18, // 41: google.cloud.sql.v1.Operation.backup_context:type_name -> google.cloud.sql.v1.BackupContext
	39, // 42: google.cloud.sql.v1.OperationErrors.errors:type_name -> google.cloud.sql.v1.OperationError
	56, // 43: google.cloud.sql.v1.Settings.settings_version:type_name -> google.protobuf.Int64Value
	52, // 44: google.cloud.sql.v1.Settings.user_labels:type_name -> google.cloud.sql.v1.Settings.UserLabelsEntry
	7,  // 45: google.cloud.sql.v1.Settings.availability_type:type_name -> google.cloud.sql.v1.SqlAvailabilityType
	4,  // 46: google.cloud.sql.v1.Settings.pricing_plan:type_name -> google.cloud.sql.v1.SqlPricingPlan
	5,  // 47: google.cloud.sql.v1.Settings.replication_type:type_name -> google.cloud.sql.v1.SqlReplicationType
	56, // 48: google.cloud.sql.v1.Settings.storage_auto_resize_limit:type_name -> google.protobuf.Int64Value
	13, // 49: google.cloud.sql.v1.Settings.activation_policy:type_name -> google.cloud.sql.v1.Settings.SqlActivationPolicy
	29, // 50: google.cloud.sql.v1.Settings.ip_configuration:type_name -> google.cloud.sql.v1.IpConfiguration
	55, // 51: google.cloud.sql.v1.Settings.storage_auto_resize:type_name -> google.protobuf.BoolValue
	30, // 52: google.cloud.sql.v1.Settings.location_preference:type_name -> google.cloud.sql.v1.LocationPreference
	21, // 53: google.cloud.sql.v1.Settings.database_flags:type_name -> google.cloud.sql.v1.DatabaseFlags
	6,  // 54: google.cloud.sql.v1.Settings.data_disk_type:type_name -> google.cloud.sql.v1.SqlDataDiskType
	31, // 55: google.cloud.sql.v1.Settings.maintenance_window:type_name -> google.cloud.sql.v1.MaintenanceWindow
	17, // 56: google.cloud.sql.v1.Settings.backup_configuration:type_name -> google.cloud.sql.v1.BackupConfiguration
	55, // 57: google.cloud.sql.v1.Settings.database_replication_enabled:type_name -> google.protobuf.BoolValue
	55, // 58: google.cloud.sql.v1.Settings.crash_safe_replication_enabled:type_name -> google.protobuf.BoolValue
	56, // 59: google.cloud.sql.v1.Settings.data_disk_size_gb:type_name -> google.protobuf.Int64Value
	44, // 60: google.cloud.sql.v1.Settings.active_directory_config:type_name -> google.cloud.sql.v1.SqlActiveDirectoryConfig
	32, // 61: google.cloud.sql.v1.Settings.deny_maintenance_periods:type_name -> google.cloud.sql.v1.DenyMaintenancePeriod
	33, // 62: google.cloud.sql.v1.Settings.insights_config:type_name -> google.cloud.sql.v1.InsightsConfig
	45, // 63: google.cloud.sql.v1.Settings.sql_server_audit_config:type_name -> google.cloud.sql.v1.SqlServerAuditConfig
	53, // 64: google.cloud.sql.v1.SslCert.create_time:type_name -> google.protobuf.Timestamp
	53, // 65: google.cloud.sql.v1.SslCert.expiration_time:type_name -> google.protobuf.Timestamp
	42, // 66: google.cloud.sql.v1.SslCertDetail.cert_info:type_name -> google.cloud.sql.v1.SslCert
	55, // 67: google.cloud.sql.v1.ExportContext.SqlExportOptions.schema_only:type_name -> google.protobuf.BoolValue
	48, // 68: google.cloud.sql.v1.ExportContext.SqlExportOptions.mysql_export_options:type_name -> google.cloud.sql.v1.ExportContext.SqlExportOptions.MysqlExportOptions
	54, // 69: google.cloud.sql.v1.ExportContext.SqlExportOptions.MysqlExportOptions.master_data:type_name -> google.protobuf.Int32Value
	51, // 70: google.cloud.sql.v1.ImportContext.SqlBakImportOptions.encryption_options:type_name -> google.cloud.sql.v1.ImportContext.SqlBakImportOptions.EncryptionOptions
	71, // [71:71] is the sub-list for method output_type
	71, // [71:71] is the sub-list for method input_type
	71, // [71:71] is the sub-list for extension type_name
	71, // [71:71] is the sub-list for extension extendee
	0,  // [0:71] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1_cloud_sql_resources_proto_init() }
func file_google_cloud_sql_v1_cloud_sql_resources_proto_init() {
	if File_google_cloud_sql_v1_cloud_sql_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AclEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiWarning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRetentionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Database); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlServerDatabaseDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlSyncConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterMySqlReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IpConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationPreference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyMaintenancePeriod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsightsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEncryptionConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEncryptionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IpMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationErrors); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCert); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlActiveDirectoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlServerAuditConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlCsvExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlExportOptions_MysqlExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlCsvImportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlBakImportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlBakImportOptions_EncryptionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Database_SqlserverDatabaseDetails)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDesc,
			NumEnums:      14,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_sql_v1_cloud_sql_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1_cloud_sql_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1_cloud_sql_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1_cloud_sql_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1_cloud_sql_resources_proto = out.File
	file_google_cloud_sql_v1_cloud_sql_resources_proto_rawDesc = nil
	file_google_cloud_sql_v1_cloud_sql_resources_proto_goTypes = nil
	file_google_cloud_sql_v1_cloud_sql_resources_proto_depIdxs = nil
}
