# The PEP 484 type hints stub file for the QtNetwork module.
#
# Generated by SIP 4.19.19
#
# Copyright (c) 2019 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from typing import overload

from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable, QtCore.pyqtBoundSignal]


class QNetworkCacheMetaData(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QNetworkCacheMetaData) -> None: ...

    def swap(self, other: QNetworkCacheMetaData) -> None: ...
    def setAttributes(self, attributes: typing.Dict[int, typing.Any]) -> None: ...
    def attributes(self) -> typing.Dict[int, typing.Any]: ...
    def setSaveToDisk(self, allow: bool) -> None: ...
    def saveToDisk(self) -> bool: ...
    def setExpirationDate(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def expirationDate(self) -> QtCore.QDateTime: ...
    def setLastModified(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def lastModified(self) -> QtCore.QDateTime: ...
    def setRawHeaders(self, headers: typing.Iterable[typing.Tuple[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Union[QtCore.QByteArray, bytes, bytearray]]]) -> None: ...
    def rawHeaders(self) -> typing.List[typing.Tuple[QtCore.QByteArray, QtCore.QByteArray]]: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def isValid(self) -> bool: ...


class QAbstractNetworkCache(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def clear(self) -> None: ...
    def insert(self, device: QtCore.QIODevice) -> None: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> QtCore.QIODevice: ...
    def cacheSize(self) -> int: ...
    def remove(self, url: QtCore.QUrl) -> bool: ...
    def data(self, url: QtCore.QUrl) -> QtCore.QIODevice: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...
    def metaData(self, url: QtCore.QUrl) -> QNetworkCacheMetaData: ...


class QAbstractSocket(QtCore.QIODevice):

    connected: PYQT_SIGNAL
    disconnected: PYQT_SIGNAL
    error: PYQT_SIGNAL
    hostFound: PYQT_SIGNAL
    proxyAuthenticationRequired: PYQT_SIGNAL
    stateChanged: PYQT_SIGNAL

    PauseMode: typing.Type[int]
    #class PauseMode(int): ...
    PauseNever = ... # type: int
    PauseOnSslErrors = ... # type: int

    class BindFlag(int):
        DefaultForPlatform = ... # type: QAbstractSocket.BindFlag
        ShareAddress = ... # type: QAbstractSocket.BindFlag
        DontShareAddress = ... # type: QAbstractSocket.BindFlag
        ReuseAddressHint = ... # type: QAbstractSocket.BindFlag

    class SocketOption(int):
        LowDelayOption = ... # type: QAbstractSocket.SocketOption
        KeepAliveOption = ... # type: QAbstractSocket.SocketOption
        MulticastTtlOption = ... # type: QAbstractSocket.SocketOption
        MulticastLoopbackOption = ... # type: QAbstractSocket.SocketOption
        TypeOfServiceOption = ... # type: QAbstractSocket.SocketOption
        SendBufferSizeSocketOption = ... # type: QAbstractSocket.SocketOption
        ReceiveBufferSizeSocketOption = ... # type: QAbstractSocket.SocketOption
        PathMtuSocketOption = ... # type: QAbstractSocket.SocketOption

    class SocketState(int):
        UnconnectedState = ... # type: QAbstractSocket.SocketState
        HostLookupState = ... # type: QAbstractSocket.SocketState
        ConnectingState = ... # type: QAbstractSocket.SocketState
        ConnectedState = ... # type: QAbstractSocket.SocketState
        BoundState = ... # type: QAbstractSocket.SocketState
        ListeningState = ... # type: QAbstractSocket.SocketState
        ClosingState = ... # type: QAbstractSocket.SocketState

    class SocketError(int):
        ConnectionRefusedError = ... # type: QAbstractSocket.SocketError
        RemoteHostClosedError = ... # type: QAbstractSocket.SocketError
        HostNotFoundError = ... # type: QAbstractSocket.SocketError
        SocketAccessError = ... # type: QAbstractSocket.SocketError
        SocketResourceError = ... # type: QAbstractSocket.SocketError
        SocketTimeoutError = ... # type: QAbstractSocket.SocketError
        DatagramTooLargeError = ... # type: QAbstractSocket.SocketError
        NetworkError = ... # type: QAbstractSocket.SocketError
        AddressInUseError = ... # type: QAbstractSocket.SocketError
        SocketAddressNotAvailableError = ... # type: QAbstractSocket.SocketError
        UnsupportedSocketOperationError = ... # type: QAbstractSocket.SocketError
        UnfinishedSocketOperationError = ... # type: QAbstractSocket.SocketError
        ProxyAuthenticationRequiredError = ... # type: QAbstractSocket.SocketError
        SslHandshakeFailedError = ... # type: QAbstractSocket.SocketError
        ProxyConnectionRefusedError = ... # type: QAbstractSocket.SocketError
        ProxyConnectionClosedError = ... # type: QAbstractSocket.SocketError
        ProxyConnectionTimeoutError = ... # type: QAbstractSocket.SocketError
        ProxyNotFoundError = ... # type: QAbstractSocket.SocketError
        ProxyProtocolError = ... # type: QAbstractSocket.SocketError
        OperationError = ... # type: QAbstractSocket.SocketError
        SslInternalError = ... # type: QAbstractSocket.SocketError
        SslInvalidUserDataError = ... # type: QAbstractSocket.SocketError
        TemporaryError = ... # type: QAbstractSocket.SocketError
        UnknownSocketError = ... # type: QAbstractSocket.SocketError

    class NetworkLayerProtocol(int):
        IPv4Protocol = ... # type: QAbstractSocket.NetworkLayerProtocol
        IPv6Protocol = ... # type: QAbstractSocket.NetworkLayerProtocol
        AnyIPProtocol = ... # type: QAbstractSocket.NetworkLayerProtocol
        UnknownNetworkLayerProtocol = ... # type: QAbstractSocket.NetworkLayerProtocol

    class SocketType(int):
        TcpSocket = ... # type: QAbstractSocket.SocketType
        UdpSocket = ... # type: QAbstractSocket.SocketType
        SctpSocket = ... # type: QAbstractSocket.SocketType
        UnknownSocketType = ... # type: QAbstractSocket.SocketType

    BindMode: typing.Type[int]
    #class BindMode(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QAbstractSocket.BindMode, QAbstractSocket.BindFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QAbstractSocket.BindMode) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QAbstractSocket.BindMode: ...
        #def __int__(self) -> int: ...

    PauseModes: typing.Type[int]
    #class PauseModes(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QAbstractSocket.PauseModes, QAbstractSocket.PauseMode]) -> None: ...
        #@overload
        #def __init__(self, a0: QAbstractSocket.PauseModes) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QAbstractSocket.PauseModes: ...
        #def __int__(self) -> int: ...

    def __init__(self, socketType: int, parent: QtCore.QObject, **props) -> None: ...

    @overload
    def bind(self, address: typing.Union[QHostAddress, int], port: int = ..., mode: typing.Union[int, int] = ...) -> bool: ...
    @overload
    def bind(self, port: int = ..., mode: typing.Union[int, int] = ...) -> bool: ...
    def setPauseMode(self, pauseMode: typing.Union[int, int]) -> None: ...
    def pauseMode(self) -> int: ...
    def resume(self) -> None: ...
    def socketOption(self, option: int) -> typing.Any: ...
    def setSocketOption(self, option: int, value: typing.Any) -> None: ...
    def setPeerName(self, name: str) -> None: ...
    def setPeerAddress(self, address: typing.Union[QHostAddress, int]) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setLocalAddress(self, address: typing.Union[QHostAddress, int]) -> None: ...
    def setLocalPort(self, port: int) -> None: ...
    def setSocketError(self, socketError: int) -> None: ...
    def setSocketState(self, state: int) -> None: ...
    def writeData(self, data: bytes) -> int: ...
    def readLineData(self, maxlen: int) -> bytes: ...
    def readData(self, maxlen: int) -> bytes: ...
    #def proxyAuthenticationRequired(self, proxy: QNetworkProxy, authenticator: QAuthenticator) -> None: ...
    #def stateChanged(self, a0: int) -> None: ...
    #def disconnected(self) -> None: ...
    #def connected(self) -> None: ...
    #def hostFound(self) -> None: ...
    def proxy(self) -> QNetworkProxy: ...
    def setProxy(self, networkProxy: QNetworkProxy) -> None: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def flush(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def close(self) -> None: ...
    #@overload
    #def error(self) -> int: ...
    #@overload
    #def error(self, a0: int) -> None: ...
    def state(self) -> int: ...
    def socketType(self) -> int: ...
    def socketDescriptor(self) -> sip.voidptr: ...
    def setSocketDescriptor(self, socketDescriptor: sip.voidptr, state: int = ..., mode: typing.Union[int, int] = ...) -> bool: ...
    def abort(self) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def peerName(self) -> str: ...
    def peerAddress(self) -> QHostAddress: ...
    def peerPort(self) -> int: ...
    def localAddress(self) -> QHostAddress: ...
    def localPort(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def isValid(self) -> bool: ...
    def disconnectFromHost(self) -> None: ...
    @overload
    def connectToHost(self, hostName: str, port: int, mode: typing.Union[int, int] = ..., protocol: int = ...) -> None: ...
    @overload
    def connectToHost(self, address: typing.Union[QHostAddress, int], port: int, mode: typing.Union[int, int] = ...) -> None: ...


class QAuthenticator(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QAuthenticator) -> None: ...

    def setOption(self, opt: str, value: typing.Any) -> None: ...
    def options(self) -> typing.Dict[str, typing.Any]: ...
    def option(self, opt: str) -> typing.Any: ...
    def isNull(self) -> bool: ...
    def realm(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def password(self) -> str: ...
    def setUser(self, user: str) -> None: ...
    def user(self) -> str: ...


class QDnsDomainNameRecord(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QDnsDomainNameRecord) -> None: ...

    def value(self) -> str: ...
    def timeToLive(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsDomainNameRecord) -> None: ...


class QDnsHostAddressRecord(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QDnsHostAddressRecord) -> None: ...

    def value(self) -> QHostAddress: ...
    def timeToLive(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsHostAddressRecord) -> None: ...


class QDnsMailExchangeRecord(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QDnsMailExchangeRecord) -> None: ...

    def timeToLive(self) -> int: ...
    def preference(self) -> int: ...
    def name(self) -> str: ...
    def exchange(self) -> str: ...
    def swap(self, other: QDnsMailExchangeRecord) -> None: ...


class QDnsServiceRecord(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QDnsServiceRecord) -> None: ...

    def weight(self) -> int: ...
    def timeToLive(self) -> int: ...
    def target(self) -> str: ...
    def priority(self) -> int: ...
    def port(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsServiceRecord) -> None: ...


class QDnsTextRecord(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QDnsTextRecord) -> None: ...

    def values(self) -> typing.List[QtCore.QByteArray]: ...
    def timeToLive(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: QDnsTextRecord) -> None: ...


class QDnsLookup(QtCore.QObject):

    finished: PYQT_SIGNAL
    nameChanged: PYQT_SIGNAL
    nameserverChanged: PYQT_SIGNAL
    typeChanged: PYQT_SIGNAL

    Type: typing.Type[int]
    #class Type(int): ...
    A = ... # type: int
    AAAA = ... # type: int
    ANY = ... # type: int
    CNAME = ... # type: int
    MX = ... # type: int
    NS = ... # type: int
    PTR = ... # type: int
    SRV = ... # type: int
    TXT = ... # type: int

    Error: typing.Type[int]
    #class Error(int): ...
    NoError = ... # type: int
    ResolverError = ... # type: int
    OperationCancelledError = ... # type: int
    InvalidRequestError = ... # type: int
    InvalidReplyError = ... # type: int
    ServerFailureError = ... # type: int
    ServerRefusedError = ... # type: int
    NotFoundError = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, type: int, name: str, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, type: int, name: str, nameserver: typing.Union[QHostAddress, int], parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def nameserverChanged(self, nameserver: typing.Union[QHostAddress, int]) -> None: ...
    def setNameserver(self, nameserver: typing.Union[QHostAddress, int]) -> None: ...
    def nameserver(self) -> QHostAddress: ...
    #def typeChanged(self, type: int) -> None: ...
    #def nameChanged(self, name: str) -> None: ...
    #def finished(self) -> None: ...
    def lookup(self) -> None: ...
    def abort(self) -> None: ...
    def textRecords(self) -> typing.List[QDnsTextRecord]: ...
    def serviceRecords(self) -> typing.List[QDnsServiceRecord]: ...
    def pointerRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def nameServerRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def mailExchangeRecords(self) -> typing.List[QDnsMailExchangeRecord]: ...
    def hostAddressRecords(self) -> typing.List[QDnsHostAddressRecord]: ...
    def canonicalNameRecords(self) -> typing.List[QDnsDomainNameRecord]: ...
    def setType(self, a0: int) -> None: ...
    def type(self) -> int: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def isFinished(self) -> bool: ...
    def errorString(self) -> str: ...
    def error(self) -> int: ...


class QHostAddress(sip.simplewrapper):

    ConversionModeFlag: typing.Type[int]
    #class ConversionModeFlag(int): ...
    ConvertV4MappedToIPv4 = ... # type: int
    ConvertV4CompatToIPv4 = ... # type: int
    ConvertUnspecifiedAddress = ... # type: int
    ConvertLocalHost = ... # type: int
    TolerantConversion = ... # type: int
    StrictConversion = ... # type: int

    SpecialAddress: typing.Type[int]
    #class SpecialAddress(int): ...
    Null = ... # type: int
    Broadcast = ... # type: int
    LocalHost = ... # type: int
    LocalHostIPv6 = ... # type: int
    AnyIPv4 = ... # type: int
    AnyIPv6 = ... # type: int
    Any = ... # type: int

    ConversionMode: typing.Type[int]
    #class ConversionMode(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QHostAddress.ConversionMode, QHostAddress.ConversionModeFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QHostAddress.ConversionMode) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QHostAddress.ConversionMode: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, address: int) -> None: ...
    @overload
    def __init__(self, ip4Addr: int) -> None: ...
    @overload
    def __init__(self, address: str) -> None: ...
    @overload
    def __init__(self, ip6Addr: typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]) -> None: ...
    @overload
    def __init__(self, copy: typing.Union[QHostAddress, int]) -> None: ...

    def isBroadcast(self) -> bool: ...
    def isUniqueLocalUnicast(self) -> bool: ...
    def isSiteLocal(self) -> bool: ...
    def isLinkLocal(self) -> bool: ...
    def isGlobal(self) -> bool: ...
    def isEqual(self, address: typing.Union[QHostAddress, int], mode: typing.Union[int, int] = ...) -> bool: ...
    def isMulticast(self) -> bool: ...
    def swap(self, other: QHostAddress) -> None: ...
    @staticmethod
    def parseSubnet(subnet: str) -> typing.Tuple[QHostAddress, int]: ...
    def isLoopback(self) -> bool: ...
    @overload
    def isInSubnet(self, subnet: typing.Union[QHostAddress, int], netmask: int) -> bool: ...
    @overload
    def isInSubnet(self, subnet: typing.Tuple[typing.Union[QHostAddress, int], int]) -> bool: ...
    def __hash__(self) -> int: ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...
    def setScopeId(self, id: str) -> None: ...
    def scopeId(self) -> str: ...
    def toString(self) -> str: ...
    def toIPv6Address(self) -> typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...
    def toIPv4Address(self) -> int: ...
    def protocol(self) -> int: ...
    @overload
    def setAddress(self, address: int) -> None: ...
    @overload
    def setAddress(self, ip4Addr: int) -> None: ...
    @overload
    def setAddress(self, address: str) -> bool: ...
    @overload
    def setAddress(self, ip6Addr: typing.Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]) -> None: ...


class QHostInfo(sip.simplewrapper):

    HostInfoError: typing.Type[int]
    #class HostInfoError(int): ...
    NoError = ... # type: int
    HostNotFound = ... # type: int
    UnknownError = ... # type: int

    @overload
    def __init__(self, id: int = ...) -> None: ...
    @overload
    def __init__(self, d: QHostInfo) -> None: ...

    def swap(self, other: QHostInfo) -> None: ...
    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    @staticmethod
    def fromName(name: str) -> QHostInfo: ...
    @staticmethod
    def abortHostLookup(lookupId: int) -> None: ...
    @staticmethod
    def lookupHost(name: str, slot: PYQT_SLOT) -> int: ...
    def lookupId(self) -> int: ...
    def setLookupId(self, id: int) -> None: ...
    def setErrorString(self, errorString: str) -> None: ...
    def errorString(self) -> str: ...
    def setError(self, error: int) -> None: ...
    def error(self) -> int: ...
    def setAddresses(self, addresses: typing.Iterable[typing.Union[QHostAddress, int]]) -> None: ...
    def addresses(self) -> typing.List[QHostAddress]: ...
    def setHostName(self, name: str) -> None: ...
    def hostName(self) -> str: ...


class QHstsPolicy(sip.simplewrapper):

    PolicyFlag: typing.Type[int]
    #class PolicyFlag(int): ...
    IncludeSubDomains = ... # type: int

    PolicyFlags: typing.Type[int]
    #class PolicyFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QHstsPolicy.PolicyFlags, QHstsPolicy.PolicyFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QHstsPolicy.PolicyFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QHstsPolicy.PolicyFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, expiry: typing.Union[QtCore.QDateTime, datetime.datetime], flags: typing.Union[int, int], host: str, mode: int = ...) -> None: ...
    @overload
    def __init__(self, rhs: QHstsPolicy) -> None: ...

    def isExpired(self) -> bool: ...
    def includesSubDomains(self) -> bool: ...
    def setIncludesSubDomains(self, include: bool) -> None: ...
    def expiry(self) -> QtCore.QDateTime: ...
    def setExpiry(self, expiry: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def host(self, options: typing.Union[int, int] = ...) -> str: ...
    def setHost(self, host: str, mode: int = ...) -> None: ...
    def swap(self, other: QHstsPolicy) -> None: ...


class QHttpPart(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QHttpPart) -> None: ...

    def swap(self, other: QHttpPart) -> None: ...
    def setBodyDevice(self, device: QtCore.QIODevice) -> None: ...
    def setBody(self, body: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], headerValue: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setHeader(self, header: int, value: typing.Any) -> None: ...


class QHttpMultiPart(QtCore.QObject):

    ContentType: typing.Type[int]
    #class ContentType(int): ...
    MixedType = ... # type: int
    RelatedType = ... # type: int
    FormDataType = ... # type: int
    AlternativeType = ... # type: int

    @overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...
    @overload
    def __init__(self, contentType: int, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def setBoundary(self, boundary: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def boundary(self) -> QtCore.QByteArray: ...
    def setContentType(self, contentType: int) -> None: ...
    def append(self, httpPart: QHttpPart) -> None: ...


class QLocalServer(QtCore.QObject):

    newConnection: PYQT_SIGNAL

    SocketOption: typing.Type[int]
    #class SocketOption(int): ...
    UserAccessOption = ... # type: int
    GroupAccessOption = ... # type: int
    OtherAccessOption = ... # type: int
    WorldAccessOption = ... # type: int

    SocketOptions: typing.Type[int]
    #class SocketOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QLocalServer.SocketOptions, QLocalServer.SocketOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QLocalServer.SocketOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QLocalServer.SocketOptions: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def socketDescriptor(self) -> sip.voidptr: ...
    def socketOptions(self) -> int: ...
    def setSocketOptions(self, options: typing.Union[int, int]) -> None: ...
    def incomingConnection(self, socketDescriptor: sip.voidptr) -> None: ...
    #def newConnection(self) -> None: ...
    @staticmethod
    def removeServer(name: str) -> bool: ...
    def waitForNewConnection(self, msecs: int = ...) -> typing.Tuple[bool, bool]: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def serverError(self) -> int: ...
    def fullServerName(self) -> str: ...
    def serverName(self) -> str: ...
    def nextPendingConnection(self) -> QLocalSocket: ...
    def maxPendingConnections(self) -> int: ...
    @overload
    def listen(self, name: str) -> bool: ...
    @overload
    def listen(self, socketDescriptor: sip.voidptr) -> bool: ...
    def isListening(self) -> bool: ...
    def hasPendingConnections(self) -> bool: ...
    def errorString(self) -> str: ...
    def close(self) -> None: ...


class _QLocalSocketErrorMethod(PYQT_SIGNAL, typing.Callable[[], int]): ...


class QLocalSocket(QtCore.QIODevice):

    connected: PYQT_SIGNAL
    disconnected: PYQT_SIGNAL
    error: _QLocalSocketErrorMethod
    stateChanged: PYQT_SIGNAL

    class LocalSocketState(int):
        UnconnectedState = ... # type: QLocalSocket.LocalSocketState
        ConnectingState = ... # type: QLocalSocket.LocalSocketState
        ConnectedState = ... # type: QLocalSocket.LocalSocketState
        ClosingState = ... # type: QLocalSocket.LocalSocketState

    class LocalSocketError(int):
        ConnectionRefusedError = ... # type: QLocalSocket.LocalSocketError
        PeerClosedError = ... # type: QLocalSocket.LocalSocketError
        ServerNotFoundError = ... # type: QLocalSocket.LocalSocketError
        SocketAccessError = ... # type: QLocalSocket.LocalSocketError
        SocketResourceError = ... # type: QLocalSocket.LocalSocketError
        SocketTimeoutError = ... # type: QLocalSocket.LocalSocketError
        DatagramTooLargeError = ... # type: QLocalSocket.LocalSocketError
        ConnectionError = ... # type: QLocalSocket.LocalSocketError
        UnsupportedSocketOperationError = ... # type: QLocalSocket.LocalSocketError
        OperationError = ... # type: QLocalSocket.LocalSocketError
        UnknownSocketError = ... # type: QLocalSocket.LocalSocketError

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def writeData(self, a0: bytes) -> int: ...
    def readData(self, maxlen: int) -> bytes: ...
    #def stateChanged(self, socketState: int) -> None: ...
    #def disconnected(self) -> None: ...
    #def connected(self) -> None: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def state(self) -> int: ...
    def socketDescriptor(self) -> sip.voidptr: ...
    def setSocketDescriptor(self, socketDescriptor: sip.voidptr, state: int = ..., mode: typing.Union[int, int] = ...) -> bool: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def isValid(self) -> bool: ...
    def flush(self) -> bool: ...
    #@overload
    #def error(self) -> int: ...
    #@overload
    #def error(self, socketError: int) -> None: ...
    def close(self) -> None: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def isSequential(self) -> bool: ...
    def abort(self) -> None: ...
    def fullServerName(self) -> str: ...
    def setServerName(self, name: str) -> None: ...
    def serverName(self) -> str: ...
    def open(self, mode: typing.Union[int, int] = ...) -> bool: ...
    def disconnectFromServer(self) -> None: ...
    @overload
    def connectToServer(self, name: str, mode: typing.Union[int, int] = ...) -> None: ...
    @overload
    def connectToServer(self, mode: typing.Union[int, int] = ...) -> None: ...


class QNetworkAccessManager(QtCore.QObject):

    authenticationRequired: PYQT_SIGNAL
    encrypted: PYQT_SIGNAL
    finished: PYQT_SIGNAL
    networkAccessibleChanged: PYQT_SIGNAL
    preSharedKeyAuthenticationRequired: PYQT_SIGNAL
    proxyAuthenticationRequired: PYQT_SIGNAL
    sslErrors: PYQT_SIGNAL

    NetworkAccessibility: typing.Type[int]
    #class NetworkAccessibility(int): ...
    UnknownAccessibility = ... # type: int
    NotAccessible = ... # type: int
    Accessible = ... # type: int

    Operation: typing.Type[int]
    #class Operation(int): ...
    HeadOperation = ... # type: int
    GetOperation = ... # type: int
    PutOperation = ... # type: int
    PostOperation = ... # type: int
    DeleteOperation = ... # type: int
    CustomOperation = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def isStrictTransportSecurityStoreEnabled(self) -> bool: ...
    def enableStrictTransportSecurityStore(self, enabled: bool, storeDir: str = ...) -> None: ...
    def redirectPolicy(self) -> int: ...
    def setRedirectPolicy(self, policy: int) -> None: ...
    def strictTransportSecurityHosts(self) -> typing.List[QHstsPolicy]: ...
    def addStrictTransportSecurityHosts(self, knownHosts: typing.Iterable[QHstsPolicy]) -> None: ...
    def isStrictTransportSecurityEnabled(self) -> bool: ...
    def setStrictTransportSecurityEnabled(self, enabled: bool) -> None: ...
    def clearConnectionCache(self) -> None: ...
    def supportedSchemesImplementation(self) -> typing.List[str]: ...
    def connectToHost(self, hostName: str, port: int = ...) -> None: ...
    def connectToHostEncrypted(self, hostName: str, port: int = ..., sslConfiguration: QSslConfiguration = ...) -> None: ...
    def supportedSchemes(self) -> typing.List[str]: ...
    def clearAccessCache(self) -> None: ...
    def networkAccessible(self) -> int: ...
    def setNetworkAccessible(self, accessible: int) -> None: ...
    def activeConfiguration(self) -> QNetworkConfiguration: ...
    def configuration(self) -> QNetworkConfiguration: ...
    def setConfiguration(self, config: QNetworkConfiguration) -> None: ...
    @overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: typing.Union[QtCore.QByteArray, bytes, bytearray], data: typing.Optional[QtCore.QIODevice] = ...) -> QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: typing.Union[QtCore.QByteArray, bytes, bytearray], data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: QNetworkRequest, verb: typing.Union[QtCore.QByteArray, bytes, bytearray], multiPart: QHttpMultiPart) -> QNetworkReply: ...
    def deleteResource(self, request: QNetworkRequest) -> QNetworkReply: ...
    def setCache(self, cache: QAbstractNetworkCache) -> None: ...
    def cache(self) -> QAbstractNetworkCache: ...
    def setProxyFactory(self, factory: QNetworkProxyFactory) -> None: ...
    def proxyFactory(self) -> QNetworkProxyFactory: ...
    def createRequest(self, op: int, request: QNetworkRequest, device: typing.Optional[QtCore.QIODevice] = ...) -> QNetworkReply: ...
    #def preSharedKeyAuthenticationRequired(self, reply: QNetworkReply, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...
    #def networkAccessibleChanged(self, accessible: int) -> None: ...
    #def sslErrors(self, reply: QNetworkReply, errors: typing.Iterable[QSslError]) -> None: ...
    #def encrypted(self, reply: QNetworkReply) -> None: ...
    #def finished(self, reply: QNetworkReply) -> None: ...
    #def authenticationRequired(self, reply: QNetworkReply, authenticator: QAuthenticator) -> None: ...
    #def proxyAuthenticationRequired(self, proxy: QNetworkProxy, authenticator: QAuthenticator) -> None: ...
    @overload
    def put(self, request: QNetworkRequest, data: QtCore.QIODevice) -> QNetworkReply: ...
    @overload
    def put(self, request: QNetworkRequest, data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QNetworkReply: ...
    @overload
    def put(self, request: QNetworkRequest, multiPart: QHttpMultiPart) -> QNetworkReply: ...
    @overload
    def post(self, request: QNetworkRequest, data: QtCore.QIODevice) -> QNetworkReply: ...
    @overload
    def post(self, request: QNetworkRequest, data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QNetworkReply: ...
    @overload
    def post(self, request: QNetworkRequest, multiPart: QHttpMultiPart) -> QNetworkReply: ...
    def get(self, request: QNetworkRequest) -> QNetworkReply: ...
    def head(self, request: QNetworkRequest) -> QNetworkReply: ...
    def setCookieJar(self, cookieJar: QNetworkCookieJar) -> None: ...
    def cookieJar(self) -> QNetworkCookieJar: ...
    def setProxy(self, proxy: QNetworkProxy) -> None: ...
    def proxy(self) -> QNetworkProxy: ...


class QNetworkConfigurationManager(QtCore.QObject):

    configurationAdded: PYQT_SIGNAL
    configurationChanged: PYQT_SIGNAL
    configurationRemoved: PYQT_SIGNAL
    onlineStateChanged: PYQT_SIGNAL
    updateCompleted: PYQT_SIGNAL

    class Capability(int):
        CanStartAndStopInterfaces = ... # type: QNetworkConfigurationManager.Capability
        DirectConnectionRouting = ... # type: QNetworkConfigurationManager.Capability
        SystemSessionSupport = ... # type: QNetworkConfigurationManager.Capability
        ApplicationLevelRoaming = ... # type: QNetworkConfigurationManager.Capability
        ForcedRoaming = ... # type: QNetworkConfigurationManager.Capability
        DataStatistics = ... # type: QNetworkConfigurationManager.Capability
        NetworkSessionRequired = ... # type: QNetworkConfigurationManager.Capability

    Capabilities: typing.Type[int]
    #class Capabilities(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QNetworkConfigurationManager.Capabilities, QNetworkConfigurationManager.Capability]) -> None: ...
        #@overload
        #def __init__(self, a0: QNetworkConfigurationManager.Capabilities) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QNetworkConfigurationManager.Capabilities: ...
        #def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def updateCompleted(self) -> None: ...
    #def onlineStateChanged(self, isOnline: bool) -> None: ...
    #def configurationChanged(self, config: QNetworkConfiguration) -> None: ...
    #def configurationRemoved(self, config: QNetworkConfiguration) -> None: ...
    #def configurationAdded(self, config: QNetworkConfiguration) -> None: ...
    def isOnline(self) -> bool: ...
    def updateConfigurations(self) -> None: ...
    def configurationFromIdentifier(self, identifier: str) -> QNetworkConfiguration: ...
    def allConfigurations(self, flags: typing.Union[int, int] = ...) -> typing.List[QNetworkConfiguration]: ...
    def defaultConfiguration(self) -> QNetworkConfiguration: ...
    def capabilities(self) -> int: ...


class QNetworkConfiguration(sip.simplewrapper):

    BearerType: typing.Type[int]
    #class BearerType(int): ...
    BearerUnknown = ... # type: int
    BearerEthernet = ... # type: int
    BearerWLAN = ... # type: int
    Bearer2G = ... # type: int
    BearerCDMA2000 = ... # type: int
    BearerWCDMA = ... # type: int
    BearerHSPA = ... # type: int
    BearerBluetooth = ... # type: int
    BearerWiMAX = ... # type: int
    BearerEVDO = ... # type: int
    BearerLTE = ... # type: int
    Bearer3G = ... # type: int
    Bearer4G = ... # type: int

    class StateFlag(int):
        Undefined = ... # type: QNetworkConfiguration.StateFlag
        Defined = ... # type: QNetworkConfiguration.StateFlag
        Discovered = ... # type: QNetworkConfiguration.StateFlag
        Active = ... # type: QNetworkConfiguration.StateFlag

    class Purpose(int):
        UnknownPurpose = ... # type: QNetworkConfiguration.Purpose
        PublicPurpose = ... # type: QNetworkConfiguration.Purpose
        PrivatePurpose = ... # type: QNetworkConfiguration.Purpose
        ServiceSpecificPurpose = ... # type: QNetworkConfiguration.Purpose

    class Type(int):
        InternetAccessPoint = ... # type: QNetworkConfiguration.Type
        ServiceNetwork = ... # type: QNetworkConfiguration.Type
        UserChoice = ... # type: QNetworkConfiguration.Type
        Invalid = ... # type: QNetworkConfiguration.Type

    StateFlags: typing.Type[int]
    #class StateFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QNetworkConfiguration.StateFlags, QNetworkConfiguration.StateFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QNetworkConfiguration.StateFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QNetworkConfiguration.StateFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QNetworkConfiguration) -> None: ...

    def setConnectTimeout(self, timeout: int) -> bool: ...
    def connectTimeout(self) -> int: ...
    def swap(self, other: QNetworkConfiguration) -> None: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def children(self) -> typing.List[QNetworkConfiguration]: ...
    def isRoamingAvailable(self) -> bool: ...
    def identifier(self) -> str: ...
    def bearerTypeFamily(self) -> int: ...
    def bearerTypeName(self) -> str: ...
    def bearerType(self) -> int: ...
    def purpose(self) -> int: ...
    def type(self) -> int: ...
    def state(self) -> int: ...


class QNetworkCookie(sip.simplewrapper):

    RawForm: typing.Type[int]
    #class RawForm(int): ...
    NameAndValueOnly = ... # type: int
    Full = ... # type: int

    @overload
    def __init__(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., value: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @overload
    def __init__(self, other: QNetworkCookie) -> None: ...

    def normalize(self, url: QtCore.QUrl) -> None: ...
    def hasSameIdentifier(self, other: QNetworkCookie) -> bool: ...
    def swap(self, other: QNetworkCookie) -> None: ...
    def setHttpOnly(self, enable: bool) -> None: ...
    def isHttpOnly(self) -> bool: ...
    @staticmethod
    def parseCookies(cookieString: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.List[QNetworkCookie]: ...
    def toRawForm(self, form: int = ...) -> QtCore.QByteArray: ...
    def setValue(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def value(self) -> QtCore.QByteArray: ...
    def setName(self, cookieName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def name(self) -> QtCore.QByteArray: ...
    def setPath(self, path: str) -> None: ...
    def path(self) -> str: ...
    def setDomain(self, domain: str) -> None: ...
    def domain(self) -> str: ...
    def setExpirationDate(self, date: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def expirationDate(self) -> QtCore.QDateTime: ...
    def isSessionCookie(self) -> bool: ...
    def setSecure(self, enable: bool) -> None: ...
    def isSecure(self) -> bool: ...


class QNetworkCookieJar(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def validateCookie(self, cookie: QNetworkCookie, url: QtCore.QUrl) -> bool: ...
    def allCookies(self) -> typing.List[QNetworkCookie]: ...
    def setAllCookies(self, cookieList: typing.Iterable[QNetworkCookie]) -> None: ...
    def deleteCookie(self, cookie: QNetworkCookie) -> bool: ...
    def updateCookie(self, cookie: QNetworkCookie) -> bool: ...
    def insertCookie(self, cookie: QNetworkCookie) -> bool: ...
    def setCookiesFromUrl(self, cookieList: typing.Iterable[QNetworkCookie], url: QtCore.QUrl) -> bool: ...
    def cookiesForUrl(self, url: QtCore.QUrl) -> typing.List[QNetworkCookie]: ...


class QNetworkDatagram(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray], destinationAddress: typing.Union[QHostAddress, int] = ..., port: int = ...) -> None: ...
    @overload
    def __init__(self, other: QNetworkDatagram) -> None: ...

    def makeReply(self, payload: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QNetworkDatagram: ...
    def setData(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def setHopLimit(self, count: int) -> None: ...
    def hopLimit(self) -> int: ...
    def setDestination(self, address: typing.Union[QHostAddress, int], port: int) -> None: ...
    def setSender(self, address: typing.Union[QHostAddress, int], port: int = ...) -> None: ...
    def destinationPort(self) -> int: ...
    def senderPort(self) -> int: ...
    def destinationAddress(self) -> QHostAddress: ...
    def senderAddress(self) -> QHostAddress: ...
    def setInterfaceIndex(self, index: int) -> None: ...
    def interfaceIndex(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def clear(self) -> None: ...
    def swap(self, other: QNetworkDatagram) -> None: ...


class QNetworkDiskCache(QAbstractNetworkCache):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def expire(self) -> int: ...
    def clear(self) -> None: ...
    def fileMetaData(self, fileName: str) -> QNetworkCacheMetaData: ...
    def insert(self, device: QtCore.QIODevice) -> None: ...
    def prepare(self, metaData: QNetworkCacheMetaData) -> QtCore.QIODevice: ...
    def remove(self, url: QtCore.QUrl) -> bool: ...
    def data(self, url: QtCore.QUrl) -> QtCore.QIODevice: ...
    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None: ...
    def metaData(self, url: QtCore.QUrl) -> QNetworkCacheMetaData: ...
    def cacheSize(self) -> int: ...
    def setMaximumCacheSize(self, size: int) -> None: ...
    def maximumCacheSize(self) -> int: ...
    def setCacheDirectory(self, cacheDir: str) -> None: ...
    def cacheDirectory(self) -> str: ...


class QNetworkAddressEntry(sip.simplewrapper):

    DnsEligibilityStatus: typing.Type[int]
    #class DnsEligibilityStatus(int): ...
    DnsEligibilityUnknown = ... # type: int
    DnsIneligible = ... # type: int
    DnsEligible = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QNetworkAddressEntry) -> None: ...

    def isTemporary(self) -> bool: ...
    def isPermanent(self) -> bool: ...
    def clearAddressLifetime(self) -> None: ...
    def setAddressLifetime(self, preferred: QtCore.QDeadlineTimer, validity: QtCore.QDeadlineTimer) -> None: ...
    def validityLifetime(self) -> QtCore.QDeadlineTimer: ...
    def preferredLifetime(self) -> QtCore.QDeadlineTimer: ...
    def isLifetimeKnown(self) -> bool: ...
    def setDnsEligibility(self, status: int) -> None: ...
    def dnsEligibility(self) -> int: ...
    def swap(self, other: QNetworkAddressEntry) -> None: ...
    def setPrefixLength(self, length: int) -> None: ...
    def prefixLength(self) -> int: ...
    def setBroadcast(self, newBroadcast: typing.Union[QHostAddress, int]) -> None: ...
    def broadcast(self) -> QHostAddress: ...
    def setNetmask(self, newNetmask: typing.Union[QHostAddress, int]) -> None: ...
    def netmask(self) -> QHostAddress: ...
    def setIp(self, newIp: typing.Union[QHostAddress, int]) -> None: ...
    def ip(self) -> QHostAddress: ...


class QNetworkInterface(sip.simplewrapper):

    InterfaceType: typing.Type[int]
    #class InterfaceType(int): ...
    Unknown = ... # type: int
    Loopback = ... # type: int
    Virtual = ... # type: int
    Ethernet = ... # type: int
    Slip = ... # type: int
    CanBus = ... # type: int
    Ppp = ... # type: int
    Fddi = ... # type: int
    Wifi = ... # type: int
    Ieee80211 = ... # type: int
    Phonet = ... # type: int
    Ieee802154 = ... # type: int
    SixLoWPAN = ... # type: int
    Ieee80216 = ... # type: int
    Ieee1394 = ... # type: int

    InterfaceFlag: typing.Type[int]
    #class InterfaceFlag(int): ...
    IsUp = ... # type: int
    IsRunning = ... # type: int
    CanBroadcast = ... # type: int
    IsLoopBack = ... # type: int
    IsPointToPoint = ... # type: int
    CanMulticast = ... # type: int

    InterfaceFlags: typing.Type[int]
    #class InterfaceFlags(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QNetworkInterface.InterfaceFlags, QNetworkInterface.InterfaceFlag]) -> None: ...
        #@overload
        #def __init__(self, a0: QNetworkInterface.InterfaceFlags) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QNetworkInterface.InterfaceFlags: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QNetworkInterface) -> None: ...

    def maximumTransmissionUnit(self) -> int: ...
    def type(self) -> int: ...
    @staticmethod
    def interfaceNameFromIndex(index: int) -> str: ...
    @staticmethod
    def interfaceIndexFromName(name: str) -> int: ...
    def swap(self, other: QNetworkInterface) -> None: ...
    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def allAddresses() -> typing.List[QHostAddress]: ...
    @staticmethod
    def allInterfaces() -> typing.List[QNetworkInterface]: ...
    @staticmethod
    def interfaceFromIndex(index: int) -> QNetworkInterface: ...
    @staticmethod
    def interfaceFromName(name: str) -> QNetworkInterface: ...
    def addressEntries(self) -> typing.List[QNetworkAddressEntry]: ...
    def hardwareAddress(self) -> str: ...
    def flags(self) -> int: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QNetworkProxy(sip.simplewrapper):

    Capability: typing.Type[int]
    #class Capability(int): ...
    TunnelingCapability = ... # type: int
    ListeningCapability = ... # type: int
    UdpTunnelingCapability = ... # type: int
    CachingCapability = ... # type: int
    HostNameLookupCapability = ... # type: int
    SctpTunnelingCapability = ... # type: int
    SctpListeningCapability = ... # type: int

    ProxyType: typing.Type[int]
    #class ProxyType(int): ...
    DefaultProxy = ... # type: int
    Socks5Proxy = ... # type: int
    NoProxy = ... # type: int
    HttpProxy = ... # type: int
    HttpCachingProxy = ... # type: int
    FtpCachingProxy = ... # type: int

    Capabilities: typing.Type[int]
    #class Capabilities(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QNetworkProxy.Capabilities, QNetworkProxy.Capability]) -> None: ...
        #@overload
        #def __init__(self, a0: QNetworkProxy.Capabilities) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QNetworkProxy.Capabilities: ...
        #def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: int, hostName: str = ..., port: int = ..., user: str = ..., password: str = ...) -> None: ...
    @overload
    def __init__(self, other: QNetworkProxy) -> None: ...

    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def rawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def setHeader(self, header: int, value: typing.Any) -> None: ...
    def header(self, header: int) -> typing.Any: ...
    def swap(self, other: QNetworkProxy) -> None: ...
    def capabilities(self) -> int: ...
    def setCapabilities(self, capab: typing.Union[int, int]) -> None: ...
    def isTransparentProxy(self) -> bool: ...
    def isCachingProxy(self) -> bool: ...
    @staticmethod
    def applicationProxy() -> QNetworkProxy: ...
    @staticmethod
    def setApplicationProxy(proxy: QNetworkProxy) -> None: ...
    def port(self) -> int: ...
    def setPort(self, port: int) -> None: ...
    def hostName(self) -> str: ...
    def setHostName(self, hostName: str) -> None: ...
    def password(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def user(self) -> str: ...
    def setUser(self, userName: str) -> None: ...
    def type(self) -> int: ...
    def setType(self, type: int) -> None: ...


class QNetworkProxyQuery(sip.simplewrapper):

    QueryType: typing.Type[int]
    #class QueryType(int): ...
    TcpSocket = ... # type: int
    UdpSocket = ... # type: int
    TcpServer = ... # type: int
    UrlRequest = ... # type: int
    SctpSocket = ... # type: int
    SctpServer = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, requestUrl: QtCore.QUrl, type: int = ...) -> None: ...
    @overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, bindPort: int, protocolTag: str = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, requestUrl: QtCore.QUrl, queryType: int = ...) -> None: ...
    @overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, hostname: str, port: int, protocolTag: str = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, networkConfiguration: QNetworkConfiguration, bindPort: int, protocolTag: str = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QNetworkProxyQuery) -> None: ...

    def swap(self, other: QNetworkProxyQuery) -> None: ...
    def setNetworkConfiguration(self, networkConfiguration: QNetworkConfiguration) -> None: ...
    def networkConfiguration(self) -> QNetworkConfiguration: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setProtocolTag(self, protocolTag: str) -> None: ...
    def protocolTag(self) -> str: ...
    def setLocalPort(self, port: int) -> None: ...
    def localPort(self) -> int: ...
    def setPeerHostName(self, hostname: str) -> None: ...
    def peerHostName(self) -> str: ...
    def setPeerPort(self, port: int) -> None: ...
    def peerPort(self) -> int: ...
    def setQueryType(self, type: int) -> None: ...
    def queryType(self) -> int: ...


class QNetworkProxyFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QNetworkProxyFactory) -> None: ...

    @staticmethod
    def usesSystemConfiguration() -> bool: ...
    @staticmethod
    def setUseSystemConfiguration(enable: bool) -> None: ...
    @staticmethod
    def systemProxyForQuery(query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def proxyForQuery(query: QNetworkProxyQuery) -> typing.List[QNetworkProxy]: ...
    @staticmethod
    def setApplicationProxyFactory(factory: QNetworkProxyFactory) -> None: ...
    def queryProxy(self, query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]: ...


class QNetworkReply(QtCore.QIODevice):

    downloadProgress: PYQT_SIGNAL
    encrypted: PYQT_SIGNAL
    error: PYQT_SIGNAL
    finished: PYQT_SIGNAL
    metaDataChanged: PYQT_SIGNAL
    preSharedKeyAuthenticationRequired: PYQT_SIGNAL
    redirectAllowed: PYQT_SIGNAL
    redirected: PYQT_SIGNAL
    sslErrors: PYQT_SIGNAL
    uploadProgress: PYQT_SIGNAL

    NetworkError: typing.Type[int]
    #class NetworkError(int): ...
    NoError = ... # type: int
    ConnectionRefusedError = ... # type: int
    RemoteHostClosedError = ... # type: int
    HostNotFoundError = ... # type: int
    TimeoutError = ... # type: int
    OperationCanceledError = ... # type: int
    SslHandshakeFailedError = ... # type: int
    UnknownNetworkError = ... # type: int
    ProxyConnectionRefusedError = ... # type: int
    ProxyConnectionClosedError = ... # type: int
    ProxyNotFoundError = ... # type: int
    ProxyTimeoutError = ... # type: int
    ProxyAuthenticationRequiredError = ... # type: int
    UnknownProxyError = ... # type: int
    ContentAccessDenied = ... # type: int
    ContentOperationNotPermittedError = ... # type: int
    ContentNotFoundError = ... # type: int
    AuthenticationRequiredError = ... # type: int
    UnknownContentError = ... # type: int
    ProtocolUnknownError = ... # type: int
    ProtocolInvalidOperationError = ... # type: int
    ProtocolFailure = ... # type: int
    ContentReSendError = ... # type: int
    TemporaryNetworkFailureError = ... # type: int
    NetworkSessionFailedError = ... # type: int
    BackgroundRequestNotAllowedError = ... # type: int
    ContentConflictError = ... # type: int
    ContentGoneError = ... # type: int
    InternalServerError = ... # type: int
    OperationNotImplementedError = ... # type: int
    ServiceUnavailableError = ... # type: int
    UnknownServerError = ... # type: int
    TooManyRedirectsError = ... # type: int
    InsecureRedirectError = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def ignoreSslErrorsImplementation(self, a0: typing.Iterable[QSslError]) -> None: ...
    def setSslConfigurationImplementation(self, a0: QSslConfiguration) -> None: ...
    def sslConfigurationImplementation(self, a0: QSslConfiguration) -> None: ...
    def rawHeaderPairs(self) -> typing.List[typing.Tuple[QtCore.QByteArray, QtCore.QByteArray]]: ...
    def isRunning(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def setFinished(self, finished: bool) -> None: ...
    def setAttribute(self, code: int, value: typing.Any) -> None: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def setHeader(self, header: int, value: typing.Any) -> None: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def setError(self, errorCode: int, errorString: str) -> None: ...
    def setRequest(self, request: QNetworkRequest) -> None: ...
    def setOperation(self, operation: int) -> None: ...
    def writeData(self, data: bytes) -> int: ...
    #def redirectAllowed(self) -> None: ...
    #def redirected(self, url: QtCore.QUrl) -> None: ...
    #def preSharedKeyAuthenticationRequired(self, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...
    #def downloadProgress(self, bytesReceived: int, bytesTotal: int) -> None: ...
    #def uploadProgress(self, bytesSent: int, bytesTotal: int) -> None: ...
    #def sslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    #def encrypted(self) -> None: ...
    #def finished(self) -> None: ...
    #def metaDataChanged(self) -> None: ...
    @overload
    def ignoreSslErrors(self) -> None: ...
    @overload
    def ignoreSslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    def setSslConfiguration(self, configuration: QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def attribute(self, code: int) -> typing.Any: ...
    def rawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def header(self, header: int) -> typing.Any: ...
    def url(self) -> QtCore.QUrl: ...
    #@overload
    #def error(self) -> int: ...
    #@overload
    #def error(self, a0: int) -> None: ...
    def request(self) -> QNetworkRequest: ...
    def operation(self) -> int: ...
    def manager(self) -> QNetworkAccessManager: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def readBufferSize(self) -> int: ...
    def isSequential(self) -> bool: ...
    def close(self) -> None: ...
    def abort(self) -> None: ...


class QNetworkRequest(sip.simplewrapper):

    RedirectPolicy: typing.Type[int]
    #class RedirectPolicy(int): ...
    ManualRedirectPolicy = ... # type: int
    NoLessSafeRedirectPolicy = ... # type: int
    SameOriginRedirectPolicy = ... # type: int
    UserVerifiedRedirectPolicy = ... # type: int

    Priority: typing.Type[int]
    #class Priority(int): ...
    HighPriority = ... # type: int
    NormalPriority = ... # type: int
    LowPriority = ... # type: int

    LoadControl: typing.Type[int]
    #class LoadControl(int): ...
    Automatic = ... # type: int
    Manual = ... # type: int

    CacheLoadControl: typing.Type[int]
    #class CacheLoadControl(int): ...
    AlwaysNetwork = ... # type: int
    PreferNetwork = ... # type: int
    PreferCache = ... # type: int
    AlwaysCache = ... # type: int

    Attribute: typing.Type[int]
    #class Attribute(int): ...
    HttpStatusCodeAttribute = ... # type: int
    HttpReasonPhraseAttribute = ... # type: int
    RedirectionTargetAttribute = ... # type: int
    ConnectionEncryptedAttribute = ... # type: int
    CacheLoadControlAttribute = ... # type: int
    CacheSaveControlAttribute = ... # type: int
    SourceIsFromCacheAttribute = ... # type: int
    DoNotBufferUploadDataAttribute = ... # type: int
    HttpPipeliningAllowedAttribute = ... # type: int
    HttpPipeliningWasUsedAttribute = ... # type: int
    CustomVerbAttribute = ... # type: int
    CookieLoadControlAttribute = ... # type: int
    AuthenticationReuseAttribute = ... # type: int
    CookieSaveControlAttribute = ... # type: int
    BackgroundRequestAttribute = ... # type: int
    SpdyAllowedAttribute = ... # type: int
    SpdyWasUsedAttribute = ... # type: int
    EmitAllUploadProgressSignalsAttribute = ... # type: int
    FollowRedirectsAttribute = ... # type: int
    HTTP2AllowedAttribute = ... # type: int
    HTTP2WasUsedAttribute = ... # type: int
    OriginalContentLengthAttribute = ... # type: int
    RedirectPolicyAttribute = ... # type: int
    Http2DirectAttribute = ... # type: int
    User = ... # type: int
    UserMax = ... # type: int

    KnownHeaders: typing.Type[int]
    #class KnownHeaders(int): ...
    ContentTypeHeader = ... # type: int
    ContentLengthHeader = ... # type: int
    LocationHeader = ... # type: int
    LastModifiedHeader = ... # type: int
    CookieHeader = ... # type: int
    SetCookieHeader = ... # type: int
    ContentDispositionHeader = ... # type: int
    UserAgentHeader = ... # type: int
    ServerHeader = ... # type: int
    IfModifiedSinceHeader = ... # type: int
    ETagHeader = ... # type: int
    IfMatchHeader = ... # type: int
    IfNoneMatchHeader = ... # type: int

    @overload
    def __init__(self, url: QtCore.QUrl = ...) -> None: ...
    @overload
    def __init__(self, other: QNetworkRequest) -> None: ...

    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int) -> None: ...
    def maximumRedirectsAllowed(self) -> int: ...
    def swap(self, other: QNetworkRequest) -> None: ...
    def setPriority(self, priority: int) -> None: ...
    def priority(self) -> int: ...
    def originatingObject(self) -> QtCore.QObject: ...
    def setOriginatingObject(self, object: QtCore.QObject) -> None: ...
    def setSslConfiguration(self, configuration: QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def setAttribute(self, code: int, value: typing.Any) -> None: ...
    def attribute(self, code: int, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def rawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def setHeader(self, header: int, value: typing.Any) -> None: ...
    def header(self, header: int) -> typing.Any: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...


class QNetworkSession(QtCore.QObject):

    closed: PYQT_SIGNAL
    error: PYQT_SIGNAL
    newConfigurationActivated: PYQT_SIGNAL
    opened: PYQT_SIGNAL
    preferredConfigurationChanged: PYQT_SIGNAL
    stateChanged: PYQT_SIGNAL
    usagePoliciesChanged: PYQT_SIGNAL

    UsagePolicy: typing.Type[int]
    #class UsagePolicy(int): ...
    NoPolicy = ... # type: int
    NoBackgroundTrafficPolicy = ... # type: int

    SessionError: typing.Type[int]
    #class SessionError(int): ...
    UnknownSessionError = ... # type: int
    SessionAbortedError = ... # type: int
    RoamingError = ... # type: int
    OperationNotSupportedError = ... # type: int
    InvalidConfigurationError = ... # type: int

    State: typing.Type[int]
    #class State(int): ...
    Invalid = ... # type: int
    NotAvailable = ... # type: int
    Connecting = ... # type: int
    Connected = ... # type: int
    Closing = ... # type: int
    Disconnected = ... # type: int
    Roaming = ... # type: int

    UsagePolicies: typing.Type[int]
    #class UsagePolicies(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QNetworkSession.UsagePolicies, QNetworkSession.UsagePolicy]) -> None: ...
        #@overload
        #def __init__(self, a0: QNetworkSession.UsagePolicies) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QNetworkSession.UsagePolicies: ...
        #def __int__(self) -> int: ...

    def __init__(self, connConfig: QNetworkConfiguration, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def usagePoliciesChanged(self, usagePolicies: typing.Union[int, int]) -> None: ...
    def usagePolicies(self) -> int: ...
    def disconnectNotify(self, signal: QtCore.QMetaMethod) -> None: ...
    def connectNotify(self, signal: QtCore.QMetaMethod) -> None: ...
    #def newConfigurationActivated(self) -> None: ...
    #def preferredConfigurationChanged(self, config: QNetworkConfiguration, isSeamless: bool) -> None: ...
    #def closed(self) -> None: ...
    #def opened(self) -> None: ...
    #def stateChanged(self, a0: int) -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def ignore(self) -> None: ...
    def migrate(self) -> None: ...
    def stop(self) -> None: ...
    def close(self) -> None: ...
    def open(self) -> None: ...
    def waitForOpened(self, msecs: int = ...) -> bool: ...
    def activeTime(self) -> int: ...
    def bytesReceived(self) -> int: ...
    def bytesWritten(self) -> int: ...
    def setSessionProperty(self, key: str, value: typing.Any) -> None: ...
    def sessionProperty(self, key: str) -> typing.Any: ...
    def errorString(self) -> str: ...
    #@overload
    #def error(self) -> int: ...
    #@overload
    #def error(self, a0: int) -> None: ...
    def state(self) -> int: ...
    def interface(self) -> QNetworkInterface: ...
    def configuration(self) -> QNetworkConfiguration: ...
    def isOpen(self) -> bool: ...


class QPasswordDigestor(sip.simplewrapper):

    def deriveKeyPbkdf2(self, algorithm: int, password: typing.Union[QtCore.QByteArray, bytes, bytearray], salt: typing.Union[QtCore.QByteArray, bytes, bytearray], iterations: int, dkLen: int) -> QtCore.QByteArray: ...
    def deriveKeyPbkdf1(self, algorithm: int, password: typing.Union[QtCore.QByteArray, bytes, bytearray], salt: typing.Union[QtCore.QByteArray, bytes, bytearray], iterations: int, dkLen: int) -> QtCore.QByteArray: ...


class QSsl(sip.simplewrapper):

    SslOption: typing.Type[int]
    #class SslOption(int): ...
    SslOptionDisableEmptyFragments = ... # type: int
    SslOptionDisableSessionTickets = ... # type: int
    SslOptionDisableCompression = ... # type: int
    SslOptionDisableServerNameIndication = ... # type: int
    SslOptionDisableLegacyRenegotiation = ... # type: int
    SslOptionDisableSessionSharing = ... # type: int
    SslOptionDisableSessionPersistence = ... # type: int
    SslOptionDisableServerCipherPreference = ... # type: int

    SslProtocol: typing.Type[int]
    #class SslProtocol(int): ...
    UnknownProtocol = ... # type: int
    SslV3 = ... # type: int
    SslV2 = ... # type: int
    TlsV1_0 = ... # type: int
    TlsV1_0OrLater = ... # type: int
    TlsV1_1 = ... # type: int
    TlsV1_1OrLater = ... # type: int
    TlsV1_2 = ... # type: int
    TlsV1_2OrLater = ... # type: int
    AnyProtocol = ... # type: int
    TlsV1SslV3 = ... # type: int
    SecureProtocols = ... # type: int
    DtlsV1_0 = ... # type: int
    DtlsV1_0OrLater = ... # type: int
    DtlsV1_2 = ... # type: int
    DtlsV1_2OrLater = ... # type: int
    TlsV1_3 = ... # type: int
    TlsV1_3OrLater = ... # type: int

    AlternativeNameEntryType: typing.Type[int]
    #class AlternativeNameEntryType(int): ...
    EmailEntry = ... # type: int
    DnsEntry = ... # type: int

    KeyAlgorithm: typing.Type[int]
    #class KeyAlgorithm(int): ...
    Opaque = ... # type: int
    Rsa = ... # type: int
    Dsa = ... # type: int
    Ec = ... # type: int

    EncodingFormat: typing.Type[int]
    #class EncodingFormat(int): ...
    Pem = ... # type: int
    Der = ... # type: int

    KeyType: typing.Type[int]
    #class KeyType(int): ...
    PrivateKey = ... # type: int
    PublicKey = ... # type: int

    SslOptions: typing.Type[int]
    #class SslOptions(sip.simplewrapper):

        #@overload
        #def __init__(self) -> None: ...
        #@overload
        #def __init__(self, f: typing.Union[QSsl.SslOptions, QSsl.SslOption]) -> None: ...
        #@overload
        #def __init__(self, a0: QSsl.SslOptions) -> None: ...

        #def __hash__(self) -> int: ...
        #def __bool__(self) -> int: ...
        #def __invert__(self) -> QSsl.SslOptions: ...
        #def __int__(self) -> int: ...


class QSslCertificate(sip.simplewrapper):

    SubjectInfo: typing.Type[int]
    #class SubjectInfo(int): ...
    Organization = ... # type: int
    CommonName = ... # type: int
    LocalityName = ... # type: int
    OrganizationalUnitName = ... # type: int
    CountryName = ... # type: int
    StateOrProvinceName = ... # type: int
    DistinguishedNameQualifier = ... # type: int
    SerialNumber = ... # type: int
    EmailAddress = ... # type: int

    @overload
    def __init__(self, device: QtCore.QIODevice, format: int = ...) -> None: ...
    @overload
    def __init__(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., format: int = ...) -> None: ...
    @overload
    def __init__(self, other: QSslCertificate) -> None: ...

    def subjectDisplayName(self) -> str: ...
    def issuerDisplayName(self) -> str: ...
    @staticmethod
    def importPkcs12(device: QtCore.QIODevice, key: QSslKey, certificate: QSslCertificate, caCertificates: typing.Optional[typing.Iterable[QSslCertificate]] = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> bool: ...
    def __hash__(self) -> int: ...
    def isSelfSigned(self) -> bool: ...
    @staticmethod
    def verify(certificateChain: typing.Iterable[QSslCertificate], hostName: str = ...) -> typing.List[QSslError]: ...
    def toText(self) -> str: ...
    def extensions(self) -> typing.List[QSslCertificateExtension]: ...
    def issuerInfoAttributes(self) -> typing.List[QtCore.QByteArray]: ...
    def subjectInfoAttributes(self) -> typing.List[QtCore.QByteArray]: ...
    def isBlacklisted(self) -> bool: ...
    def swap(self, other: QSslCertificate) -> None: ...
    def handle(self) -> sip.voidptr: ...
    @staticmethod
    def fromData(data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: int = ...) -> typing.List[QSslCertificate]: ...
    @staticmethod
    def fromDevice(device: QtCore.QIODevice, format: int = ...) -> typing.List[QSslCertificate]: ...
    @staticmethod
    def fromPath(path: str, format: int = ..., syntax: int = ...) -> typing.List[QSslCertificate]: ...
    def toDer(self) -> QtCore.QByteArray: ...
    def toPem(self) -> QtCore.QByteArray: ...
    def publicKey(self) -> QSslKey: ...
    def expiryDate(self) -> QtCore.QDateTime: ...
    def effectiveDate(self) -> QtCore.QDateTime: ...
    def subjectAlternativeNames(self) -> typing.Dict[int, typing.List[str]]: ...
    @overload
    def subjectInfo(self, info: int) -> typing.List[str]: ...
    @overload
    def subjectInfo(self, attribute: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.List[str]: ...
    @overload
    def issuerInfo(self, info: int) -> typing.List[str]: ...
    @overload
    def issuerInfo(self, attribute: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> typing.List[str]: ...
    def digest(self, algorithm: int = ...) -> QtCore.QByteArray: ...
    def serialNumber(self) -> QtCore.QByteArray: ...
    def version(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...


class QSslCertificateExtension(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QSslCertificateExtension) -> None: ...

    def isSupported(self) -> bool: ...
    def isCritical(self) -> bool: ...
    def value(self) -> typing.Any: ...
    def name(self) -> str: ...
    def oid(self) -> str: ...
    def swap(self, other: QSslCertificateExtension) -> None: ...


class QSslCipher(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, name: str, protocol: int) -> None: ...
    @overload
    def __init__(self, other: QSslCipher) -> None: ...

    def swap(self, other: QSslCipher) -> None: ...
    def protocol(self) -> int: ...
    def protocolString(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def authenticationMethod(self) -> str: ...
    def keyExchangeMethod(self) -> str: ...
    def usedBits(self) -> int: ...
    def supportedBits(self) -> int: ...
    def name(self) -> str: ...
    def isNull(self) -> bool: ...


class QSslConfiguration(sip.simplewrapper):

    NextProtocolNegotiationStatus: typing.Type[int]
    #class NextProtocolNegotiationStatus(int): ...
    NextProtocolNegotiationNone = ... # type: int
    NextProtocolNegotiationNegotiated = ... # type: int
    NextProtocolNegotiationUnsupported = ... # type: int

    NextProtocolHttp1_1 = ... # type: str
    NextProtocolSpdy3_0 = ... # type: str

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QSslConfiguration) -> None: ...

    def setBackendConfiguration(self, backendConfiguration: typing.Dict[typing.Union[QtCore.QByteArray, bytes, bytearray], typing.Any] = ...) -> None: ...
    def setBackendConfigurationOption(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray], value: typing.Any) -> None: ...
    def backendConfiguration(self) -> typing.Dict[QtCore.QByteArray, typing.Any]: ...
    def setDiffieHellmanParameters(self, dhparams: QSslDiffieHellmanParameters) -> None: ...
    def diffieHellmanParameters(self) -> QSslDiffieHellmanParameters: ...
    def setPreSharedKeyIdentityHint(self, hint: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def preSharedKeyIdentityHint(self) -> QtCore.QByteArray: ...
    def ephemeralServerKey(self) -> QSslKey: ...
    @staticmethod
    def supportedEllipticCurves() -> typing.List[QSslEllipticCurve]: ...
    def setEllipticCurves(self, curves: typing.Iterable[QSslEllipticCurve]) -> None: ...
    def ellipticCurves(self) -> typing.List[QSslEllipticCurve]: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]: ...
    def sessionProtocol(self) -> int: ...
    def nextProtocolNegotiationStatus(self) -> int: ...
    def nextNegotiatedProtocol(self) -> QtCore.QByteArray: ...
    def allowedNextProtocols(self) -> typing.List[QtCore.QByteArray]: ...
    def setAllowedNextProtocols(self, protocols: typing.Iterable[typing.Union[QtCore.QByteArray, bytes, bytearray]]) -> None: ...
    def sessionTicketLifeTimeHint(self) -> int: ...
    def setSessionTicket(self, sessionTicket: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def sessionTicket(self) -> QtCore.QByteArray: ...
    def setLocalCertificateChain(self, localChain: typing.Iterable[QSslCertificate]) -> None: ...
    def localCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def swap(self, other: QSslConfiguration) -> None: ...
    def testSslOption(self, option: int) -> bool: ...
    def setSslOption(self, option: int, on: bool) -> None: ...
    @staticmethod
    def setDefaultConfiguration(configuration: QSslConfiguration) -> None: ...
    @staticmethod
    def defaultConfiguration() -> QSslConfiguration: ...
    def setCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def setCiphers(self, ciphers: typing.Iterable[QSslCipher]) -> None: ...
    def ciphers(self) -> typing.List[QSslCipher]: ...
    def setPrivateKey(self, key: QSslKey) -> None: ...
    def privateKey(self) -> QSslKey: ...
    def sessionCipher(self) -> QSslCipher: ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    def localCertificate(self) -> QSslCertificate: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def peerVerifyDepth(self) -> int: ...
    def setPeerVerifyMode(self, mode: int) -> None: ...
    def peerVerifyMode(self) -> int: ...
    def setProtocol(self, protocol: int) -> None: ...
    def protocol(self) -> int: ...
    def isNull(self) -> bool: ...


class QSslDiffieHellmanParameters(sip.simplewrapper):

    Error: typing.Type[int]
    #class Error(int): ...
    NoError = ... # type: int
    InvalidInputDataError = ... # type: int
    UnsafeParametersError = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QSslDiffieHellmanParameters) -> None: ...

    def __hash__(self) -> int: ...
    def errorString(self) -> str: ...
    def error(self) -> int: ...
    def isValid(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    @overload
    @staticmethod
    def fromEncoded(encoded: typing.Union[QtCore.QByteArray, bytes, bytearray], encoding: int = ...) -> QSslDiffieHellmanParameters: ...
    @overload
    @staticmethod
    def fromEncoded(device: QtCore.QIODevice, encoding: int = ...) -> QSslDiffieHellmanParameters: ...
    @staticmethod
    def defaultParameters() -> QSslDiffieHellmanParameters: ...
    def swap(self, other: QSslDiffieHellmanParameters) -> None: ...


class QSslEllipticCurve(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QSslEllipticCurve) -> None: ...

    def __hash__(self) -> int: ...
    def isTlsNamedCurve(self) -> bool: ...
    def isValid(self) -> bool: ...
    def longName(self) -> str: ...
    def shortName(self) -> str: ...
    @staticmethod
    def fromLongName(name: str) -> QSslEllipticCurve: ...
    @staticmethod
    def fromShortName(name: str) -> QSslEllipticCurve: ...


class QSslError(sip.simplewrapper):

    SslError: typing.Type[int]
    #class SslError(int): ...
    UnspecifiedError = ... # type: int
    NoError = ... # type: int
    UnableToGetIssuerCertificate = ... # type: int
    UnableToDecryptCertificateSignature = ... # type: int
    UnableToDecodeIssuerPublicKey = ... # type: int
    CertificateSignatureFailed = ... # type: int
    CertificateNotYetValid = ... # type: int
    CertificateExpired = ... # type: int
    InvalidNotBeforeField = ... # type: int
    InvalidNotAfterField = ... # type: int
    SelfSignedCertificate = ... # type: int
    SelfSignedCertificateInChain = ... # type: int
    UnableToGetLocalIssuerCertificate = ... # type: int
    UnableToVerifyFirstCertificate = ... # type: int
    CertificateRevoked = ... # type: int
    InvalidCaCertificate = ... # type: int
    PathLengthExceeded = ... # type: int
    InvalidPurpose = ... # type: int
    CertificateUntrusted = ... # type: int
    CertificateRejected = ... # type: int
    SubjectIssuerMismatch = ... # type: int
    AuthorityIssuerSerialNumberMismatch = ... # type: int
    NoPeerCertificate = ... # type: int
    HostNameMismatch = ... # type: int
    NoSslSupport = ... # type: int
    CertificateBlacklisted = ... # type: int

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, error: int) -> None: ...
    @overload
    def __init__(self, error: int, certificate: QSslCertificate) -> None: ...
    @overload
    def __init__(self, other: QSslError) -> None: ...

    def __hash__(self) -> int: ...
    def swap(self, other: QSslError) -> None: ...
    def certificate(self) -> QSslCertificate: ...
    def errorString(self) -> str: ...
    def error(self) -> int: ...


class QSslKey(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, encoded: typing.Union[QtCore.QByteArray, bytes, bytearray], algorithm: int, encoding: int = ..., type: int = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @overload
    def __init__(self, device: QtCore.QIODevice, algorithm: int, encoding: int = ..., type: int = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @overload
    def __init__(self, handle: sip.voidptr, type: int = ...) -> None: ...
    @overload
    def __init__(self, other: QSslKey) -> None: ...

    def swap(self, other: QSslKey) -> None: ...
    def handle(self) -> sip.voidptr: ...
    def toDer(self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> QtCore.QByteArray: ...
    def toPem(self, passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> QtCore.QByteArray: ...
    def algorithm(self) -> int: ...
    def type(self) -> int: ...
    def length(self) -> int: ...
    def clear(self) -> None: ...
    def isNull(self) -> bool: ...


class QSslPreSharedKeyAuthenticator(sip.simplewrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...

    def maximumPreSharedKeyLength(self) -> int: ...
    def preSharedKey(self) -> QtCore.QByteArray: ...
    def setPreSharedKey(self, preSharedKey: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def maximumIdentityLength(self) -> int: ...
    def identity(self) -> QtCore.QByteArray: ...
    def setIdentity(self, identity: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def identityHint(self) -> QtCore.QByteArray: ...
    def swap(self, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...


class QTcpSocket(QAbstractSocket):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...


class QSslSocket(QTcpSocket):

    encrypted: PYQT_SIGNAL
    encryptedBytesWritten: PYQT_SIGNAL
    modeChanged: PYQT_SIGNAL
    peerVerifyError: PYQT_SIGNAL
    preSharedKeyAuthenticationRequired: PYQT_SIGNAL
    sslErrors: PYQT_SIGNAL

    PeerVerifyMode: typing.Type[int]
    #class PeerVerifyMode(int): ...
    VerifyNone = ... # type: int
    QueryPeer = ... # type: int
    VerifyPeer = ... # type: int
    AutoVerifyPeer = ... # type: int

    SslMode: typing.Type[int]
    #class SslMode(int): ...
    UnencryptedMode = ... # type: int
    SslClientMode = ... # type: int
    SslServerMode = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    @staticmethod
    def sslLibraryBuildVersionString() -> str: ...
    @staticmethod
    def sslLibraryBuildVersionNumber() -> int: ...
    def sessionProtocol(self) -> int: ...
    def localCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def setLocalCertificateChain(self, localChain: typing.Iterable[QSslCertificate]) -> None: ...
    @staticmethod
    def sslLibraryVersionString() -> str: ...
    @staticmethod
    def sslLibraryVersionNumber() -> int: ...
    def disconnectFromHost(self) -> None: ...
    def connectToHost(self, hostName: str, port: int, mode: typing.Union[int, int] = ..., protocol: int = ...) -> None: ...
    def resume(self) -> None: ...
    def setPeerVerifyName(self, hostName: str) -> None: ...
    def peerVerifyName(self) -> str: ...
    def socketOption(self, option: int) -> typing.Any: ...
    def setSocketOption(self, option: int, value: typing.Any) -> None: ...
    #def encryptedBytesWritten(self, totalBytes: int) -> None: ...
    #def peerVerifyError(self, error: QSslError) -> None: ...
    def setSslConfiguration(self, config: QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> QSslConfiguration: ...
    def encryptedBytesToWrite(self) -> int: ...
    def encryptedBytesAvailable(self) -> int: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def peerVerifyDepth(self) -> int: ...
    def setPeerVerifyMode(self, mode: int) -> None: ...
    def peerVerifyMode(self) -> int: ...
    def writeData(self, data: bytes) -> int: ...
    def readData(self, maxlen: int) -> bytes: ...
    #def preSharedKeyAuthenticationRequired(self, authenticator: QSslPreSharedKeyAuthenticator) -> None: ...
    #def modeChanged(self, newMode: int) -> None: ...
    #def encrypted(self) -> None: ...
    @overload
    def ignoreSslErrors(self) -> None: ...
    @overload
    def ignoreSslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    def startServerEncryption(self) -> None: ...
    def startClientEncryption(self) -> None: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    #@overload
    #def sslErrors(self) -> typing.List[QSslError]: ...
    #@overload
    #def sslErrors(self, errors: typing.Iterable[QSslError]) -> None: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForEncrypted(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    @staticmethod
    def systemCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def defaultCaCertificates() -> typing.List[QSslCertificate]: ...
    @staticmethod
    def setDefaultCaCertificates(certificates: typing.Iterable[QSslCertificate]) -> None: ...
    @staticmethod
    def addDefaultCaCertificate(certificate: QSslCertificate) -> None: ...
    @overload
    @staticmethod
    def addDefaultCaCertificates(path: str, format: int = ..., syntax: int = ...) -> bool: ...
    @overload
    @staticmethod
    def addDefaultCaCertificates(certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def caCertificates(self) -> typing.List[QSslCertificate]: ...
    def setCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    def addCaCertificate(self, certificate: QSslCertificate) -> None: ...
    @overload
    def addCaCertificates(self, path: str, format: int = ..., syntax: int = ...) -> bool: ...
    @overload
    def addCaCertificates(self, certificates: typing.Iterable[QSslCertificate]) -> None: ...
    @staticmethod
    def supportedCiphers() -> typing.List[QSslCipher]: ...
    @staticmethod
    def defaultCiphers() -> typing.List[QSslCipher]: ...
    @staticmethod
    def setDefaultCiphers(ciphers: typing.Iterable[QSslCipher]) -> None: ...
    @overload
    def setCiphers(self, ciphers: typing.Iterable[QSslCipher]) -> None: ...
    @overload
    def setCiphers(self, ciphers: str) -> None: ...
    def ciphers(self) -> typing.List[QSslCipher]: ...
    def privateKey(self) -> QSslKey: ...
    @overload
    def setPrivateKey(self, key: QSslKey) -> None: ...
    @overload
    def setPrivateKey(self, fileName: str, algorithm: int = ..., format: int = ..., passPhrase: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    def sessionCipher(self) -> QSslCipher: ...
    def peerCertificateChain(self) -> typing.List[QSslCertificate]: ...
    def peerCertificate(self) -> QSslCertificate: ...
    def localCertificate(self) -> QSslCertificate: ...
    @overload
    def setLocalCertificate(self, certificate: QSslCertificate) -> None: ...
    @overload
    def setLocalCertificate(self, path: str, format: int = ...) -> None: ...
    def abort(self) -> None: ...
    def flush(self) -> bool: ...
    def atEnd(self) -> bool: ...
    def close(self) -> None: ...
    def canReadLine(self) -> bool: ...
    def bytesToWrite(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def setProtocol(self, protocol: int) -> None: ...
    def protocol(self) -> int: ...
    def isEncrypted(self) -> bool: ...
    def mode(self) -> int: ...
    def setSocketDescriptor(self, socketDescriptor: sip.voidptr, state: int = ..., mode: typing.Union[int, int] = ...) -> bool: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int, mode: typing.Union[int, int] = ..., protocol: int = ...) -> None: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslPeerName: str, mode: typing.Union[int, int] = ..., protocol: int = ...) -> None: ...


class QTcpServer(QtCore.QObject):

    acceptError: PYQT_SIGNAL
    newConnection: PYQT_SIGNAL

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    #def acceptError(self, socketError: int) -> None: ...
    #def newConnection(self) -> None: ...
    def addPendingConnection(self, socket: QTcpSocket) -> None: ...
    def incomingConnection(self, handle: sip.voidptr) -> None: ...
    def resumeAccepting(self) -> None: ...
    def pauseAccepting(self) -> None: ...
    def proxy(self) -> QNetworkProxy: ...
    def setProxy(self, networkProxy: QNetworkProxy) -> None: ...
    def errorString(self) -> str: ...
    def serverError(self) -> int: ...
    def nextPendingConnection(self) -> QTcpSocket: ...
    def hasPendingConnections(self) -> bool: ...
    def waitForNewConnection(self, msecs: int = ...) -> typing.Tuple[bool, bool]: ...
    def setSocketDescriptor(self, socketDescriptor: sip.voidptr) -> bool: ...
    def socketDescriptor(self) -> sip.voidptr: ...
    def serverAddress(self) -> QHostAddress: ...
    def serverPort(self) -> int: ...
    def maxPendingConnections(self) -> int: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def isListening(self) -> bool: ...
    def close(self) -> None: ...
    def listen(self, address: typing.Union[QHostAddress, int] = ..., port: int = ...) -> bool: ...


class QUdpSocket(QAbstractSocket):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ..., **props) -> None: ...

    def receiveDatagram(self, maxSize: int = ...) -> QNetworkDatagram: ...
    def setMulticastInterface(self, iface: QNetworkInterface) -> None: ...
    def multicastInterface(self) -> QNetworkInterface: ...
    @overload
    def leaveMulticastGroup(self, groupAddress: typing.Union[QHostAddress, int]) -> bool: ...
    @overload
    def leaveMulticastGroup(self, groupAddress: typing.Union[QHostAddress, int], iface: QNetworkInterface) -> bool: ...
    @overload
    def joinMulticastGroup(self, groupAddress: typing.Union[QHostAddress, int]) -> bool: ...
    @overload
    def joinMulticastGroup(self, groupAddress: typing.Union[QHostAddress, int], iface: QNetworkInterface) -> bool: ...
    @overload
    def writeDatagram(self, data: bytes, host: typing.Union[QHostAddress, int], port: int) -> int: ...
    @overload
    def writeDatagram(self, datagram: typing.Union[QtCore.QByteArray, bytes, bytearray], host: typing.Union[QHostAddress, int], port: int) -> int: ...
    @overload
    def writeDatagram(self, datagram: QNetworkDatagram) -> int: ...
    def readDatagram(self, maxlen: int) -> typing.Tuple[bytes, QHostAddress, int]: ...
    def pendingDatagramSize(self) -> int: ...
    def hasPendingDatagrams(self) -> bool: ...
