searchData={"items":[{"type":"extras","title":"Erl_interface Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Erl_interface Release Notes\n\nThis document describes the changes made to the Erl_interface application.","ref":"notes.html"},{"type":"extras","title":"Erl_Interface 5.6 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-6"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Fixed licenses in files and added ORT curations to the following apps: otp, eldap, erl_interface, eunit, parsetools, stdlib, syntax_tools, and ERTS.\n\n  Own Id: OTP-19478 Aux Id: [PR-9376], [PR-9402], [PR-9819]\n\n- Added support for compiling Erlang/OTP for Windows on ARM64.\n\n  Own Id: OTP-19480 Aux Id: [PR-8734]\n\n- When compiling C/C++ code on Unix systems, the compiler hardening flags suggested by the [Open Source Security Foundation](https://github.com/ossf/wg-best-practices-os-developers/blob/main/docs/Compiler-Hardening-Guides/Compiler-Options-Hardening-Guide-for-C-and-C%2B%2B.md) are now enabled by default. To disable them, pass `--disable-security-hardening-flags` to `configure`.\n\n  Own Id: OTP-19519 Aux Id: [PR-9441]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n- Update of MD5 implementation from OpenSSL version 3.1.4 to 3.5.\n\n  Own Id: OTP-19614 Aux Id: [PR-9775]\n\n[PR-9376]: https://github.com/erlang/otp/pull/9376\n[PR-9402]: https://github.com/erlang/otp/pull/9402\n[PR-9819]: https://github.com/erlang/otp/pull/9819\n[PR-8734]: https://github.com/erlang/otp/pull/8734\n[PR-9441]: https://github.com/erlang/otp/pull/9441\n[PR-9670]: https://github.com/erlang/otp/pull/9670\n[PR-9775]: https://github.com/erlang/otp/pull/9775","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since terms that have a representation on the external term format larger than 2 GB cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Erl_Interface 5.5.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-5-2"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since terms that have a representation on the external term format larger than 2 GB cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-1"},{"type":"extras","title":"Erl_Interface 5.5.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"* Fix bug where the system installed openssl/md5.h would be confused with the vendored md5.h.\n\n  Own Id: OTP-18931 Aux Id: GH-7987 PR-7989","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Erl_Interface 5.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fixed some benign compile warnings on Windows.\n\n  Own Id: OTP-18895","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Add support to encode maps with `ei_x_format`.\n\n  Own Id: OTP-18764 Aux Id: PR-7602\n\n- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-2"},{"type":"extras","title":"Erl_Interface 5.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-4"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- As announced since the release of OTP 24, support for:\n\n  - version 4 node container types in the external term format are now\n    mandatory. That is, references supporting up to 5 32-bit integer\n    identifiers, and process and port identifiers with support for 64-bit data\n    storage. The distribution flag\n    [`DFLAG_V4_NC`](`e:erts:erl_dist_protocol.md#DFLAG_V4_NC`) is therefor now\n    also mandatory. OTP has since OTP 24 supported this. Also note that the\n    external format produced by `term_to_binary()` and `term_to_iovec()` will\n    unconditionally produce pids, ports, and references supporting this larger\n    format.\n  - the [new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`)\n    introduced in OTP 23.3 is now mandatory. The distribution flag\n    [`DFLAG_UNLINK_ID`](`e:erts:erl_dist_protocol.md#DFLAG_UNLINK_ID`) is\n    therefor now also mandatory.\n\n  Due to the above, OTP 26 nodes will refuse to connect to OTP nodes from\n  releases prior to OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18140 Aux Id: PR-6072","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-3"},{"type":"extras","title":"Erl_Interface 5.3.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-3-2-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Erl_Interface 5.3.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fixed configure tests for a few ARM-specific instructions, which prevented the\n  emulator from being built on some platforms.\n\n  Own Id: OTP-18554","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Erl_Interface 5.3.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Accept connection setup from OTP 23 and 24 nodes that are not using epmd.\n\n  Own Id: OTP-18404 Aux Id: GH-6595, PR-6625","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-4"},{"type":"extras","title":"Erl_Interface 5.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- `erl_call` no longer links against `nsl` on platforms where `gethostbyname` is\n  provided by libc.\n\n  Own Id: OTP-17846 Aux Id: PR-5558","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- The following distribution flags are now mandatory: `DFLAG_BIT_BINARIES`,\n  `DFLAG_EXPORT_PTR_TAG`, `DFLAG_MAP_TAGS`, `DFLAG_NEW_FLOATS`, and\n  `DFLAG_FUN_TAGS`. This mainly concerns libraries or application that implement\n  the distribution protocol themselves.\n\n  Own Id: OTP-17318 Aux Id: PR-4972\n\n- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967\n\n- Removed use of node creation value zero as a wildcard. Also prevent zero from\n  being used as creation by `erl_interface` and `jinterface` nodes.\n\n  Own Id: OTP-17682 Aux Id: PR-5347\n\n- Changed `creation` arguments, of function `ei_connect_init` and friends, from\n  type `short` to `unsigned int` for full 32-bit range.\n\n  Own Id: OTP-17802 Aux Id: PR-5347","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-5"},{"type":"extras","title":"Erl_Interface 5.2.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-2-2-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Replaced old md5 implementation with an implementation from OpenSSL.\n\n  Own Id: OTP-18877","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Erl_Interface 5.2.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Avoid attempt build dynamic libs if config option `--enable-ei-dynamic-lib` is\n  not given.\n\n  Own Id: OTP-17987 Aux Id: GH-5781, PR-5787","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Erl_Interface 5.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix compile error regarding `gethostbyaddr_r` on Android. Error introduced in\n  OTP 24.3.\n\n  Own Id: OTP-17975 Aux Id: PR-5763","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Erl_Interface 5.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-2"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Add `--enable-ei-dynamic-lib` configure option that will make erl_interface\n  also release a dynamic library version of libei.\n\n  Own Id: OTP-17883 Aux Id: PR-5601 ERIERL-724","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-6"},{"type":"extras","title":"Erl_Interface 5.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- erl_call now prints an error when the arguments cannot be parsed.\n\n  Own Id: OTP-17626","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-7"},{"type":"extras","title":"Erl_Interface 5.0.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Erl_Interface 5.0 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-5-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Two options have been added to `erl_call`. The `-fetch_stdout` option fetches\n  stdout data resulting from the code invoked by `erl_call`. The `-fetch_stdout`\n  option disables printing of the result term. In order to implement the first\n  of these two options a new function called `ei_xrpc_from` has been added to\n  erl_interface. For details see the `erl_call` documentation and\n  `erl_interface` documentation.\n\n  Own Id: OTP-17132","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Accept 64-bit process identifiers from external nodes. This is the first step\n  in an upgrade path toward using 64-bit pids in a future OTP release.\n\n  Own Id: OTP-16720 Aux Id: PR-2680\n\n- The experimental HiPE application has been removed, together with all related\n  functionality in other applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16963\n\n- The `registry` functionality part of `erl_interface` has been removed. It was\n  as of OTP 23 deprecated and scheduled for removal in OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16970\n\n- Accept references up to a size of 160-bits from remote nodes. This is the\n  first step in an upgrade path toward using references up to 160-bits in a\n  future OTP release.\n\n  Own Id: OTP-17005 Aux Id: OTP-16718\n\n- Accept 64-bit port identifiers from external nodes. This is the first step in\n  an upgrade path toward using 64-bit port identifiers in a future OTP release.\n\n  Own Id: OTP-17007\n\n- Support the new link protocol in order to be able to phase out the old link\n  protocol in the future. `erl_interface` does not support setting up or\n  removing links from the `erl_interface` side, so the bug present with the old\n  protocol did not effect `erl_interface`. This since both participants of a\n  link simultaneously needed to operate on the link in order to trigger the bug.\n\n  Own Id: OTP-17270 Aux Id: OTP-17127","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-8"},{"type":"extras","title":"Erl_Interface 4.0.3.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-9"},{"type":"extras","title":"Erl_Interface 4.0.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where sending of large data with ei*send*\\*/ei_rpc with infinite\n  timeout could fail when the tcp buffer becomes full.\n\n  Fault has existed since OTP-21.\n\n  Own Id: OTP-17358 Aux Id: ERLERL-610","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-10"},{"type":"extras","title":"Erl_Interface 4.0.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where sending of large data with ei*send*\\*/ei_rpc with infinite\n  timeout could fail when the tcp buffer becomes full.\n\n  Fault has existed since OTP-21.\n\n  Own Id: OTP-17358 Aux Id: ERLERL-610","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Erl_Interface 4.0.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Integers outside of the range \\[-(1 bsl 32) - 1, (1 bsl 32) -1] were\n  previously intended to be printed in an internal bignum format by\n  `ei_print_term()` and `ei_s_print_term()`. Unfortunately the implementation\n  has been buggy since OTP R13B02 and since then produced results with random\n  content which also could crash the calling program.\n\n  This fix replaces the printing of the internal format with printing in\n  hexadecimal form and extend the range for printing in decimal form. Currently\n  integers in the range \\[-(1 bsl 64), (1 bsl 64)] are printed in decimal form\n  and integers outside of this range in Erlang hexadecimal form.\n\n  Own Id: OTP-17099 Aux Id: ERIERL-585","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-11"},{"type":"extras","title":"Erl_Interface 4.0.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix erl_interface on windows to be compiled with correct flags to make\n  internal primitives reentrant.\n\n  Own Id: OTP-16740\n\n- Fixed `ei_get_type` to set `*size` to zero for floats, pids, port and refs\n  according to documentation.\n\n  Own Id: OTP-16753 Aux Id: ERL-1288, PR-2678\n\n- Fix ei_connect when using a dynamic node name to force usage of distribution\n  version 6.\n\n  This bug caused `erl_call -R -address` to not work properly.\n\n  Own Id: OTP-16786","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Changes in order to build on the Haiku operating system.\n\n  Thanks to Calvin Buckley\n\n  Own Id: OTP-16707 Aux Id: PR-2638","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-12"},{"type":"extras","title":"Erl_Interface 4.0 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix various compiler warnings on 64-bit Windows.\n\n  Own Id: OTP-15800\n\n- `erl_call` will now work properly on systems that cannot resolve their own\n  hostname.\n\n  Own Id: OTP-16604\n\n- Various bug fixes:\n\n  - Internal error checking in various functions.\n  - [`ei_rpc()`](ei_connect.md#ei_rpc) accepted any 2-tuple message as an rpc\n    response.\n  - [`ei_decode_ref()`](ei.md#ei_decode_ref) now refuse to write outside of\n    allocated memory in case a huge reference is decoded.\n  - [`ei_decode_ei_term()`](ei.md#ei_decode_ei_term) now reports the same term\n    types as [`ei_get_type()`](ei.md#ei_get_type).\n\n  Own Id: OTP-16623","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- A client node can receive its node name dynamically from the node that it\n  first connects to. This featured can by used by\n\n  - starting with `erl -sname undefined`\n  - erl_interface functions `ei_connect_init` and friends\n  - `erl_call -R`\n\n  Own Id: OTP-13812\n\n- Increased size of node incarnation numbers (aka \"creation\"), from 2 bits to 32\n  bits. This will reduce the risk of pids/ports/refs, from different node\n  incarnation with the same name, being mixed up.\n\n  Own Id: OTP-15603\n\n- Fix various build issues when compiling Erlang/OTP to the IBM AIX platform.\n\n  Own Id: OTP-15866 Aux Id: PR-2110\n\n- Improved node connection setup handshake protocol. Made possible to agree on\n  protocol version without dependence on `epmd` or other prior knowledge of peer\n  node version. Also added exchange of node incarnation (\"creation\") values and\n  expanded the distribution capability flag field from 32 to 64 bits.\n\n  Own Id: OTP-16229\n\n- New `erl_call` option `-address [Host]:Port` to connect directly to a node\n  without being dependent on `epmd` to resolve the node name.\n\n  Own Id: OTP-16251\n\n- As announced in OTP 22.0, the deprecated parts of `erl_interface` have now\n  been removed (essentially all C functions with prefix `erl_`).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16328\n\n- As announced in OTP 22.0, the previously existing limited support for VxWorks\n  has now been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16329 Aux Id: OTP-15621\n\n- New function `ei_connect_host_port` and friends to allow node connection\n  without being dependent on `epmd` for node name resolution.\n\n  Own Id: OTP-16496 Aux Id: OTP-16251\n\n- A number of new functions have been added to the `erl_interface` API:\n\n  - [`ei_cmp_pids()`](ei.md#ei_cmp_pids)\n  - [`ei_cmp_ports()`](ei.md#ei_cmp_ports)\n  - [`ei_cmp_refs()`](ei.md#ei_cmp_refs)\n  - [`ei_decode_iodata()`](ei.md#ei_decode_iodata)\n  - [`ei_make_pid()`](ei_connect.md#ei_make_pid)\n  - [`ei_make_ref()`](ei_connect.md#ei_make_ref)\n\n  Own Id: OTP-16594\n\n- Added a `-timeout` option to `erl_call`.\n\n  Own Id: OTP-16624\n\n- The `erl_interface` `registry` functionality is deprecated as of OTP 23, and\n  will be removed in OTP 24. Reasonably new `gcc` compilers will issue\n  deprecation warnings when using this functionality. In order to disable these\n  warnings, define the macro `EI_NO_DEPR_WARN`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16630\n\n- Documentation improvements.\n\n  Own Id: OTP-16633","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-13"},{"type":"extras","title":"Erl_Interface 3.13.2.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-14"},{"type":"extras","title":"Erl_Interface 3.13.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where sending of large data with ei*send*\\*/ei_rpc with infinite\n  timeout could fail when the tcp buffer becomes full.\n\n  Fault has existed since OTP-21.\n\n  Own Id: OTP-17358 Aux Id: ERLERL-610","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-15"},{"type":"extras","title":"Erl_Interface 3.13.2.0.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13-2-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where sending of large data with ei*send*\\*/ei_rpc with infinite\n  timeout could fail when the tcp buffer becomes full.\n\n  Fault has existed since OTP-21.\n\n  Own Id: OTP-17358 Aux Id: ERIERL-610","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Erl_Interface 3.13.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix link error \"multiple definition of \\`ei_default_socket_callbacks'\" for gcc\n  version 10 or when built with gcc option -fno-common. Error exists since\n  OTP-21.3.\n\n  Own Id: OTP-16412 Aux Id: PR-2503","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Erl_Interface 3.13.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix user supplied socket implementation for Windows and other platforms\n  without gcc atomics.\n\n  Own Id: OTP-16308","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Erl_Interface 3.13 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bugs in `ei_print_term` for binaries and bit strings causing incorrect\n  output.\n\n  Own Id: OTP-15917\n\n- Fixed bug in `ei_decode_fun` for very old fun encoding format. Bug exist since\n  OTP 22.0.\n\n  Own Id: OTP-15996","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- `ei_print_term()` now supports printing of maps and funs.\n\n  Own Id: OTP-15814","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Erl_Interface 3.12 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- The vxworks configure has been updated to respect the environment CFLAGS.\n\n  Own Id: OTP-15773","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Minor adjustments made to build system for parallel configure.\n\n  Own Id: OTP-15340 Aux Id: OTP-14625\n\n- The limited support for VxWorks is deprecated as of OTP 22, and will be\n  removed in OTP 23.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15621\n\n- The old legacy `erl_interface` library (functions with prefix `erl_`) is\n  deprecated as of OTP 22, and will be removed in OTP 23. This does not apply to\n  the `ei` library. Reasonably new `gcc` compilers will issue deprecation\n  warnings. In order to disable these warnings, define the macro\n  `EI_NO_DEPR_WARN`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15622\n\n- Added support to receive, decode, encode and send both bit strings and export\n  funs (`fun M:F/A`).\n\n  New functions `ei_decode_bitstring` and `ei_encode_bitstring` have been added\n  in order to decode and encode bit strings where the number of bits is not\n  necessary divisible by 8 (a whole number of bytes). The existing functions\n  `ei_decode_fun` and `ei_encode_fun` can now also handle export funs.\n\n  Before this change, bit strings and export funs sent to an erl_interface\n  c-node were encoded using an undocumented fallback tuple format. For bit\n  strings `{Binary,BitsInLastByte}` and for export funs `{M,F}`. Existing c-node\n  implementations expecting these tuples must be changed to instead use\n  `ei_decode_bitstring` and `ei_decode_fun`. As a temporary solution you can\n  also build erl_interface with macro `EI_COMPAT=21` or call\n  `ei_set_compat_rel(21)` to receive the old fallback tuples.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15712 Aux Id: OTP-15774","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Erl_Interface 3.11.3.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where sending of large data with ei*send*\\*/ei_rpc with infinite\n  timeout could fail when the tcp buffer becomes full.\n\n  Fault has existed since OTP-21.\n\n  Own Id: OTP-17358 Aux Id: ERLERL-610","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-16"},{"type":"extras","title":"Erl_Interface 3.11.3.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix link error \"multiple definition of \\`ei_default_socket_callbacks'\" for gcc\n  version 10 or when built with gcc option -fno-common. Error exists since\n  OTP-21.3.\n\n  Own Id: OTP-16412 Aux Id: PR-2503","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Known Bugs and Problems - Erl_interface Release Notes","doc":"- The `ei` API for decoding/encoding terms is not fully 64-bit compatible since\n  terms that have a representation on the external term format larger than 2 GB\n  cannot be handled.\n\n  Own Id: OTP-16607 Aux Id: OTP-16608","ref":"notes.html#known-bugs-and-problems-17"},{"type":"extras","title":"Erl_Interface 3.11.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- `erl_interface`/`ei` refused to use node names with an alive name (the part of\n  the node name preceding the @ sign) longer than 63 characters and a host name\n  longer than 64 characters. The total amount of characters allowed in a node\n  name (alivename@hostname) was thus limited to 128 characters. These limits\n  applied both to the own node name as well as node names of other nodes.\n  Ordinary Erlang nodes limit the node name length to 256 characters, which\n  meant that you could not communicate with certain Erlang nodes due to their\n  node name used.\n\n  `erl_interface`/`ei` now allow the total amount of characters in a node name\n  to be up to 256 characters. These characters may be distributed between alive\n  name and host name in whatever way needed. That is, the maximum amount of\n  characters in the alive name may be 254 and the maximum amount of characters\n  in the host name may be 254, but in total the node name must not exceed 256\n  characters.\n\n  Own Id: OTP-15781 Aux Id: ERIERL-356","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Erl_Interface 3.11.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- `erl_interface`/`ei` refused to use node names with an alive name (the part of\n  the node name preceding the @ sign) longer than 63 characters and a host name\n  longer than 64 characters. The total amount of characters allowed in a node\n  name (alivename@hostname) was thus limited to 128 characters. These limits\n  applied both to the own node name as well as node names of other nodes.\n  Ordinary Erlang nodes limit the node name length to 256 characters, which\n  meant that you could not communicate with certain Erlang nodes due to their\n  node name used.\n\n  `erl_interface`/`ei` now allow the total amount of characters in a node name\n  to be up to 256 characters. These characters may be distributed between alive\n  name and host name in whatever way needed. That is, the maximum amount of\n  characters in the alive name may be 254 and the maximum amount of characters\n  in the host name may be 254, but in total the node name must not exceed 256\n  characters.\n\n  Own Id: OTP-15781 Aux Id: ERIERL-356","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Erl_Interface 3.11.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix handling of Makefile dependencies so that parallel make works properly.\n\n  Own Id: OTP-15757","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Erl_Interface 3.11.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fixed two bugs in the `erl_call` program. A missing initialization (introduced\n  in `erl_interface-3.11`) which either caused a crash or failure to connect to\n  or start a node, and an incorrectly calculated timeout which could cause\n  failure to start an erlang node. These bugs only caused failures on some\n  platforms.\n\n  Own Id: OTP-15676 Aux Id: OTP-15442, ERL-881","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Erl_Interface 3.11 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-11"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Support for plugin of a\n  [user supplied socket implementation](ei_connect.md#ussi) has been added.\n\n  Own Id: OTP-15442 Aux Id: ERIERL-258","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Erl_Interface 3.10.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Make `ei_connect` and friends also accept state `ok_simultaneous` during\n  handshake, which means the other node has initiated a connection setup that\n  will be cancelled in favor of this connection.\n\n  Own Id: OTP-15161 Aux Id: ERIERL-191\n\n- Fixed bug in `ei_receive_msg`, `ei_xreceive_msg`, `ei_receive_msg_tmo` and\n  `ei_xreceive_msg_tmo`. The `x->index` was set to entire buffer size instead of\n  the number of bytes actually received.\n\n  Own Id: OTP-15171\n\n- Fixed bug in `ei_connect_init` which could be provoked if called by concurrent\n  threads. `ei_connect_init` called posix interface `gethostbyname` which is\n  documented as not thread safe.\n\n  Own Id: OTP-15191\n\n- Fixed bug in erl_compare_ext() ignoring the tail of lists of otherwise equal\n  content. Example: `[a | b]` and `[a | c]` compared equal and `{[a], b}` and\n  `{[a], c}` compared equal.\n\n  Own Id: OTP-15277 Aux Id: PR-1929","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Erl_Interface 3.10.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where calling erl_init on certain platforms could result in a buffer\n  overflow bug.\n\n  Own Id: OTP-15033\n\n- Fixed `erl_call -m` to not deallocate module source binary before it has been\n  read.\n\n  Own Id: OTP-15105 Aux Id: ERL-629","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- The program `erl_call` calls `erl_eval:eval_str/1` when it used to call\n  `lib:eval_str/1`. This means that `erl_call` will fail when trying interact\n  with an Erlang node running Erlang/OTP 20 or earlier.\n\n  Own Id: OTP-15114 Aux Id: OTP-15072, ERL-634","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Erl_Interface 3.10.2.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix handling of Makefile dependencies so that parallel make works properly.\n\n  Own Id: OTP-15757","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Erl_Interface 3.10.2.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Make `ei_connect` and friends also accept state `ok_simultaneous` during\n  handshake, which means the other node has initiated a connection setup that\n  will be cancelled in favor of this connection.\n\n  Own Id: OTP-15161 Aux Id: ERIERL-191","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Erl_Interface 3.10.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug in `ei_connect` functions that may cause failure due to insufficient\n  buffer space for gethostbyname_r.\n\n  Own Id: OTP-15022 Aux Id: ERIERL-163\n\n- Optimize encoding/decoding for pure 7-bit ascii atoms.\n\n  Own Id: OTP-15023 Aux Id: ERIERL-150","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Erl_Interface 3.10.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Erl_Interface 3.10 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix bug where gethostname would incorrectly fail with enametoolong on Linux.\n\n  Own Id: OTP-14310","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Remove generation of atoms in old latin1 external format in the distribution\n  between erlang nodes, `erl_interface`, and `jinterface`. The new utf8 format\n  for atoms was introduced in OTP R16. An OTP 20 node can therefore not connect\n  to nodes older than R16.\n\n  Atoms that can be encoded using latin1 are still encoded by `term_to_binary()`\n  using latin1 encoding. Note that all atoms will by default be encoded using\n  utf8 in a future Erlang/OTP release. For more information see the\n  documentation of `erlang:term_to_binary/2`.\n\n  Own Id: OTP-14337","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Erl_Interface 3.9.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-9-3"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Minor documentation update\n\n  Own Id: OTP-14233 Aux Id: PR-1343","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Erl_Interface 3.9.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix `ei_connect_init` and `ei_connect_xinit` to adjust the `creation` argument\n  to be compatible with nodes older than OTP-19.\n\n  Own Id: OTP-13981","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Editorial documentation changes\n\n  Own Id: OTP-13980","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Erl_Interface 3.9.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Look for .erlang.cookie in windows system directory if HOMEDRIVE and HOMEPATH\n  is not set. The same behaviour as the VM.\n\n  Own Id: OTP-13849","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Erl_Interface 3.9 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix decoding of LLONG_MIN in erl_decode\n\n  Own Id: OTP-13666 Aux Id: ERL-158\n\n- On windows `ei_decode_ulong` and `ei_decode_long` now correctly returns an\n  error when trying to decode a number that does not fit in a long. Fixed a bug\n  on windows where enabling ei tracing would cause a segmentation fault.\n\n  Own Id: OTP-13673","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Handle terms (pids,ports and refs) from nodes with a 'creation' value larger\n  than 3. This is a preparation of the distribution protocol to allow OTP 19\n  nodes to correctly communicate with future nodes (20 or higher). The\n  'creation' value differentiates different incarnations of the same node\n  (name).\n\n  Own Id: OTP-13488","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Erl_Interface 3.8.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix Erl_Interface build error on Debian/Hurd and Debian/kFreeBSD. (Thanks to\n  Sergei Golovan)\n\n  Own Id: OTP-13328","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- EPMD supports both IPv4 and IPv6\n\n  Also affects oldest supported windows version.\n\n  Own Id: OTP-13364","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Erl_Interface 3.8.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-8-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Fix the conditional selection of gethostbyname_r and gethostbyaddr_r.\n\n  Own Id: OTP-13188","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Erl_Interface 3.8 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-8"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Do not accept Nan and Infinity values\n\n  Erlang does not accept these values, so we return an error in the C interface\n  rather than letting them through to the Erlang VM, which rejects the message\n  with a somewhat cryptic \"bad external term\".\n\n  Own Id: OTP-12801","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Erl_Interface 3.7.20 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-20"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Use C99 function isfinite() instead of finite() when available on non GCC\n  compilers.\n\n  Own Id: OTP-12268","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Distribute `autoconf` helpers to applications at build time instead of having\n  multiple identical copies committed in the repository.\n\n  Own Id: OTP-12348\n\n- Added an .appup file for the application.\n\n  Own Id: OTP-12358 Aux Id: OTP-12178","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Erl_Interface 3.7.19 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-19"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Added a `.app` file for the application.\n\n  Own Id: OTP-12178","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Erl_Interface 3.7.18 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Implement --enable-sanitizers\\[=sanitizers]. Similar to debugging with\n  Valgrind, it's very useful to enable -fsanitize= switches to catch bugs at\n  runtime.\n\n  Own Id: OTP-12153","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Erl_Interface 3.7.17 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Now works with Visual Studio.\n\n  Own Id: OTP-11984","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Erl_Interface 3.7.16 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix memcheck warning in gen_challange (Thanks to Olivier Girondel)\n\n  Own Id: OTP-11608","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Erl_Interface 3.7.15 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Silence warnings (Thanks to Anthony Ramine)\n\n  Own Id: OTP-11517","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Erl_Interface 3.7.14 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-14"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Introduced functionality for inspection of system and build configuration.\n\n  Own Id: OTP-11196\n\n- Header and library files from ic and erl_interface are now installed into\n  usr/\\{include,lib\\}. Note that these directories are unversioned, so the\n  latest installed version will be the one in the directory.\n\n  Own Id: OTP-11284\n\n- Fix location of true binary under Mac OSX. Thanks to Simon Cornish.\n\n  Own Id: OTP-11289","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Erl_Interface 3.7.13 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-13"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- A guard was added to check if file descriptor is valid before closing it.\n\n  Own Id: OTP-11167","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Erl_Interface 3.7.12 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Superfluous trailing comma in enum erlang_char_encoding causing compile error\n  for g++ with --pedantic option.\n\n  Own Id: OTP-10913 Aux Id: seq12264","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Erl_Interface 3.7.11 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Revert the structs `erlang_pid`, `erlang_port` and `erlang_ref` as they were\n  before R16A (without `node_org_enc`) in order to be backward compatible with\n  user code that accesses the fields of these structs.\n\n  Own Id: OTP-10885 Aux Id: seq12256","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Erl_Interface 3.7.10 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-10"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Limited support for unicode atoms in the external format and in the internal\n  representation of the vm. This is a preparative feature in order to support\n  communication with future releases of Erlang/OTP that may create unicode\n  atoms.\n\n  Own Id: OTP-10753","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Erl_Interface 3.7.9 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-9"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Teach lib/erl_interface/configure.in to look for pthreads support in libc\n  (where it can be found on QNX)\n\n  A minor tweak such that this configure _fails_ if you pass --enable-threads\n  and no pthreads support can be found.\n\n  (Thanks to Per Hedeland)\n\n  Own Id: OTP-10581","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Erl_Interface 3.7.8 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-8"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Detect when middle endian doubles are used by a platform and account for it\n  when decoding floats. (Thanks to Mike Sperber)\n\n  Own Id: OTP-10209","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Erl_Interface 3.7.7 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Minor suppressions and fixes of compilation warnings\n\n  Own Id: OTP-10016","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Erl_Interface 3.7.6 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- An error when getting global names on OS X Lion has been fixed. The error\n  caused truncated strings to be returned from the function.\n\n  Own Id: OTP-9799","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Erlang/OTP can now be built using parallel make if you limit the number of\n  jobs, for instance using '`make -j6`' or '`make -j10`'. '`make -j`' does not\n  work at the moment because of some missing dependencies.\n\n  Own Id: OTP-9451\n\n- Eliminate use of deprecated regexp module\n\n  Own Id: OTP-9810","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Erl_Interface 3.7.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Align ei buffer according to size of pointers\n\n  Own Id: OTP-9390\n\n- XML files have been corrected.\n\n  Own Id: OTP-9550 Aux Id: OTP-9541\n\n- Make comment and documentation reflect code in\n  erl_interface/src/misc/ei_decode_term.c (Thanks to Anneli Cuss)\n\n  Own Id: OTP-9559","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- ei: integer overflow in string/atom encoding\n\n  ei_encode_atom() and ei_encode_string() use strlen() to get the length of the\n  buffer. As strlen() returns an unsigned long long and both ei functions take a\n  signed integer, the length fields may overflow.\n\n  Check so that the results of strlen can be held in a signed integer. (Thanks\n  to Michael Santos)\n\n  Own Id: OTP-9530","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Erl_Interface 3.7.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fix using sizeof() for array given as function argument\n\n  When using the sizeof() operator for an array given as function argument it\n  returns the size of the pointer. In this case, the affected function hex(char\n  digest\\[16], char buff\\[33]) will just print 4 or 8 byte instead of the full\n  length of 16 bytes, on 32bit and 64bit systems respectively. (Thanks to\n  Cristian greco)\n\n  Own Id: OTP-9151\n\n- Initialize `to` and `to_name` in `erl_receive_msg`. (Thanks to Göran Larsson)\n\n  Own Id: OTP-9241\n\n- erl_interface: fix compile error(Thanks to Michael Santos)\n\n  Own Id: OTP-9252","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Erl_Interface 3.7.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Some malformed distribution messages could cause VM to crash, this is now\n  corrected.\n\n  Own Id: OTP-8993\n\n- Strengthen string copy check (Thanks to Michael Santos).\n\n  Own Id: OTP-9071\n\n- Strengthen atom length check when decoding atoms (Thanks to Michael Santos).\n\n  Own Id: OTP-9072","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Fix global registration. C node needed DFLAG_DIST_MONITOR_FLAT set when\n  connecting. Fix list compare in erl_compare_ext to return correct result.\n  (Thanks to Vitaliy Batichko and Evgeny Khirin)\n\n  Own Id: OTP-9015","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Erl_Interface 3.7.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- erl_call: remove get_hostent\n\n  get_hostent does not properly handle IPv4 addresses on little endian platforms\n  and fails with hostnames beginning with a number. Remove get_hostent and use\n  ei_gethostbyname directly since gethostbyname supports IPv4 addresses.\n\n  (Thanks to Michael Santos)\n\n  Own Id: OTP-8890\n\n- teach ei_x_format to handle unary - and + (Thanks to Steve Vinoski)\n\n  Own Id: OTP-8891\n\n- Fix zero byte allocation in registry. (Thanks to Michael Santos)\n\n  Own Id: OTP-8893\n\n- Check the length of the node name to prevent an overflow. Memory error control\n  of ei_alloc_big. (Thanks to Michael Santos)\n\n  Own Id: OTP-8943\n\n- erl_term_len() in erl_interface could returned too large values for integers\n  (since R14B) and too small values for refs (since R9B).\n\n  Own Id: OTP-8945","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Erl_Interface 3.7.1.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- The `erl_interface` tracelevel for erlang messages was incorrect. This has now\n  been fixed.\n\n  Own Id: OTP-8874","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Erl_Interface 3.7.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Removed unused variable in `ei_decode_term.c`.\n\n  Fixed faulty deallocation in `erl_call`.\n\n  Own Id: OTP-8748\n\n- ei_connect: correct man page examples (Thanks to Michael Santos)\n\n  Own Id: OTP-8813\n\n- ei: prevent overflow in `ei_connect_init` and `ei_xconnect`\n\n  Add length check of the buffer before copying. (Thanks to Michael Santos)\n\n  Own Id: OTP-8814\n\n- Remove DECLSPEC feature which fails on Windows Vista and use the fallback\n  implementation instead.\n\n  Own Id: OTP-8826\n\n- erl_call: fix multiple buffer overflows (Thanks to Michael Santos)\n\n  Own Id: OTP-8827","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Fix incorrect writev iovec buffer handling in `erl_interface` (Thanks to Steve\n  Vinoski)\n\n  Own Id: OTP-8837","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Erl_Interface 3.7 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-7"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- compact IEEE 754 double encoding in external binary format for ei\n\n  - Implement the compact IEEE 754 double encoding in external binary format for\n    ei. Encoding for ei now always produces the NEW_FLOAT_EXT format. Decoding\n    and term printing handle both the old ERL_FLOAT_EXT encoding and the new\n    NEW_FLOAT_EXT encoding.\n  - Legacy erl_interface code also handles the new encoding, but still produces\n    the ERL_FLOAT_EXT encoding by default.\n  - Also enable the DFLAG_NEW_FLOATS distribution flag.\n  - ei_get_type() will return ERL_FLOAT_EXT regardless if the external format is\n    encoded with ERL_FLOAT_EXT or NEW_FLOAT_EXT for doubles.\n  - Reduce the number of copies of the code for encoding and decoding doubles\n    throughout ei and erl_interface by instead calling the ei encoding and\n    decoding functions wherever possible.\n  - Restore commented-out float tests in ei_decode_SUITE and ei_encode_SUITE in\n    lib/erl_interface/test. Modify them to make them match the style of other\n    tests in the same suites.\n\n  These changes are based on an ei float patch from Serge Aleynikov originally\n  submitted against R12B-2 in July 2008 and reworked by Steve Vinoski May 2010.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8684","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Erl_Interface 3.6.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-5"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Document debug support.\n\n  Debug trace output for connection activity could be enabled setting the trace\n  level as an integer to the EI_TRACELEVEL environment variable. This option\n  could also be read and set from a running program using\n  ei_get_tracelevel(void) and ei_set_tracelevel(int).\n\n  Own Id: OTP-5037\n\n- Cross compilation improvements and other build system improvements.\n\n  Most notable:\n\n  - Lots of cross compilation improvements. The old cross compilation support\n    was more or less non-existing as well as broken. Please, note that the cross\n    compilation support should still be considered as experimental. Also note\n    that old cross compilation configurations cannot be used without\n    modifications. For more information on cross compiling Erlang/OTP see the\n    `$ERL_TOP/INSTALL-CROSS.md` file.\n  - Support for staged install using\n    [DESTDIR](http://www.gnu.org/prep/standards/html_node/DESTDIR.html). The old\n    broken `INSTALL_PREFIX` has also been fixed. For more information see the\n    `$ERL_TOP/INSTALL.md` file.\n  - Documentation of the `release` target of the top `Makefile`. For more\n    information see the `$ERL_TOP/INSTALL.md` file.\n  - `make install` now by default creates relative symbolic links instead of\n    absolute ones. For more information see the `$ERL_TOP/INSTALL.md` file.\n  - `$ERL_TOP/configure --help=recursive` now works and prints help for all\n    applications with `configure` scripts.\n  - Doing `make install`, or `make release` directly after `make all` no longer\n    triggers miscellaneous rebuilds.\n  - Existing bootstrap system is now used when doing `make install`, or\n    `make release` without a preceding `make all`.\n  - The `crypto` and `ssl` applications use the same runtime library path when\n    dynamically linking against `libssl.so` and `libcrypto.so`. The runtime\n    library search path has also been extended.\n  - The `configure` scripts of `erl_interface` and `odbc` now search for thread\n    libraries and thread library quirks the same way as `erts` do.\n  - The `configure` script of the `odbc` application now also looks for odbc\n    libraries in `lib64` and `lib/64` directories when building on a 64-bit\n    system.\n  - The `config.h.in` file in the `erl_interface` application is now\n    automatically generated in instead of statically updated which reduces the\n    risk of `configure` tests without any effect.\n\n  (Thanks to Henrik Riomar for suggestions and testing)\n\n  (Thanks to Winston Smith for the AVR32-Linux cross configuration and testing)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8323\n\n- Change erroneous \"\\\\\\\\0\" in documentation files `erl_notes.xml` and\n  `erl_eterm.xml`.\n\n  Own Id: OTP-8326\n\n- Allow `erl_match()` to match `ERL_LONGLONG` and `ERL_U_LONGLONG` terms (Thanks\n  to Scott Lystig Fritchie).\n\n  Own Id: OTP-8400","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Erl_Interface 3.6.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-4"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Erl_Interface 3.6.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- The manual states that erl_receive() return the reason in the `ErlMessage`\n  struct. This was not the case and the function is now corrected.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4969\n\n- In `send_exit.c` an erroneous size of memory allocation could occur when\n  reallocating a buffer.\n\n  In `ei_decode_trace.c` the index could be updated when the decoding failed.\n\n  In `ei_printterm.c` the index could be updated when the decoding failed in\n  lists and tuples.\n\n  In `ei_decode_term.c` when decoding a double (ERL_FLOAT_EXT) no check was done\n  to ensure that the last of the 31 bytes was null terminated.\n\n  In `ei_decode_term.c` when decoding references, only the first 3 bytes are\n  read, but the index did not increment by the total size.\n\n  In `ei_decode_fun.c` no check of correct buffer allocation or data length was\n  done.\n\n  In `ei_decode_string.c` the integer list string case did not decode the NIL\n  tail correctly.\n\n  These errors has now been fixed. (Thanks to Romain Lenglet, Paul Mineiro and\n  Paul Guyot).\n\n  Own Id: OTP-6117\n\n- `ei_decode_big` could be decoded with a garbage byte.\n\n  `ei_encode_big` and `ei_x_encode_big` is now available.\n\n  Own Id: OTP-7554\n\n- The function `erl_init_resolve()` did not conform to C99 standard which caused\n  a build error on some platforms. This has now been fixed.\n\n  Own Id: OTP-8093\n\n- `Makefile.in` has been updated to use the LDFLAGS environment variable (if\n  set). (Thanks to Davide Pesavento.)\n\n  Own Id: OTP-8157","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Added support for 64-bit integers in encoding/decoding.\n\n  Added support for better printouts of binaries.\n\n  Own Id: OTP-6091","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Erl_Interface 3.6.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- A problem with `gethostbyname` in `erl_start.c` could cause a buffer overflow.\n  This has now been fixed.\n\n  Clean up of code and removed compiler warnings.\n\n  Own Id: OTP-7978","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Erl_Interface 3.6.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- A faulty validation in `ei_reg_getpval` caused it to never return the\n  key-value. This has now been fixed. (Thanks to Matt Stancliff)\n\n  Own Id: OTP-7960","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Minor update to the `configure` script.\n\n  Own Id: OTP-7959","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Erl_Interface 3.6.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6-1-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Minor update to the `configure` script.\n\n  Own Id: OTP-7959","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Erl_Interface 3.6 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-6"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Nodes belonging to different independent clusters can now co-exist on the same\n  host with the help of a new environment variable setting ERL_EPMD_PORT.\n\n  Own Id: OTP-7826","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Erl_Interface 3.5.9 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- A type-casting bug in ei_skip_term and ei_printterm on 64bit platforms\n  rendering undefined results is now corrected.\n\n  Own Id: OTP-7577\n\n- A bug in the hostent copying code of erl_interface on MacOS X/Darwin is now\n  corrected.\n\n  Own Id: OTP-7593\n\n- A problem with building `erl_interface` on FreeBSD has been fixed (Thanks to\n  Akira Kitada).\n\n  Own Id: OTP-7611","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Erl_Interface 3.5.8 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Fixed bug in erl_interface when decoding broken data\n\n  Own Id: OTP-7448","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Erl_Interface 3.5.7 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- An erroneous freeing of memory could occur when using `ei_x_format_wo_ver` in\n  erl_interface, resulting in a segmentation fault.\n\n  Own Id: OTP-6795\n\n- A faulty compare in `erl_marshal` has now been fixed. (Thanks to Simon Cornish\n  and Paul Mineiro)\n\n  Own Id: OTP-7368","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Erl_Interface 3.5.6 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Minor documentation fixes.\n\n  Own Id: OTP-7183 Aux Id: OTP-7118","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Erl_Interface 3.5.5.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- The symbol \\_\\_erl_errno was undefined in the single thread version of the ei\n  library, but is now defined.\n\n  Own Id: OTP-6887\n\n- Corrected FreeBSD build error.\n\n  Own Id: OTP-7093","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Erl_Interface 3.5.5.3 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-5-3"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Calls to alloca in erl_marshal.c have been removed. A static buffer is now\n  used instead to store node names temporarily.\n\n  Own Id: OTP-6331 Aux Id: seq10468\n\n- ei_print_term interprets a list of integers with values from 0 to 255 as a\n  string. If the original list contains the integer 0, this is considered\n  terminator of the string. This is incorrect. The function has now been\n  modified to not look for '\\\\0' in a string, but always print all characters.\n\n  Own Id: OTP-6339 Aux Id: seq10492","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Erl_Interface 3.5.5.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- The combination of xeon processors with 64bit x86 extensions and a 32bit linux\n  could cause ei_decode_long and ei_decode_longlong to fail for the value\n  LONG_MIN and LONGLONG_MIN. The conversion is now made more portable.\n\n  Own Id: OTP-6216","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Erl_Interface 3.5.5.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-5-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Portability enhancements.\n\n  Own Id: OTP-6132","ref":"notes.html#improvements-and-new-features-41"},{"type":"extras","title":"Erl_Interface 3.5.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Different (and old) `config.guess` files in the `erts` and `erl_interface`\n  applications would cause build problems on the new Intel-based iMacs. (Thanks\n  to Sebastion Strollo.)\n\n  Own Id: OTP-5967\n\n- pthread header and library mismatch on linux systems (at least some SuSE and\n  Debian) with both NPTL and Linuxthreads libraries installed.\n\n  Own Id: OTP-5981","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Support for a C node to connect to an Erlang node on a standalone host has\n  been added.\n\n  Own Id: OTP-5883 Aux Id: seq10170","ref":"notes.html#improvements-and-new-features-42"},{"type":"extras","title":"Erl_interface 3.5.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-2"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- A configuration test error caused erl_interface to be built without support\n  for threads. This has been corrected.\n\n  Own Id: OTP-5456","ref":"notes.html#improvements-and-new-features-43"},{"type":"extras","title":"Erl_interface 3.5.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5-1"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Changes and improvements have been made to the build and test environment to\n  solve problems with failing erl_interface test cases.\n\n  Own Id: OTP-5295 Aux Id: OTP-5387","ref":"notes.html#improvements-and-new-features-44"},{"type":"extras","title":"Erl_interface 3.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-5"},{"type":"extras","title":"Improvements and New Features - Erl_interface Release Notes","doc":"- Process identifiers and port identifiers have been made more unique.\n  Previously 18 bits were used as id in the internal representation of process\n  and port identifiers. Now 28 bits are used.\n\n  The maximum limit on the number of concurrently existing processes due to the\n  representation of pids has been increased to 268435456 processes. The same is\n  true for ports. This limit will at least on a 32-bit architecture be\n  impossible to reach due to memory shortage.\n\n  _NOTE:_ By default, the `ERTS`, and the `erl_interface`, `ei`, and\n  `jinterface` libraries are now only guaranteed to be compatible with other\n  Erlang/OTP components from the same release. It is possible to set each\n  component in compatibility mode of an earlier release, though. See the\n  documentation for respective component on how to set it in compatibility mode.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4968 Aux Id: OTP-4196","ref":"notes.html#improvements-and-new-features-45"},{"type":"extras","title":"Erl_interface 3.4.5 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Corrections for mistakes done for patch erl_605/OTP-4874.\n\n  Own Id: OTP-4995 Aux Id: OTP-4874","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Erl_interface 3.4.4 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- A small optimization in ei_rpc\\*() was added and a bug in ei_decode_longlong()\n  was corrected.\n\n  Own Id: OTP-4784","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Erl_interface 3.4.2 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- Strings longer than 65535 bytes were encoded wrong in ei/erl_interface.\n\n  Own Id: OTP-4865 Aux Id: EABln07451","ref":"notes.html#fixed-bugs-and-malfunctions-67"},{"type":"extras","title":"Erl_interface 3.4.1 - Erl_interface Release Notes","doc":"","ref":"notes.html#erl_interface-3-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Erl_interface Release Notes","doc":"- erl_call -a parsed erlang terms incorrectly due to a bug in ei_format, which\n  is now corrected.\n\n  Own Id: OTP-4777 Aux Id: seq8099","ref":"notes.html#fixed-bugs-and-malfunctions-68"},{"type":"extras","title":"Erl_Interface User's Guide","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Erl_Interface User's Guide","ref":"ei_users_guide.html"},{"type":"extras","title":"Introduction - Erl_Interface User's Guide","doc":"The `Erl_Interface` library contains functions that help you integrate programs\nwritten in C and Erlang. The functions in `Erl_Interface` support the following:\n\n- Manipulation of data represented as Erlang data types\n- Conversion of data between C and Erlang formats\n- Encoding and decoding of Erlang data types for transmission or storage\n- Communication between C nodes and Erlang processes\n- Backup and restore of C node state to and from [Mnesia](`m:mnesia`)\n\n> #### Note {: .info }\n>\n> By default, the `Erl_Interface` library is only guaranteed to be compatible\n> with other Erlang/OTP components from the same release as the libraries\n> themselves. For information about how to communicate with Erlang/OTP\n> components from earlier releases, see function\n> [`ei_set_compat_rel`](ei.md#ei_set_compat_rel).","ref":"ei_users_guide.html#introduction"},{"type":"extras","title":"Scope - Erl_Interface User's Guide","doc":"In the following sections, these topics are described:\n\n- Compiling your code for use with `Erl_Interface`\n- Initializing `Erl_Interface`\n- Encoding, decoding, and sending Erlang terms\n- Building terms and patterns\n- Pattern matching\n- Connecting to a distributed Erlang node\n- Using the Erlang Port Mapper Daemon (EPMD)\n- Sending and receiving Erlang messages\n- Remote procedure calls\n- Using global names","ref":"ei_users_guide.html#scope"},{"type":"extras","title":"Prerequisites - Erl_Interface User's Guide","doc":"It is assumed that the reader is familiar with the Erlang programming language.","ref":"ei_users_guide.html#prerequisites"},{"type":"extras","title":"Compiling and Linking Your Code - Erl_Interface User's Guide","doc":"To use any of the `Erl_Interface` functions, include the following line in your\ncode:\n\n```c\n#include \"ei.h\"\n```\n\nDetermine where the top directory of your OTP installation is. To find this,\nstart Erlang and enter the following command at the Eshell prompt:\n\n```text\nEshell V4.7.4  (abort with ^G)\n1> code:root_dir().\n/usr/local/otp\n```\n\nTo compile your code, ensure that your C compiler knows where to find `ei.h` by\nspecifying an appropriate `-I` argument on the command line, or add it to the\n`CFLAGS` definition in your `Makefile`. The correct value for this path is\n`$OTPROOT/lib/erl_interface-$EIVSN/include`, where:\n\n- `$OTPROOT` is the path reported by `code:root_dir/0` in the example above.\n- `$EIVSN` is the version of the `Erl_Interface` application, for example,\n  `erl_interface-3.2.3`.\n\nCompiling the code:\n\n```text\n$ cc -c -I/usr/local/otp/lib/erl_interface-3.2.3/include myprog.c\n```\n\nWhen linking:\n\n- Specify the path to `libei.a` with `-L$OTPROOT/lib/erl_interface-3.2.3/lib`.\n- Specify the name of the library with `-lei`.\n\nDo this on the command line or add the flags to the `LDFLAGS` definition in your\n`Makefile`.\n\nLinking the code:\n\n```text\n$ ld -L/usr/local/otp/lib/erl_interface-3.2.3/\n                            lib myprog.o -lei -o myprog\n```\n\nOn some systems it can be necessary to link with some more libraries (for\nexample, `libnsl.a` and `libsocket.a` on Solaris, or `wsock32.lib` on Windows)\nto use the communication facilities of `Erl_Interface`.\n\nIf you use the `Erl_Interface` functions in a threaded application based on\nPOSIX threads or Solaris threads, then `Erl_Interface` needs access to some of\nthe synchronization facilities in your threads package. You must specify extra\ncompiler flags to indicate which of the packages you use. Define `_REENTRANT`\nand either `STHREADS` or `PTHREADS`. The default is to use POSIX threads if\n`_REENTRANT` is specified.","ref":"ei_users_guide.html#compiling-and-linking-your-code"},{"type":"extras","title":"Initializing the Library - Erl_Interface User's Guide","doc":"Before calling any of the other functions in the library, initialize it by\ncalling `ei_init()` exactly once.","ref":"ei_users_guide.html#initializing-the-library"},{"type":"extras","title":"Encoding, Decoding, and Sending Erlang Terms - Erl_Interface User's Guide","doc":"Data sent between distributed Erlang nodes is encoded in the Erlang external\nformat. You must therefore encode and decode Erlang terms into byte streams if\nyou want to use the distribution protocol to communicate between a C program and\nErlang.\n\nThe `Erl_Interface` library supports this activity. It has several C functions\nthat create and manipulate Erlang data structures. The following example shows\nhow to create and encode an Erlang tuple `{tobbe,3928}`:\n\n```c\nei_x_buff buf;\nei_x_new(&buf);\nint i = 0;\nei_x_encode_tuple_header(&buf, 2);\nei_x_encode_atom(&buf, \"tobbe\");\nei_x_encode_long(&buf, 3928);\n```\n\nFor a complete description, see the [`ei`](ei.md) module.\n\n[](){: #building_terms_and_patterns }","ref":"ei_users_guide.html#encoding-decoding-and-sending-erlang-terms"},{"type":"extras","title":"Building Terms - Erl_Interface User's Guide","doc":"The previous example can be simplified by using the\n[`ei_x_format_wo_ver`](ei.md#ei_x_format_wo_ver) function to create an Erlang\nterm:\n\n```c\nei_x_buff buf;\nei_x_new(&buf);\nei_x_format_wo_ver(&buf, \"{~a,~i}\", \"tobbe\", 3928);\n```\n\nFor a complete description of the different format directives, see the the\n[`ei_x_format_wo_ver`](ei.md#ei_x_format_wo_ver) function.\n\nThe following example is more complex:\n\n```c\nei_x_buff buf;\nint i = 0;\nei_x_new(&buf);\nei_x_format_wo_ver(&buf,\n                   \"[{name,~a},{age,~i},{data,[{adr,~s,~i}]}]\",\n                   \"madonna\",\n                   21,\n                  \"E-street\", 42);\nei_print_term(stdout, buf.buff, &i);\nei_x_free(&buf);\n```\n\nAs in the previous examples, it is your responsibility to free the memory\nallocated for Erlang terms. In this example, `ei_x_free()` ensures that the data\npointed to by `buf` is released.","ref":"ei_users_guide.html#building-terms"},{"type":"extras","title":"Connecting to a Distributed Erlang Node - Erl_Interface User's Guide","doc":"To connect to a distributed Erlang node, you must first initialize the\nconnection routine with one of the\n[`ei_connect_init_*`](ei_connect.md#ei_connect_init) functions, which stores\ninformation, such as the hostname, and node name for later use:\n\n```c\nint identification_number = 99;\nint creation=1;\nchar *cookie=\"a secret cookie string\"; /* An example */\nconst char* node_name = \"einode@durin\";\nconst char *cookie = NULL;\nshort creation = time(NULL) + 1;\nei_cnode ec;\nei_connect_init(&ec,\n                node_name,\n                cookie,\n                creation);\n```\n\nFor more information, see the [`ei_connect`](ei_connect.md) module.\n\nAfter initialization, you set up the connection to the Erlang node. To specify\nthe Erlang node you want to connect to, use the `ei_connect_*()` family of\nfunctions. The following example sets up the connection and is to result in a\nvalid socket file descriptor:\n\n```c\nint sockfd;\nconst char* node_name = \"einode@durin\"; /* An example */\nif ((sockfd = ei_connect(&ec, nodename)) < 0)\n  fprintf(stderr, \"ERROR: ei_connect failed\");\n```","ref":"ei_users_guide.html#connecting-to-a-distributed-erlang-node"},{"type":"extras","title":"Using EPMD - Erl_Interface User's Guide","doc":"[`erts:epmd`](`e:erts:epmd_cmd.md`) is the Erlang Port Mapper Daemon.\nDistributed Erlang nodes register with `epmd` on the local host to indicate to\nother nodes that they exist and can accept connections. `epmd` maintains a\nregister of node and port number information, and when a node wishes to connect\nto another node, it first contacts `epmd` to find the correct port number to\nconnect to.\n\nWhen you use [`ei_connect`](ei_connect.md) to connect to an Erlang node, a\nconnection is first made to `epmd` and, if the node is known, a connection is\nthen made to the Erlang node.\n\nC nodes can also register themselves with `epmd` if they want other nodes in the\nsystem to be able to find and connect to them.\n\nBefore registering with `epmd`, you must first create a listen socket and bind\nit to a port. Then:\n\n```c\nint pub = ei_publish(&ec, port);\n```\n\n`pub` is a file descriptor now connected to `epmd`. `epmd` monitors the other\nend of the connection. If it detects that the connection has been closed, the\nnode becomes unregistered. So, if you explicitly close the descriptor or if your\nnode fails, it becomes unregistered from `epmd`.\n\nNotice that on some systems a failed node is not detected by this mechanism, as\nthe operating system does not automatically close descriptors that were left\nopen when the node failed. If a node has failed in this way, `epmd` prevents you\nfrom registering a new node with the old name, as it thinks that the old name is\nstill in use. In this case, you must close the port explicitly","ref":"ei_users_guide.html#using-epmd"},{"type":"extras","title":"Sending and Receiving Erlang Messages - Erl_Interface User's Guide","doc":"Use one of the following two functions to send messages:\n\n- [`ei_send`](ei_connect.md#ei_send)\n- [`ei_reg_send`](ei_connect.md#ei_reg_send)\n\nAs in Erlang, messages can be sent to a pid or to a registered name. It is\neasier to send a message to a registered name, as it avoids the problem of\nfinding a suitable pid.\n\nUse one of the following two functions to receive messages:\n\n- [`ei_receive`](ei_connect.md#ei_receive)\n- [`ei_receive_msg`](ei_connect.md#ei_receive_msg)","ref":"ei_users_guide.html#sending-and-receiving-erlang-messages"},{"type":"extras","title":"Example of Sending Messages - Erl_Interface User's Guide","doc":"In the following example, `{Pid, hello_world}` is sent to a registered process\n`my_server`:\n\n```c\nei_x_buff buf;\nei_x_new_with_version(&buf);\n\nei_x_encode_tuple_header(&buf, 2);\nei_x_encode_pid(&buf, ei_self(ec));\nei_x_encode_atom(&buf, \"Hello world\");\n\nei_reg_send(&ec, fd, \"my_server\", buf.buff, buf.index);\n```\n\nThe first element of the tuple that is sent is your own pid. This enables\n`my_server` to reply. For more information about the primitives, see the\n[`ei_connect`](ei_connect.md) module.","ref":"ei_users_guide.html#example-of-sending-messages"},{"type":"extras","title":"Example of Receiving Messages - Erl_Interface User's Guide","doc":"In this example, `{Pid, Something}` is received.\n\n```c\nerlang_msg msg;\nint index = 0;\nint version;\nint arity = 0;\nerlang_pid pid;\nei_x_buff buf;\nei_x_new(&buf);\nfor (;;) {\n  int got = ei_xreceive_msg(fd, &msg, &x);\n  if (got == ERL_TICK)\n    continue;\n  if (got == ERL_ERROR) {\n    fprintf(stderr, \"ei_xreceive_msg, got==%d\", got);\n    exit(1);\n  }\n  break;\n}\nei_decode_version(buf.buff, &index, &version);\nei_decode_tuple_header(buf.buff, &index, &arity);\nif (arity != 2) {\n  fprintf(stderr, \"got wrong message\");\n  exit(1);\n}\nei_decode_pid(buf.buff, &index, &pid);\n```\n\nTo provide robustness, a distributed Erlang node occasionally polls all its\nconnected neighbors in an attempt to detect failed nodes or communication links.\nA node that receives such a message is expected to respond immediately with an\n`ERL_TICK` message. This is done automatically by `ei_xreceive_msg()`. However,\nwhen this has occurred, `ei_xreceive_msg` returns `ERL_TICK` to the caller\nwithout storing a message into the `erlang_msg` structure.\n\nWhen a message has been received, it is the caller's responsibility to free the\nreceived message.\n\nFor more information, see the [`ei_connect`](ei_connect.md) and [`ei`](ei.md)\nmodules.","ref":"ei_users_guide.html#example-of-receiving-messages"},{"type":"extras","title":"Remote Procedure Calls - Erl_Interface User's Guide","doc":"An Erlang node acting as a client to another Erlang node typically sends a\nrequest and waits for a reply. Such a request is included in a function call at\na remote node and is called a remote procedure call.\n\nThe following example checks if a specific Erlang process is alive:\n\n```c\nint index = 0, is_alive;\nei_x_buff args, result;\n\nei_x_new(&result);\nei_x_new(&args);\nei_x_encode_list_header(&args, 1);\nei_x_encode_pid(&args, &check_pid);\nei_x_encode_empty_list(&args);\n\nif (ei_rpc(&ec, fd, \"erlang\", \"is_process_alive\",\n           args.buff, args.index, &result) < 0)\n    handle_error();\n\nif (ei_decode_version(result.buff, &index) < 0\n    || ei_decode_bool(result.buff, &index, &is_alive) < 0)\n    handle_error();\n```\n\nFor more information about `ei_rpc()` and its companions `ei_rpc_to()` and\n`ei_rpc_from()`, see the [`ei_connect`](ei_connect.md) module.","ref":"ei_users_guide.html#remote-procedure-calls"},{"type":"extras","title":"Using Global Names - Erl_Interface User's Guide","doc":"A C node has access to names registered through the `m:global` module in Kernel.\nNames can be looked up, allowing the C node to send messages to named Erlang\nservices. C nodes can also register global names, allowing them to provide named\nservices to Erlang processes or other C nodes.\n\n`Erl_Interface` does not provide a native implementation of the global service.\nInstead it uses the global services provided by a \"nearby\" Erlang node. To use\nthe services described in this section, it is necessary to first open a\nconnection to an Erlang node.\n\nTo see what names there are:\n\n```c\nchar **names;\nint count;\nint i;\n\nnames = ei_global_names(&ec,fd,&count);\n\nif (names)\n  for (i=0; i  #### Note {: .info }\n>\n> Remember to free `pid` later with [`ei_x_free`](ei.md#ei_x_free).\n\nTo unregister a name:\n\n```c\nei_global_unregister(&ec,fd,servicename);\n```","ref":"ei_users_guide.html#using-global-names"},{"type":"extras","title":"erl_call","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# erl_call\n\nCall/start a distributed Erlang node.","ref":"erl_call_cmd.html"},{"type":"extras","title":"Description - erl_call","doc":"`erl_call` makes it possible to start and/or communicate with a distributed\nErlang node. It is built on the `Erl_Interface` library as an example\napplication. Its purpose is to use a Unix shell script to interact with a\ndistributed Erlang node. It performs all communication with the Erlang _rex\nserver_, using the standard Erlang RPC facility. It does not require any special\nsoftware to be run at the Erlang target node.\n\nThe main use is to either start a distributed Erlang node or to make an ordinary\nfunction call. However, it is also possible to pipe an Erlang module to\n`erl_call` and have it compiled, or to pipe a sequence of Erlang expressions to\nbe evaluated (similar to the Erlang shell).\n\nOptions, which cause `stdin` to be read, can be used with advantage, as scripts\nfrom within (Unix) shell scripts. Another nice use of `erl_call` could be from\n(HTTP) CGI-bin scripts.","ref":"erl_call_cmd.html#description"},{"type":"extras","title":"erl_call <options> - erl_call","doc":"Starts/calls Erlang.\n\nEach option flag is described below with its name, type, and meaning.\n\n- **`-a [Mod [Fun [Args]]]]`** - (_Optional._) Applies the specified function\n  and returns the result. `Mod` must be specified. However, `start` and `[]` are\n  assumed for unspecified `Fun` and `Args`, respectively. `Args` is to be in the\n  same format as for `erlang:apply/3` in `ERTS` except only a subset of all\n  terms are allowed. The allowed term types are: `list` (and `string`\n  representation of list, that is \"example\"), `tuple`, `atom` and `number`.\n\n  Notice that this flag takes exactly one argument, so quoting can be necessary\n  to group `Mod`, `Fun`, and `Args` in a manner dependent on the behavior of\n  your command shell.\n\n- **`-address [Hostname:]Port`** - (One of `-n`, `-name`, `-sname` or `-address`\n  is required.) `Hostname` is the hostname of the machine that is running the\n  peer node that `erl_call` will communicate with. The default hostname is the\n  hostname of the local machine. `Port` is the port number of the node that\n  `erl_call` will communicate with. The `-address` flag cannot be combined with\n  any of the flags `-n`, `-name`, `-sname` or `-s`.\n\n  The `-address` flag is typically useful when one wants to call a node that is\n  running on machine without an accessible [epmd](`e:erts:epmd_cmd.md`)\n  instance.\n\n- **`-c Cookie`** - (_Optional._) Use this option to specify a certain cookie.\n  If no cookie is specified, the `~/.erlang.cookie` file is read and its content\n  is used as cookie. The Erlang node we want to communicate with must have the\n  same cookie.\n\n- **`-d`** - (_Optional._) Debug mode. This causes all I/O to be output to the\n  `~/.erl_call.out.Nodename` file, where `Nodename` is the node name of the\n  Erlang node in question.\n\n- **`-e`** - (_Optional._) Reads a sequence of Erlang expressions, separated by\n  comma (`,`) and ended with a full stop (`.`), from `stdin` until EOF (Control-D).\n  Evaluates the expressions and returns the result from the last expression.\n  Returns `{ok,Result}` on success.\n\n- **`-fetch_stdout`** - (_Optional._) Executes the code, specified with the `-a`\n  or `-e` option, in a new process that has a\n  [group leader](`erlang:group_leader/0`) that forwards all stdout (standard\n  output) data so that it is printed to stdout of the `erl_call` process. This\n  means that stdout data that are written during the execution of the called\n  code, by the code and by descendant processes, will be forwarded (given that\n  the group leader has not been changed by a call to `erlang:group_leader/2`).\n\n  The printed data is UTF-8 encoded.\n\n  This option is only relevant combined with the `-a` or `-e` option.\n\n  See the documentation of [the I/O protocol](`e:stdlib:io_protocol.md`) for\n  more information about the group leader concept.\n\n  > #### Note {: .info }\n  >\n  > This option only works when `erl_call` is interacting with a node with a\n  > version greater or equal to OTP-24.\n\n- **`-h HiddenName`** - (_Optional._) Specifies the name of the hidden node that\n  `erl_call` represents.\n\n- **`-m`** - (_Optional._) Reads an Erlang module from `stdin` and compiles it.\n\n- **`-n Node`** - (One of `-n`, `-name`, `-sname` or `-address` is required.)\n  Has the same meaning as `-name` and can still be used for backward\n  compatibility reasons.\n\n- **`-name Node`** - (One of `-n`, `-name`, `-sname` or `-address` is required.)\n  `Node` is the name of the peer node to be started or communicated with. It is\n  assumed that `Node` is started with `erl -name`, which means that fully\n  qualified long node names are used. If option `-s` is specified, an Erlang\n  node will (if necessary) be started with `erl -name`.\n\n- **`-no_result_term`** - (_Optional._) Do not print the result term. This\n  option is only relevant together with the options `-a` and `-e`.\n\n- **`-q`** - (_Optional._) Halts the Erlang node specified with switch `-n`.\n  This switch overrides switch `-s`.\n\n- **`-r`** - (_Optional._) Generates a random name of the hidden node that\n  `erl_call` represents.\n\n- **`-R`** - (_Optional._) Request a dynamic random name, of the hidden node\n  that `erl_call` represents, from the peer node. Supported since OTP 23. Prefer\n  `-R` over `-r` when doing repeated requests toward the same peer node.\n\n- **`-s`** - (_Optional._) Starts a distributed Erlang node if necessary. This\n  means that in a sequence of calls, where '`-s`' and '`-n Node`' are constant,\n  only the first call starts the Erlang node. This makes the rest of the\n  communication very fast. This flag is currently only available on Unix-like\n  platforms (Linux, Mac OS X, Solaris, and so on).\n\n- **`-sname Node`** - (One of `-n`, `-name`, `-sname` or `-address` is\n  required.) `Node` is the name of the peer node to be started or communicated\n  with. It is assumed that `Node` is started with `erl -sname`, which means that\n  short node names are used. If option `-s` is specified, an Erlang node is\n  started (if necessary) with `erl -sname`.\n\n- **`-timeout Seconds`** - (_Optional._) Aborts the `erl_call` process after the\n  timeout expires. Note that this does not abort commands that have already been\n  started with `-a`, `-e`, or similar.\n\n- **`-v`** - (_Optional._) Prints a lot of `verbose` information. This is only\n  useful for the developer and maintainer of `erl_call`.\n\n- **`-x ErlScript`** - (_Optional._) Specifies another name of the Erlang\n  startup script to be used. If not specified, the standard `erl` startup script\n  is used.","ref":"erl_call_cmd.html#erl_call-options"},{"type":"extras","title":"Examples - erl_call","doc":"To start an Erlang node and call `erlang:time/0`:\n\n```text\nerl_call -s -a 'erlang time' -n madonna\n{18,27,34}\n```\n\nTo terminate an Erlang node by calling `erlang:halt/0`:\n\n```text\nerl_call -s -a 'erlang halt' -n madonna\n```\n\nTo apply with many arguments:\n\n```text\nerl_call -s -a 'lists seq [1,10]' -n madonna\n```\n\nTo evaluate some expressions (_the input ends with EOF (Control-D)_):\n\n```text\nerl_call -s -e -n madonna\nstatistics(runtime),\nX=1,\nY=2,\n{_,T}=statistics(runtime),\n{X+Y,T}.\n^D\n{ok,{3,0}}\n```\n\nTo compile a module and run it (_again, the input ends with EOF (Control-D)_):\n\n(In the example, the output has been formatted afterwards.)\n\n```text\nerl_call -s -m -a procnames -n madonna\n-module(procnames).\n-compile(export_all).\nstart() ->\n        P = processes(),\n        F = fun(X) -> {X,process_info(X,registered_name)} end,\n        lists:map(F,[],P).\n^D\n[{ ,\n                  {registered_name,init}},\n { ,\n                  {registered_name,erl_prim_loader}},\n { ,\n                  {registered_name,error_logger}},\n { ,\n                  {registered_name,application_controller}},\n { ,\n                  {registered_name,kernel}},\n { ,\n                  []},\n { ,\n                  {registered_name,kernel_sup}},\n { ,\n                  {registered_name,net_sup}},\n { ,\n                  {registered_name,net_kernel}},\n { ,\n                  []},\n { ,\n                  {registered_name,global_name_server}},\n { ,\n                  {registered_name,auth}},\n { ,\n                  {registered_name,rex}},\n { ,\n                  []},\n { ,\n                  {registered_name,file_server}},\n { ,\n                  {registered_name,code_server}},\n { ,\n                  {registered_name,user}},\n { ,\n                  []}]\n```\n\nTo forward standard output without printing the result term (_again, the input\nends with EOF (Control-D)_):\n\n```erlang\nerl_call -s -e -sname madonna -fetch_stdout -no_result_term\nio:format(\"Number of schedulers: ~p~n\", [erlang:system_info(schedulers)]),\nio:format(\"Number of logical cores: ~p~n\", [erlang:system_info(logical_processors_available)]).\n^D\nNumber of schedulers: 8\nNumber of logical cores: 8\n```","ref":"erl_call_cmd.html#examples"},{"type":"extras","title":"ei","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ei\n\nRoutines for handling the Erlang binary term format.","ref":"ei.html"},{"type":"extras","title":"Description - ei","doc":"The library `ei` contains macros and functions to encode and decode the Erlang\nbinary term format.\n\n`ei` allows you to convert atoms, lists, numbers, and binaries to and from the\nbinary format. This is useful when writing port programs and drivers. `ei` uses\na given buffer, no dynamic memory (except `ei_decode_fun()`) and is often quite\nfast.\n\n`ei` also handles C-nodes, C-programs that talks Erlang distribution with Erlang\nnodes (or other C-nodes) using the Erlang distribution format.The `ei` library\nis thread safe, and using threads, one process can handle multiple C-nodes.\n\nThe decode and encode functions use a buffer and an index into the buffer, which\npoints at the point where to encode and decode. The index is updated to point\nright after the term encoded/decoded. No checking is done whether the term fits\nin the buffer or not. If encoding goes outside the buffer, the program can\ncrash.\n\nAll functions take two parameters:\n\n- `buf` is a pointer to the buffer where the binary data is or will be.\n- `index` is a pointer to an index into the buffer. This parameter is\n  incremented with the size of the term decoded/encoded.\n\nThe data is thus at `buf[*index]` when an `ei` function is called.\n\nAll encode functions assume that the `buf` and `index` parameters point to a\nbuffer large enough for the data. Note that the binary term format uses variable-\nlength encoding so different values can require a different amount of space. For\nexample, smaller integer values can be more compact than larger ones. To get\nthe size of an encoded term, without encoding it, pass `NULL` instead of a\nbuffer pointer. Parameter `index` is incremented, but nothing will be encoded.\nThis is the way in `ei` to \"preflight\" term encoding.\n\nThere are also encode functions that use a dynamic buffer. It is often more\nconvenient to use these to encode data. All encode functions comes in two\nversions; those starting with `ei_x_` use a dynamic buffer of type\n[`ei_x_buff`](ei.md#ei_x_buff).\n\nAll functions return `0` if successful, otherwise `-1` (for example, if a term\nis not of the expected type, or the data to decode is an invalid Erlang term).\n\nSome of the decode functions need a pre-allocated buffer. This buffer must be\nallocated large enough, and for non-compound types the\n[`ei_get_type()`](ei.md#ei_get_type) function returns the size required (notice\nthat for strings an extra byte is needed for the `NULL`\\-terminator).","ref":"ei.html#description"},{"type":"extras","title":"Data Types - ei","doc":"- **`ei_term`{: #ei_term }**\n\n  ```c\n  typedef struct {\n      char ei_type;\n      int arity;\n      int size;\n      union {\n  \tlong i_val;\n  \tdouble d_val;\n  \tchar atom_name[MAXATOMLEN_UTF8];\n  \terlang_pid pid;\n  \terlang_port port;\n  \terlang_ref ref;\n      } value;\n  } ei_term;\n  ```\n\n  Structure written by [`ei_decode_ei_term()`](ei.md#ei_decode_ei_term). The\n  `ei_type` field is the type of the term which equals to what\n  [`ei_get_type()`](ei.md#ei_get_type) sets `*type` to.\n\n- **`ei_x_buff`{: #ei_x_buff }** - A dynamically resized buffer. It is a\n  `struct` with two fields of interest for the user:\n\n  - **`char *buff`** - Pointer to the dynamically allocated buffer.\n\n  - **`int index`** - Offset to the next byte to write which also equals the\n    amount of bytes currently written.\n\n  An `ei_x_buff` is initialized by calling either [`ei_x_new()`](ei.md#ei_x_new)\n  or [`ei_x_new_with_version()`](ei.md#ei_x_new_with_version). The memory used\n  by an initialized `ei_x_buff` is released by calling\n  [`ei_x_free()`](ei.md#ei_x_free).\n\n- **`erlang_char_encoding`{: #erlang_char_encoding }**\n\n  ```c\n  typedef enum {\n      ERLANG_ASCII = 1,\n      ERLANG_LATIN1 = 2,\n      ERLANG_UTF8 = 4\n  } erlang_char_encoding;\n  ```\n\n  The character encodings used for atoms. `ERLANG_ASCII` represents 7-bit ASCII.\n  Latin-1 and UTF-8 are different extensions of 7-bit ASCII. All 7-bit ASCII\n  characters are valid Latin-1 and UTF-8 characters. ASCII and Latin-1 both\n  represent each character by one byte. An UTF-8 character can consist of 1-4\n  bytes. Notice that these constants are bit-flags and can be combined with\n  bitwise OR.\n\n- **`erlang_fun`{: #erlang_fun }** - Opaque data type representing an Erlang\n  fun.\n\n- **`erlang_pid`{: #erlang_pid }** - Opaque data type representing an Erlang\n  process identifier.\n\n- **`erlang_port`{: #erlang_port }** - Opaque data type representing an Erlang\n  port identifier.\n\n- **`erlang_ref`{: #erlang_ref }** - Opaque data type representing an Erlang\n  reference.\n\n- **`erlang_trace`{: #erlang_trace }** - Opaque data type representing an Erlang\n  sequential trace token.","ref":"ei.html#data-types"},{"type":"extras","title":"ei_cmp_pids() - ei","doc":"```c\nint ei_cmp_pids(erlang_pid *a, erlang_pid *b);\n```\n\nCompare two process identifiers. The comparison is done the same way as Erlang\ndoes.\n\nReturns `0` if `a` and `b` are equal. Returns a value less than `0` if `a`\ncompares as less than `b`. Returns a value larger than `0` if `a` compares as\nlarger than `b`.\n\nAvailable since OTP 23.0","ref":"ei.html#ei_cmp_pids"},{"type":"extras","title":"ei_cmp_ports() - ei","doc":"```c\nint ei_cmp_ports(erlang_port *a, erlang_port *b);\n```\n\nCompare two port identifiers. The comparison is done the same way as Erlang\ndoes.\n\nReturns `0` if `a` and `b` are equal. Returns a value less than `0` if `a`\ncompares as less than `b`. Returns a value larger than `0` if `a` compares as\nlarger than `b`.\n\nAvailable since OTP 23.0","ref":"ei.html#ei_cmp_ports"},{"type":"extras","title":"ei_cmp_refs() - ei","doc":"```c\nint ei_cmp_refs(erlang_ref *a, erlang_ref *b);\n```\n\nCompare two references. The comparison is done the same way as Erlang does.\n\nReturns `0` if `a` and `b` are equal. Returns a value less than `0` if `a`\ncompares as less than `b`. Returns a value larger than `0` if `a` compares as\nlarger than `b`.\n\nAvailable since OTP 23.0","ref":"ei.html#ei_cmp_refs"},{"type":"extras","title":"ei_decode_atom() - ei","doc":"```c\nint ei_decode_atom(const char *buf, int *index, char *p);\n```\n\nDecodes an atom from the binary format. The `NULL`\\-terminated name of the atom\nis placed at `p`. At most `MAXATOMLEN` bytes can be placed in the buffer.","ref":"ei.html#ei_decode_atom"},{"type":"extras","title":"ei_decode_atom_as() - ei","doc":"```c\nint ei_decode_atom_as(const char *buf, int *index, char *p, int plen,\n  erlang_char_encoding want, erlang_char_encoding* was, erlang_char_encoding* result);\n```\n\nDecodes an atom from the binary format. The `NULL`\\-terminated name of the atom\nis placed in buffer at `p` of length `plen` bytes.\n\nThe wanted string encoding is specified by [`want`](ei.md#erlang_char_encoding).\nThe original encoding used in the binary format (Latin-1 or UTF-8) can be\nobtained from `*was`. The encoding of the resulting string (7-bit ASCII,\nLatin-1, or UTF-8) can be obtained from `*result`. Both `was` and `result` can\nbe `NULL`. `*result` can differ from `want` if `want` is a bitwise OR'd\ncombination like `ERLANG_LATIN1|ERLANG_UTF8` or if `*result` turns out to be\npure 7-bit ASCII (compatible with both Latin-1 and UTF-8).\n\nThis function fails if the atom is too long for the buffer or if it cannot be\nrepresented with encoding `want`.\n\nThis function was introduced in Erlang/OTP R16 as part of a first step to\nsupport UTF-8 atoms.\n\nAvailable since OTP R16B","ref":"ei.html#ei_decode_atom_as"},{"type":"extras","title":"ei_decode_bignum() - ei","doc":"```c\nint ei_decode_bignum(const char *buf, int *index, mpz_t obj);\n```\n\nDecodes an integer in the binary format to a GMP `mpz_t` integer. To use this\nfunction, the `ei` library must be configured and compiled to use the GMP\nlibrary.","ref":"ei.html#ei_decode_bignum"},{"type":"extras","title":"ei_decode_binary() - ei","doc":"```c\nint ei_decode_binary(const char *buf, int *index, void *p, long *len);\n```\n\nDecodes a binary from the binary format. Parameter `len` is set to the actual\nsize of the binary. Notice that `ei_decode_binary()` assumes that there is\nenough room for the binary. The size required can be fetched by\n[`ei_get_type()`](ei.md#ei_get_type).","ref":"ei.html#ei_decode_binary"},{"type":"extras","title":"ei_decode_bitstring() - ei","doc":"```c\nint ei_decode_bitstring(const char *buf, int *index, const char **pp,\n  unsigned int *bitoffsp, size_t *nbitsp);\n```\n\nDecodes a bit string from the binary format.\n\n- **`pp`** - Either `NULL` or `*pp` returns a pointer to the first byte of the\n  bit string. The returned bit string is readable as long as the buffer pointed\n  to by `buf` is readable and not written to.\n\n- **`bitoffsp`** - Either `NULL` or `*bitoffsp` returns the number of unused\n  bits in the first byte pointed to by `*pp`. The value of `*bitoffsp` is\n  between 0 and 7. Unused bits in the first byte are the most significant bits.\n\n- **`nbitsp`** - Either `NULL` or `*nbitsp` returns the length of the bit string\n  in _bits_.\n\nReturns `0` if it was a bit string term.\n\nThe number of _bytes_ pointed to by `*pp`, which are part of the bit string, is\n`(*bitoffsp + *nbitsp + 7)/8`. If `(*bitoffsp + *bitsp)%8 > 0` then only\n`(*bitoffsp + *bitsp)%8` bits of the last byte are used. Unused bits in the last\nbyte are the least significant bits.\n\nThe values of unused bits in the first and last byte are undefined and cannot be\nrelied on.\n\nNumber of bits may be divisible by 8, which means a binary decodable by\n`ei_decode_binary` is also decodable by `ei_decode_bitstring`.\n\nAvailable since OTP 22.0","ref":"ei.html#ei_decode_bitstring"},{"type":"extras","title":"ei_decode_boolean() - ei","doc":"```c\nint ei_decode_boolean(const char *buf, int *index, int *p);\n```\n\nDecodes a boolean value from the binary format. A boolean is actually an atom,\n`true` decodes 1 and `false` decodes 0.","ref":"ei.html#ei_decode_boolean"},{"type":"extras","title":"ei_decode_char() - ei","doc":"```c\nint ei_decode_char(const char *buf, int *index, char *p);\n```\n\nDecodes a char (8-bit) integer between 0-255 from the binary format. For\nhistorical reasons the returned integer is of type `char`. Your C code is to\nconsider the returned value to be of type `unsigned char` even if the C\ncompilers and system can define `char` to be signed.","ref":"ei.html#ei_decode_char"},{"type":"extras","title":"ei_decode_double() - ei","doc":"```c\nint ei_decode_double(const char *buf, int *index, double *p);\n```\n\nDecodes a double-precision (64-bit) floating point number from the binary\nformat.","ref":"ei.html#ei_decode_double"},{"type":"extras","title":"ei_decode_ei_term() - ei","doc":"```c\nint ei_decode_ei_term(const char* buf, int* index, ei_term* term);\n```\n\nDecodes any term, or at least tries to. If the term pointed at by `*index` in\n`buf` fits in the `term` union, it is decoded, and the appropriate field in\n`term->value` is set, and `*index` is incremented by the term size.\n\nThe function returns `1` on successful decoding, `-1` on error, and `0` if the\nterm seems alright, but does not fit in the `term` structure. If `1` is\nreturned, the `index` is incremented, and `term` contains the decoded term.\n\nThe `term` structure contains the arity for a tuple or list, size for a binary,\nstring, or atom. It contains a term if it is any of the following: integer,\nfloat, atom, pid, port, or ref.","ref":"ei.html#ei_decode_ei_term"},{"type":"extras","title":"ei_decode_fun() - ei","doc":"","ref":"ei.html#ei_decode_fun"},{"type":"extras","title":"free_fun() - ei","doc":"```c\nint ei_decode_fun(const char *buf, int *index, erlang_fun *p);\n```\n\n```c\nvoid free_fun(erlang_fun* f);\n```\n\nDecodes a fun from the binary format. Parameter `p` is to be `NULL` or point to\nan `erlang_fun` structure. This is the only decode function that allocates\nmemory. When the `erlang_fun` is no longer needed, it is to be freed with\n`free_fun`. (This has to do with the arbitrary size of the environment for a\nfun.)","ref":"ei.html#free_fun"},{"type":"extras","title":"ei_decode_iodata() - ei","doc":"```c\nint ei_decode_iodata(const char *buf, int *index, int *size, char *outbuf);\n```\n\nDecodes a term of the type [`iodata()`](`e:system:typespec.md#builtin_types`).\nThe `t:iodata/0` term will be flattened an written into the buffer pointed to by\nthe `outbuf` argument. The byte size of the `iodata` is written into the integer\nvariable pointed to by the `size` argument. Both `size` and `outbuf` can be set\nto `NULL`. The integer pointed to by the `index` argument is updated to refer to\nthe term following after the `t:iodata/0` term regardless of the the state of\nthe `size` and the `outbuf` arguments.\n\nNote that the buffer pointed to by the `outbuf` argument must be large enough if\na non `NULL` value is passed as `outbuf`. You typically want to call\n`ei_decode_iodata()` twice. First with a non `NULL` `size` argument and a `NULL`\n`outbuf` argument in order to determine the size of the buffer needed, and then\nonce again in order to do the actual decoding. Note that the integer pointed to\nby `index` will be updated by the call determining the size as well, so you need\nto reset it before the second call doing the actual decoding.\n\nReturns `0` on success and `-1` on failure. Failure might be either due to\ninvalid encoding of the term or due to the term not being of the type\n`t:iodata/0`. On failure, the integer pointed to by the `index` argument will be\nupdated to refer to the sub term where the failure was detected.\n\nAvailable since OTP 23.0","ref":"ei.html#ei_decode_iodata"},{"type":"extras","title":"ei_decode_list_header() - ei","doc":"```c\nint ei_decode_list_header(const char *buf, int *index, int *arity);\n```\n\nDecodes a list header from the binary format. The number of elements is returned\nin `arity`. The `arity+1` elements follow (the last one is the tail of the list,\nnormally an empty list). If `arity` is `0`, it is an empty list.\n\nNotice that lists are encoded as strings if they consist entirely of integers in\nthe range 0..255. This function do not decode such strings, use\n`ei_decode_string()` instead.","ref":"ei.html#ei_decode_list_header"},{"type":"extras","title":"ei_decode_long() - ei","doc":"```c\nint ei_decode_long(const char *buf, int *index, long *p);\n```\n\nDecodes a long integer from the binary format. If the code is 64 bits, the\nfunction `ei_decode_long()` is the same as `ei_decode_longlong()`.","ref":"ei.html#ei_decode_long"},{"type":"extras","title":"ei_decode_longlong() - ei","doc":"```c\nint ei_decode_longlong(const char *buf, int *index, long long *p);\n```\n\nDecodes a GCC `long long` or Visual C++ `__int64` (64-bit) integer from the\nbinary format.","ref":"ei.html#ei_decode_longlong"},{"type":"extras","title":"ei_decode_map_header() - ei","doc":"```c\nint ei_decode_map_header(const char *buf, int *index, int *arity);\n```\n\nDecodes a map header from the binary format. The number of key-value pairs is\nreturned in `*arity`. Keys and values follow in this order:\n`K1, V1, K2, V2, ..., Kn, Vn`. This makes a total of `arity*2` terms. If `arity`\nis zero, it is an empty map. A correctly encoded map does not have duplicate\nkeys.\n\nAvailable since OTP 17.0","ref":"ei.html#ei_decode_map_header"},{"type":"extras","title":"ei_decode_pid() - ei","doc":"```c\nint ei_decode_pid(const char *buf, int *index, erlang_pid *p);\n```\n\nDecodes a process identifier (pid) from the binary format.","ref":"ei.html#ei_decode_pid"},{"type":"extras","title":"ei_decode_port() - ei","doc":"```c\nint ei_decode_port(const char *buf, int *index, erlang_port *p);\n```\n\nDecodes a port identifier from the binary format.","ref":"ei.html#ei_decode_port"},{"type":"extras","title":"ei_decode_ref() - ei","doc":"```c\nint ei_decode_ref(const char *buf, int *index, erlang_ref *p);\n```\n\nDecodes a reference from the binary format.","ref":"ei.html#ei_decode_ref"},{"type":"extras","title":"ei_decode_string() - ei","doc":"```c\nint ei_decode_string(const char *buf, int *index, char *p);\n```\n\nDecodes a string from the binary format. A string in Erlang is a list of\nintegers between 0 and 255. Notice that as the string is just a list, sometimes\nlists are encoded as strings by [`term_to_binary/1`](`term_to_binary/1`), even\nif it was not intended.\n\nThe string is copied to `p`, and enough space must be allocated. The returned\nstring is `NULL`\\-terminated, so you must add an extra byte to the memory\nrequirement.","ref":"ei.html#ei_decode_string"},{"type":"extras","title":"ei_decode_trace() - ei","doc":"```c\nint ei_decode_trace(const char *buf, int *index, erlang_trace *p);\n```\n\nDecodes an Erlang trace token from the binary format.","ref":"ei.html#ei_decode_trace"},{"type":"extras","title":"ei_decode_tuple_header() - ei","doc":"```c\nint ei_decode_tuple_header(const char *buf, int *index, int *arity);\n```\n\nDecodes a tuple header, the number of elements is returned in `arity`. The tuple\nelements follow in order in the buffer.","ref":"ei.html#ei_decode_tuple_header"},{"type":"extras","title":"ei_decode_ulong() - ei","doc":"```c\nint ei_decode_ulong(const char *buf, int *index, unsigned long *p);\n```\n\nDecodes an unsigned long integer from the binary format. If the code is 64 bits,\nthe function `ei_decode_ulong()` is the same as `ei_decode_ulonglong()`.","ref":"ei.html#ei_decode_ulong"},{"type":"extras","title":"ei_decode_ulonglong() - ei","doc":"```c\nint ei_decode_ulonglong(const char *buf, int *index, unsigned long long *p);\n```\n\nDecodes a GCC `unsigned long long` or Visual C++ `unsigned __int64` (64-bit)\ninteger from the binary format.","ref":"ei.html#ei_decode_ulonglong"},{"type":"extras","title":"ei_decode_version() - ei","doc":"```c\nint ei_decode_version(const char *buf, int *index, int *version);\n```\n\nDecodes the version magic number for the Erlang binary term format. It must be\nthe first token in a binary term.","ref":"ei.html#ei_decode_version"},{"type":"extras","title":"ei_encode_atom() - ei","doc":"","ref":"ei.html#ei_encode_atom"},{"type":"extras","title":"ei_encode_atom_len() - ei","doc":"","ref":"ei.html#ei_encode_atom_len"},{"type":"extras","title":"ei_x_encode_atom() - ei","doc":"","ref":"ei.html#ei_x_encode_atom"},{"type":"extras","title":"ei_x_encode_atom_len() - ei","doc":"```c\nint ei_encode_atom(char *buf, int *index, const char *p);\n```\n\n```c\nint ei_encode_atom_len(char *buf, int *index, const char *p, int len);\n```\n\n```c\nint ei_x_encode_atom(ei_x_buff* x, const char *p);\n```\n\n```c\nint ei_x_encode_atom_len(ei_x_buff* x, const char *p, int len);\n```\n\nEncodes an atom in the binary format. Parameter `p` is the name of the atom in\nLatin-1 encoding. Only up to `MAXATOMLEN-1` bytes are encoded. The name is to be\n`NULL`\\-terminated, except for the `ei_x_encode_atom_len()` function.","ref":"ei.html#ei_x_encode_atom_len"},{"type":"extras","title":"ei_encode_atom_as() - ei","doc":"Available since OTP R16B","ref":"ei.html#ei_encode_atom_as"},{"type":"extras","title":"ei_encode_atom_len_as() - ei","doc":"Available since OTP R16B","ref":"ei.html#ei_encode_atom_len_as"},{"type":"extras","title":"ei_x_encode_atom_as() - ei","doc":"Available since OTP R16B","ref":"ei.html#ei_x_encode_atom_as"},{"type":"extras","title":"ei_x_encode_atom_len_as() - ei","doc":"```c\nint ei_encode_atom_as(char *buf, int *index, const char *p,\n  erlang_char_encoding from_enc, erlang_char_encoding to_enc);\n```\n\n```c\nint ei_encode_atom_len_as(char *buf, int *index, const char *p, int len,\n  erlang_char_encoding from_enc, erlang_char_encoding to_enc);\n```\n\n```c\nint ei_x_encode_atom_as(ei_x_buff* x, const char *p,\n  erlang_char_encoding from_enc, erlang_char_encoding to_enc);\n```\n\n```c\nint ei_x_encode_atom_len_as(ei_x_buff* x, const char *p, int len,\n  erlang_char_encoding from_enc, erlang_char_encoding to_enc);\n```\n\nEncodes an atom in the binary format. Parameter `p` is the name of the atom with\ncharacter encoding [`from_enc`](ei.md#erlang_char_encoding) (ASCII, Latin-1, or\nUTF-8). The name must either be `NULL`\\-terminated or a function variant with a\n`len` parameter must be used.\n\nThe encoding fails if `p` is not a valid string in encoding `from_enc`.\n\nArgument `to_enc` is ignored. As from Erlang/OTP 20 the encoding is always done\nin UTF-8 which is readable by nodes as old as Erlang/OTP R16.\n\nAvailable since OTP R16B","ref":"ei.html#ei_x_encode_atom_len_as"},{"type":"extras","title":"ei_encode_bignum() - ei","doc":"","ref":"ei.html#ei_encode_bignum"},{"type":"extras","title":"ei_x_encode_bignum() - ei","doc":"```c\nint ei_encode_bignum(char *buf, int *index, mpz_t obj);\n```\n\n```c\nint ei_x_encode_bignum(ei_x_buff *x, mpz_t obj);\n```\n\nEncodes a GMP `mpz_t` integer to binary format. To use this function, the `ei`\nlibrary must be configured and compiled to use the GMP library.","ref":"ei.html#ei_x_encode_bignum"},{"type":"extras","title":"ei_encode_binary() - ei","doc":"","ref":"ei.html#ei_encode_binary"},{"type":"extras","title":"ei_x_encode_binary() - ei","doc":"```c\nint ei_encode_binary(char *buf, int *index, const void *p, long len);\n```\n\n```c\nint ei_x_encode_binary(ei_x_buff* x, const void *p, long len);\n```\n\nEncodes a binary in the binary format. The data is at `p`, of `len` bytes\nlength.","ref":"ei.html#ei_x_encode_binary"},{"type":"extras","title":"ei_encode_bitstring() - ei","doc":"Available since OTP 22.0","ref":"ei.html#ei_encode_bitstring"},{"type":"extras","title":"ei_x_encode_bitstring() - ei","doc":"```c\nint ei_encode_bitstring(char *buf, int *index, const char *p, size_t bitoffs, size_t nbits);\n```\n\n```c\nint ei_x_encode_bitstring(ei_x_buff* x, const char *p, size_t bitoffs, size_t nbits);\n```\n\nEncodes a bit string in the binary format.\n\nThe data is at `p`. The length of the bit string is `nbits` bits. The first\n`bitoffs` bits of the data at `p` are unused. The first byte which is part of\nthe bit string is `p[bitoffs/8]`. The `bitoffs%8` most significant bits of the\nfirst byte `p[bitoffs/8]` are unused.\n\nThe number of bytes which is part of the bit string is\n`(bitoffs + nbits + 7)/8`. If `(bitoffs + nbits)%8 > 0` then only\n`(bitoffs + nbits)%8` bits of the last byte are used. Unused bits in the last\nbyte are the least significant bits.\n\nThe values of unused bits are disregarded and does not need to be cleared.\n\nAvailable since OTP 22.0","ref":"ei.html#ei_x_encode_bitstring"},{"type":"extras","title":"ei_encode_boolean() - ei","doc":"","ref":"ei.html#ei_encode_boolean"},{"type":"extras","title":"ei_x_encode_boolean() - ei","doc":"```c\nint ei_encode_boolean(char *buf, int *index, int p);\n```\n\n```c\nint ei_x_encode_boolean(ei_x_buff* x, int p);\n```\n\nEncodes a boolean value as the atom `true` if `p` is not zero, or `false` if `p`\nis zero.","ref":"ei.html#ei_x_encode_boolean"},{"type":"extras","title":"ei_encode_char() - ei","doc":"","ref":"ei.html#ei_encode_char"},{"type":"extras","title":"ei_x_encode_char() - ei","doc":"```c\nint ei_encode_char(char *buf, int *index, char p);\n```\n\n```c\nint ei_x_encode_char(ei_x_buff* x, char p);\n```\n\nEncodes a char (8-bit) as an integer between 0-255 in the binary format. For\nhistorical reasons the integer argument is of type `char`. Your C code is to\nconsider the specified argument to be of type `unsigned char` even if the C\ncompilers and system may define `char` to be signed.","ref":"ei.html#ei_x_encode_char"},{"type":"extras","title":"ei_encode_double() - ei","doc":"","ref":"ei.html#ei_encode_double"},{"type":"extras","title":"ei_x_encode_double() - ei","doc":"```c\nint ei_encode_double(char *buf, int *index, double p);\n```\n\n```c\nint ei_x_encode_double(ei_x_buff* x, double p);\n```\n\nEncodes a double-precision (64-bit) floating point number in the binary format.\n\nReturns `-1` if the floating point number is not finite.","ref":"ei.html#ei_x_encode_double"},{"type":"extras","title":"ei_encode_empty_list() - ei","doc":"","ref":"ei.html#ei_encode_empty_list"},{"type":"extras","title":"ei_x_encode_empty_list() - ei","doc":"```c\nint ei_encode_empty_list(char* buf, int* index);\n```\n\n```c\nint ei_x_encode_empty_list(ei_x_buff* x);\n```\n\nEncodes an empty list. It is often used at the tail of a list.","ref":"ei.html#ei_x_encode_empty_list"},{"type":"extras","title":"ei_encode_fun() - ei","doc":"","ref":"ei.html#ei_encode_fun"},{"type":"extras","title":"ei_x_encode_fun() - ei","doc":"```c\nint ei_encode_fun(char *buf, int *index, const erlang_fun *p);\n```\n\n```c\nint ei_x_encode_fun(ei_x_buff* x, const erlang_fun* fun);\n```\n\nEncodes a fun in the binary format. Parameter `p` points to an `erlang_fun`\nstructure. The `erlang_fun` is not freed automatically, the `free_fun` is to be\ncalled if the fun is not needed after encoding.","ref":"ei.html#ei_x_encode_fun"},{"type":"extras","title":"ei_encode_list_header() - ei","doc":"","ref":"ei.html#ei_encode_list_header"},{"type":"extras","title":"ei_x_encode_list_header() - ei","doc":"```c\nint ei_encode_list_header(char *buf, int *index, int arity);\n```\n\n```c\nint ei_x_encode_list_header(ei_x_buff* x, int arity);\n```\n\nEncodes a list header, with a specified arity. The next `arity+1` terms are the\nelements (actually its `arity` cons cells) and the tail of the list. Lists and\ntuples are encoded recursively, so that a list can contain another list or\ntuple.\n\nFor example, to encode the list `[c, d, [e | f]]`:\n\n```c\nei_encode_list_header(buf, &i, 3);\nei_encode_atom(buf, &i, \"c\");\nei_encode_atom(buf, &i, \"d\");\nei_encode_list_header(buf, &i, 1);\nei_encode_atom(buf, &i, \"e\");\nei_encode_atom(buf, &i, \"f\");\nei_encode_empty_list(buf, &i);\n```\n\n> #### Note {: .info }\n>\n> It may seem that there is no way to create a list without knowing the number\n> of elements in advance. But indeed there is a way. Notice that the list\n> `[a, b, c]` can be written as `[a | [b | [c]]]`. Using this, a list can be\n> written as conses.\n\nTo encode a list, without knowing the arity in advance:\n\n```c\nwhile (something()) {\n    ei_x_encode_list_header(&x, 1);\n    ei_x_encode_ulong(&x, i); /* just an example */\n}\nei_x_encode_empty_list(&x);\n```","ref":"ei.html#ei_x_encode_list_header"},{"type":"extras","title":"ei_encode_long() - ei","doc":"","ref":"ei.html#ei_encode_long"},{"type":"extras","title":"ei_x_encode_long() - ei","doc":"```c\nint ei_encode_long(char *buf, int *index, long p);\n```\n\n```c\nint ei_x_encode_long(ei_x_buff* x, long p);\n```\n\nEncodes a long integer in the binary format. If the code is 64 bits, the\nfunction `ei_encode_long()` is the same as `ei_encode_longlong()`.","ref":"ei.html#ei_x_encode_long"},{"type":"extras","title":"ei_encode_longlong() - ei","doc":"","ref":"ei.html#ei_encode_longlong"},{"type":"extras","title":"ei_x_encode_longlong() - ei","doc":"```c\nint ei_encode_longlong(char *buf, int *index, long long p);\n```\n\n```c\nint ei_x_encode_longlong(ei_x_buff* x, long long p);\n```\n\nEncodes a GCC `long long` or Visual C++ `__int64` (64-bit) integer in the binary\nformat.","ref":"ei.html#ei_x_encode_longlong"},{"type":"extras","title":"ei_encode_map_header() - ei","doc":"Available since OTP 17.0","ref":"ei.html#ei_encode_map_header"},{"type":"extras","title":"ei_x_encode_map_header() - ei","doc":"```c\nint ei_encode_map_header(char *buf, int *index, int arity);\n```\n\n```c\nint ei_x_encode_map_header(ei_x_buff* x, int arity);\n```\n\nEncodes a map header, with a specified arity. The next `arity*2` terms encoded\nwill be the keys and values of the map encoded in the following order:\n`K1, V1, K2, V2, ..., Kn, Vn`.\n\nFor example, to encode the map `#{a => \"Apple\", b => \"Banana\"}`:\n\n```c\nei_x_encode_map_header(&x, 2);\nei_x_encode_atom(&x, \"a\");\nei_x_encode_string(&x, \"Apple\");\nei_x_encode_atom(&x, \"b\");\nei_x_encode_string(&x, \"Banana\");\n```\n\nA correctly encoded map cannot have duplicate keys.\n\nAvailable since OTP 17.0","ref":"ei.html#ei_x_encode_map_header"},{"type":"extras","title":"ei_encode_pid() - ei","doc":"","ref":"ei.html#ei_encode_pid"},{"type":"extras","title":"ei_x_encode_pid() - ei","doc":"```c\nint ei_encode_pid(char *buf, int *index, const erlang_pid *p);\n```\n\n```c\nint ei_x_encode_pid(ei_x_buff* x, const erlang_pid *p);\n```\n\nEncodes an Erlang process identifier (pid) in the binary format. Parameter `p`\npoints to an `erlang_pid` structure which should either have been obtained\nearlier with [`ei_decode_pid()`](ei.md#ei_decode_pid),\n[`ei_self()`](ei_connect.md#ei_self) or created by\n[`ei_make_pid()`](ei_connect.md#ei_make_pid).","ref":"ei.html#ei_x_encode_pid"},{"type":"extras","title":"ei_encode_port() - ei","doc":"","ref":"ei.html#ei_encode_port"},{"type":"extras","title":"ei_x_encode_port() - ei","doc":"```c\nint ei_encode_port(char *buf, int *index, const erlang_port *p);\n```\n\n```c\nint ei_x_encode_port(ei_x_buff* x, const erlang_port *p);\n```\n\nEncodes an Erlang port in the binary format. Parameter `p` points to an\n`erlang_port` structure which should have been obtained earlier with\n[`ei_decode_port()`](ei.md#ei_decode_port),","ref":"ei.html#ei_x_encode_port"},{"type":"extras","title":"ei_encode_ref() - ei","doc":"","ref":"ei.html#ei_encode_ref"},{"type":"extras","title":"ei_x_encode_ref() - ei","doc":"```c\nint ei_encode_ref(char *buf, int *index, const erlang_ref *p);\n```\n\n```c\nint ei_x_encode_ref(ei_x_buff* x, const erlang_ref *p);\n```\n\nEncodes an Erlang reference in the binary format. Parameter `p` points to an\n`erlang_ref` structure which either should have been obtained earlier with\n[`ei_decode_ref()`](ei.md#ei_decode_ref), or created by\n[`ei_make_ref()`](ei_connect.md#ei_make_ref).","ref":"ei.html#ei_x_encode_ref"},{"type":"extras","title":"ei_encode_string() - ei","doc":"","ref":"ei.html#ei_encode_string"},{"type":"extras","title":"ei_encode_string_len() - ei","doc":"","ref":"ei.html#ei_encode_string_len"},{"type":"extras","title":"ei_x_encode_string() - ei","doc":"","ref":"ei.html#ei_x_encode_string"},{"type":"extras","title":"ei_x_encode_string_len() - ei","doc":"```c\nint ei_encode_string(char *buf, int *index, const char *p);\n```\n\n```c\nint ei_encode_string_len(char *buf, int *index, const char *p, int len);\n```\n\n```c\nint ei_x_encode_string(ei_x_buff* x, const char *p);\n```\n\n```c\nint ei_x_encode_string_len(ei_x_buff* x, const char* s, int len);\n```\n\nEncodes a string in the binary format. (A string in Erlang is a list, but is\nencoded as a character array in the binary format.) The string is to be\n`NULL`\\-terminated, except for the `ei_x_encode_string_len()` function.","ref":"ei.html#ei_x_encode_string_len"},{"type":"extras","title":"ei_encode_trace() - ei","doc":"","ref":"ei.html#ei_encode_trace"},{"type":"extras","title":"ei_x_encode_trace() - ei","doc":"```c\nint ei_encode_trace(char *buf, int *index, const erlang_trace *p);\n```\n\n```c\nint ei_x_encode_trace(ei_x_buff* x, const erlang_trace *p);\n```\n\nEncodes an Erlang trace token in the binary format. Parameter `p` points to a\n`erlang_trace` structure which should have been obtained earlier with\n[`ei_decode_trace()`](ei.md#ei_decode_trace).","ref":"ei.html#ei_x_encode_trace"},{"type":"extras","title":"ei_encode_tuple_header() - ei","doc":"","ref":"ei.html#ei_encode_tuple_header"},{"type":"extras","title":"ei_x_encode_tuple_header() - ei","doc":"```c\nint ei_encode_tuple_header(char *buf, int *index, int arity);\n```\n\n```c\nint ei_x_encode_tuple_header(ei_x_buff* x, int arity);\n```\n\nEncodes a tuple header, with a specified arity. The next `arity` terms encoded\nwill be the elements of the tuple. Tuples and lists are encoded recursively, so\nthat a tuple can contain another tuple or list.\n\nFor example, to encode the tuple `{a, {b, {}}}`:\n\n```c\nei_encode_tuple_header(buf, &i, 2);\nei_encode_atom(buf, &i, \"a\");\nei_encode_tuple_header(buf, &i, 2);\nei_encode_atom(buf, &i, \"b\");\nei_encode_tuple_header(buf, &i, 0);\n```","ref":"ei.html#ei_x_encode_tuple_header"},{"type":"extras","title":"ei_encode_ulong() - ei","doc":"","ref":"ei.html#ei_encode_ulong"},{"type":"extras","title":"ei_x_encode_ulong() - ei","doc":"```c\nint ei_encode_ulong(char *buf, int *index, unsigned long p);\n```\n\n```c\nint ei_x_encode_ulong(ei_x_buff* x, unsigned long p);\n```\n\nEncodes an unsigned long integer in the binary format. If the code is 64 bits,\nthe function `ei_encode_ulong()` is the same as `ei_encode_ulonglong()`.","ref":"ei.html#ei_x_encode_ulong"},{"type":"extras","title":"ei_encode_ulonglong() - ei","doc":"","ref":"ei.html#ei_encode_ulonglong"},{"type":"extras","title":"ei_x_encode_ulonglong() - ei","doc":"```c\nint ei_encode_ulonglong(char *buf, int *index, unsigned long long p);\n```\n\n```c\nint ei_x_encode_ulonglong(ei_x_buff* x, unsigned long long p);\n```\n\nEncodes a GCC `unsigned long long` or Visual C++ `unsigned __int64` (64-bit)\ninteger in the binary format.","ref":"ei.html#ei_x_encode_ulonglong"},{"type":"extras","title":"ei_encode_version() - ei","doc":"","ref":"ei.html#ei_encode_version"},{"type":"extras","title":"ei_x_encode_version() - ei","doc":"```c\nint ei_encode_version(char *buf, int *index);\n```\n\n```c\nint ei_x_encode_version(ei_x_buff* x);\n```\n\nEncodes a version magic number for the binary format. Must be the first token in\na binary term.","ref":"ei.html#ei_x_encode_version"},{"type":"extras","title":"ei_get_type() - ei","doc":"```c\nint ei_get_type(const char *buf, const int *index, int *type, int *size);\n```\n\nReturns the type in `*type` and size in `*size` of the encoded term. For strings\nand atoms, size is the number of characters _not_ including the terminating\n`NULL`. For binaries and bitstrings, `*size` is the number of bytes. For lists,\ntuples and maps, `*size` is the arity of the object. For bignum integers,\n`*size` is the number of bytes for the absolute value of the bignum. For other\ntypes, `*size` is 0. In all cases, `index` is left unchanged.\n\nCurrently `*type` is one of:\n\n- **ERL_ATOM_EXT** - Decode using either\n  [`ei_decode_atom()`](ei.md#ei_decode_atom),\n  [`ei_decode_atom_as()`](ei.md#ei_decode_atom_as), or\n  [`ei_decode_boolean()`](ei.md#ei_decode_boolean).\n\n- **ERL_BINARY_EXT** - Decode using either\n  [`ei_decode_binary()`](ei.md#ei_decode_binary),\n  [`ei_decode_bitstring()`](ei.md#ei_decode_bitstring), or\n  [`ei_decode_iodata()`](ei.md#ei_decode_iodata).\n\n- **ERL_BIT_BINARY_EXT** - Decode using\n  [`ei_decode_bitstring()`](ei.md#ei_decode_bitstring).\n\n- **ERL_FLOAT_EXT** - Decode using\n  [`ei_decode_double()`](ei.md#ei_decode_double).\n\n- **ERL_NEW_FUN_EXT, ERL_FUN_EXT, ERL_EXPORT_EXT** -\n  Decode using [`ei_decode_fun()`](ei.md#ei_decode_fun).\n\n- **ERL_SMALL_INTEGER_EXT, ERL_INTEGER_EXT, ERL_SMALL_BIG_EXT, ERL_LARGE_BIG_EXT** -\n  Decode using either [`ei_decode_char()`](ei.md#ei_decode_char),\n  [`ei_decode_long()`](ei.md#ei_decode_long),\n  [`ei_decode_longlong()`](ei.md#ei_decode_longlong),\n  [`ei_decode_ulong()`](ei.md#ei_decode_ulong),\n  [`ei_decode_ulonglong()`](ei.md#ei_decode_ulonglong), or\n  [`ei_decode_bignum()`](ei.md#ei_decode_bignum).\n\n- **ERL_LIST_EXT, ERL_NIL_EXT** -\n  Decode using either [`ei_decode_list_header()`](ei.md#ei_decode_list_header),\n  or [`ei_decode_iodata()`](ei.md#ei_decode_iodata).\n\n- **ERL_STRING_EXT** - Decode using either\n  [`ei_decode_string()`](ei.md#ei_decode_string), or\n  [`ei_decode_iodata()`](ei.md#ei_decode_iodata).\n\n- **ERL_MAP_EXT** - Decode using\n  [`ei_decode_map_header()`](ei.md#ei_decode_map_header).\n\n- **ERL_PID_EXT** - Decode using [`ei_decode_pid()`](ei.md#ei_decode_pid).\n\n- **ERL_PORT_EXT** - Decode using [`ei_decode_port()`](ei.md#ei_decode_port).\n\n- **ERL_NEW_REFERENCE_EXT** - Decode using\n  [`ei_decode_ref()`](ei.md#ei_decode_ref).\n\n- **ERL_SMALL_TUPLE_EXT, ERL_LARGE_TUPLE_EXT**  \n  Decode using [`ei_decode_tuple_header()`](ei.md#ei_decode_tuple_header).\n\nInstead of decoding a term you can also skipped past it if you are not\ninterested in the data by usage of [`ei_skip_term()`](ei.md#ei_skip_term).","ref":"ei.html#ei_get_type"},{"type":"extras","title":"ei_init() - ei","doc":"```c\nint ei_init(void);\n```\n\nInitialize the `ei` library. This function should be called once (and only once)\nbefore calling any other functionality in the `ei` library.\n\nOn success zero is returned. On failure a posix error code is returned.\n\nAvailable since OTP 21.3","ref":"ei.html#ei_init"},{"type":"extras","title":"ei_print_term() - ei","doc":"","ref":"ei.html#ei_print_term"},{"type":"extras","title":"ei_s_print_term() - ei","doc":"```c\nint ei_print_term(FILE* fp, const char* buf, int* index);\n```\n\n```c\nint ei_s_print_term(char** s, const char* buf, int* index);\n```\n\nPrints a term, in clear text, to the file specified by `fp`, or the buffer\npointed to by `s`. It tries to resemble the term printing in the Erlang shell.\n\nIn `ei_s_print_term()`, parameter `s` is to point to a dynamically (malloc)\nallocated string of `BUFSIZ` bytes or a `NULL` pointer. The string can be\nreallocated (and `*s` can be updated) by this function if the result is more\nthan `BUFSIZ` characters. The string returned is `NULL`\\-terminated.\n\nThe return value is the number of characters written to the file or string, or\n`-1` if `buf[index]` does not contain a valid term. Unfortunately, I/O errors on\n`fp` is not checked.\n\nArgument `index` is updated, that is, this function can be viewed as a decode\nfunction that decodes a term into a human-readable format.","ref":"ei.html#ei_s_print_term"},{"type":"extras","title":"ei_set_compat_rel() - ei","doc":"```c\nvoid ei_set_compat_rel(unsigned release_number);\n```\n\nIn general, the `ei` library is guaranteed to be compatible with other\nErlang/OTP components that are 2 major releases older or newer than the `ei`\nlibrary itself.\n\nSometimes an exception to the above rule has to be made to make new features (or\neven bug fixes) possible. A call to `ei_set_compat_rel(release_number)` sets the\n`ei` library in compatibility mode of OTP release `release_number`.\n\nThe only useful value for `release_number` is currently `21`. This will only be\nuseful and have an effect if _bit strings_ or _export funs_ are received from a\nconnected node. Before OTP 22, bit strings and export funs were not supported by\n`ei`. They were instead encoded using an undocumented fallback tuple format when\nsent from the emulator to `ei`:\n\n- **`Bit string`** - The term `<<42, 1:1>>` was encoded as `{<<42, 128>>, 1}`.\n  The first element of the tuple is a binary and the second element denotes how\n  many bits of the last bytes are part of the bit string. In this example only\n  the most significant bit of the last byte (128) is part of the bit string.\n\n- **`Export fun`** - The term `fun lists:map/2` was encoded as `{lists,map}`. A\n  tuple with the module, function and a missing arity.\n\nIf `ei_set_compat_rel(21)` is _not_ called then a connected emulator will send\nbit strings and export funs correctly encoded. The functions\n[`ei_decode_bitstring`](ei.md#ei_decode_bitstring) and\n[`ei_decode_fun`](ei.md#ei_decode_fun) has to be used to decode such terms.\nCalling `ei_set_compat_rel(21)` should only be done as a workaround to keep an\nold implementation alive, which expects to receive the undocumented tuple\nformats for bit strings and/or export funs.\n\n> #### Note {: .info }\n>\n> If this function is called, it can only be called once and must be called\n> before any other functions in the `ei` library are called.","ref":"ei.html#ei_set_compat_rel"},{"type":"extras","title":"ei_skip_term() - ei","doc":"```c\nint ei_skip_term(const char* buf, int* index);\n```\n\nSkips a term in the specified buffer; recursively skips elements of lists and\ntuples, so that a full term is skipped. This is a way to get the size of an\nErlang term.\n\n`buf` is the buffer.\n\n`index` is updated to point right after the term in the buffer.\n\n> #### Note {: .info }\n>\n> This can be useful when you want to hold arbitrary terms: skip them and copy\n> the binary term data to some buffer.\n\nReturns `0` on success, otherwise `-1`.","ref":"ei.html#ei_skip_term"},{"type":"extras","title":"ei_x_append() - ei","doc":"","ref":"ei.html#ei_x_append"},{"type":"extras","title":"ei_x_append_buf() - ei","doc":"```c\nint ei_x_append(ei_x_buff* x, const ei_x_buff* x2);\n```\n\n```c\nint ei_x_append_buf(ei_x_buff* x, const char* buf, int len);\n```\n\nAppends data at the end of buffer `x`.","ref":"ei.html#ei_x_append_buf"},{"type":"extras","title":"ei_x_format() - ei","doc":"","ref":"ei.html#ei_x_format"},{"type":"extras","title":"ei_x_format_wo_ver() - ei","doc":"```c\nint ei_x_format(ei_x_buff* x, const char* fmt, ...);\n```\n\n```c\nint ei_x_format_wo_ver(ei_x_buff* x, const char *fmt, ... );\n```\n\nFormats a term, given as a string, to a buffer. Works like a sprintf for Erlang\nterms. `fmt` contains a format string, with arguments like `~d`, to insert terms\nfrom variables. The following formats are supported (with the C types given):\n\n```text\n~a  An atom, char*\n~c  A character, char\n~s  A string, char*\n~i  An integer, int\n~l  A long integer, long int\n~u  A unsigned long integer, unsigned long int\n~f  A float, float\n~d  A double float, double float\n~p  An Erlang pid, erlang_pid*\n```\n\nFor example, to encode a tuple with some stuff:\n\n```c\nei_x_format(\"{~a,~i,~d}\", \"numbers\", 12, 3.14159)\nencodes the tuple {numbers,12,3.14159}\n```\n\n`ei_x_format_wo_ver()` formats into a buffer, without the initial version byte.\n\n> #### Change {: .info }\n>\n> Since OTP 26.2 maps can be encoded with syntax like `\"#{k1 => v1, k2 => v2}\"`.","ref":"ei.html#ei_x_format_wo_ver"},{"type":"extras","title":"ei_x_free() - ei","doc":"```c\nint ei_x_free(ei_x_buff* x);\n```\n\nDeallocates the dynamically allocated content of the buffer referred by `x`.\nAfter deallocation, the `buff` field is set to `NULL`.","ref":"ei.html#ei_x_free"},{"type":"extras","title":"ei_x_new() - ei","doc":"","ref":"ei.html#ei_x_new"},{"type":"extras","title":"ei_x_new_with_version() - ei","doc":"```c\nint ei_x_new(ei_x_buff* x);\n```\n\n```c\nint ei_x_new_with_version(ei_x_buff* x);\n```\n\nInitialize the dynamically realizable buffer referred to by `x`. The fields of\nthe structure pointed to by parameter `x` is filled in, and a default buffer is\nallocated. `ei_x_new_with_version()` also puts an initial version byte, which is\nused in the binary format (so that `ei_x_encode_version()` will not be needed.)","ref":"ei.html#ei_x_new_with_version"},{"type":"extras","title":"Debug Information - ei","doc":"Some tips on what to check when the emulator does not seem to receive the terms\nthat you send:\n\n- Be careful with the version header, use `ei_x_new_with_version()` when\n  appropriate.\n- Turn on distribution tracing on the Erlang node.\n- Check the result codes from `ei_decode_-calls`.","ref":"ei.html#debug-information"},{"type":"extras","title":"ei_connect","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ei_connect\n\nCommunicate with distributed Erlang.","ref":"ei_connect.html"},{"type":"extras","title":"Description - ei_connect","doc":"This module enables C-programs to communicate with Erlang nodes, using the\nErlang distribution over TCP/IP.\n\nA C-node appears to Erlang as a _hidden node_. That is, Erlang processes that\nknow the name of the C-node can communicate with it in a normal manner, but the\nnode name is not shown in the listing provided by `erlang:nodes/0` in `ERTS`.\n\nThe environment variable `ERL_EPMD_PORT` can be used to indicate which logical\ncluster a C-node belongs to.","ref":"ei_connect.html#description"},{"type":"extras","title":"Time-Out Functions - ei_connect","doc":"Most functions appear in a version with the suffix `_tmo` appended to the\nfunction name. Those functions take an extra argument, a time-out in\n_milliseconds_. The semantics is this: for each communication primitive involved\nin the operation, if the primitive does not complete within the time specified,\nthe function returns an error and `erl_errno` is set to `ETIMEDOUT`. With\ncommunication primitive is meant an operation on the socket, like `connect`,\n`accept`, `recv`, or `send`.\n\nClearly the time-outs are for implementing fault tolerance, not to keep hard\nreal-time promises. The `_tmo` functions are for detecting non-responsive peers\nand to avoid blocking on socket operations.\n\nA time-out value of `0` (zero) means that time-outs are disabled. Calling a\n`_tmo` function with the last argument as `0` is therefore the same thing as\ncalling the function without the `_tmo` suffix.\n\nAs with all other functions starting with `ei_`, you are _not_ expected to put\nthe socket in non-blocking mode yourself in the program. Every use of\nnon-blocking mode is embedded inside the time-out functions. The socket will\nalways be back in blocking mode after the operations are completed (regardless\nof the result). To avoid problems, leave the socket options alone. `ei` handles\nany socket options that need modification.\n\nIn all other senses, the `_tmo` functions inherit all the return values and the\nsemantics from the functions without the `_tmo` suffix.\n\n[](){: #ussi }","ref":"ei_connect.html#time-out-functions"},{"type":"extras","title":"User Supplied Socket Implementation - ei_connect","doc":"By default `ei` supplies a TCP/IPv4 socket interface that is used when\ncommunicating. The user can however plug in his/her own IPv4 socket\nimplementation. This, for example, in order to communicate over TLS. A user\nsupplied socket implementation is plugged in by passing a\n[callback structure](ei_connect.md#ei_socket_callbacks) to either\n[`ei_connect_init_ussi()`](ei_connect.md#ei_connect_init) or\n[`ei_connect_xinit_ussi()`](ei_connect.md#ei_connect_init).\n\nAll callbacks in the `ei_socket_callbacks` structure _should_ return zero on\nsuccess; and a posix error code on failure.\n\nThe `addr` argument of the `listen`, `accept`, and `connect` callbacks refer to\nappropriate address structure for currently used protocol. Currently `ei` only\nsupports IPv4. That is, at this time `addr` always points to a\n`struct sockaddr_in` structure.\n\n[](){: #ei_socket_callbacks_fields } The\n[`ei_socket_callbacks`](ei_connect.md#ei_socket_callbacks) structure may be\nenlarged in the future. All fields not set, _needs_ to be zeroed out. Currently\nthe following fields exist:\n\n- **`flags`** - Flags informing `ei` about the behaviour of the callbacks. Flags\n  should be bitwise or:ed together. If no flag, is set, the `flags` field should\n  contain `0`. Currently, supported flags:\n\n  - **`EI_SCLBK_FLG_FULL_IMPL`** - If set, the `accept()`, `connect()`,\n    `writev()`, `write()`, and `read()` callbacks implements timeouts. The\n    timeout is passed in the `tmo` argument and is given in milli seconds. Note\n    that the `tmo` argument to these callbacks differ from the timeout arguments\n    in the `ei` API. Zero means a zero timeout. That is, poll and timeout\n    immediately unless the operation is successful. `EI_SCLBK_INF_TMO` (max\n    `unsigned`) means infinite timeout. The file descriptor is in blocking mode\n    when a callback is called, and it must be in blocking mode when the callback\n    returns.\n\n    If not set, `ei` will implement the timeout using `select()` in order to\n    determine when to call the callbacks and when to time out. The `tmo`\n    arguments of the `accept()`, `connect()`, `writev()`, `write()`, and\n    `read()` callbacks should be ignored. The callbacks may be called in\n    non-blocking mode. The callbacks are not allowed to change between blocking\n    and non-blocking mode. In order for this to work, `select()` needs to\n    interact with the socket primitives used the same way as it interacts with\n    the ordinary socket primitives. If this is not the case, the callbacks\n    _need_ to implement timeouts and this flag should be set.\n\n  More flags may be introduced in the future.\n\n- __`int (*socket)(void **ctx, void *setup_ctx)`__ - Create a socket and a\n  context for the socket.\n\n  On success it should set `*ctx` to point to a context for the created socket.\n  This context will be passed to all other socket callbacks. This function will\n  be passed the same `setup_context` as passed to the preceding\n  [`ei_connect_init_ussi()`](ei_connect.md#ei_connect_init) or\n  [`ei_connect_xinit_ussi()`](ei_connect.md#ei_connect_init) call.\n\n  > #### Note {: .info }\n  >\n  > During the lifetime of a socket, the pointer `*ctx` _has_ to remain the\n  > same. That is, it cannot later be relocated.\n\n  This callback is mandatory.\n\n- **`int (*close)(void *ctx)`** - Close the socket identified by `ctx` and\n  destroy the context.\n\n  This callback is mandatory.\n\n- **`int (*listen)(void *ctx, void *addr, int *len, int backlog)`** - Bind the\n  socket identified by `ctx` to a local interface and then listen on it.\n\n  The `addr` and `len` arguments are both input and output arguments. When\n  called `addr` points to an address structure of length `*len` containing\n  information on how to bind the socket. Upon return this callback should have\n  updated the structure referred by `addr` with information on how the socket\n  actually was bound. `*len` should be updated to reflect the size of `*addr`\n  updated. `backlog` identifies the size of the backlog for the listen socket.\n\n  This callback is mandatory.\n\n- __`int (*accept)(void **ctx, void *addr, int *len, unsigned tmo)`__ - Accept\n  connections on the listen socket identified by `*ctx`.\n\n  When a connection is accepted, a new context for the accepted connection\n  should be created and `*ctx` should be updated to point to the new context for\n  the accepted connection. When called `addr` points to an uninitialized address\n  structure of length `*len`. Upon return this callback should have updated this\n  structure with information about the client address. `*len` should be updated\n  to reflect the size of `*addr` updated.\n\n  If the `EI_SCLBK_FLG_FULL_IMPL` flag has been set, `tmo` contains timeout time\n  in milliseconds.\n\n  > #### Note {: .info }\n  >\n  > During the lifetime of a socket, the pointer `*ctx` _has_ to remain the\n  > same. That is, it cannot later be relocated.\n\n  This callback is mandatory.\n\n- **`int (*connect)(void *ctx, void *addr, int len, unsigned tmo)`** - Connect\n  the socket identified by `ctx` to the address identified by `addr`.\n\n  When called `addr` points to an address structure of length `len` containing\n  information on where to connect.\n\n  If the `EI_SCLBK_FLG_FULL_IMPL` flag has been set, `tmo` contains timeout time\n  in milliseconds.\n\n  This callback is mandatory.\n\n- **`int (*writev)(void *ctx, const void *iov, long iovcnt, ssize_t *len, unsigned tmo)`** -\n  Write data on the connected socket identified by `ctx`.\n\n  `iov` points to an array of `struct iovec` structures of length `iovcnt`\n  containing data to write to the socket. On success, this callback should set\n  `*len` to the amount of bytes successfully written on the socket.\n\n  If the `EI_SCLBK_FLG_FULL_IMPL` flag has been set, `tmo` contains timeout time\n  in milliseconds.\n\n  This callback is optional. Set the `writev` field in the the\n  `ei_socket_callbacks` structure to `NULL` if not implemented.\n\n- **`int (*write)(void *ctx, const char *buf, ssize_t *len, unsigned tmo)`** -\n  Write data on the connected socket identified by `ctx`.\n\n  When called `buf` points to a buffer of length `*len` containing the data to\n  write on the socket. On success, this callback should set `*len` to the amount\n  of bytes successfully written on the socket.\n\n  If the `EI_SCLBK_FLG_FULL_IMPL` flag has been set, `tmo` contains timeout time\n  in milliseconds.\n\n  This callback is mandatory.\n\n- **`int (*read)(void *ctx, char *buf, ssize_t *len, unsigned tmo)`** - Read\n  data on the connected socket identified by `ctx`.\n\n  `buf` points to a buffer of length `*len` where the read data should be\n  placed. On success, this callback should update `*len` to the amount of bytes\n  successfully read on the socket.\n\n  If the `EI_SCLBK_FLG_FULL_IMPL` flag has been set, `tmo` contains timeout time\n  in milliseconds.\n\n  This callback is mandatory.\n\n- **`int (*handshake_packet_header_size)(void *ctx, int *sz)`** - Inform about\n  handshake packet header size to use during the Erlang distribution handshake.\n\n  On success, `*sz` should be set to the handshake packet header size to use.\n  Valid values are `2` and `4`. Erlang TCP distribution use a handshake packet\n  size of `2` and Erlang TLS distribution use a handshake packet size of `4`.\n\n  This callback is mandatory.\n\n- **`int (*connect_handshake_complete)(void *ctx)`** - Called when a locally\n  started handshake has completed successfully.\n\n  This callback is optional. Set the `connect_handshake_complete` field in the\n  `ei_socket_callbacks` structure to `NULL` if not implemented.\n\n- **`int (*accept_handshake_complete)(void *ctx)`** - Called when a remotely\n  started handshake has completed successfully.\n\n  This callback is optional. Set the `accept_handshake_complete` field in the\n  `ei_socket_callbacks` structure to `NULL` if not implemented.\n\n- **`int (*get_fd)(void *ctx, int *fd)`** - Inform about file descriptor used by\n  the socket which is identified by `ctx`.\n\n  > #### Note {: .info }\n  >\n  > During the lifetime of a socket, the file descriptor _has_ to remain the\n  > same. That is, repeated calls to this callback with the same context\n  > `should` always report the same file descriptor.\n  >\n  > The file descriptor _has_ to be a real file descriptor. That is, no other\n  > operation should be able to get the same file descriptor until it has been\n  > released by the `close()` callback.\n\n  This callback is mandatory.","ref":"ei_connect.html#user-supplied-socket-implementation"},{"type":"extras","title":"Data Types - ei_connect","doc":"- **`ei_cnode`{: #ei_cnode }** - Opaque data type representing a C-node. A\n  `ei_cnode` structure is initialized by calling\n  [`ei_connect_init()`](ei_connect.md#ei_connect_init) or friends.\n\n- **`ei_socket_callbacks`{: #ei_socket_callbacks }**\n\n  ```c\n  typedef struct {\n      int flags;\n      int (*socket)(void **ctx, void *setup_ctx);\n      int\t(*close)(void *ctx);\n      int (*listen)(void *ctx, void *addr, int *len, int backlog);\n      int (*accept)(void **ctx, void *addr, int *len, unsigned tmo);\n      int (*connect)(void *ctx, void *addr, int len, unsigned tmo);\n      int (*writev)(void *ctx, const void *iov, int iovcnt, ssize_t *len, unsigned tmo);\n      int (*write)(void *ctx, const char *buf, ssize_t *len, unsigned tmo);\n      int (*read)(void *ctx, char *buf, ssize_t *len, unsigned tmo);\n      int (*handshake_packet_header_size)(void *ctx, int *sz);\n      int (*connect_handshake_complete)(void *ctx);\n      int (*accept_handshake_complete)(void *ctx);\n      int (*get_fd)(void *ctx, int *fd);\n  } ei_socket_callbacks;\n  ```\n\n  Callbacks functions for a\n  [_User Supplied Socket Implementation_](ei_connect.md#ussi).\n  [Documentation of each field](ei_connect.md#ei_socket_callbacks_fields) can be\n  found in the _User Supplied Socket Implementation_ section above.\n\n- **`ErlConnect`{: #ErlConnect }**\n\n  ```c\n  typedef struct {\n      char ipadr[4]; /* Ip v4 address in network byte order */\n      char nodename[MAXNODELEN];\n  } ErlConnect;\n  ```\n\n  IP v4 address and nodename.\n\n- **`Erl_IpAddr`{: #Erl_IpAddr }**\n\n  ```c\n  typedef struct {\n      unsigned s_addr; /* Ip v4 address in network byte order */\n  } Erl_IpAddr;\n  ```\n\n  IP v4 address.\n\n- **`erlang_msg`{: #erlang_msg }**\n\n  ```c\n  typedef struct {\n      long msgtype;\n      erlang_pid from;\n      erlang_pid to;\n      char toname[MAXATOMLEN+1];\n      char cookie[MAXATOMLEN+1];\n      erlang_trace token;\n  } erlang_msg;\n  ```\n\n  Information about a message received via\n  [`ei_receive_msg()`](ei_connect.md#ei_receive_msg) or friends.","ref":"ei_connect.html#data-types"},{"type":"extras","title":"ei_gethostbyaddr() - ei_connect","doc":"","ref":"ei_connect.html#ei_gethostbyaddr"},{"type":"extras","title":"ei_gethostbyaddr_r() - ei_connect","doc":"","ref":"ei_connect.html#ei_gethostbyaddr_r"},{"type":"extras","title":"ei_gethostbyname() - ei_connect","doc":"","ref":"ei_connect.html#ei_gethostbyname"},{"type":"extras","title":"ei_gethostbyname_r() - ei_connect","doc":"```c\nstruct hostent * ei_gethostbyaddr(const char *addr, int len, int type);\n```\n\n```c\nstruct hostent * ei_gethostbyaddr_r(const char *addr, int length,  int type,\n  struct hostent *hostp, char *buffer,   int buflen,  int *h_errnop);\n```\n\n```c\nstruct hostent * ei_gethostbyname(const char *name);\n```\n\n```c\nstruct hostent * ei_gethostbyname_r(const char *name,  struct hostent *hostp,\n  char *buffer,  int buflen,  int *h_errnop);\n```\n\nConvenience functions for some common name lookup functions.","ref":"ei_connect.html#ei_gethostbyname_r"},{"type":"extras","title":"ei_accept() - ei_connect","doc":"```c\nint ei_accept(ei_cnode *ec, int listensock, ErlConnect *conp);\n```\n\nUsed by a server process to accept a connection from a client process.\n\n- `ec` is the C-node structure.\n- `listensock` is an open socket descriptor on which `listen()` has previously\n  been called.\n- `conp` is a pointer to an [`ErlConnect`](ei_connect.md#ErlConnect) struct.\n\nOn success, `conp` is filled in with the address and node name of the connecting\nclient and a file descriptor is returned. On failure, `ERL_ERROR` is returned\nand `erl_errno` is set to `EIO`.","ref":"ei_connect.html#ei_accept"},{"type":"extras","title":"ei_accept_tmo() - ei_connect","doc":"```c\nint ei_accept_tmo(ei_cnode *ec, int listensock, ErlConnect *conp, unsigned timeout_ms);\n```\n\nEquivalent to `ei_accept` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_accept_tmo"},{"type":"extras","title":"ei_close_connection() - ei_connect","doc":"```c\nint ei_close_connection(int fd);\n```\n\nCloses a previously opened connection or listen socket.\n\nAvailable since OTP 21.3","ref":"ei_connect.html#ei_close_connection"},{"type":"extras","title":"ei_connect() - ei_connect","doc":"","ref":"ei_connect.html#ei_connect"},{"type":"extras","title":"ei_xconnect() - ei_connect","doc":"","ref":"ei_connect.html#ei_xconnect"},{"type":"extras","title":"ei_connect_host_port() - ei_connect","doc":"Available since OTP 23.0","ref":"ei_connect.html#ei_connect_host_port"},{"type":"extras","title":"ei_xconnect_host_port() - ei_connect","doc":"```c\nint ei_connect(ei_cnode* ec, char *nodename);\n```\n\n```c\nint ei_xconnect(ei_cnode* ec, Erl_IpAddr adr, char *alivename);\n```\n\n```c\nint ei_connect_host_port(ei_cnode* ec, char *hostname, int port);\n```\n\n```c\nint ei_xconnect_host_port(ei_cnode* ec, Erl_IpAddr adr, int port);\n```\n\nSets up a connection to an Erlang node.\n\n`ei_xconnect()` requires the IP address of the remote host and the alive name of\nthe remote node to be specified. `ei_connect()` provides an alternative\ninterface and determines the information from the node name provided. The\n`ei_xconnect_host_port()` function provides yet another alternative that will\nwork even if there is no EPMD instance on the host where the remote node is\nrunning. The `ei_xconnect_host_port()` function requires the IP address and port\nof the remote node to be specified. The `ei_connect_host_port()` function is an\nalternative to `ei_xconnect_host_port()` that lets the user specify a hostname\ninstead of an IP address.\n\n- `adr` is the 32-bit IP address of the remote host.\n- `alive` is the alivename of the remote node.\n- `node` is the name of the remote node.\n- `port` is the port number of the remote node.\n\nThese functions return an open file descriptor on success, or a negative value\nindicating that an error occurred. In the latter case they set `erl_errno` to\none of the following:\n\n- **`EHOSTUNREACH`** - The remote host `node` is unreachable.\n\n- **`ENOMEM`** - No more memory is available.\n\n- **`EIO`** - I/O error.\n\nAlso, `errno` values from `socket(2)` and `connect(2)` system calls may be\npropagated into `erl_errno`.\n\n_Example:_\n\n```c\n#define NODE   \"madonna@chivas.du.etx.ericsson.se\"\n#define ALIVE  \"madonna\"\n#define IP_ADDR \"150.236.14.75\"\n\n/*** Variant 1 ***/\nint fd = ei_connect(&ec, NODE);\n\n/*** Variant 2 ***/\nstruct in_addr addr;\naddr.s_addr = inet_addr(IP_ADDR);\nfd = ei_xconnect(&ec, &addr, ALIVE);\n```\n\nAvailable since OTP 23.0","ref":"ei_connect.html#ei_xconnect_host_port"},{"type":"extras","title":"ei_connect_init() - ei_connect","doc":"","ref":"ei_connect.html#ei_connect_init"},{"type":"extras","title":"ei_connect_init_ussi() - ei_connect","doc":"Available since OTP 21.3","ref":"ei_connect.html#ei_connect_init_ussi"},{"type":"extras","title":"ei_connect_xinit() - ei_connect","doc":"","ref":"ei_connect.html#ei_connect_xinit"},{"type":"extras","title":"ei_connect_xinit_ussi() - ei_connect","doc":"```c\nint ei_connect_init(ei_cnode* ec, const char* this_node_name, const char *cookie, unsigned creation);\n```\n\n```c\nint ei_connect_init_ussi(ei_cnode* ec, const char* this_node_name, const char *cookie,\n  unsigned creation, ei_socket_callbacks *cbs, int cbs_sz, void *setup_context);\n```\n\n```c\nint ei_connect_xinit(ei_cnode* ec, const char *thishostname, const char *thisalivename,\n  const char *thisnodename, Erl_IpAddr thisipaddr, const char *cookie, unsigned creation);\n```\n\n```c\nint ei_connect_xinit_ussi(ei_cnode* ec, const char *thishostname, const char *thisalivename,\n  const char *thisnodename, Erl_IpAddr thisipaddr, const char *cookie, unsigned creation,\n  ei_socket_callbacks *cbs, int cbs_sz, void *setup_context);\n```\n\nInitializes the `ec` structure, to identify the node name and cookie of the\nserver. One of them must be called before other functions that works on the\n`ei_cnode` type or a file descriptor associated with a connection to another\nnode is used.\n\n- `ec` is a structure containing information about the C-node. It is used in\n  other `ei` functions for connecting and receiving data.\n- `this_node_name` is the name of the C-node (the name before '@' in the full\n  node name).\n- `cookie` is the cookie for the node.\n- `creation` identifies a specific instance of a C-node. It can help prevent the\n  node from receiving messages sent to an earlier process with the same\n  registered name.\n\n  > #### Note {: .info }\n  >\n  > The type of the `creation` argument was changed from `short` (16 bit) to\n  > `unsigned int` (32 bit) in OTP 25. This should cause no practical problem\n  > other than maybe a compiler warning.\n\n- `thishostname` is the name of the machine we are running on. If long names are\n  to be used, they are to be fully qualified (that is, `durin.erix.ericsson.se`\n  instead of `durin`).\n- `thisalivename` is the name of the local C-node (the name before '@' in the\n  full node name). Can be `NULL` (from OTP 23) to get a dynamically assigned\n  name from the peer node.\n- `thisnodename` is the full name of the local C-node, that is, `mynode@myhost`.\n  Can be `NULL` if `thisalivename` is `NULL`.\n- `thispaddr` if the IP address of the host.\n- `cbs` is a pointer to a\n  [callback structure](ei_connect.md#ei_socket_callbacks) implementing and\n  alternative socket interface.\n- `cbs_sz` is the size of the structure pointed to by `cbs`.\n- `setup_context` is a pointer to a structure that will be passed as second\n  argument to the `socket` callback in the `cbs` structure.\n\nA C-node acting as a server is assigned a creation number when it calls\n`ei_publish()`.\n\nA connection is closed by simply closing the socket. For information about how\nto close the socket gracefully (when there are outgoing packets before close),\nsee the relevant system documentation.\n\nThese functions return a negative value indicating that an error occurred.\n\n_Example 1:_\n\n```c\nunsigned n = 0;\nstruct in_addr addr;\nei_cnode ec;\naddr.s_addr = inet_addr(\"150.236.14.75\");\nif (ei_connect_xinit(&ec,\n                     \"chivas\",\n                     \"madonna\",\n                     \"madonna@chivas.du.etx.ericsson.se\",\n                     &addr;\n                     \"cookie...\",\n                     n++) < 0) {\n    fprintf(stderr,\"ERROR when initializing: %d\",erl_errno);\n    exit(-1);\n}\n```\n\n_Example 2:_\n\n```c\nif (ei_connect_init(&ec, \"madonna\", \"cookie...\", n++) < 0) {\n    fprintf(stderr,\"ERROR when initializing: %d\",erl_errno);\n    exit(-1);\n}\n```\n\nAvailable since OTP 21.3","ref":"ei_connect.html#ei_connect_xinit_ussi"},{"type":"extras","title":"ei_connect_tmo() - ei_connect","doc":"","ref":"ei_connect.html#ei_connect_tmo"},{"type":"extras","title":"ei_xconnect_tmo() - ei_connect","doc":"","ref":"ei_connect.html#ei_xconnect_tmo"},{"type":"extras","title":"ei_connect_host_port_tmo() - ei_connect","doc":"Available since OTP 23.0","ref":"ei_connect.html#ei_connect_host_port_tmo"},{"type":"extras","title":"ei_xconnect_host_port_tmo() - ei_connect","doc":"```c\nint ei_connect_tmo(ei_cnode* ec, char *nodename, unsigned timeout_ms);\n```\n\n```c\nint ei_xconnect_tmo(ei_cnode* ec, Erl_IpAddr adr, char *alivename, unsigned timeout_ms);\n```\n\n```c\nint ei_connect_host_port_tmo(ei_cnode* ec, char *hostname, int port, unsigned ms);\n```\n\n```c\nint ei_xconnect_host_port_tmo(ei_cnode* ec, Erl_IpAddr adr, int port, unsigned ms);\n```\n\nEquivalent to `ei_connect`, `ei_xconnect`, `ei_connect_host_port` and\n`ei_xconnect_host_port` with an optional time-out argument, see the description\nat the beginning of this manual page.\n\nAvailable since OTP 23.0","ref":"ei_connect.html#ei_xconnect_host_port_tmo"},{"type":"extras","title":"ei_get_tracelevel() - ei_connect","doc":"Available since OTP R13B04","ref":"ei_connect.html#ei_get_tracelevel"},{"type":"extras","title":"ei_set_tracelevel() - ei_connect","doc":"```c\nint ei_get_tracelevel(void);\n```\n\n```c\nvoid ei_set_tracelevel(int level);\n```\n\nUsed to set tracing on the distribution. The levels are different verbosity\nlevels. A higher level means more information. See also section\n[Debug Information](ei_connect.md#debug_information).\n\nThese functions are not thread safe.\n\nAvailable since OTP R13B04","ref":"ei_connect.html#ei_set_tracelevel"},{"type":"extras","title":"ei_listen() - ei_connect","doc":"Available since OTP 21.3","ref":"ei_connect.html#ei_listen"},{"type":"extras","title":"ei_xlisten() - ei_connect","doc":"```c\nint ei_listen(ei_cnode *ec, int *port, int backlog);\n```\n\n```c\nint ei_xlisten(ei_cnode *ec, Erl_IpAddr adr, int *port, int backlog);\n```\n\nUsed by a server process to setup a listen socket which later can be used for\naccepting connections from client processes.\n\n- `ec` is the C-node structure.\n- `adr` is local interface to bind to.\n- `port` is a pointer to an integer containing the port number to bind to. If\n  `*port` equals `0` when calling `ei_listen()`, the socket will be bound to an\n  ephemeral port. On success, `ei_listen()` will update the value of `*port` to\n  the port actually bound to.\n- `backlog` is maximum backlog of pending connections.\n\n`ei_listen` will create a socket, bind to a port on the local interface\nidentified by `adr` (or all local interfaces if `ei_listen()` is called), and\nmark the socket as a passive socket (that is, a socket that will be used for\naccepting incoming connections).\n\nOn success, a file descriptor is returned which can be used in a call to\n`ei_accept()`. On failure, `ERL_ERROR` is returned and `erl_errno` is set to\n`EIO`.\n\nAvailable since OTP 21.3","ref":"ei_connect.html#ei_xlisten"},{"type":"extras","title":"ei_make_pid() - ei_connect","doc":"```c\nint ei_make_pid(ei_cnode *ec, erlang_pid *pid);\n```\n\nCreates a new process identifier in the argument `pid`. This process identifier\nrefers to a conseptual process residing on the C-node identified by the argument\n`ec`. On success `0` is returned. On failure `ERL_ERROR` is returned and\n`erl_errno` is set.\n\nThe C-node identified by `ec` must have been initialized and must have received\na name prior to the call to `ei_make_pid()`. Initialization of the C-node is\ndone by a call to [`ei_connect_init()`](ei_connect.md#ei_connect_init) or\nfriends. If the name is dynamically assigned from the peer node, the C-node also\nhas to be connected.\n\nAvailable since OTP 23.0","ref":"ei_connect.html#ei_make_pid"},{"type":"extras","title":"ei_make_ref() - ei_connect","doc":"```c\nint ei_make_ref(ei_cnode *ec, erlang_ref *ref);\n```\n\nCreates a new reference in the argument `ref`. This reference originates from\nthe C-node identified by the argument `ec`. On success `0` is returned. On\nfailure `ERL_ERROR` is returned and `erl_errno` is set.\n\nThe C-node identified by `ec` must have been initialized and must have received\na name prior to the call to `ei_make_ref()`. Initialization of the C-node is\ndone by a call to [`ei_connect_init()`](ei_connect.md#ei_connect_init) or\nfriends. If the name is dynamically assigned from the peer node, the C-node also\nhas to be connected.\n\nAvailable since OTP 23.0","ref":"ei_connect.html#ei_make_ref"},{"type":"extras","title":"ei_publish() - ei_connect","doc":"```c\nint ei_publish(ei_cnode *ec, int port);\n```\n\nUsed by a server process to register with the local name server EPMD, thereby\nallowing other processes to send messages by using the registered name. Before\ncalling either of these functions, the process should have called `bind()` and\n`listen()` on an open socket.\n\n- `ec` is the C-node structure.\n- `port` is the local name to register, and is to be the same as the port number\n  that was previously bound to the socket.\n- `addr` is the 32-bit IP address of the local host.\n\nTo unregister with EPMD, simply close the returned descriptor. Do not use\n`ei_unpublish()`, which is deprecated anyway.\n\nOn success, the function returns a descriptor connecting the calling process to\nEPMD. On failure, `-1` is returned and `erl_errno` is set to `EIO`.\n\nAlso, `errno` values from `socket(2)` and `connect(2)` system calls may be\npropagated into `erl_errno`.","ref":"ei_connect.html#ei_publish"},{"type":"extras","title":"ei_publish_tmo() - ei_connect","doc":"```c\nint ei_publish_tmo(ei_cnode *ec, int port, unsigned timeout_ms);\n```\n\nEquivalent to `ei_publish` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_publish_tmo"},{"type":"extras","title":"ei_receive() - ei_connect","doc":"```c\nint ei_receive(int fd, unsigned char* bufp, int bufsize);\n```\n\nReceives a message consisting of a sequence of bytes in the Erlang external\nformat.\n\n- `fd` is an open descriptor to an Erlang connection. It is obtained from a\n  previous `ei_connect` or `ei_accept`.\n- `bufp` is a buffer large enough to hold the expected message.\n- `bufsize` indicates the size of `bufp`.\n\nIf a _tick_ occurs, that is, the Erlang node on the other end of the connection\nhas polled this node to see if it is still alive, the function returns\n`ERL_TICK` and no message is placed in the buffer. Also, `erl_errno` is set to\n`EAGAIN`.\n\nOn success, the message is placed in the specified buffer and the function\nreturns the number of bytes actually read. On failure, the function returns\n`ERL_ERROR` and sets `erl_errno` to one of the following:\n\n- **`EAGAIN`** - Temporary error: Try again.\n\n- **`EMSGSIZE`** - Buffer is too small.\n\n- **`EIO`** - I/O error.","ref":"ei_connect.html#ei_receive"},{"type":"extras","title":"ei_receive_encoded() - ei_connect","doc":"```c\nint ei_receive_encoded(int fd, char **mbufp, int *bufsz,  erlang_msg *msg, int *msglen);\n```\n\nThis function is retained for compatibility with code generated by the interface\ncompiler and with code following examples in the same application.\n\nIn essence, the function performs the same operation as `ei_xreceive_msg`, but\ninstead of using an `ei_x_buff`, the function expects a pointer to a character\npointer (`mbufp`), where the character pointer is to point to a memory area\nallocated by `malloc`. Argument `bufsz` is to be a pointer to an integer\ncontaining the exact size (in bytes) of the memory area. The function may\nreallocate the memory area and will in such cases put the new size in `*bufsz`\nand update `*mbufp`.\n\nReturns either `ERL_TICK` or the `msgtype` field of the `erlang_msg *msg`. The\nlength of the message is put in `*msglen`. On error a value `< 0` is returned.\n\nIt is recommended to use `ei_xreceive_msg` instead when possible, for the sake\nof readability. However, the function will be retained in the interface for\ncompatibility and will _not_ be removed in future releases without prior notice.","ref":"ei_connect.html#ei_receive_encoded"},{"type":"extras","title":"ei_receive_encoded_tmo() - ei_connect","doc":"```c\nint ei_receive_encoded_tmo(int fd, char **mbufp, int *bufsz,  erlang_msg *msg,\n  int *msglen, unsigned timeout_ms);\n```\n\nEquivalent to `ei_receive_encoded` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_receive_encoded_tmo"},{"type":"extras","title":"ei_receive_msg() - ei_connect","doc":"","ref":"ei_connect.html#ei_receive_msg"},{"type":"extras","title":"ei_xreceive_msg() - ei_connect","doc":"```c\nint ei_receive_msg(int fd, erlang_msg* msg, ei_x_buff* x);\n```\n\n```c\nint ei_xreceive_msg(int fd, erlang_msg* msg, ei_x_buff* x);\n```\n\nReceives a message to the buffer in `x`. `ei_xreceive_msg` allows the buffer in\n`x` to grow, but `ei_receive_msg` fails if the message is larger than the\npre-allocated buffer in `x`.\n\n- `fd` is an open descriptor to an Erlang connection.\n- `msg` is a pointer to an `erlang_msg` structure and contains information on\n  the message received.\n- `x` is buffer obtained from `ei_x_new`.\n\nOn success, the functions return `ERL_MSG` and the\n[`msg`](ei_connect.md#erlang_msg) struct is initialized.\n\n`msgtype` identifies the type of message, and is one of the following:\n\n- **`ERL_SEND`** - Indicates that an ordinary send operation has occurred.\n  `msg->to` contains the pid of the recipient (the C-node).\n\n- **`ERL_REG_SEND`** - A registered send operation occurred. `msg->from`\n  contains the pid of the sender.\n\n- **`ERL_LINK` or `ERL_UNLINK`** - `msg->to` and `msg->from` contain the pids of\n  the sender and recipient of the link or unlink.\n\n- **`ERL_EXIT`** - Indicates a broken link. `msg->to` and `msg->from` contain\n  the pids of the linked processes.\n\nThe return value is the same as for [`ei_receive`](ei_connect.md#ei_receive).","ref":"ei_connect.html#ei_xreceive_msg"},{"type":"extras","title":"ei_receive_msg_tmo() - ei_connect","doc":"","ref":"ei_connect.html#ei_receive_msg_tmo"},{"type":"extras","title":"ei_xreceive_msg_tmo() - ei_connect","doc":"```c\nint ei_receive_msg_tmo(int fd, erlang_msg* msg, ei_x_buff* x, unsigned imeout_ms);\n```\n\n```c\nint ei_xreceive_msg_tmo(int fd, erlang_msg* msg, ei_x_buff* x, unsigned timeout_ms);\n```\n\nEquivalent to `ei_receive_msg` and `ei_xreceive_msg` with an optional time-out\nargument, see the description at the beginning of this manual page.","ref":"ei_connect.html#ei_xreceive_msg_tmo"},{"type":"extras","title":"ei_receive_tmo() - ei_connect","doc":"```c\nint ei_receive_tmo(int fd, unsigned char* bufp, int bufsize, unsigned timeout_ms);\n```\n\nEquivalent to `ei_receive` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_receive_tmo"},{"type":"extras","title":"ei_reg_send() - ei_connect","doc":"```c\nint ei_reg_send(ei_cnode* ec, int fd, char* server_name, char* buf, int len);\n```\n\nSends an Erlang term to a registered process.\n\n- `fd` is an open descriptor to an Erlang connection.\n- `server_name` is the registered name of the intended recipient.\n- `buf` is the buffer containing the term in binary format.\n- `len` is the length of the message in bytes.\n\nReturns `0` if successful, otherwise `-1`. In the latter case it sets\n`erl_errno` to `EIO`.\n\n_Example:_\n\nSend the atom \"ok\" to the process \"worker\":\n\n```c\nei_x_buff x;\nei_x_new_with_version(&x);\nei_x_encode_atom(&x, \"ok\");\nif (ei_reg_send(&ec, fd, x.buff, x.index) < 0)\n    handle_error();\n```","ref":"ei_connect.html#ei_reg_send"},{"type":"extras","title":"ei_reg_send_tmo() - ei_connect","doc":"```c\nint ei_reg_send_tmo(ei_cnode* ec, int fd, char* server_name, char* buf, int len,\n  unsigned timeout_ms);\n```\n\nEquivalent to `ei_reg_send` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_reg_send_tmo"},{"type":"extras","title":"ei_rpc() - ei_connect","doc":"","ref":"ei_connect.html#ei_rpc"},{"type":"extras","title":"ei_rpc_to() - ei_connect","doc":"","ref":"ei_connect.html#ei_rpc_to"},{"type":"extras","title":"ei_xrpc_to() - ei_connect","doc":"Available since OTP 24.0","ref":"ei_connect.html#ei_xrpc_to"},{"type":"extras","title":"ei_rpc_from() - ei_connect","doc":"```c\nint ei_rpc(ei_cnode *ec, int fd, char *mod, char *fun, const char *argbuf,\n  int argbuflen, ei_x_buff *x);\n```\n\n```c\nint ei_rpc_to(ei_cnode *ec, int fd, char *mod, char *fun, const char *argbuf,\n  int argbuflen);\n```\n\n```c\nint ei_xrpc_to(ei_cnode *ec, int fd, char *mod, char *fun, const char *argbuf,\n  int argbuflen, int flags);\n```\n\n```c\nint ei_rpc_from(ei_cnode *ec, int fd, int timeout, erlang_msg *msg, ei_x_buff *x);\n```\n\nSupports calling Erlang functions on remote nodes. `ei_rpc_to()` sends an RPC\nrequest to a remote node and `ei_rpc_from()` receives the results of such a\ncall. `ei_rpc()` combines the functionality of these two functions by sending an\nRPC request and waiting for the results.\n\nThe `ei_xrpc_to()` function is equivalent to `ei_rpc_to()` when its `flags`\nparameter is set to `0`. When the flags parameter of `ei_xrpc_to()` is set to\n`EI_RPC_FETCH_STDOUT`, stdout (standard output) data are forwarded. See the\ndocumentation for the flags parameter for more information about the\n`EI_RPC_FETCH_STDOUT` flag.\n\nSee also `rpc:call/4` in Kernel.\n\n- **`ec`** is the C-node structure previously initiated by a call to\n  `ei_connect_init()` or `ei_connect_xinit()`.\n- **`fd`** is an open descriptor to an Erlang connection.\n- **`timeout`** is the maximum time (in milliseconds) to wait for results. Specify\n  `ERL_NO_TIMEOUT` to wait forever. `ei_rpc()` waits infinitely for the answer,\n  that is, the call will never time out.\n- **`mod`** is the name of the module containing the function to be run on the\n  remote node.\n- **`fun`** is the name of the function to run.\n- **`argbuf`** is a pointer to a buffer with an encoded Erlang list, without a\n  version magic number, containing the arguments to be passed to the function.\n- **`argbuflen`** is the length of the buffer containing the encoded Erlang list.\n- **`msg`** is structure of type `erlang_msg` and contains information on the\n  message received. For a description of the `erlang_msg` format, see\n  [`ei_receive_msg`](ei_connect.md#ei_receive_msg).\n- **`x`** points to the dynamic buffer that receives the result. For `ei_rpc()` this\n  is the result without the version magic number. For an `ei_rpc_from()` call\n  the result consists of a version magic number and a 2-tuple. The 2-tuple can\n  be in one of the following two forms:\n\n  - **`{rex,Reply}`** - This response value means that the RPC has completed.\n    The result value is the `Reply` term. This is the only type of response that\n    one can get from an RPC triggered by a call to `ei_rpc_to()` or\n    `ei_xrpc_to()` without the `EI_RPC_FETCH_STDOUT` flag. If the RPC was\n    triggered by a call to `ei_xrpc_to()` with the `EI_RPC_FETCH_STDOUT` flag\n    set, then all forwarded stdout data has been received.\n\n  - **`{rex_stdout,StdOutUTF8Binary}`** - This response value can only be\n    obtained if the RPC call was triggered by a call to `ei_xrpc_to()` with the\n    `EI_RPC_FETCH_STDOUT` flag set. This response value means that forwarded\n    stdout data has been received. The stdout data is stored in a binary and is\n    UTF-8 encoded. One may need to call `ei_rpc_from()` multiple times to read\n    all the stdout data. The stdout data is received in the same order as it was\n    written. All forwarded stdout data have been received when a `{rex,Reply}`\n    tuple has been obtained from an `ei_rpc_from()` call.\n\n- **`flags`** The flag `EI_RPC_FETCH_STDOUT` is currently the only flag that is\n  supported by `ei_xrpc_to()`. When `EI_RPC_FETCH_STDOUT` is set, the called\n  function is executed in a new process with a\n  [group leader](`erlang:group_leader/0`) that forwards all stdout data. This\n  means that stdout data that are written during the execution of the called\n  function, by the called function and by descendant processes, will be\n  forwarded (given that the group leader has not been changed by a call to\n  `erlang:group_leader/2`). The forwarded stdout data need to be collected by a\n  sequence of calls to `ei_rpc_from()`. See the description of the `x` parameter\n  for how `ei_rpc_from()` is used to receive stdout data. See the documentation\n  of the [the I/O protocol](`e:stdlib:io_protocol.md`), for more information\n  about the group leader concept.\n\n  > #### Note {: .info }\n  >\n  > The flag `EI_RPC_FETCH_STDOUT` only works when interacting with a node with\n  > a version greater or equal to OTP-24.\n\n`ei_rpc()` returns the number of bytes in the result on success and `-1` on\nfailure. `ei_rpc_from()` returns the number of bytes, otherwise one of\n`ERL_TICK`, `ERL_TIMEOUT`, and `ERL_ERROR`. The functions `ei_rpc_to()` and\n`ei_xrpc_to()` returns 0 if successful, otherwise -1. When failing, all four\nfunctions set `erl_errno` to one of the following:\n\n- **`EIO`** - I/O error.\n\n- **`ETIMEDOUT`** - Time-out expired.\n\n- **`EAGAIN`** - Temporary error: Try again.\n\n_Example:_\n\nCheck to see if an Erlang process is alive:\n\n```c\nint index = 0, is_alive;\nei_x_buff args, result;\n\nei_x_new(&result);\nei_x_new(&args);\nei_x_encode_list_header(&args, 1);\nei_x_encode_pid(&args, &check_pid);\nei_x_encode_empty_list(&args);\n\nif (ei_rpc(&ec, fd, \"erlang\", \"is_process_alive\",\n           args.buff, args.index, &result) < 0)\n    handle_error();\n\nif (ei_decode_version(result.buff, &index) < 0\n    || ei_decode_bool(result.buff, &index, &is_alive) < 0)\n    handle_error();\n```","ref":"ei_connect.html#ei_rpc_from"},{"type":"extras","title":"ei_self() - ei_connect","doc":"```c\nerlang_pid * ei_self(ei_cnode *ec);\n```\n\nRetrieves a generic pid of the C-node. Every C-node has a (pseudo) pid used in\n`ei_send_reg`, `ei_rpc()`, and others. This is contained in a field in the `ec`\nstructure. Do _not_ modify this structure.\n\nOn success a pointer to the process identifier is returned. On failure `NULL` is\nreturned and `erl_errno` is set.\n\nThe C-node identified by `ec` must have been initialized and must have received\na name prior to the call to `ei_self()`. Initialization of the C-node is done by\na call to [`ei_connect_init()`](ei_connect.md#ei_connect_init) or friends. If\nthe name is dynamically assigned from the peer node, the C-node also has to be\nconnected.","ref":"ei_connect.html#ei_self"},{"type":"extras","title":"ei_send() - ei_connect","doc":"```c\nint ei_send(int fd, erlang_pid* to, char* buf, int len);\n```\n\nSends an Erlang term to a process.\n\n- `fd` is an open descriptor to an Erlang connection.\n- `to` is the pid of the intended recipient of the message.\n- `buf` is the buffer containing the term in binary format.\n- `len` is the length of the message in bytes.\n\nReturns `0` if successful, otherwise `-1`. In the latter case it sets\n`erl_errno` to `EIO`.","ref":"ei_connect.html#ei_send"},{"type":"extras","title":"ei_send_encoded() - ei_connect","doc":"```c\nint ei_send_encoded(int fd, erlang_pid* to, char* buf, int len);\n```\n\nWorks exactly as `ei_send`, the alternative name is retained for backward\ncompatibility. The function will _not_ be removed without prior notice.","ref":"ei_connect.html#ei_send_encoded"},{"type":"extras","title":"ei_send_encoded_tmo() - ei_connect","doc":"```c\nint ei_send_encoded_tmo(int fd, erlang_pid* to, char* buf, int len, unsigned timeout_ms);\n```\n\nEquivalent to `ei_send_encoded` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_send_encoded_tmo"},{"type":"extras","title":"ei_send_reg_encoded() - ei_connect","doc":"```c\nint ei_send_reg_encoded(int fd, const erlang_pid *from, const char *to, const char *buf, int len);\n```\n\nThis function is retained for compatibility with code generated by the interface\ncompiler and with code following examples in the same application.\n\nThe function works as `ei_reg_send` with one exception. Instead of taking\n`ei_cnode` as first argument, it takes a second argument, an `erlang_pid`, which\nis to be the process identifier of the sending process (in the Erlang\ndistribution protocol).\n\nA suitable `erlang_pid` can be retrieved from the `ei_cnode` structure by\ncalling `ei_self(cnode_pointer)`.","ref":"ei_connect.html#ei_send_reg_encoded"},{"type":"extras","title":"ei_send_reg_encoded_tmo() - ei_connect","doc":"```c\nint ei_send_reg_encoded_tmo(int fd, const erlang_pid *from, const char *to, const char *buf,\n  int len, unsigned timeout_ms);\n```\n\nEquivalent to `ei_send_reg_encoded` with an optional time-out argument, see the\ndescription at the beginning of this manual page.","ref":"ei_connect.html#ei_send_reg_encoded_tmo"},{"type":"extras","title":"ei_send_tmo() - ei_connect","doc":"```c\nint ei_send_tmo(int fd, erlang_pid* to, char* buf, int len, unsigned timeout_ms);\n```\n\nEquivalent to `ei_send` with an optional time-out argument, see the description\nat the beginning of this manual page.","ref":"ei_connect.html#ei_send_tmo"},{"type":"extras","title":"ei_thisnodename() - ei_connect","doc":"","ref":"ei_connect.html#ei_thisnodename"},{"type":"extras","title":"ei_thishostname() - ei_connect","doc":"","ref":"ei_connect.html#ei_thishostname"},{"type":"extras","title":"ei_thisalivename() - ei_connect","doc":"```c\nconst char * ei_thisnodename(ei_cnode *ec);\n```\n\n```c\nconst char * ei_thishostname(ei_cnode *ec);\n```\n\n```c\nconst char * ei_thisalivename(ei_cnode *ec);\n```\n\nCan be used to retrieve information about the C-node. These values are initially\nset with `ei_connect_init()` or `ei_connect_xinit()`.\n\nThese function simply fetch the appropriate field from the `ec` structure. Read\nthe field directly will probably be safe for a long time, so these functions are\nnot really needed.","ref":"ei_connect.html#ei_thisalivename"},{"type":"extras","title":"ei_unpublish() - ei_connect","doc":"```c\nint ei_unpublish(ei_cnode *ec);\n```\n\nCan be called by a process to unregister a specified node from EPMD on the local\nhost. This is, however, usually not allowed, unless EPMD was started with flag\n`-relaxed_command_check`, which it normally is not.\n\nTo unregister a node you have published, you should close the descriptor that\nwas returned by `ei_publish()`.\n\n> #### Warning {: .warning }\n>\n> This function is deprecated and will be removed in a future release.\n\n`ec` is the node structure of the node to unregister.\n\nIf the node was successfully unregistered from EPMD, the function returns `0`.\nOtherwise, `-1` is returned and `erl_errno` is set to `EIO`.","ref":"ei_connect.html#ei_unpublish"},{"type":"extras","title":"ei_unpublish_tmo() - ei_connect","doc":"```c\nint ei_unpublish_tmo(ei_cnode *ec, unsigned timeout_ms);\n```\n\nEquivalent to `ei_unpublish` with an optional time-out argument, see the\ndescription at the beginning of this manual page.\n\n[](){: #debug_information }","ref":"ei_connect.html#ei_unpublish_tmo"},{"type":"extras","title":"Debug Information - ei_connect","doc":"If a connection attempt fails, the following can be checked:\n\n- `erl_errno`.\n- That the correct cookie was used\n- That EPMD is running\n- That the remote Erlang node on the other side is running the same version of\n  Erlang as the `ei` library\n- That environment variable `ERL_EPMD_PORT` is set correctly\n\nThe connection attempt can be traced by setting a trace level by either using\n`ei_set_tracelevel` or by setting environment variable `EI_TRACELEVEL`. The\ntrace levels have the following messages:\n\n- 1: Verbose error messages\n- 2: Above messages and verbose warning messages\n- 3: Above messages and progress reports for connection handling\n- 4: Above messages and progress reports for communication\n- 5: Above messages and progress reports for data conversion","ref":"ei_connect.html#debug-information"},{"type":"extras","title":"ei_global","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ei_global\n\nAccess globally registered names.","ref":"ei_global.html"},{"type":"extras","title":"Description - ei_global","doc":"This module provides support for registering, looking up, and unregistering\nnames in the `global` module. For more information, see\n[`kernel:global`](`m:global`).\n\nNotice that the functions below perform an RPC using an open file descriptor\nprovided by the caller. This file descriptor must not be used for other traffic\nduring the global operation, as the function can then receive unexpected data\nand fail.","ref":"ei_global.html#description"},{"type":"extras","title":"ei_global_names() - ei_global","doc":"```c\nchar **ei_global_names(ei_cnode *ec, int fd, int *count);\n```\n\nRetrieves a list of all known global names.\n\n- `ec` is the `ei_cnode` representing the current cnode.\n- `fd` is an open descriptor to an Erlang connection.\n- `count` is the address of an integer, or `NULL`. If `count` is not `NULL`, it\n  is set by the function to the number of names found.\n\nOn success, the function returns an array of strings, each containing a single\nregistered name, and sets `count` to the number of names found. The array is\nterminated by a single `NULL` pointer. On failure, the function returns `NULL`\nand `count` is not modified.\n\n> #### Note {: .info }\n>\n> It is the caller's responsibility to free the array afterwards. It has been\n> allocated by the function with a single call to `malloc()`, so a single\n> `free()` is all that is necessary.\n\nAvailable since OTP 23.0","ref":"ei_global.html#ei_global_names"},{"type":"extras","title":"ei_global_register() - ei_global","doc":"```c\nint ei_global_register(int fd, const char *name, erlang_pid *self);\n```\n\nRegisters a name in `global`.\n\n- `fd` is an open descriptor to an Erlang connection.\n- `name` is the name to register in `global`.\n- `pid` is the pid that is to be associated with `name`. This value is returned\n  by `global` when processes request the location of `name`.\n\nReturns `0` on success, otherwise `-1`.\n\nAvailable since OTP 23.0","ref":"ei_global.html#ei_global_register"},{"type":"extras","title":"ei_global_unregister() - ei_global","doc":"```c\nint ei_global_unregister(ei_cnode *ec, int fd, const char *name);\n```\n\nUnregisters a name from `global`.\n\n- `ec` is the `ei_cnode` representing the current cnode.\n- `fd` is an open descriptor to an Erlang connection.\n- `name` is the name to unregister from `global`.\n\nReturns `0` on success, otherwise `-1`.\n\nAvailable since OTP 23.0","ref":"ei_global.html#ei_global_unregister"},{"type":"extras","title":"ei_global_whereis() - ei_global","doc":"```c\nint ei_global_whereis(ei_cnode *ec, int fd, const char *name, erlang_pid* pid, char *node);\n```\n\nLooks up a name in `global`.\n\n- `ec` is the `ei_cnode` representing the current cnode.\n- `fd` is an open descriptor to an Erlang connection.\n- `name` is the name that is to be looked up in `global`.\n\nThe `pid` parameter is a pointer to a `erlang_pid` that the function will update\nwith the pid associated with the global name, if successful.\n\nIf `node` is not `NULL`, it is a pointer to a buffer where the function can fill\nin the name of the node where `name` is found. `node` can be passed directly to\n`ei_connect()` if necessary.\n\nOn success, the function returns 0, updates the `erlang_pid` pointed to by the\npid parameter, and the `node` parameter is initialized to the node name where\n`name` is found. On failure, a negative number is returned.\n\nAvailable since OTP 23.0","ref":"ei_global.html#ei_global_whereis"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}