 #    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

set current_version "4.0.4"

proc save_options {} {
	global current_version dvd_size env burning_device option_auto_refresh_space language option_eject_cd burn_speed
	#puts "saving ver $current_version and dvdsize $dvd_size"
	check_config_file_exist
	set config_file [open $env(HOME)/.tkdvd/config w]
	puts $config_file "version = $current_version"
	puts $config_file "dvd_size = $dvd_size"
	puts $config_file "option_auto_refresh_space = $option_auto_refresh_space"
	puts $config_file "language = $language"
	if { $option_eject_cd != "" } { puts $config_file "option_eject_cd = $option_eject_cd" }
	if { $burn_speed != "" } { puts $config_file "burn_speed = $burn_speed" }
	#when "create iso image" is selected, burning_device is equal to the path of the image and so it should not be saved
	if {![string compare -length 3 $burning_device "/dev"]} {
		puts $config_file "burning_device = $burning_device"
	} else {
		puts $config_file "burning_device = /dev/sr0"
	}
	close $config_file
}

proc load_options {} {
	global env current_version space_left_f dvd_size burning_device temp_burning_device option_auto_refresh_space language option_eject_cd burn_speed
	set string_temp ""
	check_config_file_exist
	set config_file [open $env(HOME)/.tkdvd/config r]
	while { ! [eof $config_file] } {
		gets $config_file string_temp
		if { [lindex $string_temp 0] == "version" } {
			if {([lindex $string_temp end] != $current_version) } {
				#we need to update config file and check that there is no change that can break loading
				update_version_config_file [lindex $string_temp end]
			}
		}
		if {[lindex $string_temp 0] == "dvd_size"} {
			set dvd_size [lindex $string_temp end]
			#puts "dvd size found when loading settings: $dvd_size"
		}
		if {[lindex $string_temp 0] == "burning_device"} {
			set burning_device [lindex $string_temp end]
			set temp_burning_device "$burning_device"
		}
		if {[lindex $string_temp 0] == "option_auto_refresh_space"} {
			set option_auto_refresh_space [lindex $string_temp end]
		}
		if {[lindex $string_temp 0] == "language"} {
			set language [lindex $string_temp end]
		}
		if {[lindex $string_temp 0] == "option_eject_cd"} {
			set option_eject_cd [lindex $string_temp end]
		}
		if {[lindex $string_temp 0] == "burn_speed"} {
			set burn_speed [lindex $string_temp end]
		}
	}
	if { [eof $config_file] && (($dvd_size != "4589850") && ($dvd_size != "8300790") && ($dvd_size != "665600") && ($dvd_size != "716800") ) } {
		#puts "cant find dvd_size variable in config file, setting to default"
		set dvd_size "4589850"
	}
	#puts "found tkdvd config ver $config_version and dvdsize $dvd_size"

	close $config_file
}

proc check_config_file_exist {} {
	global env current_version
	if { ! [file exists "$env(HOME)/.tkdvd/config"] } {
		if { ! [file isdirectory "$env(HOME)/.tkdvd"] } {
			#puts "creating ~/.tkdvd"
			exec mkdir $env(HOME)/.tkdvd
		}
		if { ! [file exists "$env(HOME)/.tkdvd/config"] } {
			#puts "tkdvd config file doesnt exist, creating it"
			exec touch $env(HOME)/.tkdvd/config
		}
		save_options
		#set config_file [open $env(HOME)/.tkdvd/config w]
		#puts $config_file "version = $current_version"
		#puts $config_file "dvd_size = 4589850"
		#close $config_file
	}
}

proc update_version_config_file { old_version } {
	global current_version env dvd_size
	#puts "updating config file from $old_version to $current_version"
	#for updating, just load previous version options and call save_options proc
	if { $old_version == "2.8" } {
		set config_file [open $env(HOME)/.tkdvd/config r]
		set string_temp ""
		while {! [eof $config_file]} {
			gets $config_file string_temp
			#puts "$string_temp"
			if {[lindex $string_temp 0] == "dvd_size"} {
				set dvd_size [lindex $string_temp end]
			}
		}
		close $config_file
		save_options
	} else {
		#no special change for later versions so we load option classically
	}
}