/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Win32UserInfo {
    private static final int DOMAIN_ALIAS_RID_ADMINS = 544;
    private static final int DOMAIN_ALIAS_RID_POWER_USERS = 547;
    public static final int ELEVATION_TYPE_NOT_APPLICABLE = 0;
    public static final int ELEVATION_TYPE_DEFAULT = 1;
    public static final int ELEVATION_TYPE_FULL = 2;
    public static final int ELEVATION_TYPE_LIMITED = 3;
    public static final int USER_CREATION_SUCCESS = 0;
    public static final int USER_CREATION_COULD_NOT_INITIALIZE = 1;
    public static final int USER_CREATION_OTHER_ERROR = 2;
    public static final int NERR_GROUP_NOT_FOUND = 2220;
    public static final int NERR_USER_NOT_FOUND = 2221;
    public static final int NERR_GROUP_EXISTS = 2223;
    public static final int NERR_USER_EXISTS = 2224;
    public static final int NERR_PASSWORD_TOO_SHORT = 2245;
    public static final int NERR_NOT_PRIMARY = 2226;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_ALIAS_EXISTS = 1379;
    public static final String RIGHT_SERVICE_LOGON = "SeServiceLogonRight";
    public static final int SW_HIDE = 0;
    public static final int SW_SHOWNORMAL = 1;

    private static native boolean isMemberOfGroup0(int var0);

    private static native boolean executeElevated0(String var0, String var1, String var2, int var3);

    private static native int getElevationType0();

    private static native String addUser0(String var0, String var1, String var2, String var3, String var4, boolean var5, boolean var6);

    private static native int deleteUser0(String var0, String var1);

    private static native int deleteLocalGroup0(String var0, String var1);

    private static native String getAccountName0(String var0, boolean var1);

    private static native String getUserProfileDirectory0(String var0, String var1);

    private static native String getUserSid0();

    private static native boolean setLsaAccountRight0(String var0, String var1, boolean var2);

    public static boolean setLsaAccountRight(String string, String string2, boolean bl) {
        if (!InstallerUtil.isAtLeastWindowsXP()) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException("name required");
        }
        if (bl && (string2 == null || string2.trim().length() == 0)) {
            throw new IllegalArgumentException("rightName required");
        }
        return Win32UserInfo.setLsaAccountRight0(string, string2, bl);
    }

    public static String getAccountName(String string) {
        return Win32UserInfo.getAccountName(string, false);
    }

    public static String getAccountName(String string, boolean bl) {
        if (!InstallerUtil.isWindows()) {
            return null;
        }
        String string2 = Win32UserInfo.getAccountName0(string, bl);
        if (string2 != null && string2.startsWith(" ")) {
            return null;
        }
        return string2;
    }

    public static String getUserProfileDirectory(String string, String string2) {
        if (!InstallerUtil.isAtLeastWindows2000()) {
            return null;
        }
        String string3 = Win32UserInfo.getUserProfileDirectory0(string, string2);
        if (string3 != null && string3.startsWith(" ")) {
            return null;
        }
        return string3;
    }

    public static boolean isUACDisabled() {
        if (!InstallerUtil.isAtLeastWindowsVista()) {
            return false;
        }
        Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Policies\\System", "EnableLUA");
        return object instanceof Integer && (Integer)object == 0;
    }

    public static boolean deleteUser(String string) {
        if (!InstallerUtil.isAtLeastWindowsXP()) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException("name required");
        }
        Integer n = (Integer)ContextImpl.runElevatedInt(new DeleteRemoteCallable(string, false), true);
        return n != null && (n == 0 || n == 2221);
    }

    private static int printInt(int n) {
        System.out.println(n);
        return n;
    }

    public static boolean deleteLocalGroup(String string) {
        if (!InstallerUtil.isAtLeastWindowsXP()) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException("name required");
        }
        Integer n = (Integer)ContextImpl.runElevatedInt(new DeleteRemoteCallable(string, true), true);
        return n != null && (n == 0 || n == 2220);
    }

    public static Result addUser(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        if (!InstallerUtil.isAtLeastWindowsXP()) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException("name required");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password required");
        }
        String string6 = (String)((Object)ContextImpl.runElevatedInt(new AddUserRemoteCallable(string, string2, string3, string4, string5, bl, bl2), true));
        if (string6 == null) {
            return new Result(1, null, null, false);
        }
        if (string6.startsWith("S")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
            String string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            String string8 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            boolean bl3 = stringTokenizer.hasMoreTokens() && Boolean.valueOf(stringTokenizer.nextToken()) != false;
            return new Result(0, string7, string8, bl3);
        }
        int n = 2;
        StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        return new Result(n, string6);
    }

    public static boolean isAdminUser() {
        return Win32UserInfo.isMemberOfGroup0(544);
    }

    public static boolean isPowerUser() {
        return Win32UserInfo.isMemberOfGroup0(547);
    }

    public static boolean isAtLeastPowerUser() {
        return Win32UserInfo.isPowerUser() || Win32UserInfo.isAdminUser();
    }

    public static String getUserSid() {
        if (!InstallerUtil.isAtLeastWindows2000()) {
            return null;
        }
        return Win32UserInfo.getUserSid0();
    }

    public static boolean executeElevated(String string, String string2, String string3) {
        return Win32UserInfo.executeElevated(string, string2, string3, 1);
    }

    public static boolean executeElevated(String string, String string2, String string3, int n) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        return Win32UserInfo.executeElevated0(string, string2 == null ? "" : string2, string3, n);
    }

    public static int getElevationType() {
        if (!Util.isAtLeastWindowsVista()) {
            return 0;
        }
        return Win32UserInfo.getElevationType0();
    }

    public static void main(String[] stringArray) {
        System.out.println(Win32UserInfo.getUserSid0());
        System.out.println(Win32UserInfo.getAccountName(Win32UserInfo.getUserSid0()));
    }

    static {
        Common.init();
    }

    private static class AddUserRemoteCallable
    extends AbstractRemoteCallable {
        String name;
        String password;
        String comment;
        String localGroupName;
        String localGroupComment;
        boolean createGroup;
        boolean failIfGroupExists;

        private AddUserRemoteCallable(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
            this.name = string;
            this.password = string2;
            this.comment = string3;
            this.localGroupName = string4;
            this.localGroupComment = string5;
            this.createGroup = bl;
            this.failIfGroupExists = bl2;
        }

        public Serializable execute() {
            return Win32UserInfo.addUser0(this.name, this.password, this.comment, this.localGroupName, this.localGroupComment, this.createGroup, this.failIfGroupExists);
        }
    }

    private static class DeleteRemoteCallable
    extends AbstractRemoteCallable {
        String name;
        boolean group;

        private DeleteRemoteCallable(String string, boolean bl) {
            this.name = string;
            this.group = bl;
        }

        public Serializable execute() {
            String string = null;
            int n = this.name.indexOf(92);
            if (n > -1) {
                string = this.name.substring(0, n);
                this.name = this.name.substring(n + 1);
            }
            Win32UserInfo.setLsaAccountRight(this.name, null, false);
            return new Integer(this.group ? Win32UserInfo.deleteLocalGroup0(string, this.name) : Win32UserInfo.deleteUser0(string, this.name));
        }
    }

    public static class Result {
        private int errorCode = 0;
        private String rawResult;
        private String userSid;
        private String groupSid;
        private boolean groupCreated;

        public Result(int n, String string, String string2, boolean bl) {
            this.errorCode = n;
            this.userSid = string;
            this.groupSid = string2;
            this.groupCreated = bl;
        }

        public Result(int n, String string) {
            this.errorCode = n;
            this.rawResult = string;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getRawResult() {
            return this.rawResult;
        }

        public String getUserSid() {
            return this.userSid;
        }

        public String getGroupSid() {
            return this.groupSid;
        }

        public boolean isGroupCreated() {
            return this.groupCreated;
        }

        public String toString() {
            return "Result{errorCode=" + this.errorCode + ", userSid='" + this.userSid + '\'' + ", groupSid='" + this.groupSid + '\'' + ", groupCreated=" + this.groupCreated + '}';
        }
    }
}

