/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FolderInfo {
    public static final int DRIVE_UNKNOWN = 0;
    public static final int DRIVE_NO_ROOT_DIR = 1;
    public static final int DRIVE_REMOVABLE = 2;
    public static final int DRIVE_FIXED = 3;
    public static final int DRIVE_REMOTE = 4;
    public static final int DRIVE_CDROM = 5;
    public static final int DRIVE_RAMDISK = 6;
    public static final int FOLDER_DESKTOP = 1;
    public static final int FOLDER_STARTMENU = 2;
    public static final int FOLDER_PROGRAMS = 3;
    public static final int FOLDER_STARTUP = 4;
    public static final int FOLDER_SENDTO = 5;
    public static final int FOLDER_FONTS = 6;
    public static final int FOLDER_APPDATA = 7;
    public static final int FOLDER_DOCS = 8;
    public static final int FOLDER_TEMPLATES = 9;
    public static final int FOLDER_FAVORITES = 10;
    public static final int FOLDER_LOCAL_APPDATA = 11;
    private static final String PROGRAM_FILES_DIR_NAME = "ProgramFilesDir";
    private static final String COMMON_FILES_DIR_NAME = "CommonFilesDir";
    private static Map originalUserFolderCache;

    private static native String getSpecialFolder0(int var0, boolean var1);

    private static native String getPathFromRegistry0(String var0);

    private static native String getWindowsDirectory0();

    private static native String getSystemDirectory0();

    private static native int getDriveType0(String var0);

    private static native String getShortPathName0(String var0);

    public static int getDriveType(String string) {
        if (!Util.isWindows()) {
            return 0;
        }
        return FolderInfo.getDriveType0(string);
    }

    public static String getShortPathName(String string) {
        if (!Util.isWindows()) {
            return string;
        }
        return FolderInfo.getShortPathName0(string);
    }

    public static File getSpecialFolder(final int n, boolean bl) {
        Object object;
        if (!Util.isWindows()) {
            return null;
        }
        if (!bl && HelperCommunication.getInstance().isElevatedHelper()) {
            object = (File)originalUserFolderCache.get(new Integer(n));
            if (object == null) {
                object = (File)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

                    protected Object fetchValue(Context context) throws Exception {
                        return FolderInfo.getSpecialFolder(n, false);
                    }
                });
                originalUserFolderCache.put(new Integer(n), object);
            }
            if (object != null) {
                return object;
            }
        }
        if ((object = FolderInfo.getSpecialFolder0(n, bl)) == null) {
            boolean bl2 = bl = !bl;
            if (InstallerUtil.isWindows9X() || !Win32UserInfo.isAdminUser()) {
                bl = false;
            }
            object = FolderInfo.getSpecialFolder0(n, bl);
        }
        return object == null ? null : new File((String)object);
    }

    public static File getProgramFilesDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getPathFromRegistry0(PROGRAM_FILES_DIR_NAME));
    }

    public static File getCommonFilesDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getPathFromRegistry0(COMMON_FILES_DIR_NAME));
    }

    public static File getWindowsDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getWindowsDirectory0());
    }

    public static File getSystemDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return new File(FolderInfo.getSystemDirectory0());
    }

    public static File getProgramDataDirectory() {
        if (!Util.isWindows()) {
            return null;
        }
        return FolderInfo.getSpecialFolder(7, true);
    }

    static {
        Common.init();
        originalUserFolderCache = new HashMap();
    }
}

