/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.helper.content.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class PartialFileInputStream
extends InputStream {
    private CountingInputStream in;
    private long size;

    protected PartialFileInputStream(File file, long l, long l2) throws IOException {
        this.size = l2;
        this.in = new CountingInputStream(new FileInputStream(file));
        this.fullySkip(l);
        this.in.resetCount();
    }

    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        long l = this.getReadLength(n2);
        if (l == 0L && n2 > 0) {
            return -1;
        }
        return this.in.read(byArray, n, (int)l);
    }

    public long skip(long l) throws IOException {
        return this.in.skip(this.getReadLength(l));
    }

    public int available() throws IOException {
        return (int)this.getReadLength(this.in.available());
    }

    private long getReadLength(long l) {
        return Math.min(this.getRestLength(), l);
    }

    private boolean isEOF() {
        return this.getRestLength() <= 0L;
    }

    private long getRestLength() {
        return this.size - this.in.getCount();
    }

    private void fullySkip(long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l && (l3 = this.in.skip(l - l2)) > 0L; l2 += l3) {
        }
        if (l2 < l) {
            throw new IOException("could not seek pos " + l);
        }
    }
}

