/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class AbstractLabelComponent
extends AbstractFormComponent {
    private String labelText = "";
    private ExternalFile labelIconFile = null;
    private int iconTextGap = 4;
    private Color labelColor = null;
    private Font labelFont = null;
    private JLabel label;

    public static Font translateFont(Font font, JComponent jComponent) {
        if (font.getSize() == 0) {
            return font.deriveFont((float)jComponent.getFont().getSize());
        }
        return font;
    }

    public String getLabelText() {
        return AbstractLabelComponent.replaceVariables(this.labelText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setLabelText(String string) {
        this.labelText = string;
    }

    public ExternalFile getLabelIconFile() {
        return this.labelIconFile;
    }

    public void setLabelIconFile(ExternalFile externalFile) {
        this.labelIconFile = externalFile;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int n) {
        this.iconTextGap = n;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public void initialize() {
        super.initialize();
        if (this.labelText.trim().length() > 0) {
            this.initializeLabel(this.label);
        }
    }

    protected JLabel createLabel() {
        this.label = this.createLabel(this.labelIconFile, this.iconTextGap, this.labelColor, this.labelFont);
        return this.label;
    }

    protected JLabel createLabel(ExternalFile externalFile, int n, Color color, Font font) {
        File file;
        JLabel jLabel = new JLabel();
        if (externalFile != null && (file = this.getContext().getExternalFile(externalFile, false)).exists()) {
            try {
                jLabel.setIcon(new ImageIcon(file.getPath()));
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
            }
        }
        jLabel.setIconTextGap(n);
        if (color != null) {
            jLabel.setForeground(color);
        }
        if (font != null) {
            jLabel.setFont(AbstractLabelComponent.translateFont(font, jLabel));
        }
        if (this.labelText.trim().length() > 0) {
            this.initializeLabel(jLabel);
        }
        return jLabel;
    }

    protected void initializeLabel(JLabel jLabel) {
        String string = this.getLabelText();
        String string2 = AbstractLabelComponent.getTextWithoutMnemonics(string);
        jLabel.setText(string2);
        int n = AbstractLabelComponent.getMnemonicCharIndex(string);
        if (n > -1) {
            jLabel.setDisplayedMnemonic(string2.charAt(n));
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    protected JLabel getLabel() {
        return this.label;
    }
}

