// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListClusterPartitionsReader is a Reader for the ListClusterPartitions structure.
type ListClusterPartitionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListClusterPartitionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListClusterPartitionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListClusterPartitionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListClusterPartitionsOK creates a ListClusterPartitionsOK with default headers values
func NewListClusterPartitionsOK() *ListClusterPartitionsOK {
	return &ListClusterPartitionsOK{}
}

/*
ListClusterPartitionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListClusterPartitionsOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215ListClusterPartitionsResponse
}

// IsSuccess returns true when this list cluster partitions o k response has a 2xx status code
func (o *ListClusterPartitionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list cluster partitions o k response has a 3xx status code
func (o *ListClusterPartitionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list cluster partitions o k response has a 4xx status code
func (o *ListClusterPartitionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list cluster partitions o k response has a 5xx status code
func (o *ListClusterPartitionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list cluster partitions o k response a status code equal to that given
func (o *ListClusterPartitionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list cluster partitions o k response
func (o *ListClusterPartitionsOK) Code() int {
	return 200
}

func (o *ListClusterPartitionsOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/partitions][%d] listClusterPartitionsOK  %+v", 200, o.Payload)
}

func (o *ListClusterPartitionsOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/partitions][%d] listClusterPartitionsOK  %+v", 200, o.Payload)
}

func (o *ListClusterPartitionsOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215ListClusterPartitionsResponse {
	return o.Payload
}

func (o *ListClusterPartitionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215ListClusterPartitionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListClusterPartitionsDefault creates a ListClusterPartitionsDefault with default headers values
func NewListClusterPartitionsDefault(code int) *ListClusterPartitionsDefault {
	return &ListClusterPartitionsDefault{
		_statusCode: code,
	}
}

/*
ListClusterPartitionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListClusterPartitionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list cluster partitions default response has a 2xx status code
func (o *ListClusterPartitionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list cluster partitions default response has a 3xx status code
func (o *ListClusterPartitionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list cluster partitions default response has a 4xx status code
func (o *ListClusterPartitionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list cluster partitions default response has a 5xx status code
func (o *ListClusterPartitionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list cluster partitions default response a status code equal to that given
func (o *ListClusterPartitionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list cluster partitions default response
func (o *ListClusterPartitionsDefault) Code() int {
	return o._statusCode
}

func (o *ListClusterPartitionsDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/partitions][%d] ListClusterPartitions default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterPartitionsDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{id}/partitions][%d] ListClusterPartitions default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterPartitionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListClusterPartitionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
