/*
 * Decompiled with CFR 0.152.
 */
package jflex.generator;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import jflex.base.Pair;
import jflex.core.AbstractLexScan;
import jflex.core.Action;
import jflex.core.EOFActions;
import jflex.core.LexParse;
import jflex.core.LexScan;
import jflex.core.unicode.CharClasses;
import jflex.dfa.DFA;
import jflex.exceptions.GeneratorException;
import jflex.generator.CountEmitter;
import jflex.generator.HiLowEmitter;
import jflex.io.FileUtils;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.skeleton.Skeleton;

public final class Emitter {
    private static final int FINAL = 1;
    private static final int NOLOOK = 8;
    private final File inputFile;
    final String outputFileName;
    private final PrintWriter out;
    private final Skeleton skel;
    private final AbstractLexScan scanner;
    private final LexParse parser;
    private final DFA dfa;
    private boolean[] isTransition;
    private int[] rowMap;
    private boolean[] rowKilled;
    private int numCols;
    private int[] colMap;
    private boolean[] colKilled;
    private final Map<Action, Integer> actionTable = new LinkedHashMap<Action, Integer>();
    private final String visibility;
    private String eofCode;
    private String eofThrow;

    Emitter(String outputFileName, File inputFile, LexParse parser, DFA dfa, PrintWriter writer) {
        this.outputFileName = outputFileName;
        this.out = writer;
        this.parser = parser;
        this.scanner = parser.scanner;
        this.visibility = this.scanner.visibility();
        this.inputFile = inputFile;
        this.dfa = dfa;
        this.skel = new Skeleton(this.out);
    }

    static String getBaseName(String className) {
        int gen = className.indexOf(60);
        if (gen < 0) {
            return className;
        }
        return className.substring(0, gen);
    }

    public static File normalize(String name, File input) {
        File outputFile = Options.getDir() == null ? (input == null || input.getParent() == null ? new File(name) : new File(input.getParent(), name)) : new File(Options.getDir(), name);
        if (outputFile.exists() && !Options.no_backup) {
            File backup = new File(outputFile.toString() + "~");
            if (backup.exists()) {
                backup.delete();
            }
            if (outputFile.renameTo(backup)) {
                Out.println("Old file \"" + outputFile + "\" saved as \"" + backup + "\"");
            } else {
                Out.println("Couldn't save old file \"" + outputFile + "\", overwriting!");
            }
        }
        return outputFile;
    }

    private void println() {
        this.out.println();
    }

    private void println(String line) {
        this.out.println(line);
    }

    private void println(int i) {
        this.out.println(i);
    }

    private void print(String line) {
        this.out.print(line);
    }

    private void print(int i) {
        this.out.print(i);
    }

    private void print(int i, int tab) {
        int exp = i < 0 ? 1 : 10;
        while (tab-- > 1) {
            if (Math.abs(i) < exp) {
                this.print(" ");
            }
            exp *= 10;
        }
        this.print(i);
    }

    private boolean hasGenLookAhead() {
        return this.dfa.lookaheadUsed();
    }

    private void emitLookBuffer() {
        if (!this.hasGenLookAhead()) {
            return;
        }
        this.println("  /** For the backwards DFA of general lookahead statements */");
        this.println("  private boolean [] zzFin = new boolean [Math.min(ZZ_BUFFERSIZE, zzMaxBufferLen())+1];");
        this.println();
    }

    private void emitScanError() {
        this.print("  private static void zzScanError(int errorCode)");
        if (this.scanner.scanErrorException() != null) {
            this.print(" throws " + this.scanner.scanErrorException());
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException() == null) {
            this.println("    throw new Error(message);");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException() + "(message);");
        }
        this.skel.emitNext();
        this.print("  " + this.visibility + " void yypushback(int number) ");
        if (this.scanner.scanErrorException() == null) {
            this.println(" {");
        } else {
            this.println(" throws " + this.scanner.scanErrorException + " {");
        }
    }

    private void emitMain(String functionName) {
        if (!(this.scanner.standalone() || this.scanner.debugOption() || this.scanner.cupDebug())) {
            return;
        }
        if (this.scanner.cupDebug()) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol());
            this.println("   */");
            this.println("  private static String getTokenName(int token) {");
            this.println("    try {");
            this.println("      java.lang.reflect.Field [] classFields = " + this.scanner.cupSymbol() + ".class.getFields();");
            this.println("      for (int i = 0; i < classFields.length; i++) {");
            this.println("        if (classFields[i].getInt(null) == token) {");
            this.println("          return classFields[i].getName();");
            this.println("        }");
            this.println("      }");
            this.println("    } catch (Exception e) {");
            this.println("      e.printStackTrace(System.err);");
            this.println("    }");
            this.println("");
            this.println("    return \"UNKNOWN TOKEN\";");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   */");
            if (this.scanner.cupCompatible() || this.scanner.cup2Compatible()) {
                this.print("  public ");
            } else {
                this.print("  " + this.visibility + " ");
            }
            if (this.scanner.tokenType() == null) {
                if (this.scanner.isInteger()) {
                    this.print("int");
                } else if (this.scanner.isIntWrap()) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType());
            }
            this.print(" debug_");
            this.print(functionName);
            this.print("() throws java.io.IOException");
            for (String thrown : this.scanner.lexThrow()) {
                this.print("\n    , ");
                this.print(thrown);
            }
            if (this.scanner.scanErrorException() != null) {
                this.print(", ");
                this.print(this.scanner.scanErrorException());
            }
            this.println(" {");
            this.println("    " + this.scanner.tokenType() + " s = " + functionName + "();");
            this.print("    System.out.println( ");
            if (this.scanner.lineCount()) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount()) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            if (this.scanner.charCount()) {
                this.print("\" char:\" + yychar + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s.sym) + \"--\");");
            this.println("    return s;");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone()) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        String className = Emitter.getBaseName(this.scanner.className());
        this.println("  public static void main(String[] argv) {");
        this.println("    if (argv.length == 0) {");
        this.println("      System.out.println(\"Usage : java " + className + " [ --encoding <name> ] <inputfile(s)>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      int firstFilePos = 0;");
        this.println("      String encodingName = \"UTF-8\";");
        this.println("      if (argv[0].equals(\"--encoding\")) {");
        this.println("        firstFilePos = 2;");
        this.println("        encodingName = argv[1];");
        this.println("        try {");
        this.println("          // Side-effect: is encodingName valid?");
        this.println("          java.nio.charset.Charset.forName(encodingName);");
        this.println("        } catch (Exception e) {");
        this.println("          System.out.println(\"Invalid encoding '\" + encodingName + \"'\");");
        this.println("          return;");
        this.println("        }");
        this.println("      }");
        this.println("      for (int i = firstFilePos; i < argv.length; i++) {");
        this.println("        " + className + " scanner = null;");
        this.println("        java.io.FileInputStream stream = null;");
        this.println("        java.io.Reader reader = null;");
        this.println("        try {");
        this.println("          stream = new java.io.FileInputStream(argv[i]);");
        this.println("          reader = new java.io.InputStreamReader(stream, encodingName);");
        this.println("          scanner = new " + className + "(reader);");
        if (this.scanner.standalone()) {
            this.println("          while ( !scanner.zzAtEOF ) scanner." + functionName + "();");
        } else if (this.scanner.cupDebug()) {
            this.println("          while ( !scanner.zzAtEOF ) scanner.debug_" + functionName + "();");
        } else {
            this.println("          do {");
            this.println("            System.out.println(scanner." + functionName + "());");
            this.println("          } while (!scanner.zzAtEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch (java.io.FileNotFoundException e) {");
        this.println("          System.out.println(\"File not found : \\\"\"+argv[i]+\"\\\"\");");
        this.println("        }");
        this.println("        catch (java.io.IOException e) {");
        this.println("          System.out.println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\");");
        this.println("          System.out.println(e);");
        this.println("        }");
        this.println("        catch (Exception e) {");
        this.println("          System.out.println(\"Unexpected exception:\");");
        this.println("          e.printStackTrace();");
        this.println("        }");
        this.println("        finally {");
        this.println("          if (reader != null) {");
        this.println("            try {");
        this.println("              reader.close();");
        this.println("            }");
        this.println("            catch (java.io.IOException e) {");
        this.println("              System.out.println(\"IO error closing file \\\"\"+argv[i]+\"\\\"\");");
        this.println("              System.out.println(e);");
        this.println("            }");
        this.println("          }");
        this.println("          if (stream != null) {");
        this.println("            try {");
        this.println("              stream.close();");
        this.println("            }");
        this.println("            catch (java.io.IOException e) {");
        this.println("              System.out.println(\"IO error closing file \\\"\"+argv[i]+\"\\\"\");");
        this.println("              System.out.println(e);");
        this.println("            }");
        this.println("          }");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    private void emitNoMatch() {
        this.println("            zzScanError(ZZ_NO_MATCH);");
    }

    private void emitNextInput() {
        this.println("          if (zzCurrentPosL < zzEndReadL) {");
        this.println("            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);");
        this.println("            zzCurrentPosL += Character.charCount(zzInput);");
        this.println("          }");
        this.println("          else if (zzAtEOF) {");
        this.println("            zzInput = YYEOF;");
        this.println("            break zzForAction;");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            zzCurrentPos  = zzCurrentPosL;");
        this.println("            zzMarkedPos   = zzMarkedPosL;");
        this.println("            boolean eof = zzRefill();");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            zzCurrentPosL  = zzCurrentPos;");
        this.println("            zzMarkedPosL   = zzMarkedPos;");
        this.println("            zzBufferL      = zzBuffer;");
        this.println("            zzEndReadL     = zzEndRead;");
        this.println("            if (eof) {");
        this.println("              zzInput = YYEOF;");
        this.println("              break zzForAction;");
        this.println("            }");
        this.println("            else {");
        this.println("              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);");
        this.println("              zzCurrentPosL += Character.charCount(zzInput);");
        this.println("            }");
        this.println("          }");
    }

    public static String sourceFileString(File file) {
        String path = FileUtils.getRelativePath(Options.getRootDirectory(), file);
        if (File.separatorChar == '\\') {
            path = FileUtils.slashify(path);
        }
        return path.replace("\\", "\\\\");
    }

    private void emitHeader() {
        this.println("// DO NOT EDIT");
        this.println("// Generated by JFlex 1.9.1 http://jflex.de/");
        this.println("// source: " + Emitter.sourceFileString(this.inputFile));
        this.println("");
    }

    private void emitUserCode() {
        this.println(this.scanner.userCode());
        if (this.scanner.cup2Compatible()) {
            this.println();
            this.println("/* CUP2 imports */");
            this.println("import edu.tum.cup2.scanner.*;");
            this.println("import edu.tum.cup2.grammar.*;");
            this.println();
        }
    }

    private void emitClassName() {
        if (!this.scanner.noSuppressWarnings()) {
            this.println("@SuppressWarnings(\"fallthrough\")");
        }
        if (this.scanner.isPublic()) {
            this.print("public ");
        }
        if (this.scanner.isAbstract()) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal()) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className());
        if (this.scanner.isExtending() != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending());
        }
        if (this.scanner.isImplementing() != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing());
        }
        this.println(" {");
    }

    private void emitLexicalStates() {
        int i;
        for (String name : this.scanner.stateNames()) {
            int num = this.scanner.getStateNumber(name);
            this.println("  " + this.visibility + " static final int " + name + " = " + 2 * num + ";");
        }
        this.println("");
        this.println("  /**");
        this.println("   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l");
        this.println("   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l");
        this.println("   *                  at the beginning of a line");
        this.println("   * l is of the form l = 2*k, k a non negative integer");
        this.println("   */");
        this.println("  private static final int ZZ_LEXSTATE[] = {");
        int j = 0;
        this.print("    ");
        for (i = 0; i < 2 * this.dfa.numLexStates() - 1; ++i) {
            this.print(this.dfa.entryState(i), 2);
            this.print(", ");
            if (++j < 16) continue;
            this.println();
            this.print("    ");
            j = 0;
        }
        this.println(this.dfa.entryState(i));
        this.println("  };");
    }

    private void emitDynamicInit() {
        int count = 0;
        int value = this.dfa.table(0, 0);
        this.println("  /**");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        CountEmitter e = CountEmitter.emitter(this.dfa.numStates(), 1, "trans");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates(); ++i) {
            if (this.rowKilled[i]) continue;
            for (int c = 0; c < this.dfa.numInput(); ++c) {
                if (this.colKilled[c]) continue;
                if (this.dfa.table(i, c) == value) {
                    ++count;
                    continue;
                }
                e.emit(count, value);
                count = 1;
                value = this.dfa.table(i, c);
            }
        }
        e.emit(count, value);
        e.emitUnpack();
        this.println(e.toString());
    }

    private void emitCharMapArrayUnPacked() {
        CharClasses cl = this.parser.getCharClasses();
        this.println("");
        this.println("  /**");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  private static final char [] ZZ_CMAP = {");
        int n = 0;
        this.print("    ");
        int max = cl.getMaxCharCode();
        for (int c = 0; c <= max; c = (int)((char)(c + 1))) {
            this.print(this.colMap[cl.getClassCode(c)], 2);
            if (c >= max) continue;
            this.print(", ");
            if (++n < 16) continue;
            this.println();
            this.print("    ");
            n = 0;
        }
        this.println();
        this.println("  };");
        this.println();
    }

    private void mapColMap(int[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.colMap[blocks[i]];
        }
    }

    private void emitCharMapTables() {
        CharClasses cl = this.parser.getCharClasses();
        if (cl.getMaxCharCode() < 256) {
            this.emitCharMapArrayUnPacked();
        } else {
            Pair<int[], int[]> tables = cl.getTables();
            this.mapColMap((int[])tables.snd);
            this.println("");
            this.println("  /**");
            this.println("   * Top-level table for translating characters to character classes");
            this.println("   */");
            CountEmitter e = new CountEmitter("cmap_top");
            e.emitInit();
            e.emitCountValueString((int[])tables.fst);
            e.emitUnpack();
            this.println(e.toString());
            this.println("");
            this.println("  /**");
            this.println("   * Second-level tables for translating characters to character classes");
            this.println("   */");
            e = new CountEmitter("cmap_blocks");
            e.emitInit();
            e.emitCountValueString((int[])tables.snd);
            e.emitUnpack();
            this.println(e.toString());
        }
    }

    private void emitRowMapArray() {
        this.println("");
        this.println("  /**");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        HiLowEmitter e = new HiLowEmitter("RowMap");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates(); ++i) {
            e.emit(this.rowMap[i] * this.numCols);
        }
        e.emitUnpack();
        this.println(e.toString());
    }

    private void emitAttributes() {
        this.println("  /**");
        this.println("   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}");
        this.println("   */");
        CountEmitter e = new CountEmitter("Attribute");
        e.emitInit();
        int count = 1;
        int value = 0;
        if (this.dfa.isFinal(0)) {
            value = 1;
        }
        if (!this.isTransition[0]) {
            value |= 8;
        }
        for (int i = 1; i < this.dfa.numStates(); ++i) {
            int attribute = 0;
            if (this.dfa.isFinal(i)) {
                attribute = 1;
            }
            if (!this.isTransition[i]) {
                attribute |= 8;
            }
            if (value == attribute) {
                ++count;
                continue;
            }
            e.emit(count, value);
            count = 1;
            value = attribute;
        }
        e.emit(count, value);
        e.emitUnpack();
        this.println(e.toString());
    }

    private void emitClassCode() {
        if (this.scanner.classCode() != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode());
        }
        if (this.scanner.cup2Compatible()) {
            this.println();
            this.println("  /* CUP2 code: */");
            this.println("  private <T> ScannerToken<T> token(Terminal terminal, T value) {");
            this.println("    return new ScannerToken<T>(terminal, value, yyline, yycolumn);");
            this.println("  }");
            this.println();
            this.println("  private ScannerToken<Object> token(Terminal terminal) {");
            this.println("    return new ScannerToken<Object>(terminal, yyline, yycolumn);");
            this.println("  }");
            this.println();
        }
    }

    private void emitConstructorDecl() {
        this.emitConstructorDecl(true);
        if ((this.scanner.standalone() || this.scanner.debugOption()) && this.scanner.ctorArgsCount() > 0) {
            Out.warning(ErrorMessages.CTOR_DEBUG);
            this.println();
            this.emitConstructorDecl(false);
        }
    }

    private void emitConstructorDecl(boolean printCtorArgs) {
        this.println("  /**");
        this.println("   * Creates a new scanner");
        this.println("   *");
        this.println("   * @param   in  the java.io.Reader to read input from.");
        this.println("   */");
        String warn = "// WARNING: this is a default constructor for debug/standalone only. Has no custom parameters or init code.";
        if (!printCtorArgs) {
            this.println(warn);
        }
        this.print("  ");
        if (this.scanner.isPublic()) {
            this.print("public ");
        }
        this.print(Emitter.getBaseName(this.scanner.className()));
        this.print("(java.io.Reader in");
        if (printCtorArgs) {
            this.emitCtorArgs();
        }
        this.print(")");
        if (this.scanner.initThrow() != null && printCtorArgs) {
            this.print(" throws ");
            this.print(this.scanner.initThrow());
        }
        this.println(" {");
        if (this.scanner.initCode() != null && printCtorArgs) {
            this.print("  ");
            this.print(this.scanner.initCode());
        }
        this.println("    this.zzReader = in;");
        this.println("  }");
        this.println();
    }

    private void emitCtorArgs() {
        for (int i = 0; i < this.scanner.ctorArgsCount(); ++i) {
            this.print(", " + this.scanner.ctorType(i));
            this.print(" " + this.scanner.ctorArg(i));
        }
    }

    private void emitDoEOF() {
        if (this.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        this.print("  private void zzDoEOF()");
        if (this.eofThrow != null) {
            this.print(" throws ");
            this.print(this.eofThrow);
        }
        this.println(" {");
        this.println("    if (!zzEOFDone) {");
        this.println("      zzEOFDone = true;");
        this.println("    ");
        this.print(this.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    private void emitLexFunctHeader(String functionName) {
        if (this.scanner.cupCompatible() || this.scanner.cup2Compatible()) {
            this.print("  @Override");
            this.print("  public ");
        } else {
            this.print("  " + this.visibility + " ");
        }
        if (this.scanner.tokenType() == null) {
            if (this.scanner.isInteger()) {
                this.print("int");
            } else if (this.scanner.isIntWrap()) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType());
        }
        this.print(" ");
        this.print(functionName);
        this.print("() throws java.io.IOException");
        for (String thrown : this.scanner.lexThrow()) {
            this.print("\n    , ");
            this.print(thrown);
        }
        if (this.scanner.scanErrorException() != null) {
            this.print(",\n     ");
            this.print(this.scanner.scanErrorException());
        }
        this.println("\n  {");
        this.skel.emitNext();
        this.println("    int [] zzTransL = ZZ_TRANS;");
        this.println("    int [] zzRowMapL = ZZ_ROWMAP;");
        this.println("    int [] zzAttrL = ZZ_ATTRIBUTE;");
        this.skel.emitNext();
        if (this.scanner.charCount()) {
            this.println("      yychar+= zzMarkedPosL-zzStartRead;");
            this.println("");
        }
        if (this.scanner.lineCount() || this.scanner.columnCount()) {
            this.println("      boolean zzR = false;");
            this.println("      int zzCh;");
            this.println("      int zzCharCount;");
            this.println("      for (zzCurrentPosL = zzStartRead  ;");
            this.println("           zzCurrentPosL < zzMarkedPosL ;");
            this.println("           zzCurrentPosL += zzCharCount ) {");
            this.println("        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);");
            this.println("        zzCharCount = Character.charCount(zzCh);");
            this.println("        switch (zzCh) {");
            this.println("        case '\\u000B':  // fall through");
            this.println("        case '\\u000C':  // fall through");
            this.println("        case '\\u0085':  // fall through");
            this.println("        case '\\u2028':  // fall through");
            this.println("        case '\\u2029':");
            if (this.scanner.lineCount()) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount()) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = false;");
            this.println("          break;");
            this.println("        case '\\r':");
            if (this.scanner.lineCount()) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount()) {
                this.println("          yycolumn = 0;");
            }
            this.println("          zzR = true;");
            this.println("          break;");
            this.println("        case '\\n':");
            this.println("          if (zzR)");
            this.println("            zzR = false;");
            this.println("          else {");
            if (this.scanner.lineCount()) {
                this.println("            yyline++;");
            }
            if (this.scanner.columnCount()) {
                this.println("            yycolumn = 0;");
            }
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzR = false;");
            if (this.scanner.columnCount()) {
                this.println("          yycolumn += zzCharCount;");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount()) {
                this.println("      if (zzR) {");
                this.println("        // peek one character ahead if it is");
                this.println("        // (if we have counted one line too much)");
                this.println("        boolean zzPeek;");
                this.println("        if (zzMarkedPosL < zzEndReadL)");
                this.println("          zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        else if (zzAtEOF)");
                this.println("          zzPeek = false;");
                this.println("        else {");
                this.println("          boolean eof = zzRefill();");
                this.println("          zzEndReadL = zzEndRead;");
                this.println("          zzMarkedPosL = zzMarkedPos;");
                this.println("          zzBufferL = zzBuffer;");
                this.println("          if (eof)");
                this.println("            zzPeek = false;");
                this.println("          else");
                this.println("            zzPeek = zzBufferL[zzMarkedPosL] == '\\n';");
                this.println("        }");
                this.println("        if (zzPeek) yyline--;");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed()) {
            this.println("      if (zzMarkedPosL > zzStartRead) {");
            this.println("        switch (zzBufferL[zzMarkedPosL-1]) {");
            this.println("        case '\\n':");
            this.println("        case '\\u000B':  // fall through");
            this.println("        case '\\u000C':  // fall through");
            this.println("        case '\\u0085':  // fall through");
            this.println("        case '\\u2028':  // fall through");
            this.println("        case '\\u2029':  // fall through");
            this.println("          zzAtBOL = true;");
            this.println("          break;");
            this.println("        case '\\r': ");
            this.println("          if (zzMarkedPosL < zzEndReadL)");
            this.println("            zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          else if (zzAtEOF)");
            this.println("            zzAtBOL = false;");
            this.println("          else {");
            this.println("            boolean eof = zzRefill();");
            this.println("            zzMarkedPosL = zzMarkedPos;");
            this.println("            zzEndReadL = zzEndRead;");
            this.println("            zzBufferL = zzBuffer;");
            this.println("            if (eof) ");
            this.println("              zzAtBOL = false;");
            this.println("            else ");
            this.println("              zzAtBOL = zzBufferL[zzMarkedPosL] != '\\n';");
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          zzAtBOL = false;");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed()) {
            this.println("      if (zzAtBOL)");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState+1];");
            this.println("      else");
            this.println("        zzState = ZZ_LEXSTATE[zzLexicalState];");
            this.println();
        } else {
            this.println("      zzState = ZZ_LEXSTATE[zzLexicalState];");
            this.println();
        }
        this.println("      // set up zzAction for empty match case:");
        this.println("      int zzAttributes = zzAttrL[zzState];");
        this.println("      if ( (zzAttributes & 1) == 1 ) {");
        this.println("        zzAction = zzState;");
        this.println("      }");
        this.println();
        this.skel.emitNext();
    }

    private void emitCMapAccess() {
        this.println("  /**");
        this.println("   * Translates raw input code points to DFA table row");
        this.println("   */");
        this.println("  private static int zzCMap(int input) {");
        if (this.parser.getCharClasses().getMaxCharCode() <= 255) {
            this.println("    return ZZ_CMAP[input];");
        } else {
            this.println("    int offset = input & 255;");
            this.println("    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];");
        }
        this.println("  }");
    }

    private void emitGetRowMapNext() {
        this.println("          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];");
        this.println("          if (zzNext == -1) break zzForAction;");
        this.println("          zzState = zzNext;");
        this.println();
        this.println("          zzAttributes = zzAttrL[zzState];");
        this.println("          if ( (zzAttributes & 1) == 1 ) {");
        this.skel.emitNext();
        this.println("            if ( (zzAttributes & 8) == 8 ) break zzForAction;");
        this.skel.emitNext();
    }

    private static String escapify(String s) {
        StringBuilder result = new StringBuilder(s.length() * 2);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    result.append("\\'");
                    continue block8;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                case '\r': {
                    if (i + 1 != s.length() && s.charAt(i + 1) == '\n') continue block8;
                    result.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                case '\n': {
                    result.append("\"+ZZ_NL+\"");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private void emitActionTable() {
        int lastAction = 1;
        int count = 0;
        int value = 0;
        this.println("  /**");
        this.println("   * Translates DFA states to action switch labels.");
        this.println("   */");
        CountEmitter e = new CountEmitter("Action");
        e.emitInit();
        for (int i = 0; i < this.dfa.numStates(); ++i) {
            Action action;
            int newVal = 0;
            if (this.dfa.isFinal(i) && (action = this.dfa.action(i)).isEmittable()) {
                Integer stored = this.actionTable.get(action);
                if (stored == null) {
                    stored = lastAction++;
                    this.actionTable.put(action, stored);
                }
                newVal = stored;
            }
            if (value == newVal) {
                ++count;
                continue;
            }
            if (count > 0) {
                e.emit(count, value);
            }
            count = 1;
            value = newVal;
        }
        if (count > 0) {
            e.emit(count, value);
        }
        e.emitUnpack();
        this.println(e.toString());
    }

    private void emitTokenSizeLimit(String limit) {
        this.println();
        this.println("  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */");
        this.println("  private int zzMaxBufferLen() {");
        if (limit == null) {
            this.println("    return Integer.MAX_VALUE;");
        } else {
            this.println("    return " + limit + ";");
        }
        this.println("  }");
        this.println();
        this.println("  /**  Whether the scanner buffer can grow to accommodate a larger token. */");
        this.println("  private boolean zzCanGrow() {");
        if (limit == null) {
            this.println("    return true;");
        } else {
            this.println("    return zzBuffer.length < " + limit + ";");
        }
        this.println("  }");
        this.println();
    }

    private void emitActions() {
        this.println("        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {");
        int i = this.actionTable.size() + 1;
        for (Map.Entry<Action, Integer> entry : this.actionTable.entrySet()) {
            Action action = entry.getKey();
            int label = entry.getValue();
            this.println("          case " + label + ":");
            if (action.lookAhead() == Action.Kind.FIXED_BASE) {
                this.println("            // lookahead expression with fixed base length");
                this.println("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, " + action.getLookLength() + ");");
            }
            if (action.lookAhead() == Action.Kind.FIXED_LOOK || action.lookAhead() == Action.Kind.FINITE_CHOICE) {
                this.println("            // lookahead expression with fixed lookahead length");
                this.println("            zzMarkedPos = Character.offsetByCodePoints");
                this.println("                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzMarkedPos, -" + action.getLookLength() + ");");
            }
            if (action.lookAhead() == Action.Kind.GENERAL_LOOK) {
                this.println("            // general lookahead, find correct zzMarkedPos");
                this.println("            { int zzFState = " + this.dfa.entryState(action.getEntryState()) + ";");
                this.println("              int zzFPos = zzStartRead;");
                this.println("              if (zzFin.length <= zzBufferL.length) {");
                this.println("                zzFin = new boolean[zzBufferL.length+1];");
                this.println("              }");
                this.println("              boolean zzFinL[] = zzFin;");
                this.println("              while (zzFState != -1 && zzFPos < zzMarkedPos) {");
                this.println("                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);");
                this.println("                zzInput = Character.codePointAt(zzBufferL, zzFPos, zzMarkedPos);");
                this.println("                zzFPos += Character.charCount(zzInput);");
                this.println("                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMap(zzInput) ];");
                this.println("              }");
                this.println("              if (zzFState != -1) {");
                this.println("                zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1);");
                this.println("              }");
                this.println("              while (zzFPos <= zzMarkedPos) {");
                this.println("                zzFinL[zzFPos++] = false;");
                this.println("              }");
                this.println();
                this.println("              zzFState = " + this.dfa.entryState(action.getEntryState() + 1) + ";");
                this.println("              zzFPos = zzMarkedPos;");
                this.println("              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {");
                this.println("                zzInput = Character.codePointBefore(zzBufferL, zzFPos, zzStartRead);");
                this.println("                zzFPos -= Character.charCount(zzInput);");
                this.println("                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMap(zzInput) ];");
                this.println("              };");
                this.println("              zzMarkedPos = zzFPos;");
                this.println("            }");
            }
            if (this.scanner.debugOption()) {
                this.print("            System.out.println(");
                if (this.scanner.lineCount()) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount()) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                if (this.scanner.charCount()) {
                    this.print("\"char: \"+yychar+\" \"+");
                }
                this.println("\"match: --\"+zzToPrintable(yytext())+\"--\");");
                this.print("            System.out.println(\"action [" + action.priority + "] { ");
                this.print(Emitter.escapify(action.content));
                this.println(" }\");");
            }
            this.println("            { " + action.content);
            this.println("            }");
            this.println("          // fall through");
            this.println("          case " + i++ + ": break;");
        }
    }

    private void emitEOFVal() {
        Action defaultAction;
        EOFActions eofActions = this.parser.getEOFActions();
        if (this.eofCode != null) {
            this.println("            zzDoEOF();");
        }
        if (eofActions.numActions() > 0) {
            this.println("            switch (zzLexicalState) {");
            int last = this.dfa.numStates();
            for (String name : this.scanner.stateNames()) {
                int num = this.scanner.getStateNumber(name);
                Action action = eofActions.getAction(num);
                if (action == null) continue;
                this.println("            case " + name + ": {");
                if (this.scanner.debugOption()) {
                    this.print("              System.out.println(");
                    if (this.scanner.lineCount()) {
                        this.print("\"line: \"+(yyline+1)+\" \"+");
                    }
                    if (this.scanner.columnCount()) {
                        this.print("\"col: \"+(yycolumn+1)+\" \"+");
                    }
                    if (this.scanner.charCount()) {
                        this.print("\"char: \"+yychar+\" \"+");
                    }
                    this.println("\"match: <<EOF>>\");");
                    this.print("              System.out.println(\"action [" + action.priority + "] { ");
                    this.print(Emitter.escapify(action.content));
                    this.println(" }\");");
                }
                this.println("              " + action.content);
                this.println("            }  // fall though");
                this.println("            case " + ++last + ": break;");
            }
            this.println("            default:");
        }
        if ((defaultAction = eofActions.getDefault()) != null) {
            this.println("              {");
            if (this.scanner.debugOption()) {
                this.print("                System.out.println(");
                if (this.scanner.lineCount()) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount()) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                if (this.scanner.charCount()) {
                    this.print("\"char: \"+yychar+\" \"+");
                }
                this.println("\"match: <<EOF>>\");");
                this.print("                System.out.println(\"action [" + defaultAction.priority + "] { ");
                this.print(Emitter.escapify(defaultAction.content));
                this.println(" }\");");
            }
            this.println("                " + defaultAction.content);
            this.println("              }");
        } else if (this.scanner.eofVal() != null) {
            this.println("          { " + this.scanner.eofVal() + " }");
        } else if (this.scanner.isInteger()) {
            if (this.scanner.tokenType() != null) {
                Out.error(ErrorMessages.INT_AND_TYPE);
                throw new GeneratorException();
            }
            this.println("        return YYEOF;");
        } else {
            this.println("        return null;");
        }
        if (eofActions.numActions() > 0) {
            this.println("        }");
        }
    }

    private void findActionStates() {
        this.isTransition = new boolean[this.dfa.numStates()];
        for (int i = 0; i < this.dfa.numStates(); ++i) {
            for (int j = 0; !this.isTransition[i] && j < this.dfa.numInput(); j = (int)((char)(j + 1))) {
                int n = j;
                this.isTransition[i] = this.dfa.table(i, n) != -1;
            }
        }
    }

    private void reduceColumns() {
        this.colMap = new int[this.dfa.numInput()];
        this.colKilled = new boolean[this.dfa.numInput()];
        int translate = 0;
        this.numCols = this.dfa.numInput();
        block0: for (int i = 0; i < this.dfa.numInput(); ++i) {
            this.colMap[i] = i - translate;
            for (int j = 0; j < i; ++j) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numStates()) {
                    equal = this.dfa.table(k, i) == this.dfa.table(k, j);
                }
                if (!equal) continue;
                ++translate;
                this.colMap[i] = this.colMap[j];
                this.colKilled[i] = true;
                --this.numCols;
                continue block0;
            }
        }
    }

    private void reduceRows() {
        this.rowMap = new int[this.dfa.numStates()];
        this.rowKilled = new boolean[this.dfa.numStates()];
        int translate = 0;
        block0: for (int i = 0; i < this.dfa.numStates(); ++i) {
            this.rowMap[i] = i - translate;
            for (int j = 0; j < i; ++j) {
                int k = -1;
                boolean equal = true;
                while (equal && ++k < this.dfa.numInput()) {
                    equal = this.dfa.table(i, k) == this.dfa.table(j, k);
                }
                if (!equal) continue;
                ++translate;
                this.rowMap[i] = this.rowMap[j];
                this.rowKilled[i] = true;
                continue block0;
            }
        }
    }

    private void setupEOFCode() {
        if (this.scanner.eofclose()) {
            this.eofCode = LexScan.conc(this.scanner.eofCode(), "  yyclose();");
            this.eofThrow = LexScan.concExc(this.scanner.eofThrow(), "java.io.IOException");
        } else {
            this.eofCode = this.scanner.eofCode();
            this.eofThrow = this.scanner.eofThrow();
        }
    }

    private void emitVarDefs() {
        this.println("  /** Number of newlines encountered up to the start of the matched text. */");
        if (!this.scanner.lineCount()) {
            this.println("  @SuppressWarnings(\"unused\")");
        }
        this.println("  private int yyline;");
        this.println();
        this.println("  /** Number of characters from the last newline up to the start of the matched text. */");
        if (!this.scanner.columnCount()) {
            this.println("  @SuppressWarnings(\"unused\")");
        }
        this.println("  private int yycolumn;");
        this.println();
        this.println("  /** Number of characters up to the start of the matched text. */");
        if (!this.scanner.charCount()) {
            this.println("  @SuppressWarnings(\"unused\")");
        }
        this.println("  private long yychar;");
        this.println();
        this.println("  /** Whether the scanner is currently at the beginning of a line. */");
        if (!this.scanner.bolUsed()) {
            this.println("  @SuppressWarnings(\"unused\")");
        }
        this.println("  private boolean zzAtBOL = true;");
        this.println();
        this.println("  /** Whether the user-EOF-code has already been executed. */");
        if (this.eofCode == null) {
            this.println("  @SuppressWarnings(\"unused\")");
        }
        this.println("  private boolean zzEOFDone;");
        this.println();
    }

    public void emit() {
        String functionName = this.scanner.functionName() != null ? this.scanner.functionName() : "yylex";
        this.setupEOFCode();
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  private static final int ZZ_BUFFERSIZE = " + this.scanner.bufferSize() + ";");
        if (this.scanner.debugOption()) {
            this.println("  private static final String ZZ_NL = System.getProperty(\"line.separator\");");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        this.emitCharMapTables();
        this.emitActionTable();
        this.reduceRows();
        this.emitRowMapArray();
        this.emitDynamicInit();
        this.skel.emitNext();
        this.emitAttributes();
        this.skel.emitNext();
        this.emitLookBuffer();
        this.emitVarDefs();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitConstructorDecl();
        if (this.scanner.debugOption()) {
            this.println("");
            this.println("  private static String zzToPrintable(String str) {");
            this.println("    StringBuilder builder = new StringBuilder();");
            this.println("    for (int n = 0 ; n < str.length() ; ) {");
            this.println("      int ch = str.codePointAt(n);");
            this.println("      int charCount = Character.charCount(ch);");
            this.println("      n += charCount;");
            this.println("      if (ch > 31 && ch < 127) {");
            this.println("        builder.append((char)ch);");
            this.println("      } else if (charCount == 1) {");
            this.println("        builder.append(String.format(\"\\\\u%04X\", ch));");
            this.println("      } else {");
            this.println("        builder.append(String.format(\"\\\\U%06X\", ch));");
            this.println("      }");
            this.println("    }");
            this.println("    return builder.toString();");
            this.println("  }");
        }
        this.emitTokenSizeLimit(this.scanner.getTokenSizeLimit());
        this.emitCMapAccess();
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader(functionName);
        this.emitNextInput();
        this.emitGetRowMapNext();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain(functionName);
        this.skel.emitNext();
        this.out.close();
    }
}

