// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/iap/v1/service.proto

package iap

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Types of reauthentication methods supported by IAP.
type ReauthSettings_Method int32

const (
	// Reauthentication disabled.
	ReauthSettings_METHOD_UNSPECIFIED ReauthSettings_Method = 0
	// Mimics the behavior as if the user had logged out and tried to log in
	// again. Users with 2SV (2-step verification) enabled see their 2SV
	// challenges if they did not opt to have their second factor responses
	// saved. Apps Core (GSuites) admins can configure settings to disable 2SV
	// cookies and require 2SV for all Apps Core users in their domains.
	ReauthSettings_LOGIN ReauthSettings_Method = 1
	// User must type their password.
	ReauthSettings_PASSWORD ReauthSettings_Method = 2
	// User must use their secure key 2nd factor device.
	ReauthSettings_SECURE_KEY ReauthSettings_Method = 3
)

// Enum value maps for ReauthSettings_Method.
var (
	ReauthSettings_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "LOGIN",
		2: "PASSWORD",
		3: "SECURE_KEY",
	}
	ReauthSettings_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED": 0,
		"LOGIN":              1,
		"PASSWORD":           2,
		"SECURE_KEY":         3,
	}
)

func (x ReauthSettings_Method) Enum() *ReauthSettings_Method {
	p := new(ReauthSettings_Method)
	*p = x
	return p
}

func (x ReauthSettings_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReauthSettings_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iap_v1_service_proto_enumTypes[0].Descriptor()
}

func (ReauthSettings_Method) Type() protoreflect.EnumType {
	return &file_google_cloud_iap_v1_service_proto_enumTypes[0]
}

func (x ReauthSettings_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReauthSettings_Method.Descriptor instead.
func (ReauthSettings_Method) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{14, 0}
}

// Type of policy in the case of hierarchial policies.
type ReauthSettings_PolicyType int32

const (
	// Default value. This value is unused.
	ReauthSettings_POLICY_TYPE_UNSPECIFIED ReauthSettings_PolicyType = 0
	// This policy acts as a minimum to other policies, lower in the hierarchy.
	// Effective policy may only be the same or stricter.
	ReauthSettings_MINIMUM ReauthSettings_PolicyType = 1
	// This policy acts as a default if no other reauth policy is set.
	ReauthSettings_DEFAULT ReauthSettings_PolicyType = 2
)

// Enum value maps for ReauthSettings_PolicyType.
var (
	ReauthSettings_PolicyType_name = map[int32]string{
		0: "POLICY_TYPE_UNSPECIFIED",
		1: "MINIMUM",
		2: "DEFAULT",
	}
	ReauthSettings_PolicyType_value = map[string]int32{
		"POLICY_TYPE_UNSPECIFIED": 0,
		"MINIMUM":                 1,
		"DEFAULT":                 2,
	}
)

func (x ReauthSettings_PolicyType) Enum() *ReauthSettings_PolicyType {
	p := new(ReauthSettings_PolicyType)
	*p = x
	return p
}

func (x ReauthSettings_PolicyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReauthSettings_PolicyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_iap_v1_service_proto_enumTypes[1].Descriptor()
}

func (ReauthSettings_PolicyType) Type() protoreflect.EnumType {
	return &file_google_cloud_iap_v1_service_proto_enumTypes[1]
}

func (x ReauthSettings_PolicyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReauthSettings_PolicyType.Descriptor instead.
func (ReauthSettings_PolicyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{14, 1}
}

// The request to ListTunnelDestGroups.
type ListTunnelDestGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Project ID and location.
	// In the following format:
	// `projects/{project_number/id}/iap_tunnel/locations/{location}`.
	// A `-` can be used for the location to group across all locations.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of groups to return. The service might return fewer than
	// this value.
	// If unspecified, at most 100 groups are returned.
	// The maximum value is 1000; values above 1000 are coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListTunnelDestGroups`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListTunnelDestGroups` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTunnelDestGroupsRequest) Reset() {
	*x = ListTunnelDestGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTunnelDestGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTunnelDestGroupsRequest) ProtoMessage() {}

func (x *ListTunnelDestGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTunnelDestGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListTunnelDestGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListTunnelDestGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTunnelDestGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTunnelDestGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response from ListTunnelDestGroups.
type ListTunnelDestGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TunnelDestGroup existing in the project.
	TunnelDestGroups []*TunnelDestGroup `protobuf:"bytes,1,rep,name=tunnel_dest_groups,json=tunnelDestGroups,proto3" json:"tunnel_dest_groups,omitempty"`
	// A token that you can send as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTunnelDestGroupsResponse) Reset() {
	*x = ListTunnelDestGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTunnelDestGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTunnelDestGroupsResponse) ProtoMessage() {}

func (x *ListTunnelDestGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTunnelDestGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListTunnelDestGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListTunnelDestGroupsResponse) GetTunnelDestGroups() []*TunnelDestGroup {
	if x != nil {
		return x.TunnelDestGroups
	}
	return nil
}

func (x *ListTunnelDestGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to CreateTunnelDestGroup.
type CreateTunnelDestGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Project ID and location.
	// In the following format:
	// `projects/{project_number/id}/iap_tunnel/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The TunnelDestGroup to create.
	TunnelDestGroup *TunnelDestGroup `protobuf:"bytes,2,opt,name=tunnel_dest_group,json=tunnelDestGroup,proto3" json:"tunnel_dest_group,omitempty"`
	// Required. The ID to use for the TunnelDestGroup, which becomes the final component of
	// the resource name.
	//
	// This value must be 4-63 characters, and valid characters
	// are `[a-z][0-9]-`.
	TunnelDestGroupId string `protobuf:"bytes,3,opt,name=tunnel_dest_group_id,json=tunnelDestGroupId,proto3" json:"tunnel_dest_group_id,omitempty"`
}

func (x *CreateTunnelDestGroupRequest) Reset() {
	*x = CreateTunnelDestGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTunnelDestGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTunnelDestGroupRequest) ProtoMessage() {}

func (x *CreateTunnelDestGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTunnelDestGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateTunnelDestGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *CreateTunnelDestGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTunnelDestGroupRequest) GetTunnelDestGroup() *TunnelDestGroup {
	if x != nil {
		return x.TunnelDestGroup
	}
	return nil
}

func (x *CreateTunnelDestGroupRequest) GetTunnelDestGroupId() string {
	if x != nil {
		return x.TunnelDestGroupId
	}
	return ""
}

// The request to GetTunnelDestGroup.
type GetTunnelDestGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the TunnelDestGroup to be fetched.
	// In the following format:
	// `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTunnelDestGroupRequest) Reset() {
	*x = GetTunnelDestGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTunnelDestGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTunnelDestGroupRequest) ProtoMessage() {}

func (x *GetTunnelDestGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTunnelDestGroupRequest.ProtoReflect.Descriptor instead.
func (*GetTunnelDestGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *GetTunnelDestGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to DeleteTunnelDestGroup.
type DeleteTunnelDestGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the TunnelDestGroup to delete.
	// In the following format:
	// `projects/{project_number/id}/iap_tunnel/locations/{location}/destGroups/{dest_group}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTunnelDestGroupRequest) Reset() {
	*x = DeleteTunnelDestGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTunnelDestGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTunnelDestGroupRequest) ProtoMessage() {}

func (x *DeleteTunnelDestGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTunnelDestGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteTunnelDestGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteTunnelDestGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request to UpdateTunnelDestGroup.
type UpdateTunnelDestGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the TunnelDestGroup.
	TunnelDestGroup *TunnelDestGroup `protobuf:"bytes,1,opt,name=tunnel_dest_group,json=tunnelDestGroup,proto3" json:"tunnel_dest_group,omitempty"`
	// A field mask that specifies which IAP settings to update.
	// If omitted, then all of the settings are updated. See
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTunnelDestGroupRequest) Reset() {
	*x = UpdateTunnelDestGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTunnelDestGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTunnelDestGroupRequest) ProtoMessage() {}

func (x *UpdateTunnelDestGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTunnelDestGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateTunnelDestGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTunnelDestGroupRequest) GetTunnelDestGroup() *TunnelDestGroup {
	if x != nil {
		return x.TunnelDestGroup
	}
	return nil
}

func (x *UpdateTunnelDestGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A TunnelDestGroup.
type TunnelDestGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Identifier for the TunnelDestGroup. Must be unique within the
	// project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// null List of CIDRs that this group applies to.
	Cidrs []string `protobuf:"bytes,2,rep,name=cidrs,proto3" json:"cidrs,omitempty"`
	// null List of FQDNs that this group applies to.
	Fqdns []string `protobuf:"bytes,3,rep,name=fqdns,proto3" json:"fqdns,omitempty"`
}

func (x *TunnelDestGroup) Reset() {
	*x = TunnelDestGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TunnelDestGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunnelDestGroup) ProtoMessage() {}

func (x *TunnelDestGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunnelDestGroup.ProtoReflect.Descriptor instead.
func (*TunnelDestGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *TunnelDestGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TunnelDestGroup) GetCidrs() []string {
	if x != nil {
		return x.Cidrs
	}
	return nil
}

func (x *TunnelDestGroup) GetFqdns() []string {
	if x != nil {
		return x.Fqdns
	}
	return nil
}

// The request sent to GetIapSettings.
type GetIapSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for which to retrieve the settings.
	// Authorization: Requires the `getSettings` permission for the associated
	// resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIapSettingsRequest) Reset() {
	*x = GetIapSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIapSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIapSettingsRequest) ProtoMessage() {}

func (x *GetIapSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIapSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetIapSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetIapSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request sent to UpdateIapSettings.
type UpdateIapSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values for the IAP settings to be updated.
	// Authorization: Requires the `updateSettings` permission for the associated
	// resource.
	IapSettings *IapSettings `protobuf:"bytes,1,opt,name=iap_settings,json=iapSettings,proto3" json:"iap_settings,omitempty"`
	// The field mask specifying which IAP settings should be updated.
	// If omitted, the all of the settings are updated. See
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIapSettingsRequest) Reset() {
	*x = UpdateIapSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIapSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIapSettingsRequest) ProtoMessage() {}

func (x *UpdateIapSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIapSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateIapSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateIapSettingsRequest) GetIapSettings() *IapSettings {
	if x != nil {
		return x.IapSettings
	}
	return nil
}

func (x *UpdateIapSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The IAP configurable settings.
type IapSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the IAP protected resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Top level wrapper for all access related setting in IAP
	AccessSettings *AccessSettings `protobuf:"bytes,5,opt,name=access_settings,json=accessSettings,proto3" json:"access_settings,omitempty"`
	// Top level wrapper for all application related settings in IAP
	ApplicationSettings *ApplicationSettings `protobuf:"bytes,6,opt,name=application_settings,json=applicationSettings,proto3" json:"application_settings,omitempty"`
}

func (x *IapSettings) Reset() {
	*x = IapSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IapSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IapSettings) ProtoMessage() {}

func (x *IapSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IapSettings.ProtoReflect.Descriptor instead.
func (*IapSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *IapSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IapSettings) GetAccessSettings() *AccessSettings {
	if x != nil {
		return x.AccessSettings
	}
	return nil
}

func (x *IapSettings) GetApplicationSettings() *ApplicationSettings {
	if x != nil {
		return x.ApplicationSettings
	}
	return nil
}

// Access related settings for IAP protected apps.
type AccessSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// GCIP claims and endpoint configurations for 3p identity providers.
	GcipSettings *GcipSettings `protobuf:"bytes,1,opt,name=gcip_settings,json=gcipSettings,proto3" json:"gcip_settings,omitempty"`
	// Configuration to allow cross-origin requests via IAP.
	CorsSettings *CorsSettings `protobuf:"bytes,2,opt,name=cors_settings,json=corsSettings,proto3" json:"cors_settings,omitempty"`
	// Settings to configure IAP's OAuth behavior.
	OauthSettings *OAuthSettings `protobuf:"bytes,3,opt,name=oauth_settings,json=oauthSettings,proto3" json:"oauth_settings,omitempty"`
	// Settings to configure reauthentication policies in IAP.
	ReauthSettings *ReauthSettings `protobuf:"bytes,6,opt,name=reauth_settings,json=reauthSettings,proto3" json:"reauth_settings,omitempty"`
}

func (x *AccessSettings) Reset() {
	*x = AccessSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessSettings) ProtoMessage() {}

func (x *AccessSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessSettings.ProtoReflect.Descriptor instead.
func (*AccessSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *AccessSettings) GetGcipSettings() *GcipSettings {
	if x != nil {
		return x.GcipSettings
	}
	return nil
}

func (x *AccessSettings) GetCorsSettings() *CorsSettings {
	if x != nil {
		return x.CorsSettings
	}
	return nil
}

func (x *AccessSettings) GetOauthSettings() *OAuthSettings {
	if x != nil {
		return x.OauthSettings
	}
	return nil
}

func (x *AccessSettings) GetReauthSettings() *ReauthSettings {
	if x != nil {
		return x.ReauthSettings
	}
	return nil
}

// Allows customers to configure tenant_id for GCIP instance per-app.
type GcipSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// GCIP tenant ids that are linked to the IAP resource.
	// tenant_ids could be a string beginning with a number character to indicate
	// authenticating with GCIP tenant flow, or in the format of _<ProjectNumber>
	// to indicate authenticating with GCIP agent flow.
	// If agent flow is used, tenant_ids should only contain one single element,
	// while for tenant flow, tenant_ids can contain multiple elements.
	TenantIds []string `protobuf:"bytes,1,rep,name=tenant_ids,json=tenantIds,proto3" json:"tenant_ids,omitempty"`
	// Login page URI associated with the GCIP tenants.
	// Typically, all resources within the same project share the same login page,
	// though it could be overridden at the sub resource level.
	LoginPageUri *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=login_page_uri,json=loginPageUri,proto3" json:"login_page_uri,omitempty"`
}

func (x *GcipSettings) Reset() {
	*x = GcipSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcipSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcipSettings) ProtoMessage() {}

func (x *GcipSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcipSettings.ProtoReflect.Descriptor instead.
func (*GcipSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{11}
}

func (x *GcipSettings) GetTenantIds() []string {
	if x != nil {
		return x.TenantIds
	}
	return nil
}

func (x *GcipSettings) GetLoginPageUri() *wrapperspb.StringValue {
	if x != nil {
		return x.LoginPageUri
	}
	return nil
}

// Allows customers to configure HTTP request paths that'll allow HTTP OPTIONS
// call to bypass authentication and authorization.
type CorsSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration to allow HTTP OPTIONS calls to skip authorization. If
	// undefined, IAP will not apply any special logic to OPTIONS requests.
	AllowHttpOptions *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=allow_http_options,json=allowHttpOptions,proto3" json:"allow_http_options,omitempty"`
}

func (x *CorsSettings) Reset() {
	*x = CorsSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CorsSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorsSettings) ProtoMessage() {}

func (x *CorsSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorsSettings.ProtoReflect.Descriptor instead.
func (*CorsSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{12}
}

func (x *CorsSettings) GetAllowHttpOptions() *wrapperspb.BoolValue {
	if x != nil {
		return x.AllowHttpOptions
	}
	return nil
}

// Configuration for OAuth login&consent flow behavior as well as for OAuth
// Credentials.
type OAuthSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Domain hint to send as hd=? parameter in OAuth request flow. Enables
	// redirect to primary IDP by skipping Google's login screen.
	// https://developers.google.com/identity/protocols/OpenIDConnect#hd-param
	// Note: IAP does not verify that the id token's hd claim matches this value
	// since access behavior is managed by IAM policies.
	LoginHint *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=login_hint,json=loginHint,proto3" json:"login_hint,omitempty"`
}

func (x *OAuthSettings) Reset() {
	*x = OAuthSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuthSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuthSettings) ProtoMessage() {}

func (x *OAuthSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuthSettings.ProtoReflect.Descriptor instead.
func (*OAuthSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{13}
}

func (x *OAuthSettings) GetLoginHint() *wrapperspb.StringValue {
	if x != nil {
		return x.LoginHint
	}
	return nil
}

// Configuration for IAP reauthentication policies.
type ReauthSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reauth method required by the policy.
	Method ReauthSettings_Method `protobuf:"varint,1,opt,name=method,proto3,enum=google.cloud.iap.v1.ReauthSettings_Method" json:"method,omitempty"`
	// Reauth session lifetime, how long before a user has to reauthenticate
	// again.
	MaxAge *durationpb.Duration `protobuf:"bytes,2,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// How IAP determines the effective policy in cases of hierarchial policies.
	// Policies are merged from higher in the hierarchy to lower in the hierarchy.
	PolicyType ReauthSettings_PolicyType `protobuf:"varint,3,opt,name=policy_type,json=policyType,proto3,enum=google.cloud.iap.v1.ReauthSettings_PolicyType" json:"policy_type,omitempty"`
}

func (x *ReauthSettings) Reset() {
	*x = ReauthSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReauthSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReauthSettings) ProtoMessage() {}

func (x *ReauthSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReauthSettings.ProtoReflect.Descriptor instead.
func (*ReauthSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{14}
}

func (x *ReauthSettings) GetMethod() ReauthSettings_Method {
	if x != nil {
		return x.Method
	}
	return ReauthSettings_METHOD_UNSPECIFIED
}

func (x *ReauthSettings) GetMaxAge() *durationpb.Duration {
	if x != nil {
		return x.MaxAge
	}
	return nil
}

func (x *ReauthSettings) GetPolicyType() ReauthSettings_PolicyType {
	if x != nil {
		return x.PolicyType
	}
	return ReauthSettings_POLICY_TYPE_UNSPECIFIED
}

// Wrapper over application specific settings for IAP.
type ApplicationSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Settings to configure IAP's behavior for a CSM mesh.
	CsmSettings *CsmSettings `protobuf:"bytes,1,opt,name=csm_settings,json=csmSettings,proto3" json:"csm_settings,omitempty"`
	// Customization for Access Denied page.
	AccessDeniedPageSettings *AccessDeniedPageSettings `protobuf:"bytes,2,opt,name=access_denied_page_settings,json=accessDeniedPageSettings,proto3" json:"access_denied_page_settings,omitempty"`
	// The Domain value to set for cookies generated by IAP. This value is not
	// validated by the API, but will be ignored at runtime if invalid.
	CookieDomain *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=cookie_domain,json=cookieDomain,proto3" json:"cookie_domain,omitempty"`
}

func (x *ApplicationSettings) Reset() {
	*x = ApplicationSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplicationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationSettings) ProtoMessage() {}

func (x *ApplicationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationSettings.ProtoReflect.Descriptor instead.
func (*ApplicationSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{15}
}

func (x *ApplicationSettings) GetCsmSettings() *CsmSettings {
	if x != nil {
		return x.CsmSettings
	}
	return nil
}

func (x *ApplicationSettings) GetAccessDeniedPageSettings() *AccessDeniedPageSettings {
	if x != nil {
		return x.AccessDeniedPageSettings
	}
	return nil
}

func (x *ApplicationSettings) GetCookieDomain() *wrapperspb.StringValue {
	if x != nil {
		return x.CookieDomain
	}
	return nil
}

// Configuration for RCTokens generated for CSM workloads protected by IAP.
// RCTokens are IAP generated JWTs that can be verified at the application. The
// RCToken is primarily used for ISTIO deployments, and can be scoped to a
// single mesh by configuring the audience field accordingly
type CsmSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Audience claim set in the generated RCToken. This value is not validated by
	// IAP.
	RctokenAud *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=rctoken_aud,json=rctokenAud,proto3" json:"rctoken_aud,omitempty"`
}

func (x *CsmSettings) Reset() {
	*x = CsmSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CsmSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CsmSettings) ProtoMessage() {}

func (x *CsmSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CsmSettings.ProtoReflect.Descriptor instead.
func (*CsmSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{16}
}

func (x *CsmSettings) GetRctokenAud() *wrapperspb.StringValue {
	if x != nil {
		return x.RctokenAud
	}
	return nil
}

// Custom content configuration for access denied page.
// IAP allows customers to define a custom URI to use as the error page when
// access is denied to users. If IAP prevents access to this page, the default
// IAP error page will be displayed instead.
type AccessDeniedPageSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI to be redirected to when access is denied.
	AccessDeniedPageUri *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=access_denied_page_uri,json=accessDeniedPageUri,proto3" json:"access_denied_page_uri,omitempty"`
	// Whether to generate a troubleshooting URL on access denied events to this
	// application.
	GenerateTroubleshootingUri *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=generate_troubleshooting_uri,json=generateTroubleshootingUri,proto3" json:"generate_troubleshooting_uri,omitempty"`
}

func (x *AccessDeniedPageSettings) Reset() {
	*x = AccessDeniedPageSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessDeniedPageSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessDeniedPageSettings) ProtoMessage() {}

func (x *AccessDeniedPageSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessDeniedPageSettings.ProtoReflect.Descriptor instead.
func (*AccessDeniedPageSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{17}
}

func (x *AccessDeniedPageSettings) GetAccessDeniedPageUri() *wrapperspb.StringValue {
	if x != nil {
		return x.AccessDeniedPageUri
	}
	return nil
}

func (x *AccessDeniedPageSettings) GetGenerateTroubleshootingUri() *wrapperspb.BoolValue {
	if x != nil {
		return x.GenerateTroubleshootingUri
	}
	return nil
}

// The request sent to ListBrands.
type ListBrandsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. GCP Project number/id.
	// In the following format: projects/{project_number/id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListBrandsRequest) Reset() {
	*x = ListBrandsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBrandsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBrandsRequest) ProtoMessage() {}

func (x *ListBrandsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBrandsRequest.ProtoReflect.Descriptor instead.
func (*ListBrandsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListBrandsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for ListBrands.
type ListBrandsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Brands existing in the project.
	Brands []*Brand `protobuf:"bytes,1,rep,name=brands,proto3" json:"brands,omitempty"`
}

func (x *ListBrandsResponse) Reset() {
	*x = ListBrandsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBrandsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBrandsResponse) ProtoMessage() {}

func (x *ListBrandsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBrandsResponse.ProtoReflect.Descriptor instead.
func (*ListBrandsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListBrandsResponse) GetBrands() []*Brand {
	if x != nil {
		return x.Brands
	}
	return nil
}

// The request sent to CreateBrand.
type CreateBrandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. GCP Project number/id under which the brand is to be created.
	// In the following format: projects/{project_number/id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The brand to be created.
	Brand *Brand `protobuf:"bytes,2,opt,name=brand,proto3" json:"brand,omitempty"`
}

func (x *CreateBrandRequest) Reset() {
	*x = CreateBrandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBrandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBrandRequest) ProtoMessage() {}

func (x *CreateBrandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBrandRequest.ProtoReflect.Descriptor instead.
func (*CreateBrandRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{20}
}

func (x *CreateBrandRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBrandRequest) GetBrand() *Brand {
	if x != nil {
		return x.Brand
	}
	return nil
}

// The request sent to GetBrand.
type GetBrandRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the brand to be fetched.
	// In the following format: projects/{project_number/id}/brands/{brand}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBrandRequest) Reset() {
	*x = GetBrandRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBrandRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBrandRequest) ProtoMessage() {}

func (x *GetBrandRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBrandRequest.ProtoReflect.Descriptor instead.
func (*GetBrandRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{21}
}

func (x *GetBrandRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request sent to ListIdentityAwareProxyClients.
type ListIdentityAwareProxyClientsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full brand path.
	// In the following format: projects/{project_number/id}/brands/{brand}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of clients to return. The service may return fewer than
	// this value.
	// If unspecified, at most 100 clients will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListIdentityAwareProxyClients`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListIdentityAwareProxyClients` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIdentityAwareProxyClientsRequest) Reset() {
	*x = ListIdentityAwareProxyClientsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIdentityAwareProxyClientsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIdentityAwareProxyClientsRequest) ProtoMessage() {}

func (x *ListIdentityAwareProxyClientsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIdentityAwareProxyClientsRequest.ProtoReflect.Descriptor instead.
func (*ListIdentityAwareProxyClientsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListIdentityAwareProxyClientsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIdentityAwareProxyClientsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIdentityAwareProxyClientsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListIdentityAwareProxyClients.
type ListIdentityAwareProxyClientsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Clients existing in the brand.
	IdentityAwareProxyClients []*IdentityAwareProxyClient `protobuf:"bytes,1,rep,name=identity_aware_proxy_clients,json=identityAwareProxyClients,proto3" json:"identity_aware_proxy_clients,omitempty"`
	// A token, which can be send as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIdentityAwareProxyClientsResponse) Reset() {
	*x = ListIdentityAwareProxyClientsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIdentityAwareProxyClientsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIdentityAwareProxyClientsResponse) ProtoMessage() {}

func (x *ListIdentityAwareProxyClientsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIdentityAwareProxyClientsResponse.ProtoReflect.Descriptor instead.
func (*ListIdentityAwareProxyClientsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListIdentityAwareProxyClientsResponse) GetIdentityAwareProxyClients() []*IdentityAwareProxyClient {
	if x != nil {
		return x.IdentityAwareProxyClients
	}
	return nil
}

func (x *ListIdentityAwareProxyClientsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request sent to CreateIdentityAwareProxyClient.
type CreateIdentityAwareProxyClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Path to create the client in.
	// In the following format:
	// projects/{project_number/id}/brands/{brand}.
	// The project must belong to a G Suite account.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Identity Aware Proxy Client to be created.
	IdentityAwareProxyClient *IdentityAwareProxyClient `protobuf:"bytes,2,opt,name=identity_aware_proxy_client,json=identityAwareProxyClient,proto3" json:"identity_aware_proxy_client,omitempty"`
}

func (x *CreateIdentityAwareProxyClientRequest) Reset() {
	*x = CreateIdentityAwareProxyClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIdentityAwareProxyClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIdentityAwareProxyClientRequest) ProtoMessage() {}

func (x *CreateIdentityAwareProxyClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIdentityAwareProxyClientRequest.ProtoReflect.Descriptor instead.
func (*CreateIdentityAwareProxyClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{24}
}

func (x *CreateIdentityAwareProxyClientRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIdentityAwareProxyClientRequest) GetIdentityAwareProxyClient() *IdentityAwareProxyClient {
	if x != nil {
		return x.IdentityAwareProxyClient
	}
	return nil
}

// The request sent to GetIdentityAwareProxyClient.
type GetIdentityAwareProxyClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Identity Aware Proxy client to be fetched.
	// In the following format:
	// projects/{project_number/id}/brands/{brand}/identityAwareProxyClients/{client_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIdentityAwareProxyClientRequest) Reset() {
	*x = GetIdentityAwareProxyClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIdentityAwareProxyClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIdentityAwareProxyClientRequest) ProtoMessage() {}

func (x *GetIdentityAwareProxyClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIdentityAwareProxyClientRequest.ProtoReflect.Descriptor instead.
func (*GetIdentityAwareProxyClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{25}
}

func (x *GetIdentityAwareProxyClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request sent to ResetIdentityAwareProxyClientSecret.
type ResetIdentityAwareProxyClientSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Identity Aware Proxy client to that will have its
	// secret reset. In the following format:
	// projects/{project_number/id}/brands/{brand}/identityAwareProxyClients/{client_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResetIdentityAwareProxyClientSecretRequest) Reset() {
	*x = ResetIdentityAwareProxyClientSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetIdentityAwareProxyClientSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetIdentityAwareProxyClientSecretRequest) ProtoMessage() {}

func (x *ResetIdentityAwareProxyClientSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetIdentityAwareProxyClientSecretRequest.ProtoReflect.Descriptor instead.
func (*ResetIdentityAwareProxyClientSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{26}
}

func (x *ResetIdentityAwareProxyClientSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request sent to DeleteIdentityAwareProxyClient.
type DeleteIdentityAwareProxyClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Identity Aware Proxy client to be deleted.
	// In the following format:
	// projects/{project_number/id}/brands/{brand}/identityAwareProxyClients/{client_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIdentityAwareProxyClientRequest) Reset() {
	*x = DeleteIdentityAwareProxyClientRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIdentityAwareProxyClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIdentityAwareProxyClientRequest) ProtoMessage() {}

func (x *DeleteIdentityAwareProxyClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIdentityAwareProxyClientRequest.ProtoReflect.Descriptor instead.
func (*DeleteIdentityAwareProxyClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteIdentityAwareProxyClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// OAuth brand data.
// NOTE: Only contains a portion of the data that describes a brand.
type Brand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier of the brand.
	// NOTE: GCP project number achieves the same brand identification purpose as
	// only one brand per project can be created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Support email displayed on the OAuth consent screen.
	SupportEmail string `protobuf:"bytes,2,opt,name=support_email,json=supportEmail,proto3" json:"support_email,omitempty"`
	// Application name displayed on OAuth consent screen.
	ApplicationTitle string `protobuf:"bytes,3,opt,name=application_title,json=applicationTitle,proto3" json:"application_title,omitempty"`
	// Output only. Whether the brand is only intended for usage inside the
	// G Suite organization only.
	OrgInternalOnly bool `protobuf:"varint,4,opt,name=org_internal_only,json=orgInternalOnly,proto3" json:"org_internal_only,omitempty"`
}

func (x *Brand) Reset() {
	*x = Brand{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Brand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Brand) ProtoMessage() {}

func (x *Brand) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Brand.ProtoReflect.Descriptor instead.
func (*Brand) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{28}
}

func (x *Brand) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Brand) GetSupportEmail() string {
	if x != nil {
		return x.SupportEmail
	}
	return ""
}

func (x *Brand) GetApplicationTitle() string {
	if x != nil {
		return x.ApplicationTitle
	}
	return ""
}

func (x *Brand) GetOrgInternalOnly() bool {
	if x != nil {
		return x.OrgInternalOnly
	}
	return false
}

// Contains the data that describes an Identity Aware Proxy owned client.
type IdentityAwareProxyClient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique identifier of the OAuth client.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Client secret of the OAuth client.
	Secret string `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
	// Human-friendly name given to the OAuth client.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *IdentityAwareProxyClient) Reset() {
	*x = IdentityAwareProxyClient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_iap_v1_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdentityAwareProxyClient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentityAwareProxyClient) ProtoMessage() {}

func (x *IdentityAwareProxyClient) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_iap_v1_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentityAwareProxyClient.ProtoReflect.Descriptor instead.
func (*IdentityAwareProxyClient) Descriptor() ([]byte, []int) {
	return file_google_cloud_iap_v1_service_proto_rawDescGZIP(), []int{29}
}

func (x *IdentityAwareProxyClient) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IdentityAwareProxyClient) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *IdentityAwareProxyClient) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_iap_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_iap_v1_service_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x61, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9c, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x12, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44,
	0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x10, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xef, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x69, 0x61, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44,
	0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x34,
	0x0a, 0x14, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x22, 0x5b, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x5e, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb2, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x55, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73,
	0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c,
	0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd8, 0x01, 0x0a, 0x0f, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x69, 0x64, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x06, 0x52, 0x05, 0x63, 0x69, 0x64, 0x72,
	0x73, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x71, 0x64, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x06, 0x52, 0x05, 0x66, 0x71, 0x64, 0x6e, 0x73, 0x3a, 0x73, 0xea, 0x41,
	0x70, 0x0a, 0x22, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x61, 0x70, 0x5f, 0x74, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x7d, 0x22, 0x30, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x49, 0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x61,
	0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x0c, 0x69, 0x61, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x70,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69,
	0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd1, 0x01, 0x0a, 0x0b, 0x49, 0x61, 0x70, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4c, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5b,
	0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xb9, 0x02, 0x0a, 0x0e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x46,
	0x0a, 0x0d, 0x67, 0x63, 0x69, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x69, 0x70,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0c, 0x67, 0x63, 0x69, 0x70, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x46, 0x0a, 0x0d, 0x63, 0x6f, 0x72, 0x73, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x0c, 0x63, 0x6f, 0x72, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x49,
	0x0a, 0x0e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x41, 0x75,
	0x74, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0d, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x0f, 0x72, 0x65, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x75, 0x74, 0x68, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x75, 0x74, 0x68, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x71, 0x0a, 0x0c, 0x47, 0x63, 0x69, 0x70, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x42, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6c, 0x6f,
	0x67, 0x69, 0x6e, 0x50, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x22, 0x58, 0x0a, 0x0c, 0x43, 0x6f,
	0x72, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x48, 0x74, 0x74, 0x70, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x4c, 0x0a, 0x0d, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x68,
	0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x48, 0x69,
	0x6e, 0x74, 0x22, 0xe9, 0x02, 0x0a, 0x0e, 0x52, 0x65, 0x61, 0x75, 0x74, 0x68, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x42, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x75,
	0x74, 0x68, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x32, 0x0a, 0x07, 0x6d, 0x61, 0x78,
	0x5f, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x12, 0x4f, 0x0a,
	0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x75, 0x74, 0x68, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x49,
	0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x48,
	0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50,
	0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x43,
	0x55, 0x52, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x03, 0x22, 0x43, 0x0a, 0x0a, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x55, 0x4d, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x02, 0x22, 0x8b,
	0x02, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x0a, 0x0c, 0x63, 0x73, 0x6d, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x73, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b,
	0x63, 0x73, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6c, 0x0a, 0x1b, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e,
	0x69, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x18, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x61, 0x67,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x0a, 0x0d, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c,
	0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x22, 0x4c, 0x0a, 0x0b,
	0x43, 0x73, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x72,
	0x63, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x61, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a,
	0x72, 0x63, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x41, 0x75, 0x64, 0x22, 0xcb, 0x01, 0x0a, 0x18, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x51, 0x0a, 0x16, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e,
	0x69, 0x65, 0x64, 0x50, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x5c, 0x0a, 0x1c, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68,
	0x6f, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x69, 0x22, 0x30, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x48, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x32, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x06, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x73, 0x22, 0x68, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x72,
	0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x72, 0x61,
	0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x22, 0x2a,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7f, 0x0a, 0x24, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbf, 0x01, 0x0a, 0x25,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72,
	0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e, 0x0a, 0x1c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x61, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x19, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb7, 0x01,
	0x0a, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x1b, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x61, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x22, 0x3d, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x45, 0x0a, 0x2a, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x40, 0x0a,
	0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41,
	0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa3, 0x01, 0x0a, 0x05, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x6f, 0x72, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6f, 0x72, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x73, 0x0a, 0x18, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x32, 0xc0, 0x0e, 0x0a, 0x1e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x74, 0x0a,
	0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23,
	0x22, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x2a, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x3a, 0x01, 0x2a, 0x12, 0x74, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x29,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x12, 0x9a, 0x01, 0x0a, 0x12, 0x54, 0x65,
	0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x22, 0x24, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x2a, 0x2a, 0x7d,
	0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0x81, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x49, 0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x70, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12,
	0x19, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x3a, 0x69,
	0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xa2, 0x01, 0x0a, 0x11, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x61, 0x70,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x32, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x69, 0x61, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x2a, 0x2a, 0x7d, 0x3a, 0x69, 0x61, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x3a, 0x0c, 0x69, 0x61, 0x70, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0xc7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65,
	0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x61,
	0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf7, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x84, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x61,
	0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x3a, 0x11, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0xda, 0x41, 0x2d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x74,
	0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x12, 0xb4, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x61, 0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xac, 0x01, 0x0a, 0x15, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x61,
	0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x75, 0x6e,
	0x6e, 0x65, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x86, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x60, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x75, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x61,
	0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x11, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0xda, 0x41, 0x1d, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64,
	0x65, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x1a, 0x46, 0xca, 0x41, 0x12, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0xa8, 0x0c,
	0x0a, 0x1e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x85, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x22, 0x2d, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x22, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x73, 0x3a, 0x05, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x74, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x73, 0x3a, 0x1b, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x61,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x12, 0xda, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61,
	0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc9,
	0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77,
	0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x23, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72,
	0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xb8, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65, 0x50, 0x72, 0x6f,
	0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61,
	0x72, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x42, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72,
	0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x1a, 0x46, 0xca, 0x41, 0x12, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf2, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x61,
	0x70, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x69, 0x61, 0x70, 0x2f, 0x76, 0x31, 0x3b, 0x69, 0x61, 0x70, 0xaa, 0x02,
	0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x49, 0x61,
	0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x49, 0x61, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x49, 0x61, 0x70, 0x3a,
	0x3a, 0x56, 0x31, 0xea, 0x41, 0x57, 0x0a, 0x21, 0x69, 0x61, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x75, 0x6e, 0x6e, 0x65,
	0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x61,
	0x70, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_iap_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_iap_v1_service_proto_rawDescData = file_google_cloud_iap_v1_service_proto_rawDesc
)

func file_google_cloud_iap_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_iap_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_iap_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_iap_v1_service_proto_rawDescData)
	})
	return file_google_cloud_iap_v1_service_proto_rawDescData
}

var file_google_cloud_iap_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_iap_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 30)
var file_google_cloud_iap_v1_service_proto_goTypes = []interface{}{
	(ReauthSettings_Method)(0),                         // 0: google.cloud.iap.v1.ReauthSettings.Method
	(ReauthSettings_PolicyType)(0),                     // 1: google.cloud.iap.v1.ReauthSettings.PolicyType
	(*ListTunnelDestGroupsRequest)(nil),                // 2: google.cloud.iap.v1.ListTunnelDestGroupsRequest
	(*ListTunnelDestGroupsResponse)(nil),               // 3: google.cloud.iap.v1.ListTunnelDestGroupsResponse
	(*CreateTunnelDestGroupRequest)(nil),               // 4: google.cloud.iap.v1.CreateTunnelDestGroupRequest
	(*GetTunnelDestGroupRequest)(nil),                  // 5: google.cloud.iap.v1.GetTunnelDestGroupRequest
	(*DeleteTunnelDestGroupRequest)(nil),               // 6: google.cloud.iap.v1.DeleteTunnelDestGroupRequest
	(*UpdateTunnelDestGroupRequest)(nil),               // 7: google.cloud.iap.v1.UpdateTunnelDestGroupRequest
	(*TunnelDestGroup)(nil),                            // 8: google.cloud.iap.v1.TunnelDestGroup
	(*GetIapSettingsRequest)(nil),                      // 9: google.cloud.iap.v1.GetIapSettingsRequest
	(*UpdateIapSettingsRequest)(nil),                   // 10: google.cloud.iap.v1.UpdateIapSettingsRequest
	(*IapSettings)(nil),                                // 11: google.cloud.iap.v1.IapSettings
	(*AccessSettings)(nil),                             // 12: google.cloud.iap.v1.AccessSettings
	(*GcipSettings)(nil),                               // 13: google.cloud.iap.v1.GcipSettings
	(*CorsSettings)(nil),                               // 14: google.cloud.iap.v1.CorsSettings
	(*OAuthSettings)(nil),                              // 15: google.cloud.iap.v1.OAuthSettings
	(*ReauthSettings)(nil),                             // 16: google.cloud.iap.v1.ReauthSettings
	(*ApplicationSettings)(nil),                        // 17: google.cloud.iap.v1.ApplicationSettings
	(*CsmSettings)(nil),                                // 18: google.cloud.iap.v1.CsmSettings
	(*AccessDeniedPageSettings)(nil),                   // 19: google.cloud.iap.v1.AccessDeniedPageSettings
	(*ListBrandsRequest)(nil),                          // 20: google.cloud.iap.v1.ListBrandsRequest
	(*ListBrandsResponse)(nil),                         // 21: google.cloud.iap.v1.ListBrandsResponse
	(*CreateBrandRequest)(nil),                         // 22: google.cloud.iap.v1.CreateBrandRequest
	(*GetBrandRequest)(nil),                            // 23: google.cloud.iap.v1.GetBrandRequest
	(*ListIdentityAwareProxyClientsRequest)(nil),       // 24: google.cloud.iap.v1.ListIdentityAwareProxyClientsRequest
	(*ListIdentityAwareProxyClientsResponse)(nil),      // 25: google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse
	(*CreateIdentityAwareProxyClientRequest)(nil),      // 26: google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest
	(*GetIdentityAwareProxyClientRequest)(nil),         // 27: google.cloud.iap.v1.GetIdentityAwareProxyClientRequest
	(*ResetIdentityAwareProxyClientSecretRequest)(nil), // 28: google.cloud.iap.v1.ResetIdentityAwareProxyClientSecretRequest
	(*DeleteIdentityAwareProxyClientRequest)(nil),      // 29: google.cloud.iap.v1.DeleteIdentityAwareProxyClientRequest
	(*Brand)(nil),                                      // 30: google.cloud.iap.v1.Brand
	(*IdentityAwareProxyClient)(nil),                   // 31: google.cloud.iap.v1.IdentityAwareProxyClient
	(*fieldmaskpb.FieldMask)(nil),                      // 32: google.protobuf.FieldMask
	(*wrapperspb.StringValue)(nil),                     // 33: google.protobuf.StringValue
	(*wrapperspb.BoolValue)(nil),                       // 34: google.protobuf.BoolValue
	(*durationpb.Duration)(nil),                        // 35: google.protobuf.Duration
	(*v1.SetIamPolicyRequest)(nil),                     // 36: google.iam.v1.SetIamPolicyRequest
	(*v1.GetIamPolicyRequest)(nil),                     // 37: google.iam.v1.GetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),               // 38: google.iam.v1.TestIamPermissionsRequest
	(*v1.Policy)(nil),                                  // 39: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),              // 40: google.iam.v1.TestIamPermissionsResponse
	(*emptypb.Empty)(nil),                              // 41: google.protobuf.Empty
}
var file_google_cloud_iap_v1_service_proto_depIdxs = []int32{
	8,  // 0: google.cloud.iap.v1.ListTunnelDestGroupsResponse.tunnel_dest_groups:type_name -> google.cloud.iap.v1.TunnelDestGroup
	8,  // 1: google.cloud.iap.v1.CreateTunnelDestGroupRequest.tunnel_dest_group:type_name -> google.cloud.iap.v1.TunnelDestGroup
	8,  // 2: google.cloud.iap.v1.UpdateTunnelDestGroupRequest.tunnel_dest_group:type_name -> google.cloud.iap.v1.TunnelDestGroup
	32, // 3: google.cloud.iap.v1.UpdateTunnelDestGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 4: google.cloud.iap.v1.UpdateIapSettingsRequest.iap_settings:type_name -> google.cloud.iap.v1.IapSettings
	32, // 5: google.cloud.iap.v1.UpdateIapSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 6: google.cloud.iap.v1.IapSettings.access_settings:type_name -> google.cloud.iap.v1.AccessSettings
	17, // 7: google.cloud.iap.v1.IapSettings.application_settings:type_name -> google.cloud.iap.v1.ApplicationSettings
	13, // 8: google.cloud.iap.v1.AccessSettings.gcip_settings:type_name -> google.cloud.iap.v1.GcipSettings
	14, // 9: google.cloud.iap.v1.AccessSettings.cors_settings:type_name -> google.cloud.iap.v1.CorsSettings
	15, // 10: google.cloud.iap.v1.AccessSettings.oauth_settings:type_name -> google.cloud.iap.v1.OAuthSettings
	16, // 11: google.cloud.iap.v1.AccessSettings.reauth_settings:type_name -> google.cloud.iap.v1.ReauthSettings
	33, // 12: google.cloud.iap.v1.GcipSettings.login_page_uri:type_name -> google.protobuf.StringValue
	34, // 13: google.cloud.iap.v1.CorsSettings.allow_http_options:type_name -> google.protobuf.BoolValue
	33, // 14: google.cloud.iap.v1.OAuthSettings.login_hint:type_name -> google.protobuf.StringValue
	0,  // 15: google.cloud.iap.v1.ReauthSettings.method:type_name -> google.cloud.iap.v1.ReauthSettings.Method
	35, // 16: google.cloud.iap.v1.ReauthSettings.max_age:type_name -> google.protobuf.Duration
	1,  // 17: google.cloud.iap.v1.ReauthSettings.policy_type:type_name -> google.cloud.iap.v1.ReauthSettings.PolicyType
	18, // 18: google.cloud.iap.v1.ApplicationSettings.csm_settings:type_name -> google.cloud.iap.v1.CsmSettings
	19, // 19: google.cloud.iap.v1.ApplicationSettings.access_denied_page_settings:type_name -> google.cloud.iap.v1.AccessDeniedPageSettings
	33, // 20: google.cloud.iap.v1.ApplicationSettings.cookie_domain:type_name -> google.protobuf.StringValue
	33, // 21: google.cloud.iap.v1.CsmSettings.rctoken_aud:type_name -> google.protobuf.StringValue
	33, // 22: google.cloud.iap.v1.AccessDeniedPageSettings.access_denied_page_uri:type_name -> google.protobuf.StringValue
	34, // 23: google.cloud.iap.v1.AccessDeniedPageSettings.generate_troubleshooting_uri:type_name -> google.protobuf.BoolValue
	30, // 24: google.cloud.iap.v1.ListBrandsResponse.brands:type_name -> google.cloud.iap.v1.Brand
	30, // 25: google.cloud.iap.v1.CreateBrandRequest.brand:type_name -> google.cloud.iap.v1.Brand
	31, // 26: google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse.identity_aware_proxy_clients:type_name -> google.cloud.iap.v1.IdentityAwareProxyClient
	31, // 27: google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest.identity_aware_proxy_client:type_name -> google.cloud.iap.v1.IdentityAwareProxyClient
	36, // 28: google.cloud.iap.v1.IdentityAwareProxyAdminService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	37, // 29: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	38, // 30: google.cloud.iap.v1.IdentityAwareProxyAdminService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	9,  // 31: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetIapSettings:input_type -> google.cloud.iap.v1.GetIapSettingsRequest
	10, // 32: google.cloud.iap.v1.IdentityAwareProxyAdminService.UpdateIapSettings:input_type -> google.cloud.iap.v1.UpdateIapSettingsRequest
	2,  // 33: google.cloud.iap.v1.IdentityAwareProxyAdminService.ListTunnelDestGroups:input_type -> google.cloud.iap.v1.ListTunnelDestGroupsRequest
	4,  // 34: google.cloud.iap.v1.IdentityAwareProxyAdminService.CreateTunnelDestGroup:input_type -> google.cloud.iap.v1.CreateTunnelDestGroupRequest
	5,  // 35: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetTunnelDestGroup:input_type -> google.cloud.iap.v1.GetTunnelDestGroupRequest
	6,  // 36: google.cloud.iap.v1.IdentityAwareProxyAdminService.DeleteTunnelDestGroup:input_type -> google.cloud.iap.v1.DeleteTunnelDestGroupRequest
	7,  // 37: google.cloud.iap.v1.IdentityAwareProxyAdminService.UpdateTunnelDestGroup:input_type -> google.cloud.iap.v1.UpdateTunnelDestGroupRequest
	20, // 38: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ListBrands:input_type -> google.cloud.iap.v1.ListBrandsRequest
	22, // 39: google.cloud.iap.v1.IdentityAwareProxyOAuthService.CreateBrand:input_type -> google.cloud.iap.v1.CreateBrandRequest
	23, // 40: google.cloud.iap.v1.IdentityAwareProxyOAuthService.GetBrand:input_type -> google.cloud.iap.v1.GetBrandRequest
	26, // 41: google.cloud.iap.v1.IdentityAwareProxyOAuthService.CreateIdentityAwareProxyClient:input_type -> google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest
	24, // 42: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ListIdentityAwareProxyClients:input_type -> google.cloud.iap.v1.ListIdentityAwareProxyClientsRequest
	27, // 43: google.cloud.iap.v1.IdentityAwareProxyOAuthService.GetIdentityAwareProxyClient:input_type -> google.cloud.iap.v1.GetIdentityAwareProxyClientRequest
	28, // 44: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ResetIdentityAwareProxyClientSecret:input_type -> google.cloud.iap.v1.ResetIdentityAwareProxyClientSecretRequest
	29, // 45: google.cloud.iap.v1.IdentityAwareProxyOAuthService.DeleteIdentityAwareProxyClient:input_type -> google.cloud.iap.v1.DeleteIdentityAwareProxyClientRequest
	39, // 46: google.cloud.iap.v1.IdentityAwareProxyAdminService.SetIamPolicy:output_type -> google.iam.v1.Policy
	39, // 47: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetIamPolicy:output_type -> google.iam.v1.Policy
	40, // 48: google.cloud.iap.v1.IdentityAwareProxyAdminService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	11, // 49: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetIapSettings:output_type -> google.cloud.iap.v1.IapSettings
	11, // 50: google.cloud.iap.v1.IdentityAwareProxyAdminService.UpdateIapSettings:output_type -> google.cloud.iap.v1.IapSettings
	3,  // 51: google.cloud.iap.v1.IdentityAwareProxyAdminService.ListTunnelDestGroups:output_type -> google.cloud.iap.v1.ListTunnelDestGroupsResponse
	8,  // 52: google.cloud.iap.v1.IdentityAwareProxyAdminService.CreateTunnelDestGroup:output_type -> google.cloud.iap.v1.TunnelDestGroup
	8,  // 53: google.cloud.iap.v1.IdentityAwareProxyAdminService.GetTunnelDestGroup:output_type -> google.cloud.iap.v1.TunnelDestGroup
	41, // 54: google.cloud.iap.v1.IdentityAwareProxyAdminService.DeleteTunnelDestGroup:output_type -> google.protobuf.Empty
	8,  // 55: google.cloud.iap.v1.IdentityAwareProxyAdminService.UpdateTunnelDestGroup:output_type -> google.cloud.iap.v1.TunnelDestGroup
	21, // 56: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ListBrands:output_type -> google.cloud.iap.v1.ListBrandsResponse
	30, // 57: google.cloud.iap.v1.IdentityAwareProxyOAuthService.CreateBrand:output_type -> google.cloud.iap.v1.Brand
	30, // 58: google.cloud.iap.v1.IdentityAwareProxyOAuthService.GetBrand:output_type -> google.cloud.iap.v1.Brand
	31, // 59: google.cloud.iap.v1.IdentityAwareProxyOAuthService.CreateIdentityAwareProxyClient:output_type -> google.cloud.iap.v1.IdentityAwareProxyClient
	25, // 60: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ListIdentityAwareProxyClients:output_type -> google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse
	31, // 61: google.cloud.iap.v1.IdentityAwareProxyOAuthService.GetIdentityAwareProxyClient:output_type -> google.cloud.iap.v1.IdentityAwareProxyClient
	31, // 62: google.cloud.iap.v1.IdentityAwareProxyOAuthService.ResetIdentityAwareProxyClientSecret:output_type -> google.cloud.iap.v1.IdentityAwareProxyClient
	41, // 63: google.cloud.iap.v1.IdentityAwareProxyOAuthService.DeleteIdentityAwareProxyClient:output_type -> google.protobuf.Empty
	46, // [46:64] is the sub-list for method output_type
	28, // [28:46] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_iap_v1_service_proto_init() }
func file_google_cloud_iap_v1_service_proto_init() {
	if File_google_cloud_iap_v1_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_iap_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTunnelDestGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTunnelDestGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTunnelDestGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTunnelDestGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTunnelDestGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTunnelDestGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TunnelDestGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIapSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIapSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IapSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcipSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CorsSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuthSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReauthSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplicationSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CsmSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessDeniedPageSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBrandsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBrandsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBrandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBrandRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIdentityAwareProxyClientsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIdentityAwareProxyClientsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIdentityAwareProxyClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIdentityAwareProxyClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetIdentityAwareProxyClientSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIdentityAwareProxyClientRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Brand); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_iap_v1_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdentityAwareProxyClient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_iap_v1_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   30,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_cloud_iap_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_iap_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_iap_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_iap_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_iap_v1_service_proto = out.File
	file_google_cloud_iap_v1_service_proto_rawDesc = nil
	file_google_cloud_iap_v1_service_proto_goTypes = nil
	file_google_cloud_iap_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IdentityAwareProxyAdminServiceClient is the client API for IdentityAwareProxyAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IdentityAwareProxyAdminServiceClient interface {
	// Sets the access control policy for an Identity-Aware Proxy protected
	// resource. Replaces any existing policy.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for an Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Gets the IAP settings on a particular IAP protected resource.
	GetIapSettings(ctx context.Context, in *GetIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error)
	// Updates the IAP settings on a particular IAP protected resource. It
	// replaces all fields unless the `update_mask` is set.
	UpdateIapSettings(ctx context.Context, in *UpdateIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error)
	// Lists the existing TunnelDestGroups. To group across all locations, use a
	// `-` as the location ID. For example:
	// `/v1/projects/123/iap_tunnel/locations/-/destGroups`
	ListTunnelDestGroups(ctx context.Context, in *ListTunnelDestGroupsRequest, opts ...grpc.CallOption) (*ListTunnelDestGroupsResponse, error)
	// Creates a new TunnelDestGroup.
	CreateTunnelDestGroup(ctx context.Context, in *CreateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
	// Retrieves an existing TunnelDestGroup.
	GetTunnelDestGroup(ctx context.Context, in *GetTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
	// Deletes a TunnelDestGroup.
	DeleteTunnelDestGroup(ctx context.Context, in *DeleteTunnelDestGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a TunnelDestGroup.
	UpdateTunnelDestGroup(ctx context.Context, in *UpdateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error)
}

type identityAwareProxyAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIdentityAwareProxyAdminServiceClient(cc grpc.ClientConnInterface) IdentityAwareProxyAdminServiceClient {
	return &identityAwareProxyAdminServiceClient{cc}
}

func (c *identityAwareProxyAdminServiceClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetIapSettings(ctx context.Context, in *GetIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error) {
	out := new(IapSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIapSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) UpdateIapSettings(ctx context.Context, in *UpdateIapSettingsRequest, opts ...grpc.CallOption) (*IapSettings, error) {
	out := new(IapSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateIapSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) ListTunnelDestGroups(ctx context.Context, in *ListTunnelDestGroupsRequest, opts ...grpc.CallOption) (*ListTunnelDestGroupsResponse, error) {
	out := new(ListTunnelDestGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/ListTunnelDestGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) CreateTunnelDestGroup(ctx context.Context, in *CreateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/CreateTunnelDestGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) GetTunnelDestGroup(ctx context.Context, in *GetTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetTunnelDestGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) DeleteTunnelDestGroup(ctx context.Context, in *DeleteTunnelDestGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/DeleteTunnelDestGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyAdminServiceClient) UpdateTunnelDestGroup(ctx context.Context, in *UpdateTunnelDestGroupRequest, opts ...grpc.CallOption) (*TunnelDestGroup, error) {
	out := new(TunnelDestGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateTunnelDestGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IdentityAwareProxyAdminServiceServer is the server API for IdentityAwareProxyAdminService service.
type IdentityAwareProxyAdminServiceServer interface {
	// Sets the access control policy for an Identity-Aware Proxy protected
	// resource. Replaces any existing policy.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for an Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the Identity-Aware Proxy protected
	// resource.
	// More information about managing access via IAP can be found at:
	// https://cloud.google.com/iap/docs/managing-access#managing_access_via_the_api
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Gets the IAP settings on a particular IAP protected resource.
	GetIapSettings(context.Context, *GetIapSettingsRequest) (*IapSettings, error)
	// Updates the IAP settings on a particular IAP protected resource. It
	// replaces all fields unless the `update_mask` is set.
	UpdateIapSettings(context.Context, *UpdateIapSettingsRequest) (*IapSettings, error)
	// Lists the existing TunnelDestGroups. To group across all locations, use a
	// `-` as the location ID. For example:
	// `/v1/projects/123/iap_tunnel/locations/-/destGroups`
	ListTunnelDestGroups(context.Context, *ListTunnelDestGroupsRequest) (*ListTunnelDestGroupsResponse, error)
	// Creates a new TunnelDestGroup.
	CreateTunnelDestGroup(context.Context, *CreateTunnelDestGroupRequest) (*TunnelDestGroup, error)
	// Retrieves an existing TunnelDestGroup.
	GetTunnelDestGroup(context.Context, *GetTunnelDestGroupRequest) (*TunnelDestGroup, error)
	// Deletes a TunnelDestGroup.
	DeleteTunnelDestGroup(context.Context, *DeleteTunnelDestGroupRequest) (*emptypb.Empty, error)
	// Updates a TunnelDestGroup.
	UpdateTunnelDestGroup(context.Context, *UpdateTunnelDestGroupRequest) (*TunnelDestGroup, error)
}

// UnimplementedIdentityAwareProxyAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedIdentityAwareProxyAdminServiceServer struct {
}

func (*UnimplementedIdentityAwareProxyAdminServiceServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) GetIapSettings(context.Context, *GetIapSettingsRequest) (*IapSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIapSettings not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) UpdateIapSettings(context.Context, *UpdateIapSettingsRequest) (*IapSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIapSettings not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) ListTunnelDestGroups(context.Context, *ListTunnelDestGroupsRequest) (*ListTunnelDestGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTunnelDestGroups not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) CreateTunnelDestGroup(context.Context, *CreateTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTunnelDestGroup not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) GetTunnelDestGroup(context.Context, *GetTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTunnelDestGroup not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) DeleteTunnelDestGroup(context.Context, *DeleteTunnelDestGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTunnelDestGroup not implemented")
}
func (*UnimplementedIdentityAwareProxyAdminServiceServer) UpdateTunnelDestGroup(context.Context, *UpdateTunnelDestGroupRequest) (*TunnelDestGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTunnelDestGroup not implemented")
}

func RegisterIdentityAwareProxyAdminServiceServer(s *grpc.Server, srv IdentityAwareProxyAdminServiceServer) {
	s.RegisterService(&_IdentityAwareProxyAdminService_serviceDesc, srv)
}

func _IdentityAwareProxyAdminService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetIapSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIapSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIapSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetIapSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetIapSettings(ctx, req.(*GetIapSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_UpdateIapSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIapSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateIapSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateIapSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateIapSettings(ctx, req.(*UpdateIapSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_ListTunnelDestGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTunnelDestGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).ListTunnelDestGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/ListTunnelDestGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).ListTunnelDestGroups(ctx, req.(*ListTunnelDestGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_CreateTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).CreateTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/CreateTunnelDestGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).CreateTunnelDestGroup(ctx, req.(*CreateTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_GetTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).GetTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/GetTunnelDestGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).GetTunnelDestGroup(ctx, req.(*GetTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_DeleteTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).DeleteTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/DeleteTunnelDestGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).DeleteTunnelDestGroup(ctx, req.(*DeleteTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyAdminService_UpdateTunnelDestGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTunnelDestGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateTunnelDestGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyAdminService/UpdateTunnelDestGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyAdminServiceServer).UpdateTunnelDestGroup(ctx, req.(*UpdateTunnelDestGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IdentityAwareProxyAdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iap.v1.IdentityAwareProxyAdminService",
	HandlerType: (*IdentityAwareProxyAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetIamPolicy",
			Handler:    _IdentityAwareProxyAdminService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IdentityAwareProxyAdminService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IdentityAwareProxyAdminService_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetIapSettings",
			Handler:    _IdentityAwareProxyAdminService_GetIapSettings_Handler,
		},
		{
			MethodName: "UpdateIapSettings",
			Handler:    _IdentityAwareProxyAdminService_UpdateIapSettings_Handler,
		},
		{
			MethodName: "ListTunnelDestGroups",
			Handler:    _IdentityAwareProxyAdminService_ListTunnelDestGroups_Handler,
		},
		{
			MethodName: "CreateTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_CreateTunnelDestGroup_Handler,
		},
		{
			MethodName: "GetTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_GetTunnelDestGroup_Handler,
		},
		{
			MethodName: "DeleteTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_DeleteTunnelDestGroup_Handler,
		},
		{
			MethodName: "UpdateTunnelDestGroup",
			Handler:    _IdentityAwareProxyAdminService_UpdateTunnelDestGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iap/v1/service.proto",
}

// IdentityAwareProxyOAuthServiceClient is the client API for IdentityAwareProxyOAuthService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IdentityAwareProxyOAuthServiceClient interface {
	// Lists the existing brands for the project.
	ListBrands(ctx context.Context, in *ListBrandsRequest, opts ...grpc.CallOption) (*ListBrandsResponse, error)
	// Constructs a new OAuth brand for the project if one does not exist.
	// The created brand is "internal only", meaning that OAuth clients created
	// under it only accept requests from users who belong to the same Google
	// Workspace organization as the project. The brand is created in an
	// un-reviewed status. NOTE: The "internal only" status can be manually
	// changed in the Google Cloud Console. Requires that a brand does not already
	// exist for the project, and that the specified support email is owned by the
	// caller.
	CreateBrand(ctx context.Context, in *CreateBrandRequest, opts ...grpc.CallOption) (*Brand, error)
	// Retrieves the OAuth brand of the project.
	GetBrand(ctx context.Context, in *GetBrandRequest, opts ...grpc.CallOption) (*Brand, error)
	// Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned
	// by IAP. Requires that the brand for the project exists and that it is
	// set for internal-only use.
	CreateIdentityAwareProxyClient(ctx context.Context, in *CreateIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Lists the existing clients for the brand.
	ListIdentityAwareProxyClients(ctx context.Context, in *ListIdentityAwareProxyClientsRequest, opts ...grpc.CallOption) (*ListIdentityAwareProxyClientsResponse, error)
	// Retrieves an Identity Aware Proxy (IAP) OAuth client.
	// Requires that the client is owned by IAP.
	GetIdentityAwareProxyClient(ctx context.Context, in *GetIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Resets an Identity Aware Proxy (IAP) OAuth client secret. Useful if the
	// secret was compromised. Requires that the client is owned by IAP.
	ResetIdentityAwareProxyClientSecret(ctx context.Context, in *ResetIdentityAwareProxyClientSecretRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error)
	// Deletes an Identity Aware Proxy (IAP) OAuth client. Useful for removing
	// obsolete clients, managing the number of clients in a given project, and
	// cleaning up after tests. Requires that the client is owned by IAP.
	DeleteIdentityAwareProxyClient(ctx context.Context, in *DeleteIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type identityAwareProxyOAuthServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewIdentityAwareProxyOAuthServiceClient(cc grpc.ClientConnInterface) IdentityAwareProxyOAuthServiceClient {
	return &identityAwareProxyOAuthServiceClient{cc}
}

func (c *identityAwareProxyOAuthServiceClient) ListBrands(ctx context.Context, in *ListBrandsRequest, opts ...grpc.CallOption) (*ListBrandsResponse, error) {
	out := new(ListBrandsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListBrands", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) CreateBrand(ctx context.Context, in *CreateBrandRequest, opts ...grpc.CallOption) (*Brand, error) {
	out := new(Brand)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateBrand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) GetBrand(ctx context.Context, in *GetBrandRequest, opts ...grpc.CallOption) (*Brand, error) {
	out := new(Brand)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetBrand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) CreateIdentityAwareProxyClient(ctx context.Context, in *CreateIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateIdentityAwareProxyClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) ListIdentityAwareProxyClients(ctx context.Context, in *ListIdentityAwareProxyClientsRequest, opts ...grpc.CallOption) (*ListIdentityAwareProxyClientsResponse, error) {
	out := new(ListIdentityAwareProxyClientsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListIdentityAwareProxyClients", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) GetIdentityAwareProxyClient(ctx context.Context, in *GetIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetIdentityAwareProxyClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) ResetIdentityAwareProxyClientSecret(ctx context.Context, in *ResetIdentityAwareProxyClientSecretRequest, opts ...grpc.CallOption) (*IdentityAwareProxyClient, error) {
	out := new(IdentityAwareProxyClient)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ResetIdentityAwareProxyClientSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityAwareProxyOAuthServiceClient) DeleteIdentityAwareProxyClient(ctx context.Context, in *DeleteIdentityAwareProxyClientRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/DeleteIdentityAwareProxyClient", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IdentityAwareProxyOAuthServiceServer is the server API for IdentityAwareProxyOAuthService service.
type IdentityAwareProxyOAuthServiceServer interface {
	// Lists the existing brands for the project.
	ListBrands(context.Context, *ListBrandsRequest) (*ListBrandsResponse, error)
	// Constructs a new OAuth brand for the project if one does not exist.
	// The created brand is "internal only", meaning that OAuth clients created
	// under it only accept requests from users who belong to the same Google
	// Workspace organization as the project. The brand is created in an
	// un-reviewed status. NOTE: The "internal only" status can be manually
	// changed in the Google Cloud Console. Requires that a brand does not already
	// exist for the project, and that the specified support email is owned by the
	// caller.
	CreateBrand(context.Context, *CreateBrandRequest) (*Brand, error)
	// Retrieves the OAuth brand of the project.
	GetBrand(context.Context, *GetBrandRequest) (*Brand, error)
	// Creates an Identity Aware Proxy (IAP) OAuth client. The client is owned
	// by IAP. Requires that the brand for the project exists and that it is
	// set for internal-only use.
	CreateIdentityAwareProxyClient(context.Context, *CreateIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error)
	// Lists the existing clients for the brand.
	ListIdentityAwareProxyClients(context.Context, *ListIdentityAwareProxyClientsRequest) (*ListIdentityAwareProxyClientsResponse, error)
	// Retrieves an Identity Aware Proxy (IAP) OAuth client.
	// Requires that the client is owned by IAP.
	GetIdentityAwareProxyClient(context.Context, *GetIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error)
	// Resets an Identity Aware Proxy (IAP) OAuth client secret. Useful if the
	// secret was compromised. Requires that the client is owned by IAP.
	ResetIdentityAwareProxyClientSecret(context.Context, *ResetIdentityAwareProxyClientSecretRequest) (*IdentityAwareProxyClient, error)
	// Deletes an Identity Aware Proxy (IAP) OAuth client. Useful for removing
	// obsolete clients, managing the number of clients in a given project, and
	// cleaning up after tests. Requires that the client is owned by IAP.
	DeleteIdentityAwareProxyClient(context.Context, *DeleteIdentityAwareProxyClientRequest) (*emptypb.Empty, error)
}

// UnimplementedIdentityAwareProxyOAuthServiceServer can be embedded to have forward compatible implementations.
type UnimplementedIdentityAwareProxyOAuthServiceServer struct {
}

func (*UnimplementedIdentityAwareProxyOAuthServiceServer) ListBrands(context.Context, *ListBrandsRequest) (*ListBrandsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBrands not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) CreateBrand(context.Context, *CreateBrandRequest) (*Brand, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBrand not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) GetBrand(context.Context, *GetBrandRequest) (*Brand, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBrand not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) CreateIdentityAwareProxyClient(context.Context, *CreateIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIdentityAwareProxyClient not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) ListIdentityAwareProxyClients(context.Context, *ListIdentityAwareProxyClientsRequest) (*ListIdentityAwareProxyClientsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIdentityAwareProxyClients not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) GetIdentityAwareProxyClient(context.Context, *GetIdentityAwareProxyClientRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIdentityAwareProxyClient not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) ResetIdentityAwareProxyClientSecret(context.Context, *ResetIdentityAwareProxyClientSecretRequest) (*IdentityAwareProxyClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetIdentityAwareProxyClientSecret not implemented")
}
func (*UnimplementedIdentityAwareProxyOAuthServiceServer) DeleteIdentityAwareProxyClient(context.Context, *DeleteIdentityAwareProxyClientRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIdentityAwareProxyClient not implemented")
}

func RegisterIdentityAwareProxyOAuthServiceServer(s *grpc.Server, srv IdentityAwareProxyOAuthServiceServer) {
	s.RegisterService(&_IdentityAwareProxyOAuthService_serviceDesc, srv)
}

func _IdentityAwareProxyOAuthService_ListBrands_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBrandsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListBrands(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListBrands",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListBrands(ctx, req.(*ListBrandsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_CreateBrand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBrandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateBrand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateBrand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateBrand(ctx, req.(*CreateBrandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_GetBrand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBrandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetBrand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetBrand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetBrand(ctx, req.(*GetBrandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateIdentityAwareProxyClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).CreateIdentityAwareProxyClient(ctx, req.(*CreateIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIdentityAwareProxyClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListIdentityAwareProxyClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListIdentityAwareProxyClients",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ListIdentityAwareProxyClients(ctx, req.(*ListIdentityAwareProxyClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetIdentityAwareProxyClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).GetIdentityAwareProxyClient(ctx, req.(*GetIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetIdentityAwareProxyClientSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).ResetIdentityAwareProxyClientSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/ResetIdentityAwareProxyClientSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).ResetIdentityAwareProxyClientSecret(ctx, req.(*ResetIdentityAwareProxyClientSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIdentityAwareProxyClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityAwareProxyOAuthServiceServer).DeleteIdentityAwareProxyClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iap.v1.IdentityAwareProxyOAuthService/DeleteIdentityAwareProxyClient",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityAwareProxyOAuthServiceServer).DeleteIdentityAwareProxyClient(ctx, req.(*DeleteIdentityAwareProxyClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IdentityAwareProxyOAuthService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iap.v1.IdentityAwareProxyOAuthService",
	HandlerType: (*IdentityAwareProxyOAuthServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBrands",
			Handler:    _IdentityAwareProxyOAuthService_ListBrands_Handler,
		},
		{
			MethodName: "CreateBrand",
			Handler:    _IdentityAwareProxyOAuthService_CreateBrand_Handler,
		},
		{
			MethodName: "GetBrand",
			Handler:    _IdentityAwareProxyOAuthService_GetBrand_Handler,
		},
		{
			MethodName: "CreateIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_CreateIdentityAwareProxyClient_Handler,
		},
		{
			MethodName: "ListIdentityAwareProxyClients",
			Handler:    _IdentityAwareProxyOAuthService_ListIdentityAwareProxyClients_Handler,
		},
		{
			MethodName: "GetIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_GetIdentityAwareProxyClient_Handler,
		},
		{
			MethodName: "ResetIdentityAwareProxyClientSecret",
			Handler:    _IdentityAwareProxyOAuthService_ResetIdentityAwareProxyClientSecret_Handler,
		},
		{
			MethodName: "DeleteIdentityAwareProxyClient",
			Handler:    _IdentityAwareProxyOAuthService_DeleteIdentityAwareProxyClient_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iap/v1/service.proto",
}
