// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/timeseriesinsights/v1/timeseries_insights.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_INTERNAL_TIMESERIES_INSIGHTS_CONTROLLER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_INTERNAL_TIMESERIES_INSIGHTS_CONTROLLER_CONNECTION_IMPL_H

#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_retry_traits.h"
#include "google/cloud/timeseriesinsights/v1/internal/timeseries_insights_controller_stub.h"
#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_connection.h"
#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_connection_idempotency_policy.h"
#include "google/cloud/timeseriesinsights/v1/timeseries_insights_controller_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace timeseriesinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class TimeseriesInsightsControllerConnectionImpl
    : public timeseriesinsights_v1::TimeseriesInsightsControllerConnection {
 public:
  ~TimeseriesInsightsControllerConnectionImpl() override = default;

  TimeseriesInsightsControllerConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          timeseriesinsights_v1_internal::TimeseriesInsightsControllerStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::timeseriesinsights::v1::DataSet> ListDataSets(
      google::cloud::timeseriesinsights::v1::ListDataSetsRequest request)
      override;

  StatusOr<google::cloud::timeseriesinsights::v1::DataSet> CreateDataSet(
      google::cloud::timeseriesinsights::v1::CreateDataSetRequest const&
          request) override;

  Status DeleteDataSet(
      google::cloud::timeseriesinsights::v1::DeleteDataSetRequest const&
          request) override;

  StatusOr<google::cloud::timeseriesinsights::v1::AppendEventsResponse>
  AppendEvents(google::cloud::timeseriesinsights::v1::AppendEventsRequest const&
                   request) override;

  StatusOr<google::cloud::timeseriesinsights::v1::QueryDataSetResponse>
  QueryDataSet(google::cloud::timeseriesinsights::v1::QueryDataSetRequest const&
                   request) override;

  StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice> EvaluateSlice(
      google::cloud::timeseriesinsights::v1::EvaluateSliceRequest const&
          request) override;

  StatusOr<google::cloud::timeseriesinsights::v1::EvaluatedSlice>
  EvaluateTimeseries(
      google::cloud::timeseriesinsights::v1::EvaluateTimeseriesRequest const&
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      timeseriesinsights_v1_internal::TimeseriesInsightsControllerStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace timeseriesinsights_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TIMESERIESINSIGHTS_V1_INTERNAL_TIMESERIES_INSIGHTS_CONTROLLER_CONNECTION_IMPL_H
