// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/case_service.proto

#include "google/cloud/support/v2/internal/case_connection_impl.h"
#include "google/cloud/support/v2/internal/case_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace support_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<support_v2::CaseServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<support_v2::CaseServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<support_v2::CaseServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<support_v2::CaseServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<support_v2::CaseServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

CaseServiceConnectionImpl::CaseServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<support_v2_internal::CaseServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      CaseServiceConnection::options())) {}

StatusOr<google::cloud::support::v2::Case> CaseServiceConnectionImpl::GetCase(
    google::cloud::support::v2::GetCaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetCase(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::support::v2::GetCaseRequest const& request) {
        return stub_->GetCase(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::support::v2::Case>
CaseServiceConnectionImpl::ListCases(
    google::cloud::support::v2::ListCasesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCases(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::support::v2::Case>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<support_v2::CaseServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::support::v2::ListCasesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::support::v2::ListCasesRequest const& request) {
              return stub->ListCases(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::support::v2::ListCasesResponse r) {
        std::vector<google::cloud::support::v2::Case> result(r.cases().size());
        auto& messages = *r.mutable_cases();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::support::v2::Case>
CaseServiceConnectionImpl::SearchCases(
    google::cloud::support::v2::SearchCasesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchCases(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::support::v2::Case>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<support_v2::CaseServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::support::v2::SearchCasesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::support::v2::SearchCasesRequest const& request) {
              return stub->SearchCases(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::support::v2::SearchCasesResponse r) {
        std::vector<google::cloud::support::v2::Case> result(r.cases().size());
        auto& messages = *r.mutable_cases();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::support::v2::Case>
CaseServiceConnectionImpl::CreateCase(
    google::cloud::support::v2::CreateCaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateCase(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::support::v2::CreateCaseRequest const& request) {
        return stub_->CreateCase(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::support::v2::Case>
CaseServiceConnectionImpl::UpdateCase(
    google::cloud::support::v2::UpdateCaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateCase(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::support::v2::UpdateCaseRequest const& request) {
        return stub_->UpdateCase(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::support::v2::Case>
CaseServiceConnectionImpl::EscalateCase(
    google::cloud::support::v2::EscalateCaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->EscalateCase(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::support::v2::EscalateCaseRequest const& request) {
        return stub_->EscalateCase(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceConnectionImpl::CloseCase(
    google::cloud::support::v2::CloseCaseRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CloseCase(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::support::v2::CloseCaseRequest const& request) {
        return stub_->CloseCase(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::support::v2::CaseClassification>
CaseServiceConnectionImpl::SearchCaseClassifications(
    google::cloud::support::v2::SearchCaseClassificationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->SearchCaseClassifications(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::support::v2::CaseClassification>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<support_v2::CaseServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::support::v2::SearchCaseClassificationsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::support::v2::
                       SearchCaseClassificationsRequest const& request) {
              return stub->SearchCaseClassifications(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::support::v2::SearchCaseClassificationsResponse r) {
        std::vector<google::cloud::support::v2::CaseClassification> result(
            r.case_classifications().size());
        auto& messages = *r.mutable_case_classifications();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2_internal
}  // namespace cloud
}  // namespace google
