// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#include "google/cloud/storagecontrol/v2/storage_control_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storagecontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

StorageControlClient::StorageControlClient(
    std::shared_ptr<StorageControlConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
StorageControlClient::~StorageControlClient() = default;

StatusOr<google::storage::control::v2::Folder>
StorageControlClient::CreateFolder(
    std::string const& parent,
    google::storage::control::v2::Folder const& folder,
    std::string const& folder_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::CreateFolderRequest request;
  request.set_parent(parent);
  *request.mutable_folder() = folder;
  request.set_folder_id(folder_id);
  return connection_->CreateFolder(request);
}

StatusOr<google::storage::control::v2::Folder>
StorageControlClient::CreateFolder(
    google::storage::control::v2::CreateFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFolder(request);
}

Status StorageControlClient::DeleteFolder(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::DeleteFolderRequest request;
  request.set_name(name);
  return connection_->DeleteFolder(request);
}

Status StorageControlClient::DeleteFolder(
    google::storage::control::v2::DeleteFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFolder(request);
}

StatusOr<google::storage::control::v2::Folder> StorageControlClient::GetFolder(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::GetFolderRequest request;
  request.set_name(name);
  return connection_->GetFolder(request);
}

StatusOr<google::storage::control::v2::Folder> StorageControlClient::GetFolder(
    google::storage::control::v2::GetFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFolder(request);
}

StreamRange<google::storage::control::v2::Folder>
StorageControlClient::ListFolders(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::ListFoldersRequest request;
  request.set_parent(parent);
  return connection_->ListFolders(request);
}

StreamRange<google::storage::control::v2::Folder>
StorageControlClient::ListFolders(
    google::storage::control::v2::ListFoldersRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFolders(std::move(request));
}

future<StatusOr<google::storage::control::v2::Folder>>
StorageControlClient::RenameFolder(std::string const& name,
                                   std::string const& destination_folder_id,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::RenameFolderRequest request;
  request.set_name(name);
  request.set_destination_folder_id(destination_folder_id);
  return connection_->RenameFolder(request);
}

StatusOr<google::longrunning::Operation> StorageControlClient::RenameFolder(
    NoAwaitTag, std::string const& name,
    std::string const& destination_folder_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::RenameFolderRequest request;
  request.set_name(name);
  request.set_destination_folder_id(destination_folder_id);
  return connection_->RenameFolder(NoAwaitTag{}, request);
}

future<StatusOr<google::storage::control::v2::Folder>>
StorageControlClient::RenameFolder(
    google::storage::control::v2::RenameFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RenameFolder(request);
}

StatusOr<google::longrunning::Operation> StorageControlClient::RenameFolder(
    NoAwaitTag,
    google::storage::control::v2::RenameFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RenameFolder(NoAwaitTag{}, request);
}

future<StatusOr<google::storage::control::v2::Folder>>
StorageControlClient::RenameFolder(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RenameFolder(operation);
}

StatusOr<google::storage::control::v2::StorageLayout>
StorageControlClient::GetStorageLayout(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::GetStorageLayoutRequest request;
  request.set_name(name);
  return connection_->GetStorageLayout(request);
}

StatusOr<google::storage::control::v2::StorageLayout>
StorageControlClient::GetStorageLayout(
    google::storage::control::v2::GetStorageLayoutRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetStorageLayout(request);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlClient::CreateManagedFolder(
    std::string const& parent,
    google::storage::control::v2::ManagedFolder const& managed_folder,
    std::string const& managed_folder_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::CreateManagedFolderRequest request;
  request.set_parent(parent);
  *request.mutable_managed_folder() = managed_folder;
  request.set_managed_folder_id(managed_folder_id);
  return connection_->CreateManagedFolder(request);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlClient::CreateManagedFolder(
    google::storage::control::v2::CreateManagedFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagedFolder(request);
}

Status StorageControlClient::DeleteManagedFolder(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::DeleteManagedFolderRequest request;
  request.set_name(name);
  return connection_->DeleteManagedFolder(request);
}

Status StorageControlClient::DeleteManagedFolder(
    google::storage::control::v2::DeleteManagedFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagedFolder(request);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlClient::GetManagedFolder(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::GetManagedFolderRequest request;
  request.set_name(name);
  return connection_->GetManagedFolder(request);
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlClient::GetManagedFolder(
    google::storage::control::v2::GetManagedFolderRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetManagedFolder(request);
}

StreamRange<google::storage::control::v2::ManagedFolder>
StorageControlClient::ListManagedFolders(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::storage::control::v2::ListManagedFoldersRequest request;
  request.set_parent(parent);
  return connection_->ListManagedFolders(request);
}

StreamRange<google::storage::control::v2::ManagedFolder>
StorageControlClient::ListManagedFolders(
    google::storage::control::v2::ListManagedFoldersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListManagedFolders(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2
}  // namespace cloud
}  // namespace google
