// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

#include "google/cloud/spanner/admin/database_admin_client.h"
#include "google/cloud/spanner/admin/database_admin_options.h"
#include <memory>
#include <thread>
#include <utility>

namespace google {
namespace cloud {
namespace spanner_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatabaseAdminClient::DatabaseAdminClient(
    std::shared_ptr<DatabaseAdminConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DatabaseAdminClient::~DatabaseAdminClient() = default;

StreamRange<google::spanner::admin::database::v1::Database>
DatabaseAdminClient::ListDatabases(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListDatabasesRequest request;
  request.set_parent(parent);
  return connection_->ListDatabases(request);
}

StreamRange<google::spanner::admin::database::v1::Database>
DatabaseAdminClient::ListDatabases(
    google::spanner::admin::database::v1::ListDatabasesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatabases(std::move(request));
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::CreateDatabase(std::string const& parent,
                                    std::string const& create_statement,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CreateDatabaseRequest request;
  request.set_parent(parent);
  request.set_create_statement(create_statement);
  return connection_->CreateDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CreateDatabase(
    NoAwaitTag, std::string const& parent, std::string const& create_statement,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CreateDatabaseRequest request;
  request.set_parent(parent);
  request.set_create_statement(create_statement);
  return connection_->CreateDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::CreateDatabase(
    google::spanner::admin::database::v1::CreateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CreateDatabase(
    NoAwaitTag,
    google::spanner::admin::database::v1::CreateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::CreateDatabase(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDatabase(operation);
}

StatusOr<google::spanner::admin::database::v1::Database>
DatabaseAdminClient::GetDatabase(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::GetDatabaseRequest request;
  request.set_name(name);
  return connection_->GetDatabase(request);
}

StatusOr<google::spanner::admin::database::v1::Database>
DatabaseAdminClient::GetDatabase(
    google::spanner::admin::database::v1::GetDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDatabase(request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::UpdateDatabase(
    google::spanner::admin::database::v1::Database const& database,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateDatabaseRequest request;
  *request.mutable_database() = database;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::UpdateDatabase(
    NoAwaitTag, google::spanner::admin::database::v1::Database const& database,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateDatabaseRequest request;
  *request.mutable_database() = database;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::UpdateDatabase(
    google::spanner::admin::database::v1::UpdateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::UpdateDatabase(
    NoAwaitTag,
    google::spanner::admin::database::v1::UpdateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::UpdateDatabase(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabase(operation);
}

future<
    StatusOr<google::spanner::admin::database::v1::UpdateDatabaseDdlMetadata>>
DatabaseAdminClient::UpdateDatabaseDdl(
    std::string const& database, std::vector<std::string> const& statements,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateDatabaseDdlRequest request;
  request.set_database(database);
  *request.mutable_statements() = {statements.begin(), statements.end()};
  return connection_->UpdateDatabaseDdl(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::UpdateDatabaseDdl(
    NoAwaitTag, std::string const& database,
    std::vector<std::string> const& statements, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateDatabaseDdlRequest request;
  request.set_database(database);
  *request.mutable_statements() = {statements.begin(), statements.end()};
  return connection_->UpdateDatabaseDdl(NoAwaitTag{}, request);
}

future<
    StatusOr<google::spanner::admin::database::v1::UpdateDatabaseDdlMetadata>>
DatabaseAdminClient::UpdateDatabaseDdl(
    google::spanner::admin::database::v1::UpdateDatabaseDdlRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabaseDdl(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::UpdateDatabaseDdl(
    NoAwaitTag,
    google::spanner::admin::database::v1::UpdateDatabaseDdlRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabaseDdl(NoAwaitTag{}, request);
}

future<
    StatusOr<google::spanner::admin::database::v1::UpdateDatabaseDdlMetadata>>
DatabaseAdminClient::UpdateDatabaseDdl(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabaseDdl(operation);
}

Status DatabaseAdminClient::DropDatabase(std::string const& database,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::DropDatabaseRequest request;
  request.set_database(database);
  return connection_->DropDatabase(request);
}

Status DatabaseAdminClient::DropDatabase(
    google::spanner::admin::database::v1::DropDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DropDatabase(request);
}

StatusOr<google::spanner::admin::database::v1::GetDatabaseDdlResponse>
DatabaseAdminClient::GetDatabaseDdl(std::string const& database, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::GetDatabaseDdlRequest request;
  request.set_database(database);
  return connection_->GetDatabaseDdl(request);
}

StatusOr<google::spanner::admin::database::v1::GetDatabaseDdlResponse>
DatabaseAdminClient::GetDatabaseDdl(
    google::spanner::admin::database::v1::GetDatabaseDdlRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDatabaseDdl(request);
}

StatusOr<google::iam::v1::Policy> DatabaseAdminClient::SetIamPolicy(
    std::string const& resource, google::iam::v1::Policy const& policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::SetIamPolicyRequest request;
  request.set_resource(resource);
  *request.mutable_policy() = policy;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DatabaseAdminClient::SetIamPolicy(
    std::string const& resource, IamUpdater const& updater, Options opts) {
  internal::CheckExpectedOptions<DatabaseAdminBackoffPolicyOption>(opts,
                                                                   __func__);
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest get_request;
  get_request.set_resource(resource);
  google::iam::v1::SetIamPolicyRequest set_request;
  set_request.set_resource(resource);
  auto backoff_policy =
      internal::CurrentOptions().get<DatabaseAdminBackoffPolicyOption>();
  if (backoff_policy != nullptr) {
    backoff_policy = backoff_policy->clone();
  }
  for (;;) {
    auto recent = connection_->GetIamPolicy(get_request);
    if (!recent) {
      return recent.status();
    }
    auto policy = updater(*std::move(recent));
    if (!policy) {
      return internal::CancelledError(
          "updater did not yield a policy",
          GCP_ERROR_INFO().WithMetadata("gl-cpp.error.origin", "client"));
    }
    *set_request.mutable_policy() = *std::move(policy);
    auto result = connection_->SetIamPolicy(set_request);
    if (result || result.status().code() != StatusCode::kAborted ||
        backoff_policy == nullptr) {
      return result;
    }
    std::this_thread::sleep_for(backoff_policy->OnCompletion());
  }
}

StatusOr<google::iam::v1::Policy> DatabaseAdminClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DatabaseAdminClient::GetIamPolicy(
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest request;
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DatabaseAdminClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DatabaseAdminClient::TestIamPermissions(
    std::string const& resource, std::vector<std::string> const& permissions,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::TestIamPermissionsRequest request;
  request.set_resource(resource);
  *request.mutable_permissions() = {permissions.begin(), permissions.end()};
  return connection_->TestIamPermissions(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DatabaseAdminClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CreateBackup(
    std::string const& parent,
    google::spanner::admin::database::v1::Backup const& backup,
    std::string const& backup_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CreateBackupRequest request;
  request.set_parent(parent);
  *request.mutable_backup() = backup;
  request.set_backup_id(backup_id);
  return connection_->CreateBackup(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CreateBackup(
    NoAwaitTag, std::string const& parent,
    google::spanner::admin::database::v1::Backup const& backup,
    std::string const& backup_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CreateBackupRequest request;
  request.set_parent(parent);
  *request.mutable_backup() = backup;
  request.set_backup_id(backup_id);
  return connection_->CreateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CreateBackup(
    google::spanner::admin::database::v1::CreateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CreateBackup(
    NoAwaitTag,
    google::spanner::admin::database::v1::CreateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CreateBackup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(operation);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CopyBackup(std::string const& parent,
                                std::string const& backup_id,
                                std::string const& source_backup,
                                google::protobuf::Timestamp const& expire_time,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CopyBackupRequest request;
  request.set_parent(parent);
  request.set_backup_id(backup_id);
  request.set_source_backup(source_backup);
  *request.mutable_expire_time() = expire_time;
  return connection_->CopyBackup(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CopyBackup(
    NoAwaitTag, std::string const& parent, std::string const& backup_id,
    std::string const& source_backup,
    google::protobuf::Timestamp const& expire_time, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CopyBackupRequest request;
  request.set_parent(parent);
  request.set_backup_id(backup_id);
  request.set_source_backup(source_backup);
  *request.mutable_expire_time() = expire_time;
  return connection_->CopyBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CopyBackup(
    google::spanner::admin::database::v1::CopyBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CopyBackup(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::CopyBackup(
    NoAwaitTag,
    google::spanner::admin::database::v1::CopyBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CopyBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Backup>>
DatabaseAdminClient::CopyBackup(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CopyBackup(operation);
}

StatusOr<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::GetBackup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::GetBackupRequest request;
  request.set_name(name);
  return connection_->GetBackup(request);
}

StatusOr<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::GetBackup(
    google::spanner::admin::database::v1::GetBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackup(request);
}

StatusOr<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::UpdateBackup(
    google::spanner::admin::database::v1::Backup const& backup,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateBackupRequest request;
  *request.mutable_backup() = backup;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackup(request);
}

StatusOr<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::UpdateBackup(
    google::spanner::admin::database::v1::UpdateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackup(request);
}

Status DatabaseAdminClient::DeleteBackup(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::DeleteBackupRequest request;
  request.set_name(name);
  return connection_->DeleteBackup(request);
}

Status DatabaseAdminClient::DeleteBackup(
    google::spanner::admin::database::v1::DeleteBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackup(request);
}

StreamRange<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::ListBackups(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListBackupsRequest request;
  request.set_parent(parent);
  return connection_->ListBackups(request);
}

StreamRange<google::spanner::admin::database::v1::Backup>
DatabaseAdminClient::ListBackups(
    google::spanner::admin::database::v1::ListBackupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackups(std::move(request));
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::RestoreDatabase(std::string const& parent,
                                     std::string const& database_id,
                                     std::string const& backup, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::RestoreDatabaseRequest request;
  request.set_parent(parent);
  request.set_database_id(database_id);
  request.set_backup(backup);
  return connection_->RestoreDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::RestoreDatabase(
    NoAwaitTag, std::string const& parent, std::string const& database_id,
    std::string const& backup, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::RestoreDatabaseRequest request;
  request.set_parent(parent);
  request.set_database_id(database_id);
  request.set_backup(backup);
  return connection_->RestoreDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::RestoreDatabase(
    google::spanner::admin::database::v1::RestoreDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreDatabase(request);
}

StatusOr<google::longrunning::Operation> DatabaseAdminClient::RestoreDatabase(
    NoAwaitTag,
    google::spanner::admin::database::v1::RestoreDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreDatabase(NoAwaitTag{}, request);
}

future<StatusOr<google::spanner::admin::database::v1::Database>>
DatabaseAdminClient::RestoreDatabase(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreDatabase(operation);
}

StreamRange<google::longrunning::Operation>
DatabaseAdminClient::ListDatabaseOperations(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListDatabaseOperationsRequest request;
  request.set_parent(parent);
  return connection_->ListDatabaseOperations(request);
}

StreamRange<google::longrunning::Operation>
DatabaseAdminClient::ListDatabaseOperations(
    google::spanner::admin::database::v1::ListDatabaseOperationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatabaseOperations(std::move(request));
}

StreamRange<google::longrunning::Operation>
DatabaseAdminClient::ListBackupOperations(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListBackupOperationsRequest request;
  request.set_parent(parent);
  return connection_->ListBackupOperations(request);
}

StreamRange<google::longrunning::Operation>
DatabaseAdminClient::ListBackupOperations(
    google::spanner::admin::database::v1::ListBackupOperationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackupOperations(std::move(request));
}

StreamRange<google::spanner::admin::database::v1::DatabaseRole>
DatabaseAdminClient::ListDatabaseRoles(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListDatabaseRolesRequest request;
  request.set_parent(parent);
  return connection_->ListDatabaseRoles(request);
}

StreamRange<google::spanner::admin::database::v1::DatabaseRole>
DatabaseAdminClient::ListDatabaseRoles(
    google::spanner::admin::database::v1::ListDatabaseRolesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatabaseRoles(std::move(request));
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::CreateBackupSchedule(
    std::string const& parent,
    google::spanner::admin::database::v1::BackupSchedule const& backup_schedule,
    std::string const& backup_schedule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::CreateBackupScheduleRequest request;
  request.set_parent(parent);
  *request.mutable_backup_schedule() = backup_schedule;
  request.set_backup_schedule_id(backup_schedule_id);
  return connection_->CreateBackupSchedule(request);
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::CreateBackupSchedule(
    google::spanner::admin::database::v1::CreateBackupScheduleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackupSchedule(request);
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::GetBackupSchedule(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::GetBackupScheduleRequest request;
  request.set_name(name);
  return connection_->GetBackupSchedule(request);
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::GetBackupSchedule(
    google::spanner::admin::database::v1::GetBackupScheduleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackupSchedule(request);
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::UpdateBackupSchedule(
    google::spanner::admin::database::v1::BackupSchedule const& backup_schedule,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::UpdateBackupScheduleRequest request;
  *request.mutable_backup_schedule() = backup_schedule;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackupSchedule(request);
}

StatusOr<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::UpdateBackupSchedule(
    google::spanner::admin::database::v1::UpdateBackupScheduleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackupSchedule(request);
}

Status DatabaseAdminClient::DeleteBackupSchedule(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::DeleteBackupScheduleRequest request;
  request.set_name(name);
  return connection_->DeleteBackupSchedule(request);
}

Status DatabaseAdminClient::DeleteBackupSchedule(
    google::spanner::admin::database::v1::DeleteBackupScheduleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackupSchedule(request);
}

StreamRange<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::ListBackupSchedules(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::spanner::admin::database::v1::ListBackupSchedulesRequest request;
  request.set_parent(parent);
  return connection_->ListBackupSchedules(request);
}

StreamRange<google::spanner::admin::database::v1::BackupSchedule>
DatabaseAdminClient::ListBackupSchedules(
    google::spanner::admin::database::v1::ListBackupSchedulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackupSchedules(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace spanner_admin
}  // namespace cloud
}  // namespace google
