// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/servicemanagement/v1/servicemanager.proto

#include "google/cloud/servicemanagement/v1/internal/service_manager_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/api/servicemanagement/v1/servicemanager.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace servicemanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceManagerMetadata::ServiceManagerMetadata(
    std::shared_ptr<ServiceManagerStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::api::servicemanagement::v1::ListServicesResponse>
ServiceManagerMetadata::ListServices(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::ListServicesRequest const& request) {
  SetMetadata(context, options);
  return child_->ListServices(context, options, request);
}

StatusOr<google::api::servicemanagement::v1::ManagedService>
ServiceManagerMetadata::GetService(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::GetServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->GetService(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncCreateService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::api::servicemanagement::v1::CreateServiceRequest const& request) {
  SetMetadata(*context, *options);
  return child_->AsyncCreateService(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> ServiceManagerMetadata::CreateService(
    grpc::ClientContext& context, Options options,
    google::api::servicemanagement::v1::CreateServiceRequest const& request) {
  SetMetadata(context, options);
  return child_->CreateService(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncDeleteService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::api::servicemanagement::v1::DeleteServiceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->AsyncDeleteService(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> ServiceManagerMetadata::DeleteService(
    grpc::ClientContext& context, Options options,
    google::api::servicemanagement::v1::DeleteServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->DeleteService(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncUndeleteService(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::api::servicemanagement::v1::UndeleteServiceRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->AsyncUndeleteService(cq, std::move(context),
                                      std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ServiceManagerMetadata::UndeleteService(
    grpc::ClientContext& context, Options options,
    google::api::servicemanagement::v1::UndeleteServiceRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->UndeleteService(context, options, request);
}

StatusOr<google::api::servicemanagement::v1::ListServiceConfigsResponse>
ServiceManagerMetadata::ListServiceConfigs(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::ListServiceConfigsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->ListServiceConfigs(context, options, request);
}

StatusOr<google::api::Service> ServiceManagerMetadata::GetServiceConfig(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::GetServiceConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat(
                  "service_name=", internal::UrlEncode(request.service_name()),
                  "&", "config_id=", internal::UrlEncode(request.config_id())));
  return child_->GetServiceConfig(context, options, request);
}

StatusOr<google::api::Service> ServiceManagerMetadata::CreateServiceConfig(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::CreateServiceConfigRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->CreateServiceConfig(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncSubmitConfigSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->AsyncSubmitConfigSource(cq, std::move(context),
                                         std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ServiceManagerMetadata::SubmitConfigSource(
    grpc::ClientContext& context, Options options,
    google::api::servicemanagement::v1::SubmitConfigSourceRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->SubmitConfigSource(context, options, request);
}

StatusOr<google::api::servicemanagement::v1::ListServiceRolloutsResponse>
ServiceManagerMetadata::ListServiceRollouts(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::ListServiceRolloutsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->ListServiceRollouts(context, options, request);
}

StatusOr<google::api::servicemanagement::v1::Rollout>
ServiceManagerMetadata::GetServiceRollout(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::GetServiceRolloutRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("service_name=", internal::UrlEncode(request.service_name()),
                   "&",
                   "rollout_id=", internal::UrlEncode(request.rollout_id())));
  return child_->GetServiceRollout(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncCreateServiceRollout(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->AsyncCreateServiceRollout(cq, std::move(context),
                                           std::move(options), request);
}

StatusOr<google::longrunning::Operation>
ServiceManagerMetadata::CreateServiceRollout(
    grpc::ClientContext& context, Options options,
    google::api::servicemanagement::v1::CreateServiceRolloutRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("service_name=",
                           internal::UrlEncode(request.service_name())));
  return child_->CreateServiceRollout(context, options, request);
}

StatusOr<google::api::servicemanagement::v1::GenerateConfigReportResponse>
ServiceManagerMetadata::GenerateConfigReport(
    grpc::ClientContext& context, Options const& options,
    google::api::servicemanagement::v1::GenerateConfigReportRequest const&
        request) {
  SetMetadata(context, options);
  return child_->GenerateConfigReport(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
ServiceManagerMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> ServiceManagerMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void ServiceManagerMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void ServiceManagerMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicemanagement_v1_internal
}  // namespace cloud
}  // namespace google
