// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#include "google/cloud/servicehealth/v1/service_health_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace servicehealth_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ServiceHealthClient::ServiceHealthClient(
    std::shared_ptr<ServiceHealthConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ServiceHealthClient::~ServiceHealthClient() = default;

StreamRange<google::cloud::servicehealth::v1::Event>
ServiceHealthClient::ListEvents(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::ListEventsRequest request;
  request.set_parent(parent);
  return connection_->ListEvents(request);
}

StreamRange<google::cloud::servicehealth::v1::Event>
ServiceHealthClient::ListEvents(
    google::cloud::servicehealth::v1::ListEventsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEvents(std::move(request));
}

StatusOr<google::cloud::servicehealth::v1::Event> ServiceHealthClient::GetEvent(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::GetEventRequest request;
  request.set_name(name);
  return connection_->GetEvent(request);
}

StatusOr<google::cloud::servicehealth::v1::Event> ServiceHealthClient::GetEvent(
    google::cloud::servicehealth::v1::GetEventRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEvent(request);
}

StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthClient::ListOrganizationEvents(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::ListOrganizationEventsRequest request;
  request.set_parent(parent);
  return connection_->ListOrganizationEvents(request);
}

StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthClient::ListOrganizationEvents(
    google::cloud::servicehealth::v1::ListOrganizationEventsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOrganizationEvents(std::move(request));
}

StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthClient::GetOrganizationEvent(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::GetOrganizationEventRequest request;
  request.set_name(name);
  return connection_->GetOrganizationEvent(request);
}

StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
ServiceHealthClient::GetOrganizationEvent(
    google::cloud::servicehealth::v1::GetOrganizationEventRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOrganizationEvent(request);
}

StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthClient::ListOrganizationImpacts(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::ListOrganizationImpactsRequest request;
  request.set_parent(parent);
  return connection_->ListOrganizationImpacts(request);
}

StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthClient::ListOrganizationImpacts(
    google::cloud::servicehealth::v1::ListOrganizationImpactsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOrganizationImpacts(std::move(request));
}

StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthClient::GetOrganizationImpact(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::servicehealth::v1::GetOrganizationImpactRequest request;
  request.set_name(name);
  return connection_->GetOrganizationImpact(request);
}

StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
ServiceHealthClient::GetOrganizationImpact(
    google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOrganizationImpact(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1
}  // namespace cloud
}  // namespace google
